/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.messageCenter.server.dao;

import com.kingdee.messageCenter.IClientManagerDAO;
import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.web.context.ContextLoader;

public class ClientManagerDAO
implements IClientManagerDAO {
    private static final String TABLE_NAME = "T_MCT_ClientSetting";
    private static final String DATA_TYPE_SECRETKEY = "SECRETKEY";
    private static final String DATA_TYPE_WORKER = "WORKER";
    private JdbcTemplate jdbcTemplate = null;

    protected JdbcTemplate getJdbcTemplate() {
        if (this.jdbcTemplate == null) {
            this.jdbcTemplate = (JdbcTemplate)ContextLoader.getCurrentWebApplicationContext().getBean("jdbcTemplate", JdbcTemplate.class);
        }
        return this.jdbcTemplate;
    }

    @Override
    public String getSecretKey(String clientId) {
        String sql = "select FValue from T_MCT_ClientSetting where FDataType = ? and FKey = ? ";
        return (String)this.getJdbcTemplate().queryForObject(sql, new Object[]{DATA_TYPE_SECRETKEY, clientId}, String.class);
    }

    @Override
    public String getClientId() {
        return null;
    }

    @Override
    public String getServerUrl() {
        return null;
    }

    @Override
    public boolean isProxy() {
        return false;
    }

    @Override
    public String getProxyHost() {
        return null;
    }

    @Override
    public String getProxyPort() {
        return null;
    }

    @Override
    public Map<String, String> getWorkerSetting() {
        String sql = "select FKey,FValue from T_MCT_ClientSetting where FDataType = ? ";
        SqlRowSet rs = this.getJdbcTemplate().queryForRowSet(sql, new Object[]{DATA_TYPE_WORKER}, new int[]{12});
        HashMap<String, String> workerMap = new HashMap<String, String>();
        String subject = null;
        String workerClassName = null;
        while (rs.next()) {
            subject = rs.getString("FKey");
            workerClassName = rs.getString("FValue");
            workerMap.put(subject, workerClassName);
        }
        return workerMap;
    }
}

