/*
 * Decompiled with CFR 0.152.
 */
package nl.justobjects.pushlet.core;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nl.justobjects.pushlet.core.Protocol;
import nl.justobjects.pushlet.util.Sys;

public class Event
implements Protocol,
Serializable {
    private static final long serialVersionUID = -2892756401636456762L;
    public static final String MESSAGE_ID = "MESSAGEID";
    public static final String ENTERPRISE_ID = "ENTERPRISEID";
    protected Map<String, String> attributes = new HashMap<String, String>();

    public Event(String anEventType) {
        this(anEventType, null);
    }

    public Event(String anEventType, Map<String, String> theAttributes) {
        if (theAttributes != null) {
            this.setAttrs(theAttributes);
        }
        this.setField("p_event", anEventType);
        this.setField("p_time", System.currentTimeMillis() / 1000L);
    }

    public Event(Map<String, String> theAttributes) {
        if (!theAttributes.containsKey("p_event")) {
            throw new IllegalArgumentException("p_event not found in attributes");
        }
        this.setAttrs(theAttributes);
    }

    public static Event createDataEvent(String aSubject) {
        return Event.createDataEvent(aSubject, null);
    }

    public static Event createDataEvent(String aSubject, Map<String, String> theAttributes) {
        Event dataEvent = new Event("data", theAttributes);
        dataEvent.setField("p_subject", aSubject);
        return dataEvent;
    }

    public String getEventType() {
        return this.getField("p_event");
    }

    public String getSubject() {
        return this.getField("p_subject");
    }

    public void setField(String name, String value) {
        this.attributes.put(name, value);
    }

    public void setField(String name, int value) {
        this.attributes.put(name, value + "");
    }

    public void setField(String name, long value) {
        this.attributes.put(name, value + "");
    }

    public String getField(String name) {
        return this.attributes.get(name);
    }

    public String getField(String name, String aDefault) {
        String result = this.getField(name);
        return result == null ? aDefault : result;
    }

    public Iterator<String> getFieldNames() {
        return this.attributes.keySet().iterator();
    }

    public String toString() {
        return this.attributes.toString();
    }

    public String toQueryString() {
        String queryString = "";
        String amp = "";
        Iterator<String> iter = this.getFieldNames();
        while (iter.hasNext()) {
            String nextAttrName = iter.next();
            String nextAttrValue = this.getField(nextAttrName);
            queryString = queryString + amp + nextAttrName + "=" + nextAttrValue;
            amp = "&";
        }
        return queryString;
    }

    public String toXML(boolean strict) {
        String xmlString = "<event ";
        Iterator<String> iter = this.getFieldNames();
        while (iter.hasNext()) {
            String nextAttrName = iter.next();
            String nextAttrValue = null;
            try {
                nextAttrValue = URLEncoder.encode(this.getField(nextAttrName), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            xmlString = xmlString + nextAttrName + "=\"" + (strict ? Sys.forHTMLTag(nextAttrValue) : nextAttrValue) + "\" ";
        }
        xmlString = xmlString + "/>";
        return xmlString;
    }

    public String toXML() {
        return this.toXML(false);
    }

    public Object clone() {
        return new Event(this.attributes);
    }

    private void setAttrs(Map<String, String> theAttributes) {
        this.attributes.putAll(theAttributes);
    }

    public Map<String, String> getAttrs() {
        return this.attributes;
    }

    public String getMessageId() {
        return this.getField(MESSAGE_ID);
    }
}

