/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.netctrl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.base.netctrl.app.AbstractMutexServiceControlFacadeControllerBean;
import com.kingdee.eas.base.netctrl.app.MutexService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MutexServiceControlFacadeControllerBean
extends AbstractMutexServiceControlFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.netctrl.app.MutexServiceControlFacadeControllerBean");
    private static final long serialVersionUID = -180741064776864946L;

    public String getLockUpdateInformation(Context ctx, String id) throws BOSException {
        if (id == null) {
            return "";
        }
        if (id.trim().length() == 0) {
            return "";
        }
        String lockUserName = "";
        ObjectUpdateLock objectUpdateLock = this.getObjectUpdateLock(ctx, id);
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(BOSUuid.read((String)id).getType());
        String entityAlias = entityObjectInfo == null ? "\u5bf9\u8c61" : (entityObjectInfo.getAlias() == null ? (entityObjectInfo.getName() == null ? "\u5bf9\u8c61" : entityObjectInfo.getName()) : entityObjectInfo.getAlias());
        DataTableInfo dataTableInfo = entityObjectInfo == null ? null : entityObjectInfo.getTable();
        String tableName = dataTableInfo == null ? null : dataTableInfo.getName();
        String fieldName = null;
        String data = null;
        if (dataTableInfo != null) {
            if (dataTableInfo.getColumnByName("FNumber") != null) {
                fieldName = "FNumber";
            } else if (dataTableInfo.getColumnByName("FName") != null) {
                fieldName = "FName";
            }
        }
        if (fieldName != null && tableName != null) {
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append(fieldName).append(" \"").append(fieldName).append("\"\r\n");
            sql.append("From ").append(tableName).append("\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And FID='").append(id).append("'\r\n");
            try {
                IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rowset.next()) {
                    data = rowset.getString(fieldName) == null ? "" : "[" + rowset.getString(fieldName) + "]";
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        if (data == null) {
            data = id;
        }
        if (objectUpdateLock != null) {
            lockUserName = "[" + objectUpdateLock.getUserName() + "]";
        }
        StringBuffer message = new StringBuffer();
        message.setLength(0);
        message.append("{0} {1} \u5df2\u88ab\u7528\u6237 {2} \u64cd\u4f5c\u9501\u5b9a\r\n");
        Object[] objs = new Object[]{entityAlias, data, lockUserName};
        return MessageFormat.format(message.toString(), objs);
    }

    public ObjectUpdateLock getObjectUpdateLock(Context ctx, String id) throws BOSException {
        String key;
        if (id == null) {
            return null;
        }
        if (id.trim().length() == 0) {
            return null;
        }
        HashMap mutexMap = MutexService.getInstanceOfObjId().getObjIDForUpdateList(ctx);
        if (mutexMap.containsKey(key = id + ctx.getAIS())) {
            ObjectUpdateLock objectUpdateLock = (ObjectUpdateLock)mutexMap.get(key);
            return objectUpdateLock;
        }
        return null;
    }

    @Override
    protected void _batchRequestObjIDForUpdate(Context ctx, List idList) throws BOSException, EASBizException {
        Map lockResult = MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(idList);
        if (lockResult != null) {
            for (int index = 0; index < idList.size(); ++index) {
                String id;
                Object idObject = idList.get(index);
                if (idObject == null || idObject.toString().trim().length() == 0 || !lockResult.containsKey(id = idObject.toString())) continue;
                Object resultObject = lockResult.get(id);
                if (!Boolean.class.getName().equals(resultObject.getClass().getName())) continue;
                Boolean result = Boolean.parseBoolean(resultObject.toString());
                if (result.booleanValue()) {
                    logger.info((Object)("Locked Object : " + id + "\r\n"));
                    continue;
                }
                throw new EASBizException(new NumericExceptionSubItem("Locked Object Failed", this.getLockUpdateInformation(ctx, id)));
            }
        }
    }
}

