/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.clientUtil;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class DateUtil {
    public static boolean equals(Date o1, Date o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.compareTo(o2) == 0;
    }

    public static boolean equals(Date o1, Date o2, String formate) {
        SimpleDateFormat sdf = null;
        try {
            sdf = new SimpleDateFormat(formate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (o1 == null || o2 == null || sdf == null) {
            return DateUtil.equals(o1, o2);
        }
        String os1 = sdf.format(o1);
        String os2 = sdf.format(o2);
        return DateUtil.isEq(os1, os2);
    }

    public static boolean equalsDate(Date o1, Date o2) {
        return DateUtil.equals(o1, o2, "YYYY-MM-DD");
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private static boolean isEq(String s1, String s2) {
        if (DateUtil.isEmpty(s1)) {
            return DateUtil.isEmpty(s2);
        }
        return s1.equals(s2);
    }

    public static int conpareToDate(String date1, String date2) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Date dt1 = df.parse(date1);
            Date dt2 = df.parse(date2);
            long t1 = dt1.getTime();
            long t2 = dt2.getTime();
            long c = t2 - t1;
            if (c == 0L) {
                return 0;
            }
            BigDecimal tc = new BigDecimal(c + "");
            tc = tc.divide(new BigDecimal(86400000), RoundingMode.HALF_UP);
            return tc.intValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
    }
}

