/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;

public class EmmUtils {
    public static String getSqlFromCollection(Collection coll) {
        StringBuffer sqlBuffer = new StringBuffer();
        if (coll != null && coll.size() > 0) {
            String[] keys = coll.toArray(new String[coll.size()]);
            for (int i = 0; i < keys.length; ++i) {
                sqlBuffer.append("'" + keys[i].trim() + "'");
                if (i >= keys.length - 1) continue;
                sqlBuffer.append(",");
            }
        }
        return sqlBuffer.toString();
    }

    public static String getSqlFromCollection(Collection coll, String alias) {
        StringBuffer sqlBuffer = new StringBuffer();
        if (coll != null && coll.size() > 0) {
            String[] keys = coll.toArray(new String[coll.size()]);
            if (coll.size() > 1000) {
                sqlBuffer.append("(");
            }
            sqlBuffer.append(alias + " in (");
            int count = 0;
            for (int i = 0; i < keys.length; ++i) {
                if (++count % 1000 == 0) {
                    sqlBuffer.append(" or " + alias + " in (");
                }
                sqlBuffer.append("'" + keys[i].trim() + "'");
                if (count % 1000 != 0) {
                    sqlBuffer.append(",");
                }
                if (count % 1000 != 0) continue;
                sqlBuffer.append(" )");
            }
            sqlBuffer.append(" )");
        }
        return sqlBuffer.toString();
    }

    public static String getSqlFromArray(String[] ss) {
        StringBuffer sqlBuffer = new StringBuffer();
        if (ss != null && ss.length > 0) {
            String[] keys = ss;
            for (int i = 0; i < keys.length; ++i) {
                sqlBuffer.append("'" + keys[i].trim() + "'");
                if (i >= keys.length - 1) continue;
                sqlBuffer.append(",");
            }
        }
        return sqlBuffer.toString();
    }

    public static int[] executeBatchUpdate(Context ctx, List<String> sqls) throws BOSException {
        int[] i2;
        if (sqls == null || sqls.size() == 0) {
            return null;
        }
        Connection con = null;
        Statement ps = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.createStatement();
            for (int i2 = 0; i2 < sqls.size(); ++i2) {
                ps.addBatch(sqls.get(i2));
            }
            i2 = ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException("sqlBatch execute exception : " + sqls.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        return i2;
    }
}

