/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.common.util;

import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.eas.mm.basedata.BooleanAllEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.enums.EnumUtils;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;

public final class MMUtils {
    public static final String[] BOOLEAN_ARRAY = new String[]{BooleanAllEnum.Yes.getAlias(), BooleanAllEnum.No.getAlias()};
    public static final String FORMAT = "yyyy-MM-dd";
    public static final String DISABLE_DATE = "2099-12-31";

    public static boolean checkExisted(String[] array, String value) {
        if (MMUtils.isEmptyString(value)) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!value.trim().equals(array[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean checkExisted(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyString(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isPositiveInteger(String number) {
        Pattern pattern = Pattern.compile("^\\+?[1-9][0-9]*$");
        Matcher matcher = pattern.matcher(number);
        return matcher.find();
    }

    public static boolean isNotEmptyString(String value) {
        return !MMUtils.isEmptyString(value);
    }

    public static String dateToString(Date date, String format) {
        if (date == null || MMUtils.isEmptyString(format)) {
            return null;
        }
        SimpleDateFormat dateFormater = new SimpleDateFormat(format);
        return dateFormater.format(date);
    }

    public static Date stringToDate(String date, String format) throws ParseException {
        SimpleDateFormat dateFormater = new SimpleDateFormat(format);
        return dateFormater.parse(date);
    }

    public static boolean isNumber(String number) {
        Pattern pattern = Pattern.compile("^(-?\\d+)(\\.\\d+)?$");
        Matcher matcher = pattern.matcher(number);
        return matcher.find();
    }

    public static String setToString(Set valueSet) {
        StringBuffer returnValue = new StringBuffer("(");
        if (valueSet != null && valueSet.size() != 0) {
            Iterator it = valueSet.iterator();
            boolean flag = false;
            String tempValue = null;
            Object obj = null;
            while (it.hasNext()) {
                obj = it.next();
                tempValue = obj instanceof String ? (String)obj : obj.toString();
                if (MMUtils.isEmptyString(tempValue)) continue;
                if (flag) {
                    returnValue.append(",");
                }
                returnValue.append("'");
                returnValue.append(tempValue);
                returnValue.append("'");
                flag = true;
            }
        } else {
            returnValue.append("'null'");
        }
        returnValue.append(")");
        return returnValue.toString();
    }

    public static String getResourceWithParam(String msg, Object[] params) {
        MessageFormat format = new MessageFormat(msg);
        return format.format(params);
    }

    public static String getResourceWithParam(String resource, String key, Locale local, String[] params) {
        String message = ResourceBase.getString((String)resource, (String)key, (Locale)local);
        return MMUtils.getResourceWithParam(message, params);
    }

    public static String setToString(Set valueSet, String compart) {
        if (valueSet == null || valueSet.size() == 0) {
            return "";
        }
        StringBuffer returnValue = new StringBuffer();
        Iterator it = valueSet.iterator();
        boolean flag = false;
        while (it.hasNext()) {
            if (flag) {
                returnValue.append(compart);
            }
            returnValue.append(it.next());
            flag = true;
        }
        return returnValue.toString();
    }

    public static void hideProvideTypeEnumForKDComboBox(KDTable table, String columnKey) {
        try {
            KDComboBox comboBox = new KDComboBox();
            comboBox.setName("comboBox");
            comboBox.setVisible(true);
            Class<?> enumClass = Class.forName("com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum");
            comboBox.addItems(EnumUtils.getEnumList(enumClass).toArray());
            comboBox.removeItem((Object)EnumUtils.getEnum(enumClass, (String)"SPANORGPROVIDE"));
            KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)comboBox);
            table.getColumn(columnKey).setEditor((ICellEditor)cellEditor);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static boolean isSameStringValue(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }
}

