/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.mobile;

import com.kingdee.eas.industry.mobile.ConnectionWrapper;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class ConnectionPool {
    private static LinkedList m_notUsedConnection = new LinkedList();
    private static HashSet m_usedUsedConnection = new HashSet();
    private static String m_url = "";
    private static String m_user = "";
    private static String m_password = "";
    private static String m_driverName = "org.mariadb.jdbc.Driver";
    static final boolean DEBUG = true;
    private static long m_lastClearClosedConnection = System.currentTimeMillis();
    public static long CHECK_CLOSED_CONNECTION_TIME = 14400000L;

    private ConnectionPool() {
    }

    private static void initDriver() {
        Driver driver = null;
        try {
            driver = (Driver)Class.forName(m_driverName).newInstance();
            ConnectionPool.installDriver(driver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void installDriver(Driver driver) {
        try {
            DriverManager.registerDriver(driver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized Connection getConnection() {
        ConnectionPool.clearClosedConnection();
        while (m_notUsedConnection.size() > 0) {
            try {
                ConnectionWrapper wrapper = (ConnectionWrapper)m_notUsedConnection.removeFirst();
                if (wrapper.connection.isClosed()) continue;
                m_usedUsedConnection.add(wrapper);
                wrapper.debugInfo = new Throwable("Connection initial statement");
                return wrapper.connection;
            }
            catch (Exception wrapper) {
            }
        }
        int newCount = ConnectionPool.getIncreasingConnectionCount();
        LinkedList<ConnectionWrapper> list = new LinkedList<ConnectionWrapper>();
        ConnectionWrapper wrapper = null;
        for (int i = 0; i < newCount; ++i) {
            wrapper = ConnectionPool.getNewConnection();
            if (wrapper == null) continue;
            list.add(wrapper);
        }
        if (list.size() == 0) {
            return null;
        }
        wrapper = (ConnectionWrapper)list.removeFirst();
        m_usedUsedConnection.add(wrapper);
        m_notUsedConnection.addAll(list);
        list.clear();
        return wrapper.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConnectionWrapper getNewConnection() {
        Connection con = null;
        try {
            ConnectionWrapper wrapper;
            con = DriverManager.getConnection(m_url, m_user, m_password);
            ConnectionWrapper connectionWrapper = wrapper = new ConnectionWrapper(con);
            return connectionWrapper;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static synchronized void pushConnectionBackToPool(ConnectionWrapper con) {
        boolean exist = m_usedUsedConnection.remove(con);
        if (exist) {
            m_notUsedConnection.addLast(con);
        }
    }

    public static int close() {
        int count = 0;
        Iterator iterator = m_notUsedConnection.iterator();
        while (iterator.hasNext()) {
            try {
                ((ConnectionWrapper)iterator.next()).close();
                ++count;
            }
            catch (Exception exception) {}
        }
        m_notUsedConnection.clear();
        iterator = m_usedUsedConnection.iterator();
        while (iterator.hasNext()) {
            try {
                ConnectionWrapper wrapper = (ConnectionWrapper)iterator.next();
                wrapper.close();
                wrapper.debugInfo.printStackTrace();
                ++count;
            }
            catch (Exception exception) {}
        }
        m_usedUsedConnection.clear();
        return count;
    }

    private static void clearClosedConnection() {
        long time = System.currentTimeMillis();
        if (time < m_lastClearClosedConnection) {
            time = m_lastClearClosedConnection;
            return;
        }
        if (time - m_lastClearClosedConnection < CHECK_CLOSED_CONNECTION_TIME) {
            return;
        }
        m_lastClearClosedConnection = time;
        Iterator iterator = m_notUsedConnection.iterator();
        while (iterator.hasNext()) {
            ConnectionWrapper wrapper = (ConnectionWrapper)iterator.next();
            try {
                if (!wrapper.connection.isClosed()) continue;
                iterator.remove();
            }
            catch (Exception e) {
                iterator.remove();
                System.out.println("connection is closed, this connection initial StackTrace");
                wrapper.debugInfo.printStackTrace();
            }
        }
        int decrease = ConnectionPool.getDecreasingConnectionCount();
        if (m_notUsedConnection.size() < decrease) {
            return;
        }
        while (decrease-- > 0) {
            ConnectionWrapper wrapper = (ConnectionWrapper)m_notUsedConnection.removeFirst();
            try {
                wrapper.connection.close();
            }
            catch (Exception exception) {}
        }
    }

    public static int getIncreasingConnectionCount() {
        int count = 1;
        int current = ConnectionPool.getConnectionCount();
        count = current / 4;
        if (count < 1) {
            count = 1;
        }
        return count;
    }

    public static int getDecreasingConnectionCount() {
        boolean count = false;
        int current = ConnectionPool.getConnectionCount();
        if (current < 10) {
            return 0;
        }
        return current / 3;
    }

    public static synchronized void printDebugMsg() {
        ConnectionPool.printDebugMsg(System.out);
    }

    public static synchronized void printDebugMsg(PrintStream out) {
        StringBuffer msg = new StringBuffer();
        msg.append("debug message in " + ConnectionPool.class.getName());
        msg.append("\r\n");
        msg.append("total count is connection pool: " + ConnectionPool.getConnectionCount());
        msg.append("\r\n");
        msg.append("not used connection count: " + ConnectionPool.getNotUsedConnectionCount());
        msg.append("\r\n");
        msg.append("used connection, count: " + ConnectionPool.getUsedConnectionCount());
        out.println(msg);
        for (ConnectionWrapper wrapper : m_usedUsedConnection) {
            wrapper.debugInfo.printStackTrace(out);
        }
        out.println();
    }

    public static synchronized int getNotUsedConnectionCount() {
        return m_notUsedConnection.size();
    }

    public static synchronized int getUsedConnectionCount() {
        return m_usedUsedConnection.size();
    }

    public static synchronized int getConnectionCount() {
        return m_notUsedConnection.size() + m_usedUsedConnection.size();
    }

    public static String getUrl() {
        return m_url;
    }

    public static void setUrl(String url) {
        if (url == null) {
            return;
        }
        m_url = url.trim();
    }

    public static String getUser() {
        return m_user;
    }

    public static void setUser(String user) {
        if (user == null) {
            return;
        }
        m_user = user.trim();
    }

    public static String getPassword() {
        return m_password;
    }

    public static void setPassword(String password) {
        if (password == null) {
            return;
        }
        m_password = password.trim();
    }

    static {
        ConnectionPool.initDriver();
    }
}

