/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.mobile;

import com.kingdee.eas.industry.mobile.ConnectionPool;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import org.mariadb.jdbc.MariaDbPooledConnection;

class ConnectionWrapper
implements InvocationHandler {
    private static final String CLOSE_METHOD_NAME = "close";
    public Connection connection = null;
    private Connection m_originConnection = null;
    public long lastAccessTime = System.currentTimeMillis();
    Throwable debugInfo = new Throwable("Connection initial statement");

    ConnectionWrapper(Connection con) {
        this.connection = (Connection)Proxy.newProxyInstance(con.getClass().getClassLoader(), MariaDbPooledConnection.class.getInterfaces(), (InvocationHandler)this);
        this.m_originConnection = con;
    }

    void close() throws SQLException {
        this.m_originConnection.close();
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object obj = null;
        if (CLOSE_METHOD_NAME.equals(m.getName())) {
            ConnectionPool.pushConnectionBackToPool(this);
        } else {
            obj = m.invoke((Object)this.m_originConnection, args);
        }
        this.lastAccessTime = System.currentTimeMillis();
        return obj;
    }
}

