/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.report.DefaultReportImp;
import com.kingdee.eas.base.report.DefaultTreeReportImp;
import com.kingdee.eas.base.report.IReport;
import com.kingdee.eas.base.report.IReportManager;
import com.kingdee.eas.base.report.IReportTree;
import com.kingdee.eas.base.report.LicensePermissionUtils;
import com.kingdee.eas.base.report.QueryAdapter;
import com.kingdee.eas.base.report.ReportException;
import com.kingdee.eas.base.report.ReportProperty;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;

public class ReportFactory {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IReport createReport(String reportID, Context ctx) throws BOSException, SQLException, ReportException, EASBizException, Exception {
        IReportManager reportFacade = ReportFactory.getReportManager(ctx);
        HashMap map = reportFacade.GetReportByID(reportID);
        boolean hasLicence = false;
        IReport report = null;
        IRowSet rs = (IRowSet)map.get("report");
        if (rs == null) throw new ReportException(ReportException.REPORT_NOT_EXISTS);
        rs.beforeFirst();
        rs.next();
        String reportClassName = rs.getString("FReportClassName");
        String reportSRVClassName = rs.getString("FReportSRVClassName");
        try {
            String filterUIName = rs.getString("FFilterPanelName");
            String reportName = rs.getString("FName");
            hasLicence = filterUIName != null && filterUIName.trim().length() > 0 ? ReportFactory.checkHasLicence(filterUIName, reportName) : true;
            if (ctx != null) {
                hasLicence = true;
            }
            if (!hasLicence) throw new ReportException(ReportException.REPORT_NO_LICENSE, new Object[]{reportClassName});
            String viewPermission = rs.getString("FViewPermission").trim();
            if (ctx != null) {
                System.out.println("\u9488\u5bf9Web Report \u589e\u52a0\u6743\u9650\u9879\u63a7\u5236\u5904\u7406\uff0c\u9488\u5bf9Web\u6682\u4e0d\u63a7\u5236");
                try {
                    if (!viewPermission.equals("")) {
                        LicensePermissionUtils.checkPermission(null, null, (String)viewPermission);
                    }
                }
                catch (Exception se) {
                    se.printStackTrace();
                }
            } else if (!viewPermission.equals("")) {
                LicensePermissionUtils.checkPermission(null, null, (String)viewPermission);
            }
            if (reportClassName.trim().length() == 0) {
                if (reportSRVClassName.length() <= 0) throw new ReportException(ReportException.REPORT_CREATE_FAIL, new Object[]{reportID});
                report = new DefaultReportImp();
            } else {
                report = (IReport)Class.forName(reportClassName).newInstance();
            }
            if (ctx != null) {
                report.setWebContext(ctx);
            }
            ReportProperty prop = report.getReportProperty();
            prop.readData(map);
            report.createListener();
            return report;
        }
        catch (InstantiationException e) {
            throw new ReportException(ReportException.REPORT_CREATE_FAIL, new Object[]{reportClassName});
        }
        catch (IllegalAccessException e) {
            throw new ReportException(ReportException.REPORT_CREATE_FAIL, new Object[]{reportClassName});
        }
        catch (ClassNotFoundException e) {
            throw new ReportException(ReportException.REPORT_CREATE_FAIL, new Object[]{reportClassName});
        }
        catch (PermissionException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IReportTree createTreeReport(String reportID, Context ctx) throws BOSException, SQLException, ReportException, EASBizException, Exception {
        IReportManager reportFacade = ReportFactory.getReportManager(ctx);
        HashMap map = reportFacade.GetReportByID(reportID);
        IRowSet rs = (IRowSet)map.get("report");
        boolean hasLicence = false;
        IReportTree reportTree = null;
        if (rs == null) throw new ReportException(ReportException.REPORT_NOT_EXISTS);
        rs.beforeFirst();
        rs.next();
        String reportClassName = rs.getString("FReportClassName");
        String reportSRVClassName = rs.getString("FReportSRVClassName");
        try {
            String filterUIName = rs.getString("FFilterPanelName");
            String reportName = rs.getString("FName");
            hasLicence = ReportFactory.checkHasLicence(filterUIName, reportName);
            if (!hasLicence) throw new ReportException(ReportException.REPORT_NO_LICENSE, new Object[]{reportClassName});
            String viewPermission = rs.getString("FViewPermission").trim();
            if (!viewPermission.equals("")) {
                LicensePermissionUtils.checkPermission(null, null, (String)viewPermission);
            }
            if (reportClassName.trim().length() == 0) {
                if (reportSRVClassName.length() <= 0) throw new ReportException(ReportException.REPORT_CREATE_FAIL, new Object[]{reportID});
                reportTree = new DefaultTreeReportImp();
            } else {
                reportTree = (IReportTree)Class.forName(reportClassName).newInstance();
            }
            ReportProperty prop = reportTree.getReport().getReportProperty();
            prop.readData(map);
            reportTree.getReport().createListener();
            return reportTree;
        }
        catch (InstantiationException e) {
            throw new ReportException(ReportException.REPORT_CREATE_FAIL, new Object[]{reportClassName});
        }
        catch (IllegalAccessException e) {
            throw new ReportException(ReportException.REPORT_CREATE_FAIL, new Object[]{reportClassName});
        }
        catch (ClassNotFoundException e) {
            throw new ReportException(ReportException.REPORT_CREATE_FAIL, new Object[]{reportClassName});
        }
        catch (PermissionException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private static boolean checkHasLicence(String filterUIName, String reportName) throws SQLException, Exception {
        boolean hasLicence = false;
        if (filterUIName == null || filterUIName.trim().length() <= 0) {
            hasLicence = true;
        } else {
            String[] uiName = filterUIName.split(",");
            for (int i = 0; i < uiName.length && !(hasLicence = LicensePermissionUtils.checkLicence((String)uiName[i].toString(), (String)reportName)); ++i) {
            }
        }
        return hasLicence;
    }

    public static boolean releaseLicense1(String filterUIName) {
        boolean hasLicence = false;
        if (filterUIName != null && filterUIName.trim().length() > 0) {
            String[] uiName = filterUIName.split(",");
            for (int i = 0; i < uiName.length; ++i) {
                LicensePermissionUtils.releaseLicense((String)uiName[i].toString());
            }
        }
        return hasLicence;
    }

    public static IReport createQueryReport(String reportID, Context ctx, IMetaDataPK metaDataPK, String filterPanelName) throws BOSException, EASBizException, SQLException {
        IReportManager reportFacade = ReportFactory.getReportManager(ctx);
        HashMap map = reportFacade.getQeuryReportByID(reportID);
        QueryAdapter report = null;
        report = new QueryAdapter();
        ReportProperty prop = report.getReportProperty();
        prop.setMetaDataPK(metaDataPK);
        prop.setFilterPanelName(filterPanelName);
        prop.setVirtualMode(false);
        prop.setReportID(reportID);
        prop.setRsHeader((IRowSet)map.get("reportheader"));
        return report;
    }

    public static IReportManager getReportManager(Context ctx) throws BOSException {
        IReportManager reportFacade = null;
        reportFacade = ctx == null ? (IReportManager)BOSObjectFactory.createRemoteBOSObject((String)"com.kingdee.eas.base.report.app.ReportMananger", IReportManager.class) : (IReportManager)BOSObjectFactory.getLocalBOSObjectFactory((Context)ctx).createBOSObject("com.kingdee.eas.base.report.app.ReportMananger");
        return reportFacade;
    }

    public static void main(String[] args1) {
    }
}

