/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.update8;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesCollection;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.update8.AbstractMaterial8FacadeControllerBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class Material8FacadeControllerBean
extends AbstractMaterial8FacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.update8.Material8FacadeControllerBean");

    @Override
    protected MaterialPlanInfo _getPlanInfo(Context ctx, String matid, String ouid) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterinfo = this.getFilterOUMaterial(ctx, "orgUnit.id", ouid, "material.id", matid);
        viewInfo.setFilter(filterinfo);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("supplyOrgUnit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("supplyOrgUnit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("productUnit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("productUnit.name"));
        this.getPlanSelectors(viewInfo.getSelector());
        MaterialPlanCollection con = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            for (int i = 0; i < con.size(); ++i) {
                MaterialPlanInfo info = con.get(i);
                if (!info.getOrgUnit().getId().toString().equals(ouid)) continue;
                return info;
            }
            return con.get(0);
        }
        MaterialPlanInfo info = null;
        return info;
    }

    private FilterInfo getFilterOUMaterial(Context ctx, String OUIdFieldName, String OUID, String materialFieldname, String matid) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(materialFieldname, (Object)matid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(OUIdFieldName, (Object)OUID, CompareType.EQUALS));
        return filter;
    }

    private SelectorItemCollection getPlanSelectors(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("material.longNumber"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.shortName"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        return sic;
    }

    @Override
    protected MaterialCompanyInfoInfo _getCompanyInfo(Context ctx, String matid, String ouid) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterinfo = this.getFilterOUMaterial(ctx, "company.id", ouid, "mateial.id", matid);
        viewInfo.setFilter(filterinfo);
        this.getMCSelectors(viewInfo.getSelector());
        MaterialCompanyInfoCollection con = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            int i = 0;
            if (i < con.size()) {
                MaterialCompanyInfoInfo info = con.get(i);
                if (info.getCompany().getId().toString().equals(ouid)) {
                    // empty if block
                }
                return info;
            }
            return con.get(0);
        }
        MaterialCompanyInfoInfo info = null;
        return info;
    }

    public SelectorItemCollection getMCSelectors(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("KAClass.id"));
        sic.add(new SelectorItemInfo("KAClass.name"));
        sic.add(new SelectorItemInfo("KAClass.number"));
        sic.add(new SelectorItemInfo("standardCost"));
        sic.add(new SelectorItemInfo("accountType"));
        sic.add(new SelectorItemInfo("calculateType"));
        sic.add(new SelectorItemInfo("materialId"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("mateial.longNumber"));
        sic.add(new SelectorItemInfo("mateial.id"));
        sic.add(new SelectorItemInfo("mateial.name"));
        sic.add(new SelectorItemInfo("mateial.number"));
        sic.add(new SelectorItemInfo("mateial.shortName"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("status"));
        return sic;
    }

    @Override
    protected MaterialInventoryInfo _getInventoryInfo(Context ctx, String matid, String ouid) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterinfo = this.getFilterOUMaterial(ctx, "orgUnit.id", ouid, "material.id", matid);
        viewInfo.setFilter(filterinfo);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.hasLocation"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.whman.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.whman.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.whman.name"));
        this.getInventorySelectors(viewInfo.getSelector());
        MaterialInventoryCollection con = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            for (int i = 0; i < con.size(); ++i) {
                MaterialInventoryInfo info = con.get(i);
                if (!info.getOrgUnit().getId().toString().equals(ouid)) continue;
                return info;
            }
            return con.get(0);
        }
        MaterialInventoryInfo info = null;
        return info;
    }

    private SelectorItemCollection getInventorySelectors(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("material.longNumber"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.shortName"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("isControl"));
        sic.add(new SelectorItemInfo("qtySafety"));
        sic.add(new SelectorItemInfo("qtyMin"));
        sic.add(new SelectorItemInfo("qtyMax"));
        sic.add(new SelectorItemInfo("daysBottom"));
        sic.add(new SelectorItemInfo("daysTop"));
        sic.add(new SelectorItemInfo("daysTurnover"));
        sic.add(new SelectorItemInfo("isNegative"));
        sic.add(new SelectorItemInfo("isBatchNo"));
        sic.add(new SelectorItemInfo("isSequenceNo"));
        sic.add(new SelectorItemInfo("isLotNumber"));
        sic.add(new SelectorItemInfo("isBarcode"));
        sic.add(new SelectorItemInfo("qtyMinPackage"));
        sic.add(new SelectorItemInfo("abcType"));
        sic.add(new SelectorItemInfo("isCompages"));
        sic.add(new SelectorItemInfo("issuePriorityMode"));
        sic.add(new SelectorItemInfo("isPeriodValid"));
        sic.add(new SelectorItemInfo("periodValid"));
        sic.add(new SelectorItemInfo("periodValidUnit"));
        sic.add(new SelectorItemInfo("inWarehsAhead"));
        sic.add(new SelectorItemInfo("outWarehsAhead"));
        sic.add(new SelectorItemInfo("prepWarnAhead"));
        sic.add(new SelectorItemInfo("aheadUnit"));
        return sic;
    }

    @Override
    protected MaterialPurchasingInfo _getPurchasingInfo(Context ctx, String matid, String ouid) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterinfo = this.getFilterOUMaterial(ctx, "orgUnit.id", ouid, "material.id", matid);
        viewInfo.setFilter(filterinfo);
        this.getPurchasingSelectors(viewInfo.getSelector());
        MaterialPurchasingCollection con = MaterialPurchasingFactory.getLocalInstance((Context)ctx).getMaterialPurchasingCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            int i = 0;
            if (i < con.size()) {
                MaterialPurchasingInfo info = con.get(i);
                if (info.getOrgUnit().getId().toString().equals(ouid)) {
                    // empty if block
                }
                return info;
            }
            return con.get(0);
        }
        MaterialPurchasingInfo info = null;
        return info;
    }

    private SelectorItemCollection getPurchasingSelectors(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.longNumber"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.shortName"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("purPerson.id"));
        sic.add(new SelectorItemInfo("purPerson.number"));
        sic.add(new SelectorItemInfo("purPerson.name"));
        sic.add(new SelectorItemInfo("purGroup.number"));
        sic.add(new SelectorItemInfo("purGroup.name"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("appointPurOrgUnit.id"));
        sic.add(new SelectorItemInfo("appointPurOrgUnit.name"));
        sic.add(new SelectorItemInfo("appointPurOrgUnit.number"));
        return sic;
    }

    @Override
    protected MaterialSalesInfo _getSalesInfo(Context ctx, String matid, String ouid) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterinfo = this.getFilterOUMaterial(ctx, "orgUnit.id", ouid, "material.id", matid);
        viewInfo.setFilter(filterinfo);
        this.getSalesSelectors(viewInfo.getSelector());
        MaterialSalesCollection con = MaterialSalesFactory.getLocalInstance((Context)ctx).getMaterialSalesCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            int i = 0;
            if (i < con.size()) {
                MaterialSalesInfo info = con.get(i);
                if (info.getOrgUnit().getId().toString().equals(ouid)) {
                    // empty if block
                }
                return info;
            }
            return con.get(0);
        }
        MaterialSalesInfo info = null;
        return info;
    }

    private SelectorItemCollection getSalesSelectors(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("material.longNumber"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.shortName"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("taxData.id"));
        sic.add(new SelectorItemInfo("taxData.number"));
        sic.add(new SelectorItemInfo("taxData.name"));
        sic.add(new SelectorItemInfo("price"));
        sic.add(new SelectorItemInfo("isReturn"));
        sic.add(new SelectorItemInfo("isnotCheckOnReturn"));
        sic.add(new SelectorItemInfo("isReceivByCheck"));
        sic.add(new SelectorItemInfo("issueTopRatio"));
        sic.add(new SelectorItemInfo("issueBottomRatio"));
        sic.add(new SelectorItemInfo("daydAhead"));
        sic.add(new SelectorItemInfo("daysDelay"));
        sic.add(new SelectorItemInfo("lowerQuantity"));
        sic.add(new SelectorItemInfo("taxRate"));
        sic.add(new SelectorItemInfo("abcType"));
        sic.add(new SelectorItemInfo("isPurBySale"));
        return sic;
    }

    @Override
    protected List _getMaterialsExistInvInfo(Context ctx, String[] materialIDs, String inventoryID) throws BOSException {
        StringBuffer sqlStringBuffer = new StringBuffer();
        int size = materialIDs.length;
        if (size < 1) {
            return null;
        }
        sqlStringBuffer.append(" (material ='" + materialIDs[0] + "' And orgUnit = '" + inventoryID + "')  And status =1 ");
        for (int index = 1; index < size; ++index) {
            sqlStringBuffer.append(" or ");
            sqlStringBuffer.append(" (material ='" + materialIDs[index] + "' And orgUnit ='" + inventoryID + "')  And status =1 ");
        }
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx);
        MaterialInventoryCollection collection = iMaterialInventory.getMaterialInventoryCollection("Where" + sqlStringBuffer.toString());
        ArrayList<String> arrayList = new ArrayList<String>();
        int collectionSize = collection.size();
        for (int i = 0; i < collectionSize; ++i) {
            arrayList.add(collection.get(i).getMaterial().getId().toString());
        }
        return arrayList;
    }

    @Override
    protected HashMap _verifyMaterialInvInfos(Context ctx, HashMap hashMap) throws BOSException {
        HashMap<String, List> resultMap = new HashMap<String, List>();
        if (hashMap != null) {
            Set keySet = hashMap.keySet();
            Object[] keyArray = keySet.toArray();
            int size = keyArray.length;
            for (int index = 0; index < size; ++index) {
                String storageID = (String)keyArray[index];
                List materialIDList = (List)hashMap.get(storageID);
                List resultList = null;
                if (materialIDList == null || (resultList = this._getMaterialsExistInvInfo(ctx, materialIDList.toArray(new String[materialIDList.size()]), storageID)) == null) continue;
                resultMap.put(storageID, resultList);
            }
        }
        return resultMap;
    }
}

