/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.enums.Enum;
import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JTextField;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class IndustryUtils {
    public static final Calendar calendar = Calendar.getInstance();
    public static final Date currDate = new Date();
    public static final Timestamp currTime = new Timestamp(System.currentTimeMillis());
    public static final long dayTime = 86400000L;
    public static final String[] editUIDefaultKDTableActions = new String[]{"AddRow", "RemoveRow", "Delete", "Cut", "Paste", "Undo", "Redo"};
    public static final long hourTime = 3600000L;
    public static final long minuteTime = 60000L;
    public static final SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss");
    public static final long secondTime = 1000L;

    public static void addActionsServices(ItemAction[] actions, IBindService[] services) {
        if (IndustryUtils.isEmptyArray(actions) || IndustryUtils.isEmptyArray(services)) {
            return;
        }
        for (ItemAction action : actions) {
            if (action == null) continue;
            for (IBindService service : services) {
                action.addService(service);
            }
        }
    }

    public static void addColumnF7Listener(IColumn column, String f7Name, PreChangeListener preChangeListener, SelectorListener selectorListener, DataChangeListener dataChangeListener) throws Exception {
        KDBizPromptBox f7Editor;
        Component component;
        if (column == null) {
            return;
        }
        ICellEditor editor = column.getEditor();
        Component component2 = component = editor == null ? null : editor.getComponent();
        KDBizPromptBox kDBizPromptBox = component == null ? null : (f7Editor = component instanceof KDBizPromptBox ? (KDBizPromptBox)component : null);
        if (f7Editor != null) {
            if (!IndustryUtils.isEmptyString(f7Name)) {
                f7Editor.setName(f7Name);
            }
            if (preChangeListener != null) {
                f7Editor.addPreChangeListener(preChangeListener);
            }
            if (selectorListener != null) {
                f7Editor.addSelectorListener(selectorListener);
            }
            if (dataChangeListener != null) {
                f7Editor.addDataChangeListener(dataChangeListener);
            }
        }
    }

    public static String checkColumnUsage(String[] ens, ICoreBase[] icbs, List idList, String propAlias, String[] props, Map propMap) throws EASBizException, BOSException {
        StringBuilder errorMessages = new StringBuilder();
        try {
            StringBuilder sql = new StringBuilder();
            if (IndustryUtils.isEmptyArray(ens) || IndustryUtils.isEmptyArray(icbs) || IndustryUtils.isEmptyArray(props) || IndustryUtils.isEmptyString(propAlias)) {
                return null;
            }
            int ensLength = ens.length;
            int icbsLength = icbs.length;
            int propsLength = props.length;
            if (ensLength != icbsLength || ensLength != propsLength) {
                return null;
            }
            errorMessages.setLength(0);
            for (int index = 0; index < ensLength; ++index) {
                int ocSize;
                String en = ens[index];
                ICoreBase icb = icbs[index];
                String prop = props[index];
                if (IndustryUtils.isEmptyString(en) || icb == null || IndustryUtils.isEmptyList(idList) || IndustryUtils.isEmptyString(prop) || IndustryUtils.isEmptyMap(propMap)) continue;
                String propLastWord = prop.substring(prop.length() - 1);
                boolean isRelationProp = ".".equals(propLastWord);
                String propName = isRelationProp ? prop.substring(0, prop.length() - 1) : prop;
                sql.setLength(0);
                sql.append("Select ");
                sql.append("id, ");
                if (isRelationProp) {
                    sql.append(propName).append(".id ");
                    sql.append("Where ");
                    sql.append(propName).append(".id In ( ");
                } else {
                    sql.append(propName).append(" ");
                    sql.append("Where ");
                    sql.append(propName).append(" In ( ");
                }
                sql.append(SQLUtil.arrayToString((Object[])idList.toArray()));
                sql.append(") ");
                EntityViewInfo evi = new EntityViewInfo(sql.toString());
                evi.setBaseOnSelector(true);
                CoreBaseCollection oc = icb.getCollection(evi);
                int n = ocSize = IndustryUtils.isEmptyObjectCollection((IObjectCollection)oc) ? 0 : oc.size();
                if (ocSize == 0) continue;
                for (int ocIndex = 0; ocIndex < ocSize; ++ocIndex) {
                    String propNumber;
                    String tnID;
                    IObjectValue ov = oc.getObject(ocIndex);
                    if (IndustryUtils.isEmptyObjectValue(ov)) continue;
                    IObjectValue tnInfo = isRelationProp ? IndustryUtils.getObjectValueObjectValueData(ov, propName) : null;
                    String string = tnID = isRelationProp ? IndustryUtils.getObjectValueStringData(tnInfo, "id") : IndustryUtils.getObjectValueStringData(ov, propName);
                    if (IndustryUtils.isEmptyString(tnID) || IndustryUtils.isEmptyString(propNumber = IndustryUtils.getMapStringData(propMap, tnID, ""))) continue;
                    errorMessages.append("\u3010").append(propAlias).append("\u3011 ").append(propNumber).append(" \u5df2\u88ab\u3010").append(en).append("\u3011\u4f7f\u7528\r\n");
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return errorMessages.toString();
    }

    public static String checkKDTableRequiredColumn(KDTable table, String[] columns, boolean isReturnAllResult) throws Exception {
        if (table == null) {
            return null;
        }
        int tableRowCount = table.getRowCount();
        int tableColCount = table.getColumnCount();
        int tableHeadRowCount = table.getHeadRowCount();
        if (tableRowCount == 0 || tableColCount == 0 || tableHeadRowCount == 0) {
            return null;
        }
        ArrayList<String> reqColList = new ArrayList<String>();
        HashMap<String, String> reqColNameMap = new HashMap<String, String>();
        HashMap<String, Integer> reqColIndexMap = new HashMap<String, Integer>();
        IRow headRow = table.getHeadRow(0);
        if (IndustryUtils.isEmptyArray(columns)) {
            for (int index = 0; index < tableColCount; ++index) {
                boolean isRequired;
                ICell headCell = headRow.getCell(index);
                IColumn col = table.getColumn(index);
                if (col == null || headCell == null) continue;
                String colKey = col.getKey();
                Object colNameObject = headCell.getValue();
                String colName = colNameObject == null ? null : colNameObject.toString();
                int colIndex = col.getColumnIndex();
                if (IndustryUtils.isEmptyString(colKey) || colIndex < 0 || !(isRequired = col.isRequired())) continue;
                if (!reqColList.contains(colKey)) {
                    reqColList.add(colKey);
                }
                reqColNameMap.put(colKey, IndustryUtils.isEmptyString(colName) ? colKey : colName);
                reqColIndexMap.put(colKey, colIndex);
            }
        } else {
            for (String column : columns) {
                String colName;
                ICell headCell;
                int colIndex;
                IColumn col;
                if (IndustryUtils.isEmptyString(column) || (col = table.getColumn(column)) == null || (colIndex = col.getColumnIndex()) < 0 || (headCell = headRow.getCell(colIndex)) == null) continue;
                Object colNameObject = headCell.getValue();
                String string = colName = colNameObject == null ? null : colNameObject.toString();
                if (!reqColList.contains(column)) {
                    reqColList.add(column);
                }
                reqColNameMap.put(column, IndustryUtils.isEmptyString(colName) ? column : colName);
                reqColIndexMap.put(column, colIndex);
            }
        }
        if (IndustryUtils.isEmptyList(reqColList)) {
            return null;
        }
        if (IndustryUtils.isEmptyMap(reqColNameMap)) {
            return null;
        }
        if (IndustryUtils.isEmptyMap(reqColIndexMap)) {
            return null;
        }
        StringBuilder checkResult = new StringBuilder();
        int reqColCount = reqColList.size();
        table.getSelectManager().removeAll();
        checkResult.setLength(0);
        for (int rowIndex = 0; rowIndex < tableRowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex < reqColCount; ++colIndex) {
                Object reqColValueObject;
                String reqCol;
                Object reqColObject = reqColList.get(colIndex);
                String string = reqCol = reqColObject == null ? null : reqColObject.toString();
                if (IndustryUtils.isEmptyString(reqCol)) continue;
                int reqColIndex = IndustryUtils.getMapIntegerData(reqColIndexMap, reqCol);
                String reqColName = IndustryUtils.getMapStringData(reqColNameMap, reqCol);
                if (reqColIndex < 0 || (reqColValueObject = table.getCell(rowIndex, reqColIndex).getValue()) != null) continue;
                table.getSelectManager().add(rowIndex, reqColIndex, rowIndex, reqColIndex, 1);
                checkResult.append("\u7b2c" + (rowIndex + 1) + "\u884c\u7684\u3010" + reqColName + "\u3011\u4e0d\u80fd\u4e3a\u7a7a").append("\r\n");
                if (isReturnAllResult) continue;
                table.scrollToVisible(rowIndex, reqColIndex);
                return checkResult.toString();
            }
        }
        return checkResult.toString();
    }

    public static void checkNumber(Context ctx, IObjectCollection colls, ICoreBase bif) throws BOSException, EASBizException {
        if (ctx == null || colls == null || bif == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u7f16\u7801\u68c0\u6d4b\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        int size = colls.size();
        if (size == 0) {
            return;
        }
        ArrayList<String> numberList = new ArrayList<String>();
        FilterInfo fi = new FilterInfo();
        for (int index = 0; index < size; ++index) {
            IObjectValue model = colls.getObject(index);
            if (model == null) continue;
            String id = IndustryUtils.getObjectValueStringData(model, "id");
            String number = IndustryUtils.getObjectValueStringData(model, "number");
            if (IndustryUtils.isEmptyString(number)) {
                throw new EASBizException(new NumericExceptionSubItem("\u7f16\u7801\u68c0\u6d4b\u5931\u8d25", "\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            fi.getFilterItems().clear();
            if (!IndustryUtils.isEmptyString(id)) {
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
            }
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            if (bif.exists(fi)) {
                throw new EASBizException(new NumericExceptionSubItem("\u7f16\u7801\u68c0\u6d4b\u5931\u8d25", "\u7f16\u7801\u3010" + number + "\u3011\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728"));
            }
            if (numberList.contains(number)) {
                throw new EASBizException(new NumericExceptionSubItem("\u7f16\u7801\u68c0\u6d4b\u5931\u8d25", "\u7f16\u7801\u3010" + number + "\u3011\u51fa\u73b0\u91cd\u590d"));
            }
            numberList.add(number);
        }
    }

    public static void checkNumber(Context ctx, IObjectValue model, ICoreBase bif) throws BOSException, EASBizException {
        if (ctx == null || model == null || bif == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u7f16\u7801\u68c0\u6d4b\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        CoreBaseCollection colls = new CoreBaseCollection();
        colls.addObject(model);
        IndustryUtils.checkNumber(ctx, (IObjectCollection)colls, bif);
    }

    public static void checkPermission(String userID, List orgIDList, String permItem, IPermission ip) throws BOSException, EASBizException {
        if (IndustryUtils.isEmptyString(userID) || IndustryUtils.isEmptyList(orgIDList) || IndustryUtils.isEmptyString(permItem) || ip == null) {
            return;
        }
        ObjectUuidPK userPK = new ObjectUuidPK(userID);
        int orgIDListSize = orgIDList.size();
        for (int index = 0; index < orgIDListSize; ++index) {
            String orgID;
            Object orgIDObject = orgIDList.get(index);
            String string = orgID = orgIDObject == null ? null : orgIDObject.toString();
            if (IndustryUtils.isEmptyString(orgID)) continue;
            ObjectUuidPK orgPK = new ObjectUuidPK(orgID);
            ip.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permItem);
        }
    }

    public static void checkRef(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    public static void checkRef(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
    }

    public static void excelImportExport(Map params) throws Exception {
        HSSFWorkbook wb;
        if (IndustryUtils.isEmptyMap(params)) {
            throw new EASBizException(new NumericExceptionSubItem("Excel\u5bfc\u5165\u5bfc\u51fa\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        String action = IndustryUtils.getMapStringData(params, "Action");
        if (IndustryUtils.isEmptyString(action)) {
            throw new EASBizException(new NumericExceptionSubItem("Excel\u5bfc\u5165\u5bfc\u51fa\u5931\u8d25", "\u4f20\u9012\u7684Action\u53c2\u6570\u4e3a\u7a7a"));
        }
        if (!action.equals("ExcelImport") && !action.equals("ExcelExport")) {
            throw new EASBizException(new NumericExceptionSubItem("Excel\u5bfc\u5165\u5bfc\u51fa\u5931\u8d25", "\u4f20\u9012\u7684Action\u53c2\u6570\u65e0\u6548"));
        }
        String filePath = IndustryUtils.getMapStringData(params, "FilePath");
        if (IndustryUtils.isEmptyString(filePath)) {
            throw new EASBizException(new NumericExceptionSubItem("Excel\u5bfc\u5165\u5bfc\u51fa\u5931\u8d25", "\u4f20\u9012\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a"));
        }
        String fileType = GlobalFunction.getFileExtension((String)filePath);
        if (IndustryUtils.isEmptyString(fileType)) {
            throw new EASBizException(new NumericExceptionSubItem("Excel\u5bfc\u5165\u5bfc\u51fa\u5931\u8d25", "\u6587\u4ef6\u6ca1\u6709\u6269\u5c55\u540d"));
        }
        Object object = "xls".equalsIgnoreCase(fileType) ? (action.equals("ExcelExport") ? new HSSFWorkbook() : new HSSFWorkbook((InputStream)new FileInputStream(filePath))) : ("xlsx".equalsIgnoreCase(fileType) ? (action.equals("ExcelExport") ? new XSSFWorkbook() : new XSSFWorkbook(filePath)) : (wb = null));
        if (wb == null) {
            throw new EASBizException(new NumericExceptionSubItem("Excel\u5bfc\u5165\u5bfc\u51fa\u5931\u8d25", "\u4e0d\u652f\u6301" + fileType + "\u6587\u4ef6\u7c7b\u578b"));
        }
        IndustryUtils.getEntityObjectMap(params);
        String meoFullName = IndustryUtils.getMapStringData(params, "MainEntityObject");
        List eoList = IndustryUtils.getMapListData(params, "EntityObjectList");
        ArrayList<String> reoList = new ArrayList<String>();
        if (IndustryUtils.isEmptyString(meoFullName) || IndustryUtils.isEmptyList(eoList)) {
            wb.close();
            throw new EASBizException(new NumericExceptionSubItem("Excel\u5bfc\u5165\u5bfc\u51fa\u5931\u8d25", "\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53Map"));
        }
        int eoListSize = eoList.size();
        int meoIndex = eoList.indexOf(meoFullName);
        CellStyle cs = wb.createCellStyle();
        cs.setAlignment(HorizontalAlignment.CENTER);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        CreationHelper ch = wb.getCreationHelper();
        DataFormat df = ch.createDataFormat();
        CellStyle csdt = wb.createCellStyle();
        csdt.setDataFormat(df.getFormat("yyyy-MM-dd"));
        CellStyle css = wb.createCellStyle();
        css.setDataFormat(df.getFormat("@"));
        StringBuilder sb = new StringBuilder();
        for (int eoIndex = 0; eoIndex < eoListSize; ++eoIndex) {
            int cIndex;
            int sRowNum;
            Sheet s;
            Object newInfoObject;
            Map eoMap;
            String eoPKString;
            Object eoPK = eoList.get(eoIndex);
            if (eoPK == null || IndustryUtils.isEmptyString(eoPKString = eoPK.toString()) || IndustryUtils.isEmptyMap(eoMap = IndustryUtils.getMapMapData(params, eoPKString))) continue;
            String eoName = IndustryUtils.getMapStringData(eoMap, "Name");
            String eoFullName = IndustryUtils.getMapStringData(eoMap, "FullName");
            String eoIDColName = IndustryUtils.getMapStringData(eoMap, "IDColumnName");
            Object ovClassObject = IndustryUtils.getMapData(eoMap, "ObjectValueClass");
            Class ovClass = ovClassObject == null ? null : (ovClassObject instanceof Class ? (Class)ovClassObject : null);
            Object v1 = newInfoObject = ovClass == null ? null : ovClass.newInstance();
            IObjectValue newInfo = newInfoObject == null ? null : (newInfoObject instanceof IObjectValue ? (IObjectValue)newInfoObject : null);
            BOSObjectType eoBOSType = newInfo == null ? null : newInfo.getBOSType();
            List cList = IndustryUtils.getMapListData(eoMap, "ColumnList");
            Map dMap = IndustryUtils.getMapMapData(eoMap, "DataMap", new HashMap());
            IObjectCollection dColls = IndustryUtils.getMapObjectCollectionData(eoMap, "DataCollection", (IObjectCollection)new CoreBaseCollection());
            if (IndustryUtils.isEmptyString(eoName) || IndustryUtils.isEmptyString(eoFullName) || IndustryUtils.isEmptyString(eoIDColName) || IndustryUtils.isEmptyList(cList) || newInfo == null || eoBOSType == null) continue;
            int cListSize = cList.size();
            int dCollsSize = IndustryUtils.isEmptyObjectCollection(dColls) ? 0 : dColls.size();
            String eoAlias = IndustryUtils.getMapStringData(eoMap, "Alias");
            String sName = IndustryUtils.isEmptyString(eoAlias) ? eoName : eoAlias;
            Sheet sheet = s = action.equals("ExcelExport") ? wb.createSheet(sName) : wb.getSheet(sName);
            if (s == null) continue;
            int n = sRowNum = action.equals("ExcelImport") ? s.getLastRowNum() : 0;
            if (action.equals("ExcelImport") && sRowNum < 3) continue;
            int dSize = action.equals("ExcelImport") ? sRowNum - 2 : dCollsSize;
            Row rt = s.getRow(0) == null ? s.createRow(0) : s.getRow(0);
            Row ra = s.getRow(1) == null ? s.createRow(1) : s.getRow(1);
            Row rn = s.getRow(2) == null ? s.createRow(2) : s.getRow(2);
            rt.setHeight(Short.parseShort("800"));
            ra.setHeight(Short.parseShort("600"));
            rn.setHeight(Short.parseShort("600"));
            Cell ct = rt.getCell(0) == null ? rt.createCell(0) : rt.getCell(0);
            ct.setCellStyle(cs);
            ct.setCellValue(IndustryUtils.isEmptyString(eoAlias) ? eoFullName : eoAlias + "\r\n" + eoFullName);
            int cCount = 0;
            for (cIndex = 0; cIndex < cListSize; ++cIndex) {
                Object beInfoObject;
                Object eClassObject;
                Map reoDMap;
                Map reoMap;
                Map cMap;
                Object cMapObject = cList.get(cIndex);
                if (cMapObject == null) continue;
                Map map = cMap = cMapObject instanceof Map ? (Map)cMapObject : null;
                if (IndustryUtils.isEmptyMap(cMap)) continue;
                String cName = IndustryUtils.getMapStringData(cMap, "Name");
                String cAlias = IndustryUtils.getMapStringData(cMap, "Alias");
                Object dtObject = IndustryUtils.getMapData(cMap, "Type");
                DataType dt = dtObject instanceof DataType ? (DataType)dtObject : null;
                String reoFullName = IndustryUtils.getMapStringData(cMap, "EntityObject");
                Map map2 = IndustryUtils.isEmptyString(reoFullName) ? null : (reoMap = reoFullName.equals(eoFullName) ? eoMap : IndustryUtils.getMapMapData(params, reoFullName, new HashMap()));
                Map map3 = IndustryUtils.isEmptyString(reoFullName) ? null : (reoFullName.equals(eoFullName) ? dMap : (reoDMap = IndustryUtils.isEmptyMap(reoMap) ? null : IndustryUtils.getMapMapData(reoMap, "DataMap", new HashMap())));
                if (IndustryUtils.isEmptyString(cName) || dt == null || dt.equals((Object)DataType.OBJECTCOLLECTION)) continue;
                Object object2 = eClassObject = dt.equals((Object)DataType.ENUM) ? IndustryUtils.getMapData(cMap, "EnumClass") : null;
                Class eClass = eClassObject == null ? null : (eClassObject instanceof Class ? (Class)eClassObject : null);
                Object object3 = beInfoObject = dt.equals((Object)DataType.ENUM) ? IndustryUtils.getMapData(cMap, "BizEnumInfo") : null;
                BizEnumInfo beInfo = beInfoObject == null ? null : (beInfoObject instanceof BizEnumInfo ? (BizEnumInfo)beInfoObject : null);
                BizEnumValueType bet = beInfo == null ? null : beInfo.getDataType();
                BizEnumValueCollection bevColls = beInfo == null ? null : beInfo.getEnumValue();
                int bevCollsSize = IndustryUtils.isEmptyObjectCollection((IObjectCollection)bevColls) ? 0 : bevColls.size();
                Method beM = bet == null || eClass == null ? null : eClass.getMethod("getEnum", String.class);
                HashMap<String, String> cbeVAMap = new HashMap<String, String>();
                HashMap<String, String> cbeANMap = new HashMap<String, String>();
                Cell ca = ra.getCell(cCount) == null ? ra.createCell(cCount) : ra.getCell(cCount);
                Cell cn = rn.getCell(cCount) == null ? rn.createCell(cCount) : rn.getCell(cCount);
                ca.setCellStyle(cs);
                cn.setCellStyle(cs);
                sb.setLength(0);
                sb.append(IndustryUtils.isEmptyString(cAlias) ? cName : cAlias);
                if (bevCollsSize > 0) {
                    sb.append("\r\n\uff08 ");
                    for (int bevIndex = 0; bevIndex < bevCollsSize; ++bevIndex) {
                        BizEnumValueInfo bevInfo = bevColls.get(bevIndex);
                        if (bevInfo == null) continue;
                        String bevName = bevInfo.getName();
                        String bevAlias = bevInfo.getAlias();
                        Object bevValue = bevInfo.getValue();
                        if (IndustryUtils.isEmptyString(bevName) || bevValue == null) continue;
                        sb.append(IndustryUtils.isEmptyString(bevAlias) ? bevName : bevAlias).append(" ");
                        cbeVAMap.put(bevValue.toString(), IndustryUtils.isEmptyString(bevAlias) ? bevName : bevAlias);
                        cbeANMap.put(IndustryUtils.isEmptyString(bevAlias) ? bevName : bevAlias, bevName);
                    }
                    sb.append("\uff09");
                }
                ca.setCellValue(sb.toString());
                String cnValue = action.equals("ExcelImport") ? cn.getStringCellValue() : null;
                sb.setLength(0);
                sb.append(cName);
                if (dt.equals((Object)DataType.OBJECTVALUE)) {
                    sb.append(".number");
                }
                if (action.equals("ExcelImport") && (IndustryUtils.isEmptyString(cnValue) || !cnValue.equals(sb.toString()))) continue;
                cn.setCellValue(sb.toString());
                int dRowIndex = 3;
                for (int dIndex = 0; dIndex < dSize; ++dIndex) {
                    String vs;
                    IObjectValue dInfo = action.equals("ExcelExport") ? dColls.getObject(dIndex) : (dIndex < dCollsSize ? (dColls.getObject(dIndex) == null ? (IObjectValue)ObjectUtils.createCopy((Object)newInfo) : dColls.getObject(dIndex)) : (IObjectValue)ObjectUtils.createCopy((Object)newInfo));
                    String dID = IndustryUtils.getObjectValueStringData(dInfo, "id");
                    if (IndustryUtils.isEmptyString(dID) && action.equals("ExcelImport")) {
                        dInfo.put("id", (Object)BOSUuid.create((BOSObjectType)eoBOSType));
                        dInfo.put("isExcelImport", (Object)true);
                    }
                    Row rv = s.getRow(dRowIndex) == null ? s.createRow(dRowIndex) : s.getRow(dRowIndex);
                    Cell cv = rv.getCell(cCount) == null ? rv.createCell(cCount) : rv.getCell(cCount);
                    int cvt = cv.getCellType().getCode();
                    Object v = action.equals("ExcelImport") ? (cvt == CellType.BLANK.getCode() ? null : (cvt == CellType.STRING.getCode() ? cv.getStringCellValue() : (cvt == CellType.BOOLEAN.getCode() ? cv.getStringCellValue() : (cvt == CellType.NUMERIC.getCode() ? Double.valueOf(cv.getNumericCellValue()) : null)))) : IndustryUtils.getObjectValueData(dInfo, cName);
                    String string = vs = v == null ? null : v.toString();
                    if (action.equals("ExcelImport")) {
                        if (IndustryUtils.isEmptyString(vs)) {
                            ++dRowIndex;
                            continue;
                        }
                        if (eoIDColName.equals(cName) && !dMap.containsKey(vs)) {
                            dMap.put(vs, dInfo);
                        }
                        if (dt.equals((Object)DataType.STRING)) {
                            dInfo.put(cName, (Object)vs);
                            if (cName.equals("number") && !dMap.containsKey(vs)) {
                                dMap.put(vs, dInfo);
                            }
                        } else if (dt.equals((Object)DataType.OBJECTVALUE)) {
                            if (reoMap != null && !reoDMap.containsKey(vs)) {
                                reoDMap.put(vs, null);
                            }
                            dInfo.put(cName, (Object)vs);
                        } else if (dt.equals((Object)DataType.DECIMAL)) {
                            if (v instanceof String) {
                                dInfo.put(cName, (Object)new BigDecimal(vs));
                            } else if (v instanceof Double) {
                                dInfo.put(cName, (Object)BigDecimal.valueOf((Double)v));
                            }
                        } else if (dt.equals((Object)DataType.ENUM)) {
                            String bevName = IndustryUtils.isEmptyMap(cbeANMap) ? null : IndustryUtils.getMapStringData(cbeANMap, vs);
                            Object ve = IndustryUtils.isEmptyString(bevName) ? null : beM.invoke(null, bevName);
                            dInfo.put(cName, ve);
                        } else if (dt.equals((Object)DataType.INTEGER)) {
                            if (v instanceof String || v instanceof Double) {
                                dInfo.put(cName, (Object)new BigDecimal(vs).intValue());
                            }
                        } else if (dt.equals((Object)DataType.TIMESTAMP) || dt.equals((Object)DataType.DATE) || dt.equals((Object)DataType.TIME)) {
                            Date vd = cv.getDateCellValue();
                            if (vd != null) {
                                dInfo.put(cName, (Object)new Timestamp(vd.getTime()));
                            }
                        } else if (dt.equals((Object)DataType.BOOLEAN)) {
                            if (v instanceof Boolean) {
                                dInfo.put(cName, v);
                            } else if (v instanceof Double) {
                                dInfo.put(cName, (Object)Boolean.parseBoolean(String.valueOf(new BigDecimal(vs).intValue())));
                            } else if (v instanceof String) {
                                if (vs.equalsIgnoreCase("True") || vs.equalsIgnoreCase("\u662f")) {
                                    dInfo.put(cName, (Object)true);
                                } else if (vs.equalsIgnoreCase("False") || vs.equalsIgnoreCase("\u5426")) {
                                    dInfo.put(cName, (Object)false);
                                }
                            }
                        }
                        if (dIndex + 1 > dCollsSize) {
                            dColls.addObject(dInfo);
                            ++dCollsSize;
                        } else {
                            dColls.setObject(dIndex, dInfo);
                        }
                    } else if (dt.equals((Object)DataType.STRING) || dt.equals((Object)DataType.BOSUUID)) {
                        cv.setCellValue(vs);
                        cv.setCellStyle(css);
                    } else if (dt.equals((Object)DataType.OBJECTVALUE)) {
                        IObjectValue vInfo = v == null ? null : (v instanceof IObjectValue ? (IObjectValue)v : null);
                        String vInfoNumber = IndustryUtils.getObjectValueStringData(vInfo, "number");
                        cv.setCellValue(vInfoNumber);
                        cv.setCellStyle(css);
                    } else if (dt.equals((Object)DataType.DECIMAL)) {
                        BigDecimal vDec;
                        BigDecimal bigDecimal = v == null ? null : (vDec = v instanceof BigDecimal ? (BigDecimal)v : null);
                        if (IndustryUtils.isZeroBigDecimal(vDec)) {
                            cv.setCellValue(0.0);
                        } else {
                            cv.setCellValue(vDec.doubleValue());
                        }
                    } else if (dt.equals((Object)DataType.ENUM)) {
                        if (v instanceof Enum) {
                            cv.setCellValue(((Enum)v).getAlias());
                        } else {
                            String bevAlias = IndustryUtils.isEmptyMap(cbeVAMap) ? null : IndustryUtils.getMapStringData(cbeVAMap, vs);
                            cv.setCellValue(bevAlias);
                        }
                        cv.setCellStyle(css);
                    } else if (dt.equals((Object)DataType.INTEGER)) {
                        cv.setCellValue((double)(v == null ? null : (v instanceof Integer ? (Integer)v : null)).intValue());
                    } else if (dt.equals((Object)DataType.TIMESTAMP) || dt.equals((Object)DataType.DATE) || dt.equals((Object)DataType.TIME)) {
                        if (v instanceof Timestamp) {
                            cv.setCellValue(new Date(((Timestamp)v).getTime()));
                        } else if (v instanceof Date) {
                            cv.setCellValue((Date)v);
                        }
                        cv.setCellStyle(csdt);
                    } else if (dt.equals((Object)DataType.BOOLEAN)) {
                        if (v instanceof Boolean) {
                            if (((Boolean)v).booleanValue()) {
                                cv.setCellValue("\u662f");
                            } else {
                                cv.setCellValue("\u5426");
                            }
                        } else if (v instanceof Integer) {
                            cv.setCellValue(Boolean.valueOf(vs).booleanValue());
                        }
                    }
                    ++dRowIndex;
                }
                if (!IndustryUtils.isEmptyString(reoFullName) && reoMap != null) {
                    if (!IndustryUtils.isEmptyMap(reoDMap)) {
                        reoMap.put("DataMap", reoDMap);
                        if (!reoList.contains(reoFullName)) {
                            reoList.add(reoFullName);
                        }
                    }
                    params.put(reoFullName, reoMap);
                }
                ++cCount;
            }
            eoMap.put("DataCollection", dColls);
            eoMap.put("DataMap", dMap);
            params.put(eoFullName, eoMap);
            if (!IndustryUtils.isEmptyMap(dMap) && !reoList.contains(eoFullName)) {
                reoList.add(eoFullName);
            }
            if (!action.equals("ExcelExport")) continue;
            s.addMergedRegion(new CellRangeAddress(0, 0, 0, cCount - 1));
            for (cIndex = 0; cIndex < cCount; ++cIndex) {
                s.autoSizeColumn(cIndex);
            }
        }
        if (action.equals("ExcelImport") && !IndustryUtils.isEmptyList(reoList)) {
            int reoListSize = reoList.size();
            for (int reoIndex = 0; reoIndex < reoListSize; ++reoIndex) {
                ICoreBase reoBIF;
                Map reoMap;
                String reoPKString;
                Object reoPK = reoList.get(reoIndex);
                if (reoPK == null || IndustryUtils.isEmptyString(reoPKString = reoPK.toString()) || IndustryUtils.isEmptyMap(reoMap = IndustryUtils.getMapMapData(params, reoPKString))) continue;
                String reoIDColName = IndustryUtils.getMapStringData(reoMap, "IDColumnName");
                Map reoDMap = IndustryUtils.getMapMapData(reoMap, "DataMap");
                Set reoDIDSet = reoDMap == null ? null : reoDMap.keySet();
                Object reoBIFObject = IndustryUtils.getMapData(reoMap, "BizInterface");
                ICoreBase iCoreBase = reoBIFObject == null ? null : (reoBIF = reoBIFObject instanceof ICoreBase ? (ICoreBase)reoBIFObject : null);
                if (IndustryUtils.isEmptyString(reoIDColName) || IndustryUtils.isEmptySet(reoDIDSet) || reoBIF == null) continue;
                sb.setLength(0);
                sb.append("Select ");
                sb.append("id, ");
                sb.append(reoIDColName).append(" ");
                sb.append("Where ");
                sb.append(reoIDColName).append(" In ( ");
                sb.append(SQLUtil.arrayToString((Object[])reoDIDSet.toArray()));
                sb.append(" ) ");
                EntityViewInfo reoEVInfo = new EntityViewInfo(sb.toString());
                reoEVInfo.setBaseOnSelector(true);
                CoreBaseCollection reoDColls = reoBIF.getCollection(reoEVInfo);
                if (IndustryUtils.isEmptyObjectCollection((IObjectCollection)reoDColls)) continue;
                int reoDCollsSize = reoDColls.size();
                for (int reoDIndex = 0; reoDIndex < reoDCollsSize; ++reoDIndex) {
                    IObjectValue oreoDInfo;
                    String oID;
                    String id;
                    IObjectValue reoDInfo = reoDColls.getObject(reoDIndex);
                    if (reoDInfo == null || IndustryUtils.isEmptyString(id = IndustryUtils.getObjectValueStringData(reoDInfo, reoIDColName)) || !IndustryUtils.isEmptyString(oID = IndustryUtils.getObjectValueStringData(oreoDInfo = IndustryUtils.getMapObjectValueData(reoDMap, id), reoIDColName))) continue;
                    reoDMap.put(id, reoDInfo);
                }
                reoMap.put("DataMap", reoDMap);
                params.put(reoPKString, reoMap);
            }
            if (meoIndex + 1 < eoListSize) {
                eoList.remove(meoIndex);
                eoList.add(meoFullName);
            }
            for (int eoIndex = 0; eoIndex < eoListSize; ++eoIndex) {
                ICoreBase bif;
                Map eoMap;
                String eoPKString;
                Object eoPK = eoList.get(eoIndex);
                if (eoPK == null || IndustryUtils.isEmptyString(eoPKString = eoPK.toString()) || IndustryUtils.isEmptyMap(eoMap = IndustryUtils.getMapMapData(params, eoPKString))) continue;
                String eoName = IndustryUtils.getMapStringData(eoMap, "Name");
                String eoAlias = IndustryUtils.getMapStringData(eoMap, "Alias");
                String eoFullName = IndustryUtils.getMapStringData(eoMap, "FullName");
                List cList = IndustryUtils.getMapListData(eoMap, "ColumnList");
                String idColName = IndustryUtils.getMapStringData(eoMap, "IDColumnName");
                IObjectCollection dColls = IndustryUtils.getMapObjectCollectionData(eoMap, "DataCollection");
                Object bifObject = IndustryUtils.getMapData(eoMap, "BizInterface");
                ICoreBase iCoreBase = bifObject == null ? null : (bif = bifObject instanceof ICoreBase ? (ICoreBase)bifObject : null);
                if (IndustryUtils.isEmptyString(eoName) || IndustryUtils.isEmptyString(eoFullName) || IndustryUtils.isEmptyString(idColName) || IndustryUtils.isEmptyList(cList) || IndustryUtils.isEmptyObjectCollection(dColls)) continue;
                Map dMap = IndustryUtils.getMapMapData(eoMap, "DataMap");
                int cListSize = cList.size();
                int dCollsSize = dColls.size();
                for (int cIndex = 0; cIndex < cListSize; ++cIndex) {
                    int reoDCollsSize;
                    Map reoMap;
                    Map cMap;
                    Object cMapObject = cList.get(cIndex);
                    if (cMapObject == null) continue;
                    Map map = cMap = cMapObject instanceof Map ? (Map)cMapObject : null;
                    if (IndustryUtils.isEmptyMap(cMap)) continue;
                    String cName = IndustryUtils.getMapStringData(cMap, "Name");
                    String cAlias = IndustryUtils.getMapStringData(cMap, "Alias");
                    Object dtObject = IndustryUtils.getMapData(cMap, "Type");
                    DataType dt = dtObject instanceof DataType ? (DataType)dtObject : null;
                    String reoFullName = IndustryUtils.getMapStringData(cMap, "EntityObject");
                    String reopName = IndustryUtils.getMapStringData(cMap, "EntityObjectProperty");
                    Boolean expand = IndustryUtils.getMapBooleanData(cMap, "Expand", false);
                    if (IndustryUtils.isEmptyString(cName) || dt == null || IndustryUtils.isEmptyString(reoFullName) || IndustryUtils.isEmptyString(reopName)) continue;
                    Map map4 = reoMap = reoFullName.equals(eoFullName) ? eoMap : IndustryUtils.getMapMapData(params, reoFullName);
                    Map reoDMap = reoFullName.equals(eoFullName) ? dMap : (IndustryUtils.isEmptyMap(reoMap) ? null : IndustryUtils.getMapMapData(reoMap, "DataMap"));
                    IObjectCollection reoDColls = IndustryUtils.getMapObjectCollectionData(reoMap, "DataCollection");
                    int n = reoDCollsSize = IndustryUtils.isEmptyObjectCollection(reoDColls) ? 0 : reoDColls.size();
                    if (!dt.equals((Object)DataType.OBJECTCOLLECTION) && !dt.equals((Object)DataType.OBJECTVALUE)) continue;
                    for (int dIndex = 0; dIndex < dCollsSize; ++dIndex) {
                        IObjectValue dInfo = dColls.getObject(dIndex);
                        if (dInfo == null) continue;
                        String id = IndustryUtils.getObjectValueStringData(dInfo, idColName);
                        String vs = IndustryUtils.getObjectValueStringData(dInfo, cName);
                        if (IndustryUtils.isEmptyString(vs)) continue;
                        if (dt.equals((Object)DataType.OBJECTCOLLECTION) && expand.booleanValue() && reoDCollsSize > 0 && !IndustryUtils.isEmptyString(id)) {
                            IObjectCollection voc = IndustryUtils.getObjectValueObjectCollectionData(dInfo, cName, (IObjectCollection)new CoreBaseCollection());
                            for (int reoDIndex = 0; reoDIndex < reoDCollsSize; ++reoDIndex) {
                                String reovoID;
                                IObjectValue reovov;
                                IObjectValue reoDInfo = reoDColls.getObject(reoDIndex);
                                if (reoDInfo == null || IndustryUtils.isEmptyObjectValue(reovov = IndustryUtils.getObjectValueObjectValueData(reoDInfo, reopName)) || IndustryUtils.isEmptyString(reovoID = IndustryUtils.getObjectValueStringData(reovov, idColName)) || !reovoID.equals(id)) continue;
                                voc.addObject(reoDInfo);
                            }
                            dInfo.put(cName, (Object)voc);
                        } else if (dt.equals((Object)DataType.OBJECTVALUE) && !IndustryUtils.isEmptyMap(reoDMap)) {
                            IObjectValue vov = IndustryUtils.getMapObjectValueData(reoDMap, vs);
                            if (vov == null) {
                                sb.setLength(0);
                                sb.append("\u3010").append(IndustryUtils.isEmptyString(eoAlias) ? eoName : eoAlias).append("\u3011\u7b2c").append(dIndex + 1).append("\u6761\u8bb0\u5f55\uff0c\u7cfb\u7edf\u4e2d\u672a\u627e\u5230\u3010").append(IndustryUtils.isEmptyString(cAlias) ? cName : cAlias).append("\u3011").append(vs);
                                wb.close();
                                throw new EASBizException(new NumericExceptionSubItem("Excel\u5bfc\u5165\u5bfc\u51fa\u5931\u8d25", sb.toString()));
                            }
                            dInfo.put(cName, (Object)vov);
                        }
                        dColls.setObject(dIndex, dInfo);
                    }
                }
                eoMap.put("DataCollection", dColls);
                params.put(eoPKString, eoMap);
                if (bif == null || !meoFullName.equals(eoFullName) || IndustryUtils.isEmptyObjectCollection(dColls)) continue;
                Map dvMap = IndustryUtils.getMapMapData(params, "DefaultValueMap");
                if (!IndustryUtils.isEmptyMap(dvMap)) {
                    Iterator dvMapKeyIter;
                    Set dvMapKeySet = dvMap.keySet();
                    Iterator iterator = dvMapKeyIter = dvMapKeySet == null ? null : dvMapKeySet.iterator();
                    if (dvMapKeyIter != null) {
                        while (dvMapKeyIter.hasNext()) {
                            String key;
                            Object keyObject = dvMapKeyIter.next();
                            String string = key = keyObject == null ? null : keyObject.toString();
                            if (IndustryUtils.isEmptyString(key)) continue;
                            for (int dIndex = 0; dIndex < dCollsSize; ++dIndex) {
                                IObjectValue dInfo = dColls.getObject(dIndex);
                                if (dInfo == null) continue;
                                dInfo.put(key, dvMap.get(key));
                                dColls.setObject(dIndex, dInfo);
                            }
                        }
                    }
                }
                CoreBaseCollection aDColls = new CoreBaseCollection();
                aDColls.addObjectCollection(dColls);
                bif.addnewBatchData(aDColls);
            }
        }
        if (action.equals("ExcelExport")) {
            FileOutputStream fos = new FileOutputStream(filePath);
            wb.write((OutputStream)fos);
            fos.close();
        }
        wb.close();
    }

    public static void getEntityObjectMap(Map params) throws Exception {
        Object dCollsObject;
        ICoreBase eoBIF;
        Object eoBIFObject;
        EntityObjectInfo eoInfo;
        String bosTypeString;
        BOSObjectType bosType;
        if (IndustryUtils.isEmptyMap(params)) {
            throw new EASBizException(new NumericExceptionSubItem("\u83b7\u53d6\u5b9e\u4f53Map\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        String action = IndustryUtils.getMapStringData(params, "Action");
        if (IndustryUtils.isEmptyString(action)) {
            throw new EASBizException(new NumericExceptionSubItem("\u5bfc\u51faExcel\u5931\u8d25", "\u4f20\u9012\u7684Action\u53c2\u6570\u4e3a\u7a7a"));
        }
        if (!action.equals("ExcelImport") && !action.equals("ExcelExport")) {
            throw new EASBizException(new NumericExceptionSubItem("\u5bfc\u51faExcel\u5931\u8d25", "\u4f20\u9012\u7684Action\u53c2\u6570\u65e0\u6548"));
        }
        Object pkObject = IndustryUtils.getMapData(params, "PK");
        MetaDataPK pk = pkObject == null ? null : (pkObject instanceof MetaDataPK ? (MetaDataPK)pkObject : null);
        Object bosTypeObject = IndustryUtils.getMapData(params, "BOSType");
        BOSObjectType bOSObjectType = bosTypeObject == null ? null : (bosType = bosTypeObject instanceof BOSObjectType ? (BOSObjectType)bosTypeObject : null);
        if (pk == null && bosType == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u83b7\u53d6\u5b9e\u4f53Map\u5931\u8d25", "\u4f20\u9012\u7684PK\u548cBOSType\u4e3a\u7a7a"));
        }
        String string = bosTypeString = bosType == null ? null : bosType.toString();
        if (pk == null && IndustryUtils.isEmptyString(bosTypeString)) {
            throw new EASBizException(new NumericExceptionSubItem("\u83b7\u53d6\u5b9e\u4f53Map\u5931\u8d25", "\u4f20\u9012\u7684PK\u548cBOSType\u4e3a\u7a7a"));
        }
        if (pk == null && !MetaDataLoaderFactory.getRemoteMetaDataLoader().isEntity(bosType)) {
            throw new EASBizException(new NumericExceptionSubItem("\u83b7\u53d6\u5b9e\u4f53Map\u5931\u8d25", "\u6839\u636eBOSType\u3010" + bosTypeString + "\u3011\u83b7\u53d6\u5b9e\u4f53\u5bf9\u8c61\u5931\u8d25"));
        }
        EntityObjectInfo entityObjectInfo = eoInfo = pk == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bosType) : MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)pk);
        if (eoInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u83b7\u53d6\u5b9e\u4f53Map\u5931\u8d25", "\u6839\u636eBOSType\u3010" + bosTypeString + "\u3011\u83b7\u53d6\u5b9e\u4f53\u5bf9\u8c61\u5931\u8d25"));
        }
        String eoName = eoInfo.getName();
        String eoAlias = eoInfo.getAlias();
        String eoFullName = eoInfo.getFullName();
        Class ovClass = eoInfo.getObjectValueClazzRuntime();
        PropertyCollection pColls = eoInfo.getDuplicatedEntityProperties();
        String eoFactoryName = eoInfo.getBusinessImplFactory();
        Class<?> eoFactoryClass = IndustryUtils.isEmptyString(eoFactoryName) ? null : Class.forName(eoFactoryName);
        Method eoFactoryM = eoFactoryClass == null ? null : eoFactoryClass.getMethod("getRemoteInstance", new Class[0]);
        Object object = eoBIFObject = eoFactoryM == null ? null : eoFactoryM.invoke(null, new Object[0]);
        ICoreBase iCoreBase = eoBIFObject == null ? null : (eoBIF = eoBIFObject instanceof ICoreBase ? (ICoreBase)eoBIFObject : null);
        if (IndustryUtils.isEmptyString(eoName) || IndustryUtils.isEmptyString(eoFullName) || ovClass == null || eoBIF == null) {
            return;
        }
        if (bosType != null) {
            params.put("MainEntityObject", eoFullName);
        }
        List eoList = IndustryUtils.getMapListData(params, "EntityObjectList", new ArrayList());
        Map eoMap = IndustryUtils.getMapMapData(params, eoFullName, new HashMap());
        if (eoList.contains(eoFullName)) {
            return;
        }
        eoMap.put("Name", eoName);
        eoMap.put("Alias", eoAlias);
        eoMap.put("FullName", eoFullName);
        eoMap.put("ObjectValueClass", ovClass);
        eoMap.put("BizInterface", eoBIF);
        eoMap.put("IDColumnName", "id");
        params.put(eoFullName, eoMap);
        eoList.add(eoFullName);
        params.put("EntityObjectList", eoList);
        if (IndustryUtils.isEmptyObjectCollection((IObjectCollection)pColls)) {
            return;
        }
        List idList = IndustryUtils.getMapListData(params, "IDList");
        String selector = IndustryUtils.getMapStringData(params, "Selector");
        String sorter = IndustryUtils.getMapStringData(params, "Sorter");
        List selectorList = IndustryUtils.getMapListData(params, "SelectorList", new ArrayList());
        if (IndustryUtils.isEmptyList(selectorList) && !IndustryUtils.isEmptyString(selector)) {
            int dotPos = selector.indexOf(",");
            while (dotPos >= 0) {
                int nDotPos = selector.indexOf(",", dotPos + 1);
                String p = nDotPos < 0 ? selector.substring(dotPos + 1) : selector.substring(dotPos + 1, nDotPos);
                selectorList.add(p.trim());
                dotPos = nDotPos;
            }
            params.put("SelectorList", selectorList);
        }
        if (!(eoMap.containsKey("DataCollection") || IndustryUtils.isEmptyList(idList) || action.equals("ExcelImport"))) {
            StringBuilder sb = new StringBuilder();
            sb.setLength(0);
            sb.append("Select ");
            if (IndustryUtils.isEmptyString(selector)) {
                sb.append("id ");
            } else {
                sb.append(selector).append(" ");
            }
            sb.append("Where ");
            sb.append("id In ( ");
            sb.append(SQLUtil.arrayToString((Object[])idList.toArray())).append(" ");
            sb.append(") ");
            if (!IndustryUtils.isEmptyString(sorter)) {
                sb.append("Order By ");
                sb.append(sorter);
            }
            EntityViewInfo evi = new EntityViewInfo(sb.toString());
            evi.setBaseOnSelector(true);
            CoreBaseCollection colls = IndustryUtils.isEmptyList(idList) ? null : eoBIF.getCollection(evi);
            eoMap.put("DataCollection", colls);
        }
        IObjectCollection dColls = (dCollsObject = IndustryUtils.getMapData(eoMap, "DataCollection")) == null ? null : (dCollsObject instanceof IObjectCollection ? (IObjectCollection)dCollsObject : null);
        String eofpName = IndustryUtils.getMapStringData(eoMap, "FullPropertyName");
        ArrayList cList = new ArrayList();
        int pCollsSize = pColls.size();
        for (int pIndex = 0; pIndex < pCollsSize; ++pIndex) {
            DataType dt;
            OwnPropertyInfo opInfo;
            String fpName;
            PropertyInfo pInfo = pColls.get(pIndex);
            if (pInfo == null) continue;
            String pName = pInfo.getName();
            String pAlias = pInfo.getAlias();
            if (IndustryUtils.isEmptyString(pName) || pName.equals("seq")) continue;
            if (pName.equals("number")) {
                eoMap.put("IDColumnName", "number");
            }
            String string2 = fpName = IndustryUtils.isEmptyString(eofpName) ? pName : eofpName + "." + pName;
            if (IndustryUtils.isEmptyString(fpName) || !IndustryUtils.isEmptyList(selectorList) && !selectorList.contains(fpName) && !selectorList.contains(fpName + ".id") && !selectorList.contains(fpName + ".seq")) continue;
            int cIndex = IndustryUtils.isEmptyList(selectorList) ? -1 : (selectorList.contains(fpName) ? selectorList.indexOf(fpName) : (selectorList.contains(fpName + ".id") ? selectorList.indexOf(fpName + ".id") : selectorList.indexOf(fpName + ".seq")));
            HashMap<String, Object> cMap = new HashMap<String, Object>();
            cMap.put("Name", pName);
            cMap.put("Alias", pAlias);
            LinkPropertyInfo lpInfo = pInfo instanceof LinkPropertyInfo ? (LinkPropertyInfo)pInfo : null;
            OwnPropertyInfo ownPropertyInfo = opInfo = pInfo instanceof OwnPropertyInfo ? (OwnPropertyInfo)pInfo : null;
            if (lpInfo != null) {
                RelationshipInfo rInfo = lpInfo.getRelationship();
                if (rInfo == null) continue;
                RelationshipType rType = rInfo.getType();
                EntityObjectInfo ceoInfo = rInfo.getClientObject();
                EntityObjectInfo seoInfo = rInfo.getSupplierObject();
                PropertyInfo ceopInfo = rInfo.getClientProperty();
                PropertyInfo seopInfo = rInfo.getSupplierProperty();
                if (rType == null || seoInfo == null || ceoInfo == null || seopInfo == null || ceopInfo == null) continue;
                String ceoFullName = ceoInfo.getFullName();
                String seoFullName = seoInfo.getFullName();
                String ceopName = ceopInfo.getName();
                String seopName = seopInfo.getName();
                if (IndustryUtils.isEmptyString(seoFullName) || IndustryUtils.isEmptyString(ceoFullName) || IndustryUtils.isEmptyString(seopName) || IndustryUtils.isEmptyString(ceopName)) continue;
                MetaDataPK seoPK = MetaDataPK.create((String)seoFullName);
                if (rType.equals((Object)RelationshipType.COMPOSITION)) {
                    if (seoFullName.equals(eoFullName)) {
                        cMap.put("Type", DataType.OBJECTVALUE);
                        cMap.put("EntityObject", ceoFullName);
                        cMap.put("EntityObjectProperty", ceopName);
                        cMap.put("Expand", false);
                    } else {
                        cMap.put("Type", DataType.OBJECTCOLLECTION);
                        params.put("BOSType", null);
                        params.put("PK", seoPK);
                        cMap.put("EntityObject", seoFullName);
                        cMap.put("EntityObjectProperty", seopName);
                        cMap.put("Expand", true);
                    }
                } else if (rType.equals((Object)RelationshipType.ASSOCIATION)) {
                    cMap.put("Type", DataType.OBJECTVALUE);
                    cMap.put("EntityObject", seoFullName);
                    cMap.put("EntityObjectProperty", seopName);
                    if (!params.containsKey(seoFullName)) {
                        Object reoBIFObject;
                        HashMap<String, String> reoMap = new HashMap<String, String>();
                        String reoFactoryName = seoInfo.getBusinessImplFactory();
                        Class<?> reoFactoryClass = IndustryUtils.isEmptyString(reoFactoryName) ? null : Class.forName(reoFactoryName);
                        Method reoFactoryM = reoFactoryClass == null ? null : reoFactoryClass.getMethod("getRemoteInstance", new Class[0]);
                        Object object2 = reoBIFObject = reoFactoryM == null ? null : reoFactoryM.invoke(null, new Object[0]);
                        ICoreBase reoBIF = reoBIFObject == null ? null : (reoBIFObject instanceof ICoreBase ? (ICoreBase)reoBIFObject : null);
                        reoMap.put("FullName", seoFullName);
                        reoMap.put("BizInterface", (String)reoBIF);
                        reoMap.put("IDColumnName", "number");
                        params.put(seoFullName, reoMap);
                    }
                }
            } else if (opInfo != null) {
                DataType dt2 = opInfo.getDataType();
                if (dt2 == null) continue;
                cMap.put("Type", dt2);
                if (dt2.equals((Object)DataType.ENUM)) {
                    BizEnumInfo beInfo = opInfo.getEnumType();
                    cMap.put("BizEnumInfo", beInfo);
                    String eClassName = beInfo == null ? null : beInfo.getFullName();
                    Class<?> eClass = IndustryUtils.isEmptyString(eClassName) ? null : Class.forName(eClassName);
                    cMap.put("EnumClass", eClass);
                }
            }
            if (cIndex < 0) {
                cList.add(cMap);
            } else {
                int cListSize = cList.size();
                if (cIndex + 1 > cListSize) {
                    for (int loop = cListSize; loop < cIndex + 1; ++loop) {
                        cList.add(null);
                    }
                }
                cList.set(cIndex, cMap);
            }
            Object dtObject = IndustryUtils.getMapData(cMap, "Type");
            DataType dataType = dtObject == null ? null : (dt = dtObject instanceof DataType ? (DataType)dtObject : null);
            if (dt == null) continue;
            Boolean expand = IndustryUtils.getMapBooleanData(cMap, "Expand", false);
            String reoFullName = IndustryUtils.getMapStringData(cMap, "EntityObject");
            CoreBaseCollection eColls = new CoreBaseCollection();
            if (!IndustryUtils.isEmptyObjectCollection(dColls) && dt.equals((Object)DataType.OBJECTCOLLECTION) && expand.booleanValue()) {
                int dCollsSize = dColls.size();
                for (int dIndex = 0; dIndex < dCollsSize; ++dIndex) {
                    IObjectCollection vColls;
                    Object v;
                    IObjectValue dInfo = dColls.getObject(dIndex);
                    if (dInfo == null || (v = IndustryUtils.getObjectValueData(dInfo, pName)) == null) continue;
                    IObjectCollection iObjectCollection = vColls = v instanceof IObjectCollection ? (IObjectCollection)v : null;
                    if (IndustryUtils.isEmptyObjectCollection(vColls)) continue;
                    eColls.addObjectCollection(vColls);
                    dInfo.remove(pName);
                    dColls.setObject(dIndex, dInfo);
                }
            }
            if (!dt.equals((Object)DataType.OBJECTCOLLECTION) || !expand.booleanValue() || IndustryUtils.isEmptyString(reoFullName)) continue;
            HashMap<String, Object> seoMap = new HashMap<String, Object>();
            seoMap.put("DataCollection", eColls);
            seoMap.put("PropertyName", pName);
            seoMap.put("FullPropertyName", fpName);
            params.put(reoFullName, seoMap);
            IndustryUtils.getEntityObjectMap(params);
        }
        eoMap.put("ColumnList", cList);
        eoMap.put("DataCollection", dColls);
    }

    public static Object getListData(List list, int index) {
        if (IndustryUtils.isEmptyList(list) || index < 0) {
            return null;
        }
        int size = list.size();
        if (index + 1 > size) {
            return null;
        }
        return list.get(index);
    }

    public static Map getListMapData(List list, int index) {
        if (IndustryUtils.isEmptyList(list) || index < 0) {
            return null;
        }
        Object value = IndustryUtils.getListData(list, index);
        return value == null ? null : (value instanceof Map ? (Map)value : null);
    }

    public static Map getListMapData(List list, int index, Map defaultValue) {
        if (IndustryUtils.isEmptyList(list) || index < 0) {
            return defaultValue;
        }
        Map value = IndustryUtils.getListMapData(list, index);
        return value == null ? defaultValue : value;
    }

    public static BigDecimal getMapBigDecimalData(Map map, Object param) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getMapData(map, param);
        return value == null ? null : (value instanceof BigDecimal ? (BigDecimal)value : null);
    }

    public static BigDecimal getMapBigDecimalData(Map map, Object param, BigDecimal defaultValue) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        BigDecimal value = IndustryUtils.getMapBigDecimalData(map, param);
        return value == null ? defaultValue : value;
    }

    public static Boolean getMapBooleanData(Map map, Object param) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getMapData(map, param);
        return value == null ? null : (value instanceof Boolean ? (Boolean)value : null);
    }

    public static Boolean getMapBooleanData(Map map, Object param, Boolean defaultValue) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        Boolean value = IndustryUtils.getMapBooleanData(map, param);
        return value == null ? defaultValue : value;
    }

    public static Object getMapData(Map map, Object param) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = map.containsKey(param) ? (map.get(param) == null ? null : map.get(param)) : null;
        return value;
    }

    public static Date getMapDateData(Map map, Object param) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getMapData(map, param);
        return value == null ? null : (value instanceof Date ? (Date)value : null);
    }

    public static Integer getMapIntegerData(Map map, Object param) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getMapData(map, param);
        return value == null ? null : Integer.valueOf(value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString()));
    }

    public static Integer getMapIntegerData(Map map, Object param, Integer defaultValue) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        Integer value = IndustryUtils.getMapIntegerData(map, param);
        return value == null ? defaultValue : value;
    }

    public static List getMapListData(Map map, Object param) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getMapData(map, param);
        return value == null ? null : (value instanceof List ? (List)value : null);
    }

    public static List getMapListData(Map map, Object param, List defaultValue) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        List value = IndustryUtils.getMapListData(map, param);
        return value == null ? defaultValue : value;
    }

    public static Long getMapLongData(Map map, Object param) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getMapData(map, param);
        return value == null ? null : (value instanceof Long ? (Long)value : null);
    }

    public static Map getMapMapData(Map map, Object param) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getMapData(map, param);
        return value == null ? null : (value instanceof Map ? (Map)value : null);
    }

    public static Map getMapMapData(Map map, Object param, Map defaultValue) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        Map value = IndustryUtils.getMapMapData(map, param);
        return value == null ? defaultValue : value;
    }

    public static IObjectCollection getMapObjectCollectionData(Map map, Object param) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getMapData(map, param);
        return value == null ? null : (value instanceof IObjectCollection ? (IObjectCollection)value : null);
    }

    public static IObjectCollection getMapObjectCollectionData(Map map, Object param, IObjectCollection defaultValue) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        IObjectCollection value = IndustryUtils.getMapObjectCollectionData(map, param);
        return value == null ? defaultValue : value;
    }

    public static IObjectValue getMapObjectValueData(Map map, Object param) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getMapData(map, param);
        return value == null ? null : (value instanceof IObjectValue ? (IObjectValue)value : null);
    }

    public static IObjectValue getMapObjectValueData(Map map, Object param, IObjectValue defaultValue) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        IObjectValue value = IndustryUtils.getMapObjectValueData(map, param);
        return value == null ? defaultValue : value;
    }

    public static Set getMapSetData(Map map, Object param) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getMapData(map, param);
        return value == null ? null : (value instanceof Set ? (Set)value : null);
    }

    public static Set getMapSetData(Map map, Object param, Set defaultValue) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        Set value = IndustryUtils.getMapSetData(map, param);
        return value == null ? defaultValue : value;
    }

    public static String getMapStringData(Map map, Object param) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getMapData(map, param);
        return value == null ? null : value.toString();
    }

    public static String getMapStringData(Map map, Object param, String defaultValue) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return defaultValue;
        }
        Object value = IndustryUtils.getMapData(map, param);
        return value == null ? defaultValue : value.toString();
    }

    public static Time getMapTimeData(Map map, Object param) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getMapData(map, param);
        return value == null ? null : (value instanceof Time ? (Time)value : null);
    }

    public static Timestamp getMapTimestampData(Map map, Object param) {
        if (IndustryUtils.isEmptyMap(map) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getMapData(map, param);
        return value == null ? null : (value instanceof Timestamp ? (Timestamp)value : null);
    }

    public static BigDecimal getObjectValueBigDecimalData(IObjectValue objectValue, String param) {
        if (IndustryUtils.isEmptyObjectValue(objectValue) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getObjectValueData(objectValue, param);
        return value == null ? null : (value instanceof BigDecimal ? (BigDecimal)value : null);
    }

    public static BigDecimal getObjectValueBigDecimalData(IObjectValue objectValue, String param, BigDecimal defaultValue) {
        if (IndustryUtils.isEmptyObjectValue(objectValue) || param == null) {
            return defaultValue;
        }
        BigDecimal value = IndustryUtils.getObjectValueBigDecimalData(objectValue, param);
        return value == null ? defaultValue : value;
    }

    public static Boolean getObjectValueBooleanData(IObjectValue objectValue, String param) {
        if (IndustryUtils.isEmptyObjectValue(objectValue) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getObjectValueData(objectValue, param);
        return value == null ? false : (value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString()));
    }

    public static Object getObjectValueData(IObjectValue objectValue, String param) {
        if (IndustryUtils.isEmptyObjectValue(objectValue) || param == null) {
            return null;
        }
        Object value = objectValue.containsKey(param) ? (objectValue.get(param) == null ? null : objectValue.get(param)) : null;
        return value;
    }

    public static Integer getObjectValueIntegerData(IObjectValue objectValue, String param) {
        if (IndustryUtils.isEmptyObjectValue(objectValue) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getObjectValueData(objectValue, param);
        return value == null ? null : Integer.valueOf(value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString()));
    }

    public static List getObjectValueListData(IObjectValue objectValue, String param) {
        if (IndustryUtils.isEmptyObjectValue(objectValue) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getObjectValueData(objectValue, param);
        return value == null ? null : (value instanceof List ? (List)value : null);
    }

    public static IObjectCollection getObjectValueObjectCollectionData(IObjectValue objectValue, String param) {
        if (IndustryUtils.isEmptyObjectValue(objectValue) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getObjectValueData(objectValue, param);
        return value == null ? null : (value instanceof IObjectCollection ? (IObjectCollection)value : null);
    }

    public static IObjectCollection getObjectValueObjectCollectionData(IObjectValue objectValue, String param, IObjectCollection defaultValue) {
        if (IndustryUtils.isEmptyObjectValue(objectValue) || param == null) {
            return defaultValue;
        }
        IObjectCollection value = IndustryUtils.getObjectValueObjectCollectionData(objectValue, param);
        return value == null ? defaultValue : value;
    }

    public static IObjectValue getObjectValueObjectValueData(IObjectValue objectValue, String param) {
        if (IndustryUtils.isEmptyObjectValue(objectValue) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getObjectValueData(objectValue, param);
        return value == null ? null : (value instanceof IObjectValue ? (IObjectValue)value : null);
    }

    public static String getObjectValueStringData(IObjectValue objectValue, String param) {
        if (IndustryUtils.isEmptyObjectValue(objectValue) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getObjectValueData(objectValue, param);
        return value == null ? null : value.toString();
    }

    public static String getObjectValueStringData(IObjectValue objectValue, String param, String defaultValue) {
        if (IndustryUtils.isEmptyObjectValue(objectValue) || param == null) {
            return defaultValue;
        }
        String value = IndustryUtils.getObjectValueStringData(objectValue, param);
        return value == null ? defaultValue : value;
    }

    public static Timestamp getObjectValueTimestampData(IObjectValue objectValue, String param) {
        if (IndustryUtils.isEmptyObjectValue(objectValue) || param == null) {
            return null;
        }
        Object value = IndustryUtils.getObjectValueData(objectValue, param);
        return value == null ? null : (value instanceof Timestamp ? (Timestamp)value : null);
    }

    public static String getParamValue(IParamItem pi, String paramNumber, String orgUnitID) throws BOSException, EASBizException {
        if (pi == null || IndustryUtils.isEmptyString(paramNumber) || IndustryUtils.isEmptyString(orgUnitID)) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append("Select ");
        sql.append("id ");
        sql.append(",value ");
        sql.append("Where ");
        sql.append("keyID.number='").append(paramNumber).append("' ");
        sql.append("And (( ");
        sql.append("orgUnitID.id='").append(orgUnitID).append("' ");
        sql.append("And keyID.orgType<>").append(10).append(" ");
        sql.append("And keyID.orgType<>").append(-1).append(" ");
        sql.append(") Or (( ");
        sql.append("CU.id='").append(orgUnitID).append("' ");
        sql.append("Or orgUnitID.id='").append(orgUnitID).append("' ");
        sql.append(") ");
        sql.append("And keyID.orgType=").append(10).append(" ");
        sql.append(") Or ");
        sql.append("keyID.orgType=").append(-1).append(" ");
        sql.append(") ");
        ParamItemCollection piCollection = pi.getParamItemCollection(sql.toString());
        ParamItemInfo piInfo = IndustryUtils.isEmptyObjectCollection((IObjectCollection)piCollection) ? null : piCollection.get(0);
        return IndustryUtils.isEmptyObjectValue((IObjectValue)piInfo) ? null : piInfo.getValue();
    }

    public static List getPermissionUserOrgIDList(String userID, String permItem, String filter, ICoreBase iuop) throws BOSException, EASBizException {
        if (IndustryUtils.isEmptyString(userID) || IndustryUtils.isEmptyString(permItem) || iuop == null) {
            return null;
        }
        ArrayList<String> orgIDList = new ArrayList<String>();
        try {
            StringBuilder sb = new StringBuilder();
            sb.setLength(0);
            sb.append("Select ");
            sb.append("id ");
            sb.append(",org.id ");
            sb.append("Where ");
            sb.append("owner.id='").append(userID).append("' ");
            sb.append("And permItem.name='").append(permItem).append("' ");
            if (!IndustryUtils.isEmptyString(filter)) {
                sb.append("And ").append(filter).append(" ");
            }
            EntityViewInfo uopEVInfo = new EntityViewInfo(sb.toString());
            uopEVInfo.setBaseOnSelector(true);
            CoreBaseCollection uopCollection = iuop.getCollection(uopEVInfo);
            if (IndustryUtils.isEmptyObjectCollection((IObjectCollection)uopCollection)) {
                return null;
            }
            int uopCollectionSize = uopCollection.size();
            for (int index = 0; index < uopCollectionSize; ++index) {
                IObjectValue uopInfo = uopCollection.getObject(index);
                IObjectValue orgInfo = IndustryUtils.getObjectValueObjectValueData(uopInfo, "org");
                String orgID = IndustryUtils.getObjectValueStringData(orgInfo, "id");
                if (IndustryUtils.isEmptyString(orgID) || orgIDList.contains(orgID)) continue;
                orgIDList.add(orgID);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return orgIDList;
    }

    public static boolean isEmptyArray(Object[] array) {
        if (array == null) {
            return true;
        }
        return array.length == 0;
    }

    public static boolean isEmptyJSONObject(JSONObject jsonObject) {
        if (jsonObject == null) {
            return true;
        }
        return jsonObject.length() == 0;
    }

    public static boolean isEmptyList(List list) {
        if (list == null) {
            return true;
        }
        return list.size() == 0;
    }

    public static boolean isEmptyMap(Map map) {
        if (map == null) {
            return true;
        }
        return map.size() == 0;
    }

    public static boolean isEmptyObjectCollection(IObjectCollection objectCollection) {
        if (objectCollection == null) {
            return true;
        }
        return objectCollection.size() == 0;
    }

    public static boolean isEmptyObjectValue(IObjectValue objectValue) {
        if (objectValue == null) {
            return true;
        }
        return objectValue.size() == 0;
    }

    public static boolean isEmptyRowSet(IRowSet rowSet) {
        if (rowSet == null) {
            return true;
        }
        return rowSet.size() == 0;
    }

    public static boolean isEmptySet(Set set) {
        if (set == null) {
            return true;
        }
        return set.size() == 0;
    }

    public static boolean isEmptyString(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() == 0;
    }

    public static boolean isEmptyStringBuilder(String sb) {
        if (sb == null) {
            return true;
        }
        if (sb.length() == 0) {
            return true;
        }
        return sb.toString().trim().length() == 0;
    }

    public static boolean isZeroBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return true;
        }
        return bigDecimal.compareTo(BigDecimal.ZERO) == 0;
    }

    public static void removeActionsServices(ItemAction[] actions, String[] serviceClassNames) {
        if (IndustryUtils.isEmptyArray(actions) || IndustryUtils.isEmptyArray(serviceClassNames)) {
            return;
        }
        for (ItemAction action : actions) {
            Map serviceMap;
            if (action == null || IndustryUtils.isEmptyMap(serviceMap = action.getServices())) continue;
            for (String serviceClassName : serviceClassNames) {
                if (IndustryUtils.isEmptyString(serviceClassName)) continue;
                serviceMap.remove(serviceClassName);
            }
        }
    }

    public static void removeKDTableActionMap(KDTable table, String[] actions) {
        if (table == null || IndustryUtils.isEmptyArray(actions)) {
            return;
        }
        ActionMap aMap = table.getActionMap();
        if (aMap == null) {
            return;
        }
        if (aMap.size() == 0) {
            return;
        }
        for (String action : actions) {
            if (IndustryUtils.isEmptyString(action)) continue;
            aMap.remove(action);
        }
    }

    public static void setBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID, ICodingRuleManager iCRM) throws EASBizException, BOSException {
        String billNumber;
        if (ctx == null || billInfo == null || bizOrgUnitID == null || iCRM == null) {
            throw new EASBizException(new NumericExceptionSubItem("\u6570\u636e\u68c0\u6d4b\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        CodingRuleInfo ruleInfo = iCRM.getCodingRule(billInfo, bizOrgUnitID);
        String string = billNumber = ruleInfo == null ? null : iCRM.getNumber(billInfo, ruleInfo);
        if (billNumber != null) {
            billInfo.setString("number", billNumber);
        } else if (billInfo.getString("id") != null) {
            billInfo.setString("number", "AutoNumberFromBTP_" + billInfo.getString("id").toString());
        } else {
            billInfo.setString("number", "AutoNumberFromBTP_" + BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
        }
    }

    public static void setButtonsActionProxys(Component[] buttons, ItemAction[] actions, ResourceBundleHelper resHelper, Map serviceContext) {
        if (IndustryUtils.isEmptyArray(buttons) || IndustryUtils.isEmptyArray(actions) || resHelper == null) {
            return;
        }
        int buttonsLength = buttons.length;
        int proxysLength = buttons.length;
        if (buttonsLength != proxysLength) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < buttonsLength; ++index) {
            IItemAction actionProxy;
            String text;
            String resText2;
            KDMenuItem menuItem;
            String name;
            Component button = buttons[index];
            ItemAction action = actions[index];
            if (button == null || action == null || IndustryUtils.isEmptyString(name = button.getName())) continue;
            KDWorkButton btn = button instanceof KDWorkButton ? (KDWorkButton)button : null;
            KDMenuItem kDMenuItem = menuItem = button instanceof KDMenuItem ? (KDMenuItem)button : null;
            String oldText = btn != null ? btn.getText() : (menuItem != null ? menuItem.getText() : null);
            sb.setLength(0);
            sb.append(name).append(".text");
            String resName = sb.toString();
            sb.setLength(0);
            try {
                resText2 = resHelper.getString(resName);
                if (!IndustryUtils.isEmptyString(resText2)) {
                    sb.append(resText2);
                }
            }
            catch (MissingResourceException resText2) {
                // empty catch block
            }
            resText2 = sb.toString();
            String string = text = IndustryUtils.isEmptyString(resText2) ? oldText : resText2;
            if (IndustryUtils.isEmptyString(text)) continue;
            Object proxy = ActionProxyFactory.getProxy((Object)action, (Class[])new Class[]{IItemAction.class}, (Map)serviceContext);
            IItemAction iItemAction = actionProxy = proxy instanceof IItemAction ? (IItemAction)proxy : null;
            if (actionProxy == null) continue;
            if (btn != null) {
                btn.setAction((Action)actionProxy);
                btn.setText(text);
                continue;
            }
            if (menuItem == null) continue;
            menuItem.setAction((Action)actionProxy);
            menuItem.setText(text);
        }
    }

    public static void setColumnBigDecimalEditor(IColumn column, int precision, boolean isNegatived) throws Exception {
        KDFormattedTextField bigDecimalEditor;
        Component component;
        if (column == null || precision < 0) {
            return;
        }
        ICellEditor editor = column.getEditor();
        Component component2 = component = editor == null ? null : editor.getComponent();
        KDFormattedTextField kDFormattedTextField = component == null ? null : (bigDecimalEditor = component instanceof KDFormattedTextField ? (KDFormattedTextField)component : null);
        if (bigDecimalEditor == null) {
            KDFormattedTextField newBigDecimalEditor = new KDFormattedTextField();
            newBigDecimalEditor.setDataType(1);
            newBigDecimalEditor.setPrecision(precision % 11);
            newBigDecimalEditor.setMaximumValue((Comparable)new BigDecimal("999999999999.9999"));
            newBigDecimalEditor.setMinimumValue((Comparable)new BigDecimal("-999999999999.9999"));
            newBigDecimalEditor.setHorizontalAlignment(4);
            newBigDecimalEditor.setSupportedEmpty(true);
            newBigDecimalEditor.setRemoveingZeroInDispaly(false);
            newBigDecimalEditor.setNegatived(isNegatived);
            column.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)newBigDecimalEditor));
        } else {
            bigDecimalEditor.setPrecision(precision);
            bigDecimalEditor.setNegatived(isNegatived);
            bigDecimalEditor.setHorizontalAlignment(4);
            bigDecimalEditor.setSupportedEmpty(true);
            bigDecimalEditor.setRemoveingZeroInDispaly(false);
        }
    }

    public static void setColumnF7Editor(IColumn column, String filter) throws Exception {
        FilterInfo f7FI;
        KDBizPromptBox f7Editor;
        Component component;
        if (column == null) {
            return;
        }
        ICellEditor editor = column.getEditor();
        Component component2 = component = editor == null ? null : editor.getComponent();
        KDBizPromptBox kDBizPromptBox = component == null ? null : (f7Editor = component instanceof KDBizPromptBox ? (KDBizPromptBox)component : null);
        EntityViewInfo f7EVI = f7Editor == null ? new EntityViewInfo() : (f7Editor.getEntityViewInfo() == null ? new EntityViewInfo() : f7Editor.getEntityViewInfo());
        FilterInfo filterInfo = f7FI = f7EVI.getFilter() == null ? new FilterInfo() : f7EVI.getFilter();
        if (!IndustryUtils.isEmptyString(filter)) {
            f7FI.mergeFilter(new FilterInfo(filter), "And");
        }
        if (f7Editor != null) {
            f7Editor.setCommitFormat("$number$");
            f7Editor.setEditFormat("$number$");
            f7Editor.setDisplayFormat("($number$)$name$");
        }
        f7EVI.setFilter(f7FI);
        f7Editor.setEntityViewInfo(f7EVI);
    }

    public static void setColumnTimestampEditor(IColumn column, boolean isTime, boolean isTimeEnabled) throws Exception {
        Component component;
        if (column == null) {
            return;
        }
        ICellEditor editor = column.getEditor();
        Component component2 = component = editor == null ? null : editor.getComponent();
        if (isTime) {
            KDTimePicker timestampEditor;
            KDTimePicker kDTimePicker = component == null ? null : (timestampEditor = component instanceof KDTimePicker ? (KDTimePicker)component : null);
            if (timestampEditor == null) {
                KDTimePicker newTimestampEditor = new KDTimePicker();
                column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)newTimestampEditor));
            }
        } else {
            KDDatePicker timestampEditor;
            KDDatePicker kDDatePicker = component == null ? null : (timestampEditor = component instanceof KDDatePicker ? (KDDatePicker)component : null);
            if (timestampEditor == null) {
                KDDatePicker newTimestampEditor = new KDDatePicker();
                newTimestampEditor.setTimeEnabled(isTimeEnabled);
                column.setEditor((ICellEditor)new KDTDefaultCellEditor(newTimestampEditor));
            } else {
                timestampEditor.setTimeEnabled(isTimeEnabled);
            }
        }
    }

    public static void setKDTableColumnSortable(KDTable table, String[] columns) {
        if (table == null) {
            return;
        }
        if (IndustryUtils.isEmptyArray(columns)) {
            int tableColumnCount = table.getColumnCount();
            for (int index = 0; index < tableColumnCount; ++index) {
                table.getColumn(index).setSortable(true);
            }
        } else {
            for (String column : columns) {
                IColumn col;
                if (IndustryUtils.isEmptyString(column) || (col = table.getColumn(column)) == null) continue;
                col.setSortable(true);
            }
        }
    }

    public static void setKDTableMergeColumns(KDTable table, String[] columns) {
        if (table == null || IndustryUtils.isEmptyArray(columns)) {
            return;
        }
        table.getGroupManager().setGroup(true);
        for (String column : columns) {
            IColumn col;
            if (IndustryUtils.isEmptyString(column) || (col = table.getColumn(column)) == null) continue;
            col.setGroup(true);
            col.setMergeable(true);
        }
    }

    public static void setObjectCollectionValue(IObjectCollection colls, String[] properties, Object[] values) throws BOSException, EASBizException {
        if (IndustryUtils.isEmptyObjectCollection(colls) || IndustryUtils.isEmptyArray(properties) || IndustryUtils.isEmptyArray(values)) {
            throw new EASBizException(new NumericExceptionSubItem("\u6570\u636e\u68c0\u6d4b\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        int propertiesLength = properties.length;
        int valuesLength = values.length;
        if (propertiesLength != valuesLength) {
            throw new EASBizException(new NumericExceptionSubItem("\u6570\u636e\u68c0\u6d4b\u5931\u8d25", "\u53c2\u6570\u4e2d\u5b57\u6bb5\u4e0e\u503c\u7684\u6570\u91cf\u4e0d\u4e00\u81f4"));
        }
        int collsSize = colls.size();
        for (int index = 0; index < collsSize; ++index) {
            IObjectValue model = colls.getObject(index);
            if (model == null) continue;
            for (int pIndex = 0; pIndex < propertiesLength; ++pIndex) {
                String property = properties[pIndex];
                if (IndustryUtils.isEmptyString(property)) continue;
                model.put(property, values[pIndex]);
            }
        }
    }

    public static void setObjectValueValue(IObjectValue model, String[] properties, Object[] values) throws BOSException, EASBizException {
        if (IndustryUtils.isEmptyObjectValue(model) || IndustryUtils.isEmptyArray(properties) || IndustryUtils.isEmptyArray(values)) {
            throw new EASBizException(new NumericExceptionSubItem("\u6570\u636e\u68c0\u6d4b\u5931\u8d25", "\u4f20\u9012\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        int propertiesLength = properties.length;
        int valuesLength = values.length;
        if (propertiesLength != valuesLength) {
            throw new EASBizException(new NumericExceptionSubItem("\u6570\u636e\u68c0\u6d4b\u5931\u8d25", "\u53c2\u6570\u4e2d\u5b57\u6bb5\u4e0e\u503c\u7684\u6570\u91cf\u4e0d\u4e00\u81f4"));
        }
        CoreBaseCollection colls = new CoreBaseCollection();
        colls.addObject(model);
        IndustryUtils.setObjectCollectionValue((IObjectCollection)colls, properties, values);
    }

    public static void setUIComponentShowHide(Object[] uics, Boolean isVisible, Boolean isEnable) throws Exception {
        if (IndustryUtils.isEmptyArray(uics)) {
            return;
        }
        HashMap<String, Map> mMap = new HashMap<String, Map>();
        for (Object uic : uics) {
            Method mse;
            Method msv;
            Object mseObject;
            String cn;
            Class<?> c;
            if (uic == null || (c = uic.getClass()) == null || IndustryUtils.isEmptyString(cn = c.getName())) continue;
            Map cmMap = IndustryUtils.getMapMapData(mMap, cn, new HashMap());
            Object msvObject = IndustryUtils.isEmptyMap(cmMap) ? c.getMethod("setVisible", Boolean.TYPE) : IndustryUtils.getMapData(cmMap, "setVisible");
            Object object = mseObject = IndustryUtils.isEmptyMap(cmMap) ? c.getMethod("setEnabled", Boolean.TYPE) : IndustryUtils.getMapData(cmMap, "setEnabled");
            Method method = msvObject == null ? null : (msv = msvObject instanceof Method ? (Method)msvObject : null);
            Method method2 = mseObject == null ? null : (mse = mseObject instanceof Method ? (Method)mseObject : null);
            if (msv == null || mse == null) continue;
            if (IndustryUtils.isEmptyMap(cmMap)) {
                cmMap.put("setVisible", msv);
                cmMap.put("setEnabled", mse);
                mMap.put(cn, cmMap);
            }
            msv.invoke(uic, isVisible);
            mse.invoke(uic, isEnable);
        }
    }

    public static void stringBuilderAppend(StringBuilder sb, String content, String delimiter) {
        if (sb == null || IndustryUtils.isEmptyString(content)) {
            return;
        }
        if (!IndustryUtils.isEmptyString(delimiter) && sb.length() > 0) {
            sb.append(delimiter);
        }
        sb.append(content);
    }

    public static String timeFormat(long time, String format, Locale locale) {
        long mod;
        boolean formatS;
        if (IndustryUtils.isEmptyString(format) || locale == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        long newTime = time;
        boolean formatH = format.toUpperCase().indexOf("H".toUpperCase()) >= 0;
        boolean formatM = format.toUpperCase().indexOf("M".toUpperCase()) >= 0;
        boolean bl = formatS = format.toUpperCase().indexOf("S".toUpperCase()) >= 0;
        if (formatH) {
            if (newTime >= 3600000L) {
                mod = newTime % 3600000L;
                long h = (newTime -= mod) / 3600000L;
                sb.append(h);
                newTime = mod;
            } else {
                sb.append("0");
            }
            sb.append(EASCommonResource.getString((String)"com.kingdee.eas.util.IndustryUtilsResource.HOUR_SHORT", (Locale)locale));
        }
        if (formatM) {
            if (newTime >= 60000L) {
                mod = newTime % 60000L;
                long m = (newTime -= mod) / 60000L;
                if (formatH && m < 10L) {
                    sb.append("0");
                }
                sb.append(m);
                newTime = mod;
            } else {
                sb.append("00");
            }
            sb.append(EASCommonResource.getString((String)"com.kingdee.eas.util.IndustryUtilsResource.MINUTE_SHORT", (Locale)locale));
        }
        if (formatS) {
            if (newTime >= 1000L) {
                mod = newTime % 1000L;
                long s = (newTime -= mod) / 1000L;
                if (formatM && s < 10L) {
                    sb.append("0");
                }
                sb.append(s);
                newTime = mod;
            } else {
                sb.append("00");
            }
            sb.append(EASCommonResource.getString((String)"com.kingdee.eas.util.IndustryUtilsResource.SECOND_SHORT", (Locale)locale));
        }
        return sb.toString();
    }

    public static List transferRowSetToList(IRowSet rs) throws Exception {
        if (IndustryUtils.isEmptyRowSet(rs)) {
            return null;
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        if (rsmd == null) {
            return null;
        }
        int colCount = rsmd.getColumnCount();
        if (colCount <= 0) {
            return null;
        }
        ArrayList<String> colList = new ArrayList<String>();
        for (int index = 1; index <= colCount; ++index) {
            String col = rsmd.getColumnName(index);
            if (IndustryUtils.isEmptyString(col) || colList.contains(col)) continue;
            colList.add(col);
        }
        if (IndustryUtils.isEmptyList(colList)) {
            return null;
        }
        Object[] cols = colList.toArray();
        ArrayList dList = new ArrayList();
        while (rs.next()) {
            HashMap<String, Object> rdMap = new HashMap<String, Object>();
            for (Object col : cols) {
                String colString;
                String string = colString = col == null ? null : col.toString();
                if (IndustryUtils.isEmptyString(colString)) continue;
                rdMap.put(colString, rs.getObject(colString));
            }
            if (IndustryUtils.isEmptyMap(rdMap)) continue;
            dList.add(rdMap);
        }
        rs.close();
        return dList;
    }
}

