/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelation;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.emm.mo.EMMGenerateMRBByMOFacadeFactory;
import com.kingdee.eas.emm.mo.EMMManufactureOrderChangeEntryCollection;
import com.kingdee.eas.emm.mo.EMMManufactureOrderChangeEntryInfo;
import com.kingdee.eas.emm.mo.EMMManufactureOrderChangeInfo;
import com.kingdee.eas.emm.mo.IEMMGenerateMRBByMOFacade;
import com.kingdee.eas.emm.mo.app.AbstractEMMManufactureOrderChangeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.common.BillBaseStatusEnum;
import com.kingdee.eas.industry.emm.mm.mo.IStockTransferPlanDetial;
import com.kingdee.eas.industry.emm.mm.mo.StockTransferPlanDetialFactory;
import com.kingdee.eas.industry.emm.mo.EMMManufactureOrderEntrysGenFacadeFactory;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.IManufactureOrderStock;
import com.kingdee.eas.mm.mo.IManufactureOrderTechnics;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.IMaterialReqBill;
import com.kingdee.eas.scm.im.inv.IMaterialReqBillEntry;
import com.kingdee.eas.scm.im.inv.IStockTransferBill;
import com.kingdee.eas.scm.im.inv.IStockTransferBillEntry;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EMMManufactureOrderChangeControllerBean
extends AbstractEMMManufactureOrderChangeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.emm.mo.app.EMMManufactureOrderChangeControllerBean");
    protected String unStockTransferTypeID = "mBoAAAABOJA12srm";
    public static final String sql_BOTPRelation;
    protected static final String TransactionType_Number_BACK = "443";
    protected static final String TransactionType_Number_SPAN = "L465";
    protected BigDecimal oldQty = BigDecimal.ZERO;
    protected BigDecimal newQty = BigDecimal.ZERO;

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EMMManufactureOrderChangeInfo emmmocInfo = (EMMManufactureOrderChangeInfo)model;
        if (emmmocInfo.getBillBaseStatus().getValue() == 2) {
            emmmocInfo.setBillBaseStatus(BillBaseStatusEnum.SUBMITED);
        } else {
            emmmocInfo.setBillBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        }
        return super._save(ctx, (IObjectValue)emmmocInfo);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((EMMManufactureOrderChangeInfo)model).setBillBaseStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    public String getString(Context ctx, String name) {
        return EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)name, (Locale)ctx.getLocale());
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        int i;
        boolean useNew = true;
        if (useNew) {
            this.auditChangeBill(ctx, pk, model);
            return;
        }
        EMMManufactureOrderChangeInfo mocInfo = (EMMManufactureOrderChangeInfo)model;
        EMMManufactureOrderChangeEntryCollection entryColl = mocInfo.getEntrys();
        ManufactureOrderInfo moInfo = null;
        EMMManufactureOrderChangeEntryInfo emmMOCEntryInfo = null;
        StringBuffer sql = new StringBuffer();
        for (i = 0; i < entryColl.size(); ++i) {
            emmMOCEntryInfo = entryColl.get(i);
            moInfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(emmMOCEntryInfo.getManuOrder().getId().toString()));
            if (emmMOCEntryInfo.getOldQty().compareTo(moInfo.getQty()) != 0) {
                throw new EASBizException(new NumericExceptionSubItem(this.getString(ctx, "APPROVE_FAIL"), this.getString(ctx, "MANUFACTURE_INFO") + emmMOCEntryInfo.getManuOrder().getNumber() + this.getString(ctx, "JHSLYGB_INFO")));
            }
            if (emmMOCEntryInfo.getOldPlanBeginDate().getTime() != moInfo.getPlanBeginDate().getTime()) {
                throw new EASBizException(new NumericExceptionSubItem(this.getString(ctx, "APPROVE_FAIL"), this.getString(ctx, "MANUFACTURE_INFO") + emmMOCEntryInfo.getManuOrder().getNumber() + this.getString(ctx, "JHKGRQYGB_INFO")));
            }
            if (emmMOCEntryInfo.getOldPlanEndDate().getTime() == moInfo.getPlanEndDate().getTime()) continue;
            throw new EASBizException(new NumericExceptionSubItem(this.getString(ctx, "APPROVE_FAIL"), this.getString(ctx, "MANUFACTURE_INFO") + emmMOCEntryInfo.getManuOrder().getNumber() + this.getString(ctx, "JHWGRQYGB_INFO")));
        }
        if (entryColl.size() > 0) {
            for (i = 0; i < entryColl.size(); ++i) {
                EMMManufactureOrderChangeEntryInfo entryInfo = entryColl.get(i);
                moInfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(entryInfo.getManuOrder().getId().toString()));
                if (moInfo.getBaseStatus().getValue() != 4 && moInfo.getBaseStatus().getValue() != 5) {
                    throw new EASBizException(new NumericExceptionSubItem(this.getString(ctx, "APPROVE_FAIL"), this.getString(ctx, "MANUFACTURE_INFO") + moInfo.getNumber() + this.getString(ctx, "BSSHHXDZT_INFO")));
                }
                this.oldQty = entryInfo.getOldQty();
                this.newQty = entryInfo.getNewQty();
                if (entryInfo.getOldQty().compareTo(entryInfo.getNewQty()) != 0) {
                    if (entryInfo.getNewQty().compareTo(BigDecimal.ZERO) == 0) {
                        this.cancelManuOrder(ctx, moInfo);
                    } else {
                        if (entryInfo.getOldQty().compareTo(entryInfo.getNewQty()) == 1) {
                            try {
                                this.subOrderQty(ctx, moInfo);
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                                throw new EASBizException(new NumericExceptionSubItem("Error", e.getMessage()));
                            }
                        }
                        if (entryInfo.getOldQty().compareTo(entryInfo.getNewQty()) == -1) {
                            this.addOrderQty(ctx, moInfo);
                        }
                    }
                }
                if (entryInfo.getOldPlanEndDate().compareTo(entryInfo.getNewPlanEndDate()) != 0) {
                    this.changePlanDate(ctx, moInfo, entryInfo.getOldPlanBeginDate(), entryInfo.getNewPlanBeginDate(), entryInfo.getOldPlanEndDate(), entryInfo.getNewPlanEndDate());
                }
                sql.append(" update T_MM_MANUFACTUREORDER set fqty =? , fbaseqty=? , fplanbegindate=?, fplanenddate=? where fid=?");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{this.newQty, this.newQty, entryInfo.getNewPlanBeginDate(), entryInfo.getNewPlanEndDate(), moInfo.getId().toString()});
            }
        }
        ((EMMManufactureOrderChangeInfo)model).setBillBaseStatus(BillBaseStatusEnum.AUDITED);
        ((EMMManufactureOrderChangeInfo)model).setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        ((EMMManufactureOrderChangeInfo)model).setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)((EMMManufactureOrderChangeInfo)model));
    }

    protected void changePlanDate(Context ctx, ManufactureOrderInfo manuorder, Date oldPlanBeginDate, Date newPlanBeginDate, Date oldPlanEndDate, Date newPlanEndDate) throws EASBizException, BOSException {
        IManufactureOrderTechnics imot = ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx);
        IManufactureOrderStock imos = ManufactureOrderStockFactory.getLocalInstance((Context)ctx);
        long betweenBegDays = EMMManufactureOrderChangeControllerBean.getDaySub(oldPlanBeginDate, newPlanBeginDate);
        long betweenEndDays = EMMManufactureOrderChangeControllerBean.getDaySub(oldPlanEndDate, newPlanEndDate);
        HashMap<Integer, Timestamp> mapPlanDate = new HashMap<Integer, Timestamp>();
        StringBuffer sql = new StringBuffer();
        ManufactureOrderTechnicsInfo motInfo = null;
        ManufactureOrderStockInfo mosInfo = null;
        ManufactureOrderTechnicsCollection motColl = manuorder.getTechnics();
        for (int i = 0; i < motColl.size(); ++i) {
            motInfo = (ManufactureOrderTechnicsInfo)imot.getValue((IObjectPK)new ObjectUuidPK(motColl.get(i).getId().toString()));
            motInfo.setEarlistWoktime(new Timestamp(motInfo.getEarlistWoktime().getTime() + 86400000L * betweenBegDays));
            motInfo.setEarlistCmpTime(new Timestamp(motInfo.getEarlistCmpTime().getTime() + 86400000L * betweenEndDays));
            motInfo.setLastWorktime(new Timestamp(motInfo.getLastWorktime().getTime() + 86400000L * betweenBegDays));
            motInfo.setLastCmpTime(new Timestamp(motInfo.getLastCmpTime().getTime() + 86400000L * betweenEndDays));
            if (mapPlanDate.get(motInfo.getOperationNo()) != null) {
                if (((Timestamp)mapPlanDate.get(motInfo.getOperationNo())).getTime() > motInfo.getEarlistWoktime().getTime()) {
                    mapPlanDate.put(motInfo.getOperationNo(), motInfo.getEarlistWoktime());
                }
            } else {
                mapPlanDate.put(motInfo.getOperationNo(), motInfo.getEarlistWoktime());
            }
            sql.setLength(0);
            sql.append(" update T_MM_MFTOrderTechnics set ");
            sql.append("FEarlistWoktime = ?, ");
            sql.append("FEarlistCmpTime = ?, ");
            sql.append("FLastWorktime = ?, ");
            sql.append("FLastCmpTime = ? ");
            sql.append(" where fid=?");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{motInfo.getEarlistWoktime(), motInfo.getEarlistCmpTime(), motInfo.getLastWorktime(), motInfo.getLastCmpTime(), motInfo.getId().toString()});
        }
        ManufactureOrderStockCollection stockColl = manuorder.getStocks();
        for (int i = 0; i < stockColl.size(); ++i) {
            mosInfo = (ManufactureOrderStockInfo)imos.getValue((IObjectPK)new ObjectUuidPK(stockColl.get(i).getId().toString()));
            mosInfo.setDemandTime((Timestamp)mapPlanDate.get(mosInfo.getOperationNo()));
            sql.setLength(0);
            sql.append(" update T_MM_MFTORDERSTOCK set FDemandTime = ? where fid=?");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{mosInfo.getDemandTime(), mosInfo.getId().toString()});
            sql.setLength(0);
            sql.append(" update t_im_materialreqbillentry set FDEMANDDATE=?");
            sql.append(" where fcorebillentryid =?");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{mapPlanDate.get(mosInfo.getOperationNo()), mosInfo.getId().toString()});
        }
        sql.setLength(0);
        sql.append(" update t_mm_manufactureorder set FPLANBEGINDATE=?,FPLANENDDATE=?");
        sql.append(" where fid =?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{newPlanBeginDate, newPlanEndDate, manuorder.getId().toString()});
    }

    protected void cancelManuOrder(Context ctx, ManufactureOrderInfo manuorder) throws BOSException, EASBizException {
        IManufactureOrder iManuOrder = ManufactureOrderFactory.getLocalInstance((Context)ctx);
        IManufactureOrderTechnics iManuOrderT = ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx);
        com.kingdee.eas.scm.common.BillBaseStatusEnum old = manuorder.getBaseStatus();
        manuorder.setBaseStatus(com.kingdee.eas.scm.common.BillBaseStatusEnum.CLOSED);
        iManuOrder.update((IObjectPK)new ObjectUuidPK(manuorder.getId().toString()), (CoreBaseInfo)manuorder);
        ManufactureOrderTechnicsCollection motColl = manuorder.getTechnics();
        ArrayList<String> lstIds = new ArrayList<String>();
        for (int i = 0; i < motColl.size(); ++i) {
            lstIds.add(motColl.get(i).getId().toString());
        }
        if (lstIds.size() > 0) {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_MM_MFTOrderTechnicsEx set fPendingFlag =").append(1).append(" , FPENDINGTIME = GETDATE(), FPENDINGEMPID ='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString()).append("' where fpid in ").append(this.getStringIDByList(lstIds));
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        if (this.changeMaterialReqBill(ctx, manuorder)) {
            manuorder.setBaseStatus(old);
            iManuOrder.update((IObjectPK)new ObjectUuidPK(manuorder.getId().toString()), (CoreBaseInfo)manuorder);
        }
    }

    protected boolean changeMaterialReqBill(Context ctx, ManufactureOrderInfo manuorder) throws EASBizException, BOSException {
        IRowSet rs = null;
        ManufactureOrderStockCollection stockColl = manuorder.getStocks();
        ManufactureOrderStockInfo mosInfo = null;
        boolean isRetBillCreated = false;
        for (int i = 0; i < stockColl.size(); ++i) {
            mosInfo = (ManufactureOrderStockInfo)ManufactureOrderStockFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(stockColl.get(i).getId().toString()));
            this.delNextBillFromStockID(ctx, mosInfo);
            rs = null;
            rs = this.getNextBillFromStockID(ctx, mosInfo, true);
            if (rs == null || rs.size() <= 0) continue;
            isRetBillCreated = isRetBillCreated || this.unNextBillFromStockID(ctx, mosInfo, rs);
        }
        return isRetBillCreated;
    }

    protected void delNextBillFromStockID(Context ctx, ManufactureOrderStockInfo stocksInfo) throws BOSException, EASBizException {
        IRowSet rs = this.getNextBillFromStockID(ctx, stocksInfo, false);
        IRowSet rs2 = null;
        StringBuffer sql = new StringBuffer();
        IMaterialReqBill iMrq = MaterialReqBillFactory.getLocalInstance((Context)ctx);
        IMaterialReqBillEntry iMrqEntry = MaterialReqBillEntryFactory.getLocalInstance((Context)ctx);
        IStockTransferPlanDetial iStockTransferPlanDetial = StockTransferPlanDetialFactory.getLocalInstance(ctx);
        IStockTransferBill iStockTransferBill = StockTransferBillFactory.getLocalInstance((Context)ctx);
        IStockTransferBillEntry iStockTransferBillEntry = StockTransferBillEntryFactory.getLocalInstance((Context)ctx);
        try {
            while (rs.next()) {
                String fid = rs.getString("fid");
                String fentryid = rs.getString("fentryid");
                String ftype = rs.getString("ftype");
                sql.setLength(0);
                if (ftype.equals("MRQBILL")) {
                    sql.append(" select fid from t_im_materialreqbillentry where fparentid = '").append(fid).append("'");
                    rs2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    if (rs2 != null && rs2.size() > 1) {
                        iMrqEntry.delete((IObjectPK)new ObjectUuidPK(fentryid));
                        continue;
                    }
                    iMrq.delete((IObjectPK)new ObjectUuidPK(fid));
                    continue;
                }
                if (ftype.equals("STOCKTRANSFERPLANDETIAL")) {
                    iStockTransferPlanDetial.delete((IObjectPK)new ObjectUuidPK(fid));
                    continue;
                }
                if (!ftype.equals("STOCKTRANSFERBILL")) continue;
                sql.append(" select fid from t_im_stocktransferbillentry where fparentid = '").append(fid).append("'");
                rs2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rs2 != null && rs2.size() > 1) {
                    iStockTransferBillEntry.delete((IObjectPK)new ObjectUuidPK(fentryid));
                    continue;
                }
                iStockTransferBill.delete((IObjectPK)new ObjectUuidPK(fid));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLDataException(e);
        }
    }

    protected IRowSet getNextBillFromStockID(Context ctx, ManufactureOrderStockInfo stocksInfo, boolean isaudit) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" Select fid,fentryid,fqty,fissueqty,fbasestatus,ftype from (\r\n ");
        sql.append(" Select h.fid as fid,d.fid as fentryid,d.fqty  as fqty, d.fissueqty as fissueqty,h.fbasestatus as fbasestatus, 'MRQBILL' as ftype \r\n ");
        sql.append(" from t_im_materialreqbill h \r\n ");
        sql.append(" inner join t_im_materialreqbillentry d on h.fid = d.fparentid \r\n ");
        sql.append(" where d.fcorebillentryid = '").append(stocksInfo.getId()).append("' \r\n ");
        if (isaudit) {
            sql.append(" and h.fbasestatus = 4 \r\n ");
            sql.append(" and d.fqty <> 0 \r\n ");
        } else {
            sql.append(" and h.fbasestatus in (0,1,2) \r\n ");
        }
        sql.append(" union \r\n ");
        sql.append(" Select a.fid as fid,a.fid as fentryid,a.CFSubmitQty as fqty,0 as fissueqty, a.cfbasestatus as fbasestatus,'STOCKTRANSFERPLANDETIAL' As ftype \r\n ");
        sql.append(" from CT_MO_StockTransferPlanDetial a \r\n ");
        sql.append(" where a.fsourcebillid = '").append(stocksInfo.getId()).append("' \r\n ");
        if (isaudit) {
            sql.append(" and a.CFSubmitTransferQty > 0 \r\n ");
        } else {
            sql.append(" and a.CFSubmitTransferQty = 0 \r\n ");
        }
        sql.append(" union \r\n ");
        sql.append(" Select h.fid as fid,d.fid as fentryid,d.fqty  as fqty,0 as fissueqty,h.fbasestatus as fbasestatus,'STOCKTRANSFERBILL' as ftype \r\n ");
        sql.append(" from t_im_stocktransferbill h \r\n ");
        sql.append(" inner join t_im_stocktransferbillentry d on h.fid = d.fparentid \r\n ");
        sql.append(" where d.fsourcebillentryid = '").append(stocksInfo.getId()).append("' \r\n ");
        if (isaudit) {
            sql.append(" and (h.fbasestatus = 4 or h.fbasestatus = 7 ) \r\n ");
            sql.append(" and d.fqty <> 0 \r\n ");
        } else {
            sql.append(" and h.fbasestatus in (0,1,2) \r\n ");
        }
        sql.append(") as totalbill order by totalbill.ftype asc, totalbill.fbasestatus asc ,totalbill.fissueqty desc ");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    protected IRowSet getMaterialReqBillFromStockID(Context ctx, ManufactureOrderStockInfo stocksInfo, boolean isaudit) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" Select h.fid as fid,d.fid as fentryid,d.fqty  as fqty, d.fissueqty as fissueqty, 'MRQBILL' as ftype \r\n ");
        sql.append(" from t_im_materialreqbill h \r\n ");
        sql.append(" inner join t_im_materialreqbillentry d on h.fid = d.fparentid \r\n ");
        sql.append(" where d.fcorebillentryid = '").append(stocksInfo.getId()).append("' \r\n ");
        if (isaudit) {
            sql.append(" and h.fbasestatus = 4 \r\n ");
            sql.append(" and d.fqty <> 0 \r\n ");
        } else {
            sql.append(" and h.fbasestatus in (0,1,2) \r\n ");
        }
        sql.append(" order by h.fbasestatus asc ,d.fissueqty desc ");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    protected boolean unNextBillFromStockID(Context ctx, ManufactureOrderStockInfo stocksInfo, IRowSet rs) throws BOSException, EASBizException {
        boolean isRetBillCreated = false;
        if (rs == null || rs.size() < 1) {
            return false;
        }
        try {
            while (rs.next()) {
                String fid = rs.getString("fid");
                String fentryid = rs.getString("fentryid");
                BigDecimal funQty = rs.getBigDecimal("fqty");
                String ftype = rs.getString("ftype");
                BigDecimal fissueqty = rs.getBigDecimal("fissueqty");
                if (ftype.equals("MRQBILL")) {
                    this.createRetMaterialReqBill(ctx, fid, fentryid, funQty, stocksInfo);
                    isRetBillCreated = true;
                    continue;
                }
                if (ftype.equals("STOCKTRANSFERPLANDETIAL")) {
                    this.updateStockTransferPlanDetial(ctx, fid, funQty, stocksInfo);
                    continue;
                }
                if (!ftype.equals("STOCKTRANSFERBILL")) continue;
                this.createRetStockTransferBill(ctx, fid, fentryid, funQty, stocksInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLDataException(e);
        }
        return isRetBillCreated;
    }

    protected void createRetMaterialReqBill(Context ctx, String fbillid, String fbillentryid, BigDecimal fRetqty, ManufactureOrderStockInfo stocksInfo) throws BOSException, EASBizException {
        TransactionTypeInfo transType;
        if (fbillid == null || "".equals(fbillid)) {
            return;
        }
        if (fbillentryid == null || "".equals(fbillentryid)) {
            return;
        }
        if (fRetqty == null || fRetqty.compareTo(new BigDecimal(0)) <= 0) {
            return;
        }
        BigDecimal fqty = fRetqty.multiply(new BigDecimal(-1));
        IMaterialReqBill iMrq = MaterialReqBillFactory.getLocalInstance((Context)ctx);
        MaterialReqBillInfo info = iMrq.getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK(fbillid));
        MaterialReqBillEntryInfo entryInfo = null;
        if (info.getEntry() != null && info.getEntry().size() > 0) {
            for (int i = 0; i < info.getEntry().size(); ++i) {
                if (!info.getEntry().get(i).getId().toString().equals(fbillentryid)) continue;
                entryInfo = info.getEntry().get(i);
                break;
            }
        }
        if (entryInfo == null) {
            return;
        }
        MaterialReqBillInfo copyinfo = (MaterialReqBillInfo)info.clone();
        BOSUuid reqid = BOSUuid.create((String)"500AB75E");
        copyinfo.setId(reqid);
        copyinfo.setBizDate(new Date());
        String transTypeNumber = TransactionType_Number_BACK;
        if (stocksInfo.getProvideType().getValue() == 10930) {
            transTypeNumber = TransactionType_Number_SPAN;
        }
        try {
            transType = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo("where number = '" + transTypeNumber + "'");
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getString(ctx, "SWLXTL_INFO") + transTypeNumber));
        }
        copyinfo.setTransactionType(transType);
        copyinfo.setBizType(info.getBizType());
        copyinfo.setBaseStatus(com.kingdee.eas.scm.common.BillBaseStatusEnum.ADD);
        copyinfo.setNumber(this.setAutoNumberByOrg(copyinfo, ctx));
        copyinfo.setSupplyStoreOrgUnit(copyinfo.getStorageOrgUnit());
        copyinfo.setAuditor(null);
        copyinfo.setAuditTime(null);
        copyinfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        copyinfo.setCreateTime(new Timestamp(new Date().getTime()));
        copyinfo.getEntry().clear();
        MaterialReqBillEntryInfo copyentryinfo = (MaterialReqBillEntryInfo)entryInfo.clone();
        MaterialReqBillEntryCollection entrycoll = new MaterialReqBillEntryCollection();
        BOSUuid entryid = BOSUuid.create((String)"11774BB4");
        copyentryinfo.setId(entryid);
        copyentryinfo.setQty(fqty);
        copyentryinfo.setIssueQty(fqty);
        copyentryinfo.setBaseIssueQty(fqty);
        copyentryinfo.put("actureQty", (Object)fqty);
        copyentryinfo.put("reqRemark", (Object)"");
        entrycoll.add(copyentryinfo);
        copyinfo.put("entry", (Object)entrycoll);
        copyinfo.put("priceInfo", null);
        IObjectPK pk = iMrq.save((CoreBaseInfo)copyinfo);
        this.generateBOTPRelation(ctx, "1D0D80DD", "500AB75E", stocksInfo.getParent().getId().toString(), pk.toString());
    }

    protected void updateStockTransferPlanDetial(Context ctx, String fbillid, BigDecimal fRetqty, ManufactureOrderStockInfo stocksInfo) throws BOSException, EASBizException {
        if (fbillid == null || "".equals(fbillid)) {
            return;
        }
        if (fRetqty == null || fRetqty.compareTo(new BigDecimal(0)) <= 0) {
            return;
        }
        BigDecimal fqty = fRetqty.multiply(new BigDecimal(-1));
        StringBuffer sql = new StringBuffer();
        sql.append(" update CT_MO_StockTransferPlandetial t \r\n ");
        sql.append(" set CFSubmitQty = CFSubmitQty - \r\n ").append(fRetqty);
        sql.append(" where fid = '").append(fbillid).append("' \r\n ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update CT_MO_StockTransferPlan ut set CFSubmitQty = CFSubmitQty - ").append(fRetqty).append(" \r\n");
        sql.append(" where exists(select 1 from t_bot_relation a where a.FSRCOBJECTID = '").append(fbillid).append("' and a.FDESTOBJECTID = ut.fid and a.FSRCENTITYID = '9CBCD44C' and a.FDESTENTITYID = '08B2670B')\r\n");
        sql.append(" and exists(Select 1 from CT_MO_StockTransferPlanDetial b where b.fid = '").append(fbillid).append("' and isnull(b.CFMATERIALID,'Null') = isnull(ut.cfmaterialid,'Null') \r\n");
        sql.append(" and isnull(b.CFPROJECTID,'Null') = isnull(ut.CFPROJECTID,'Null') ");
        sql.append(" and isnull(b.CFSTORAGEORGUNITID,'Null') = isnull(ut.CFSTORAGEORGUNITID,'Null') ");
        sql.append(" and isnull(b.CFSUPPLYSOUID,'Null') = isnull(ut.CFSUPPLYSOUID,'Null') ");
        sql.append(" and isnull(b.CFPROCESSFLOW,'Null') = isnull(ut.CFPROCESSFLOW,'Null') ");
        sql.append(" )\r\n");
        sql.append(" and isnull(ut.Fsourcefunction,'Null') = 'stocktransferplandetial' ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void createRetStockTransferBill(Context ctx, String fbillid, String fbillentryid, BigDecimal fRetqty, ManufactureOrderStockInfo stocksInfo) throws BOSException, EASBizException {
        if (fbillid == null || "".equals(fbillid)) {
            return;
        }
        if (fbillentryid == null || "".equals(fbillentryid)) {
            return;
        }
        if (fRetqty == null || fRetqty.compareTo(new BigDecimal(0)) <= 0) {
            return;
        }
        BigDecimal fqty = fRetqty.multiply(new BigDecimal(-1));
        Timestamp now = new Timestamp(new Date().getTime());
        UserInfo userinfo = (UserInfo)ctx.get((Object)"UserInfo");
        CoreBillBaseCollection coreBillBaseCol = new CoreBillBaseCollection();
        BOTMappingInfo botInfo = null;
        IBOTMapping botFac = BOTMappingFactory.getLocalInstance((Context)ctx);
        IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = null;
        StockTransferBillInfo stockTransferBillInfo = StockTransferBillFactory.getLocalInstance((Context)ctx).getStockTransferBillInfo((IObjectPK)new ObjectUuidPK(fbillid));
        StockTransferBillEntryInfo stockTransferBillEntryInfo = StockTransferBillEntryFactory.getLocalInstance((Context)ctx).getStockTransferBillEntryInfo((IObjectPK)new ObjectUuidPK(fbillentryid));
        StockTransferBillEntryCollection newentrycol = new StockTransferBillEntryCollection();
        StockTransferBillInfo newstockTransferBillInfo = (StockTransferBillInfo)stockTransferBillInfo.clone();
        newstockTransferBillInfo.setCreator(userinfo);
        newstockTransferBillInfo.setCreateTime(now);
        newstockTransferBillInfo.setLastUpdateUser(userinfo);
        newstockTransferBillInfo.setLastUpdateTime(now);
        newstockTransferBillInfo.setModificationTime(now);
        newstockTransferBillInfo.setDescription(this.getString(ctx, "SCBL_NAME"));
        stockTransferBillEntryInfo.setIssueQty(fRetqty);
        stockTransferBillEntryInfo.setQty(fRetqty);
        stockTransferBillEntryInfo.setBaseQty(fRetqty);
        stockTransferBillEntryInfo.put("transfernumber", (Object)fRetqty);
        newentrycol.add(stockTransferBillEntryInfo);
        newstockTransferBillInfo.put("entry", (Object)newentrycol);
        coreBillBaseCol.add((CoreBillBaseInfo)newstockTransferBillInfo);
        BOTMappingCollection botCol = botFac.getBOTMappingCollection("where name='INM-FDB' and extRule.isEffected=1  ");
        if (botCol.size() != 1) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getString(ctx, "NOTFIND_INM_FDB")));
        }
        botInfo = botCol.get(0);
        result = btp.transform(coreBillBaseCol, botInfo);
        BOTRelationCollection relations = result.getBOTRelationCollection();
        IObjectCollection bills = result.getBills();
        for (int a = 0; a < bills.size(); ++a) {
            StockTransferBillInfo bill = (StockTransferBillInfo)bills.getObject(a);
            btp.saveRelations((CoreBillBaseInfo)bill, relations);
            if (bill.getId() == null) continue;
            this.generateBOTPRelation(ctx, "1D0D80DD", "2239F30A", stocksInfo.getParent().getId().toString(), bill.getId().toString());
            String updateSQL = "update t_im_stocktransferbill set cftransfertypeid = '" + this.unStockTransferTypeID + "',flastupdateuserid = '" + userinfo.getId().toString() + "',fbasestatus = 1,fsourcebillid = '" + stocksInfo.getParent().getId().toString() + "',fsourcebilltypeid = null,cfdisstatus = '1' where fid = '" + bill.getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)updateSQL.toString());
        }
    }

    protected void subOrderQty(Context ctx, ManufactureOrderInfo manuorder) throws BOSException, EASBizException, SQLException {
        int i;
        ManufactureOrderTechnicsCollection techColl = manuorder.getTechnics();
        ManufactureOrderStockCollection stockColl = manuorder.getStocks();
        IManufactureOrderTechnics imot = ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx);
        IManufactureOrderStock imos = ManufactureOrderStockFactory.getLocalInstance((Context)ctx);
        IMaterialReqBill iMrq = MaterialReqBillFactory.getLocalInstance((Context)ctx);
        IMaterialReqBillEntry iMrqEntry = MaterialReqBillEntryFactory.getLocalInstance((Context)ctx);
        ArrayList motIDList = new ArrayList();
        ManufactureOrderTechnicsInfo motInfo = null;
        ManufactureOrderStockInfo mosInfo = null;
        StringBuffer sql = new StringBuffer();
        BigDecimal newPlannedQty = BigDecimal.ZERO;
        BigDecimal newOperQty = BigDecimal.ZERO;
        for (i = 0; i < techColl.size(); ++i) {
            motInfo = (ManufactureOrderTechnicsInfo)imot.getValue((IObjectPK)new ObjectUuidPK(techColl.get(i).getId().toString()));
            if (motInfo.getFinishedQty().compareTo(BigDecimal.ZERO) == 0 && motInfo.getPassQty().compareTo(BigDecimal.ZERO) == 0) {
                newOperQty = new BigDecimal(String.valueOf(motInfo.getOperQty().multiply(this.newQty.divide(this.oldQty, 6, RoundingMode.HALF_UP)).doubleValue()));
                sql.setLength(0);
                sql.append(" update T_MM_MFTOrderTechnics set FOPERQTY = " + newOperQty + " where fid='" + motInfo.getId() + "'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            techColl.set(i, motInfo);
        }
        for (i = 0; i < stockColl.size(); ++i) {
            mosInfo = (ManufactureOrderStockInfo)imos.getValue((IObjectPK)new ObjectUuidPK(stockColl.get(i).getId().toString()));
            newPlannedQty = new BigDecimal(String.valueOf(mosInfo.getPlannedQty().multiply(this.newQty.divide(this.oldQty, 6, RoundingMode.HALF_UP)).doubleValue()));
            sql.setLength(0);
            sql.append(" update T_MM_MFTORDERSTOCK set FPLANNEDQTY = " + newPlannedQty + " where fid='" + mosInfo.getId() + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            mosInfo.setPlannedQty(newPlannedQty);
            stockColl.set(i, mosInfo);
        }
        IRowSet rs = null;
        Object rs2 = null;
        StringBuffer sql2 = new StringBuffer();
        BigDecimal c = BigDecimal.ZERO;
        int fcount = 0;
        block2: for (int i2 = 0; i2 < stockColl.size(); ++i2) {
            rs = null;
            sql.setLength(0);
            sql.append(" Select sum(d.fissueqty) as fissueqty  ,count(*) as fcount \r\n ");
            sql.append(" from t_im_materialreqbill h \r\n ");
            sql.append(" inner join t_im_materialreqbillentry d on h.fid = d.fparentid \r\n ");
            sql.append(" where d.fcorebillentryid = '").append(stockColl.get(i2).getId()).append("' \r\n ");
            sql.append(" and h.fbasestatus in (0,1,2,4) \r\n ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs == null || rs.size() <= 0) continue;
            block3: while (rs.next() && rs.getBigDecimal("fissueqty") != null) {
                String ftype;
                BigDecimal fissueQty;
                BigDecimal funQty;
                String fentryid;
                String fid;
                c = rs.getBigDecimal("fissueqty").subtract(stockColl.get(i2).getPlannedQty());
                fcount = rs.getInt("fcount");
                if (rs.getBigDecimal("fissueqty").compareTo(stockColl.get(i2).getPlannedQty()) != 1) continue;
                rs = null;
                rs = this.getMaterialReqBillFromStockID(ctx, stockColl.get(i2), false);
                if (rs != null && rs.size() > 0) {
                    while (rs.next()) {
                        fid = rs.getString("fid");
                        fentryid = rs.getString("fentryid");
                        funQty = rs.getBigDecimal("fqty");
                        fissueQty = rs.getBigDecimal("fissueqty");
                        ftype = rs.getString("ftype");
                        if (ftype.equals("MRQBILL")) {
                            if (fcount == 1) {
                                sql2.setLength(0);
                                sql2.append(" update t_im_materialreqbillentry set fissueqty = ");
                                sql2.append(stockColl.get(i2).getPlannedQty());
                                sql2.append(", fqty = ");
                                sql2.append(stockColl.get(i2).getPlannedQty());
                                sql2.append(" where fid ='");
                                sql2.append(fentryid);
                                sql2.append("'");
                                DbUtil.execute((Context)ctx, (String)sql2.toString());
                                break;
                            }
                            if (c.compareTo(fissueQty) >= 0) {
                                iMrqEntry.delete((IObjectPK)new ObjectUuidPK(fentryid));
                                if (iMrq.getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK(fid)).getEntries() == null || iMrq.getMaterialReqBillInfo((IObjectPK)new ObjectUuidPK(fid)).getEntries().size() == 0) {
                                    iMrq.delete((IObjectPK)new ObjectUuidPK(fid));
                                }
                            } else {
                                sql2.setLength(0);
                                sql2.append(" update t_im_materialreqbillentry set fissueqty = fissueqty - ");
                                sql2.append(c);
                                sql2.append(" where fid ='");
                                sql2.append(fentryid);
                                sql2.append("'");
                                DbUtil.execute((Context)ctx, (String)sql2.toString());
                            }
                            c = c.subtract(fissueQty);
                        }
                        if (c.compareTo(BigDecimal.ZERO) > 0) continue;
                        break;
                    }
                }
                if (c.compareTo(BigDecimal.ZERO) <= 0) continue block2;
                rs = null;
                rs = this.getMaterialReqBillFromStockID(ctx, stockColl.get(i2), true);
                if (rs == null || rs.size() <= 0) continue;
                while (rs.next()) {
                    fid = rs.getString("fid");
                    fentryid = rs.getString("fentryid");
                    funQty = rs.getBigDecimal("fqty");
                    fissueQty = rs.getBigDecimal("fissueqty");
                    ftype = rs.getString("ftype");
                    if (ftype.equals("MRQBILL")) {
                        if (c.compareTo(fissueQty) >= 0) {
                            this.createRetMaterialReqBill(ctx, fid, fentryid, funQty, stockColl.get(i2));
                        } else {
                            this.createRetMaterialReqBill(ctx, fid, fentryid, funQty.subtract(c), stockColl.get(i2));
                        }
                        c = c.subtract(fissueQty);
                    }
                    if (c.compareTo(BigDecimal.ZERO) > 0) continue;
                    continue block3;
                }
            }
        }
    }

    protected void addOrderQty(Context ctx, ManufactureOrderInfo manuorder) throws BOSException, EASBizException {
        int i;
        ManufactureOrderTechnicsCollection techColl = manuorder.getTechnics();
        ManufactureOrderStockCollection stockColl = manuorder.getStocks();
        IManufactureOrderTechnics imot = ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx);
        IManufactureOrderStock imos = ManufactureOrderStockFactory.getLocalInstance((Context)ctx);
        IMaterialReqBill iMrq = MaterialReqBillFactory.getLocalInstance((Context)ctx);
        IMaterialReqBillEntry iMrqEntry = MaterialReqBillEntryFactory.getLocalInstance((Context)ctx);
        IEMMGenerateMRBByMOFacade iGenMRBByMo = EMMGenerateMRBByMOFacadeFactory.getLocalInstance(ctx);
        IParamControl ipc = null != ctx ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = null;
        HashMap<Integer, String> mapParamVal = new HashMap<Integer, String>();
        HashMap<Integer, ManufactureOrderTechnicsInfo> mapTechnics = new HashMap<Integer, ManufactureOrderTechnicsInfo>();
        ManufactureOrderTechnicsInfo motInfo = null;
        ManufactureOrderStockInfo mosInfo = null;
        StringBuffer sql = new StringBuffer();
        BigDecimal newDemandQty = BigDecimal.ZERO;
        for (i = 0; i < techColl.size(); ++i) {
            motInfo = (ManufactureOrderTechnicsInfo)imot.getValue((IObjectPK)new ObjectUuidPK(techColl.get(i).getId().toString()));
            newDemandQty = new BigDecimal(String.valueOf(motInfo.getOperQty().multiply(this.newQty.divide(this.oldQty, 6, RoundingMode.HALF_UP)).doubleValue()));
            if (motInfo.getFinishedQty().compareTo(BigDecimal.ZERO) == 0 && motInfo.getPassQty().compareTo(BigDecimal.ZERO) == 0) {
                sql.setLength(0);
                sql.append(" update T_MM_MFTOrderTechnics set FOPERQTY = " + newDemandQty + " where fid='" + motInfo.getId() + "'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            } else {
                if (EntryBaseStatusEnum.COMPLETION.equals((Object)motInfo.getBaseStatus())) {
                    motInfo.setBaseStatus(EntryBaseStatusEnum.MOSTCOMPLETION);
                }
                sql.setLength(0);
                sql.append(" update T_MM_MFTOrderTechnics set FOPERQTY = " + newDemandQty + ", fbasestatus=" + motInfo.getBaseStatus().getValue() + " where fid='" + motInfo.getId() + "'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            motInfo.setOperQty(newDemandQty);
            pk = new ObjectUuidPK(motInfo.getStorageOrgUnit().getId());
            mapParamVal.put(motInfo.getOperationNo(), "false");
            mapTechnics.put(motInfo.getOperationNo(), motInfo);
            techColl.set(i, motInfo);
        }
        for (i = 0; i < stockColl.size(); ++i) {
            mosInfo = (ManufactureOrderStockInfo)imos.getValue((IObjectPK)new ObjectUuidPK(stockColl.get(i).getId().toString()));
            newDemandQty = new BigDecimal(String.valueOf(mosInfo.getPlannedQty().multiply(this.newQty.divide(this.oldQty, 6, RoundingMode.HALF_UP)).doubleValue()));
            sql.setLength(0);
            sql.append(" update T_MM_MFTORDERSTOCK set FPLANNEDQTY = " + newDemandQty + " where fid='" + mosInfo.getId() + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            mosInfo.setPlannedQty(newDemandQty);
            if (mapParamVal.get(mosInfo.getOperationNo()) == null || "".equals(mapParamVal.get(mosInfo.getOperationNo())) || !"true".equals(mapParamVal.get(mosInfo.getOperationNo())) && !"TRUE".equals(mapParamVal.get(mosInfo.getOperationNo()))) continue;
            iGenMRBByMo.generateMRBByMO(mosInfo, (ManufactureOrderTechnicsInfo)mapTechnics.get(mosInfo.getOperationNo()), manuorder);
        }
    }

    protected void generateBOTPRelation(Context ctx, String sourceBillType, String destBillType, String sourceBillID, String destBillID) throws BOSException, EASBizException {
        String curUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        SQLUtils.execute((Context)ctx, (String)sql_BOTPRelation.replace("CURDate()", "now()"), (Object[])new Object[]{sourceBillType, destBillType, sourceBillID, destBillID, curUserID});
    }

    protected String setAutoNumberByOrg(MaterialReqBillInfo maReqInfo, Context ctx) throws EASBizException {
        try {
            String orgid = null;
            orgid = maReqInfo.getSupplyStoreOrgUnit().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (iCodingRuleManager.isExist((IObjectValue)maReqInfo, orgid)) {
                return iCodingRuleManager.getNumber((IObjectValue)maReqInfo, orgid);
            }
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getString(ctx, "CSLLCQDBM_ERROR")), (Throwable)e);
        }
        return null;
    }

    protected String getStringIDByList(List idList) {
        StringBuffer strBuf = new StringBuffer();
        Iterator it = idList.iterator();
        strBuf.append("(");
        while (it.hasNext()) {
            strBuf.append("'");
            strBuf.append(it.next());
            strBuf.append("',");
        }
        if (strBuf.length() != "(".length()) {
            strBuf.deleteCharAt(strBuf.length() - 1);
            strBuf.append(")");
        } else {
            strBuf.append(")");
        }
        return strBuf.toString();
    }

    public static long getDaySub(Date beginDate, Date endDate) {
        Calendar calst = Calendar.getInstance();
        Calendar caled = Calendar.getInstance();
        calst.setTime(beginDate);
        caled.setTime(endDate);
        calst.set(11, 0);
        calst.set(12, 0);
        calst.set(13, 0);
        caled.set(11, 0);
        caled.set(12, 0);
        caled.set(13, 0);
        int days = ((int)(caled.getTime().getTime() / 1000L) - (int)(calst.getTime().getTime() / 1000L)) / 3600 / 24;
        return days;
    }

    protected void auditChangeBill(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        EMMManufactureOrderChangeInfo mocInfo = (EMMManufactureOrderChangeInfo)model;
        this.checkDataByAudit(ctx, mocInfo);
        EMMManufactureOrderChangeEntryCollection entryColl = mocInfo.getEntrys();
        ManufactureOrderInfo moInfo = null;
        EMMManufactureOrderChangeEntryInfo emmMOCEntryInfo = null;
        StringBuffer sql = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < entryColl.size(); ++i) {
            emmMOCEntryInfo = entryColl.get(i);
            moInfo = emmMOCEntryInfo.getManuOrder();
            BigDecimal fnewQty = emmMOCEntryInfo.getNewQty();
            Date fnewPlanBeginDate = emmMOCEntryInfo.getNewPlanBeginDate();
            Date fnewPlanEndDate = emmMOCEntryInfo.getNewPlanEndDate();
            HashMap<String, Object> inparam = new HashMap<String, Object>();
            inparam.put("manuOrderID", moInfo.getId());
            inparam.put("newQty", fnewQty);
            inparam.put("newBeginPlanDate", sdf.format(fnewPlanBeginDate));
            inparam.put("newEndPlanDate", sdf.format(fnewPlanEndDate));
            Map returnMap = EMMManufactureOrderEntrysGenFacadeFactory.getLocalInstance((Context)ctx).changeOrderQtyAndDate(inparam);
            if (returnMap.get("issuccess").toString().equals("1")) continue;
            String ferrorRerurn = "";
            if (returnMap.get("result") != null) {
                ferrorRerurn = returnMap.get("result").toString();
            }
            throw new EASBizException(new NumericExceptionSubItem(this.getString(ctx, "BGDSH_FAIL"), ferrorRerurn));
        }
        UserInfo userinfo = null;
        userinfo = (UserInfo)ctx.get((Object)"UserInfo");
        sql.append(" update T_MO_EMMManufactureOrderChange set Fbillbasestatus =4 , Fauditorid='" + userinfo.getId() + "' , Faudittime = sysdate where fid= '" + mocInfo.getId() + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void checkDataByAudit(Context ctx, EMMManufactureOrderChangeInfo info) throws EASBizException, BOSException {
        if (info == null || info.getId() == null) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getString(ctx, "BGDWBC_INFO"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (info.getBillBaseStatus() == null || !info.getBillBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getString(ctx, "BGDBSTJZT_INFO"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (info.getEntrys() == null || info.getEntrys().size() < 1) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getString(ctx, "BGDWFLXX_INFO"));
            throw new InterfaceDataBaseException(interfaceException);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Select mo.fid as fmanuorderid,mo.fnumber as fmanuordernumber, ");
        sql.append(" cd.foldqty, ");
        sql.append(" to_char(cd.foldplanbegindate,'yyyy-MM-dd') as foldplanbegindate, ");
        sql.append(" to_char(cd.foldplanenddate,'yyyy-MM-dd') as foldplanenddate, ");
        sql.append(" cd.fnewqty, ");
        sql.append(" to_char(cd.fnewplanbegindate,'yyyy-MM-dd') as fnewplanbegindate, ");
        sql.append(" to_char(cd.fnewplanenddate,'yyyy-MM-dd') as fnewplanenddate, ");
        sql.append(" mo.fqty as forderqty, ");
        sql.append(" to_char(mo.fplanbegindate,'yyyy-MM-dd') as fplanbegindate, ");
        sql.append(" to_char(mo.fplanenddate,'yyyy-MM-dd') as fplanenddate ");
        sql.append(" from T_MO_EMMManufactureOrderChange ch ");
        sql.append(" inner join T_MO_EMMMOCE cd on ch.fid = cd.fparentid ");
        sql.append(" left outer join t_mm_manufactureorder mo on mo.fid = cd.FManuOrderID and mo.fmaterialid = cd.fmaterialid ");
        sql.append(" where ch.fid = '" + info.getId() + "' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            ArrayList<String> hasIDList = new ArrayList<String>();
            while (rs.next()) {
                if (rs.getString("fmanuorderid") == null) {
                    NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getString(ctx, "BGDFLMYDYDSCDD_INFO"));
                    throw new InterfaceDataBaseException(interfaceException);
                }
                String manuNumber = rs.getString("fmanuordernumber");
                if (hasIDList.contains(rs.getString("fmanuorderid"))) {
                    NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getString(ctx, "TYSCDD_INFO") + "[" + manuNumber + "]" + this.getString(ctx, "CZDHFL_INFO"));
                    throw new InterfaceDataBaseException(interfaceException);
                }
                hasIDList.add(rs.getString("fmanuorderid"));
                BigDecimal foldqty = rs.getBigDecimal("foldqty");
                BigDecimal fnewqty = rs.getBigDecimal("fnewqty");
                BigDecimal forderqty = rs.getBigDecimal("forderqty");
                String foldplanbegindate = rs.getString("foldplanbegindate");
                String foldplanenddate = rs.getString("foldplanenddate");
                String fnewplanbegindate = rs.getString("fnewplanbegindate");
                String fnewplanenddate = rs.getString("fnewplanenddate");
                String fplanbegindate = rs.getString("fplanbegindate");
                String fplanenddate = rs.getString("fplanenddate");
                if (fnewqty == null) {
                    fnewqty = BigDecimal.ZERO;
                }
                if (foldqty.compareTo(forderqty) != 0) {
                    NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getString(ctx, "MANUFACTURE_INFO") + "[" + manuNumber + "]" + this.getString(ctx, "YSL_INFO") + "[" + foldqty + "]" + this.getString(ctx, "YZXSL_INFO") + "[" + forderqty + "]" + this.getString(ctx, "QHDSJ_INFO"));
                    throw new InterfaceDataBaseException(interfaceException);
                }
                if (!foldplanenddate.equals(fplanenddate)) {
                    NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getString(ctx, "MANUFACTURE_INFO") + "[" + manuNumber + "]" + this.getString(ctx, "YJHWGRQ_INFO") + "[" + foldplanenddate + "]" + this.getString(ctx, "YZXJHWGRQ_INFO") + "[" + fplanenddate + "]" + this.getString(ctx, "QHDSJ_INFO"));
                    throw new InterfaceDataBaseException(interfaceException);
                }
                if (!foldplanbegindate.equals(fplanbegindate)) {
                    NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getString(ctx, "MANUFACTURE_INFO") + "[" + manuNumber + "]" + this.getString(ctx, "YJHKGRQ_INFO") + "[" + foldplanbegindate + "]" + this.getString(ctx, "YZXJHKGRQ_INFO") + "[" + fplanbegindate + "]" + this.getString(ctx, "QHDSJ_INFO"));
                    throw new InterfaceDataBaseException(interfaceException);
                }
                if (fnewplanbegindate == null || fnewplanbegindate.equals("") || fnewplanbegindate.equals("0000-00-00")) {
                    NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getString(ctx, "MANUFACTURE_INFO") + "[" + manuNumber + "]" + this.getString(ctx, "XJHKGRQ_ISNULL"));
                    throw new InterfaceDataBaseException(interfaceException);
                }
                if (fnewplanenddate == null || fnewplanenddate.equals("") || fnewplanenddate.equals("0000-00-00")) {
                    NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getString(ctx, "MANUFACTURE_INFO") + "[" + manuNumber + "]" + this.getString(ctx, "XJHWGRQ_ISNULL"));
                    throw new InterfaceDataBaseException(interfaceException);
                }
                if (fnewplanbegindate.compareTo(fnewplanenddate) > 0) {
                    NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getString(ctx, "MANUFACTURE_INFO") + "[" + manuNumber + "]" + this.getString(ctx, "XJHWGRQ_INFO") + "[" + fnewplanenddate + "]" + this.getString(ctx, "XYXJHKGRQ_INFO") + "[" + fnewplanbegindate + "]\uff0c" + this.getString(ctx, "BYXSH_INFO"));
                    throw new InterfaceDataBaseException(interfaceException);
                }
                if (foldqty.compareTo(fnewqty) != 0 || !fnewplanbegindate.equals(foldplanbegindate) || !fnewplanenddate.equals(foldplanenddate)) continue;
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", this.getString(ctx, "MANUFACTURE_INFO") + "[" + manuNumber + "]" + this.getString(ctx, "XJSLBCZBDSJ_INFO"));
                throw new InterfaceDataBaseException(interfaceException);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    static {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into T_BOT_Relation(\r\n");
        sql.append("FID,\r\n");
        sql.append("FSRCEntityID,\r\n");
        sql.append("FDESTEntityID,\r\n");
        sql.append("FSRCObjectID,\r\n");
        sql.append("FDESTObjectID,\r\n");
        sql.append("FDate,\r\n");
        sql.append("FOperatorID,\r\n");
        sql.append("FIsEffected,\r\n");
        sql.append("FBOTMappingID,\r\n");
        sql.append("FType\r\n");
        sql.append(")\r\n");
        sql.append("Values(\r\n");
        sql.append("NewBOSID('").append(new BOTRelation().getType().toString()).append("'),\r\n");
        sql.append("?,\r\n");
        sql.append("?,\r\n");
        sql.append("?,\r\n");
        sql.append("?,\r\n");
        sql.append("CURDate(),\r\n");
        sql.append("?,\r\n");
        sql.append("1,\r\n");
        sql.append("Null,\r\n");
        sql.append("0\r\n");
        sql.append(")\r\n");
        sql_BOTPRelation = sql.toString();
    }
}

