/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.emm.mo.EMMManufactureOrderCTL;
import com.kingdee.eas.emm.mo.EMMManufactureOrderFlowCTL;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillFactory;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillInfo;
import com.kingdee.eas.industry.emm.mo.EMMManufactureOrderEntrysGenFacadeFactory;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.lot.LotParamValueInfo;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.MOUtil;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.MOUpdaterMOOrder;
import com.kingdee.eas.mm.mo.app.MOUpdaterSaleOrder;
import com.kingdee.eas.mm.mo.app.service.order.AuditService;
import com.kingdee.eas.mm.project.WBSTypeEnum;
import com.kingdee.eas.mm.project.app.WriteBackWBSFacadeControllerBean;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class EmmAuditService
extends AuditService {
    private static final long serialVersionUID = -4402533011777993688L;

    public void afterHandle() throws BOSException, EASBizException {
        if (this.batchResults.getToDoIdsArray().length > 0) {
            String idStr = SQLUtil.setToString((Set)this.batchResults.getToDoIdsSet());
            EMMManufactureOrderCTL.updateRowStatus(this.ctx, EntryBaseStatusEnum.AUDITED, idStr);
            List idList = new ArrayList();
            idList = this.batchResults.getToDoIdsList();
            EMMManufactureOrderEntrysGenFacadeFactory.getLocalInstance((Context)this.ctx).setTechnicsMergeID(idList, false);
            this.backWriteRestructBill(this.batchResults.getToDoIdsArray());
        }
    }

    private void backWriteRestructBill(String[] ids) throws BOSException, EASBizException {
        for (int n = 0; n < ids.length; ++n) {
            ManufactureOrderInfo orderinfo = ManufactureOrderFactory.getLocalInstance((Context)this.ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(ids[n]));
            BillTypeInfo billtypeinfo = null;
            String restructBillid = orderinfo.getSourceBillId();
            if (orderinfo.getSourceBillType() != null) {
                billtypeinfo = BillTypeFactory.getLocalInstance((Context)this.ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK(orderinfo.getSourceBillType().getId().toString()));
            }
            if (restructBillid == null || billtypeinfo == null || !"675".equals(billtypeinfo.getNumber())) continue;
            RestructReqBillInfo info = RestructReqBillFactory.getLocalInstance(this.ctx).getRestructReqBillInfo((IObjectPK)new ObjectUuidPK(restructBillid));
            BigDecimal retructedqty = info.getRetructedqty() == null ? BigDecimal.ZERO : info.getRetructedqty();
            BigDecimal qty = retructedqty.add(orderinfo.getQty());
            info.setRetructedqty(qty);
            if (qty.compareTo(info.getCtructqty()) > 0) {
                throw new ManufactureOrderException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"ERROR_FLAG", (Locale)this.ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"FXGZSQD_INFO", (Locale)this.ctx.getLocale())));
            }
            RestructReqBillFactory.getLocalInstance(this.ctx).update((IObjectPK)new ObjectUuidPK(restructBillid), (CoreBaseInfo)info);
        }
    }

    public void doCheck() throws BOSException, EASBizException {
        HashSet orderSet = (HashSet)this.batchResults.getToDoIdsSet();
        IObjectCollection col = this.batchResults.getObjCollection();
        String msg = null;
        ManufactureOrderCollection orderCollection = null;
        IManufactureOrder order = ManufactureOrderFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        ev.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orderSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        orderCollection = col != null ? (ManufactureOrderCollection)col : order.getManufactureOrderCollection(ev);
        MaterialInfo materialInfo = null;
        ManufactureOrderInfo mo = null;
        StorageOrgUnitInfo storageOrgUnit = null;
        for (int i = 0; i < orderCollection.size(); ++i) {
            mo = (ManufactureOrderInfo)orderCollection.getObject(i);
            materialInfo = mo.getMaterial();
            storageOrgUnit = mo.getStorageOrgUnit();
            String id = mo.getId().toString();
            if (storageOrgUnit == null || materialInfo == null) continue;
            boolean isIsLotNumber = this.getIsIsLotNumber(this.ctx, materialInfo, storageOrgUnit);
            LotFrame lotFrame = new LotFrame();
            lotFrame.setMainBizOrg(storageOrgUnit.getId().toString());
            lotFrame.setMaterial(materialInfo.getId().toString());
            List lotList = new ArrayList<LotFrame>();
            lotList.add(lotFrame);
            lotList = LotRuleFactory.getLocalInstance((Context)this.ctx).fillLotFramesNoSerial(lotList);
            lotFrame = lotList == null ? null : (lotList.size() == 0 ? null : (LotFrame)lotList.get(0));
            boolean isLotRule = false;
            if (lotFrame != null && lotFrame.getLotRule() != null) {
                isLotRule = true;
            }
            LotParamValueInfo lotParamInfo = LotFacadeFactory.getLocalInstance((Context)this.ctx).getLotParamValueByOrg(storageOrgUnit.getId().toString());
            boolean isManufacturePlan = lotParamInfo.isManufacturePlan();
            boolean isManufactureOrder = lotParamInfo.isManufactureOrder();
            if (!isIsLotNumber) continue;
            if (isLotRule) {
                if (isManufacturePlan) {
                    if (mo.getLot() != null && !mo.getLot().trim().equals("")) continue;
                    msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "LOT_NOT_NULL");
                    this.batchResults.addError(id, msg);
                    continue;
                }
                if (!isManufactureOrder || mo.getLot() != null && !mo.getLot().trim().equals("")) continue;
                msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "LOT_NOT_NULL");
                this.batchResults.addError(id, msg);
                continue;
            }
            if (isManufacturePlan) {
                if (mo.getLot() != null && !mo.getLot().trim().equals("")) continue;
                msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "LOT_NOT_NULL");
                this.batchResults.addError(id, msg);
                continue;
            }
            if (!isManufactureOrder || mo.getLot() != null && !mo.getLot().trim().equals("")) continue;
            msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "LOT_NOT_NULL");
            this.batchResults.addError(id, msg);
        }
        this.auditBatchCheck(this.ctx, this.batchResults);
    }

    public void doIt() throws BOSException, EASBizException {
        this.afterAudit(this.ctx, this.batchResults);
        this.afterAuditWriteBackWBS(this.ctx, this.batchResults, 103);
        LotFacadeFactory.getLocalInstance((Context)this.ctx).manufactuerOrderInsertLotSource(this.batchResults.getToDoIdsArray());
    }

    private void afterAudit(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        String[] sqls = new String[5];
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_MM_ManufactureOrder ").append("set FUnToStoreQty =  FExtraUpperLimit-FToStroreQty-FTotalDirectSendQty,FUnToStoreBaseQty = FExtraUpperLimitBase-FToStoreBaseQty-FTotalDirectSendBaseQty  ").append("where FID in (").append(idStr).append(") ").append("and FIsUnlimitedQty=0 ");
        sqls[0] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_ManufactureOrder ").append("set FUnToStoreQty = FQty-FTotalSplitQty-FToStroreQty-FTotalDirectSendQty,FUnToStoreBaseQty = FBaseQty-FTotalSplitBaseQty-FToStoreBaseQty-FTotalDirectSendBaseQty ").append("where FID in (").append(idStr).append(") ").append("and FIsUnlimitedQty=1 ");
        sqls[1] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_MFTOrderStock as t0 ").append("set (FUnIssueQty,FUnIssueBaseQty,FAssociateQty) = ").append("(select  t0.FPlannedQty-t0.FActIssueQty+t0.FRejectedQty,t0.FPlannedBaseQty-t0.FActIssueBaseQty+t0.FRejectedBaseQty,").append("round(to_decimal(t0.FPlannedBaseQty * to_decimal((1+FExtraRatio/100),21,8),21,8),b1.FQtyPrecision)-t0.FActIssueBaseQty ").append("from t_bd_multimeasureunit  b1 ").append("where t0.FMaterialID = b1.FMaterialID and t0.FBaseUnitID = b1.fmeasureunitid ").append("and t0.FParentID in (").append(idStr).append(") ").append(")\r\n");
        updateSql.append("Where\r\n");
        updateSql.append("1=1\r\n");
        updateSql.append("And t0.FParentID In (\r\n");
        updateSql.append(idStr);
        updateSql.append(")\r\n");
        sqls[2] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_MFTOrderTechnics ").append("set FUnFinishQty = FQty,FUnFinishBaseQty = FBaseQty, ").append("    FUnMoveOutQty = FQty,FUnMoveOutBaseQty = FBaseQty, ").append("    FUnTestQty = FQty,FUnTestBaseQty = FBaseQty ").append(",FUnDispatchQty = FQTY - FTotalSplitQty - FTotalDispatchQty ").append("where FParentID in (").append(idStr).append(") ");
        sqls[3] = updateSql.toString();
        updateSql.setLength(0);
        updateSql.append("update T_MM_MFTOrderTechnics as t0  ").append("set (FIntoQty,FIntoBaseQty) = ").append("(select t0.FQty,t0.FBaseQty ").append("from T_MM_ManufactureOrder t1 ").append("where t1.FFirstOperNo = t0.FOperationNo ").append("and t1.FID = t0.FParentID ").append("and t1.FID in (").append(idStr).append(") ").append(") \r\n");
        sqls[4] = updateSql.toString();
        try {
            SQLUtil.batchExecuteSql((Context)ctx, (String[])sqls);
        }
        catch (BOSException bosException) {
            Throwable throwable = bosException.getCause();
            if (throwable instanceof SQLException) {
                String sqlState = ((SQLException)throwable).getSQLState();
                String message = ((SQLException)throwable).getMessage();
                if (sqlState != null && sqlState.equalsIgnoreCase("22003")) {
                    throw new ManufactureOrderException(ManufactureOrderException.NUMERIC_VALUE_OUT_OF_RANGE);
                }
                if (message != null && message.toLowerCase().indexOf("numeric") > -1) {
                    throw new ManufactureOrderException(ManufactureOrderException.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
            throw bosException;
        }
    }

    private boolean getIsIsLotNumber(Context ctx, MaterialInfo materialInfo, StorageOrgUnitInfo storageOrgUnit) throws EASBizException, BOSException {
        MaterialInventoryInfo materialInv;
        SCMEntryDataVO vo = new SCMEntryDataVO();
        SCMEntryDataVO voResult = new SCMEntryDataVO();
        vo.setMaterialInfos(new MaterialInfo[]{materialInfo});
        vo.setStorageOrgUnitInfos(new StorageOrgUnitInfo[]{storageOrgUnit});
        vo.setIsLoadingMaterialPlan(true);
        vo.setIsLoadingMaterialInventory(true);
        vo.setIsLoadingMaterialInfo(false);
        voResult = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(vo);
        String key = materialInfo.getId().toString() + storageOrgUnit.getId().toString();
        Map miInfoMap = voResult.getMaterialInventoryInfos();
        return miInfoMap != null && miInfoMap.get(key) != null && (materialInv = (MaterialInventoryInfo)voResult.getMaterialInventoryInfos().get(key)).isIsLotNumber();
    }

    private void auditBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
        batchResults = MOUtil.checkMOClose((Context)ctx, (BatchActionResults)batchResults, (String)idStr, (String)"T_MM_ManufactureOrder", (BatchActionEnum)BatchActionEnum.AUDIT);
        MOUpdaterSaleOrder billUpdater = new MOUpdaterSaleOrder(ctx);
        billUpdater.setBatchResults(batchResults);
        billUpdater.setAuditAction(true);
        billUpdater.execute();
        billUpdater = new MOUpdaterMOOrder(ctx);
        billUpdater.setBatchResults(batchResults);
        billUpdater.setAuditAction(true);
        billUpdater.execute();
    }

    private void afterAuditWriteBackWBS(Context ctx, BatchActionResults batchResults, int bizAction) throws BOSException, EASBizException {
        StringBuffer tempTableSql = new StringBuffer();
        tempTableSql.append("CREATE TABLE TEMP_WRITEBACKWBS (").append("FBizDate DATETIME,").append("FPROJECTID VARCHAR(44),").append("FMaterialID VARCHAR(44),").append("FTrackNumberID VARCHAR(44),").append("FStorageOrgUnitID VARCHAR(44) )");
        String tempTableName = "";
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(tempTableSql.toString());
            String idStr = SQLUtil.arrayToString((Object[])batchResults.getToDoIdsArray());
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("INSERT INTO ").append(tempTableName).append(" (FBizDate,FPROJECTID,FMaterialID,FTrackNumberID,FStorageOrgUnitID) ");
            insertSql.append("SELECT\r\n");
            insertSql.append("M1.FAUDITTIME FBIZDATE,\r\n");
            insertSql.append("M1.FPROJECTID,\r\n");
            insertSql.append("M1.FMATERIALID,\r\n");
            insertSql.append("M1.FTRACKID,\r\n");
            insertSql.append("M1.FSTORAGEORGUNITID\r\n");
            insertSql.append("FROM\r\n");
            insertSql.append("T_MM_MANUFACTUREORDER M\r\n");
            insertSql.append("INNER JOIN T_MM_MANUFACTUREORDER M1\r\n");
            insertSql.append("ON 1=1\r\n");
            insertSql.append("AND M.FPROJECTID=M1.FPROJECTID\r\n");
            insertSql.append("AND M.FMATERIALID=M1.FMATERIALID\r\n");
            insertSql.append("AND M.FSTORAGEORGUNITID=M1.FSTORAGEORGUNITID\r\n");
            insertSql.append("AND ((\r\n");
            insertSql.append("M.FTRACKID IS NULL\r\n");
            insertSql.append("AND M1.FTRACKID IS NULL\r\n");
            insertSql.append(") OR M.FTRACKID=M1.FTRACKID\r\n");
            insertSql.append(")\r\n");
            insertSql.append("AND M1.FBASESTATUS=").append(4).append("\r\n");
            insertSql.append("WHERE\r\n");
            insertSql.append("1=1\r\n");
            insertSql.append("AND M.FID IN (").append(idStr).append(")\r\n");
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            WriteBackWBSFacadeControllerBean wbsFacade = new WriteBackWBSFacadeControllerBean();
            wbsFacade.batchWriteBackByDate(ctx, tempTableName, bizAction, WBSTypeEnum.MANUFACTURE);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tempTableName != null) {
                TempTablePool pool = TempTablePool.getInstance((Context)ctx);
                pool.releaseTable(tempTableName);
            }
        }
    }
}

