/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.emm.mo.EMMManufactureOrderFlowCTL;
import com.kingdee.eas.industry.emm.mm.mo.FaultRecordCollection;
import com.kingdee.eas.industry.emm.mm.mo.FaultRecordFactory;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockFactory;
import com.kingdee.eas.mm.mo.app.service.order.DeleteService;
import com.kingdee.eas.scm.common.SCMBillEntryBaseCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class EmmDeleteService
extends DeleteService {
    private static final long serialVersionUID = 722833426280248832L;

    public void afterHandle() throws BOSException, EASBizException {
    }

    public void doCheck() throws BOSException, EASBizException {
        List idList = this.batchResults.getToDoIdsList();
        if (idList != null && idList.size() > 0) {
            String moid = null;
            String msg = null;
            ArrayList<String> ids = new ArrayList<String>();
            StringBuffer ksqlBuf = new StringBuffer();
            ksqlBuf.append("SELECT  mo.FID as FID, ");
            ksqlBuf.append("   mo.FBaseStatus as FBaseStatus, ");
            ksqlBuf.append("   mo.FBirthType as FBirthType, ");
            ksqlBuf.append("   bt.FDestObjectID  as FDestObjectID ");
            ksqlBuf.append("FROM  T_mm_manufactureorder  mo  ");
            ksqlBuf.append("   LEFT  JOIN  T_bot_Relation  bt  ");
            ksqlBuf.append("     ON  mo.fid = bt.FSrcObjectID  ");
            ksqlBuf.append("Where\r\n");
            ksqlBuf.append("1=1\r\n");
            ksqlBuf.append("And (\r\n");
            ksqlBuf.append("1<>1\r\n");
            for (int index = 0; index < idList.size(); ++index) {
                ksqlBuf.append("Or MO.FLongNumber Like '%").append(idList.get(index).toString()).append("!%'\r\n");
            }
            ksqlBuf.append(")\r\n");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)ksqlBuf.toString());
            try {
                while (rs != null && rs.next()) {
                    String childId = rs.getString("FID");
                    int status = rs.getInt("FBaseStatus");
                    int birthtype = rs.getInt("FBirthType");
                    String destObjectID = rs.getString("FDestObjectID");
                    if (status != 1 && status != 2) {
                        msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "Exists_ModifiedChild_noDelete");
                        break;
                    }
                    if (birthtype != 30) {
                        msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "Exists_otherChild_noDelete");
                        break;
                    }
                    if (!StringUtils.isEmpty((String)destObjectID)) {
                        msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "Exists_BOTPChild_noDelete");
                        break;
                    }
                    ids.add(childId);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (StringUtils.isEmpty(msg)) {
                if (this.batchResults.isToDo(moid)) {
                    IManufactureOrder iManufactureOrder = ManufactureOrderFactory.getLocalInstance((Context)this.ctx);
                    for (int k = 0; k < ids.size(); ++k) {
                        ObjectStringPK moPK = new ObjectStringPK((String)ids.get(k));
                        iManufactureOrder.deleteNoCheck((IObjectPK)moPK);
                    }
                }
            } else {
                this.batchResults.addError(moid, msg);
            }
            for (int index = 0; index < idList.size(); ++index) {
                this.beforeDelete(idList.get(index).toString());
            }
        }
    }

    public void doIt() throws BOSException, EASBizException {
    }

    private void beforeDelete(String pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("sourceBillType.number"));
        sic.add(new SelectorItemInfo("sourceBillType.name"));
        ManufactureOrderInfo manufactureInfo = ManufactureOrderFactory.getLocalInstance((Context)this.ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(pk), sic);
        this.beforeDelete(this.ctx, manufactureInfo);
    }

    protected void beforeDelete(Context ctx, ManufactureOrderInfo manufactureInfo) throws BOSException, EASBizException {
        if (manufactureInfo.getSourceBillType() != null && manufactureInfo.getSourceBillType().getNumber().equals("NCR")) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"NCRCS_INFO", (Locale)ctx.getLocale()));
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (manufactureInfo != null && manufactureInfo.getId() != null) {
            StringBuffer sql = new StringBuffer();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("id"));
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("MOS.FID \"FID\"\r\n");
            sql.append("From T_MM_MFTOrderStock MOS\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And MOS.FParentID='").append(manufactureInfo.getId().toString()).append("'\r\n");
            sql.append("And Exists(\r\n");
            sql.append("Select\r\n");
            sql.append("1\r\n");
            sql.append("From T_IM_StockTransferBillEntry STBE\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And STBE.FSourceBillEntryID=MOS.FID\r\n");
            sql.append(")\r\n");
            filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)manufactureInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
            entityViewInfo.setSelector(selectorItemCollection);
            entityViewInfo.setFilter(filterInfo);
            SCMBillEntryBaseCollection scmBillEntryBaseCollection = ManufactureOrderStockFactory.getLocalInstance((Context)ctx).getSCMBillEntryBaseCollection(entityViewInfo);
            if (scmBillEntryBaseCollection != null && scmBillEntryBaseCollection.size() > 0) {
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"NCRCS_INFO", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"DJYCSXYDBD_INFO", (Locale)ctx.getLocale()));
                throw new InterfaceDataBaseException(interfaceException);
            }
            entityViewInfo = new EntityViewInfo();
            filterInfo = new FilterInfo();
            selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("id"));
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("FR.FID \"FID\"\r\n");
            sql.append("From CT_MO_FaultRecord FR\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And FR.CFMANUOrderID='").append(manufactureInfo.getId().toString()).append("'\r\n");
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
            entityViewInfo.setSelector(selectorItemCollection);
            entityViewInfo.setFilter(filterInfo);
            FaultRecordCollection faultRecordCollection = FaultRecordFactory.getLocalInstance(ctx).getFaultRecordCollection(entityViewInfo);
            if (faultRecordCollection != null && faultRecordCollection.size() > 0) {
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"NCRCS_INFO", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"DJYYGZJL_INFO", (Locale)ctx.getLocale()));
                throw new InterfaceDataBaseException(interfaceException);
            }
            entityViewInfo = new EntityViewInfo();
            filterInfo = new FilterInfo();
            selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("id"));
            sql.setLength(0);
        }
    }
}

