/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.DataLimitExceedException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.IManufactureStrategy;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyFactory;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.emm.mo.EMMManufactureOrderCTL;
import com.kingdee.eas.emm.mo.EMMManufactureOrderFlowCTL;
import com.kingdee.eas.emm.mo.ManufactureOrderTechnicsExFactory;
import com.kingdee.eas.emm.mo.ManufactureOrderTechnicsExInfo;
import com.kingdee.eas.mm.basedata.CSEntrustTypeEnum;
import com.kingdee.eas.mm.basedata.ControlStrategyFactory;
import com.kingdee.eas.mm.basedata.ControlStrategyInfo;
import com.kingdee.eas.mm.basedata.ScheduleTypeEnum;
import com.kingdee.eas.mm.common.util.MMCommonUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.lot.LotFacadeFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderException;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.app.service.order.SubmitService;
import com.kingdee.eas.mm.planning.PlannedOrderEntryInfo;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class EmmSubmitService
extends SubmitService {
    private static final long serialVersionUID = 6524229502576305172L;

    public void afterHandle() throws BOSException, EASBizException {
        this.afterSubmit(this.ctx, this.model);
    }

    public void doCheck() throws BOSException, EASBizException {
        IObjectCollection col = this.batchResults.getObjCollection();
        MaterialInfo[] materialInfos = new MaterialInfo[col.size()];
        StorageOrgUnitInfo[] storageOrgUnit = new StorageOrgUnitInfo[col.size()];
        if (col != null && col.size() > 0) {
            String msg = null;
            HashMap crossOrgMap = new HashMap();
            HashSet<String> crossOrgSet = new HashSet<String>();
            for (int i = 0; i < col.size(); ++i) {
                ManufactureOrderTechnicsInfo entry;
                int j;
                ManufactureOrderInfo mo = (ManufactureOrderInfo)col.getObject(i);
                if (mo.getBaseStatus().equals((Object)BillBaseStatusEnum.ALTERING)) {
                    EMMManufactureOrderFlowCTL.synchronizeMOInfo(this.ctx, mo);
                }
                materialInfos[i] = mo.getMaterial();
                storageOrgUnit[i] = mo.getStorageOrgUnit();
                MaterialInfo materialInfo = materialInfos[i];
                StorageOrgUnitInfo stor = storageOrgUnit[i];
                String materialID = materialInfo.getId().toString();
                String storageOrgUnitID = stor.getId().toString();
                String key = materialID + storageOrgUnitID;
                String id = null;
                id = mo.getId() == null ? "NEWID" : mo.getId().toString();
                if (this.batchResults.isToDo(id)) {
                    ManufactureOrderTechnicsCollection tecCol = mo.getTechnics();
                    MMCommonUtils.objectValueSort((IObjectCollection)tecCol, (boolean)true, (String)"operationNo");
                    for (j = 0; j < tecCol.size(); ++j) {
                        entry = tecCol.get(j);
                        ControlStrategyInfo cInfo = null;
                        if (entry.getControlStrategy() != null) {
                            cInfo = ControlStrategyFactory.getLocalInstance((Context)this.ctx).getControlStrategyInfo((IObjectPK)new ObjectUuidPK(entry.getControlStrategy().getId()));
                        }
                        if (cInfo != null && cInfo.getEntrustType() != null && cInfo.getEntrustType().equals((Object)CSEntrustTypeEnum.INNERCOOPERATE)) {
                            if (j > 0 && !mo.getTechnics().get(j - 1).isIsReportPoint()) {
                                msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "OUTWP_LAS_OR_NEXT_ISNOT_REPORPOINT");
                                this.batchResults.addError(id, msg);
                            }
                            if (j < mo.getTechnics().size() - 1 && !mo.getTechnics().get(j + 1).isIsReportPoint()) {
                                msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "OUTWP_LAS_OR_NEXT_ISNOT_REPORPOINT");
                                this.batchResults.addError(id, msg);
                            }
                        }
                        if (entry.getAdminOrgUnit() != null) continue;
                        msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "TECH_ADMIN_ORG_MUST_NOT_NULL");
                        this.batchResults.addError(id, msg);
                    }
                }
                if (this.batchResults.isToDo(id)) {
                    ManufactureOrderStockCollection stockCol = mo.getStocks();
                    for (j = 0; j < stockCol.size(); ++j) {
                        List<String> seqList;
                        entry = stockCol.get(j);
                        if (entry.getProvideType() != MaterialProvideTypeEnum.SPANORGPROVIDE && entry.getProvideType() != MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE) continue;
                        String keyID = entry.getMaterial().getId().toString() + "_" + entry.getStorageOrgUnit().getId().toString();
                        if (crossOrgMap.containsKey(keyID)) {
                            seqList = (List)crossOrgMap.get(keyID);
                            seqList.add(String.valueOf(entry.getProvideType().getValue()));
                        } else {
                            seqList = new ArrayList();
                            seqList.add(String.valueOf(entry.getProvideType().getValue()));
                            crossOrgMap.put(keyID, seqList);
                        }
                        if (crossOrgSet.contains(keyID)) continue;
                        crossOrgSet.add(keyID);
                    }
                }
                SCMEntryDataVO vo = new SCMEntryDataVO();
                SCMEntryDataVO voResult = new SCMEntryDataVO();
                vo.setMaterialInfos(materialInfos);
                vo.setStorageOrgUnitInfos(storageOrgUnit);
                vo.setIsLoadingMaterialPlan(true);
                vo.setIsLoadingMaterialInventory(true);
                vo.setIsLoadingMaterialInfo(false);
                voResult = SCMGroupFacadeFactory.getLocalInstance((Context)this.ctx).loadComplexData(vo);
                MaterialInventoryInfo materialInv = (MaterialInventoryInfo)voResult.getMaterialInventoryInfos().get(key);
                if (materialInv == null) {
                    msg = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"XMSCDDSDCPBM_NOTFIND", (Locale)this.ctx.getLocale());
                    this.batchResults.addError(id, msg);
                } else if (materialInv.isIsLotNumber() && mo.getLot() == null) {
                    msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "LOT_NOT_NULL");
                }
                if (mo.getBomNum() == null) {
                    msg = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"XMSCDDSDBOM_ISNOTNULL", (Locale)this.ctx.getLocale());
                    this.batchResults.addError(id, msg);
                }
                if (mo.getRouting() == null) {
                    msg = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"XMSCDDSDGYLX_ISNOTNULL", (Locale)this.ctx.getLocale());
                    this.batchResults.addError(id, msg);
                }
                if (mo.getCostObject() == null) {
                    msg = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"XMSCDDSDCBDX_ISNOTNULL", (Locale)this.ctx.getLocale());
                    this.batchResults.addError(id, msg);
                }
                IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)this.ctx);
                IMaterialPlan iMaterialPlan = MaterialPlanFactory.getLocalInstance((Context)this.ctx);
                MaterialPlanInfo planInfo = iMaterialPlan.getPlanInfo(materialID, storageOrgUnitID);
                MaterialInfo material = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
                if (planInfo != null) {
                    boolean isConfig = planInfo.isIsConfigable();
                    if (isConfig && mo.getProject() == null && mo.getTrackNumber() == null) {
                        msg = EMMManufactureOrderFlowCTL.getMessage(this.ctx, "PROJECT_TRACKNUM_NOT_NULL", new String[]{material.getName()});
                        this.batchResults.addError(id, msg);
                    }
                    if ((mo.getSourceBillType() != null && !"9XXvbVGlRtym/0qtqeIXXrhE1B8=".equals(mo.getSourceBillType().getId().toString()) || mo.getSourceBillType() == null) && planInfo.getManufactureStrategy() != null) {
                        String strategy = planInfo.getManufactureStrategy().getId().toString();
                        IManufactureStrategy ims = ManufactureStrategyFactory.getLocalInstance((Context)this.ctx);
                        ManufactureStrategyInfo msi = (ManufactureStrategyInfo)ims.getValue((IObjectPK)new ObjectUuidPK(strategy));
                        if (strategy.equals("GE2FIa4GQ6uhdx0RDGuibtg0uEU=") || strategy.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
                            if (planInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM && mo.getProject() == null) {
                                msg = EMMManufactureOrderFlowCTL.getMessage(this.ctx, "ETO_PROJECT_NOT_NULL", new String[]{material.getName(), msi.getNumber()});
                                this.batchResults.addError(id, msg);
                            } else if (planInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM_TRACKNO) {
                                if (mo.getProject() == null) {
                                    msg = EMMManufactureOrderFlowCTL.getMessage(this.ctx, "ETO_PROJECT_NOT_NULL", new String[]{material.getName(), msi.getNumber()});
                                    this.batchResults.addError(id, msg);
                                }
                                if (mo.getTrackNumber() == null) {
                                    msg = EMMManufactureOrderFlowCTL.getMessage(this.ctx, "MTO_TRACKNUMBER_NOT_NULL", new String[]{material.getName(), msi.getNumber()});
                                    this.batchResults.addError(id, msg);
                                }
                            }
                        } else if ((strategy.equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || strategy.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategy.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || strategy.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) && mo.getTrackNumber() == null) {
                            msg = EMMManufactureOrderFlowCTL.getMessage(this.ctx, "MTO_TRACKNUMBER_NOT_NULL", new String[]{material.getName(), msi.getNumber()});
                            this.batchResults.addError(id, msg);
                        }
                    }
                }
                if (!this.batchResults.isToDo(id)) continue;
                ScheduleTypeEnum scheduleType = mo.getScheduleType();
                if (scheduleType != null && scheduleType.getValue() != 10) {
                    boolean hasCalendar;
                    boolean isSupplyClassTerm = EMMManufactureOrderCTL.isSupplyClassTerm(this.ctx, mo);
                    if (!isSupplyClassTerm) {
                        msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "Not_SupplyClassTerm");
                        this.batchResults.addError(id, msg);
                    }
                    if (!(hasCalendar = EMMManufactureOrderCTL.hasProjectCalendar(this.ctx, mo.getStorageOrgUnit().getId().toString()))) {
                        msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "Not_FACTORYCALENDAR");
                        this.batchResults.addError(id, msg);
                    }
                }
                Set outSet = MMUtils.getCrossOrgMaterialSupplyOrgSet((Context)this.ctx, crossOrgSet);
                for (String materialOrg : outSet) {
                    String[] array = materialOrg.split("_");
                    String sqlMaterialName = "select fname_" + SysContext.getSysContext().getLocale() + " as name from T_BD_Material where fid='" + array[0] + "'";
                    String sqlOrgName = "select fname_" + SysContext.getSysContext().getLocale() + " as name from T_ORG_Storage where fid='" + array[1] + "'";
                    String materialName = "";
                    String orgName = "";
                    IRowSet rs_m = DbUtil.executeQuery((Context)this.ctx, (String)sqlMaterialName);
                    IRowSet rs_o = DbUtil.executeQuery((Context)this.ctx, (String)sqlOrgName);
                    try {
                        while (rs_m != null && rs_m.next()) {
                            materialName = rs_m.getString("name");
                        }
                        while (rs_o != null && rs_o.next()) {
                            orgName = rs_o.getString("name");
                        }
                    }
                    catch (SQLException e) {
                        throw new SQLDataException(e);
                    }
                    List tmpList = (List)crossOrgMap.get(materialOrg);
                    for (int k = 0; k < tmpList.size(); ++k) {
                        String provideTypeName = MaterialProvideTypeEnum.getEnum((int)Integer.parseInt(tmpList.get(k).toString())).getAlias();
                        String msgInfo = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"MID_AUDIT_CHECK", (String[])new String[]{provideTypeName, materialName, orgName});
                        this.batchResults.addError(id, msgInfo);
                    }
                }
            }
        }
    }

    public void doIt() throws BOSException, EASBizException {
    }

    public IObjectPK submitSingle() throws BOSException, EASBizException {
        boolean isExist;
        ManufactureOrderInfo mo = (ManufactureOrderInfo)this.model;
        if (mo.getId() != null && (isExist = ManufactureOrderFactory.getLocalInstance((Context)this.ctx).exists((IObjectPK)new ObjectUuidPK(mo.getId().toString())))) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("technics.*"));
            sic.add(new SelectorItemInfo("stocks.*"));
            sic.add(new SelectorItemInfo("storageOrgUnit.*"));
            sic.add(new SelectorItemInfo("project.*"));
            sic.add(new SelectorItemInfo("routing.*"));
            sic.add(new SelectorItemInfo("trackNumber.*"));
            this.model = ManufactureOrderFactory.getLocalInstance((Context)this.ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(mo.getId().toString()), sic);
        }
        this._submitEx(this.ctx, (IObjectValue)mo);
        this._submitPIEx(this.ctx, (IObjectValue)mo);
        BillBaseStatusEnum baseStatus = mo.getBaseStatus();
        int dbStatus = 0;
        BigDecimal alterBeforeQty = mo.getBaseQty();
        BigDecimal alterBeforeBaseQty = mo.getBaseQty();
        UserInfo auditor = mo.getAuditor();
        Timestamp auditTime = mo.getAuditTime();
        if (baseStatus == BillBaseStatusEnum.ALTERING) {
            ManufactureOrderInfo dbData = ManufactureOrderFactory.getLocalInstance((Context)this.ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(mo.getId()));
            dbStatus = dbData.getBaseStatus().getValue();
            alterBeforeQty = dbData.getQty();
            alterBeforeBaseQty = dbData.getBaseQty();
            auditor = dbData.getAuditor();
            auditTime = dbData.getAuditTime();
        }
        IBillType iBillType = BillTypeFactory.getLocalInstance((Context)this.ctx);
        BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("B2aZSVXaSx6qxdfekgCmrEY+1VI="));
        mo.setBillType(billTypeInfo);
        if (mo.getLot() != null) {
            mo.setLot(mo.getLot().trim());
        }
        IObjectPK pk = null;
        try {
            mo.setExtraUpperLimitBase(mo.getExtraUpperLimit());
            mo.setLackLowerLimitBase(mo.getLackLowerLimit());
            mo.setUnToStoreBaseQty(mo.getUnToStoreQty());
            mo.setDeliveryBaseQty(mo.getBaseQty());
            pk = super._submit(this.ctx, (IObjectValue)mo);
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof DataLimitExceedException) {
                throw new ManufactureOrderException(ManufactureOrderException.NUMERIC_VALUE_OUT_OF_RANGE);
            }
            throw new BOSException((Throwable)exception);
        }
        EMMManufactureOrderCTL.afterSubmit(this.ctx, mo.getId().toString());
        if (BillBaseStatusEnum.ALTERING.equals((Object)baseStatus)) {
            LotFacadeFactory.getLocalInstance((Context)this.ctx).manufactureOrderDeleteLotSource(new String[]{pk.toString()});
            LogControllManager.getInstance().enableLog();
            ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
            IObjectPK logPk = LogUtil.beginLog((Context)this.ctx, (String)"alter", (BOSObjectType)mo.getBOSType(), (IObjectPK)pk, (String)mo.getNumber(), (String)"mm_manufactureOrder_alter");
            if (mo.getSourceBillType() != null && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(mo.getSourceBillType().getId().toString())) {
                String srcBillEntryID = mo.getSrcBillEntryID();
                StringBuffer updateSql = new StringBuffer();
                updateSql.append(" UPDATE  t_sd_saleorderentry  ");
                updateSql.append(" SET  ");
                updateSql.append("   FTotalProductQty = FTotalProductQty - ?, ");
                updateSql.append("   FTotalunProductQty = FTotalunProductQty +? , ");
                updateSql.append("   FTotalBaseProductQty = FTotalBaseProductQty -? , ");
                updateSql.append("   FTotalBaseunProductQty = FTotalBaseunProductQty +?   ");
                updateSql.append("WHERE  t_sd_saleorderentry.fid =?");
                Object[] params = new Object[]{alterBeforeQty, alterBeforeQty, alterBeforeBaseQty, alterBeforeBaseQty, srcBillEntryID};
                DbUtil.execute((Context)this.ctx, (String)updateSql.toString(), (Object[])params);
            } else if (mo.getSourceBillType() != null && "B2aZSVXaSx6qxdfekgCmrEY+1VI=".equals(mo.getSourceBillType().getId().toString())) {
                String sourceBillId = mo.getSourceBillId();
                StringBuffer updateSql = new StringBuffer();
                updateSql.append(" UPDATE  T_MM_ManufactureOrder  ");
                updateSql.append(" SET  ");
                updateSql.append("   FRepairQty = FRepairQty - ?, ");
                updateSql.append("   FunRepairQty = FunRepairQty +? , ");
                updateSql.append("   FRepairBaseQty = FRepairBaseQty -? , ");
                updateSql.append("   FunRepairBaseQty = FunRepairBaseQty +?   ");
                updateSql.append("WHERE  FID =?");
                Object[] params = new Object[]{alterBeforeQty, alterBeforeQty, alterBeforeBaseQty, alterBeforeBaseQty, sourceBillId};
                DbUtil.execute((Context)this.ctx, (String)updateSql.toString(), (Object[])params);
            }
            this._audit(this.ctx, pk);
            ManufactureOrderInfo moInfo = ManufactureOrderFactory.getLocalInstance((Context)this.ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(mo.getId()));
            moInfo.setAuditor(auditor);
            moInfo.setAuditTime(auditTime);
            if (dbStatus == 5) {
                moInfo.setBaseStatus(BillBaseStatusEnum.RELEASED);
                this.innerUpdate(this.ctx, pk, (IObjectValue)moInfo);
            }
            if (dbStatus == 8) {
                moInfo.setBaseStatus(BillBaseStatusEnum.COMPLETE);
            }
            this.innerUpdate(this.ctx, pk, (IObjectValue)moInfo);
            LogUtil.afterLog((Context)this.ctx, (IObjectPK)logPk);
            EMMManufactureOrderFlowCTL.dealWithMOFinish(this.ctx, pk);
            return pk;
        }
        String orgUnitID = mo.getStorageOrgUnit().getId().toString();
        if (this.isAuditAfterSubmit(this.ctx, (SCMBillBaseInfo)mo, orgUnitID, 4)) {
            Boolean release = null;
            release = (Boolean)this.ctx.get((Object)"release");
            if (release == null || !release.booleanValue()) {
                Boolean isPORelease = (Boolean)this.ctx.get((Object)"isPlannedOrderRelease");
                if (isPORelease == null || !isPORelease.booleanValue()) {
                    try {
                        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
                        entry.add((Object)pk);
                        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{entry};
                        EMMManufactureOrderFlowCTL.updateReqPlanData(this.ctx, entries, 102);
                    }
                    catch (Exception exc) {
                        throw new BOSException((Throwable)exc);
                    }
                }
                this.ctx.put((Object)"isPlannedOrderRelease", null);
                this.auditAndLog(this.ctx, pk, mo.getBOSType(), mo.getNumber(), "mm_manufactureOrder_audit");
            }
        } else {
            Boolean isPORelease = (Boolean)this.ctx.get((Object)"isPlannedOrderRelease");
            if (isPORelease == null || !isPORelease.booleanValue()) {
                try {
                    BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
                    entry.add((Object)pk);
                    BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{entry};
                    EMMManufactureOrderFlowCTL.updateReqPlanData(this.ctx, entries, 102);
                }
                catch (Exception exc) {
                    throw new BOSException((Throwable)exc);
                }
            }
            this.ctx.put((Object)"isPlannedOrderRelease", null);
        }
        return pk;
    }

    public IObjectPK afterSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ManufactureOrderInfo mo = (ManufactureOrderInfo)model;
        if (mo.getId() == null) {
            mo.setId(BOSUuid.create((BOSObjectType)mo.getBOSType()));
        }
        ObjectUuidPK pk = new ObjectUuidPK(mo.getId().toString());
        BillBaseStatusEnum baseStatus = mo.getBaseStatus();
        int dbStatus = 0;
        BigDecimal alterBeforeQty = mo.getBaseQty();
        BigDecimal alterBeforeBaseQty = mo.getBaseQty();
        UserInfo auditor = mo.getAuditor();
        Timestamp auditTime = mo.getAuditTime();
        EMMManufactureOrderCTL.afterSubmit(ctx, mo.getId().toString());
        StringBuffer strSql = new StringBuffer();
        strSql.setLength(0);
        strSql.append(" update t_mm_mftordertechnics  ");
        strSql.append(" set fbasestatus =  ").append(2);
        strSql.append(" Where FParentID = '");
        strSql.append(mo.getId().toString());
        strSql.append("'");
        DbUtil.execute((Context)ctx, (String)strSql.toString());
        if (BillBaseStatusEnum.ALTERING.equals((Object)baseStatus)) {
            LotFacadeFactory.getLocalInstance((Context)ctx).manufactureOrderDeleteLotSource(new String[]{mo.getId().toString()});
            LogControllManager.getInstance().enableLog();
            ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
            IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"alter", (BOSObjectType)mo.getBOSType(), (IObjectPK)pk, (String)mo.getNumber(), (String)"mm_manufactureOrder_alter");
            if (mo.getSourceBillType() != null && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(mo.getSourceBillType().getId().toString())) {
                String srcBillEntryID = mo.getSrcBillEntryID();
                StringBuffer updateSql = new StringBuffer();
                updateSql.append(" UPDATE  t_sd_saleorderentry  ");
                updateSql.append(" SET  ");
                updateSql.append("   FTotalProductQty = FTotalProductQty - ?, ");
                updateSql.append("   FTotalunProductQty = FTotalunProductQty +? , ");
                updateSql.append("   FTotalBaseProductQty = FTotalBaseProductQty -? , ");
                updateSql.append("   FTotalBaseunProductQty = FTotalBaseunProductQty +?   ");
                updateSql.append("WHERE  t_sd_saleorderentry.fid =?");
                Object[] params = new Object[]{alterBeforeQty, alterBeforeQty, alterBeforeBaseQty, alterBeforeBaseQty, srcBillEntryID};
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])params);
            } else if (mo.getSourceBillType() != null && "B2aZSVXaSx6qxdfekgCmrEY+1VI=".equals(mo.getSourceBillType().getId().toString())) {
                String sourceBillId = mo.getSourceBillId();
                StringBuffer updateSql = new StringBuffer();
                updateSql.append(" UPDATE  T_MM_ManufactureOrder  ");
                updateSql.append(" SET  ");
                updateSql.append("   FRepairQty = FRepairQty - ?, ");
                updateSql.append("   FunRepairQty = FunRepairQty +? , ");
                updateSql.append("   FRepairBaseQty = FRepairBaseQty -? , ");
                updateSql.append("   FunRepairBaseQty = FunRepairBaseQty +?   ");
                updateSql.append("WHERE  FID =?");
                Object[] params = new Object[]{alterBeforeQty, alterBeforeQty, alterBeforeBaseQty, alterBeforeBaseQty, sourceBillId};
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])params);
            }
            this._audit(ctx, (IObjectPK)pk);
            ManufactureOrderInfo moInfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(mo.getId()));
            moInfo.setAuditor(auditor);
            moInfo.setAuditTime(auditTime);
            if (dbStatus == 5) {
                moInfo.setBaseStatus(BillBaseStatusEnum.RELEASED);
                this.innerUpdate(ctx, (IObjectPK)pk, (IObjectValue)moInfo);
            }
            if (dbStatus == 8) {
                moInfo.setBaseStatus(BillBaseStatusEnum.COMPLETE);
            }
            this.innerUpdate(ctx, (IObjectPK)pk, (IObjectValue)moInfo);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
            EMMManufactureOrderFlowCTL.dealWithMOFinish(ctx, (IObjectPK)pk);
            return pk;
        }
        String orgUnitID = mo.getStorageOrgUnit().getId().toString();
        if (this.isAuditAfterSubmit(ctx, (SCMBillBaseInfo)mo, orgUnitID, 4)) {
            Boolean release = null;
            release = (Boolean)ctx.get((Object)"release");
            if (release == null || !release.booleanValue()) {
                Boolean isPORelease = (Boolean)ctx.get((Object)"isPlannedOrderRelease");
                if (isPORelease == null || !isPORelease.booleanValue()) {
                    try {
                        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
                        entry.add((Object)pk);
                        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{entry};
                        EMMManufactureOrderFlowCTL.updateReqPlanData(ctx, entries, 102);
                    }
                    catch (Exception exc) {
                        throw new BOSException((Throwable)exc);
                    }
                }
                ctx.put((Object)"isPlannedOrderRelease", null);
                this.auditAndLog(ctx, (IObjectPK)pk, mo.getBOSType(), mo.getNumber(), "mm_manufactureOrder_audit");
            }
        } else {
            Boolean isPORelease = (Boolean)ctx.get((Object)"isPlannedOrderRelease");
            if (isPORelease == null || !isPORelease.booleanValue()) {
                try {
                    BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class});
                    entry.add((Object)pk);
                    BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{entry};
                    EMMManufactureOrderFlowCTL.updateReqPlanData(ctx, entries, 102);
                }
                catch (Exception exc) {
                    throw new BOSException((Throwable)exc);
                }
            }
            ctx.put((Object)"isPlannedOrderRelease", null);
        }
        this.setManufactureTechnicsEx(ctx, (ManufactureOrderInfo)model);
        return pk;
    }

    private void setManufactureTechnicsEx(Context ctx, ManufactureOrderInfo obj) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("technics.*"));
        sic.add(new SelectorItemInfo("stocks.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("routing.*"));
        sic.add(new SelectorItemInfo("trackNumber.*"));
        obj = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(obj.getId().toString()), sic);
        ManufactureOrderTechnicsCollection colls = obj.getTechnics();
        for (int n = 0; n < colls.size(); ++n) {
            ManufactureOrderTechnicsInfo techinfo = colls.get(n);
            String manufactororderid = obj.getId().toString();
            FilterInfo filter = new FilterInfo();
            String techid = null;
            boolean isExist = false;
            if (techinfo.getId() != null) {
                techid = techinfo.getId().toString();
                filter.getFilterItems().add(new FilterItemInfo("pid", (Object)techid, CompareType.EQUALS));
                isExist = ManufactureOrderTechnicsExFactory.getLocalInstance(ctx).exists(filter);
            } else {
                techinfo.setId(BOSUuid.create((BOSObjectType)techinfo.getBOSType()));
            }
            if (isExist) continue;
            ManufactureOrderTechnicsExInfo technicsex = new ManufactureOrderTechnicsExInfo();
            technicsex.setParent(manufactororderid);
            technicsex.setPid(techinfo);
            ManufactureOrderTechnicsExFactory.getLocalInstance(ctx).save(technicsex);
        }
    }

    protected void _submitEx(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ManufactureOrderInfo info = (ManufactureOrderInfo)model;
        if (info.getTechnics() != null && info.getTechnics().size() > 0) {
            ManufactureOrderTechnicsCollection collection = info.getTechnics();
            Object[] arrays = collection.toArray();
            int index = 1;
            StringBuilder strStatistics = new StringBuilder();
            strStatistics.append(EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"CSGYFLZD_INFO", (Locale)ctx.getLocale()));
            boolean isException = false;
            for (Object MTentryinfo : arrays) {
                ManufactureOrderTechnicsInfo Mtinfo = (ManufactureOrderTechnicsInfo)MTentryinfo;
                if (Mtinfo.getWorkcenter() == null) {
                    strStatistics.append(String.valueOf(index) + ", ");
                    isException = true;
                }
                ++index;
                if (Mtinfo.getOperQty() == null || !Mtinfo.getOperQty().equals(BigDecimal.ZERO)) continue;
                Mtinfo.setOperQty(info.getQty());
            }
            if (isException) {
                strStatistics.append(EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"H_NAME", (Locale)ctx.getLocale()));
                throw new EASBizException(new NumericExceptionSubItem("", strStatistics.toString() + EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"SJZGZZXZD_ISNOTNULL", (Locale)ctx.getLocale())));
            }
        }
    }

    protected void _submitPIEx(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ManufactureOrderInfo info = (ManufactureOrderInfo)model;
        boolean bol = this.isAuditAfterSubmit(ctx, (SCMBillBaseInfo)info, info.getStorageOrgUnit().getId().toString(), 4);
        if (!bol) {
            for (int i = 0; i < info.getTechnics().size(); ++i) {
                ManufactureOrderTechnicsInfo tech = info.getTechnics().get(i);
                tech.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            }
        }
        String sourceBillTypeID = "";
        if (info.getSourceBillType() != null) {
            sourceBillTypeID = info.getSourceBillType().getId().toString();
        }
        if (sourceBillTypeID.equals("9XXvbVGlRtym/0qtqeIXXrhE1B8=") && info.getStocks() != null && info.getStocks().size() > 0 && info.getRouting() != null && info.getBomID() != null) {
            PlannedOrderInfo plannedOrderInfo;
            String SourceBillId;
            StringBuffer sql = new StringBuffer();
            sql.delete(0, sql.length());
            sql.append(" Select d.fid ");
            sql.append(" from t_mm_pbom h ");
            sql.append(" inner join t_mm_pbomentry d on h.fid = d.fparentid ");
            sql.append(" where h.froutingid = '").append(info.getRouting().getId().toString()).append("' ");
            sql.append(" and h.fbomid = '").append(info.getBomID().toString()).append("'  and rownum = 1 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs != null && rs.size() > 0 && (SourceBillId = info.getSourceBillId()) != null && !"".equals(SourceBillId) && PlannedOrderFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(SourceBillId)) && (plannedOrderInfo = PlannedOrderFactory.getLocalInstance((Context)ctx).getPlannedOrderInfo((IObjectPK)new ObjectUuidPK(SourceBillId))).getEntries() != null && plannedOrderInfo.getEntries().size() > 0) {
                for (int i = 0; i < plannedOrderInfo.getEntries().size(); ++i) {
                    PlannedOrderEntryInfo entryInfo = plannedOrderInfo.getEntries().get(i);
                    if (entryInfo.getMaterial() == null || entryInfo.getSourceBillEntryId() == null) continue;
                    for (int j = 0; j < info.getStocks().size(); ++j) {
                        ManufactureOrderStockInfo stockInfo = info.getStocks().get(j);
                        if (stockInfo.getMaterial() == null || stockInfo.getBomEntryID() == null || !stockInfo.getMaterial().getId().toString().equals(entryInfo.getMaterial().getId().toString()) || !stockInfo.getBomEntryID().toString().equals(entryInfo.getSourceBillEntryId().toString())) continue;
                        BigDecimal rateQty = new BigDecimal(0);
                        stockInfo.setQty(entryInfo.getStandardQty().multiply(info.getQty()).divide(plannedOrderInfo.getQty(), 4));
                        stockInfo.setBaseQty(entryInfo.getStandardQty().multiply(info.getQty()).divide(plannedOrderInfo.getQty(), 4));
                        stockInfo.setUnitQty(entryInfo.getUnitQty());
                        stockInfo.setUnitBaseQty(entryInfo.getUnitQty());
                        stockInfo.setLossRatio(entryInfo.getScrapRate());
                        stockInfo.setLossQty(entryInfo.getScrapQty().multiply(info.getQty()).divide(plannedOrderInfo.getQty(), 4));
                        stockInfo.setLossBaseQty(entryInfo.getScrapQty().multiply(info.getQty()).divide(plannedOrderInfo.getQty(), 4));
                        stockInfo.setAssociateQty(stockInfo.getQty());
                        stockInfo.setPlannedBaseQty(entryInfo.getBaseDemandQty().multiply(info.getQty()).divide(plannedOrderInfo.getQty(), 4));
                        stockInfo.setPlannedQty(entryInfo.getDemandQty().multiply(info.getQty()).divide(plannedOrderInfo.getQty(), 4));
                        stockInfo.setUnIssueBaseQty(stockInfo.getBaseQty());
                        stockInfo.setUnIssueQty(stockInfo.getQty());
                        stockInfo.setOriginalPlanBaseQty(stockInfo.getBaseQty());
                        stockInfo.setOriginalPlanQty(stockInfo.getQty());
                        stockInfo.setUnReceiptBaseQty(stockInfo.getBaseQty());
                        stockInfo.setUnReceiptQty(stockInfo.getQty());
                        stockInfo.setPickExtraBaseQty(stockInfo.getBaseQty());
                        stockInfo.setPickExtraQty(stockInfo.getQty());
                    }
                }
            }
        }
    }
}

