/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.emm.mo.EMMManufactureOrderCTL;
import com.kingdee.eas.emm.mo.EMMManufactureOrderFlowCTL;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.app.service.order.UnReleaseService;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class EmmUnReleaseService
extends UnReleaseService {
    private static final long serialVersionUID = 6845376688434576545L;

    public void afterHandle() throws BOSException, EASBizException {
        if (this.batchResults.getToDoIdsArray().length > 0) {
            String idStr = SQLUtil.setToString((Set)this.batchResults.getToDoIdsSet());
            EMMManufactureOrderCTL.updateRowStatus(this.ctx, EntryBaseStatusEnum.AUDITED, idStr);
        }
    }

    public void doCheck() throws BOSException, EASBizException {
        List ids = this.batchResults.getToDoIdsList();
        if (ids != null && ids.size() > 0) {
            String moid = null;
            String msg = null;
            for (int i = 0; i < ids.size(); ++i) {
                moid = ids.toArray()[i].toString();
                ManufactureOrderInfo moInfo = ManufactureOrderFactory.getLocalInstance((Context)this.ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(moid));
                if (moInfo.getBaseStatus() == BillBaseStatusEnum.RELEASED) continue;
                msg = EMMManufactureOrderFlowCTL.getString(this.ctx, "NotReleasedForUnReleased");
                throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{msg});
            }
        }
        HashSet set = new HashSet();
        set.addAll(ids);
        if (EMMManufactureOrderCTL.checkManufactureStockTransferPlanBill(this.ctx, set)) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"XMSCDDXYCZDBJH_UNRELEASE", (Locale)this.ctx.getLocale()));
        }
    }

    public void doIt() throws BOSException, EASBizException {
        this.doCommon();
    }

    private void afterUnReleased(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
    }
}

