/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgUnitExtInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.app.AbstractAutoNumberFacadeControllerBean;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.eas.zjbom.app.util.ProcessBomTree;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class AutoNumberFacadeControllerBean
extends AbstractAutoNumberFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.app.AutoNumberFacadeControllerBean");
    public static final String def_bostype = "def_bostype";
    public static final String sql_lock_unlock = "update t_bd_lockcodingrule set flock = ? where fbostype = ?";
    public static final String sql_insert = "insert into t_bd_lockcodingrule ( flock, fbostype) values ( ?,? )";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] _getBatchAutoNumber(Context ctx, IObjectCollection objects, String mainOrgKey) throws BOSException, EASBizException {
        IObjectValue temp = objects.getObject(0);
        int size = objects.size();
        String bostype = temp.getBOSType().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String[] numbers = null;
        if (iCodingRuleManager.isExist(temp, "00000000-0000-0000-0000-000000000000CCE7AED4")) {
            try {
                this.lockCodingRule(ctx, bostype, "00000000-0000-0000-0000-000000000000CCE7AED4");
                numbers = iCodingRuleManager.getBatchNumber(temp, "00000000-0000-0000-0000-000000000000CCE7AED4", size);
            }
            finally {
                this.unlockCodingRule(ctx, bostype, "00000000-0000-0000-0000-000000000000CCE7AED4");
            }
            return numbers;
        }
        String companyID = AutoNumberUtil.EAS_ROOT_ORGUNIT_ID;
        Object o = temp.get(mainOrgKey);
        if (o != null && OrgUnitExtInfo.class.isInstance(o)) {
            companyID = ((OrgUnitExtInfo)o).getId().toString();
        }
        if (companyID == null) {
            return this.getNumberByBOSID(ctx, bostype, size);
        }
        try {
            this.lockCodingRule(ctx, bostype, companyID);
            numbers = iCodingRuleManager.isExist(temp, companyID) ? iCodingRuleManager.getBatchNumber(temp, companyID, size) : (AutoNumberUtil.EAS_ROOT_ORGUNIT_ID != null && iCodingRuleManager.isExist(temp, AutoNumberUtil.EAS_ROOT_ORGUNIT_ID) ? iCodingRuleManager.getBatchNumber(temp, AutoNumberUtil.EAS_ROOT_ORGUNIT_ID, size) : this.getNumberByBOSID(ctx, bostype, size));
        }
        finally {
            this.unlockCodingRule(ctx, bostype, companyID);
        }
        return numbers;
    }

    protected void lockCodingRule(Context ctx, String bostype, String org) throws BOSException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(1);
        params.add(bostype);
        int up = ProcessBomTree.executeUpdate(ctx, sql_lock_unlock, params);
        if (up == 0) {
            params.clear();
            params.add(1);
            params.add(def_bostype);
            ProcessBomTree.executeUpdate(ctx, sql_lock_unlock, params);
        }
    }

    protected String[] getNumberByBOSID(Context ctx, String bostype, int size) throws BOSException {
        String[] numbers = new String[size];
        for (int i = 0; i < size; ++i) {
            numbers[i] = "AutoNoNumberRule_" + BOSUuid.create((String)bostype).toString();
        }
        return numbers;
    }

    protected void unlockCodingRule(Context ctx, String bostype, String org) throws BOSException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(0);
        params.add(bostype);
        int up = ProcessBomTree.executeUpdate(ctx, sql_lock_unlock, params);
        if (up == 0) {
            params.clear();
            params.add(0);
            params.add(def_bostype);
            ProcessBomTree.executeUpdate(ctx, sql_lock_unlock, params);
            params.clear();
            params.add(0);
            params.add(bostype);
            ProcessBomTree.executeUpdate(ctx, sql_insert, params);
        }
    }
}

