/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.bl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.common.EmmUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BLSCWCQKHBBRptServer
extends ReportServerBase {
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private String storage;
    private String project;
    private String trackNumber;
    private String endTrackNumebr;
    private String[] materials;
    private String storageOrgId;
    private String storageOrgNumber;
    private String storageOrgName;
    private String projectNumber;
    private String projectName;
    private String projectId;
    private String trackNumberId;
    private String trackNumberName;
    private String endTrackNumebrName;
    private String endTrackNumebrId;
    private Context ctx;
    private int opCount;
    private boolean bzTotal;
    private boolean bjTotal;
    private boolean sjdwTotal;

    private String getString(Context ctx, String name) {
        return EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)name, (Locale)ctx.getLocale());
    }

    protected IRowSet getReportData(String s, RptParams rptparams) throws Exception {
        this.ctx = this.getContext();
        this.initRptParams(rptparams);
        IRowSet rs = null;
        String tempTable = null;
        if (this.bzTotal) {
            tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(this.createTempTableForWc());
            StringBuffer sb = new StringBuffer();
            sb.setLength(0);
            sb.append(" /*dialect*/ insert into " + tempTable + "(FWorkCenterID,FWorkCenterNumber,FWorkCenterName)");
            sb.append(" select distinct wc.fid,wc.fnumber,wc.fname_l2 ");
            sb.append(" from t_mm_workcenter wc");
            sb.append(" where wc.CFIsInside=1");
            sb.append(" and wc.FStorageOrgUnitID='" + this.storageOrgId + "'");
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append(" /*dialect*/ update " + tempTable + " t set t.fplanqty=");
            sb.append(" (select sum(mfo.fqty)");
            sb.append(" from T_MM_ManufactureOrder mfo ");
            sb.append(" inner join t_org_storage sou on mfo.FStorageOrgUnitID=sou.fid");
            sb.append(" inner join t_mm_project pro on mfo.fprojectid=pro.fid");
            sb.append(" inner join t_mm_tracknumber track on mfo.FTrackID=track.fid");
            sb.append(" inner join t_mm_tracknumber endTrack on endTrack.Fid=mfo.CFEndTrackNumberID");
            sb.append(" where 1=1 ");
            sb.append(" and exists (select 1 from T_MM_MFTOrderTechnics mft where mft.fparentid=mfo.fid and mft.fworkcenterid=t.fworkcenterid)");
            sb.append(this.buildWhereSql());
            sb.append(" )");
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            String tmpMergeTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(this.createTableForMergeQty());
            sb.setLength(0);
            sb.append(" /*dialect*/ insert into " + tmpMergeTable);
            sb.append(" select mfo.fid,mft.fmergeid,max(mft.foperationno),max(mft.fbasestatus),mft.fworkcenterid,max(mft.ffinishedqty),0,0 ");
            sb.append(" from T_MM_ManufactureOrder mfo ");
            sb.append(" inner join T_MM_MFTOrderTechnics mft on mfo.fid=mft.fparentid");
            sb.append(" inner join t_org_storage sou on mfo.FStorageOrgUnitID=sou.fid");
            sb.append(" inner join t_mm_project pro on mfo.fprojectid=pro.fid");
            sb.append(" inner join t_mm_tracknumber track on mfo.FTrackID=track.fid");
            sb.append(" inner join t_mm_tracknumber endTrack on endTrack.Fid=mfo.CFEndTrackNumberID");
            sb.append(" where mft.fworkcenterid in (select fworkcenterid from " + tempTable + ")");
            sb.append(this.buildWhereSql());
            sb.append(" group by mfo.fid,mft.fmergeid,mft.fworkcenterid");
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append(" /*dialect*/ update " + tmpMergeTable + " t set (t.FFGQty,t.FBFQty)=");
            sb.append(" (select max(FRepairAmount),max(FScrapAmount)");
            sb.append(" from T_SFC_ProdorderComplete pc ");
            sb.append(" inner join T_SFC_ProdorderCompleteEntry pce on pc.fid=pce.fparentid");
            sb.append(" where pc.FProdID=t.fmoid and pc.FWorkCenterID=t.fworkcenterid");
            sb.append(" and pc.FMergeId=t.FMergeID");
            sb.append(" and pc.fbasestatus>3");
            sb.append(" )");
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append(" /*dialect*/ update " + tempTable + " t set (t.FFinishQty,t.FCPFGQty,t.FCPBFQty,t.FCount)=");
            sb.append(" (select sum(t2.FinishedQty),sum(t2.FFGQty),sum(t2.FBFQty),count(fmoid)");
            sb.append(" from " + tmpMergeTable + " t2 where t.fworkcenterid=t2.FWorkCenterID");
            sb.append(" )");
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append(" /*dialect*/ update " + tempTable + " t set t.FKGCount=");
            sb.append(" (select count(t2.FMergeID) from " + tmpMergeTable + " t2 ");
            sb.append(" where t.fworkcenterid=t2.FWorkCenterID and t2.FMergeStatus>=13) ");
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append("/*dialect*/ update " + tempTable + " t set t.FWGBL=to_char(round(t.FFinishQty/t.FPlanQty,4)*100,'fm9999990.009999') || '%'");
            sb.append(" where nvl(t.FPlanQty,0)>0");
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append("/*dialect*/ update " + tempTable + " t set t.FXMWCBL=to_char(round(t.FKGCount/t.FCount,4)*100,'fm9999990.009999') || '%'");
            sb.append(" where nvl(t.FCount,0)>0");
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select '" + this.projectName + "' as FProjectName,'" + this.trackNumber + "' as FTrackNumber,'" + this.endTrackNumebr + "' as FEndTrackNumber,t.* from " + tempTable + " t order by t.fworkcenternumber"));
            TempTablePool.getInstance((Context)this.ctx).releaseTable(tmpMergeTable);
        } else if (this.bjTotal) {
            tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(this.createTempTableForBj());
            StringBuffer sb = new StringBuffer();
            String tmpDataTable = TempTablePool.getInstance((Context)this.ctx).createTempTable("create table T_mo_temppsnb1(FBujian varchar(100),FMoID varchar(100))");
            sb.setLength(0);
            sb.append(" /*dialect*/ insert into " + tmpDataTable + "");
            sb.append(" select  distinct SUBSTR(rooting.fnumber,INSTR(rooting.fnumber,'(', 1, 1)+1,INSTR(rooting.fnumber, ')', 1, 1)-INSTR(rooting.fnumber, '(', 1, 1)-1) as fbujian,mfo.fid");
            sb.append(" from T_MM_ManufactureOrder mfo");
            sb.append(" inner join t_org_storage sou on mfo.FStorageOrgUnitID=sou.fid");
            sb.append(" inner join t_bd_material mat on mfo.fmaterialid=mat.fid");
            sb.append(" inner join t_mm_project pro on mfo.fprojectid=pro.fid");
            sb.append(" inner join t_mm_tracknumber track on mfo.FTrackID=track.fid");
            sb.append(" inner join t_mm_tracknumber endTrack on endTrack.Fid=mfo.CFEndTrackNumberID");
            sb.append(" inner join t_mm_standardrooting rooting on rooting.fid=mfo.froutingid");
            sb.append(" where 1=1 ");
            sb.append(this.buildWhereSql());
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append(" /*dialect*/ insert into " + tempTable + "(FBujian,FTotal)");
            sb.append(" select  FBujian,count(Fmoid)");
            sb.append(" from " + tmpDataTable + " t");
            sb.append(" group by t.FBujian");
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append(" /*dialect*/ update " + tempTable + " t set t.FKGQty=");
            sb.append(" (select count(t2.fmoid) ");
            sb.append(" from " + tmpDataTable + " t2 ");
            sb.append(" where t.fbujian=t2.fbujian");
            sb.append(" and exists(select 1 from T_MM_MFTOrderTechnics mft where mft.fbasestatus>=13 and mft.fparentid=t2.fmoid)");
            sb.append(" )");
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append(" /*dialect*/ update " + tempTable + " t set t.FWKGQty=");
            sb.append(" (select count(t2.fmoid) ");
            sb.append(" from " + tmpDataTable + " t2 ");
            sb.append(" where t.fbujian=t2.fbujian");
            sb.append(" and exists(select 1 from T_MM_MFTOrderTechnics mft where mft.fbasestatus<13 and mft.fparentid=t2.fmoid)");
            sb.append(" )");
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select '" + this.projectName + "' as FProjectName,'" + this.trackNumber + "' as FTrackNumber,'" + this.endTrackNumebr + "' as FEndTrackNumber,t.* from " + tempTable + " t order by FBujian"));
            TempTablePool.getInstance((Context)this.ctx).releaseTable(tmpDataTable);
        } else if (this.sjdwTotal) {
            tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(this.createTempTableForSjdw());
            StringBuffer sb = new StringBuffer();
            String tmpDataTable = TempTablePool.getInstance((Context)this.ctx).createTempTable("create table T_mo_temppsnb1(FWorkCenterID varchar(100),FWorkCenterNumber varchar(100),FWorkCenterName varchar(100),FMoID varchar(100))");
            sb.setLength(0);
            sb.append(" /*dialect*/ insert into " + tmpDataTable + "");
            sb.append(" select  wc.fid,wc.fnumber,wc.fname_l2,mfo.fid");
            sb.append(" from T_MM_ManufactureOrder mfo");
            sb.append(" inner join t_org_storage sou on mfo.FStorageOrgUnitID=sou.fid");
            sb.append(" inner join t_bd_material mat on mfo.fmaterialid=mat.fid");
            sb.append(" inner join t_mm_project pro on mfo.fprojectid=pro.fid");
            sb.append(" inner join t_mm_tracknumber track on mfo.FTrackID=track.fid");
            sb.append(" inner join t_mm_tracknumber endTrack on endTrack.Fid=mfo.CFEndTrackNumberID");
            sb.append(" inner join t_mm_standardrooting rooting on rooting.fid=mfo.froutingid");
            sb.append(" inner join t_mm_workcenter wc on mfo.CFAddressWorkCente=wc.fid");
            sb.append(" where 1=1 ");
            sb.append(this.buildWhereSql());
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append(" /*dialect*/ insert into " + tempTable + "(FWorkCenterId,FWorkCenterNumber,FWorkCenterName,FTotal)");
            sb.append(" select  FWorkCenterID,FWorkCenterNumber,FWorkCenterName,count(Fmoid)");
            sb.append(" from " + tmpDataTable + " t");
            sb.append(" group by FWorkCenterID,FWorkCenterNumber,FWorkCenterName");
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append(" /*dialect*/ update " + tempTable + " t set t.FKGQty=");
            sb.append(" (select count(t2.fmoid) ");
            sb.append(" from " + tmpDataTable + " t2 ");
            sb.append(" where t.FWorkCenterID=t2.FWorkCenterID");
            sb.append(" and exists(select 1 from T_MM_MFTOrderTechnics mft where mft.fbasestatus>=13 and mft.fparentid=t2.fmoid)");
            sb.append(" )");
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            sb.setLength(0);
            sb.append(" /*dialect*/ update " + tempTable + " t set t.FWKGQty=");
            sb.append(" (select count(t2.fmoid) ");
            sb.append(" from " + tmpDataTable + " t2 ");
            sb.append(" where t.FWorkCenterID=t2.FWorkCenterID");
            sb.append(" and exists(select 1 from T_MM_MFTOrderTechnics mft where mft.fbasestatus<13 and mft.fparentid=t2.fmoid)");
            sb.append(" )");
            DbUtil.execute((Context)this.ctx, (String)sb.toString());
            rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select '" + this.projectName + "' as FProjectName,'" + this.trackNumber + "' as FTrackNumber,'" + this.endTrackNumebr + "' as FEndTrackNumber,t.* from " + tempTable + " t order by FWorkCenterNumber"));
            TempTablePool.getInstance((Context)this.ctx).releaseTable(tmpDataTable);
        }
        TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
        return rs;
    }

    private String buildWhereSql() {
        StringBuffer sql = new StringBuffer();
        if (this.projectId != null) {
            sql.append(" and pro.fid='" + this.projectId + "'");
        }
        if (this.storageOrgId != null) {
            sql.append(" and sou.fid='" + this.storageOrgId + "'");
        }
        if (this.trackNumberId != null) {
            sql.append(" and track.fid='" + this.trackNumberId + "'");
        }
        if (this.endTrackNumebrId != null) {
            sql.append(" and endTrack.fid='" + this.endTrackNumebrId + "'");
        }
        if (this.materials != null && this.materials.length > 0) {
            sql.append(" and mat.fnumber in (" + EmmUtils.getSqlFromArray((String[])this.materials) + ")");
        }
        return sql.toString();
    }

    private String createTableForMergeQty() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_mo_temppsnb1(");
        sql.append("FMoID varchar(100),");
        sql.append("FMergeID varchar(100),");
        sql.append("FOperNo int,");
        sql.append("FMergeStatus int,");
        sql.append("FWorkCenterID varchar(100),");
        sql.append("FinishedQty numeric(28,4),");
        sql.append("FFGQty numeric(28,4),");
        sql.append("FBFQty numeric(28,4)");
        sql.append(")");
        return sql.toString();
    }

    private void initRptParams(RptParams params) throws BOSException, SQLException {
        IRowSet rss;
        String sql;
        String[] tmp;
        if (params.getObject("storage") != null) {
            this.storage = null;
            if (params.getObject("storage") instanceof StorageOrgUnitInfo) {
                StorageOrgUnitInfo sou = (StorageOrgUnitInfo)params.getObject("storage");
                this.storage = sou.getNumber();
            } else {
                this.storage = params.getObject("storage").toString();
            }
            String sql2 = "select fid,fname_l2 as fname  from t_org_storage where fnumber='" + this.storage + "'";
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql2);
            while (rs.next()) {
                this.storageOrgId = rs.getString("fid");
                this.storageOrgName = rs.getString("fname");
            }
        } else {
            this.storage = null;
        }
        if (params.getObject("project") != null) {
            tmp = ((String)params.getObject("project")).split(";");
            this.project = tmp[0].trim();
            sql = "select fid,fname_l2 as fname  from t_mm_project where fnumber='" + this.project + "'";
            rss = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rss.next()) {
                this.projectId = rss.getString("fid");
                this.projectName = rss.getString("fname");
            }
        } else {
            this.project = null;
        }
        if (params.getObject("trackNumber") != null) {
            tmp = ((String)params.getObject("trackNumber")).split(";");
            this.trackNumber = tmp[0].trim();
            sql = "select fid,fname_l2 as fname  from t_mm_trackNumber where fnumber='" + this.trackNumber + "'";
            rss = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rss.next()) {
                this.trackNumberId = rss.getString("fid");
                this.trackNumberName = rss.getString("fname");
            }
        } else {
            this.trackNumber = null;
        }
        if (params.getObject("endTrackNumber") != null) {
            tmp = ((String)params.getObject("endTrackNumber")).split(";");
            this.endTrackNumebr = tmp[0].trim();
            sql = "select fid,fname_l2 as fname  from t_mm_trackNumber where fnumber='" + this.endTrackNumebr + "'";
            IRowSet rsb = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rsb.next()) {
                this.endTrackNumebrId = rsb.getString("fid");
                this.endTrackNumebrName = rsb.getString("fname");
            }
        } else {
            this.endTrackNumebr = null;
        }
        if (params.getObject("material") != null) {
            tmp = ((String)params.getObject("material")).split(";");
            this.materials = new String[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                this.materials[i] = tmp[i].trim();
            }
        } else {
            this.materials = null;
        }
        if (params.getObject("radBZ") != null) {
            this.bzTotal = Boolean.parseBoolean(params.getObject("radBZ").toString());
        }
        if (params.getObject("radBJ") != null) {
            this.bjTotal = Boolean.parseBoolean(params.getObject("radBJ").toString());
        }
        if (params.getObject("radSJDW") != null) {
            this.sjdwTotal = Boolean.parseBoolean(params.getObject("radSJDW").toString());
        }
    }

    private String createTempTableForWc() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_mo_temppsnb1(");
        sql.append("FWorkCenterID varchar(100),");
        sql.append("FWorkCenterNumber varchar(100),");
        sql.append("FWorkCenterName varchar(100),");
        sql.append("FPlanQty numeric(28,4),");
        sql.append("FFinishQty numeric(28,4),");
        sql.append("FWGBL varchar(100),");
        sql.append("FCPFGQty numeric(28,4),");
        sql.append("FCPBFQty numeric(28,4),");
        sql.append("FCount int,");
        sql.append("FKGCount int,");
        sql.append("FXMWCBL varchar(100)");
        sql.append(")");
        return sql.toString();
    }

    private String createTempTableForBj() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_mo_temppsnb1(");
        sql.append("FBujian varchar(100),");
        sql.append("FTotal numeric(28,4),");
        sql.append("FKGQty numeric(28,4),");
        sql.append("FWKGQty numeric(28,4)");
        sql.append(")");
        return sql.toString();
    }

    private String createTempTableForSjdw() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_mo_temppsnb1(");
        sql.append("FWorkCenterID varchar(100),");
        sql.append("FWorkCenterNumber varchar(100),");
        sql.append("FWorkCenterName varchar(100),");
        sql.append("FTotal numeric(28,4),");
        sql.append("FKGQty numeric(28,4),");
        sql.append("FWKGQty numeric(28,4)");
        sql.append(")");
        return sql.toString();
    }

    protected ReportTitles getReportTitles(String s, RptParams rptparams) throws BaseException {
        ReportTitles title = new ReportTitles();
        title.AddTitle(1, this.getString(this.ctx, "SCWCQKHB_TABLE"));
        title.AddTitle(3, this.getString(this.ctx, "STORAGE_NAME") + this.storageOrgName);
        if (this.bzTotal) {
            title.AddTitle(6, this.getString(this.ctx, "TJFS_NAME") + this.getString(this.ctx, "ABZTJ_NAME"));
        } else if (this.bjTotal) {
            title.AddTitle(6, this.getString(this.ctx, "TJFS_NAME") + this.getString(this.ctx, "ABJTJ_NAME"));
        } else {
            title.AddTitle(6, this.getString(this.ctx, "TJFS_NAME") + this.getString(this.ctx, "AJSDWTJ_NAME"));
        }
        return title;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = new ReportHeader();
        if (this.bzTotal) {
            ReportHeader temp = header.addChild("FProjectName", this.getString(this.ctx, "XMH_NAME"));
            temp.setWidth(240);
            temp = header.addChild("FTrackNumber", this.getString(this.ctx, "KSGZH_NAME"));
            temp = header.addChild("FEndTrackNumber", this.getString(this.ctx, "JSGZH_NAME"));
            temp = header.addChild("FWorkCenterName", this.getString(this.ctx, "ZYBZ_NAME"));
            temp = header.addChild("FPlanQty", this.getString(this.ctx, "JHSL_QTY"));
            temp = header.addChild("FFinishQty", this.getString(this.ctx, "WGSL_QTY"));
            temp = header.addChild("FWGBL", this.getString(this.ctx, "WGBL_QTY"));
            temp = header.addChild("FCPFGQty", this.getString(this.ctx, "CPFGSL_QTY"));
            temp = header.addChild("FCPBFQty", this.getString(this.ctx, "CPBFSL_QTY"));
            temp = header.addChild("FCount", this.getString(this.ctx, "ZXS_QTY"));
            temp = header.addChild("FKGCount", this.getString(this.ctx, "KGXS_QTY"));
            temp = header.addChild("FXMWCBL", this.getString(this.ctx, "XMWCBFB_QTY"));
        } else if (this.bjTotal) {
            ReportHeader temp = header.addChild("FProjectName", this.getString(this.ctx, "XMH_NAME"));
            temp.setWidth(240);
            temp = header.addChild("FTrackNumber", this.getString(this.ctx, "KSGZH_NAME"));
            temp = header.addChild("FEndTrackNumber", this.getString(this.ctx, "JSGZH_NAME"));
            temp = header.addChild("FBujian", this.getString(this.ctx, "BJ_NAME"));
            temp = header.addChild("FTotal", this.getString(this.ctx, "ZS_QTY"));
            temp = header.addChild("FKGQty", this.getString(this.ctx, "KGSL_QTY"));
            temp = header.addChild("FWKGQty", this.getString(this.ctx, "WKGSL_QTY"));
        } else if (this.sjdwTotal) {
            ReportHeader temp = header.addChild("FProjectName", this.getString(this.ctx, "XMH_NAME"));
            temp.setWidth(240);
            temp = header.addChild("FTrackNumber", this.getString(this.ctx, "KSGZH_NAME"));
            temp = header.addChild("FEndTrackNumber", this.getString(this.ctx, "JSGZH_NAME"));
            temp = header.addChild("FWorkCenterName", this.getString(this.ctx, "SJDW_NAME"));
            temp = header.addChild("FTotal", this.getString(this.ctx, "ZS_QTY"));
            temp = header.addChild("FKGQty", this.getString(this.ctx, "KGSL_QTY"));
            temp = header.addChild("FWKGQty", this.getString(this.ctx, "WKGSL_QTY"));
        }
        return header;
    }
}

