/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.bl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.common.EmmUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BLYCLCYBRptServer
extends ReportServerBase {
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private String storage;
    private String project;
    private String trackNumber;
    private String endTrackNumebr;
    private String[] materials;
    private String storageOrgId;
    private String storageOrgNumber;
    private String storageOrgName;
    private String projectNumber;
    private String projectName;
    private String projectId;
    private String trackNumberId;
    private String trackNumberName;
    private String endTrackNumebrName;
    private String endTrackNumebrId;
    private Context ctx;
    private int opCount;

    private String getString(Context ctx, String name) {
        return EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)name, (Locale)ctx.getLocale());
    }

    protected IRowSet getReportData(String s, RptParams rptparams) throws Exception {
        this.ctx = this.getContext();
        this.initRptParams(rptparams);
        IRowSet rs = null;
        String tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(this.createTempTable());
        StringBuffer sb = new StringBuffer();
        sb.setLength(0);
        sb.append(" /*dialect*/ insert into " + tempTable);
        sb.append(" select distinct pro.fid,pro.fnumber,pro.fname_l2,");
        sb.append(" track.fid,track.fnumber,track.fname_l2,");
        sb.append(" endTrack.fid,endTrack.fnumber,endTrack.fname_l2,");
        sb.append(" rawMat.fid,rawMat.fnumber,rawMat.fname_l2,nb.CFSteelModel,");
        sb.append(" 0,0,0,0,0");
        sb.append(" from ct_mo_nestingbill nb");
        sb.append(" inner join t_org_storage sou on nb.CFStorageOrgUnitID=sou.fid");
        sb.append(" inner join  t_bd_material rawMat on nb.CFRawMaterialID=rawMat.fid");
        sb.append(" inner join t_mm_project pro on nb.cfprojectid=pro.fid");
        sb.append(" inner join t_mm_tracknumber track on nb.cfbegincarnoid=track.fid");
        sb.append(" inner join t_mm_tracknumber endTrack on endTrack.Fid=nb.cfendcarnoid");
        sb.append(" where 1=1 and nb.cfbasestatus>3");
        sb.append(this.buildWhereSql());
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" /*dialect*/ update " + tempTable + " t set t.FYJJH=");
        sb.append("(select sum(yd.CFQty) from CT_MO_YudingEZhiding yd");
        sb.append("  where 1=1 and yd.CFStorageOrgUnitID='" + this.storageOrgId + "'");
        sb.append(" and yd.CFProjectID=t.fprojectid and yd.CFBeginCarnoID=t.FTrackNumberID and yd.CFEndCarnoID=t.FEndTrackNumberID");
        sb.append(" and yd.CFMaterialID=t.FRawMaterialID )");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" /*dialect*/ update " + tempTable + " t set t.FEJJH=");
        sb.append("(select sum(sbe.fqty) from t_im_stocktransferbillentry  sbe");
        sb.append(" inner join t_im_stocktransferbill sb on sb.fid=sbe.fparentid");
        sb.append(" inner join t_mm_trackNumber tk on sbe.ftracknumberid=tk.fid");
        sb.append("  where 1=1 and sb.fbasestatus>3 and sb.freceiptstorageorgunitid='" + this.storageOrgId + "'");
        sb.append(" and sbe.fprojectid=t.fprojectid and tk.fnumber>='" + this.trackNumber + "' and tk.fnumber<='" + this.endTrackNumebr + "'");
        sb.append(" and sbe.fmaterialid=t.FRawMaterialID )");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
        sb.setLength(0);
        sb.append(" /*dialect*/ update " + tempTable + " t set t.FSJJH=");
        sb.append(" (select round(sum(nvl(nb.CFRemaindWeight,0))*sum(nvl(mpp.CFQty,0)),2) as CFRemaindWeight ");
        sb.append(" from CT_MO_NestingBill nb ");
        sb.append(" inner join CT_MO_MaterialRequPlan mpp on mpp.fsourcebillid=nb.fid");
        sb.append("  where 1=1 and nb.CFBaseStatus>3 and nb.CFStorageOrgUnitID='" + this.storageOrgId + "'");
        sb.append(" and nb.CFProjectID=t.fprojectid and nb.CFBeginCarnoID>='" + this.trackNumberId + "' and nb.CFEndCarnoID='" + this.endTrackNumebrId + "'");
        sb.append(" and nb.CFRawMaterialID=t.FRawMaterialID");
        sb.append(" )");
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
        DbUtil.execute((Context)this.ctx, (String)("/*dialect*/ update " + tempTable + " set FCY1=nvl(FEJJH,0)-nvl(FYJJH,0),FCY2=nvl(FSJJH,0)-nvl(FYJJH,0)"));
        rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select * from " + tempTable + " order by FRawMaterialNumber"));
        TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
        return rs;
    }

    private String buildWhereSql() {
        StringBuffer sql = new StringBuffer();
        if (this.projectId != null) {
            sql.append(" and pro.fid='" + this.projectId + "'");
        }
        if (this.storageOrgId != null) {
            sql.append(" and sou.fid='" + this.storageOrgId + "'");
        }
        if (this.trackNumberId != null) {
            sql.append(" and track.fid='" + this.trackNumberId + "'");
        }
        if (this.endTrackNumebrId != null) {
            sql.append(" and endTrack.fid='" + this.endTrackNumebrId + "'");
        }
        if (this.materials != null && this.materials.length > 0) {
            sql.append(" and rawMat.fnumber in (" + EmmUtils.getSqlFromArray((String[])this.materials) + ")");
        }
        return sql.toString();
    }

    private void initRptParams(RptParams params) throws BOSException, SQLException {
        IRowSet rss;
        String sql;
        String[] tmp;
        if (params.getObject("storage") != null) {
            this.storage = null;
            if (params.getObject("storage") instanceof StorageOrgUnitInfo) {
                StorageOrgUnitInfo sou = (StorageOrgUnitInfo)params.getObject("storage");
                this.storage = sou.getNumber();
            } else {
                this.storage = params.getObject("storage").toString();
            }
            String sql2 = "select fid,fname_l2 as fname  from t_org_storage where fnumber='" + this.storage + "'";
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql2);
            while (rs.next()) {
                this.storageOrgId = rs.getString("fid");
                this.storageOrgName = rs.getString("fname");
            }
        } else {
            this.storage = null;
        }
        if (params.getObject("project") != null) {
            tmp = ((String)params.getObject("project")).split(";");
            this.project = tmp[0].trim();
            sql = "select fid,fname_l2 as fname  from t_mm_project where fnumber='" + this.project + "'";
            rss = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rss.next()) {
                this.projectId = rss.getString("fid");
                this.projectName = rss.getString("fname");
            }
        } else {
            this.project = null;
        }
        if (params.getObject("trackNumber") != null) {
            tmp = ((String)params.getObject("trackNumber")).split(";");
            this.trackNumber = tmp[0].trim();
            sql = "select fid,fname_l2 as fname  from t_mm_trackNumber where fnumber='" + this.trackNumber + "'";
            rss = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rss.next()) {
                this.trackNumberId = rss.getString("fid");
                this.trackNumberName = rss.getString("fname");
            }
        } else {
            this.trackNumber = null;
        }
        if (params.getObject("endTrackNumber") != null) {
            tmp = ((String)params.getObject("endTrackNumber")).split(";");
            this.endTrackNumebr = tmp[0].trim();
            sql = "select fid,fname_l2 as fname  from t_mm_trackNumber where fnumber='" + this.endTrackNumebr + "'";
            IRowSet rsb = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rsb.next()) {
                this.endTrackNumebrId = rsb.getString("fid");
                this.endTrackNumebrName = rsb.getString("fname");
            }
        } else {
            this.endTrackNumebr = null;
        }
        if (params.getObject("material") != null) {
            tmp = ((String)params.getObject("material")).split(";");
            this.materials = new String[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                this.materials[i] = tmp[i].trim();
            }
        } else {
            this.materials = null;
        }
    }

    private String createTempTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_mo_temppsnb1(");
        sql.append("FProjectID varchar(100),");
        sql.append("FProjectNumber varchar(100),");
        sql.append("FProjectName varchar(100),");
        sql.append("FTrackNumberID varchar(100),");
        sql.append("FTrackNumber varchar(100),");
        sql.append("FTrackName varchar(100),");
        sql.append("FEndTrackNumberID varchar(100),");
        sql.append("FEndTrackNumber varchar(100),");
        sql.append("FEndTrackName varchar(100),");
        sql.append("FRawMaterialID varchar(100),");
        sql.append("FRawMaterialNumber varchar(100),");
        sql.append("FRawMaterialName varchar(100),");
        sql.append("FCZGG varchar(100),");
        sql.append("FYJJH numeric(28,4),");
        sql.append("FEJJH numeric(28,4),");
        sql.append("FSJJH numeric(28,4),");
        sql.append("FCY1 numeric(28,4),");
        sql.append("FCY2 numeric(28,4)");
        sql.append(")");
        return sql.toString();
    }

    protected ReportTitles getReportTitles(String s, RptParams rptparams) throws BaseException {
        ReportTitles title = new ReportTitles();
        title.AddTitle(1, this.getString(this.ctx, "YCLCY_TABLE"));
        title.AddTitle(3, this.getString(this.ctx, "STORAGE_NAME") + this.storageOrgName);
        return title;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = new ReportHeader();
        ReportHeader temp = header.addChild("FProjectName", this.getString(this.ctx, "XMH_NAME"));
        temp.setWidth(240);
        temp = header.addChild("FTrackNumber", this.getString(this.ctx, "KSGZH_NAME"));
        temp = header.addChild("FEndTrackNumber", this.getString(this.ctx, "JSGZH_NAME"));
        temp = header.addChild("FRawMaterialNumber", this.getString(this.ctx, "CLBM_NAME"));
        temp.setWidth(150);
        temp = header.addChild("FRawMaterialName", this.getString(this.ctx, "CLMC_NAME"));
        temp.setWidth(150);
        temp = header.addChild("FCZGG", this.getString(this.ctx, "CZGG_NAME"));
        temp = header.addChild("FYJJH", this.getString(this.ctx, "YJJHDE_NAME"));
        temp.setWidth(150);
        temp = header.addChild("FEJJH", this.getString(this.ctx, "EJJHFL_NAME"));
        temp.setWidth(150);
        temp = header.addChild("FSJJH", this.getString(this.ctx, "SJJHPS_NAME"));
        temp.setWidth(150);
        temp = header.addChild("FCY1", this.getString(this.ctx, "CY21_NAME"));
        temp = header.addChild("FCY2", this.getString(this.ctx, "CY31_NAME"));
        return header;
    }
}

