/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.pm.dp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.common.BillBaseStatusEnum;
import com.kingdee.eas.industry.emm.mm.pm.dp.DeliveryPlanFactory;
import com.kingdee.eas.industry.emm.mm.pm.dp.DeliveryPlanInfo;
import com.kingdee.eas.industry.emm.mm.pm.dp.app.AbstractDeliveryPlanControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DeliveryPlanControllerBean
extends AbstractDeliveryPlanControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.mm.pm.dp.app.DeliveryPlanControllerBean");

    @Override
    protected void _audit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DeliveryPlanInfo planInfo = (DeliveryPlanInfo)model;
        if (!planInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0010", (Locale)ctx.getLocale()) + planInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0217", (Locale)ctx.getLocale())));
        }
        String sql = "update CT_DP_DeliveryPlan set CFBaseStatus = 4,FAuditorID = ?,CFAuditDate = now()  where fid = ? ";
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        DbUtil.execute((Context)ctx, (String)"update CT_DP_DeliveryPlan set CFBaseStatus = 4,FAuditorID = ?,CFAuditDate = now()  where fid = ? ", (Object[])new Object[]{userInfo.getId().toString(), planInfo.getId().toString()});
        super._audit(ctx, model);
    }

    @Override
    protected void _audit(Context ctx, List billIDs) throws BOSException, EASBizException {
        if (billIDs.size() > 0) {
            String sql = "update CT_DP_DeliveryPlan set CFBaseStatus = 4,FAuditorID = ?,CFAuditDate = now()  where fid = ? ";
            for (int i = 0; i < billIDs.size(); ++i) {
                String billID = (String)billIDs.get(i);
                DeliveryPlanInfo planInfo = DeliveryPlanFactory.getLocalInstance(ctx).getDeliveryPlanInfo((IObjectPK)new ObjectUuidPK(billID));
                if (!planInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
                    throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0010", (Locale)ctx.getLocale()) + planInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0217", (Locale)ctx.getLocale())));
                }
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                DbUtil.execute((Context)ctx, (String)"update CT_DP_DeliveryPlan set CFBaseStatus = 4,FAuditorID = ?,CFAuditDate = now()  where fid = ? ", (Object[])new Object[]{userInfo.getId().toString(), planInfo.getId().toString()});
            }
        }
        super._audit(ctx, billIDs);
    }

    @Override
    protected void _batchSubmit(Context ctx, List billIDs) throws BOSException, EASBizException {
        if (billIDs.size() > 0) {
            String sql = "update CT_DP_DeliveryPlan set CFBaseStatus = 2  where fid = ? ";
            for (int i = 0; i < billIDs.size(); ++i) {
                String billID = (String)billIDs.get(i);
                DeliveryPlanInfo planInfo = DeliveryPlanFactory.getLocalInstance(ctx).getDeliveryPlanInfo((IObjectPK)new ObjectUuidPK(billID));
                if (!planInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) && !planInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
                    throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0010", (Locale)ctx.getLocale()) + planInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0218", (Locale)ctx.getLocale())));
                }
                DbUtil.execute((Context)ctx, (String)"update CT_DP_DeliveryPlan set CFBaseStatus = 2  where fid = ? ", (Object[])new Object[]{billID});
            }
        }
        super._batchSubmit(ctx, billIDs);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add(new SelectorItemInfo("id"));
            selectorItemCollection.add(new SelectorItemInfo("number"));
            selectorItemCollection.add(new SelectorItemInfo("baseStatus"));
            DeliveryPlanInfo planInfo = DeliveryPlanFactory.getLocalInstance(ctx).getDeliveryPlanInfo(pk, selectorItemCollection);
            if (planInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0010", (Locale)ctx.getLocale()) + planInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0219", (Locale)ctx.getLocale())));
            }
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DeliveryPlanInfo planInfo = (DeliveryPlanInfo)model;
        String billNumber = planInfo.getNumber();
        if ((billNumber == null || billNumber.trim().length() == 0) && planInfo.getOrgUnit() != null && planInfo.getOrgUnit().getId() != null) {
            this.setBillNumber(ctx, (IObjectValue)planInfo, planInfo.getOrgUnit().getId().toString());
        }
        if (planInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0010", (Locale)ctx.getLocale()) + planInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0220", (Locale)ctx.getLocale())));
        }
        if (planInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0010", (Locale)ctx.getLocale()) + planInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0221", (Locale)ctx.getLocale())));
        }
        planInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, (IObjectValue)planInfo);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DeliveryPlanInfo planInfo = (DeliveryPlanInfo)model;
        String billNumber = planInfo.getNumber();
        if ((billNumber == null || billNumber.trim().length() == 0) && planInfo.getOrgUnit() != null && planInfo.getOrgUnit().getId() != null) {
            this.setBillNumber(ctx, (IObjectValue)planInfo, planInfo.getOrgUnit().getId().toString());
        }
        if (planInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0010", (Locale)ctx.getLocale()) + planInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0222", (Locale)ctx.getLocale())));
        }
        planInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, (IObjectValue)planInfo);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DeliveryPlanInfo planInfo = (DeliveryPlanInfo)model;
        if (!planInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0010", (Locale)ctx.getLocale()) + planInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0046", (Locale)ctx.getLocale())));
        }
        String sql = "update CT_DP_DeliveryPlan set CFBaseStatus = 1,FAuditorID = ?,CFAuditDate = ?  where fid = ? ";
        DbUtil.execute((Context)ctx, (String)"update CT_DP_DeliveryPlan set CFBaseStatus = 1,FAuditorID = ?,CFAuditDate = ?  where fid = ? ", (Object[])new Object[]{null, null, planInfo.getId().toString()});
        super._unAudit(ctx, model);
    }

    @Override
    protected void _unAudit(Context ctx, List billIDs) throws BOSException, EASBizException {
        if (billIDs.size() > 0) {
            String sql = "update CT_DP_DeliveryPlan set CFBaseStatus = 1,FAuditorID = ?,CFAuditDate = ?  where fid = ? ";
            for (int i = 0; i < billIDs.size(); ++i) {
                String billID = (String)billIDs.get(i);
                DeliveryPlanInfo planInfo = DeliveryPlanFactory.getLocalInstance(ctx).getDeliveryPlanInfo((IObjectPK)new ObjectUuidPK(billID));
                if (!planInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                    throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0010", (Locale)ctx.getLocale()) + planInfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0223", (Locale)ctx.getLocale())));
                }
                DbUtil.execute((Context)ctx, (String)"update CT_DP_DeliveryPlan set CFBaseStatus = 1,FAuditorID = ?,CFAuditDate = ?  where fid = ? ", (Object[])new Object[]{null, null, billID});
            }
        }
        super._unAudit(ctx, billIDs);
    }

    protected void setBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID) throws EASBizException, BOSException {
        String billNumber = null;
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule(billInfo, bizOrgUnitID);
        if (ruleInfo != null) {
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(billInfo, ruleInfo);
        }
        if (billNumber != null) {
            billInfo.setString("number", billNumber);
        } else if (billInfo.getString("id") != null) {
            billInfo.setString("number", "AutoNumberFromBTP_" + billInfo.getString("id").toString());
        } else {
            billInfo.setString("number", "AutoNumberFromBTP_" + BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
        }
    }
}

