/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.pm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.mm.pm.report.app.AbstractDeliveryPlanReportFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DeliveryPlanReportFacadeControllerBean
extends AbstractDeliveryPlanReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.mm.pm.report.app.DeliveryPlanReportFacadeControllerBean");

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptParams pp = new RptParams();
        pp.setString("title", params.getString("init_title"));
        return pp;
    }

    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptParams rptParams = new RptParams();
        String orgUnit = (String)params.getObjectElement("orgUnitID");
        String project = (String)params.getObjectElement("projectID");
        Date bizDateFrom = (Date)params.getObjectElement("bizDateFrom");
        Date bizDateTo = (Date)params.getObjectElement("bizDateTo");
        String bizDateFromStr = DateTimeUtils.format((Date)bizDateFrom, (String)"yyyy-MM");
        String bizDateToStr = DateTimeUtils.format((Date)bizDateTo, (String)"yyyy-MM");
        String trackNo = (String)params.getObjectElement("trackNo");
        String nodeDesc = (String)params.getObjectElement("nodeDesc");
        StringBuffer sql = new StringBuffer();
        sql.append("select t2.FName_l2,t1.CFTrackNo,t1.CFQty,t1.FBizDate").append("\n");
        sql.append("from CT_DP_DeliveryPlan t1").append("\n");
        sql.append("inner join T_MM_Project t2 on t2.FID = t1.CFProjectID ").append("\n");
        sql.append("where 1 = 1 ").append("\n");
        if (project != null) {
            String projectIDs = null;
            if (project.contains(",")) {
                String[] projectIds = project.split(",");
                for (int i = 0; i < projectIds.length; ++i) {
                    String projectId = projectIds[i];
                    projectIDs = projectIds == null ? "'" + projectId + "'" : projectIDs + " ,'" + projectId + "'";
                }
            } else {
                projectIDs = "'" + project + "'";
            }
            sql.append("and t2.FID in (" + projectIDs + ")").append("\n");
        }
        if (orgUnit != null) {
            sql.append("and t1.CFOrgUnitID in ('" + orgUnit + "')").append("\n");
        }
        if (trackNo != null) {
            sql.append("and t1.CFTrackNo like '%" + trackNo + "%'").append("\n");
        }
        if (nodeDesc != null) {
            sql.append("and t1.CFNodeDesc like '%" + nodeDesc + "%'").append("\n");
        }
        if (bizDateFrom != null) {
            sql.append("and To_CHAR(t1.FBizDate,'YYYY-MM-DD')>='" + bizDateFromStr + "'").append("\n");
        }
        if (bizDateTo != null) {
            sql.append("and To_CHAR(t1.FBizDate,'YYYY-MM-DD')<='" + bizDateToStr + "'").append("\n");
        }
        sql.append("order by t1.FBizDate ASC").append("\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, Map<String, Map<String, String>>> allMap = new HashMap<String, Map<String, Map<String, String>>>();
        try {
            while (rs.next()) {
                Map<String, String> mapVal;
                Map<String, Map<String, String>> detailRsMap;
                String projectName = rs.getString(1);
                String trackNum = rs.getString(2);
                Integer qty = rs.getInt(3);
                Date bizDate = rs.getDate(4);
                bizDate = DateTimeUtils.parseDate((String)((Date)bizDate).toString(), (String)"yyyy-MM");
                int fromYear = DateTimeUtils.getYear((Date)bizDate);
                int fromMonth = DateTimeUtils.getMonth((Date)bizDate);
                String colName = fromYear + "_" + fromMonth;
                String key = projectName + colName;
                if (!allMap.containsKey(projectName)) {
                    detailRsMap = new HashMap();
                    mapVal = new HashMap<String, String>();
                    mapVal.put("trackNo", trackNum);
                    mapVal.put("project", projectName);
                    mapVal.put("colName", colName);
                    mapVal.put("qty", (String)((Object)qty));
                    mapVal.put("year", (String)((Object)Integer.valueOf(fromYear)));
                    detailRsMap.put(key, mapVal);
                    allMap.put(projectName, detailRsMap);
                    continue;
                }
                detailRsMap = (Map)allMap.get(projectName);
                if (detailRsMap.containsKey(key)) {
                    mapVal = (Map)detailRsMap.get(key);
                    Integer qtyTemp = (Integer)mapVal.get("qty");
                    String trackNoTemp = (String)mapVal.get("trackNo");
                    mapVal.put("qty", (String)((Object)Integer.valueOf(qtyTemp + qty)));
                    mapVal.put("trackNo", trackNoTemp + "\u3001" + trackNum);
                    continue;
                }
                mapVal = new HashMap();
                mapVal.put("trackNo", trackNum);
                mapVal.put("project", projectName);
                mapVal.put("colName", colName);
                mapVal.put("qty", (String)((Object)qty));
                mapVal.put("year", (String)((Object)Integer.valueOf(fromYear)));
                detailRsMap.put(key, mapVal);
            }
            rptParams.setObject("allMap", allMap);
        }
        catch (Exception e) {
            throw new SQLDataException();
        }
        return rptParams;
    }
}

