/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.pm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class ProjMonthCompWorkPlanTotalReport
extends ReportServerBase {
    private Context ctx;
    private Date month;
    private String sou;
    private String souid = null;
    private String project;
    private String projectidlist = null;
    private String monthstr = null;
    private SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM");
    private SimpleDateFormat dfd = new SimpleDateFormat("yyyy-MM-dd");
    private int days = 0;

    protected IRowSet getReportData(String arg0, RptParams params) throws Exception {
        this.ctx = this.getContext();
        this.initRptParams(params);
        String tempTableResult = TempTablePool.getInstance((Context)this.getContext()).createTempTable("CREATE TABLE NEWDATA (   FStorageOrgUnitId VARCHAR(44),  FProjectId VARCHAR(44),   Fprojectname VARCHAR(80),  Ftype int,  FDesc VARCHAR(44),  fmonth VARCHAR(44)," + this.getDaySql() + "  ) \n");
        DbUtil.execute((Context)this.getContext(), (String)this.getInsertSqlForResult(tempTableResult));
        IRowSet set = DbUtil.executeQuery((Context)this.getContext(), (String)this.getResultSql(tempTableResult));
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTableResult);
        return set;
    }

    private String getResultSql(String tempTableResult) {
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/ select FStorageOrgUnitId,FProjectId,fmonth,Ftype,Fprojectname,FDesc,");
        for (int i = 0; i < this.days; ++i) {
            sql.append("WMSYS.WM_CONCAT(Fday" + (i + 1) + ") as Fday" + (i + 1) + "");
            if (i >= this.days - 1) continue;
            sql.append(",");
        }
        sql.append(" from " + tempTableResult);
        sql.append(" group by Fprojectname,FDesc,FStorageOrgUnitId,FProjectId,fmonth,Ftype ");
        sql.append(" order by Fprojectname,Ftype ");
        return sql.toString();
    }

    private String getInsertSqlForResult(String tempTableResult) {
        int i;
        StringBuffer sql = new StringBuffer();
        if (this.souid == null || "".equals(this.souid)) {
            try {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0249", (Locale)this.getContext().getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0250", (Locale)this.getContext().getLocale())));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        sql.append("/*dialect*/ insert into " + tempTableResult);
        sql.append(" select  * from (");
        sql.append(" select  '").append(this.souid).append("' as FStorageOrgUnitId,");
        sql.append(" fid as FProjectId, ");
        sql.append(" fname_l2 as Fprojectname, ");
        sql.append(" 1 as Ftype, ");
        sql.append(" '").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0251", (Locale)this.getContext().getLocale())).append("' as FDesc, ");
        sql.append(" '").append(this.monthstr).append("' as fmonth ,");
        for (i = 0; i < this.days; ++i) {
            sql.append(" ' '  as FDay" + (i + 1));
            if (i >= this.days - 1) continue;
            sql.append(",");
        }
        sql.append(" From t_mm_Project ");
        if (this.project == null || "".equals(this.project)) {
            sql.append(" where fid in(Select Cfprojectid from CT_PM_YearRollingPlan where ");
            if (!"8vJD+kZuRLuQlkF2ysZ3b8znrtQ=".equals(this.souid)) {
                sql.append(" Cfmanufactureorgunitid = '").append(this.souid).append("' and ");
            }
            sql.append(" Exists(Select 1 from Ct_Pm_Yearrollingplanentrys  a where a.fparentid = CT_PM_YearRollingPlan.fid and to_char( a.cffinishtime,'yyyy-MM') = '").append(this.dfm.format(this.month)).append("'))   ");
        } else {
            sql.append(" where fid in(").append(this.projectidlist).append(") ");
        }
        sql.append(" union ");
        sql.append(" select  '").append(this.souid).append("' as FStorageOrgUnitId,");
        sql.append(" fid as FProjectId, ");
        sql.append(" fname_l2 as Fprojectname, ");
        sql.append(" 2 as Ftype, ");
        sql.append(" '").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0252", (Locale)this.getContext().getLocale())).append("' as FDesc, ");
        sql.append(" '").append(this.monthstr).append("' as fmonth ,");
        for (i = 0; i < this.days; ++i) {
            sql.append(" ' '  as FDay" + (i + 1));
            if (i >= this.days - 1) continue;
            sql.append(",");
        }
        sql.append(" From t_mm_Project ");
        if (this.project == null || "".equals(this.project)) {
            sql.append(" where fid in(Select Cfprojectid from CT_PM_YearRollingPlan where  ");
            if (!"8vJD+kZuRLuQlkF2ysZ3b8znrtQ=".equals(this.souid)) {
                sql.append(" Cfmanufactureorgunitid = '").append(this.souid).append("' and ");
            }
            sql.append(" Exists(Select 1 from Ct_Pm_Yearrollingplanentrys  a where a.fparentid = CT_PM_YearRollingPlan.fid and to_char( a.cffinishtime,'yyyy-MM') = '").append(this.dfm.format(this.month)).append("'))   ");
        } else {
            sql.append(" where fid in(").append(this.projectidlist).append(") ");
        }
        sql.append(" ) kk ");
        sql.append(" order by kk.FStorageOrgUnitId,kk.FProjectId,kk.Ftype ");
        return sql.toString();
    }

    private String getDaySql() {
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < this.days; ++i) {
            sql.append("Fday" + (i + 1) + " varchar(2000) DEFAULT('')");
            if (i >= this.days - 1) continue;
            sql.append(",");
        }
        return sql.toString();
    }

    private void initRptParams(RptParams params) throws BOSException {
        if (params.getObject("month") != null) {
            String temp;
            this.monthstr = temp = (String)params.getObject("month");
            try {
                this.month = this.dfm.parse(temp);
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.month);
                this.days = cal.getActualMaximum(5);
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        } else {
            this.month = null;
        }
        if (params.getObject("storageOrgUnit") != null) {
            this.sou = (String)params.getObject("storageOrgUnit");
            CoreBaseCollection souInfo = StorageOrgUnitFactory.getLocalInstance((Context)this.ctx).getCollection("select fid where number='" + this.sou + "'");
            this.souid = souInfo.get(0).getId().toString();
        } else {
            this.sou = null;
        }
        if (params.getObject("project") != null) {
            this.project = (String)params.getObject("project");
            String projectreplace = this.project.replace(";", "','");
            projectreplace = projectreplace.replace(" ", "");
            CoreBaseCollection projects = ProjectFactory.getLocalInstance((Context)this.ctx).getCollection("select fid where number in ('" + projectreplace + "')");
            if (projects != null && projects.size() > 0) {
                for (int i = 0; i < projects.size(); ++i) {
                    this.projectidlist = i == 0 ? "'" + projects.get(i).getId().toString() + "'" : this.projectidlist + ",'" + projects.get(i).getId().toString() + "'";
                }
            }
        } else {
            this.project = null;
        }
    }

    protected ReportTitles getReportTitles(String reportID, RptParams params) throws BaseException {
        CoreBaseCollection souInfo;
        ReportTitles titles = new ReportTitles();
        titles.AddTitle(0, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0253", (Locale)this.getContext().getLocale()));
        titles.AddTitle(1, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0254", (Locale)this.getContext().getLocale()) + this.dfm.format(this.month));
        if (this.sou != null && (souInfo = StorageOrgUnitFactory.getLocalInstance((Context)this.ctx).getCollection("select name where number='" + this.sou + "'")) != null && souInfo.size() > 0) {
            titles.AddTitle(2, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0255", (Locale)this.getContext().getLocale()) + ((StorageOrgUnitInfo)souInfo.get(0)).getName());
        }
        if (this.project != null) {
            String projectreplace = this.project.replace(";", "','");
            projectreplace = projectreplace.replace(" ", "");
            CoreBaseCollection projects = ProjectFactory.getLocalInstance((Context)this.ctx).getCollection("select name where number='" + projectreplace + "'");
            String projectnamelist = "";
            if (projects != null && projects.size() > 0) {
                for (int i = 0; i < projects.size(); ++i) {
                    projectnamelist = i == 0 ? "" + projects.get(i).get("name").toString() + "" : projectnamelist + "," + projects.get(i).get("name").toString() + "";
                }
            }
            if (projects != null && projects.size() > 0) {
                titles.AddTitle(3, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0256", (Locale)this.getContext().getLocale()) + projectnamelist);
            }
        }
        titles.AddTitle(4, " ");
        titles.AddTitle(5, " ");
        titles.AddTitle(6, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0257", (Locale)this.getContext().getLocale()));
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams params) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        ReportHeader temp = null;
        temp = reportHeader.addChild("FStorageOrgUnitId", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0258", (Locale)this.getContext().getLocale()));
        temp.setVisible(false);
        temp = reportHeader.addChild("FProjectId", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0259", (Locale)this.getContext().getLocale()));
        temp.setVisible(false);
        temp = reportHeader.addChild("fmonth", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0260", (Locale)this.getContext().getLocale()));
        temp.setVisible(false);
        temp = reportHeader.addChild("Ftype", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0261", (Locale)this.getContext().getLocale()));
        temp.setVisible(false);
        temp = reportHeader.addChild("Fprojectname", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0234", (Locale)this.getContext().getLocale()));
        temp.setMergeable(true);
        temp = reportHeader.addChild("FDesc", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0262", (Locale)this.getContext().getLocale()));
        temp.setMergeable(true);
        temp.setWidth(60);
        for (int i = 0; i < this.days; ++i) {
            reportHeader.addChild("Fday" + (i + 1), i + 1 + "");
        }
        return reportHeader;
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        return totalFilter;
    }
}

