/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.pm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.common.utils.DateUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import edu.emory.mathcs.backport.java.util.Collections;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ProjectPlanCompleteReportSever
extends ReportServerBase {
    protected IRowSet getReportData(String arg0, RptParams arg1) throws Exception {
        return null;
    }

    private int getYear(String time) {
        String[] strs = time.split("-");
        return Integer.parseInt(strs[0]);
    }

    private int getMonth(String time) {
        String[] strs = time.split("-");
        return Integer.parseInt(strs[1]);
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        String startTime = filter.getString("startTime");
        String endTime = filter.getString("endTime");
        int starYear = this.getYear(startTime);
        int endYear = this.getYear(endTime);
        Date startDate = DateUtil.stringToDateFormat(startTime, Constants.FORMAT_MONTH);
        Date endDate = DateUtil.stringToDateFormat(endTime, Constants.FORMAT_MONTH);
        int month = DateUtil.getMonth(startDate, endDate) + 1;
        ReportHeader reportHeader = super.getReportHeader(reportID, filter);
        ReportHeader projectName = reportHeader.addChild("projectName", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0234", (Locale)this.getContext().getLocale()));
        projectName.setMergeable(true);
        ReportHeader manufactureOrgUnit = reportHeader.addChild("manufactureOrgUnit", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0235", (Locale)this.getContext().getLocale()));
        manufactureOrgUnit.setMergeable(true);
        ReportHeader taskDesc = reportHeader.addChild("taskDesc", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0236", (Locale)this.getContext().getLocale()));
        taskDesc.setMergeable(true);
        reportHeader.addChild("qtyStr", "");
        for (int i = starYear; i <= endYear; ++i) {
            ReportHeader yearHeader = reportHeader.addChild("year" + i, Integer.valueOf(i).toString());
            ReportHeader yearSumHeader = reportHeader.addChild("yearSum" + i, Integer.valueOf(i).toString() + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0237", (Locale)this.getContext().getLocale()));
            yearSumHeader.addChild("yearPlanSum" + i, i + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0238", (Locale)this.getContext().getLocale()));
            yearSumHeader.addChild("yearActualSum" + i, i + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0239", (Locale)this.getContext().getLocale()));
            for (int j = 1; j <= month; ++j) {
                Date curDate = null;
                curDate = i == starYear && j == 1 ? startDate : DateUtil.addMonth(startDate, j - 1);
                Calendar curCalendar = Calendar.getInstance();
                curCalendar.setTime(curDate);
                if (i != curCalendar.get(1)) continue;
                ReportHeader monthHeader = yearHeader.addChild("month" + i + j, DateUtil.DateToString(curDate, Constants.FORMAT_MONTH));
                monthHeader.addChild("monthPlan" + i + j, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0240", (Locale)this.getContext().getLocale()));
                monthHeader.addChild("monthActual" + i + j, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0241", (Locale)this.getContext().getLocale()));
            }
        }
        return reportHeader;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        String storageOrgUnitId = filter.getString("storageOrgUnit.id");
        StorageOrgUnitInfo storageInfo = StorageOrgUnitFactory.getLocalInstance((Context)this.getContext()).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageOrgUnitId));
        String manufactureOrgUnitId = filter.getString("manufactureOrgUnitId");
        String manufactureName = "";
        if (manufactureOrgUnitId != null) {
            StorageOrgUnitInfo manufactureInfo = StorageOrgUnitFactory.getLocalInstance((Context)this.getContext()).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(manufactureOrgUnitId));
            manufactureName = manufactureInfo.getName();
        }
        String startTime = filter.getString("startTime");
        String endTime = filter.getString("endTime");
        ReportTitles reportTitles = new ReportTitles();
        reportTitles.AddTitle(0, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0242", (Locale)this.getContext().getLocale()) + storageInfo.getName());
        reportTitles.AddTitle(1, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0243", (Locale)this.getContext().getLocale()) + manufactureName);
        reportTitles.AddTitle(2, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0244", (Locale)this.getContext().getLocale()) + startTime);
        reportTitles.AddTitle(3, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0245", (Locale)this.getContext().getLocale()) + endTime);
        return reportTitles;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String createTempName = null;
        String createTempSql = this.createTempTable(reportID, filter);
        try {
            createTempName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTempSql);
            this.insertTempTable(createTempName, filter);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        return createTempName;
    }

    public String createTempTable(String reportID, RptParams filter) throws BOSException {
        StringBuffer createSql = new StringBuffer();
        try {
            String startTime = filter.getString("startTime");
            String endTime = filter.getString("endTime");
            int starYear = this.getYear(startTime);
            int endYear = this.getYear(endTime);
            Date startDate = DateUtil.stringToDateFormat(startTime, Constants.FORMAT_MONTH);
            Date endDate = DateUtil.stringToDateFormat(endTime, Constants.FORMAT_MONTH);
            int month = DateUtil.getMonth(startDate, endDate) + 1;
            createSql.append("create Table ProjectPlanComplete (");
            createSql.append("projectName VARCHAR(255),");
            createSql.append("taskDesc VARCHAR(255),");
            createSql.append("qtyStr VARCHAR(44),");
            for (int i = starYear; i <= endYear; ++i) {
                for (int j = 1; j <= month; ++j) {
                    Date curDate = null;
                    curDate = i == starYear && j == 1 ? startDate : DateUtil.addMonth(startDate, j - 1);
                    Calendar curCalendar = Calendar.getInstance();
                    curCalendar.setTime(curDate);
                    if (i != curCalendar.get(1)) continue;
                    createSql.append("monthPlan" + i + j).append(" VARCHAR(800) ,");
                    createSql.append("monthActual" + i + j).append(" VARCHAR(800) ,");
                }
                createSql.append("yearPlanSum" + i).append(" VARCHAR(44) ,");
                createSql.append("yearActualSum" + i).append(" VARCHAR(44) ,");
            }
            createSql.append("manufactureOrgUnit nvarchar(255))");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return createSql.toString();
    }

    public void insertTempTable(String createTempName, RptParams filter) throws BOSException {
        String startTime = filter.getString("startTime");
        String endTime = filter.getString("endTime");
        int starYear = this.getYear(startTime);
        int endYear = this.getYear(endTime);
        Date startDate = DateUtil.stringToDateFormat(startTime, Constants.FORMAT_MONTH);
        Date endDate = DateUtil.stringToDateFormat(endTime, Constants.FORMAT_MONTH);
        int month = 0;
        try {
            month = DateUtil.getMonth(startDate, endDate) + 1;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Map dataMap = this.getProjectPlan(filter);
        filter.setBoolean("yearmonth", true);
        Map countDataMap = this.getProjectPlan(filter);
        Set keySet = countDataMap.keySet();
        Iterator keyIt = keySet.iterator();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        StringBuffer insertSql = new StringBuffer();
        StringBuffer valueSql = new StringBuffer();
        insertSql.append("INSERT INTO ").append(createTempName).append(" ");
        insertSql.append("(projectName,");
        insertSql.append("qtyStr,");
        valueSql.append(" VALUES (?,?,");
        int count = 0;
        for (int i = starYear; i <= endYear; ++i) {
            for (int j = 1; j <= month; ++j) {
                Date curDate = null;
                curDate = i == starYear && j == 1 ? startDate : DateUtil.addMonth(startDate, j - 1);
                Calendar curCalendar = Calendar.getInstance();
                curCalendar.setTime(curDate);
                if (i != curCalendar.get(1)) continue;
                insertSql.append("monthPlan" + i + j).append(",");
                insertSql.append("monthActual" + i + j).append(",");
                valueSql.append("?,?,");
                ++count;
                ++count;
            }
            insertSql.append("yearPlanSum" + i).append(",");
            insertSql.append("yearActualSum" + i).append(",");
            valueSql.append("?,?,");
            ++count;
            ++count;
        }
        insertSql.append("taskDesc,");
        valueSql.append("?,");
        insertSql.append("manufactureOrgUnit)");
        valueSql.append("?);");
        insertSql.append(valueSql);
        Object[] objectSum = new Object[4 + count];
        objectSum[0] = EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0246", (Locale)this.getContext().getLocale());
        while (keyIt.hasNext()) {
            String key = (String)keyIt.next();
            Map objMap = (Map)countDataMap.get(key);
            String Cfprojectid = (String)objMap.get("Cfprojectid");
            String projectName = (String)objMap.get("projectName");
            String storageName = (String)objMap.get("storageName");
            String CFManufactureOrgUnitID = (String)objMap.get("CFManufactureOrgUnitID");
            String CFtaskdescriptionID = (String)objMap.get("CFtaskdescriptionID");
            String taskDesc = (String)objMap.get("taskDesc");
            Object[] object = new Object[4 + count];
            Object[] trackNum = new Object[4 + count];
            object[0] = projectName;
            trackNum[0] = projectName;
            object[1] = EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0247", (Locale)this.getContext().getLocale());
            trackNum[1] = EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0248", (Locale)this.getContext().getLocale());
            int index = 2;
            for (int i = starYear; i <= endYear; ++i) {
                BigDecimal planSum = BigDecimal.ZERO;
                BigDecimal actualSum = BigDecimal.ZERO;
                for (int j = 1; j <= month; ++j) {
                    Date curDate = null;
                    curDate = i == starYear && j == 1 ? startDate : DateUtil.addMonth(startDate, j - 1);
                    Calendar curCalendar = Calendar.getInstance();
                    curCalendar.setTime(curDate);
                    if (i != curCalendar.get(1)) continue;
                    String mapKey = Cfprojectid + CFManufactureOrgUnitID + CFtaskdescriptionID + curCalendar.get(1) + (curCalendar.get(2) + 1);
                    Map projectPlanMap = (Map)dataMap.get(mapKey);
                    if (projectPlanMap != null) {
                        BigDecimal cellSum;
                        if (projectPlanMap.get("planQty") != null) {
                            object[index] = projectPlanMap.get("planQty");
                            String planTrackNum = (String)projectPlanMap.get("planTrackNum");
                            planTrackNum = this.trackNumFormart(planTrackNum);
                            trackNum[index] = planTrackNum;
                            BigDecimal planQty = (BigDecimal)projectPlanMap.get("planQty");
                            planSum = planSum.add(planQty);
                            if (objectSum[index] == null) {
                                objectSum[index] = BigDecimal.ZERO;
                            }
                            cellSum = (BigDecimal)objectSum[index];
                            objectSum[index] = cellSum.add(planQty);
                        } else {
                            object[index] = BigDecimal.ZERO;
                            trackNum[index] = null;
                        }
                        ++index;
                        if (projectPlanMap.get("actualQty") != null) {
                            object[index] = projectPlanMap.get("actualQty");
                            String actualTrackNum = (String)projectPlanMap.get("actualTrackNum");
                            actualTrackNum = this.trackNumFormart(actualTrackNum);
                            trackNum[index] = actualTrackNum;
                            BigDecimal actualQty = (BigDecimal)projectPlanMap.get("actualQty");
                            actualSum = actualSum.add(actualQty);
                            if (objectSum[index] == null) {
                                objectSum[index] = BigDecimal.ZERO;
                            }
                            cellSum = (BigDecimal)objectSum[index];
                            objectSum[index] = cellSum.add(actualQty);
                        } else {
                            object[index] = BigDecimal.ZERO;
                            trackNum[index] = null;
                        }
                        ++index;
                        continue;
                    }
                    object[index] = BigDecimal.ZERO;
                    trackNum[index] = null;
                    object[++index] = BigDecimal.ZERO;
                    trackNum[index] = null;
                    ++index;
                }
                if (planSum == null) {
                    planSum = BigDecimal.ZERO;
                }
                object[index] = planSum;
                if (objectSum[index] == null) {
                    objectSum[index] = BigDecimal.ZERO;
                }
                BigDecimal cellPlanSum = (BigDecimal)objectSum[index];
                objectSum[index] = cellPlanSum.add(planSum);
                ++index;
                if (actualSum == null) {
                    actualSum = BigDecimal.ZERO;
                }
                object[index] = actualSum;
                if (objectSum[index] == null) {
                    objectSum[index] = BigDecimal.ZERO;
                }
                BigDecimal cellActualSum = (BigDecimal)objectSum[index];
                objectSum[index] = cellActualSum.add(actualSum);
                ++index;
            }
            object[4 + count - 2] = taskDesc;
            trackNum[4 + count - 2] = taskDesc;
            object[4 + count - 1] = storageName;
            trackNum[4 + count - 1] = storageName;
            paramsList.add(object);
            paramsList.add(trackNum);
        }
        paramsList.add(objectSum);
        DbUtil.executeBatch((Context)this.getContext(), (String)insertSql.toString(), paramsList);
    }

    public Map getProjectPlan(RptParams filter) throws BOSException {
        Boolean yearmonth = filter.getBoolean("yearmonth");
        HashMap dataMap = new HashMap();
        IRowSet rowSet = null;
        String storageOrgUnitId = filter.getString("storageOrgUnit.id");
        String manufactureOrgUnitId = filter.getString("manufactureOrgUnitId");
        String startTime = filter.getString("startTime");
        String endTime = filter.getString("endTime");
        int startYear = this.getYear(startTime);
        int endYear = this.getYear(endTime);
        int startMonth = this.getMonth(startTime);
        int endMonth = this.getMonth(endTime);
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("/*dialect*/ Select CT_PM_YearRollingPlan.Cfprojectid,");
            sql.append("T_MM_PROJECT.FNAME_L2 projectName,");
            sql.append("CT_PM_YearRollingPlan.CFManufactureOrgUnitID,");
            sql.append("ENTRYS.CFtaskdescriptionID,");
            sql.append("taskDes.Fdescription_L2 taskDesc,");
            sql.append("T_ORG_STORAGE.FNAME_L2 storageName,");
            if (yearmonth.equals(Boolean.FALSE)) {
                sql.append("ENTRYS.Cfyear,");
                sql.append("ENTRYS.Cfmonth,");
            }
            sql.append("count(CT_PM_YearRollingPlan.fid) planQty,");
            sql.append("wm_concat(substr(Tracknum.Fnumber, -4)) planTrackNum,");
            sql.append("0 actualQty,");
            sql.append("'' actualTrackNum ");
            sql.append("from CT_PM_YearRollingPlan ");
            sql.append("LEFT JOIN CT_PM_YEARROLLINGPLANENTRYS ENTRYS ON ENTRYS.Fparentid = CT_PM_YearRollingPlan.Fid ");
            sql.append("LEFT JOIN CT_BAS_TaskDescription taskDes ON ENTRYS.CFTASKDESCRIPTIONID = taskDes.Fid ");
            sql.append("LEFT JOIN T_MM_PROJECT ON T_MM_PROJECT.FID = CT_PM_YearRollingPlan.Cfprojectid ");
            sql.append("LEFT JOIN T_ORG_STORAGE ON T_ORG_STORAGE.FID = CT_PM_YearRollingPlan.CFManufactureOrgUnitID ");
            sql.append("LEFT JOIN T_MM_TRACKNUMBER Tracknum ON Tracknum.FID = ENTRYS.Cftracknumberid ");
            sql.append("LEFT JOIN  (Select CT_BAS_RollingPTE.Cfmaterialid,").append("CT_BAS_RollingPlanTemplate.Cfprojectid,").append("CT_BAS_RollingPlanTemplate.Cfstorageorgunitid,").append("CT_BAS_RollingPTE.Cftaskremarkid ").append("FROM CT_BAS_RollingPlanTemplate ").append("LEFT JOIN CT_BAS_RollingPTE ON CT_BAS_RollingPTE.Fparentid = CT_BAS_RollingPlanTemplate.Fid) rollPlanTemplate ").append("ON rollPlanTemplate.Cfprojectid = CT_PM_YearRollingPlan.Cfprojectid ").append("AND rollPlanTemplate.Cfstorageorgunitid = CT_PM_YearRollingPlan.CFManufactureOrgUnitID ").append("AND rollPlanTemplate.Cftaskremarkid =  ENTRYS.CFTASKDESCRIPTIONID ");
            sql.append("LEFT JOIN T_Mm_Manufactureorder ON T_Mm_Manufactureorder.Fstorageorgunitid = rollPlanTemplate.Cfstorageorgunitid ").append("AND rollPlanTemplate.Cfprojectid = T_Mm_Manufactureorder.Fprojectid ").append("AND rollPlanTemplate.Cfmaterialid = T_Mm_Manufactureorder.Fmaterialid ").append("AND T_Mm_Manufactureorder.Fbasestatus = 8 ");
            sql.append("LEFT JOIN T_MM_TRACKNUMBER endTracknum ON endTracknum.Fid = T_Mm_Manufactureorder.Ftrackid ");
            sql.append("Where ");
            sql.append("To_date(ENTRYS.Cfyear||'-'||ENTRYS.Cfmonth,'yyyy-MM') >= To_date('").append(startYear).append("-").append(startMonth).append("','yyyy-MM') ");
            sql.append("And To_date(ENTRYS.Cfyear||'-'||ENTRYS.Cfmonth,'yyyy-MM') <= To_date('").append(endYear).append("-").append(endMonth).append("','yyyy-MM') ");
            sql.append("And CT_PM_YearRollingPlan.Cfstorageorgunitid = '").append(storageOrgUnitId).append("' ");
            if (manufactureOrgUnitId != null) {
                sql.append("And CT_PM_YearRollingPlan.CFManufactureOrgUnitID = '").append(manufactureOrgUnitId).append("' ");
            }
            sql.append("GROUP BY ");
            sql.append("CT_PM_YearRollingPlan.Cfprojectid,");
            sql.append("T_MM_PROJECT.FNAME_L2,");
            sql.append("CT_PM_YearRollingPlan.CFManufactureOrgUnitID,");
            sql.append("ENTRYS.CFtaskdescriptionID,");
            sql.append("taskDes.Fdescription_L2,");
            if (yearmonth.equals(Boolean.FALSE)) {
                sql.append("ENTRYS.Cfyear,");
                sql.append("ENTRYS.Cfmonth,");
            }
            sql.append("T_ORG_STORAGE.FNAME_L2 ");
            rowSet = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
            while (rowSet.next()) {
                String Cfprojectid = rowSet.getString("Cfprojectid");
                String projectName = rowSet.getString("projectName");
                String CFManufactureOrgUnitID = rowSet.getString("CFManufactureOrgUnitID");
                String CFtaskdescriptionID = rowSet.getString("CFtaskdescriptionID");
                String taskDesc = rowSet.getString("taskDesc");
                String storageName = rowSet.getString("storageName");
                int Cfyear = 0;
                int Cfmonth = 0;
                if (yearmonth.equals(Boolean.FALSE)) {
                    Cfyear = rowSet.getInt("Cfyear");
                    Cfmonth = rowSet.getInt("Cfmonth");
                }
                BigDecimal planQty = rowSet.getBigDecimal("planQty");
                String planTrackNum = rowSet.getString("planTrackNum");
                BigDecimal actualQty = rowSet.getBigDecimal("actualQty");
                String actualTrackNum = rowSet.getString("actualTrackNum");
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                rowMap.put("Cfprojectid", Cfprojectid);
                rowMap.put("projectName", projectName);
                rowMap.put("CFManufactureOrgUnitID", CFManufactureOrgUnitID);
                rowMap.put("CFtaskdescriptionID", CFtaskdescriptionID);
                rowMap.put("taskDesc", taskDesc);
                rowMap.put("storageName", storageName);
                rowMap.put("Cfyear", Cfyear);
                rowMap.put("Cfmonth", Cfmonth);
                rowMap.put("planQty", planQty);
                rowMap.put("planTrackNum", planTrackNum);
                rowMap.put("actualQty", actualQty);
                rowMap.put("actualTrackNum", actualTrackNum);
                dataMap.put(Cfprojectid + CFManufactureOrgUnitID + CFtaskdescriptionID + Cfyear + Cfmonth, rowMap);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return dataMap;
    }

    public String trackNumFormart(String trackNum) {
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        StringBuffer sb = null;
        if (trackNum != null) {
            sb = new StringBuffer();
            ArrayList<String> list = new ArrayList<String>();
            String[] arrayStr = trackNum.split(",");
            for (int i = 0; i < arrayStr.length; ++i) {
                list.add(arrayStr[i]);
            }
            Collections.sort(list);
            Integer curInt = null;
            int count = 0;
            for (int i = 0; i < list.size(); ++i) {
                String str = (String)list.get(i);
                if (i == 0) {
                    sb.append(str);
                    curInt = Integer.parseInt(str);
                    continue;
                }
                Integer indexInt = Integer.parseInt(str);
                if (indexInt - curInt > 1) {
                    count = 0;
                    if (i == 1) {
                        sb.append(",").append(decimalFormat.format(indexInt));
                    } else {
                        sb.append(decimalFormat.format(curInt)).append(",").append(decimalFormat.format(indexInt));
                    }
                    curInt = Integer.parseInt(str);
                    continue;
                }
                curInt = Integer.parseInt(str);
                if (count == 0) {
                    sb.append("~");
                }
                if (i == list.size() - 1) {
                    sb.append(decimalFormat.format(curInt));
                }
                ++count;
            }
        }
        if (sb != null) {
            return sb.toString();
        }
        return null;
    }
}

