/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.pm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.WorkCenterFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class WorkShopProjKeyOperationRptServer
extends ReportServerBase {
    private Context ctx;
    private Date month;
    private String sou;
    private String souid = null;
    private String project;
    private String projectid = null;
    private String monthstr = null;
    private SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM");
    private SimpleDateFormat dfd = new SimpleDateFormat("yyyy-MM-dd");
    private int days = 0;
    private String trackbegin = null;
    private String trackbeginid = null;
    private String trackend = null;
    private String trackendid = null;
    private String workshop = null;
    private String workshopidlist = null;

    protected IRowSet getReportData(String arg0, RptParams params) throws Exception {
        this.ctx = this.getContext();
        this.initRptParams(params);
        String tempTableResult = TempTablePool.getInstance((Context)this.getContext()).createTempTable("CREATE TABLE NEWDATA (   FStorageOrgUnitId VARCHAR(44),  FProjectId VARCHAR(44),   Foperationid VARCHAR(44),  Foperationname VARCHAR(100),  Foperationordernum int ,  Fworkshopname VARCHAR(100),  Ftype int,  FDesc VARCHAR(44),  fmonth VARCHAR(44)," + this.getDaySql() + "  ) \n");
        DbUtil.execute((Context)this.getContext(), (String)this.getInsertSqlForResult(tempTableResult));
        IRowSet set = DbUtil.executeQuery((Context)this.getContext(), (String)this.getResultSql(tempTableResult));
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTableResult);
        return set;
    }

    private String getResultSql(String tempTableResult) {
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/ select FStorageOrgUnitId,FProjectId,fmonth,Ftype,Foperationid,Foperationname,Foperationordernum,Fworkshopname,FDesc,");
        for (int i = 0; i < this.days; ++i) {
            sql.append("WMSYS.WM_CONCAT(Fday" + (i + 1) + ") as Fday" + (i + 1) + "");
            if (i >= this.days - 1) continue;
            sql.append(",");
        }
        sql.append(" from " + tempTableResult);
        sql.append(" group by Foperationname,Foperationid,FDesc,FStorageOrgUnitId,FProjectId,fmonth,Foperationordernum,Ftype ,Fworkshopname  ");
        sql.append(" order by Foperationordernum,Foperationname,Ftype ");
        return sql.toString();
    }

    private String getInsertSqlForResult(String tempTableResult) {
        int i;
        StringBuffer sql = new StringBuffer();
        if (this.souid == null || "".equals(this.souid)) {
            try {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0249", (Locale)this.ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0250", (Locale)this.ctx.getLocale())));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        if (this.projectid == null || "".equals(this.projectid)) {
            try {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0249", (Locale)this.ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0305", (Locale)this.ctx.getLocale())));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        sql.append("/*dialect*/ insert into " + tempTableResult);
        sql.append(" select  * from (");
        sql.append(" select  '").append(this.souid).append("' as FStorageOrgUnitId,");
        sql.append(" '").append(this.projectid).append("' as FProjectId,");
        sql.append(" d.cfoperationid as Foperationid, ");
        sql.append(" operation.fname_l2 as Foperationname, ");
        sql.append(" d.cfordernum as Foperationordernum, ");
        sql.append(" (Select fname_l2 From t_mm_workcenter where fid = workcenter.fparentwcid) as Fworkshopname, ");
        sql.append(" 1 as Ftype, ");
        sql.append(" '").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0251", (Locale)this.ctx.getLocale())).append("' as FDesc, ");
        sql.append(" '").append(this.monthstr).append("' as fmonth ,");
        for (i = 0; i < this.days; ++i) {
            sql.append(" ' '  as FDay" + (i + 1));
            if (i >= this.days - 1) continue;
            sql.append(",");
        }
        sql.append(" From ct_bas_prodorgkeyoperation h inner join ct_bas_prodokoe d on h.fid = d.fparentid  ");
        sql.append(" inner join  t_mm_operation operation  on d.cfoperationid = operation.fid  ");
        sql.append(" left outer join  t_mm_workcenter workcenter  on operation.fworkcenterid = workcenter.fid  ");
        sql.append(" where h.cfstorageorgunitid = '").append(this.souid).append("' ");
        if (this.workshopidlist != null && !"".equals(this.workshopidlist)) {
            sql.append(" and workcenter.fparentwcid in(").append(this.workshopidlist).append(") ");
        }
        sql.append(" union ");
        sql.append(" select  '").append(this.souid).append("' as FStorageOrgUnitId,");
        sql.append(" '").append(this.projectid).append("' as FProjectId,");
        sql.append(" d.cfoperationid as Foperationid, ");
        sql.append(" operation.fname_l2 as Foperationname, ");
        sql.append(" d.cfordernum as Foperationordernum, ");
        sql.append(" (Select fname_l2 From t_mm_workcenter where fid = workcenter.fparentwcid) as Fworkshopname, ");
        sql.append(" 2 as Ftype, ");
        sql.append(" '").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0252", (Locale)this.ctx.getLocale())).append("' as FDesc, ");
        sql.append(" '").append(this.monthstr).append("' as fmonth ,");
        for (i = 0; i < this.days; ++i) {
            sql.append(" ' '  as FDay" + (i + 1));
            if (i >= this.days - 1) continue;
            sql.append(",");
        }
        sql.append(" From ct_bas_prodorgkeyoperation h inner join ct_bas_prodokoe d on h.fid = d.fparentid  ");
        sql.append(" inner join  t_mm_operation operation  on d.cfoperationid = operation.fid  ");
        sql.append(" left outer join  t_mm_workcenter workcenter  on operation.fworkcenterid = workcenter.fid  ");
        sql.append(" where h.cfstorageorgunitid = '").append(this.souid).append("' ");
        if (this.workshopidlist != null && !"".equals(this.workshopidlist)) {
            sql.append(" and workcenter.fparentwcid in(").append(this.workshopidlist).append(") ");
        }
        sql.append(" ) kk ");
        sql.append(" order by kk.Foperationordernum,kk.Ftype ");
        return sql.toString();
    }

    private String getDaySql() {
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < this.days; ++i) {
            sql.append("Fday" + (i + 1) + " varchar(1000) DEFAULT('')");
            if (i >= this.days - 1) continue;
            sql.append(",");
        }
        return sql.toString();
    }

    private void initRptParams(RptParams params) throws BOSException {
        if (params.getObject("month") != null) {
            String temp;
            this.monthstr = temp = (String)params.getObject("month");
            try {
                this.month = this.dfm.parse(temp);
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.month);
                this.days = cal.getActualMaximum(5);
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        } else {
            this.month = null;
        }
        if (params.getObject("storageOrgUnit") != null) {
            this.sou = (String)params.getObject("storageOrgUnit");
            CoreBaseCollection souInfo = StorageOrgUnitFactory.getLocalInstance((Context)this.ctx).getCollection("select fid where number='" + this.sou + "'");
            this.souid = souInfo.get(0).getId().toString();
        } else {
            this.sou = null;
        }
        if (params.getObject("project") != null) {
            this.project = (String)params.getObject("project");
            CoreBaseCollection projects = ProjectFactory.getLocalInstance((Context)this.ctx).getCollection("select fid where  number='" + this.project + "'");
            this.projectid = projects.get(0).getId().toString();
        } else {
            this.projectid = null;
        }
        if (params.getObject("trackNumber") != null) {
            this.trackbegin = (String)params.getObject("trackNumber");
            CoreBaseCollection trackbegins = TrackNumberFactory.getLocalInstance((Context)this.ctx).getCollection("select fid where  number='" + this.trackbegin + "'");
            this.trackbeginid = trackbegins.get(0).getId().toString();
        } else {
            this.trackbeginid = null;
        }
        if (params.getObject("endTrackNumber") != null) {
            this.trackend = (String)params.getObject("endTrackNumber");
            CoreBaseCollection trackends = TrackNumberFactory.getLocalInstance((Context)this.ctx).getCollection("select fid where  number='" + this.trackend + "'");
            this.trackendid = trackends.get(0).getId().toString();
        } else {
            this.trackendid = null;
        }
        if (params.getObject("workShop") != null) {
            this.workshop = (String)params.getObject("workShop");
            String workshopreplace = this.workshop.replace(";", "','");
            workshopreplace = workshopreplace.replace(" ", "");
            CoreBaseCollection workcents = WorkCenterFactory.getLocalInstance((Context)this.ctx).getCollection("select fid where number in ('" + workshopreplace + "')");
            if (workcents != null && workcents.size() > 0) {
                for (int i = 0; i < workcents.size(); ++i) {
                    this.workshopidlist = i == 0 ? "'" + workcents.get(i).getId().toString() + "'" : this.workshopidlist + ",'" + workcents.get(i).getId().toString() + "'";
                }
            }
        } else {
            this.workshopidlist = null;
        }
    }

    protected ReportTitles getReportTitles(String arg0, RptParams params) throws BaseException {
        CoreBaseCollection trackends;
        CoreBaseCollection trackbegins;
        CoreBaseCollection projects;
        CoreBaseCollection souInfo;
        ReportTitles titles = new ReportTitles();
        titles.AddTitle(0, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0306", (Locale)this.ctx.getLocale()));
        titles.AddTitle(1, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0254", (Locale)this.ctx.getLocale()) + this.dfm.format(this.month));
        if (this.sou != null && (souInfo = StorageOrgUnitFactory.getLocalInstance((Context)this.ctx).getCollection("select name where number='" + this.sou + "'")) != null && souInfo.size() > 0) {
            titles.AddTitle(2, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0255", (Locale)this.ctx.getLocale()) + ((StorageOrgUnitInfo)souInfo.get(0)).getName());
        }
        if (this.project != null && (projects = ProjectFactory.getLocalInstance((Context)this.ctx).getCollection("select name where number='" + this.project + "'")) != null && projects.size() > 0) {
            String projectname = projects.get(0).get("name").toString();
            titles.AddTitle(3, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0256", (Locale)this.ctx.getLocale()) + projectname);
        }
        if (this.trackbeginid != null && (trackbegins = TrackNumberFactory.getLocalInstance((Context)this.ctx).getCollection("select name where id='" + this.trackbeginid + "'")) != null && trackbegins.size() > 0) {
            String tracknamebegin = trackbegins.get(0).get("name").toString();
            titles.AddTitle(4, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0299", (Locale)this.ctx.getLocale()) + tracknamebegin);
        }
        if (this.trackendid != null && (trackends = TrackNumberFactory.getLocalInstance((Context)this.ctx).getCollection("select name where id='" + this.trackendid + "'")) != null && trackends.size() > 0) {
            String tracknameend = trackends.get(0).get("name").toString();
            titles.AddTitle(5, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0300", (Locale)this.ctx.getLocale()) + tracknameend);
        }
        if (this.workshop != null) {
            String workshopreplace = this.workshop.replace(";", "','");
            workshopreplace = workshopreplace.replace(" ", "");
            CoreBaseCollection workshops = WorkCenterFactory.getLocalInstance((Context)this.ctx).getCollection("select name where number in ('" + workshopreplace + "')");
            String workshopnamelist = "";
            if (workshops != null && workshops.size() > 0) {
                for (int i = 0; i < workshops.size(); ++i) {
                    workshopnamelist = i == 0 ? "" + workshops.get(i).get("name").toString() + "" : workshopnamelist + "," + workshops.get(i).get("name").toString() + "";
                }
            }
            if (workshops != null && workshops.size() > 0) {
                titles.AddTitle(6, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0307", (Locale)this.ctx.getLocale()) + workshopnamelist);
            }
        }
        titles.AddTitle(7, EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0257", (Locale)this.ctx.getLocale()));
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams params) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        ReportHeader temp = null;
        temp = reportHeader.addChild("FStorageOrgUnitId", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0258", (Locale)this.ctx.getLocale()));
        temp.setVisible(false);
        temp = reportHeader.addChild("FProjectId", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0259", (Locale)this.ctx.getLocale()));
        temp.setVisible(false);
        temp = reportHeader.addChild("fmonth", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0260", (Locale)this.ctx.getLocale()));
        temp.setVisible(false);
        temp = reportHeader.addChild("Ftype", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0261", (Locale)this.ctx.getLocale()));
        temp.setVisible(false);
        temp = reportHeader.addChild("Foperationid", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0308", (Locale)this.ctx.getLocale()));
        temp.setVisible(false);
        temp = reportHeader.addChild("Foperationname", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0309", (Locale)this.ctx.getLocale()));
        temp.setMergeable(true);
        temp = reportHeader.addChild("Foperationordernum", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0310", (Locale)this.ctx.getLocale()));
        temp.setVisible(false);
        temp = reportHeader.addChild("Fworkshopname", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0311", (Locale)this.ctx.getLocale()));
        temp.setMergeable(true);
        temp = reportHeader.addChild("FDesc", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0262", (Locale)this.ctx.getLocale()));
        temp.setMergeable(true);
        temp.setWidth(60);
        for (int i = 0; i < this.days; ++i) {
            reportHeader.addChild("Fday" + (i + 1), i + 1 + "");
        }
        return reportHeader;
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        return totalFilter;
    }
}

