/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.sc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.mm.pm.MarketingFittingRollingPlanFactory;
import com.kingdee.eas.industry.emm.mm.pm.MarketingFittingRollingPlanInfo;
import com.kingdee.eas.industry.emm.mm.sc.OperationScRequestBillCollection;
import com.kingdee.eas.industry.emm.mm.sc.OperationScRequestBillEntryCollection;
import com.kingdee.eas.industry.emm.mm.sc.OperationScRequestBillEntryInfo;
import com.kingdee.eas.industry.emm.mm.sc.OperationScRequestBillFactory;
import com.kingdee.eas.industry.emm.mm.sc.OperationScRequestBillInfo;
import com.kingdee.eas.industry.emm.mm.sc.app.AbstractOperationScRequestBillControllerBean;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OperationScRequestBillControllerBean
extends AbstractOperationScRequestBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.mm.sc.app.OperationScRequestBillControllerBean");
    private String RESURL = "com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource";

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        OperationScRequestBillInfo info = (OperationScRequestBillInfo)model;
        if (info == null) {
            info = (OperationScRequestBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0000", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
        String billId = info.getId().toString();
        StringBuilder sql = new StringBuilder();
        sql.append(" update T_MM_MFTOrderTechnics mf set fentrusttype = 3,FEntrustSupplierID=(");
        sql.append(" select osc.cfsupplierid from CT_SC_OperationScRequestBill osc");
        sql.append(" inner join CT_SC_OperationSRBE osentry on osc.fid=osentry.fparentid");
        sql.append(" where osentry.CFMotID=mf.fid");
        sql.append(" and osc.fid='" + billId + "')");
        sql.append(" where mf.fentrusttype=1");
        sql.append(" and mf.fid=(");
        sql.append(" select osentry.CFMotID from CT_SC_OperationSRBE osentry");
        sql.append(" inner join CT_SC_OperationScRequestBill osc on osc.fid=osentry.fparentid");
        sql.append(" where osentry.CFMotID=mf.fid and osc.fid='" + billId + "')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        OperationScRequestBillInfo info = (OperationScRequestBillInfo)model;
        if (info == null) {
            info = (OperationScRequestBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        this.checkUnPassAduit(ctx, info, model);
        super.update(ctx, pk, (CoreBaseInfo)info);
        String billId = info.getId().toString();
        StringBuilder sql = new StringBuilder();
        sql.append(" update T_MM_MFTOrderTechnics mf set FEntrustSupplierID=null,fentrusttype = 1");
        sql.append(" where mf.fid=(");
        sql.append(" select osentry.CFMotID from CT_SC_OperationSRBE osentry");
        sql.append(" inner join CT_SC_OperationScRequestBill osc on osc.fid=osentry.fparentid");
        sql.append(" where osentry.CFMotID=mf.fid and osc.fid='" + billId + "')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = null;
        OperationScRequestBillInfo eti = (OperationScRequestBillInfo)model;
        if (eti.getCU() == null) {
            eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0014", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        this.check(ctx, eti);
        OperationScRequestBillEntryCollection operationScRequestBillEntryCollection = eti.getEntrys();
        int size = operationScRequestBillEntryCollection.size();
        BigDecimal qty = BigDecimal.ZERO;
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                OperationScRequestBillEntryInfo entryInfo = operationScRequestBillEntryCollection.get(i);
                BigDecimal operQty = entryInfo.getOperQty();
                BigDecimal totalDispatchQty = entryInfo.getTotalDispatchQty();
                qty = qty.add(operQty.subtract(totalDispatchQty));
            }
        }
        if (qty == BigDecimal.ZERO) {
            throw new EASBizException(new NumericExceptionSubItem("", "\u7533\u8bf7\u6570\u91cf\u4e0d\u80fd\u4e3a0\n"));
        }
        eti.setQty(qty);
        BigDecimal workPrice = eti.getWorkPrice() == null ? BigDecimal.ZERO : eti.getWorkPrice();
        BigDecimal workAmount = workPrice.multiply(qty);
        eti.setWorkAmount(workAmount);
        OperationScRequestBillEntryCollection entryColl = eti.getEntrys();
        for (int i = 0; i < entryColl.size(); ++i) {
            OperationScRequestBillEntryInfo entryInfo = entryColl.get(i);
            String order = entryInfo.getProOrderNumber();
            ManufactureOrderInfo manOder = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo("where number = '" + order + "'");
            if (entryInfo.getMotID() != null || manOder == null) continue;
            ManufactureOrderTechnicsCollection moTes = manOder.getTechnics();
            for (int j = 0; j < moTes.size(); ++j) {
                ManufactureOrderTechnicsInfo moTeInfo = moTes.get(j);
                if (!moTeInfo.getOperation().getId().toString().equals(entryInfo.getOperation().getId().toString())) continue;
                entryInfo.setMotID(moTeInfo.getId().toString());
            }
        }
        pk = super._save(ctx, (IObjectValue)eti);
        return pk;
    }

    private void UpdQtyAndWorkAmount(Context ctx, String billId) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" update CT_SC_OperationScRequestBill bill set cfqty =");
        sql.append("(select sum(isnull(mf.fqty,0)-mf.FTotalDispatchQty) qty from T_MM_MFTOrderTechnics mf");
        sql.append(" inner join CT_SC_OperationSRBE osentry on osentry.CFMotID=mf.fid ");
        sql.append(" inner join CT_SC_OperationScRequestBill osc");
        sql.append(" on osc.fid=osentry.fparentid and osc.fid='" + billId + "')");
        sql.append(" where bill.fid='" + billId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update CT_SC_OperationScRequestBill set cfworkamount=(");
        sql.append(" select isnull(bill.cfqty,0)*isnull(bill.cfworkprice,0) as amount from CT_SC_OperationScRequestBill bill");
        sql.append(" where bill.fid='" + billId + "')");
        sql.append(" where fid='" + billId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void check(Context ctx, OperationScRequestBillInfo eti) throws EASBizException, BOSException {
        if (eti.getCU() == null) {
            eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        FilterInfo filter = new FilterInfo();
        if (eti.getNumber() != null) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        }
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.EQUALS));
        }
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        OperationScRequestBillCollection QSConllection = OperationScRequestBillFactory.getLocalInstance(ctx).getOperationScRequestBillCollection(ev);
        if (QSConllection.size() > 1) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0003", (Locale)ctx.getLocale()) + " \n"));
        }
        StringBuffer errStr = new StringBuffer();
        if (eti.getStorageOrgUnit() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0048", (Locale)ctx.getLocale()) + "\n");
        }
        if (eti.getMaterial() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0049", (Locale)ctx.getLocale()) + "\n");
        }
        if (eti.getScOperation() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0050", (Locale)ctx.getLocale()) + " \n");
        }
        if (eti.getRequestScReason() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0051", (Locale)ctx.getLocale()) + "\n");
        } else if (eti.getRequestScReason().length() > 200) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0052", (Locale)ctx.getLocale()) + "\n");
        }
        if (eti.getRemark() != null && eti.getRemark().length() > 200) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0053", (Locale)ctx.getLocale()) + " \n");
        }
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
        for (int i = 0; i < eti.getEntrys().size(); ++i) {
            OperationScRequestBillEntryInfo entry = eti.getEntrys().get(i);
            StringBuffer tmpStr = new StringBuffer();
            if (entry.getOperation() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0054", (Locale)ctx.getLocale()) + "\n");
            }
            if (entry.getOperQty() == null || entry.getOperQty() == BigDecimal.ZERO) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0055", (Locale)ctx.getLocale()) + "\n");
            }
            if (tmpStr.length() <= 0) continue;
            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"FLDXH_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1});
            throw new EASBizException(new NumericExceptionSubItem("", strInfo + "\uff1a  \n" + tmpStr.toString()));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        OperationScRequestBillInfo info = (OperationScRequestBillInfo)this.getValue(ctx, pk);
        if (info.getStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0002", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OperationScRequestBillInfo eti = (OperationScRequestBillInfo)model;
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0013", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        this.check(ctx, eti);
        OperationScRequestBillEntryCollection operationScRequestBillEntryCollection = eti.getEntrys();
        int size = operationScRequestBillEntryCollection.size();
        BigDecimal qty = BigDecimal.ZERO;
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                OperationScRequestBillEntryInfo entryInfo = operationScRequestBillEntryCollection.get(i);
                BigDecimal operQty = entryInfo.getOperQty();
                BigDecimal totalDispatchQty = entryInfo.getTotalDispatchQty();
                qty = qty.add(operQty.subtract(totalDispatchQty));
            }
        }
        if (qty == BigDecimal.ZERO) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0056", (Locale)ctx.getLocale()) + "\n"));
        }
        eti.setQty(qty);
        BigDecimal workPrice = eti.getWorkPrice() == null ? BigDecimal.ZERO : eti.getWorkPrice();
        BigDecimal workAmount = workPrice.multiply(qty);
        eti.setWorkAmount(workAmount);
        IObjectPK pk = null;
        pk = super._submit(ctx, (IObjectValue)eti);
        return pk;
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    public void handleAfterTransform(Context arg0, String arg1, IObjectCollection arg2) throws BOSException, EASBizException {
        super.handleAfterTransform(arg0, arg1, arg2);
    }

    public void handleAfterTransform(Context ctx, String arg1, IObjectValue arg2) throws BOSException, EASBizException {
        OperationScRequestBillInfo operScInfo = (OperationScRequestBillInfo)arg2;
        String number = operScInfo.getNumber();
        StorageOrgUnitInfo storageInfo = operScInfo.getStorageOrgUnit();
        if (number == null && storageInfo != null) {
            try {
                this.setBillNumber(ctx, (IObjectValue)operScInfo, storageInfo.getId().toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
            }
        }
        super.handleAfterTransform(ctx, arg1, (IObjectValue)operScInfo);
    }

    protected void setBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID) throws Exception {
        String billNumber = null;
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule(billInfo, bizOrgUnitID);
        if (ruleInfo != null) {
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(billInfo, ruleInfo);
        }
        if (billNumber != null) {
            billInfo.setString("number", billNumber);
        } else if (billInfo.getString("id") != null) {
            billInfo.setString("number", "AutoNumberFromBTP_" + billInfo.getString("id").toString());
        } else {
            billInfo.setString("number", "AutoNumberFromBTP_" + BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
        }
    }

    protected void checkUnPassAduit(Context ctx, OperationScRequestBillInfo operationScRequestBillInfo, IObjectValue model) throws EASBizException, BOSException {
        String id;
        String string = operationScRequestBillInfo == null ? null : (id = operationScRequestBillInfo.getId() == null ? null : operationScRequestBillInfo.getId().toString());
        if (id == null) {
            return;
        }
        if (id.trim().length() == 0) {
            return;
        }
        BOTRelationCollection destRelationCollection = BTPManagerFactory.getLocalInstance((Context)ctx).getDestRelation(id);
        if (destRelationCollection == null) {
            return;
        }
        if (destRelationCollection.size() == 0) {
            return;
        }
        HashMap destBillMap = new HashMap();
        ArrayList<String> destRelationIDList = new ArrayList<String>();
        for (int index = 0; index < destRelationCollection.size(); ++index) {
            BOSObjectType bosType;
            BOTRelationInfo destRelationInfo = destRelationCollection.get(index);
            if (destRelationInfo == null) {
                return;
            }
            String relationID = destRelationInfo.getId() == null ? null : destRelationInfo.getId().toString();
            String destID = destRelationInfo.getDestObjectID();
            if (destID == null || relationID == null || destID.trim().length() == 0 || relationID.trim().length() == 0 || !BOSUuid.isValid((String)destID, (boolean)true)) continue;
            BOSUuid destBOSID = BOSUuid.read((String)destID);
            BOSObjectType bOSObjectType = bosType = destBOSID == null ? null : destBOSID.getType();
            if (bosType == null) continue;
            ArrayList<String> destBillIDList = destBillMap.containsKey(bosType.toString()) ? (destBillMap.get(bosType.toString()) == null ? new ArrayList<String>() : (destBillMap.get(bosType.toString()) instanceof List ? (List)destBillMap.get(bosType.toString()) : new ArrayList<String>())) : new ArrayList<String>();
            destBillIDList.add(destID);
            destBillMap.put(bosType.toString(), destBillIDList);
            destRelationIDList.add(relationID);
        }
        if (destBillMap.size() == 0) {
            return;
        }
        Iterator destBillIterator = destBillMap.keySet().iterator();
        if (destBillIterator == null) {
            return;
        }
        StringBuffer errorMessages = new StringBuffer();
        while (destBillIterator.hasNext()) {
            int index;
            IPurRequest billInterface;
            String baseStatusMetaData;
            String baseStatusType;
            PropertyInfo baseStatusPropertyInfo;
            Object bosTypeObject = destBillIterator.next();
            String bosType = bosTypeObject == null ? null : bosTypeObject.toString();
            if (bosType == null || bosType.trim().length() == 0) continue;
            EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)bosType));
            String entityAlias = entityObjectInfo == null ? EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0035", (Locale)ctx.getLocale()) : (entityObjectInfo.getAlias() == null ? (entityObjectInfo.getName() == null ? EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0035", (Locale)ctx.getLocale()) : entityObjectInfo.getName()) : entityObjectInfo.getAlias());
            PropertyCollection propertyCollection = entityObjectInfo.getPropertiesRuntime();
            PropertyInfo propertyInfo = propertyCollection == null ? null : (propertyCollection.containsKey((Object)"baseStatus") ? (propertyCollection.getObject((Object)"baseStatus") == null ? null : (propertyCollection.getObject((Object)"baseStatus") instanceof PropertyInfo ? (PropertyInfo)propertyCollection.getObject((Object)"baseStatus") : null)) : (baseStatusPropertyInfo = null));
            String string2 = baseStatusPropertyInfo.containsKey("dataType") ? (baseStatusPropertyInfo.get("dataType") == null ? null : baseStatusPropertyInfo.get("dataType").toString()) : (baseStatusType = null);
            String string3 = baseStatusPropertyInfo.containsKey("metadataRef") ? (baseStatusPropertyInfo.get("metadataRef") == null ? null : baseStatusPropertyInfo.get("metadataRef").toString()) : (baseStatusMetaData = null);
            Boolean hasBaseStatus = baseStatusPropertyInfo == null || baseStatusType == null || baseStatusMetaData == null ? false : baseStatusType.equals("Enum") && baseStatusMetaData.equals("com.kingdee.eas.scm.common.BillBaseStatusEnum");
            List destBillIDList = destBillMap.containsKey(bosType) ? (destBillMap.get(bosType) == null ? null : (destBillMap.get(bosType) instanceof List ? (List)destBillMap.get(bosType) : null)) : null;
            if (destBillIDList == null || destBillIDList.size() == 0) continue;
            Object object = new PurRequestInfo().getBOSType().toString().equals(bosType) ? PurRequestFactory.getLocalInstance((Context)ctx) : (new MaterialReqBillInfo().getBOSType().toString().equals(bosType) ? MaterialReqBillFactory.getLocalInstance((Context)ctx) : (billInterface = new MarketingFittingRollingPlanInfo().getBOSType().toString().equals(bosType) ? MarketingFittingRollingPlanFactory.getLocalInstance(ctx) : null));
            if (billInterface == null) {
                return;
            }
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            FilterInfo filterInfo = new FilterInfo();
            if (hasBaseStatus.booleanValue()) {
                filterInfo.getFilterItems().clear();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(destBillIDList), CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)0, CompareType.NOTEQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)1, CompareType.NOTEQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)2, CompareType.NOTEQUALS));
                entityViewInfo.setFilter(filterInfo);
                entityViewInfo.setSelector(sic);
                CoreBaseCollection destBillCollection = billInterface.getCollection(entityViewInfo);
                if (destBillCollection != null && destBillCollection.size() > 0) {
                    for (index = 0; index < destBillCollection.size(); ++index) {
                        String destBillNumber;
                        IObjectValue destBillInfo = destBillCollection.getObject(index);
                        String string4 = destBillInfo == null ? "" : (destBillInfo.containsKey("number") ? (destBillInfo.get("number") == null ? "" : destBillInfo.get("number").toString()) : (destBillNumber = ""));
                        if (destBillNumber == null) continue;
                        errorMessages.append(destBillNumber).append("\r\n");
                    }
                    if (errorMessages.toString().trim().length() > 0) {
                        String strInfo = ResourceBase.getString((String)this.RESURL, (String)"ZXXYXBSXZBCTJ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[0]);
                        errorMessages.insert(0, strInfo + ":\r\n");
                        throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0036", (Locale)ctx.getLocale()), errorMessages.toString()));
                    }
                }
            }
            filterInfo.getFilterItems().clear();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(destBillIDList), CompareType.INCLUDE));
            IObjectPK[] deletePKs = billInterface.delete(filterInfo);
            System.out.println("Delete Bill[" + bosType + "]\r\n:" + deletePKs.toString());
            for (index = 0; index < destRelationIDList.size(); ++index) {
                String relationID;
                String string5 = relationID = destRelationIDList.get(index) == null ? null : destRelationIDList.get(index).toString();
                if (relationID == null) continue;
                BOTRelationFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(relationID));
            }
        }
    }
}

