/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.sc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.mm.sc.BigDecimalUitl;
import com.kingdee.eas.industry.emm.mm.sc.ScInHandOverEntryInfo;
import com.kingdee.eas.industry.emm.mm.sc.ScInHandOverEntryPartsEntryInfo;
import com.kingdee.eas.industry.emm.mm.sc.ScInHandOverInfo;
import com.kingdee.eas.industry.emm.mm.sc.app.AbstractScInHandOverControllerBean;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ScInHandOverControllerBean
extends AbstractScInHandOverControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.mm.sc.app.YearScRequestBillControllerBean");
    private String RESURL = "com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource";

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ScInHandOverInfo bill = (ScInHandOverInfo)model;
        if (bill.getCU() == null) {
            bill.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.checkNumber(ctx, (IObjectValue)bill);
        return super._addnew(ctx, model);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ScInHandOverInfo info = (ScInHandOverInfo)model;
        if (info == null) {
            info = (ScInHandOverInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0000", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            info.getEntrys().get(i).setStatus(EntryBaseStatusEnum.AUDITED);
        }
        super.update(ctx, pk, (CoreBaseInfo)info);
        try {
            String billId = info.getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append(" /*dialect*/select e1.cfqty-se.cfqty-nvl(se.cftotalinqty,0) as fdiffqty,e1.fseq");
            sql.append(" from ct_sc_scinhandoverentry e1 ");
            sql.append(" inner join ct_sc_scouthandoverentry se on e1.cfsourceentryid=se.fid ");
            sql.append(" where e1.fparentid='" + billId + "'");
            sql.append(" and e1.cfqty-se.cfqty-nvl(se.cftotalinqty,0)>0");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            StringBuffer error = new StringBuffer();
            while (rs.next()) {
                int seq = rs.getInt("fseq");
                BigDecimal diff = rs.getBigDecimal("fdiffqty");
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"DXHSLCC_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{seq, diff});
                error.append(";").append(strInfo);
            }
            if (error.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("", error.toString()));
            }
            sql.setLength(0);
            sql.append(" /*dialect*/ update ct_sc_scouthandoverentry se set se.cftotalinqty= ");
            sql.append(" (select nvl(se.cftotalinqty,0)+e1.cfqty  ");
            sql.append("  from ct_sc_scinhandoverentry e1 ");
            sql.append("  where se.fid=e1.cfsourceentryid ");
            sql.append("  and e1.fparentid='" + billId + "') ");
            sql.append("  where se.fid in (select e2.cfsourceentryid from ct_sc_scinhandoverentry e2 where e2.fparentid='" + billId + "')");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" /*dialect*/ update ct_sc_scouthandoverentry se set se.cfstatus=7 ");
            sql.append(" where se.cftotalinqty>=se.cfqty");
            sql.append(" and se.fid in (select e2.cfsourceentryid from ct_sc_scinhandoverentry e2 where e2.fparentid='" + billId + "') ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.setLength(0);
            sql.append(" /*dialect*/ update ct_sc_scouthandover b set b.cfstatus=7 ");
            sql.append(" where not exists (select 1 from ct_sc_scouthandoverentry e");
            sql.append(" where e.fparentid=b.fid and e.cfstatus<>7) ");
            sql.append(" and b.fid in (select e2.cfsourcebillid from ct_sc_scinhandoverentry e2 where e2.fparentid='" + billId + "') ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ScInHandOverInfo info = (ScInHandOverInfo)model;
        if (info == null) {
            info = (ScInHandOverInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            info.getEntrys().get(i).setStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        }
        super.update(ctx, pk, (CoreBaseInfo)info);
        try {
            String billId = info.getId().toString();
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append(" /*dialect*/select nvl(se.cftotalinqty,0)-e1.cfqty as fdiffqty,e1.fseq");
            sql.append(" from ct_sc_scinhandoverentry e1 ");
            sql.append(" inner join ct_sc_scouthandoverentry se on e1.cfsourceentryid=se.fid ");
            sql.append(" where e1.fparentid='" + billId + "'");
            sql.append(" and e1.cfqty-nvl(se.cftotalinqty,0)<0");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            StringBuffer error = new StringBuffer();
            while (rs.next()) {
                int seq = rs.getInt("fseq");
                BigDecimal diff = rs.getBigDecimal("fdiffqty");
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"DXHSLCC_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{seq, diff});
                error.append(";").append(strInfo);
            }
            if (error.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("", error.toString()));
            }
            sql.setLength(0);
            sql.append(" /*dialect*/ update ct_sc_scouthandoverentry se set se.cftotalinqty= ");
            sql.append(" (select nvl(se.cftotalinqty,0)-e1.cfqty  ");
            sql.append("  from ct_sc_scinhandoverentry e1 ");
            sql.append("  where se.fid=e1.cfsourceentryid ");
            sql.append("  and e1.fparentid='" + billId + "') ");
            sql.append("  where se.fid in (select e2.cfsourceentryid from ct_sc_scinhandoverentry e2 where e2.fparentid='" + billId + "')");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" /*dialect*/ update ct_sc_scouthandoverentry se set se.cfstatus=4 ");
            sql.append(" where se.cftotalinqty<se.cfqty");
            sql.append(" and se.fid in (select e2.cfsourceentryid from ct_sc_scinhandoverentry e2 where e2.fparentid='" + billId + "') ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.setLength(0);
            sql.append(" /*dialect*/ update ct_sc_scouthandover b set b.cfstatus=4 ");
            sql.append(" where  exists (select 1 from ct_sc_scouthandoverentry e");
            sql.append(" where e.fparentid=b.fid and e.cfstatus<>7) ");
            sql.append(" and b.fid in (select e2.cfsourcebillid from ct_sc_scinhandoverentry e2 where e2.fparentid='" + billId + "') ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ScInHandOverInfo info = (ScInHandOverInfo)this.getValue(ctx, pk);
        if (info.getStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0002", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void check(Context ctx, ScInHandOverInfo eti) throws EASBizException, BOSException {
        if (eti.getCU() == null) {
            eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0003", (Locale)ctx.getLocale())));
        }
        StringBuffer errStr = new StringBuffer();
        if (eti.getStorageOrgUnit() == null) {
            errStr.append(";").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0042", (Locale)ctx.getLocale()));
        }
        if (eti.getProject() == null) {
            errStr.append(";").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0057", (Locale)ctx.getLocale()));
        }
        if (eti.getTrackNumber() == null) {
            errStr.append(";").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0057", (Locale)ctx.getLocale()));
        }
        if (eti.getSupplier() == null) {
            errStr.append(";").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0043", (Locale)ctx.getLocale()));
        }
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
        BigDecimal total = BigDecimal.ZERO;
        for (int i = 0; i < eti.getEntrys().size(); ++i) {
            ScInHandOverEntryInfo entry = eti.getEntrys().get(i);
            StringBuffer tmpStr = new StringBuffer();
            if (entry.getMaterial() == null) {
                tmpStr.append(";").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0058", (Locale)ctx.getLocale()));
            }
            if (BigDecimalUitl.isBigDecimalEmptyAndZero(entry.getQty())) {
                tmpStr.append(";").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0026", (Locale)ctx.getLocale()));
            }
            if (tmpStr.length() > 0) {
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"FLDXH_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1});
                throw new EASBizException(new NumericExceptionSubItem("", strInfo + "," + tmpStr.toString()));
            }
            for (int j = 0; j < entry.getPartsEntry().size(); ++j) {
                ScInHandOverEntryPartsEntryInfo sEntry = entry.getPartsEntry().get(j);
                StringBuffer tss = new StringBuffer();
                if (sEntry.getMaterial() == null) {
                    tss.append(";").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0025", (Locale)ctx.getLocale()));
                }
                if (BigDecimalUitl.isBigDecimalEmptyAndZero(sEntry.getQty())) {
                    tss.append(";").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0026", (Locale)ctx.getLocale()));
                }
                if (tss.length() <= 0) continue;
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"FLLBJFL_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1, j + 1});
                throw new EASBizException(new NumericExceptionSubItem("", strInfo + "," + tmpStr.toString()));
            }
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ScInHandOverInfo eti = (ScInHandOverInfo)model;
        this.check(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0013", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        for (int i = 0; i < eti.getEntrys().size(); ++i) {
            eti.getEntrys().get(i).setStatus(EntryBaseStatusEnum.SUBMITED);
        }
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ScInHandOverInfo eti = (ScInHandOverInfo)model;
        if (eti.getCU() == null) {
            eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.check(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0014", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }

    protected void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ScInHandOverInfo info = (ScInHandOverInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(model, info.getStorageOrgUnit().getId().toString());
        if (ruleStatus.isExist() && (StringUtils.isEmpty((String)info.getNumber()) || ruleStatus.isAddNoBreak() || !ruleStatus.isModifiable() && this.isNumberUsed(ctx, info))) {
            this.setNewNumber(ctx, info, iCodingRuleManager, null);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(model.getBOSUuid("id"));
            super._checkNumberBlank(ctx, (IObjectPK)pk, model);
            super._checkNumberDup(ctx, (IObjectPK)pk, model);
        }
    }

    protected boolean isNumberUsed(Context ctx, ScInHandOverInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        if (info.getCU() != null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        boolean exist = super._exists(ctx, filter);
        return exist;
    }

    protected void setNewNumber(Context ctx, ScInHandOverInfo info, ICodingRuleManager iCodingRuleManager, String customString) throws BOSException, EASBizException {
        String number = iCodingRuleManager.getNumber((IObjectValue)info, info.getStorageOrgUnit().getId().toString(), customString);
        info.setNumber(number);
        if (this.isNumberUsed(ctx, info)) {
            this.setNewNumber(ctx, info, iCodingRuleManager, customString);
        }
    }

    protected String _getNewNumber(Context ctx, IObjectValue model, String strCompanyID, String customString) throws BOSException, EASBizException {
        String strBindProp;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        ScInHandOverInfo aSCMBillBaseInfo = (ScInHandOverInfo)model;
        String number = "";
        boolean isNumberNoSet = false;
        if (aSCMBillBaseInfo.getNumber() == null || aSCMBillBaseInfo.getNumber().length() == 0) {
            isNumberNoSet = true;
        }
        if ((strBindProp = this.getBindingProperty(ctx)) != null && strBindProp.trim().length() > 0) {
            number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp, customString);
            aSCMBillBaseInfo.setNumber(number);
        } else {
            number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            aSCMBillBaseInfo.setNumber(number);
        }
        ObjectUuidPK pk = new ObjectUuidPK(aSCMBillBaseInfo.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
            String newNumber = "";
            newNumber = strBindProp != null && strBindProp.trim().length() > 0 ? iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp, customString) : iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            if (newNumber.equals(aSCMBillBaseInfo.getNumber())) {
                throw new CMBillException(CMBillException.NUMBERRULEERROR);
            }
            number = newNumber;
            aSCMBillBaseInfo.setNumber(newNumber);
            if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
                return this._getNewNumber(ctx, (IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            }
        }
        return number;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ScInHandOverInfo aSCMBillBaseInfo = (ScInHandOverInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (aSCMBillBaseInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)aSCMBillBaseInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getBindingProperty(ctx) != null && this.getBindingProperty(ctx).trim().length() > 0 && aSCMBillBaseInfo.get(this.getBindingProperty(ctx)) != null) {
            filterItem = new FilterItemInfo(this.getBindingProperty(ctx), this.getBindingPropertyValue(aSCMBillBaseInfo), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    protected String getBindingProperty(Context ctx) throws BOSException {
        return null;
    }

    protected Object getBindingPropertyValue(ScInHandOverInfo aSCMBillBaseInfo) {
        return null;
    }
}

