/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.fcs.algorithm.method;

import java.util.List;

public class DemoAlgorithm {
    static double[] alphas = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9};

    public static Double getbetterforecast(List<Integer> y, int period, int m) {
        double[] result = DemoAlgorithm.betterforecast(y, period, m);
        return result[result.length - 1];
    }

    public static double[] betterforecast(List<Integer> y, int period, int m) {
        double[] result = null;
        double avg = 0.0;
        for (int i = 0; i < alphas.length; ++i) {
            int sum = 0;
            double[] temp = DemoAlgorithm.forecast(y, alphas[i], 0.25, 0.0, period, m, false);
            for (int j = 0; j < y.size(); ++j) {
                sum = (int)((double)sum + Math.abs((double)y.get(j).intValue() - temp[j]));
            }
            if (i == 0) {
                avg = sum / y.size();
                result = temp;
            }
            if (!(avg < (double)(sum / y.size()))) continue;
            result = temp;
        }
        return result;
    }

    public static double[] forecast(List<Integer> y, double alpha, double beta, double gamma, int period, int m, boolean debug) {
        if (y == null) {
            return null;
        }
        int seasons = y.size() / period;
        double a0 = DemoAlgorithm.calculateInitialLevel(y, period);
        double b0 = DemoAlgorithm.calculateInitialTrend(y, period);
        double[] initialSeasonalIndices = DemoAlgorithm.calculateSeasonalIndices(y, period, seasons);
        if (debug) {
            System.out.println(String.format("Total observations: %d, Seasons %d, Periods %d", y.size(), seasons, period));
            System.out.println("Initial level value a0: " + a0);
            System.out.println("Initial trend value b0: " + b0);
            DemoAlgorithm.printArray("Seasonal Indices: ", initialSeasonalIndices);
        }
        double[] forecast = DemoAlgorithm.calculateHoltWinters(y, a0, b0, alpha, beta, gamma, initialSeasonalIndices, period, m, debug);
        if (debug) {
            DemoAlgorithm.printArray("Forecast", forecast);
        }
        return forecast;
    }

    private static double[] calculateHoltWinters(List<Integer> y, double a0, double b0, double alpha, double beta, double gamma, double[] initialSeasonalIndices, int period, int m, boolean debug) {
        int i;
        double[] St = new double[y.size()];
        double[] Bt = new double[y.size()];
        double[] It = new double[y.size()];
        double[] Ft = new double[y.size() + m];
        St[1] = a0;
        Bt[1] = b0;
        for (i = 0; i < period; ++i) {
            It[i] = initialSeasonalIndices[i];
        }
        Ft[0 + m] = (St[0] + (double)m * Bt[0]) * It[0];
        Ft[m + 1] = (St[1] + (double)m * Bt[1]) * It[1];
        for (i = 2; i < y.size(); ++i) {
            St[i] = i - period >= 0 ? alpha * (double)y.get(i).intValue() / It[i - period] + (1.0 - alpha) * (St[i - 1] + Bt[i - 1]) : alpha * (double)y.get(i).intValue() + (1.0 - alpha) * (St[i - 1] + Bt[i - 1]);
            Bt[i] = gamma * (St[i] - St[i - 1]) + (1.0 - gamma) * Bt[i - 1];
            if (i - period >= 0) {
                It[i] = beta * (double)y.get(i).intValue() / St[i] + (1.0 - beta) * It[i - period];
            }
            if (i + m >= period) {
                Ft[i + m] = (St[i] + (double)m * Bt[i]) * It[i - period + m];
                if (Ft[i + m] <= 0.0) {
                    Ft[i + m] = 1.0;
                }
            }
            if (!debug) continue;
            System.out.println(String.format("i = %d, y = %d, S = %f, Bt = %f, It = %f, F = %f", i, y.get(i), St[i], Bt[i], It[i], Ft[i]));
        }
        return Ft;
    }

    private static double calculateInitialLevel(List<Integer> y, int period) {
        return y.get(0).intValue();
    }

    private static double calculateInitialTrend(List<Integer> y, int period) {
        double sum = 0.0;
        for (int i = 0; i < period; ++i) {
            sum += (double)(y.get(period + i) - y.get(i));
        }
        return sum / (double)(period * period);
    }

    private static double[] calculateSeasonalIndices(List<Integer> y, int period, int seasons) {
        int j;
        double[] seasonalAverage = new double[seasons];
        double[] seasonalIndices = new double[period];
        double[] averagedObservations = new double[y.size()];
        int i = 0;
        while (i < seasons) {
            for (j = 0; j < period; ++j) {
                int n = i;
                seasonalAverage[n] = seasonalAverage[n] + (double)y.get(i * period + j).intValue();
            }
            int n = i++;
            seasonalAverage[n] = seasonalAverage[n] / (double)period;
        }
        for (i = 0; i < seasons; ++i) {
            for (j = 0; j < period; ++j) {
                averagedObservations[i * period + j] = (double)y.get(i * period + j).intValue() / seasonalAverage[i];
            }
        }
        i = 0;
        while (i < period) {
            for (j = 0; j < seasons; ++j) {
                int n = i;
                seasonalIndices[n] = seasonalIndices[n] + averagedObservations[j * period + i];
            }
            int n = i++;
            seasonalIndices[n] = seasonalIndices[n] / (double)seasons;
        }
        return seasonalIndices;
    }

    private static void printArray(String description, double[] data) {
        System.out.println(String.format("******************* %s *********************", description));
        for (int i = 0; i < data.length; ++i) {
            System.out.println(data[i]);
        }
        System.out.println(String.format("*****************************************************************", description));
    }

    public static double[] betterSec(List<Integer> y, int m) {
        double[] result = null;
        double avg = 0.0;
        for (int i = 0; i < alphas.length; ++i) {
            int sum = 0;
            double[] temp = DemoAlgorithm.getSecExpect(y, m, alphas[i]);
            for (int j = 0; j < y.size(); ++j) {
                sum = (int)((double)sum + Math.abs((double)y.get(j).intValue() - temp[j]));
            }
            if (i == 0) {
                avg = sum / y.size();
                result = temp;
            }
            if (!(avg < (double)(sum / y.size()))) continue;
            result = temp;
        }
        return result;
    }

    public static double[] getSecExpect(List<Integer> list, int year, Double modulus) {
        if (list.size() < 20 || modulus <= 0.0 || modulus >= 1.0) {
            return null;
        }
        double[] ft = new double[list.size() + year];
        Double modulusLeft = 1.0 - modulus;
        Double lastIndex = Double.parseDouble(list.get(0).toString());
        Double lastSecIndex = Double.parseDouble(list.get(0).toString());
        for (int i = 0; i < list.size(); ++i) {
            lastIndex = modulus * (double)list.get(i).intValue() + modulusLeft * lastIndex;
            lastSecIndex = modulus * lastIndex + modulusLeft * lastSecIndex;
            Double a = 2.0 * lastIndex - lastSecIndex;
            Double b = modulus / modulusLeft * (lastIndex - lastSecIndex);
            ft[i + 1] = a + b * (double)year;
            if (!(ft[i + 1] <= 0.0)) continue;
            ft[i + 1] = 1.0;
        }
        return ft;
    }

    public static Double getThridExpect(List<Integer> list, int year, Double modulus) {
        Double lastIndex;
        if (list.size() < 20 || modulus <= 0.0 || modulus >= 1.0) {
            return null;
        }
        Double modulusLeft = 1.0 - modulus;
        Double lastSecIndex = lastIndex = Double.valueOf((list.get(0) + list.get(1) + list.get(2)) / 3);
        Double lastThreadIndes = lastIndex;
        for (Integer data : list) {
            lastIndex = modulus * (double)data.intValue() + modulusLeft * lastIndex;
            lastSecIndex = modulus * lastIndex + modulusLeft * lastSecIndex;
            lastThreadIndes = modulus * lastSecIndex + modulusLeft * lastThreadIndes;
        }
        Double a = 3.0 * lastIndex - 3.0 * lastSecIndex + lastThreadIndes;
        Double b = modulus / (2.0 * modulusLeft * modulusLeft) * ((6.0 - 5.0 * modulus) * lastIndex - 2.0 * (5.0 - 4.0 * modulus) * lastSecIndex + (4.0 - 3.0 * modulus) * lastThreadIndes);
        Double c = modulus * modulus / (2.0 * modulusLeft * modulusLeft) * (lastIndex - 2.0 * lastSecIndex + lastThreadIndes);
        Double except = a + b * (double)year + c * (double)year * (double)year;
        return except < 0.0 ? 0.0 : except;
    }
}

