/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.fcs.algorithm.method;

import com.kingdee.eas.industry.emm.project.fcs.algorithm.method.AbstractAlgorithm;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;

public class MovingAverageAlgorithm
extends AbstractAlgorithm {
    protected BigDecimal[] source;
    protected int forcastPeriod;
    protected int step;

    public MovingAverageAlgorithm(double[] source, int forcastPeriod, int step) {
        if (source == null) {
            throw new IllegalArgumentException("source data can not be null");
        }
        if (step > source.length) {
            throw new IllegalArgumentException("step must less than source data's length");
        }
        this.source = new BigDecimal[source.length];
        this.forcastPeriod = forcastPeriod;
        this.step = step;
        for (int i = 0; i < source.length; ++i) {
            this.source[i] = new BigDecimal(source[i]);
        }
    }

    public BigDecimal[] getSource() {
        return this.source;
    }

    public void setSource(BigDecimal[] source) {
        this.source = source;
    }

    public int getForcastPeriod() {
        return this.forcastPeriod;
    }

    public void setForcastPeriod(int forcastPeriod) {
        this.forcastPeriod = forcastPeriod;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    @Override
    public BigDecimal[] calc() {
        int i;
        ArrayList<BigDecimal> buffer = new ArrayList<BigDecimal>();
        for (int i2 = 0; i2 < this.source.length; ++i2) {
            buffer.add(this.source[i2]);
        }
        int index = this.step;
        BigDecimal stepBD = new BigDecimal(this.step);
        MathContext mc = new MathContext(this.scale, this.roundingMode);
        while (true) {
            BigDecimal sum = BigDecimal.ZERO;
            for (i = index - this.step; i < index; ++i) {
                sum = sum.add((BigDecimal)buffer.get(i));
            }
            buffer.add(sum.divide(stepBD, mc));
            if (buffer.size() == this.forcastPeriod + this.source.length) break;
            ++index;
        }
        BigDecimal[] ret = new BigDecimal[this.forcastPeriod];
        for (i = this.source.length; i < buffer.size(); ++i) {
            ret[i - this.source.length] = ((BigDecimal)buffer.get(i)).setScale(this.scale, this.roundingMode);
        }
        return ret;
    }
}

