/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.fcs.algorithm.method;

import com.kingdee.eas.industry.emm.project.fcs.algorithm.method.AbstractAlgorithm;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;

public class QuadraticExponentialSmoothingAlgotithm
extends AbstractAlgorithm {
    protected double[] source;
    protected int forcastPeriod;
    protected BigDecimal alpha;

    public QuadraticExponentialSmoothingAlgotithm(double[] source, int forcastPeriod, double alpha) {
        this.source = source;
        this.forcastPeriod = forcastPeriod;
        this.alpha = new BigDecimal(alpha);
    }

    @Override
    public BigDecimal[] calc() {
        BigDecimal initial = new BigDecimal(this.source[0]);
        ArrayList<BigDecimal> firstForcasts = new ArrayList<BigDecimal>();
        for (int i = 0; i < this.source.length; ++i) {
            initial = this.alpha.multiply(new BigDecimal(this.source[i])).add(BigDecimal.ONE.subtract(this.alpha).multiply(initial));
            firstForcasts.add(initial.setScale(this.scale, this.roundingMode));
        }
        initial = new BigDecimal(this.source[0]);
        ArrayList<BigDecimal> secForcasts = new ArrayList<BigDecimal>();
        for (int i = 0; i < this.source.length; ++i) {
            initial = this.alpha.multiply((BigDecimal)firstForcasts.get(i)).add(BigDecimal.ONE.subtract(this.alpha).multiply(initial));
            secForcasts.add(initial.setScale(this.scale, this.roundingMode));
        }
        MathContext mc = new MathContext(this.scale, this.roundingMode);
        ArrayList<BigDecimal> ret = new ArrayList<BigDecimal>(this.forcastPeriod);
        for (int i = 0; i < this.forcastPeriod + 1; ++i) {
            if (i < this.source.length) {
                BigDecimal a = new BigDecimal(2).multiply((BigDecimal)firstForcasts.get(i)).subtract((BigDecimal)secForcasts.get(i));
                BigDecimal b = this.alpha.divide(BigDecimal.ONE.subtract(this.alpha), mc).multiply(((BigDecimal)firstForcasts.get(i)).subtract((BigDecimal)secForcasts.get(i)));
                ret.add(a.add(b).setScale(this.scale, this.roundingMode));
                continue;
            }
            if (i <= this.source.length) continue;
            int idx = this.source.length - 1;
            BigDecimal a = new BigDecimal(2).multiply((BigDecimal)firstForcasts.get(idx)).subtract((BigDecimal)secForcasts.get(idx));
            BigDecimal b = this.alpha.divide(BigDecimal.ONE.subtract(this.alpha), mc).multiply(((BigDecimal)firstForcasts.get(idx)).subtract((BigDecimal)secForcasts.get(idx)));
            ret.add(a.add(b.multiply(new BigDecimal(i - this.source.length + 1))).setScale(this.scale, this.roundingMode));
        }
        return ret.toArray(new BigDecimal[0]);
    }
}

