/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.fcs.algorithm.method;

import com.kingdee.eas.industry.emm.project.fcs.algorithm.method.MovingAverageAlgorithm;
import java.math.BigDecimal;

public class TrendMovingAverageAlgorithm
extends MovingAverageAlgorithm {
    public TrendMovingAverageAlgorithm(double[] source, int forcastPeriod, int step) {
        super(source, forcastPeriod, step);
        if (step > forcastPeriod) {
            throw new IllegalArgumentException("step must less than forcastPeriod");
        }
    }

    @Override
    public BigDecimal[] calc() {
        this.source = super.calc();
        this.forcastPeriod = this.source.length;
        BigDecimal[] secMoving = super.calc();
        BigDecimal[] ret = new BigDecimal[this.source.length];
        BigDecimal two = new BigDecimal(2);
        for (int i = 0; i < this.source.length; ++i) {
            BigDecimal a = two.multiply(this.source[i]).subtract(secMoving[i]).abs();
            BigDecimal b = new BigDecimal(2.0 / (double)(this.step - 1)).multiply(this.source[i].subtract(secMoving[i]).abs());
            ret[i] = a.add(b).setScale(this.scale, this.roundingMode);
        }
        return ret;
    }
}

