/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pt.app.transfer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.industry.emm.pt.ProjectTransferEntryInfo;
import com.kingdee.eas.industry.emm.pt.ProjectTransferInfo;
import com.kingdee.eas.industry.emm.pt.app.transfer.TransferUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TransferJCHUtil
extends TransferUtil {
    public static void init(Context ctx, ProjectTransferInfo pt) throws EASBizException, BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("delete ct_pt_projectjch where fid = ?");
        DBUtil.executeUpdate((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pt.getId().toString()});
        sql.setLength(0);
        sql.append(" insert into ct_pt_projectjch");
        sql.append(" select *");
        sql.append(" from (select rownum oseq,o.*");
        sql.append(" from (select pto.fid,ojch.fid oldjchid,ojch.fnumber oldjchnumber");
        sql.append(" from CT_PT_ProjectTransfer pto");
        sql.append(" inner join T_EMM_ProjectJCH ojch on ojch.fparentid = pto.cfoldprojectid");
        sql.append(" where pto.fid = ?");
        sql.append(" order by ojch.fseq,ojch.fnumber) o");
        sql.append(" ) ptold");
        sql.append(" ,");
        sql.append(" (select rownum seq,n.*");
        sql.append(" from (select njch.fid newjchid,njch.fnumber newjchnumber");
        sql.append(" from CT_PT_ProjectTransfer ptn");
        sql.append(" inner join T_EMM_ProjectJCH njch on njch.fparentid = ptn.cfnewprojectid");
        sql.append(" where ptn.fid = ?");
        sql.append(" order by njch.fseq,njch.fnumber) n");
        sql.append(" ) ptnew");
        sql.append(" where ptold.oseq = ptnew.seq");
        DBUtil.executeUpdate((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pt.getId().toString(), pt.getId().toString()});
        sql.setLength(0);
        sql.append(" select ojch.fseq, ojch.fnumber");
        sql.append(" from CT_PT_ProjectTransfer pto");
        sql.append(" inner join T_EMM_ProjectJCH ojch on ojch.fparentid = pto.cfoldprojectid");
        sql.append(" left join ct_pt_projectjch ptjch on ptjch.oldjchid = ojch.fid and ptjch.fid = pto.fid");
        sql.append(" where pto.fid = ? ");
        sql.append(" and ptjch.oldjchid is null");
        IRowSet rows = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pt.getId().toString()});
        try {
            StringBuilder errors = new StringBuilder();
            while (rows.next()) {
                int fs = rows.getInt("fseq");
                String fn = rows.getString("fnumber");
                errors.append("\u3001").append(fn);
            }
            if (errors.length() > 0) {
                ProjectTransferEntryInfo ei = TransferJCHUtil.addEntryInfo(ctx, pt, "\u539f-\u65b0\u8282\u8f66\u53f7\u5339\u914d", "\u672a\u5339\u914d\u4e0a\u7684\u8282\u8f66\u53f7\uff1a" + errors.substring(1));
                NumericExceptionSubItem exc = new NumericExceptionSubItem(ei.getItemName(), ei.getRemark());
                throw new EASBizException(exc);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append("select count(1) dcount from ct_pt_projectjch where fid = ?");
        rows = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pt.getId().toString()});
        try {
            if (rows.next()) {
                BigDecimal dcount = rows.getBigDecimal("dcount");
                TransferJCHUtil.addEntryInfo(ctx, pt, "\u539f-\u65b0\u8282\u8f66\u53f7\u5339\u914d", "\u5df2\u5168\u5339\u914d\uff0c\u5171" + dcount + "\u6761");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

