/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.reworkprocess.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.zj.app.ZJDefaultWarehouseServerUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.common.BillBaseStatusEnum;
import com.kingdee.eas.industry.emm.common.util.TransactionTypeUtils;
import com.kingdee.eas.industry.emm.mo.EMMManufactureOrderEntrysGenFacadeFactory;
import com.kingdee.eas.industry.emm.mo.app.EMMManufactureOrderEntrysGenFacadeControllerBean;
import com.kingdee.eas.industry.emm.reworkprocess.ReworkBillChangeTypeEnum;
import com.kingdee.eas.industry.emm.reworkprocess.ReworkBillCollection;
import com.kingdee.eas.industry.emm.reworkprocess.ReworkBillEntryCollection;
import com.kingdee.eas.industry.emm.reworkprocess.ReworkBillEntryInfo;
import com.kingdee.eas.industry.emm.reworkprocess.ReworkBillInfo;
import com.kingdee.eas.industry.emm.reworkprocess.app.AbstractReworkBillControllerBean;
import com.kingdee.eas.mm.basedata.CSEntrustTypeEnum;
import com.kingdee.eas.mm.basedata.ControlStrategyCollection;
import com.kingdee.eas.mm.basedata.ControlStrategyFactory;
import com.kingdee.eas.mm.basedata.OperationFactory;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.OprTimeUnitEnum;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeFactory;
import com.kingdee.eas.mm.basedata.WorkCenterFactory;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.PickTypeEnum;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillEntryBaseCollection;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.zjbom.app.EngineeringChangeFormMaterialAudit;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class ReworkBillControllerBean
extends AbstractReworkBillControllerBean {
    private static final long serialVersionUID = 7990889905532340298L;
    private String RESURL = "com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess";
    public static final String TransactionType_Number_BACK = "443";
    public static final String TransactionType_Number_SPAN = "L465";
    public static final String TransactionType_Number_ADD = "442";

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ReworkBillInfo info = (ReworkBillInfo)model;
        if (info.getBaseStatus() == BillBaseStatusEnum.ADD) {
            info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        } else {
            if (info.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0000", (Locale)ctx.getLocale())));
            }
            if (info.getBaseStatus() == BillBaseStatusEnum.SUBMITED) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0001", (Locale)ctx.getLocale())));
            }
        }
        if (info.getNumber() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0002", (Locale)ctx.getLocale())));
        }
        if (info.getStorageOrgUnit() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0003", (Locale)ctx.getLocale())));
        }
        if (info.getProject() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0004", (Locale)ctx.getLocale())));
        }
        if (info.getStandardRooting() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0005", (Locale)ctx.getLocale())));
        }
        return super._save(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ReworkBillInfo info = this.getReworkBillInfo(ctx, pk);
        if (info.getBaseStatus() != BillBaseStatusEnum.ADD && info.getBaseStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && info.getBaseStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0006", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (((ReworkBillInfo)model).getBaseStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0000", (Locale)ctx.getLocale())));
        }
        ReworkBillCollection infos = new ReworkBillCollection();
        infos.add((ReworkBillInfo)model);
        this.checkData(ctx, infos, false);
        ((ReworkBillInfo)model).setBaseStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    @Override
    protected void _batchSubmit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        HashSet<IObjectPK> set = new HashSet<IObjectPK>();
        for (int i = 0; i < pks.length; ++i) {
            set.add(pks[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        ReworkBillCollection infos = this.getReworkBillCollection(ctx, view);
        this.checkData(ctx, infos, false);
        CoreBaseCollection c = new CoreBaseCollection();
        for (int i = 0; i < infos.size(); ++i) {
            infos.get(i).setBaseStatus(BillBaseStatusEnum.SUBMITED);
            c.add((CoreBaseInfo)infos.get(i));
        }
        this.updateBatchData(ctx, c);
    }

    @Override
    protected void _audit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._passAudit(ctx, (IObjectPK)new ObjectUuidPK(model.getBOSUuid("id")), model);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._unpassAudit(ctx, (IObjectPK)new ObjectUuidPK(model.getBOSUuid("id")), model);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ReworkBillInfo info = (ReworkBillInfo)model;
        if (info.getBaseStatus() == BillBaseStatusEnum.ADD || info.getBaseStatus() == BillBaseStatusEnum.TEMPORARILYSAVED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0007", (Locale)ctx.getLocale())));
        }
        if (info.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0000", (Locale)ctx.getLocale())));
        }
        ReworkBillCollection infos = new ReworkBillCollection();
        infos.add(info);
        this.checkData(ctx, infos, true);
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        this.process(ctx, info);
        this.update(ctx, pk, (CoreBaseInfo)info);
        super._passAudit(ctx, pk, model);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ReworkBillInfo info = (ReworkBillInfo)model;
        if (info.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0008", (Locale)ctx.getLocale())));
        }
        super._unpassAudit(ctx, pk, model);
    }

    protected void checkData(Context ctx, ReworkBillCollection infos, boolean isAudit) throws BOSException, EASBizException {
        StringBuilder msg = new StringBuilder();
        for (int i = 0; i < infos.size(); ++i) {
            ReworkBillEntryInfo entry;
            int j;
            ReworkBillInfo info = infos.get(i);
            if (msg.length() > 0) {
                msg.append("\n");
            }
            StringBuilder infoMsg = new StringBuilder();
            if (isAudit) {
                if (info.getBaseStatus() != BillBaseStatusEnum.SUBMITED) {
                    infoMsg.append("\n\r").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0009", (Locale)ctx.getLocale()));
                    throw new EASBizException(new NumericExceptionSubItem("", infoMsg.toString()));
                }
            } else if (info.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
                infoMsg.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0010", (Locale)ctx.getLocale()));
                throw new EASBizException(new NumericExceptionSubItem("", infoMsg.toString()));
            }
            if (info.getStorageOrgUnit() == null) {
                infoMsg.append("\n\r").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0003", (Locale)ctx.getLocale()));
            }
            if (info.getProject() == null) {
                infoMsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0004", (Locale)ctx.getLocale()));
            }
            if (info.getStandardRooting() == null) {
                infoMsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0005", (Locale)ctx.getLocale()));
            }
            if (info.getEntrys().isEmpty()) {
                infoMsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0011", (Locale)ctx.getLocale()));
            }
            ReworkBillEntryCollection entrys = info.getEntrys();
            HashMap<String, String> cache = new HashMap<String, String>();
            for (j = 0; j < entrys.size(); ++j) {
                entry = entrys.get(i);
                String t = entry.getTechnicsID() == null ? "S" : "T";
                String o = entry.getManufactureOrder().getId().toString() + entry.getOperation().getId();
                if (!cache.containsKey(o)) {
                    cache.put(o, t);
                    continue;
                }
                if (t.equals(cache.get(o))) continue;
                infoMsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0012", (Locale)ctx.getLocale()));
                break;
            }
            for (j = 0; j < entrys.size(); ++j) {
                String oql;
                String name;
                entry = entrys.get(i);
                boolean isStockData = entry.getTechnicsID() == null;
                String string = name = isStockData ? EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0013", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0014", (Locale)ctx.getLocale());
                if (ReworkBillChangeTypeEnum.DELETE == entry.getChangeType()) {
                    oql = "WHERE parent.ID='" + entry.getManufactureOrder().getId() + "' AND operationNo=" + entry.getOperationNo();
                    if (isStockData) {
                        if (ManufactureOrderStockFactory.getLocalInstance((Context)ctx).exists(oql)) continue;
                        infoMsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0015", (Locale)ctx.getLocale()) + name + "\uff1a" + EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0016", (Locale)ctx.getLocale()) + name + "\uff01");
                        break;
                    }
                    if (ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx).exists(oql)) continue;
                    infoMsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0015", (Locale)ctx.getLocale()) + name + "\uff1a" + EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0016", (Locale)ctx.getLocale()) + name + "\uff01");
                    break;
                }
                if (ReworkBillChangeTypeEnum.UPDATE == entry.getChangeType()) {
                    if (isStockData) {
                        if (entry.getStorageOrgUnit() == null) {
                            infoMsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0017", (Locale)ctx.getLocale()));
                            break;
                        }
                        if (entry.getProvideType() == null) {
                            infoMsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0018", (Locale)ctx.getLocale()));
                            break;
                        }
                        if (entry.getQty() != null) continue;
                        infoMsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0019", (Locale)ctx.getLocale()) + name + EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0020", (Locale)ctx.getLocale()));
                        break;
                    }
                    if (entry.getWorkcenter() == null) {
                        infoMsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0021", (Locale)ctx.getLocale()));
                        break;
                    }
                    if (entry.getWorkcenter() == null) {
                        infoMsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0022", (Locale)ctx.getLocale()));
                        break;
                    }
                    if (entry.getEntrustType() != CSEntrustTypeEnum.OPERATIONENTRUST || entry.getEntrustSupplier() != null) continue;
                    infoMsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0023", (Locale)ctx.getLocale()));
                    break;
                }
                if (ReworkBillChangeTypeEnum.ADD != entry.getChangeType()) continue;
                if (isStockData) {
                    if (entry.getQty() != null) continue;
                    infoMsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0019", (Locale)ctx.getLocale()) + name + EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0020", (Locale)ctx.getLocale()));
                    break;
                }
                oql = "WHERE parent.ID='" + entry.getManufactureOrder().getId() + "' AND operationNo=" + entry.getOperationNo();
                if (!ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx).exists(oql)) continue;
                infoMsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0019", (Locale)ctx.getLocale()) + name + EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0024", (Locale)ctx.getLocale()) + name + "\uff01");
                break;
            }
            if (infoMsg.length() <= 0) continue;
            infoMsg.insert(0, EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0025", (Locale)ctx.getLocale()) + "\u3010" + info.getNumber() + "\u3011" + (isAudit ? EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0026", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0027", (Locale)ctx.getLocale())) + EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0028", (Locale)ctx.getLocale()));
            msg.append(infoMsg.toString());
        }
        if (msg.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", msg.toString()));
        }
    }

    protected ManufactureOrderInfo dealTechnicsAdjustment(Context ctx, ReworkBillInfo info, ReworkBillEntryInfo entry, ManufactureOrderInfo adjustMOInfo, SCMBillEntryBaseCollection adjustTechnics, SCMBillEntryBaseCollection adjustStocks) throws BOSException, EASBizException {
        if (ReworkBillChangeTypeEnum.ADD == entry.getChangeType()) {
            ManufactureOrderTechnicsInfo t;
            if (!adjustTechnics.isEmpty()) {
                return adjustMOInfo;
            }
            if (adjustMOInfo.getBaseStatus() == com.kingdee.eas.scm.common.BillBaseStatusEnum.FINISH || adjustMOInfo.getBaseStatus() == com.kingdee.eas.scm.common.BillBaseStatusEnum.COMPLETE) {
                ManufactureOrderInfo adjustMOInfoNew = adjustMOInfo = (ManufactureOrderInfo)adjustMOInfo.clone();
                adjustMOInfoNew.setId(null);
                adjustMOInfoNew.setNumber(null);
                AutoNumberUtil.initNumber(ctx, (IObjectValue)adjustMOInfoNew);
                adjustMOInfoNew.getTechnics().clear();
                adjustMOInfoNew.getStocks().clear();
                t = this.addTechnics(ctx, entry, adjustMOInfoNew);
                adjustMOInfoNew.setTransactionType(ProductTransactionTypeFactory.getLocalInstance((Context)ctx).getProductTransactionTypeInfo("SELECT * WHERE bizType.id='yRPu9BAfSRuIIEu9QnyxviQHQ1w=' and storageOrgUnit.id='" + adjustMOInfoNew.getStorageOrgUnit().getId() + "' and isDefault = 1"));
                adjustMOInfoNew.setBizType(adjustMOInfoNew.getTransactionType().getBizType());
                ManufactureOrderFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)adjustMOInfoNew);
                ManufactureOrderFactory.getLocalInstance((Context)ctx).audit((IObjectPK)new ObjectUuidPK(adjustMOInfoNew.getId()));
                this.generateBOTPRelation(ctx, "ECC2A30F", "1D0D80DD", info.getId().toString(), adjustMOInfoNew.getId().toString());
            } else {
                t = this.addTechnics(ctx, entry, adjustMOInfo);
                ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)t);
            }
            adjustTechnics.add((SCMBillEntryBaseInfo)t);
        } else if (ReworkBillChangeTypeEnum.DELETE == entry.getChangeType()) {
            ManufactureOrderTechnicsCollection removeColl = new ManufactureOrderTechnicsCollection();
            removeColl.add((ManufactureOrderTechnicsInfo)adjustTechnics.get(0));
            new EMMManufactureOrderEntrysGenFacadeControllerBean().removeTechnicsInfoManuOrder(ctx, removeColl, adjustMOInfo);
            ManufactureOrderFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(adjustMOInfo.getId()), (CoreBaseInfo)adjustMOInfo);
            adjustMOInfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(adjustMOInfo.getId()));
            boolean isOnlyContainAuditEntry = true;
            ManufactureOrderTechnicsCollection technics = adjustMOInfo.getTechnics();
            if (technics != null) {
                for (int i = 0; i < technics.size(); ++i) {
                    if (technics.get(i).getBaseStatus() == EntryBaseStatusEnum.AUDITED) continue;
                    isOnlyContainAuditEntry = false;
                    break;
                }
            }
            if (isOnlyContainAuditEntry) {
                adjustMOInfo.setBaseStatus(com.kingdee.eas.scm.common.BillBaseStatusEnum.AUDITED);
                ManufactureOrderFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(adjustMOInfo.getId()), (CoreBaseInfo)adjustMOInfo);
            }
        } else if (ReworkBillChangeTypeEnum.UPDATE == entry.getChangeType()) {
            ManufactureOrderTechnicsInfo techInfo = (ManufactureOrderTechnicsInfo)adjustTechnics.get(0);
            techInfo.setEntrustType(entry.getEntrustType());
            techInfo.setWorkcenter(entry.getWorkcenter());
            techInfo.setIsCheckPoint(entry.isIsCheckPoint());
            techInfo.setIsPickingPoint(entry.isIsPickingPoint());
            techInfo.setIsReportPoint(entry.isIsReportPoint());
            techInfo.setEntrustSupplier(entry.getEntrustSupplier());
            techInfo.setStartPosition(entry.getTAIWEI());
            techInfo.setOperationRemark(entry.getProInstruction());
            ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(techInfo.getId()), (CoreBaseInfo)techInfo);
        }
        return adjustMOInfo;
    }

    protected void dealStockAjustment(Context ctx, ReworkBillInfo info, ReworkBillEntryInfo entry, ManufactureOrderInfo adjustMOInfo, SCMBillEntryBaseCollection adjustTechnics, SCMBillEntryBaseCollection adjustStocks) throws BOSException, EASBizException {
        Boolean MFTReleaseCMaterialReq = false;
        if (ReworkBillChangeTypeEnum.ADD == entry.getChangeType()) {
            if (adjustTechnics.isEmpty()) {
                adjustMOInfo = this.dealTechnicsAdjustment(ctx, info, entry, adjustMOInfo, adjustTechnics, adjustStocks);
            }
            if (adjustStocks.isEmpty()) {
                ManufactureOrderStockFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)this.addStock(ctx, info, entry, adjustMOInfo));
            } else {
                ManufactureOrderStockInfo sInfo = (ManufactureOrderStockInfo)adjustStocks.get(0);
                BigDecimal qty = this.addStockQty(ctx, info, entry, (ManufactureOrderStockInfo)adjustStocks.get(0), adjustMOInfo);
                if (MFTReleaseCMaterialReq.booleanValue() && adjustTechnics.size() > 0 && adjustTechnics.get(0).getBaseStatus().getValue() > 4) {
                    this.addMaterialReqBill(ctx, info, entry, adjustMOInfo, (ManufactureOrderStockInfo)adjustStocks.get(0), qty, true);
                }
                ManufactureOrderStockFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(sInfo.getId()), (CoreBaseInfo)sInfo);
            }
        } else {
            ManufactureOrderStockInfo sInfo = (ManufactureOrderStockInfo)adjustStocks.get(0);
            if (ReworkBillChangeTypeEnum.DELETE == entry.getChangeType()) {
                EMMManufactureOrderEntrysGenFacadeFactory.getLocalInstance((Context)ctx).subManuOrderStocksQty(null, sInfo.getQty(), sInfo, true);
            } else if (ReworkBillChangeTypeEnum.UPDATE == entry.getChangeType()) {
                if (adjustTechnics.size() > 0 && adjustTechnics.get(0).getBaseStatus().getValue() > 4) {
                    BigDecimal qty = this.addStockQty(ctx, info, entry, (ManufactureOrderStockInfo)adjustStocks.get(0), adjustMOInfo);
                    if (entry.getQty().compareTo(BigDecimal.ZERO) < 0) {
                        this.addMaterialReqBill(ctx, info, entry, adjustMOInfo, (ManufactureOrderStockInfo)adjustStocks.get(0), qty, false);
                    } else if (MFTReleaseCMaterialReq.booleanValue()) {
                        this.addMaterialReqBill(ctx, info, entry, adjustMOInfo, (ManufactureOrderStockInfo)adjustStocks.get(0), qty, true);
                    }
                } else {
                    this.addStockQty(ctx, info, entry, (ManufactureOrderStockInfo)adjustStocks.get(0), adjustMOInfo);
                }
                sInfo.setIssueMode(entry.getIssueMode());
                sInfo.setStorageOrgUnit(entry.getStorageOrgUnit());
                sInfo.setProvideType(entry.getProvideType());
                sInfo.setIsMustReq(entry.isIsMustReq());
                sInfo.setFlow(entry.getFlow());
                sInfo.setDispatchOrgUnit(entry.getDispatchOrgUnit());
                sInfo.setIsOwnObject(entry.isIsOwnObject());
                ManufactureOrderStockFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(sInfo.getId()), (CoreBaseInfo)sInfo);
            }
        }
    }

    protected String getParamValue(Context ctx, String paramName, String storageOrgUnitID) throws BOSException, EASBizException {
        if (storageOrgUnitID == null) {
            return null;
        }
        String value = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("value"));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)storageOrgUnitID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)paramName, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        ParamItemCollection paramItemCollection = ParamItemFactory.getLocalInstance((Context)ctx).getParamItemCollection(entityViewInfo);
        if (paramItemCollection != null && paramItemCollection.size() > 0 && paramItemCollection.get(0) != null) {
            value = paramItemCollection.get(0).getValue() == null ? "" : paramItemCollection.get(0).getValue();
        }
        return value;
    }

    protected void process(Context ctx, ReworkBillInfo info) throws BOSException, EASBizException {
        ArrayList<String> botpIDEdList = new ArrayList<String>();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            ManufactureOrderInfo adjustMOInfo;
            ReworkBillEntryInfo entry = info.getEntrys().get(i);
            try {
                adjustMOInfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(entry.getManufactureOrder().getId()));
            }
            catch (ObjectNotFoundException e) {
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"BMXDSCDDBCZ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{entry.getManufactureOrderNumber()});
                throw new EASBizException(new NumericExceptionSubItem("", strInfo));
            }
            SCMBillEntryBaseCollection adjustStocks = null;
            if (entry.getMaterial() != null) {
                adjustStocks = ManufactureOrderStockFactory.getLocalInstance((Context)ctx).getSCMBillEntryBaseCollection("where parent.id='" + entry.getManufactureOrder().getId() + "' and operationNo='" + entry.getOperationNo() + "' and operation.id='" + entry.getOperation().getId() + "' and material.id='" + entry.getMaterial().getId() + "'");
            }
            SCMBillEntryBaseCollection adjustTechnics = ManufactureOrderTechnicsFactory.getLocalInstance((Context)ctx).getSCMBillEntryBaseCollection("where parent.id='" + entry.getManufactureOrder().getId() + "' and operationNo='" + entry.getOperationNo() + "' and operation.id='" + entry.getOperation().getId() + "'");
            if (StringUtil.isEmptyString((String)entry.getTechnicsID())) {
                this.dealStockAjustment(ctx, info, entry, adjustMOInfo, adjustTechnics, adjustStocks);
            } else if (StringUtil.isEmptyString((String)entry.getStockID())) {
                this.dealTechnicsAdjustment(ctx, info, entry, adjustMOInfo, adjustTechnics, adjustStocks);
            } else {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0029", (Locale)ctx.getLocale())));
            }
            if (botpIDEdList != null && botpIDEdList.size() > 0 && botpIDEdList.contains(adjustMOInfo.getId().toString())) continue;
            botpIDEdList.add(adjustMOInfo.getId().toString());
            this.generateBOTPRelation(ctx, "ECC2A30F", "1D0D80DD", info.getId().toString(), adjustMOInfo.getId().toString());
        }
    }

    protected void generateBOTPRelation(Context ctx, String sourceBillType, String destBillType, String sourceBillID, String destBillID) throws BOSException, EASBizException {
        String curUserID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        SQLUtils.execute((Context)ctx, (String)EngineeringChangeFormMaterialAudit.sql_BOTPRelation.replace("CURDate()", "now()"), (Object[])new Object[]{sourceBillType, destBillType, sourceBillID, destBillID, curUserID});
    }

    private BigDecimal addStockQty(Context ctx, ReworkBillInfo info, ReworkBillEntryInfo entryInfo, ManufactureOrderStockInfo stockinfo, ManufactureOrderInfo manuFactureOrderInfo) throws EASBizException, BOSException {
        BigDecimal old = stockinfo.getQty();
        BigDecimal qty = entryInfo.getBaseQty().add(old);
        BigDecimal rQty = entryInfo.getQty().add(old);
        stockinfo.setQty(qty);
        stockinfo.setBaseQty(qty);
        stockinfo.setPlannedQty(rQty);
        stockinfo.setPlannedBaseQty(rQty);
        stockinfo.setLossBaseQty(entryInfo.getLossQty());
        stockinfo.setLossQty(entryInfo.getLossQty());
        stockinfo.setLossRatio(entryInfo.getLossQty().divide(qty, 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
        stockinfo.setUnitQty(stockinfo.getUnitQty().add(entryInfo.getBaseQty().divide(manuFactureOrderInfo.getQty(), stockinfo.getUnit().getQtyPrecision(), RoundingMode.HALF_UP)));
        stockinfo.setUnitBaseQty(stockinfo.getUnitQty());
        stockinfo.setUnIssueQty(stockinfo.getUnIssueQty().add(stockinfo.getUnitQty().multiply(manuFactureOrderInfo.getQty())));
        stockinfo.setUnIssueBaseQty(stockinfo.getUnIssueQty());
        stockinfo.setAssociateQty(stockinfo.getAssociateQty().add(stockinfo.getUnitQty().multiply(manuFactureOrderInfo.getQty())));
        manuFactureOrderInfo.getStocks().add(stockinfo);
        return entryInfo.getQty();
    }

    private ManufactureOrderStockInfo addStock(Context ctx, ReworkBillInfo info, ReworkBillEntryInfo entryInfo, ManufactureOrderInfo manuFactureOrderInfo) throws EASBizException, BOSException {
        ManufactureOrderStockInfo manufactureStockInfo = new ManufactureOrderStockInfo();
        MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(entryInfo.getMaterial().getId()));
        manufactureStockInfo.setParent(manuFactureOrderInfo);
        manufactureStockInfo.setMaterial(materialInfo);
        manufactureStockInfo.setUnit(materialInfo.getBaseUnit());
        manufactureStockInfo.setBaseUnit(materialInfo.getBaseUnit());
        manufactureStockInfo.setOperationNo(entryInfo.getOperationNo());
        manufactureStockInfo.setOperation(entryInfo.getOperation());
        manufactureStockInfo.setUnitQty(entryInfo.getUnitQty());
        manufactureStockInfo.setQty(entryInfo.getQty());
        manufactureStockInfo.setBaseQty(entryInfo.getBaseQty());
        if (entryInfo.getLossQty() != null) {
            manufactureStockInfo.setLossBaseQty(entryInfo.getLossBaseQty());
            manufactureStockInfo.setLossQty(entryInfo.getLossQty());
        } else {
            manufactureStockInfo.setLossBaseQty(BigDecimal.ZERO);
            manufactureStockInfo.setLossQty(BigDecimal.ZERO);
        }
        BigDecimal LossRatio = new BigDecimal(0);
        if (entryInfo.getQty() != null && entryInfo.getQty().compareTo(BigDecimal.ZERO) != 0 && entryInfo.getLossQty() != null) {
            LossRatio = entryInfo.getLossQty().multiply(new BigDecimal(100)).divide(entryInfo.getQty(), 4);
        }
        manufactureStockInfo.setLossRatio(LossRatio);
        manufactureStockInfo.setPlannedQty(manufactureStockInfo.getLossQty().add(manufactureStockInfo.getQty()));
        manufactureStockInfo.setPlannedBaseQty(manufactureStockInfo.getLossBaseQty().add(manufactureStockInfo.getBaseQty()));
        MaterialProvideTypeEnum materialProTypeEnum = entryInfo.getProvideType();
        manufactureStockInfo.setProvideType(materialProTypeEnum);
        manufactureStockInfo.setStorageOrgUnit(entryInfo.getStorageOrgUnit());
        manufactureStockInfo.setIssueMode(entryInfo.getIssueMode());
        if (manufactureStockInfo.getProvideType() == MaterialProvideTypeEnum.CURRENTORGPROVIDE) {
            manufactureStockInfo.setPickType(PickTypeEnum.INNERORG);
        } else if (manufactureStockInfo.getProvideType() == MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE && manufactureStockInfo.getStorageOrgUnit() != null && manufactureStockInfo.getReceiptStroageOrgUnit() != null && StringUtils.equals((String)manufactureStockInfo.getStorageOrgUnit().getId().toString(), (String)manufactureStockInfo.getReceiptStroageOrgUnit().getId().toString())) {
            manufactureStockInfo.setPickType(PickTypeEnum.INNERORG);
        } else {
            manufactureStockInfo.setPickType(PickTypeEnum.OTHERSTORAGE);
        }
        manufactureStockInfo.put("isMustReq", (Object)entryInfo.isIsMustReq());
        manufactureStockInfo.setDemandTime(manuFactureOrderInfo.getPlanBeginDate());
        manufactureStockInfo.setExtraRatio(BigDecimal.ZERO);
        if (manufactureStockInfo.getMaterial() != null) {
            WarehouseInfo warehouseInfo = null;
            materialProTypeEnum = entryInfo.getProvideType();
            warehouseInfo = materialProTypeEnum.equals((Object)MaterialProvideTypeEnum.CURRENTORGPROVIDE) || materialProTypeEnum.equals((Object)MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) ? ZJDefaultWarehouseServerUtils.getDefaultWarehouse((Context)ctx, (StorageOrgUnitInfo)manuFactureOrderInfo.getStorageOrgUnit(), (MaterialInfo)entryInfo.getMaterial(), (ProjectInfo)manuFactureOrderInfo.getProject(), (WorkCenterInfo)entryInfo.getWorkcenter()) : ZJDefaultWarehouseServerUtils.getDefaultWarehouse((Context)ctx, (StorageOrgUnitInfo)entryInfo.getStorageOrgUnit(), (MaterialInfo)entryInfo.getMaterial(), (ProjectInfo)manuFactureOrderInfo.getProject(), (boolean)true);
            manufactureStockInfo.setWarehouse(warehouseInfo);
            String storageId = entryInfo.getStorageOrgUnit().getId().toString();
            String materialId = manufactureStockInfo.getMaterial().getId().toString();
            MaterialPlanCollection materialPlanColl = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection("Where orgUnit.id = '" + storageId + "' And material.id = '" + materialId + "'");
            if (materialPlanColl.size() > 0) {
                MaterialPlanInfo materialPlanInfo = materialPlanColl.get(0);
                manufactureStockInfo.setIsBackflush(materialPlanInfo.isIsBackFlush());
            }
        }
        manufactureStockInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
        manufactureStockInfo.setUnIssueQty(manufactureStockInfo.getPlannedQty());
        manufactureStockInfo.setUnIssueBaseQty(manufactureStockInfo.getPlannedQty());
        manufactureStockInfo.setAssociateQty(manufactureStockInfo.getPlannedQty());
        manufactureStockInfo.put("flow", (Object)entryInfo.getFlow());
        manufactureStockInfo.setRemark(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0030", (Locale)ctx.getLocale()));
        manufactureStockInfo.setReceiptStroageOrgUnit(info.getStorageOrgUnit());
        manufactureStockInfo.setId(BOSUuid.create((String)"ED498839"));
        manuFactureOrderInfo.getStocks().add(manufactureStockInfo);
        manuFactureOrderInfo.setSourceBillId(info.getId().toString());
        return manufactureStockInfo;
    }

    private ManufactureOrderTechnicsInfo addTechnics(Context ctx, ReworkBillEntryInfo entryInfo, ManufactureOrderInfo manuFactureOrderInfo) throws BOSException, EASBizException {
        ManufactureOrderTechnicsInfo manufactureTechnicsInfo = new ManufactureOrderTechnicsInfo();
        manufactureTechnicsInfo.setParent(manuFactureOrderInfo);
        StorageOrgUnitInfo storageOrgInfo = manuFactureOrderInfo.getStorageOrgUnit();
        manufactureTechnicsInfo.setStorageOrgUnit(storageOrgInfo);
        ControlStrategyCollection controlStrColl = ControlStrategyFactory.getLocalInstance((Context)ctx).getControlStrategyCollection("Where storageOrgUnit.id = '" + storageOrgInfo.getId().toString() + "' And number = '0002'");
        if (controlStrColl.size() > 0) {
            manufactureTechnicsInfo.setControlStrategy(controlStrColl.get(0));
        }
        manufactureTechnicsInfo.setEarlistWoktime(manuFactureOrderInfo.getPlanBeginDate());
        manufactureTechnicsInfo.setLastWorktime(manuFactureOrderInfo.getPlanBeginDate());
        manufactureTechnicsInfo.setEarlistCmpTime(manuFactureOrderInfo.getPlanEndDate());
        manufactureTechnicsInfo.setLastCmpTime(manuFactureOrderInfo.getPlanEndDate());
        manufactureTechnicsInfo.setOperationNo(entryInfo.getOperationNo());
        manufactureTechnicsInfo.setEntrustType(entryInfo.getEntrustType());
        OperationInfo oi = OperationFactory.getLocalInstance((Context)ctx).getOperationInfo((IObjectPK)new ObjectUuidPK(entryInfo.getOperation().getId()));
        manufactureTechnicsInfo.setOperation(oi);
        manufactureTechnicsInfo.setIsXOpertion(oi.isIsXOpertion());
        WorkCenterInfo workCenter = entryInfo.getWorkcenter();
        workCenter = WorkCenterFactory.getLocalInstance((Context)ctx).getWorkCenterInfo((IObjectPK)new ObjectUuidPK(workCenter.getId()));
        manufactureTechnicsInfo.setWorkcenter(workCenter);
        manufactureTechnicsInfo.setAdminOrgUnit(workCenter.getAdminOrgUnit());
        manufactureTechnicsInfo.setEntrustSupplier(entryInfo.getEntrustSupplier());
        manufactureTechnicsInfo.setIsReportPoint(entryInfo.isIsReportPoint());
        manufactureTechnicsInfo.setIsCheckPoint(entryInfo.isIsCheckPoint());
        manufactureTechnicsInfo.setIsPickingPoint(entryInfo.isIsPickingPoint());
        manufactureTechnicsInfo.put("taiweif7", (Object)entryInfo.getTAIWEI());
        manufactureTechnicsInfo.put("opertionAlias", (Object)entryInfo.getOpertionAlias());
        manufactureTechnicsInfo.put("prolnstruction", (Object)entryInfo.getProInstruction());
        manufactureTechnicsInfo.setRemark(EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0030", (Locale)ctx.getLocale()));
        manufactureTechnicsInfo.setTimeUnit(OprTimeUnitEnum.Hour);
        BigDecimal qty = manuFactureOrderInfo.getQty();
        manufactureTechnicsInfo.setQty(qty);
        manufactureTechnicsInfo.setOperQty(qty);
        manufactureTechnicsInfo.setTotalUpperQty(qty);
        manufactureTechnicsInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
        manufactureTechnicsInfo.setControlStrategy(entryInfo.getOperation().getControlStrategy());
        manuFactureOrderInfo.getTechnics().add(manufactureTechnicsInfo);
        return manufactureTechnicsInfo;
    }

    private void addMaterialReqBill(Context ctx, ReworkBillInfo info, ReworkBillEntryInfo entryInfo, ManufactureOrderInfo orderManuFactureOrderInfo, ManufactureOrderStockInfo manufactureOrderStockInfo, BigDecimal qty, boolean isadd) throws EASBizException, BOSException {
        TransactionTypeInfo transType;
        MaterialReqBillInfo materialReqBillInfo = new MaterialReqBillInfo();
        AutoNumberUtil.initNumber(ctx, (IObjectValue)materialReqBillInfo);
        materialReqBillInfo.setSupplyStoreOrgUnit(manufactureOrderStockInfo.getStorageOrgUnit());
        materialReqBillInfo.setSourceBillId(info.getId().toString());
        materialReqBillInfo.setStorageOrgUnit(manufactureOrderStockInfo.getStorageOrgUnit());
        materialReqBillInfo.setAdminOrgUnit(orderManuFactureOrderInfo.getAdminOrgUnit());
        String transTypeNumber = TransactionType_Number_BACK;
        if (entryInfo != null && entryInfo.getProvideType() != null && entryInfo.getProvideType() == MaterialProvideTypeEnum.SPANORGPROVIDE) {
            transTypeNumber = TransactionType_Number_SPAN;
        }
        if (isadd) {
            transTypeNumber = TransactionType_Number_ADD;
        }
        try {
            transType = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo("where number = '" + transTypeNumber + "'");
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess", (String)"0EMMREWORK-0031", (Locale)ctx.getLocale()) + transTypeNumber));
        }
        materialReqBillInfo.setTransactionType(transType);
        BizTypeInfo bizTypeInfo = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo((IObjectPK)new ObjectUuidPK("0rSFjAEeEADgAAyMwKgSQiQHQ1w="));
        materialReqBillInfo.setBizType(bizTypeInfo);
        materialReqBillInfo.setBizDate(new Date());
        WorkCenterInfo centerInfo = entryInfo.getWorkcenter();
        centerInfo = WorkCenterFactory.getLocalInstance((Context)ctx).getWorkCenterInfo((IObjectPK)new ObjectUuidPK(entryInfo.getWorkcenter().getId()));
        if (centerInfo != null) {
            materialReqBillInfo.setCostCenterOrgUnit(centerInfo.getCostCenter());
        }
        materialReqBillInfo.put("costObject", (Object)orderManuFactureOrderInfo.getCostObject());
        MaterialReqBillEntryInfo billEntryInfo = new MaterialReqBillEntryInfo();
        billEntryInfo.setCostObject(orderManuFactureOrderInfo.getCostObject());
        billEntryInfo.setDemandDate(orderManuFactureOrderInfo.getPlanBeginDate());
        billEntryInfo.setMaterial(entryInfo.getMaterial());
        billEntryInfo.setOperation(entryInfo.getOperation());
        billEntryInfo.setOperationNo(entryInfo.getOperationNo());
        billEntryInfo.setOrderNumber(orderManuFactureOrderInfo.getNumber());
        billEntryInfo.setProject(orderManuFactureOrderInfo.getProject());
        billEntryInfo.setQty(qty);
        billEntryInfo.setStorageOrgUnit(entryInfo.getStorageOrgUnit());
        billEntryInfo.setTrackNumber(orderManuFactureOrderInfo.getTrackNumber());
        billEntryInfo.setInvUpdateType(TransactionTypeUtils.getInvUpdateTypeServer((Context)ctx, (TransactionTypeInfo)transType));
        MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(entryInfo.getMaterial().getId()));
        billEntryInfo.setMaterial(materialInfo);
        billEntryInfo.setUnit(materialInfo.getBaseUnit());
        billEntryInfo.setBaseUnit(materialInfo.getBaseUnit());
        billEntryInfo.setIssueQty(qty);
        billEntryInfo.setBaseIssueQty(qty);
        billEntryInfo.setBaseQty(qty);
        WarehouseInfo warehouseInfo = null;
        MaterialProvideTypeEnum materialProTypeEnum = entryInfo.getProvideType();
        warehouseInfo = materialProTypeEnum.equals((Object)MaterialProvideTypeEnum.CURRENTORGPROVIDE) || materialProTypeEnum.equals((Object)MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) ? ZJDefaultWarehouseServerUtils.getDefaultWarehouse((Context)ctx, (StorageOrgUnitInfo)orderManuFactureOrderInfo.getStorageOrgUnit(), (MaterialInfo)entryInfo.getMaterial(), (ProjectInfo)orderManuFactureOrderInfo.getProject(), (WorkCenterInfo)entryInfo.getWorkcenter()) : ZJDefaultWarehouseServerUtils.getDefaultWarehouse((Context)ctx, (StorageOrgUnitInfo)entryInfo.getStorageOrgUnit(), (MaterialInfo)entryInfo.getMaterial(), (ProjectInfo)orderManuFactureOrderInfo.getProject(), (boolean)true);
        billEntryInfo.setWarehouse(warehouseInfo);
        billEntryInfo.setWorkCenter(entryInfo.getWorkcenter());
        if (centerInfo != null) {
            billEntryInfo.setCostCenterOrgUnit(centerInfo.getCostCenter());
        }
        materialReqBillInfo.getEntry().add(billEntryInfo);
        MaterialReqBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)materialReqBillInfo);
        this.createBotRelation(ctx, MaterialReqBillFactory.getLocalInstance((Context)ctx).getType().toString(), info.getId().toString(), materialReqBillInfo.getId().toString());
    }

    private void createBotRelation(Context ctx, String DESTEntityID, String srcObjectID, String destObjectID) throws BOSException {
        UserInfo curUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        BOTRelationInfo info = new BOTRelationInfo();
        info.setSrcEntityID(this.getBOSType().toString());
        info.setDestEntityID(DESTEntityID);
        info.setSrcObjectID(srcObjectID);
        info.setDestObjectID(destObjectID);
        info.setDate(new Date());
        info.setOperatorID(curUserInfo.getId().toString());
        info.setIsEffected(true);
        info.setBOTMappingID(null);
        info.setType(0);
        BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
    }
}

