/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OperationLackAnalysisRptServer
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)OperationLackAnalysisRptServer.class.getName());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private final int analysisMaterial = 1;
    private final int analysisOperation = 0;
    private int analysisType = this.analysisOperation = 0;
    private Context ctx;
    private Date endDate;
    private String gongwei;
    private boolean isOnlyKeyMaterial;
    private boolean isOnlyShortage;
    private long lstart;
    private long lstop;
    private String materialId;
    private String materialNumber;
    private String materialProp;
    private String projectId;
    private String projectNumber;
    private String sou;
    private String souId;
    private Date startDate;
    private String warehouseIds;
    private String workShopId;

    private String getResultSql(String tmpTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("select project.fnumber as FProjectNumber");
        sql.append(",project.fname_l2 as FProjectName");
        if (this.analysisType == this.analysisOperation) {
            sql.append(",trackNum.fnumber as FTrackNumber");
            sql.append(",trackNum.fname_l2 as FTrackName");
            sql.append(",operation.fnumber as FOperationNumber");
            sql.append(",operation.fname_l2 as FOperationName");
            sql.append(",workCenter.fname_l2 as FWorkCenterName");
            sql.append(",tmp.FmaterialPropId");
        }
        sql.append(",material.fnumber as FMaterialNumber");
        sql.append(",material.fname_l2 as FMaterialName");
        sql.append(",unit.fname_l2 as FUnitName");
        sql.append(",tmp.FPlanQty as FPlanQty");
        sql.append(",tmp.FYLLQty as FYLQty");
        sql.append(",llWarehouse.fname_l2 as FYLWarehouse");
        sql.append(",tmp.FLLWareHouseInvQty as FInvQty");
        sql.append(",tmp.FEnough as FEnough");
        sql.append(",case when tmp.FisKeyMaterial=1 then '\u662f'\t else '\u5426' end as FisKeyMaterial,tmp.cfgongwei as cfgongwei");
        if (this.analysisType == this.analysisOperation) {
            sql.append(",tmp.freqdate as freqdate");
        }
        sql.append(" from " + tmpTable + " tmp");
        sql.append(" inner join t_mm_project project on project.fid=tmp.fprojectid");
        if (this.analysisType == this.analysisOperation) {
            sql.append(" inner join T_Mm_Tracknumber trackNum on trackNum.fid=tmp.FtrackId");
            sql.append(" inner join t_mm_operation operation on operation.fid=tmp.foperationId");
            sql.append(" inner join t_mm_workcenter workCenter on workCenter.fid=tmp.fworkcenterid");
        }
        sql.append(" inner join t_BD_Material material on material.fid=tmp.fmaterialId");
        sql.append(" inner join t_bd_measureunit unit on unit.fid=tmp.funitId");
        sql.append(" left join t_db_warehouse llWarehouse on llWarehouse.fid=tmp.FLLWareHouseId");
        sql.append(" left join t_db_warehouse wlbWarehouse on wlbWarehouse.fid=tmp.FWLBWareHouseId");
        sql.append(" Where 1=1");
        if (this.isOnlyShortage) {
            sql.append(" and tmp.FEnough < 0 ");
        }
        sql.append(" order by FProjectNumber");
        if (this.analysisType == this.analysisOperation) {
            sql.append(",FOperationNumber");
        }
        sql.append(",FMaterialNumber");
        return sql.toString();
    }

    private String getSqlForLLWarehouseInvQty(String tmpTable) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(fcurstoreqty) as FLLWareHouseInvQty ");
        sql.append(" from t_im_inventory inv  ");
        sql.append(" where inv.fwarehouseid=tmp.FLLWareHouseId  ");
        sql.append(" and inv.fmaterialid=tmp.fmaterialid  ");
        return sql.toString();
    }

    private String getSqlForMerge(String tmp) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from (");
        sql.append(" select fprojectid as FProjectId");
        if (this.analysisType == this.analysisOperation) {
            sql.append(" ,FtrackId as FtrackId ");
            sql.append(" ,FmaterialPropId as FmaterialPropId");
            sql.append(" ,FOperationId as FOperationId ");
            sql.append(" ,FWorkCenterId as FWorkCenterId");
        } else {
            sql.append(" ,null as FOperationId");
            sql.append(" ,null as FWorkCenterId");
        }
        sql.append(" ,FMaterialId as FMaterialId");
        sql.append(" ,FUnitId as FUnitId");
        if (this.analysisType == this.analysisOperation) {
            sql.append(" ,freqdate as freqdate");
        }
        sql.append(" ,sum(FPlanQty) as FPlanQty");
        sql.append(" ,sum(FYLLQty) as FYLLQty");
        sql.append(" ,FLLWareHouseId as FLLWareHouseId");
        sql.append(" ,null as FLLWareHouseInvQty");
        sql.append(" ,null as FWLBWareHouseId");
        sql.append(" ,null as FWLBWareHouseInvQty");
        sql.append(" ,0 as FEnough");
        sql.append(" ,1 as FFlag");
        sql.append(" ,FisKeyMaterial as FisKeyMaterial,cfgongwei as cfgongwei");
        sql.append(" from " + tmp + " tmp ");
        sql.append(" group by fprojectid,fmaterialid,FUnitId,FLLWareHouseId,FisKeyMaterial,cfgongwei ");
        if (this.analysisType == this.analysisOperation) {
            sql.append(",FtrackId,FOperationId,FWorkCenterId,FmaterialPropId,freqdate");
        }
        sql.append(" ) where rownum<10001");
        return sql.toString();
    }

    private String getSqlForStock() {
        StringBuffer sql = new StringBuffer();
        sql.append(" select mo.fprojectid as FProjectId");
        if (this.analysisType == this.analysisOperation) {
            sql.append(" ,mo.ftrackid as FtrackId");
            sql.append(",T_Mm_Bomentry.Fmaterialprop as FmaterialPropId");
        }
        sql.append(" ,tec.foperationid as FOperationId");
        sql.append(" ,tec.fworkcenterid as FWorkCenterId");
        sql.append(" ,sto.fmaterialid  as FMaterialId");
        sql.append(" ,sto.funitid as FUnitId");
        sql.append(" ,sto.FDemandTime as FReqDate");
        sql.append(" ,sto.fplannedQty as FPlanQty");
        sql.append(" ,sto.FActIssueQty as FYLLQty");
        sql.append(" ,sto.fwarehouseid as FLLWareHouseId");
        sql.append(" ,0 as FLLWareHouseInvQty");
        sql.append(" ,null as FWLBWareHouseId");
        sql.append(" ,0 as FWLBWareHouseInvQty");
        sql.append(" ,0 as FEnough");
        sql.append(" ,0 as FFlag");
        sql.append(" ,0 as FisKeyMaterial");
        sql.append(" ,LD.FNumber as cfgongwei");
        sql.append(" from t_mm_manufactureorder mo ");
        sql.append(" inner join  t_mm_mftordertechnics tec on mo.fid=tec.fparentid");
        sql.append(" inner join  t_mm_mftorderstock sto on mo.fid=sto.fparentid");
        sql.append(" Left Join CT_EMM_LocationDefined LD On LD.FID=TEC.FLocationDefine ");
        if (this.analysisType == this.analysisOperation) {
            sql.append(" left join T_Mm_Bom ON T_Mm_Bom.fid = mo.fbomid ");
            sql.append(" left join T_Mm_Bomentry ON T_Mm_Bomentry.Fparentid = T_Mm_Bom.fid ");
            sql.append(" and sto.fmaterialid = T_Mm_Bomentry.Fmaterialid ");
        }
        sql.append(" where tec.foperationno=sto.foperationno ");
        sql.append(" and sto.fissuemode=11010 ");
        if (this.startDate != null) {
            sql.append(" and tec.FEarlistWoktime>=to_date('" + sdf.format(this.startDate) + " 00:00:00','yyyy-MM-dd hh24:mi:ss')");
        }
        if (this.endDate != null) {
            sql.append(" and tec.FEarlistWoktime<=to_date('" + sdf.format(this.endDate) + " 23:59:59','yyyy-MM-dd hh24:mi:ss')");
        }
        if (this.souId != null) {
            sql.append(" and mo.fstorageorgunitid='" + this.souId + "'");
        }
        if (this.projectId != null) {
            sql.append(" and mo.fprojectid='" + this.projectId + "'");
        }
        if (this.materialId != null) {
            sql.append(" and sto.fmaterialid='" + this.materialId + "'");
        }
        if (this.isOnlyKeyMaterial) {
            sql.append(" and sto.fmaterialid in (select cfmaterialid from  CT_MM_CoreMaterial where Cfstorageorgunitid='" + this.souId + "')");
        }
        if (this.warehouseIds != null && !"".equals(this.warehouseIds)) {
            sql.append(" and T_db_warehouse.fnumber in (").append(this.warehouseIds).append(")");
        }
        if (this.workShopId != null && !"".equals(this.workShopId)) {
            sql.append(" and tec.fworkcenterid in (Select fid from T_Mm_Workcenter where T_Mm_Workcenter.fparentwcid = '").append(this.workShopId).append("')");
        }
        if (this.analysisType == this.analysisOperation && this.materialProp != null && !"".equals(this.materialProp)) {
            sql.append(" and T_Mm_Bomentry.Fmaterialprop = ").append(this.materialProp).append(" ");
        }
        if (this.gongwei != null && !"".equals(this.gongwei)) {
            sql.append(" and LD.FNumber like '%").append(this.gongwei).append("%' ");
        }
        return sql.toString();
    }

    private String getSqlForWLBWareHouse(String tmpTable) throws BOSException, EASBizException {
        String fstorageorgunitid = "";
        fstorageorgunitid = ContextUtil.getCurrentStorageUnit((Context)this.getContext()).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select ");
        sql.append(" mp.fdefaultwarehouseid  As fid");
        sql.append(" from t_bd_materialinventory mp");
        sql.append("  where mp.forgunit = '").append(fstorageorgunitid).append("'");
        sql.append("  and mp.fmaterialid = tmp.FMaterialId ");
        return sql.toString();
    }

    private String getSqlForWLBWareHouseInvQty(String tmpTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(fcurstoreqty) as FWLBWareHouseInvQty ");
        sql.append(" from t_im_inventory inv  ");
        sql.append(" where inv.fwarehouseid=tmp.FWLBWareHouseId  ");
        sql.append(" and inv.fmaterialid=tmp.fmaterialid  ");
        String fstorageorgunitid = "";
        fstorageorgunitid = ContextUtil.getCurrentStorageUnit((Context)this.getContext()).getId().toString();
        sql.append(" and inv.fstorageorgunitid='").append(fstorageorgunitid).append("'");
        return sql.toString();
    }

    private void initRptParams(RptParams params) {
        String temp;
        IRowSet rs;
        if (params.getObject("storageOrgUnit") != null) {
            this.sou = (String)params.getObject("storageOrgUnit");
            try {
                rs = DbUtil.executeQuery((Context)this.ctx, (String)("select fid from t_org_storage where fnumber='" + this.sou + "'"));
                while (rs.next()) {
                    this.souId = rs.getString("fid");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.sou = null;
            this.souId = null;
        }
        if (params.getObject("project") != null) {
            this.projectNumber = (String)params.getObject("project");
            try {
                rs = DbUtil.executeQuery((Context)this.ctx, (String)("select fid from t_mm_project where fnumber='" + this.projectNumber + "'"));
                while (rs.next()) {
                    this.projectId = rs.getString("fid");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.projectNumber = null;
            this.projectId = null;
        }
        if (params.getObject("material") != null) {
            this.materialNumber = (String)params.getObject("material");
            try {
                rs = DbUtil.executeQuery((Context)this.ctx, (String)("select fid from t_bd_material where fnumber='" + this.materialNumber + "'"));
                while (rs.next()) {
                    this.materialId = rs.getString("fid");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.materialNumber = null;
            this.materialId = null;
        }
        this.analysisType = "true".equals(params.getObject("analysisOperation")) ? this.analysisOperation : this.analysisMaterial;
        this.isOnlyKeyMaterial = params.getObject("isOnlyKeyMaterial") != null ? Boolean.parseBoolean(params.getObject("isOnlyKeyMaterial").toString()) : false;
        this.isOnlyShortage = params.getObject("isOnlyShortage") != null ? Boolean.parseBoolean(params.getObject("isOnlyShortage").toString()) : false;
        if (params.getObject("startDate") != null) {
            temp = (String)params.getObject("startDate");
            try {
                this.startDate = sdf.parse(temp);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (params.getObject("endDate") != null) {
            temp = (String)params.getObject("endDate");
            try {
                this.endDate = sdf.parse(temp);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (params.getObject("warehouse") != null) {
            this.warehouseIds = "";
            String warehouseStr = params.getString("warehouse");
            String[] warehouseArray = warehouseStr.split(";");
            if (warehouseArray.length > 0) {
                for (int i = 0; i < warehouseArray.length; ++i) {
                    this.warehouseIds = i == warehouseArray.length - 1 ? this.warehouseIds + "'" + warehouseArray[i].trim() + "'" : this.warehouseIds + "'" + warehouseArray[i].trim() + "',";
                }
            }
        } else {
            this.warehouseIds = null;
        }
        if (params.getObject("workShop") != null) {
            String workShopNumStr = (String)params.getObject("workShop");
            try {
                IRowSet rs2 = DbUtil.executeQuery((Context)this.ctx, (String)("select fid from T_Mm_Workcenter where fnumber='" + workShopNumStr + "'"));
                while (rs2.next()) {
                    this.workShopId = rs2.getString("fid");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.workShopId = null;
        }
        this.materialProp = params.getObject("materialProp") != null ? (String)params.getObject("materialProp") : null;
        this.gongwei = params.getObject("gongwei") != null ? (String)params.getObject("gongwei") : null;
    }

    protected IRowSet getReportData(String reportId, RptParams params) throws Exception {
        this.ctx = this.getContext();
        this.initRptParams(params);
        logger.info((Object)"============ OperationLackAnalysis start createTempTable1===================");
        this.lstart = System.currentTimeMillis();
        String trackFieldId = "";
        String materialPropId = "";
        if (this.analysisType == this.analysisOperation) {
            trackFieldId = "  FtrackId VARCHAR(44),";
            materialPropId = "  FmaterialPropId VARCHAR(44),";
        }
        String tmpTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable("CREATE TABLE NEWDATA (   FProjectId VARCHAR(44)," + trackFieldId + materialPropId + "  FOperationId VARCHAR(44),  FWorkCenterId VARCHAR(44),  FMaterialId VARCHAR(44),  FUnitId VARCHAR(44),  FReqDate DateTime,  FPlanQty NUMERIC(21,8) DEFAULT 0,  FYLLQty NUMERIC(21,8) DEFAULT 0,  FLLWareHouseId VARCHAR(44),  FLLWareHouseInvQty NUMERIC(21,8) DEFAULT 0,  FWLBWareHouseId VARCHAR(44) DEFAULT 0,  FWLBWareHouseInvQty NUMERIC(21,8) DEFAULT 0,  FEnough NUMERIC(21,8) DEFAULT 0,  FFlag   int  DEFAULT 0,  FisKeyMaterial   int  DEFAULT 0,  cfgongwei   VARCHAR(100)  )");
        this.lstop = System.currentTimeMillis();
        String reqDate = "";
        if (this.analysisType == this.analysisOperation) {
            reqDate = "  FReqDate DateTime,";
        }
        String tmpTable2 = TempTablePool.getInstance((Context)this.getContext()).createTempTable("CREATE TABLE NEWDATA (   FProjectId VARCHAR(44)," + trackFieldId + materialPropId + "  FOperationId VARCHAR(44),  FWorkCenterId VARCHAR(44),  FMaterialId VARCHAR(44),  FUnitId VARCHAR(44)," + reqDate + "  FPlanQty NUMERIC(21,8) DEFAULT 0,  FYLLQty NUMERIC(21,8) DEFAULT 0,  FLLWareHouseId VARCHAR(44),  FLLWareHouseInvQty NUMERIC(21,8) DEFAULT 0,  FWLBWareHouseId VARCHAR(44) DEFAULT 0,  FWLBWareHouseInvQty NUMERIC(21,8) DEFAULT 0,  FEnough NUMERIC(21,8) DEFAULT 0,  FFlag   int  DEFAULT 0,  FisKeyMaterial   int  DEFAULT 0,  cfgongwei   VARCHAR(100)  )");
        this.lstop = System.currentTimeMillis();
        logger.info((Object)("########### OperationLackAnalysis createTempTable1 end : " + (this.lstop - this.lstart)));
        logger.info((Object)"########### start insert stockData###########");
        this.lstart = System.currentTimeMillis();
        DbUtil.execute((Context)this.ctx, (String)("/*dialect*/ insert into " + tmpTable + " " + this.getSqlForStock()));
        this.lstop = System.currentTimeMillis();
        logger.info((Object)("########### inser stockData end : " + (this.lstop - this.lstart)));
        logger.info((Object)"########### update isKeyMaterial###########");
        this.lstart = System.currentTimeMillis();
        DbUtil.execute((Context)this.ctx, (String)("/*dialect*/ update " + tmpTable + " tmp set FisKeyMaterial=1  where exists (select 1 from  CT_MM_CoreMaterial where Cfstorageorgunitid='" + this.souId + "' and cfmaterialid=tmp.fmaterialid)"));
        this.lstop = System.currentTimeMillis();
        logger.info((Object)("########### update isKeyMaterial end : " + (this.lstop - this.lstart)));
        logger.info((Object)"########### start MergeData###########");
        this.lstart = System.currentTimeMillis();
        DbUtil.execute((Context)this.ctx, (String)("/*dialect*/ insert into " + tmpTable2 + " " + this.getSqlForMerge(tmpTable)));
        this.lstop = System.currentTimeMillis();
        logger.info((Object)("########### MergeData end : " + (this.lstop - this.lstart)));
        logger.info((Object)"########### start update FLLWareHouseInvQty###########");
        this.lstart = System.currentTimeMillis();
        DbUtil.execute((Context)this.ctx, (String)("/*dialect*/ update  " + tmpTable2 + " tmp set FLLWareHouseInvQty=(" + this.getSqlForLLWarehouseInvQty(tmpTable2) + ")"));
        this.lstop = System.currentTimeMillis();
        logger.info((Object)("###########  update FLLWareHouseInvQty end : " + (this.lstop - this.lstart)));
        logger.info((Object)"########### start update FWLBWareHouseId###########");
        this.lstart = System.currentTimeMillis();
        DbUtil.execute((Context)this.ctx, (String)("/*dialect*/ update  " + tmpTable2 + " tmp set FWLBWareHouseId= (" + this.getSqlForWLBWareHouse(tmpTable2) + ")"));
        this.lstop = System.currentTimeMillis();
        logger.info((Object)("###########  update FWLBWareHouseId end : " + (this.lstop - this.lstart)));
        logger.info((Object)"########### start update FWLBWareHouseInvQty###########");
        this.lstart = System.currentTimeMillis();
        DbUtil.execute((Context)this.ctx, (String)("/*dialect*/ update  " + tmpTable2 + " tmp set FWLBWareHouseInvQty=(" + this.getSqlForWLBWareHouseInvQty(tmpTable2) + ") "));
        this.lstop = System.currentTimeMillis();
        logger.info((Object)("###########  update FWLBWareHouseInvQty end : " + (this.lstop - this.lstart)));
        logger.info((Object)"########### start update FEnough###########");
        this.lstart = System.currentTimeMillis();
        DbUtil.execute((Context)this.ctx, (String)("/*dialect*/ update  " + tmpTable2 + " tmp set FEnough=nvl(FLLWareHouseInvQty,0)+nvl(FYLLQty,0)-nvl(FPlanQty,0) "));
        this.lstop = System.currentTimeMillis();
        logger.info((Object)("###########  update FEnough end : " + (this.lstop - this.lstart)));
        logger.info((Object)"########### start getResult###########");
        this.lstart = System.currentTimeMillis();
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)this.getResultSql(tmpTable2));
        this.lstop = System.currentTimeMillis();
        logger.info((Object)("###########  getResult end : " + (this.lstop - this.lstart)));
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tmpTable);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tmpTable2);
        return rs;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams params) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        reportHeader.addChild("FProjectNumber", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0000", (Locale)this.ctx.getLocale())).setWidth(80);
        reportHeader.addChild("FProjectName", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0001", (Locale)this.ctx.getLocale())).setWidth(130);
        if (this.analysisType == this.analysisOperation) {
            reportHeader.addChild("FTrackNumber", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0002", (Locale)this.ctx.getLocale())).setWidth(130);
            reportHeader.addChild("FTrackName", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0003", (Locale)this.ctx.getLocale())).setWidth(120);
            reportHeader.addChild("FOperationNumber", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0004", (Locale)this.ctx.getLocale())).setWidth(130);
            reportHeader.addChild("FOperationName", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0005", (Locale)this.ctx.getLocale())).setWidth(130);
            reportHeader.addChild("FWorkCenterName", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0006", (Locale)this.ctx.getLocale())).setVisible(false);
            reportHeader.addChild("freqdate", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0007", (Locale)this.ctx.getLocale())).setWidth(140);
        }
        reportHeader.addChild("FMaterialNumber", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0008", (Locale)this.ctx.getLocale())).setWidth(125);
        reportHeader.addChild("FMaterialName", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0009", (Locale)this.ctx.getLocale())).setWidth(120);
        if (this.analysisType == this.analysisOperation) {
            reportHeader.addChild("FmaterialPropId", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0010", (Locale)this.ctx.getLocale())).setWidth(130);
        }
        reportHeader.addChild("FUnitName", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0011", (Locale)this.ctx.getLocale())).setWidth(130);
        reportHeader.addChild("FPlanQty", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0012", (Locale)this.ctx.getLocale())).setWidth(130).setAlign(3);
        reportHeader.addChild("FYLQty", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0013", (Locale)this.ctx.getLocale())).setWidth(130).setAlign(3);
        reportHeader.addChild("FYLWarehouse", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0014", (Locale)this.ctx.getLocale())).setWidth(130);
        reportHeader.addChild("FInvQty", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0015", (Locale)this.ctx.getLocale())).setWidth(130).setAlign(3);
        reportHeader.addChild("FEnough", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0016", (Locale)this.ctx.getLocale())).setWidth(130).setAlign(3);
        reportHeader.addChild("FisKeyMaterial", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0017", (Locale)this.ctx.getLocale())).setWidth(80);
        reportHeader.addChild("cfgongwei", EASResource.getString((String)"com.kingdee.eas.industry.report.EMMEMRptResource", (String)"0EMMRPT-0018", (Locale)this.ctx.getLocale()));
        return reportHeader;
    }

    protected ReportTitles getReportTitles(String s, RptParams rptparams) throws BaseException {
        return null;
    }
}

