/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.webservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.framework.DataBaseDAssignCollection;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WHStateEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.webservice.AbstractWSBomWebServiceFacadeControllerBean;
import com.kingdee.eas.industry.webservice.WSBOMInfo;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BOMUsageEnum;
import com.kingdee.eas.mm.basedata.BomChangeFactory;
import com.kingdee.eas.mm.basedata.BomChangeInfo;
import com.kingdee.eas.mm.basedata.BomChangeNewEntryInfo;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomGroupstandardFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.DesignModeCollection;
import com.kingdee.eas.mm.basedata.DesignModeEntryInfo;
import com.kingdee.eas.mm.basedata.DesignModeFactory;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.IBomEntry;
import com.kingdee.eas.mm.basedata.IssuePropEnum;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.MainTenanceLevelCollection;
import com.kingdee.eas.mm.basedata.MainTenanceLevelFactory;
import com.kingdee.eas.mm.basedata.MainTenanceLevelInfo;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.util.MfgBomUtil;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.project.ProjectCarCollection;
import com.kingdee.eas.mm.project.ProjectCarFactory;
import com.kingdee.eas.mm.project.ProjectCarInfo;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.convert.BomChangeBillAuditFacadeFactory;
import com.kingdee.eas.zjbom.convert.process.BomConvertBaseProcess;
import com.kingdee.eas.zjbom.convert.util.BomUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WSBomWebServiceFacadeControllerBean
extends AbstractWSBomWebServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.webservice.WSBomWebServiceFacadeControllerBean");
    private static final String BOM_RESOURCE_PATH = "com.kingdee.eas.mm.basedata.BOMResource";

    @Override
    protected String[] _importBom(Context ctx, IObjectCollection wswsBom) throws BOSException, EASBizException {
        if (wswsBom.size() == 0 || wswsBom == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"QSXLHBOMCS_LESS", (Locale)ctx.getLocale()));
        }
        System.out.print("---------------webservice start import Bom-------------------");
        CoreBaseCollection coreBaseCol = new CoreBaseCollection();
        IBom idb = BomFactory.getLocalInstance((Context)ctx);
        String[] result = new String[wswsBom.size()];
        for (int i = 0; i < wswsBom.size(); ++i) {
            System.out.println(wswsBom.getClass() + ":" + wswsBom.getObject(i).toString() + ";");
            WSBOMInfo wsBomInfo = (WSBOMInfo)wswsBom.getObject(i);
            String error = "";
            if (wsBomInfo.getDesignno() == null || wsBomInfo.getDesignno().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJRGHNUMBER_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomInfo.getDesignno(), CompareType.EQUALS));
            if (!UserFactory.getLocalInstance((Context)ctx).exists(filter)) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJRGHBCZ_NOT_EXIST", (Locale)ctx.getLocale(), (Object[])new Object[]{wsBomInfo.getDesignno()});
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfoByNumber(wsBomInfo.getDesignno());
            if (wsBomInfo.getStorageOrgUnitNumber() == null || wsBomInfo.getStorageOrgUnitNumber().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LYKCZZBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            EntityViewInfo stoEv = new EntityViewInfo();
            FilterInfo stoFilter = new FilterInfo();
            stoFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomInfo.getStorageOrgUnitNumber(), CompareType.EQUALS));
            stoEv.setFilter(stoFilter);
            StorageOrgUnitCollection storageCol = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(stoEv);
            if (storageCol == null || storageCol.size() == 0) {
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LYKCZZBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                continue;
            }
            StorageOrgUnitInfo storageInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageCol.get(0).getId()));
            if (!WSBomWebServiceFacadeControllerBean.hasPermission(ctx, "mm_bom_addnew", new ObjectUuidPK(storageInfo.getId()), userInfo.getId().toString())) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJRMYZZBOMXZQXZ_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{userInfo.getName(), storageInfo.getName()});
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (!storageInfo.isIsBizUnit()) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KCZZBWSHTKCZZ_NOT_BIZUNIT", (Locale)ctx.getLocale(), (Object[])new Object[]{storageInfo.getName()});
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            CtrlUnitInfo cu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(storageInfo.getCU().getId()));
            if (wsBomInfo.getSourceBillId() == null || wsBomInfo.getSourceBillId().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"PLMSJBOMID_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsBomInfo.getParentmaterialnumber() == null || wsBomInfo.getParentmaterialnumber().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SSLJBMBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsBomInfo.getMaterialnumber() == null || wsBomInfo.getMaterialnumber().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LJBMBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsBomInfo.getParentunitname() == null || wsBomInfo.getParentunitname().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SSLJJLDWMCB_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsBomInfo.getUnitname() == null || wsBomInfo.getUnitname().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LJJLDWMCB_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsBomInfo.getDesignMode() == null || wsBomInfo.getDesignMode().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJMSBNWK_DONOT", (Locale)ctx.getLocale());
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsBomInfo.getSupplyOrgUnitnumber() == null || wsBomInfo.getSupplyOrgUnitnumber().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"GHKCZZBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsBomInfo.getMaterialProp() == null || wsBomInfo.getMaterialProp().equals("")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WLSXBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsBomInfo.getCanSelected() == null || wsBomInfo.getCanSelected().equals("")) {
                wsBomInfo.setCanSelected("0");
            } else if (!wsBomInfo.getCanSelected().equals("0") && !wsBomInfo.getCanSelected().equals("1")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KXJZNWLY_ONLY", (Locale)ctx.getLocale());
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsBomInfo.getFirstCfg() == null || wsBomInfo.getFirstCfg().equals("")) {
                wsBomInfo.setFirstCfg("0");
            } else if (!wsBomInfo.getFirstCfg().equals("0") && !wsBomInfo.getFirstCfg().equals("1")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SXPZZNWLY_ONLY", (Locale)ctx.getLocale());
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsBomInfo.getFeture() == null || wsBomInfo.getFeture().equals("")) {
                wsBomInfo.setFeture("0");
            } else if (!wsBomInfo.getFeture().equals("0") && !wsBomInfo.getFeture().equals("1")) {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"TZJZNWLY_ONLY", (Locale)ctx.getLocale());
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsBomInfo.getFixSeq() != null && !wsBomInfo.getFixSeq().equals("")) {
                if (!WSBomWebServiceFacadeControllerBean.isInteteger(wsBomInfo.getFixSeq())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"ZHPXHGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                    continue;
                }
            } else {
                wsBomInfo.setFixSeq("0");
            }
            if (wsBomInfo.getEffectiveDate() != null && !wsBomInfo.getEffectiveDate().equals("")) {
                if (!WSBomWebServiceFacadeControllerBean.isDate(wsBomInfo.getEffectiveDate())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"ENARQGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                    continue;
                }
            } else {
                wsBomInfo.setEffectiveDate("1999-01-01");
            }
            if (wsBomInfo.getDisableDate() != null && !wsBomInfo.getDisableDate().equals("")) {
                if (!WSBomWebServiceFacadeControllerBean.isDate(wsBomInfo.getDisableDate())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SHXDAGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                    continue;
                }
            } else {
                wsBomInfo.setDisableDate("2099-01-01");
            }
            if (wsBomInfo.getNetWeight() != null && !wsBomInfo.getNetWeight().equals("")) {
                if (!WSBomWebServiceFacadeControllerBean.isPosNumber(wsBomInfo.getNetWeight())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JZHGSHBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                    continue;
                }
            }
            if (wsBomInfo.getProductQty() != null && !wsBomInfo.getProductQty().equals("") && !wsBomInfo.getProductQty().equals("0")) {
                if (!WSBomWebServiceFacadeControllerBean.isPosNumber(wsBomInfo.getProductQty())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SHCSHLGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                    continue;
                }
            } else {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SHCHSHLBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            if (wsBomInfo.getConsumeFixQty() != null && !wsBomInfo.getConsumeFixQty().equals("")) {
                if (!WSBomWebServiceFacadeControllerBean.isPosNumber(wsBomInfo.getConsumeFixQty())) {
                    error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XHDEGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                    continue;
                }
            } else {
                error = ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XHDEBNWK_NOT_NULL", (Locale)ctx.getLocale());
                result[i] = wsBomInfo.getSourceBillId() + ",-1," + error;
                continue;
            }
            String designResult = this.addNewBom(ctx, wsBomInfo, userInfo, cu, coreBaseCol);
            if (coreBaseCol.size() > 0) {
                int size = coreBaseCol.size();
                for (int j = 0; j < size; ++j) {
                    idb.save(coreBaseCol.get(j));
                }
            }
            result[i] = designResult;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String addNewBom(Context ctx, WSBOMInfo wsBomInfo, UserInfo userInfo, CtrlUnitInfo cu, CoreBaseCollection coreBaseCol) throws BOSException, EASBizException {
        ProjectInfo projectInfo;
        TrackNumberInfo endTrack;
        TrackNumberInfo startTrack;
        BOMTypeEnum BomType;
        WarehouseInfo deWarehouse;
        WarehouseInfo warehouse;
        MeasureUnitInfo paUnitInfo;
        MeasureUnitInfo unitInfo;
        MaterialPlanInfo paMaPlan;
        MaterialPlanInfo maPlan;
        MaterialPlanCollection maPlanCol;
        MaterialInfo parentMaterial;
        MaterialInfo materialInfo;
        DesignModeInfo designMode;
        Boolean isProjectManu;
        IssuePropEnum issuePropEnum;
        MainTenanceLevelInfo mainTenanceLevelInfo;
        StorageOrgUnitInfo transferInfo;
        SupplierInfo childSupplyInfo;
        SupplierInfo getSupplyInfo;
        StorageOrgUnitInfo supplyInfo;
        StorageOrgUnitInfo storageInfo;
        BOSUuid pk;
        IBom ib;
        IBomEntry ibe;
        BomEntryInfo bomEntryInfo;
        BomInfo bomInfo;
        block245: {
            bomInfo = new BomInfo();
            bomEntryInfo = new BomEntryInfo();
            ibe = BomEntryFactory.getLocalInstance((Context)ctx);
            ib = BomFactory.getLocalInstance((Context)ctx);
            IStorageOrgUnit isr = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
            IMaterialPlan imp = MaterialPlanFactory.getLocalInstance((Context)ctx);
            pk = null;
            Timestamp now = new Timestamp(System.currentTimeMillis());
            EntityViewInfo stoEv = new EntityViewInfo();
            FilterInfo stoFilter = new FilterInfo();
            stoFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomInfo.getStorageOrgUnitNumber(), CompareType.EQUALS));
            stoEv.setFilter(stoFilter);
            StorageOrgUnitCollection storageCol = isr.getStorageOrgUnitCollection(stoEv);
            if (storageCol == null || storageCol.size() == 0) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LYKCZZBCZ_NOT_EXIST", (Locale)ctx.getLocale());
            }
            storageInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageCol.get(0).getId()));
            EntityViewInfo supplyEv = new EntityViewInfo();
            FilterInfo supplyFilter = new FilterInfo();
            supplyFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomInfo.getSupplyOrgUnitnumber(), CompareType.EQUALS));
            supplyEv.setFilter(supplyFilter);
            StorageOrgUnitCollection supplyCol = isr.getStorageOrgUnitCollection(supplyEv);
            if (supplyCol == null || supplyCol.size() == 0) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"GHKCZZBCZ_NOT_EXIST", (Locale)ctx.getLocale());
            }
            supplyInfo = supplyCol.get(0);
            if (!(supplyInfo = isr.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(supplyInfo.getId()))).isIsBizUnit()) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KCZZBWSHTKCZZ_NOT_BIZUNIT", (Locale)ctx.getLocale(), (Object[])new Object[]{supplyInfo.getName()});
            }
            SupplierCollection getSupplyCol = null;
            SupplierCollection childCol = null;
            StorageOrgUnitCollection transferCol = null;
            ISupplier isp = SupplierFactory.getLocalInstance((Context)ctx);
            getSupplyInfo = null;
            EntityViewInfo dviewInfo = new EntityViewInfo();
            FilterInfo dfilterInfo = new FilterInfo();
            dfilterInfo.getFilterItems().add(new FilterItemInfo("assignCU.id", (Object)cu.getId().toString(), CompareType.EQUALS));
            dviewInfo.setFilter(dfilterInfo);
            ArrayList<String> idList = new ArrayList<String>();
            DataBaseDAssignCollection colls = DataBaseDAssignFactory.getLocalInstance((Context)ctx).getDataBaseDAssignCollection(dviewInfo);
            for (int i = 0; i < colls.size(); ++i) {
                String supplyID = colls.get(i).getDataBaseDID().toString();
                if (!isp.exists((IObjectPK)new ObjectUuidPK(supplyID)) || idList.contains(supplyID)) continue;
                idList.add(supplyID);
            }
            if (wsBomInfo.getGetSuppplierNumber() != null && !wsBomInfo.getGetSuppplierNumber().equals("")) {
                EntityViewInfo getSupplyEv = new EntityViewInfo();
                FilterInfo getSupplyFilter = new FilterInfo();
                getSupplyFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomInfo.getGetSuppplierNumber(), CompareType.EQUALS));
                getSupplyEv.setFilter(getSupplyFilter);
                getSupplyCol = isp.getSupplierCollection(getSupplyEv);
                if (getSupplyCol == null || getSupplyCol.size() == 0) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WBLYDWBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                }
                getSupplyInfo = getSupplyCol.get(0);
                if (!(getSupplyInfo = isp.getSupplierInfo((IObjectPK)new ObjectUuidPK(getSupplyInfo.getId()))).getCU().getId().equals((Object)cu.getId()) && !idList.contains(getSupplyInfo.getId().toString()) || !getSupplyInfo.getUsedStatus().equals((Object)com.kingdee.eas.basedata.master.cssp.UsedStatusEnum.APPROVED)) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WBLYDWZWHZBSY_NOT_APPROVE", (Locale)ctx.getLocale(), (Object[])new Object[]{getSupplyInfo.getName(), cu.getName()});
                }
            }
            childSupplyInfo = null;
            if (wsBomInfo.getChildsuppliernumber() != null && !wsBomInfo.getChildsuppliernumber().equals("")) {
                EntityViewInfo childEv = new EntityViewInfo();
                FilterInfo childFilter = new FilterInfo();
                childFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomInfo.getChildsuppliernumber(), CompareType.EQUALS));
                childEv.setFilter(childFilter);
                childCol = isp.getSupplierCollection(childEv);
                if (childCol == null || childCol.size() == 0) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WBGHDWBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                }
                childSupplyInfo = childCol.get(0);
                if (!(childSupplyInfo = isp.getSupplierInfo((IObjectPK)new ObjectUuidPK(childSupplyInfo.getId()))).getCU().getId().equals((Object)cu.getId()) && !idList.contains(childSupplyInfo.getId().toString()) || !childSupplyInfo.getUsedStatus().equals((Object)com.kingdee.eas.basedata.master.cssp.UsedStatusEnum.APPROVED)) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WBGHDWZWHZBSY_NOT_APPROVE", (Locale)ctx.getLocale(), (Object[])new Object[]{childSupplyInfo.getName(), cu.getName()});
                }
            }
            transferInfo = null;
            if (wsBomInfo.getTransferOrgUnitnumber() != null && !wsBomInfo.getTransferOrgUnitnumber().equals("")) {
                EntityViewInfo transferEv = new EntityViewInfo();
                FilterInfo transferFilter = new FilterInfo();
                transferFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomInfo.getTransferOrgUnitnumber(), CompareType.EQUALS));
                transferEv.setFilter(transferFilter);
                transferCol = isr.getStorageOrgUnitCollection(transferEv);
                if (transferCol == null || transferCol.size() == 0) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"DCKCZZBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                }
                transferInfo = transferCol.get(0);
                if (!(transferInfo = isr.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(transferInfo.getId()))).isIsBizUnit()) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KCZZBWSHTKCZZ_NOT_BIZUNIT", (Locale)ctx.getLocale(), (Object[])new Object[]{transferInfo.getName()});
                }
            }
            MainTenanceLevelCollection mainTenanceLevelCollection = null;
            mainTenanceLevelInfo = null;
            if (wsBomInfo.getMainTenanceLevelNumber() != null && !wsBomInfo.getMainTenanceLevelNumber().equals("")) {
                EntityViewInfo mainTenanceLevelViewInfo = new EntityViewInfo();
                FilterInfo mainTenanceLevelFilterInfo = new FilterInfo();
                mainTenanceLevelFilterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomInfo.getMainTenanceLevelNumber(), CompareType.EQUALS));
                mainTenanceLevelViewInfo.setFilter(mainTenanceLevelFilterInfo);
                mainTenanceLevelCollection = MainTenanceLevelFactory.getLocalInstance((Context)ctx).getMainTenanceLevelCollection(mainTenanceLevelViewInfo);
                if (mainTenanceLevelCollection == null || mainTenanceLevelCollection.size() == 0) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"MainTenanceLevelNumber_IsNotExists", (Locale)ctx.getLocale(), (Object[])new String[]{wsBomInfo.getMainTenanceLevelNumber()});
                }
                mainTenanceLevelInfo = mainTenanceLevelCollection.get(0);
            }
            issuePropEnum = IssuePropEnum.NULL;
            if (wsBomInfo.getIssueProp() != null && !wsBomInfo.getIssueProp().equals("")) {
                if (wsBomInfo.getIssueProp().equals("ECP")) {
                    issuePropEnum = IssuePropEnum.ECP;
                } else if (!wsBomInfo.getIssueProp().equals("MCP")) {
                    issuePropEnum = IssuePropEnum.MCP;
                }
            }
            isProjectManu = true;
            if (wsBomInfo.getIsProjectManu() != null && !wsBomInfo.getIsProjectManu().equals("")) {
                if (wsBomInfo.getIsProjectManu().equals("0")) {
                    isProjectManu = false;
                } else if (!wsBomInfo.getIsProjectManu().equals("1")) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SFXMZZGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                }
            } else {
                wsBomInfo.setIsProjectManu("1");
            }
            designMode = null;
            if (wsBomInfo.getDesignMode() != null && !wsBomInfo.getDesignMode().equals("")) {
                DesignModeCollection designModeCol = DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeCollection("select id where number='" + wsBomInfo.getDesignMode() + "'");
                if (designModeCol.size() <= 0) return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJMOSHBMEAS_NOT_EXIST", (Locale)ctx.getLocale());
                designMode = DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeInfo((IObjectPK)new ObjectUuidPK(designModeCol.get(0).getId()));
                if (!designMode.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SHJMSHWQY_NOT_ACTIVE", (Locale)ctx.getLocale(), (Object[])new Object[]{designMode.getName()});
                }
            }
            if (designMode.getNumber().equals("M02") || designMode.getNumber().equals("M04")) {
                isProjectManu = false;
            } else if (designMode.getNumber().equals("M03") || designMode.getNumber().equals("M01")) {
                isProjectManu = true;
            }
            EntityViewInfo maEv = new EntityViewInfo();
            FilterInfo maFilter = new FilterInfo();
            maFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomInfo.getMaterialnumber(), CompareType.EQUALS));
            maEv.setFilter(maFilter);
            MaterialCollection maCol = im.getMaterialCollection(maEv);
            if (maCol == null || maCol.size() == 0) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LJBMBCZ_NOT_EXIST", (Locale)ctx.getLocale());
            }
            materialInfo = maCol.get(0);
            if (!(materialInfo = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()))).getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WLWHZH_NOT_APPROVED", (Locale)ctx.getLocale(), (Object[])new Object[]{materialInfo.getNumber()});
            }
            EntityViewInfo parentMaEv = new EntityViewInfo();
            FilterInfo parentMaFilter = new FilterInfo();
            parentMaFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomInfo.getParentmaterialnumber(), CompareType.EQUALS));
            parentMaEv.setFilter(parentMaFilter);
            MaterialCollection parentMaCol = im.getMaterialCollection(parentMaEv);
            if (parentMaCol == null || parentMaCol.size() == 0) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SSLJBMBCZ_NOT_EXIST", (Locale)ctx.getLocale());
            }
            parentMaterial = parentMaCol.get(0);
            if (!(parentMaterial = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(parentMaterial.getId()))).getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WLWHZH_NOT_APPROVED", (Locale)ctx.getLocale(), (Object[])new Object[]{parentMaterial.getNumber()});
            }
            EntityViewInfo maPlanEnv = new EntityViewInfo();
            FilterInfo maPlanFilter = new FilterInfo();
            maPlanFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
            maPlanFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)supplyInfo.getId().toString(), CompareType.EQUALS));
            maPlanEnv.setFilter(maPlanFilter);
            maPlanCol = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(maPlanEnv);
            maPlan = null;
            if (maPlanCol != null && maPlanCol.size() > 0) {
                maPlan = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanInfo((IObjectPK)new ObjectUuidPK(maPlanCol.get(0).getId()));
            }
            EntityViewInfo paMaPlanEnv = new EntityViewInfo();
            FilterInfo paMaPlanFilter = new FilterInfo();
            paMaPlanFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)parentMaterial.getId().toString(), CompareType.EQUALS));
            paMaPlanFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageInfo.getId().toString(), CompareType.EQUALS));
            paMaPlanEnv.setFilter(paMaPlanFilter);
            MaterialPlanCollection paMaPlanCol = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(paMaPlanEnv);
            paMaPlan = null;
            if (paMaPlanCol != null && paMaPlanCol.size() > 0) {
                paMaPlan = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanInfo((IObjectPK)new ObjectUuidPK(paMaPlanCol.get(0).getId()));
                if (designMode.getNumber().equals("M03") && !paMaPlan.isIsConfigable()) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJMSWMFXWLBXKP_NOT_CONFIG", (Locale)ctx.getLocale());
                }
            }
            if (maPlanCol != null && maPlanCol.size() > 0 && paMaPlanCol != null && paMaPlanCol.size() > 0 && designMode.getNumber().equals("M02") && (maPlan.isIsConfigable() || paMaPlan.isIsConfigable())) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SJMSWMZFWLJBKP_NOT_CONFIG", (Locale)ctx.getLocale());
            }
            EntityViewInfo paMaStoEnv = new EntityViewInfo();
            FilterInfo paMaStoFilter = new FilterInfo();
            paMaStoFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)parentMaterial.getId().toString(), CompareType.EQUALS));
            paMaStoFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageInfo.getId().toString(), CompareType.EQUALS));
            paMaStoEnv.setFilter(paMaStoFilter);
            MaterialInventoryCollection paMaStoCol = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(paMaStoEnv);
            if (paMaStoCol == null || paMaStoCol.size() == 0) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WLZMYHZHZHTDKC_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{parentMaterial.getNumber(), storageInfo.getName()});
            }
            EntityViewInfo maStoEnv = new EntityViewInfo();
            FilterInfo maStoFilter = new FilterInfo();
            maStoFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString(), CompareType.EQUALS));
            maStoFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)supplyInfo.getId().toString(), CompareType.EQUALS));
            maStoEnv.setFilter(maStoFilter);
            MaterialInventoryCollection maStoCol = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(maStoEnv);
            if (maStoCol == null || maStoCol.size() == 0) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WLZMYHZHZHTDKC_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{materialInfo.getNumber(), supplyInfo.getName()});
            }
            EntityViewInfo uniEv = new EntityViewInfo();
            FilterInfo uniFilter = new FilterInfo();
            uniFilter.getFilterItems().add(new FilterItemInfo("name", (Object)wsBomInfo.getUnitname(), CompareType.EQUALS));
            uniEv.setFilter(uniFilter);
            MeasureUnitCollection meaCol = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(uniEv);
            if (meaCol == null || meaCol.size() == 0) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LJJLDWBCZ_NOT_EXIST", (Locale)ctx.getLocale());
            }
            unitInfo = meaCol.get(0);
            unitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitInfo.getId()));
            if (unitInfo.isIsDisabled()) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JLDWYJY_IS_DISABLED", (Locale)ctx.getLocale(), (Object[])new Object[]{unitInfo.getName()});
            }
            IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            MultiMeasureUnitInfo maMu = new MultiMeasureUnitInfo();
            maMu = immu.getMultiUnit(materialInfo.getId().toString(), unitInfo.getId().toString());
            if (maMu == null) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JLDWBSWLDYDDJLDW_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{unitInfo.getName(), materialInfo.getNumber()});
            }
            EntityViewInfo paUniEv = new EntityViewInfo();
            FilterInfo paUniFilter = new FilterInfo();
            paUniFilter.getFilterItems().add(new FilterItemInfo("name", (Object)wsBomInfo.getParentunitname(), CompareType.EQUALS));
            paUniEv.setFilter(paUniFilter);
            MeasureUnitCollection paUniCol = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(paUniEv);
            if (paUniCol == null || paUniCol.size() == 0) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SSLJJLDWBCZ_NOT_EXIST", (Locale)ctx.getLocale());
            }
            paUnitInfo = paUniCol.get(0);
            paUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(paUnitInfo.getId()));
            if (paUnitInfo.isIsDisabled()) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JLDWYJY_IS_DISABLED", (Locale)ctx.getLocale(), (Object[])new Object[]{paUnitInfo.getName()});
            }
            MultiMeasureUnitInfo parentMu = new MultiMeasureUnitInfo();
            parentMu = immu.getMultiUnit(parentMaterial.getId().toString(), paUnitInfo.getId().toString());
            if (parentMu == null) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JLDWBSWLDYDDJLDW_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{paUnitInfo.getName(), parentMaterial.getNumber()});
            }
            warehouse = null;
            if (wsBomInfo.getTransferWarehousenumber() != null && !wsBomInfo.getTransferWarehousenumber().equals("")) {
                EntityViewInfo wareEv = new EntityViewInfo();
                FilterInfo wareFilter = new FilterInfo();
                wareFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomInfo.getTransferWarehousenumber(), CompareType.EQUALS));
                wareEv.setFilter(wareFilter);
                WarehouseCollection wareCol = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(wareEv);
                if (wareCol == null || wareCol.size() == 0) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"DCCKBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                }
                warehouse = wareCol.get(0);
                warehouse = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectUuidPK(warehouse.getId()));
                if (!warehouse.getWhState().equals((Object)WHStateEnum.ACTIVE)) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"DCCKWQY_NOT_ACTIVE", (Locale)ctx.getLocale(), (Object[])new Object[]{warehouse.getNumber()});
                }
            }
            deWarehouse = null;
            if (wsBomInfo.getDefaultWarehousenumber() != null && !wsBomInfo.getDefaultWarehousenumber().equals("")) {
                EntityViewInfo deWareEv = new EntityViewInfo();
                FilterInfo deWareFilter = new FilterInfo();
                deWareFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomInfo.getDefaultWarehousenumber(), CompareType.EQUALS));
                deWareEv.setFilter(deWareFilter);
                WarehouseCollection deWareCol = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(deWareEv);
                if (deWareCol == null || deWareCol.size() == 0) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LLCKBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                }
                deWarehouse = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectUuidPK(deWareCol.get(0).getId()));
                if (!deWarehouse.getWhState().equals((Object)WHStateEnum.ACTIVE)) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LLCKWQY_NOT_ACTIVE", (Locale)ctx.getLocale(), (Object[])new Object[]{deWarehouse.getNumber()});
                }
            }
            BomType = designMode.getBomType();
            startTrack = null;
            endTrack = null;
            if (wsBomInfo.getBeginTrackNumber() != null && !wsBomInfo.getBeginTrackNumber().equals("")) {
                TrackNumberCollection startTrackNumberCol = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberCollection("select id where number='" + wsBomInfo.getBeginTrackNumber() + "'");
                if (startTrackNumberCol == null || startTrackNumberCol.size() <= 0) return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KSGZHZEASZBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                startTrack = startTrackNumberCol.get(0);
                startTrack = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(startTrack.getId()));
                if (startTrack.getStatus().equals((Object)MMBasedataStatusEnum.CLOSED)) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KSGZHZEASYGB_IS_CLOSE", (Locale)ctx.getLocale(), (Object[])new Object[]{startTrack.getNumber()});
                }
            } else if (designMode.isTrackNumber()) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KSGZINSTRATEGY_MUST", (Locale)ctx.getLocale());
            }
            if (wsBomInfo.getEndtrackNumber() != null && !wsBomInfo.getEndtrackNumber().equals("")) {
                TrackNumberCollection endTrackNumberCol = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberCollection("select id where number='" + wsBomInfo.getEndtrackNumber() + "'");
                if (endTrackNumberCol == null || endTrackNumberCol.size() <= 0) return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JSHGZHZEASXT_NOT_EXIST", (Locale)ctx.getLocale());
                endTrack = endTrackNumberCol.get(0);
                endTrack = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(endTrack.getId()));
                if (endTrack.getStatus().equals((Object)MMBasedataStatusEnum.CLOSED)) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JSHGZHZEASYGB_IS_CLOSE", (Locale)ctx.getLocale(), (Object[])new Object[]{endTrack.getNumber()});
                }
            } else if (designMode.isTrackNumber()) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"JSGZINSTRATEGY_MUST", (Locale)ctx.getLocale());
            }
            projectInfo = null;
            if (wsBomInfo.getProjectnumber() != null && !wsBomInfo.getProjectnumber().equals("")) {
                ProjectCarInfo entryInfo;
                int index;
                int collsSize;
                ProjectCarCollection ptColls;
                block244: {
                    ProjectCollection projectCol = ProjectFactory.getLocalInstance((Context)ctx).getProjectCollection("select id where number='" + wsBomInfo.getProjectnumber() + "'");
                    if (projectCol == null || projectCol.size() <= 0) return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XMHZEASZBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                    projectInfo = projectCol.get(0);
                    projectInfo = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(projectInfo.getId()));
                    if (!projectInfo.getBaseStatus().equals((Object)MMBaseStatusEnum.AUDIT)) {
                        return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XMHZEASZWHZ_NOT_APPROVED", (Locale)ctx.getLocale(), (Object[])new Object[]{projectInfo.getNumber()});
                    }
                    if (startTrack != null && !IndustryUtils.isEmptyObjectCollection((IObjectCollection)(ptColls = projectInfo.getCarNumberRange()))) {
                        collsSize = ptColls.size();
                        for (index = 0; index < collsSize; ++index) {
                            entryInfo = ptColls.get(index);
                            if (entryInfo == null || !(entryInfo = ProjectCarFactory.getLocalInstance((Context)ctx).getProjectCarInfo((IObjectPK)new ObjectUuidPK(entryInfo.getId()))).getTrackNumber().getId().equals((Object)startTrack.getId())) {
                                continue;
                            }
                            break block244;
                        }
                        return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XMHYKSBEGGZH_NOT_CORRECT", (Locale)ctx.getLocale());
                    }
                }
                if (endTrack != null && !IndustryUtils.isEmptyObjectCollection((IObjectCollection)(ptColls = projectInfo.getCarNumberRange()))) {
                    collsSize = ptColls.size();
                    for (index = 0; index < collsSize; ++index) {
                        entryInfo = ptColls.get(index);
                        if (entryInfo == null || !(entryInfo = ProjectCarFactory.getLocalInstance((Context)ctx).getProjectCarInfo((IObjectPK)new ObjectUuidPK(entryInfo.getId()))).getTrackNumber().getId().equals((Object)endTrack.getId())) {
                            continue;
                        }
                        break block245;
                    }
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XMHYJSENDGZH_NOT_CORRECT", (Locale)ctx.getLocale());
                }
            } else if (designMode.isProject()) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XMHINSTRATEGY_MUST", (Locale)ctx.getLocale());
            }
        }
        BOMUsageEnum BomUsage = BOMUsageEnum.NULL;
        if (wsBomInfo.getUsageType() != null && !wsBomInfo.equals("")) {
            if (wsBomInfo.getUsageType().equals("10")) {
                BomUsage = BOMUsageEnum.Master;
            } else if (wsBomInfo.getUsageType().equals("20")) {
                BomUsage = BOMUsageEnum.BackingOut;
            } else if (wsBomInfo.getUsageType().equals("30")) {
                BomUsage = BOMUsageEnum.maintaining;
            } else {
                if (!wsBomInfo.getUsageType().equals("40")) return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"BOMYTGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                BomUsage = BOMUsageEnum.Other;
            }
        } else {
            BomUsage = BOMUsageEnum.Master;
        }
        Boolean isStock = false;
        if (wsBomInfo.getIsStockTransfer() != null && !wsBomInfo.getIsStockTransfer().equals("")) {
            if (wsBomInfo.getIsStockTransfer().equals("1")) {
                isStock = true;
            } else if (!wsBomInfo.getIsStockTransfer().equals("0")) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"BLDBGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            }
        } else {
            wsBomInfo.setIsStockTransfer("0");
        }
        LocationInfo location = null;
        if (isStock.booleanValue()) {
            if (transferInfo == null) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"BLDBWYDCKCZCBNWK_NOT_NULL", (Locale)ctx.getLocale());
            }
            if (warehouse != null && transferInfo != null) {
                if (!warehouse.getStorageOrg().getId().equals((Object)transferInfo.getId())) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"DCCKBSDCKCZZHDYX_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{warehouse.getNumber(), transferInfo.getName()});
                }
                if (wsBomInfo.getLocation() != null && !wsBomInfo.getLocation().equals("") && warehouse.isHasLocation()) {
                    EntityViewInfo loEv = new EntityViewInfo();
                    FilterInfo loFilter = new FilterInfo();
                    loFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomInfo.getLocation(), CompareType.EQUALS));
                    loEv.setFilter(loFilter);
                    LocationCollection locaCol = LocationFactory.getLocalInstance((Context)ctx).getLocationCollection(loEv);
                    if (locaCol == null || locaCol.size() == 0) {
                        return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KWZEASBCZ_NOT_EXIST", (Locale)ctx.getLocale());
                    }
                    location = locaCol.get(0);
                    location = LocationFactory.getLocalInstance((Context)ctx).getLocationInfo((IObjectPK)new ObjectUuidPK(location.getId()));
                    if (!location.getWarehouse().getId().toString().equals(warehouse.getId().toString())) {
                        return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KWBSDCCKXDYDKW_NOT_EXIST", (Locale)ctx.getLocale(), (Object[])new Object[]{location.getNumber(), warehouse.getNumber()});
                    }
                    if (!location.getState().equals((Object)WHStateEnum.ACTIVE)) {
                        return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KWZEASXTZHWQY_NOT_ACTIVE", (Locale)ctx.getLocale(), (Object[])new Object[]{location.getNumber()});
                    }
                }
            }
        } else {
            transferInfo = null;
            warehouse = null;
            if (wsBomInfo.getTransferOrgUnitnumber() != null && !wsBomInfo.getTransferOrgUnitnumber().equals("")) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"BLDBWKHLDCKCBXWK_MUST_NULL", (Locale)ctx.getLocale());
            }
            if (wsBomInfo.getTransferWarehousenumber() != null && !wsBomInfo.getTransferWarehousenumber().equals("")) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"BLDBWKHLDCCKWK_MUST_NULL", (Locale)ctx.getLocale());
            }
        }
        Boolean isSelect = false;
        if (wsBomInfo.getCanSelected() != null && !wsBomInfo.getCanSelected().equals("")) {
            if (wsBomInfo.getCanSelected().equals("1")) {
                isSelect = true;
            } else if (!wsBomInfo.getCanSelected().equals("0")) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KXJIANGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            }
        } else {
            wsBomInfo.setCanSelected("0");
        }
        Boolean isFirst = false;
        if (wsBomInfo.getFirstCfg() != null && !wsBomInfo.getFirstCfg().equals("")) {
            if (wsBomInfo.getFirstCfg().equals("1")) {
                isFirst = true;
            } else if (!wsBomInfo.getFirstCfg().equals("0")) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"SXPZGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            }
        } else {
            wsBomInfo.setFirstCfg("0");
        }
        Boolean isFeture = false;
        if (wsBomInfo.getFeture() != null && !wsBomInfo.getFeture().equals("")) {
            if (wsBomInfo.getFeture().equals("1")) {
                isFeture = true;
            } else if (!wsBomInfo.getFeture().equals("0")) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"TZHJGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            }
        } else {
            wsBomInfo.setFeture("0");
        }
        if (!paMaPlan.isIsConfigable()) {
            isSelect = false;
            isFirst = false;
            isFeture = false;
        }
        Integer leadTime = new Integer(0);
        if (wsBomInfo.getLeadtime() != null && !wsBomInfo.getLeadtime().equals("")) {
            if (!WSBomWebServiceFacadeControllerBean.isInteteger(wsBomInfo.getLeadtime())) return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"PZSJGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            leadTime = Integer.parseInt(wsBomInfo.getLeadtime());
        } else {
            wsBomInfo.setLeadtime("0");
        }
        ConsumeTypeEnum consumeType = ConsumeTypeEnum.VariableAmount;
        if (wsBomInfo.getConsumeType() != null && !wsBomInfo.getConsumeType().equals("")) {
            if (wsBomInfo.getConsumeType().equals("30")) {
                consumeType = ConsumeTypeEnum.Proportion;
            } else if (!wsBomInfo.getConsumeType().equals("20")) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XHLXGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            }
        } else {
            wsBomInfo.setConsumeType("20");
        }
        BigDecimal scrapRatio = BigDecimal.ZERO;
        if (wsBomInfo.getScrapRatio() != null && !wsBomInfo.getScrapRatio().equals("")) {
            if (!WSBomWebServiceFacadeControllerBean.isPosNumber(wsBomInfo.getScrapRatio())) return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"FPLGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            scrapRatio = new BigDecimal(wsBomInfo.getScrapRatio());
        } else {
            wsBomInfo.setScrapRatio("0");
        }
        BigDecimal proportion = new BigDecimal("100");
        if (wsBomInfo.getProportion() != null && !wsBomInfo.getProportion().equals("")) {
            if (!WSBomWebServiceFacadeControllerBean.isPosNumber(wsBomInfo.getProportion())) return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"XHBLGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            proportion = new BigDecimal(wsBomInfo.getProportion());
        } else {
            wsBomInfo.setProportion("100");
        }
        MaterialAttributeEnum materialProp = MaterialAttributeEnum.OTHER;
        if (wsBomInfo.getMaterialProp().equals("10010")) {
            materialProp = MaterialAttributeEnum.SCHEDULEPART;
        } else if (wsBomInfo.getMaterialProp().equals("10020")) {
            materialProp = MaterialAttributeEnum.PHANTOMPART;
        } else if (wsBomInfo.getMaterialProp().equals("10030")) {
            materialProp = MaterialAttributeEnum.FABRICATEDPART;
        } else if (wsBomInfo.getMaterialProp().equals("10040")) {
            materialProp = MaterialAttributeEnum.PURCHASEDPART;
        } else if (wsBomInfo.getMaterialProp().equals("10050")) {
            materialProp = MaterialAttributeEnum.EXTERNALPROCESSINPART;
        } else {
            if (!wsBomInfo.getMaterialProp().equals("10060")) return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"WLSHXEASXT_NOT_EXIST", (Locale)ctx.getLocale());
            materialProp = MaterialAttributeEnum.OTHER;
        }
        MaterialIssueModeEnum materialIssue = MaterialIssueModeEnum.PRODUCEISSMODE;
        if (wsBomInfo.getIssMode() != null && !wsBomInfo.getIssMode().equals("")) {
            if (wsBomInfo.getIssMode().equals("11010")) {
                materialIssue = MaterialIssueModeEnum.PRODUCEISSMODE;
            } else if (wsBomInfo.getIssMode().equals("11030")) {
                materialIssue = MaterialIssueModeEnum.KANBANISSMODE;
            } else if (wsBomInfo.getIssMode().equals("11050")) {
                materialIssue = MaterialIssueModeEnum.STRAIGHT;
            } else {
                if (!wsBomInfo.getIssMode().equals("11040")) return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"LSLMSZEASXT_NOT_EXIST", (Locale)ctx.getLocale());
                materialIssue = MaterialIssueModeEnum.NOTISSMODE;
            }
        }
        MaterialProvideTypeEnum provideType = MaterialProvideTypeEnum.NONE;
        provideType = BomConvertBaseProcess.getMaterialProvideTypeEnum(ctx, storageInfo.getId().toString(), supplyInfo.getId().toString(), materialInfo.getId().toString());
        if (provideType.equals((Object)MaterialProvideTypeEnum.CURRENTORGPROVIDE) || provideType.equals((Object)MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE)) {
            if (deWarehouse != null && !deWarehouse.getStorageOrg().getId().equals((Object)storageInfo.getId())) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"GYLXLLCKBSDQKCZZXCK_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{deWarehouse.getNumber(), storageInfo.getName()});
            }
        } else if ((provideType.equals((Object)MaterialProvideTypeEnum.SPANORGPROVIDE) || provideType.equals((Object)MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE)) && deWarehouse != null && !deWarehouse.getStorageOrg().getId().equals((Object)supplyInfo.getId())) {
            return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"GYLXLLCKBSDQGHZZXCK_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{deWarehouse.getNumber(), supplyInfo.getName()});
        }
        Boolean isHaveEntry = false;
        BomEntryCollection bomEntryCol = ibe.getBomEntryCollection("select id where sourceBillEntryId ='" + wsBomInfo.getSourceBillId() + "'");
        if (bomEntryCol != null && bomEntryCol.size() > 0) {
            bomEntryInfo = bomEntryCol.get(0);
            bomEntryInfo = ibe.getBomEntryInfo((IObjectPK)new ObjectUuidPK(bomEntryInfo.getId()));
            bomInfo = bomEntryInfo.getParent();
            if ((bomInfo = ib.getBomInfo((IObjectPK)new ObjectUuidPK(bomInfo.getId()))).getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                if (!bomInfo.getMaterial().getId().equals((Object)parentMaterial.getId()) || !bomInfo.getStorageOrgUnit().getId().equals((Object)storageInfo.getId()) || !bomInfo.getDesignMode().equals((Object)designMode)) return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"DYDBZEASHQBTBYZ_NOT_CORRECT", (Locale)ctx.getLocale());
                boolean projectEqual = false;
                if (designMode.isProject()) {
                    if (projectInfo != null) {
                        projectEqual = bomInfo.getProject().equals((Object)projectInfo);
                    }
                } else if (!designMode.isProject() && designMode.isTrackNumber()) {
                    if (startTrack != null) {
                        projectEqual = startTrack.equals((Object)bomEntryInfo.getBeginCarno());
                    }
                    if (endTrack != null) {
                        projectEqual = endTrack.equals((Object)bomEntryInfo.getEndCarno());
                    }
                }
                if (!projectEqual) return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"DYDBZEASHQBTBYZ_NOT_CORRECT", (Locale)ctx.getLocale());
                BomChangeInfo bomChangeInfo = BomChangeBillAuditFacadeFactory.getLocalInstance(ctx).addBomChangeInfoByBom(null, bomInfo);
                bomChangeInfo.setUnit(paUnitInfo);
                bomChangeInfo.setStorageOrgUnit(storageInfo);
                bomChangeInfo.setChangePerson(userInfo.getPerson());
                bomChangeInfo.setDesignMode(designMode);
                bomChangeInfo.setProject(projectInfo);
                bomChangeInfo.setProductQty(new BigDecimal(wsBomInfo.getProductQty()));
                bomChangeInfo.setUnit(unitInfo);
                bomChangeInfo.setMainTenanceLevel(mainTenanceLevelInfo);
                BomChangeNewEntryInfo newChangeEntry = new BomChangeNewEntryInfo();
                materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
                newChangeEntry.setMaterial(materialInfo);
                if (maPlanCol != null && maPlanCol.size() > 0) {
                    newChangeEntry.setOutputType(maPlan.getOutputType());
                } else {
                    newChangeEntry.setOutputType(MaterialProductEnum.OTHER);
                }
                newChangeEntry.setUnit(unitInfo);
                newChangeEntry.setConsumeFixQty(new BigDecimal(wsBomInfo.getConsumeFixQty()));
                newChangeEntry.setConsumeType(consumeType);
                newChangeEntry.setProportion(proportion);
                newChangeEntry.setScrapRatio(scrapRatio);
                newChangeEntry.setLeadtime(leadTime);
                newChangeEntry.setIssueProp(issuePropEnum);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    if (wsBomInfo.getEffectiveDate() != null && !wsBomInfo.getEffectiveDate().equals("")) {
                        newChangeEntry.setEffectiveDate(sdf.parse(wsBomInfo.getEffectiveDate()));
                    } else {
                        newChangeEntry.setEffectiveDate(sdf.parse(MMUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd")));
                    }
                    if (wsBomInfo.getDisableDate() != null && !wsBomInfo.getDisableDate().equals("")) {
                        newChangeEntry.setDisableDate(sdf.parse(wsBomInfo.getDisableDate()));
                    } else {
                        newChangeEntry.setDisableDate(sdf.parse("2099-12-31"));
                    }
                }
                catch (ParseException e) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"RQGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                }
                newChangeEntry.setIssMode(materialIssue);
                newChangeEntry.setSupplyOrgUnit(supplyInfo);
                newChangeEntry.setTransferOrgUnit(transferInfo);
                newChangeEntry.setProvideType(provideType);
                if (wsBomInfo.getNetWeight() != null && !wsBomInfo.getNetWeight().equals("")) {
                    newChangeEntry.setNetWeight(new BigDecimal(wsBomInfo.getNetWeight()));
                }
                newChangeEntry.setBlkSize(wsBomInfo.getBlkSize());
                newChangeEntry.setSpecifiedLength(wsBomInfo.getSpecifiedLength());
                newChangeEntry.setMaterialProp(materialProp);
                if (newChangeEntry.getProvideType() == MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) {
                    newChangeEntry.setTransferOrgUnit(newChangeEntry.getSupplyOrgUnit());
                }
                newChangeEntry.setTransferWarehouse(warehouse);
                newChangeEntry.setLocation(location);
                newChangeEntry.setDefaultWarehouse(deWarehouse);
                newChangeEntry.setBomFlow(wsBomInfo.getBomFlow());
                newChangeEntry.setGtmeno(wsBomInfo.getGtmeno());
                newChangeEntry.setBeginCarno(startTrack);
                newChangeEntry.setEndCarno(endTrack);
                newChangeEntry.setFixSeq(Integer.parseInt(wsBomInfo.getFixSeq()));
                newChangeEntry.setCanSelected(isSelect);
                newChangeEntry.setFirstCfg(isFirst);
                newChangeEntry.setFeture(isFeture);
                newChangeEntry.setIsStockTransfer(isStock);
                newChangeEntry.setRemark(wsBomInfo.getDesignRemark());
                newChangeEntry.setSourcebillEntryID(wsBomInfo.getSourceBillId());
                bomChangeInfo.getNewEntry().add(newChangeEntry);
                BomChangeFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)bomChangeInfo);
                return wsBomInfo.getSourceBillId() + ",1," + bomInfo.getId().toString();
            }
            if (bomInfo.getMaterial().getId().equals((Object)parentMaterial.getId()) && bomInfo.getStorageOrgUnit().getId().equals((Object)storageInfo.getId()) && bomInfo.getDesignMode().equals((Object)designMode) && (bomInfo.getMainTenanceLevel() == null && mainTenanceLevelInfo == null || bomInfo.getMainTenanceLevel() != null && mainTenanceLevelInfo != null && mainTenanceLevelInfo.getId().toString().equals(bomInfo.getMainTenanceLevel().getId().toString()))) {
                boolean projectEqual = false;
                if (designMode.isProject()) {
                    if (projectInfo != null) {
                        projectEqual = bomInfo.getProject().equals((Object)projectInfo);
                    }
                } else if (!designMode.isProject() && designMode.isTrackNumber()) {
                    if (startTrack != null) {
                        projectEqual = startTrack.equals((Object)bomEntryInfo.getBeginCarno());
                    }
                    if (endTrack != null) {
                        projectEqual = endTrack.equals((Object)bomEntryInfo.getEndCarno());
                    }
                } else {
                    projectEqual = projectInfo != null && bomInfo.getProject() != null ? bomInfo.getProject().equals((Object)projectInfo) : true;
                }
                if (projectEqual) {
                    bomInfo.setUnit(paUnitInfo);
                    bomInfo.setBaseUnit(paUnitInfo);
                    bomInfo.setName(parentMaterial.getName());
                    bomInfo.setBomType(BomType);
                    bomInfo.setDesignMode(designMode);
                    bomInfo.setUsageType(BomUsage);
                    bomInfo.setMaterial(parentMaterial);
                    bomInfo.setModel(parentMaterial.getModel());
                    if (wsBomInfo.getBomname() != null && !wsBomInfo.getBomname().equals("")) {
                        bomInfo.setName(wsBomInfo.getBomname());
                    } else {
                        bomInfo.setName(parentMaterial.getName());
                    }
                    bomInfo.setProject(projectInfo);
                    bomInfo.setStorageOrgUnit(storageInfo);
                    bomInfo.setGetSupplier(getSupplyInfo);
                    UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                    bomInfo.setLastUpdateUser(user);
                    bomInfo.setModifier(user);
                    bomInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                    bomInfo.setModificationTime(new Timestamp(System.currentTimeMillis()));
                    bomInfo.setProductBaseQty(new BigDecimal(wsBomInfo.getProductQty()));
                    bomInfo.setProductQty(new BigDecimal(wsBomInfo.getProductQty()));
                    bomInfo.setIsProjectManu(isProjectManu.booleanValue());
                    bomInfo.setBizDate((Date)new Timestamp(new Date().getTime()));
                    bomInfo.setPictureNumber(wsBomInfo.getPictureNumber());
                    bomInfo.put("getSupplier", (Object)getSupplyInfo);
                    bomInfo.setMainTenanceLevel(mainTenanceLevelInfo);
                    String result = this.checkBomData(ctx, bomInfo, wsBomInfo, designMode, cu);
                    if (!result.equals("true")) {
                        return result;
                    }
                    pk = bomEntryInfo.getId();
                    materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
                    bomEntryInfo.setMaterial(materialInfo);
                    if (maPlanCol != null && maPlanCol.size() > 0) {
                        bomEntryInfo.setOutputType(maPlan.getOutputType());
                    } else {
                        bomEntryInfo.setOutputType(MaterialProductEnum.OTHER);
                    }
                    bomEntryInfo.setUnit(unitInfo);
                    bomEntryInfo.setBaseUnit(unitInfo);
                    bomEntryInfo.setConsumeFixBaseQty(new BigDecimal(wsBomInfo.getConsumeFixQty()));
                    bomEntryInfo.setConsumeFixQty(new BigDecimal(wsBomInfo.getConsumeFixQty()));
                    bomEntryInfo.setConsumeType(consumeType);
                    bomEntryInfo.setProportion(proportion);
                    bomEntryInfo.setScrapRatio(scrapRatio);
                    bomEntryInfo.setLeadtime(leadTime.intValue());
                    bomEntryInfo.setIssueProp(issuePropEnum);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        if (wsBomInfo.getEffectiveDate() != null && !wsBomInfo.getEffectiveDate().equals("")) {
                            bomEntryInfo.setEffectiveDate(sdf.parse(wsBomInfo.getEffectiveDate()));
                        } else {
                            bomEntryInfo.setEffectiveDate(sdf.parse(MMUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd")));
                        }
                        if (wsBomInfo.getDisableDate() != null && !wsBomInfo.getDisableDate().equals("")) {
                            bomEntryInfo.setDisableDate(sdf.parse(wsBomInfo.getDisableDate()));
                        } else {
                            bomEntryInfo.setDisableDate(sdf.parse("2099-12-31"));
                        }
                    }
                    catch (ParseException e) {
                        return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"RQGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
                    }
                    bomEntryInfo.setIssMode(materialIssue);
                    bomEntryInfo.setSupplyOrgUnit(supplyInfo);
                    bomEntryInfo.setTransferOrgUnit(transferInfo);
                    bomEntryInfo.setProvideType(provideType);
                    bomEntryInfo.setSupplier(childSupplyInfo);
                    if (wsBomInfo.getNetWeight() != null && !wsBomInfo.getNetWeight().equals("")) {
                        bomEntryInfo.setNetWeight(new BigDecimal(wsBomInfo.getNetWeight()));
                    }
                    bomEntryInfo.setBlkSize(wsBomInfo.getBlkSize());
                    bomEntryInfo.setSpecifiedLength(wsBomInfo.getSpecifiedLength());
                    bomEntryInfo.setMaterialProp(materialProp);
                    if (bomEntryInfo.getProvideType() == MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) {
                        bomEntryInfo.setTransferOrgUnit(bomEntryInfo.getSupplyOrgUnit());
                    }
                    bomEntryInfo.setTransferWarehouse(warehouse);
                    bomEntryInfo.setLocation(location);
                    bomEntryInfo.setDefaultWarehouse(deWarehouse);
                    bomEntryInfo.setBomFlow(wsBomInfo.getBomFlow());
                    bomEntryInfo.setGtmeno(wsBomInfo.getGtmeno());
                    bomEntryInfo.setBeginCarno(startTrack);
                    bomEntryInfo.setEndCarno(endTrack);
                    bomEntryInfo.setFixSeq(Integer.parseInt(wsBomInfo.getFixSeq()));
                    bomEntryInfo.setCanSelected(isSelect.booleanValue());
                    bomEntryInfo.setFirstCfg(isFirst.booleanValue());
                    bomEntryInfo.setFeture(isFeture.booleanValue());
                    bomEntryInfo.setIsStockTransfer(isStock.booleanValue());
                    bomEntryInfo.setBlueprint(wsBomInfo.getBlueprint());
                    bomEntryInfo.setDesignRemark(wsBomInfo.getDesignRemark());
                    bomEntryInfo.setSourceBillEntryId(wsBomInfo.getSourceBillId());
                    result = this.checkBomEntryData(ctx, bomEntryInfo, wsBomInfo, designMode);
                    if (!result.equals("true")) {
                        return result;
                    }
                    result = this.checkBomDesignModeData(ctx, bomInfo, wsBomInfo, cu);
                    if (!result.equals("true")) {
                        return result;
                    }
                    ibe.update((IObjectPK)new ObjectUuidPK(pk), (CoreBaseInfo)bomEntryInfo);
                    ib.update((IObjectPK)new ObjectUuidPK(bomInfo.getId()), (CoreBaseInfo)bomInfo);
                    return wsBomInfo.getSourceBillId() + ",1," + pk.toString();
                }
            }
            isHaveEntry = true;
        }
        String projectid = "";
        String trackId = "";
        if (projectInfo != null) {
            projectid = projectInfo.getId().toString();
        }
        if (startTrack != null) {
            trackId = startTrack.getId().toString();
        }
        if ((bomInfo = BomUtil.getBomInfo(ctx, parentMaterial.getId().toString(), storageInfo.getId().toString(), projectid, designMode, trackId, mainTenanceLevelInfo == null ? null : mainTenanceLevelInfo.getId().toString())) == null) {
            IRowSet ros;
            bomInfo = new BomInfo();
            ctx.get((Object)"UserInfo");
            BOSUuid bomid = BOSUuid.create((BOSObjectType)bomInfo.getBOSType());
            bomInfo.setId(bomid);
            bomInfo.setUnit(paUnitInfo);
            bomInfo.setBaseUnit(paUnitInfo);
            bomInfo.setName(parentMaterial.getName());
            bomInfo.setBomType(BomType);
            bomInfo.setDesignMode(designMode);
            bomInfo.setCU(cu);
            bomInfo.setUsageType(BomUsage);
            bomInfo.setMaterial(parentMaterial);
            bomInfo.setModel(parentMaterial.getModel());
            if (wsBomInfo.getBomname() != null && !wsBomInfo.getBomname().equals("")) {
                bomInfo.setName(wsBomInfo.getBomname());
            } else {
                bomInfo.setName(parentMaterial.getName());
            }
            bomInfo.setProject(projectInfo);
            bomInfo.setStorageOrgUnit(storageInfo);
            bomInfo.setGetSupplier(getSupplyInfo);
            bomInfo.setCreator(userInfo);
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            bomInfo.setLastUpdateUser(user);
            bomInfo.setModifier(user);
            bomInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            bomInfo.setModificationTime(new Timestamp(System.currentTimeMillis()));
            bomInfo.setYield(new BigDecimal(100.0));
            bomInfo.setBizDate(new Date());
            bomInfo.setMainTenanceLevel(mainTenanceLevelInfo);
            if (BomType.equals((Object)BOMTypeEnum.OrderBOM) && projectInfo != null) {
                String trackSql = "Select TN.FID trackid From T_MM_TrackNumber TN Left Join T_MM_ProjectCar PTN On PTN.FTrackNumberID=TN.FID  Where PTN.FProjectID='" + projectInfo.getId().toString() + "' and TN.FNUMBER>='" + startTrack.getNumber() + "' AND TN.FNUMBER<='" + endTrack.getNumber() + "'";
                ros = DbUtil.executeQuery((Context)ctx, (String)trackSql);
                try {
                    while (ros.next()) {
                        String trackid = ros.getString("trackid") == null ? "" : ros.getString("trackid");
                        if (trackid.equals("")) continue;
                        String insertSql = "insert into t_mm_orderbompt(FID,FTrackID,FOrderID,FProjectID)  VALUES(newbosid('F8019C2D'),'" + trackid + "','" + bomid.toString() + "','" + projectInfo.getId().toString() + "') ";
                        DbUtil.execute((Context)ctx, (String)insertSql);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return wsBomInfo.getSourceBillId() + ",-1," + e.getMessage();
                }
            }
            String querySqls = "select 1 from T_MM_BOMGROUPSTANDARD where  FSTORAGEORGUNITID = '" + storageInfo.getId().toString() + "' ";
            ros = DbUtil.executeQuery((Context)ctx, (String)querySqls);
            try {
                if (!ros.next()) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0216", (Locale)ctx.getLocale()) + storageInfo.getName() + "," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0219", (Locale)ctx.getLocale());
                }
                querySqls = "select 1 from T_MM_BOMGROUPSTANDARD where  FNUMBER = '999' AND FSTORAGEORGUNITID = '" + storageInfo.getId().toString() + "' ";
                ros = DbUtil.executeQuery((Context)ctx, (String)querySqls);
                if (ros.next()) {
                    bomInfo.setBomGroup(BomGroupstandardFactory.getLocalInstance((Context)ctx).getBomGroupstandardInfo("where number='999' and storageOrgUnit = '" + storageInfo.getId().toString() + "'"));
                } else {
                    bomInfo.setBomGroup(BomGroupstandardFactory.getLocalInstance((Context)ctx).getBomGroupstandardCollection("where storageOrgUnit = '" + storageInfo.getId().toString() + "' ").get(0));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            bomInfo.setProductBaseQty(new BigDecimal(wsBomInfo.getProductQty()));
            bomInfo.setProductQty(new BigDecimal(wsBomInfo.getProductQty()));
            bomInfo.setIsProjectManu(isProjectManu.booleanValue());
            bomInfo.setBizDate((Date)new Timestamp(new Date().getTime()));
            bomInfo.setPictureNumber(wsBomInfo.getPictureNumber());
            bomInfo.put("getSupplier", (Object)getSupplyInfo);
            BOSUuid oldEntryId = null;
            if (isHaveEntry.booleanValue()) {
                oldEntryId = bomEntryInfo.getId();
            }
            bomEntryInfo = new BomEntryInfo();
            materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
            bomEntryInfo.setMaterial(materialInfo);
            if (maPlanCol != null && maPlanCol.size() > 0) {
                bomEntryInfo.setOutputType(maPlan.getOutputType());
            } else {
                bomEntryInfo.setOutputType(MaterialProductEnum.OTHER);
            }
            bomEntryInfo.setUnit(unitInfo);
            bomEntryInfo.setBaseUnit(unitInfo);
            bomEntryInfo.setConsumeFixBaseQty(new BigDecimal(wsBomInfo.getConsumeFixQty()));
            bomEntryInfo.setConsumeFixQty(new BigDecimal(wsBomInfo.getConsumeFixQty()));
            bomEntryInfo.setConsumeType(consumeType);
            bomEntryInfo.setProportion(proportion);
            bomEntryInfo.setScrapRatio(scrapRatio);
            bomEntryInfo.setLeadtime(leadTime.intValue());
            bomEntryInfo.setIssueProp(issuePropEnum);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                if (wsBomInfo.getEffectiveDate() != null && !wsBomInfo.getEffectiveDate().equals("")) {
                    bomEntryInfo.setEffectiveDate(sdf.parse(wsBomInfo.getEffectiveDate()));
                } else {
                    bomEntryInfo.setEffectiveDate(sdf.parse(MMUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd")));
                }
                if (wsBomInfo.getDisableDate() != null && !wsBomInfo.getDisableDate().equals("")) {
                    bomEntryInfo.setDisableDate(sdf.parse(wsBomInfo.getDisableDate()));
                } else {
                    bomEntryInfo.setDisableDate(sdf.parse("2099-12-31"));
                }
            }
            catch (ParseException e) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"RQGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            }
            bomEntryInfo.setIssMode(materialIssue);
            bomEntryInfo.setSupplyOrgUnit(supplyInfo);
            bomEntryInfo.setTransferOrgUnit(transferInfo);
            bomEntryInfo.setProvideType(provideType);
            bomEntryInfo.setSupplier(childSupplyInfo);
            if (wsBomInfo.getNetWeight() != null && !wsBomInfo.getNetWeight().equals("")) {
                bomEntryInfo.setNetWeight(new BigDecimal(wsBomInfo.getNetWeight()));
            }
            bomEntryInfo.setBlkSize(wsBomInfo.getBlkSize());
            bomEntryInfo.setSpecifiedLength(wsBomInfo.getSpecifiedLength());
            bomEntryInfo.setMaterialProp(materialProp);
            if (bomEntryInfo.getProvideType() == MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) {
                bomEntryInfo.setTransferOrgUnit(bomEntryInfo.getSupplyOrgUnit());
            }
            bomEntryInfo.setTransferWarehouse(warehouse);
            bomEntryInfo.setLocation(location);
            bomEntryInfo.setDefaultWarehouse(deWarehouse);
            bomEntryInfo.setBomFlow(wsBomInfo.getBomFlow());
            bomEntryInfo.setGtmeno(wsBomInfo.getGtmeno());
            bomEntryInfo.setBeginCarno(startTrack);
            bomEntryInfo.setEndCarno(endTrack);
            bomEntryInfo.setFixSeq(Integer.parseInt(wsBomInfo.getFixSeq()));
            bomEntryInfo.setCanSelected(isSelect.booleanValue());
            bomEntryInfo.setFirstCfg(isFirst.booleanValue());
            bomEntryInfo.setFeture(isFeture.booleanValue());
            bomEntryInfo.setIsStockTransfer(isStock.booleanValue());
            bomEntryInfo.setBlueprint(wsBomInfo.getBlueprint());
            bomEntryInfo.setDesignRemark(wsBomInfo.getDesignRemark());
            bomEntryInfo.setSourceBillEntryId(wsBomInfo.getSourceBillId());
            String result = this.checkBomData(ctx, bomInfo, wsBomInfo, designMode, cu);
            if (!result.equals("true")) {
                return result;
            }
            result = this.checkBomEntryData(ctx, bomEntryInfo, wsBomInfo, designMode);
            if (!result.equals("true")) {
                return result;
            }
            bomInfo.getEntrys().add(bomEntryInfo);
            if (wsBomInfo.getBomnumber() != null && !wsBomInfo.getBomnumber().equals("")) {
                FilterInfo bomNumFilter = new FilterInfo();
                bomNumFilter.getFilterItems().add(new FilterItemInfo("number", (Object)wsBomInfo.getBomnumber(), CompareType.EQUALS));
                if (BomFactory.getLocalInstance((Context)ctx).exists(bomNumFilter)) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"BOMNUMBER_IS_EXIST", (Locale)ctx.getLocale(), (Object[])new Object[]{wsBomInfo.getBomnumber()});
                }
                bomInfo.setNumber(wsBomInfo.getBomnumber().trim());
                ib.save((CoreBaseInfo)bomInfo);
                if (isHaveEntry.booleanValue()) {
                    ibe.delete((IObjectPK)new ObjectUuidPK(oldEntryId));
                }
                pk = bomEntryInfo.getId();
                return wsBomInfo.getSourceBillId() + ",1," + pk.toString();
            } else {
                if (!CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)bomInfo, bomInfo.getStorageOrgUnit().getId().toString())) return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"KCZZHWDYQYZZB_NOT", (Locale)ctx.getLocale(), (Object[])new Object[]{bomInfo.getStorageOrgUnit().getName().toString()});
                String billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)bomInfo, bomInfo.getStorageOrgUnit().getId().toString());
                bomInfo.setNumber(this.setBillNumber(ctx, (IObjectValue)bomInfo, bomInfo.getStorageOrgUnit().getId().toString()));
                ib.save((CoreBaseInfo)bomInfo);
                if (isHaveEntry.booleanValue()) {
                    ibe.delete((IObjectPK)new ObjectUuidPK(oldEntryId));
                }
                pk = bomEntryInfo.getId();
            }
            return wsBomInfo.getSourceBillId() + ",1," + pk.toString();
        }
        if (bomInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            BomChangeInfo bomChangeInfo = BomChangeBillAuditFacadeFactory.getLocalInstance(ctx).addBomChangeInfoByBom(null, bomInfo);
            bomChangeInfo.setUnit(paUnitInfo);
            bomChangeInfo.setStorageOrgUnit(storageInfo);
            bomChangeInfo.setChangePerson(userInfo.getPerson());
            bomChangeInfo.setDesignMode(designMode);
            bomChangeInfo.setProject(projectInfo);
            bomChangeInfo.setProductQty(new BigDecimal(wsBomInfo.getProductQty()));
            bomChangeInfo.setUnit(unitInfo);
            bomChangeInfo.setMainTenanceLevel(mainTenanceLevelInfo);
            BomChangeNewEntryInfo newChangeEntry = new BomChangeNewEntryInfo();
            materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
            newChangeEntry.setMaterial(materialInfo);
            if (maPlanCol != null && maPlanCol.size() > 0) {
                newChangeEntry.setOutputType(maPlan.getOutputType());
            } else {
                newChangeEntry.setOutputType(MaterialProductEnum.OTHER);
            }
            newChangeEntry.setUnit(unitInfo);
            newChangeEntry.setConsumeFixQty(new BigDecimal(wsBomInfo.getConsumeFixQty()));
            newChangeEntry.setConsumeType(consumeType);
            newChangeEntry.setProportion(proportion);
            newChangeEntry.setScrapRatio(scrapRatio);
            newChangeEntry.setLeadtime(leadTime);
            newChangeEntry.setIssueProp(issuePropEnum);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                if (wsBomInfo.getEffectiveDate() != null && !wsBomInfo.getEffectiveDate().equals("")) {
                    newChangeEntry.setEffectiveDate(sdf.parse(wsBomInfo.getEffectiveDate()));
                } else {
                    newChangeEntry.setEffectiveDate(sdf.parse(MMUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd")));
                }
                if (wsBomInfo.getDisableDate() != null && !wsBomInfo.getDisableDate().equals("")) {
                    newChangeEntry.setDisableDate(sdf.parse(wsBomInfo.getDisableDate()));
                } else {
                    newChangeEntry.setDisableDate(sdf.parse("2099-12-31"));
                }
            }
            catch (ParseException e) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"RQGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
            }
            newChangeEntry.setIssMode(materialIssue);
            newChangeEntry.setSupplyOrgUnit(supplyInfo);
            newChangeEntry.setTransferOrgUnit(transferInfo);
            newChangeEntry.setProvideType(provideType);
            if (wsBomInfo.getNetWeight() != null && !wsBomInfo.getNetWeight().equals("")) {
                newChangeEntry.setNetWeight(new BigDecimal(wsBomInfo.getNetWeight()));
            }
            newChangeEntry.setBlkSize(wsBomInfo.getBlkSize());
            newChangeEntry.setSpecifiedLength(wsBomInfo.getSpecifiedLength());
            newChangeEntry.setMaterialProp(materialProp);
            if (newChangeEntry.getProvideType() == MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) {
                newChangeEntry.setTransferOrgUnit(newChangeEntry.getSupplyOrgUnit());
            }
            newChangeEntry.setTransferWarehouse(warehouse);
            newChangeEntry.setLocation(location);
            newChangeEntry.setDefaultWarehouse(deWarehouse);
            newChangeEntry.setBomFlow(wsBomInfo.getBomFlow());
            newChangeEntry.setGtmeno(wsBomInfo.getGtmeno());
            newChangeEntry.setBeginCarno(startTrack);
            newChangeEntry.setEndCarno(endTrack);
            newChangeEntry.setFixSeq(Integer.parseInt(wsBomInfo.getFixSeq()));
            newChangeEntry.setCanSelected(isSelect);
            newChangeEntry.setFirstCfg(isFirst);
            newChangeEntry.setFeture(isFeture);
            newChangeEntry.setIsStockTransfer(isStock);
            newChangeEntry.setRemark(wsBomInfo.getDesignRemark());
            newChangeEntry.setSourcebillEntryID(wsBomInfo.getSourceBillId());
            bomChangeInfo.getNewEntry().add(newChangeEntry);
            BomChangeFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)bomChangeInfo);
            if (!isHaveEntry.booleanValue()) return wsBomInfo.getSourceBillId() + ",1," + bomInfo.getId().toString();
            BOSUuid oldEntryId = bomEntryInfo.getId();
            ibe.delete((IObjectPK)new ObjectUuidPK(oldEntryId));
            return wsBomInfo.getSourceBillId() + ",1," + bomInfo.getId().toString();
        }
        BigDecimal productQty = new BigDecimal(wsBomInfo.getProductQty());
        if (!productQty.equals(bomInfo.getProductQty())) {
            return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"TYFXKCSMXMGZFXBYZ_NOT_SAME", (Locale)ctx.getLocale());
        }
        bomInfo.setUnit(paUnitInfo);
        bomInfo.setBaseUnit(paUnitInfo);
        bomInfo.setName(parentMaterial.getName());
        bomInfo.setBomType(BomType);
        bomInfo.setUsageType(BomUsage);
        bomInfo.setMaterial(parentMaterial);
        bomInfo.setModel(parentMaterial.getModel());
        if (wsBomInfo.getBomname() != null && !wsBomInfo.getBomname().equals("")) {
            bomInfo.setName(wsBomInfo.getBomname());
        } else {
            bomInfo.setName(parentMaterial.getName());
        }
        bomInfo.setProject(projectInfo);
        bomInfo.setStorageOrgUnit(storageInfo);
        bomInfo.setGetSupplier(getSupplyInfo);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        bomInfo.setLastUpdateUser(user);
        bomInfo.setModifier(user);
        bomInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        bomInfo.setModificationTime(new Timestamp(System.currentTimeMillis()));
        bomInfo.setProductBaseQty(productQty);
        bomInfo.setProductQty(productQty);
        bomInfo.setMainTenanceLevel(mainTenanceLevelInfo);
        bomInfo.setIsProjectManu(isProjectManu.booleanValue());
        bomInfo.setBizDate((Date)new Timestamp(new Date().getTime()));
        bomInfo.setPictureNumber(wsBomInfo.getPictureNumber());
        bomInfo.put("getSupplier", (Object)getSupplyInfo);
        String result = this.checkBomData(ctx, bomInfo, wsBomInfo, designMode, cu);
        if (!result.equals("true")) {
            return result;
        }
        BOSUuid oldEntryId = null;
        if (isHaveEntry.booleanValue()) {
            oldEntryId = bomEntryInfo.getId();
        }
        bomEntryInfo = new BomEntryInfo();
        bomEntryInfo.setId(BOSUuid.create((BOSObjectType)bomEntryInfo.getBOSType()));
        materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
        bomEntryInfo.setMaterial(materialInfo);
        if (maPlanCol != null && maPlanCol.size() > 0) {
            bomEntryInfo.setOutputType(maPlan.getOutputType());
        } else {
            bomEntryInfo.setOutputType(MaterialProductEnum.OTHER);
        }
        bomEntryInfo.setUnit(unitInfo);
        bomEntryInfo.setBaseUnit(unitInfo);
        bomEntryInfo.setConsumeFixBaseQty(new BigDecimal(wsBomInfo.getConsumeFixQty()));
        bomEntryInfo.setConsumeFixQty(new BigDecimal(wsBomInfo.getConsumeFixQty()));
        bomEntryInfo.setConsumeType(consumeType);
        bomEntryInfo.setProportion(proportion);
        bomEntryInfo.setScrapRatio(scrapRatio);
        bomEntryInfo.setLeadtime(leadTime.intValue());
        bomEntryInfo.setIssueProp(issuePropEnum);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (wsBomInfo.getEffectiveDate() != null && !wsBomInfo.getEffectiveDate().equals("")) {
                bomEntryInfo.setEffectiveDate(sdf.parse(wsBomInfo.getEffectiveDate()));
            } else {
                bomEntryInfo.setEffectiveDate(sdf.parse(MMUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd")));
            }
            if (wsBomInfo.getDisableDate() != null && !wsBomInfo.getDisableDate().equals("")) {
                bomEntryInfo.setDisableDate(sdf.parse(wsBomInfo.getDisableDate()));
            } else {
                bomEntryInfo.setDisableDate(sdf.parse("2099-12-31"));
            }
        }
        catch (ParseException e) {
            return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"RQGSBZQ_NOT_CORRECT", (Locale)ctx.getLocale());
        }
        bomEntryInfo.setIssMode(materialIssue);
        bomEntryInfo.setSupplyOrgUnit(supplyInfo);
        bomEntryInfo.setTransferOrgUnit(transferInfo);
        bomEntryInfo.setProvideType(provideType);
        bomEntryInfo.setSupplier(childSupplyInfo);
        if (wsBomInfo.getNetWeight() != null && !wsBomInfo.getNetWeight().equals("")) {
            bomEntryInfo.setNetWeight(new BigDecimal(wsBomInfo.getNetWeight()));
        }
        bomEntryInfo.setBlkSize(wsBomInfo.getBlkSize());
        bomEntryInfo.setSpecifiedLength(wsBomInfo.getSpecifiedLength());
        bomEntryInfo.setMaterialProp(materialProp);
        if (bomEntryInfo.getProvideType() == MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) {
            bomEntryInfo.setTransferOrgUnit(bomEntryInfo.getSupplyOrgUnit());
        }
        bomEntryInfo.setTransferWarehouse(warehouse);
        bomEntryInfo.setLocation(location);
        bomEntryInfo.setDefaultWarehouse(deWarehouse);
        bomEntryInfo.setBomFlow(wsBomInfo.getBomFlow());
        bomEntryInfo.setGtmeno(wsBomInfo.getGtmeno());
        bomEntryInfo.setBeginCarno(startTrack);
        bomEntryInfo.setEndCarno(endTrack);
        bomEntryInfo.setFixSeq(Integer.parseInt(wsBomInfo.getFixSeq()));
        bomEntryInfo.setCanSelected(isSelect.booleanValue());
        bomEntryInfo.setFirstCfg(isFirst.booleanValue());
        bomEntryInfo.setFeture(isFeture.booleanValue());
        bomEntryInfo.setIsStockTransfer(isStock.booleanValue());
        bomEntryInfo.setBlueprint(wsBomInfo.getBlueprint());
        bomEntryInfo.setDesignRemark(wsBomInfo.getDesignRemark());
        bomEntryInfo.setSourceBillEntryId(wsBomInfo.getSourceBillId());
        result = this.checkBomEntryData(ctx, bomEntryInfo, wsBomInfo, designMode);
        if (!result.equals("true")) {
            return result;
        }
        result = this.checkBomDesignModeData(ctx, bomInfo, wsBomInfo, cu);
        if (!result.equals("true")) {
            return result;
        }
        bomInfo.getEntrys().add(bomEntryInfo);
        ib.update((IObjectPK)new ObjectUuidPK(bomInfo.getId()), (CoreBaseInfo)bomInfo);
        if (isHaveEntry.booleanValue()) {
            ibe.delete((IObjectPK)new ObjectUuidPK(oldEntryId));
        }
        pk = bomEntryInfo.getId();
        return wsBomInfo.getSourceBillId() + ",1," + pk.toString();
    }

    public String checkBomData(Context ctx, BomInfo bomInfo, WSBOMInfo wsBomInfo, DesignModeInfo designMode, CtrlUnitInfo ctrlUnitInfo) throws EASBizException, BOSException {
        if (bomInfo.getUsageType().equals((Object)BOMUsageEnum.Master) && this.checkHaveOtherBom(ctx, bomInfo.getStorageOrgUnit(), bomInfo.getMaterial(), bomInfo.getProject(), bomInfo)) {
            return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"ParentMaterialOrgUnitHaveOtherBom", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, bomInfo.getMaterial()), this.getStorageOrgUnitName(ctx, bomInfo.getStorageOrgUnit())});
        }
        List<String> mulOrgUnitNameList = this.getBomMaterialMulOrgUnitList(ctx, bomInfo.getMaterial().getId().toString(), ctrlUnitInfo, bomInfo.getProject() == null ? null : bomInfo.getProject().getId().toString(), true);
        String forgunitName = this.getStorageOrgUnitName(ctx, bomInfo.getStorageOrgUnit());
        if (mulOrgUnitNameList != null && mulOrgUnitNameList.size() > 0 && !mulOrgUnitNameList.contains(forgunitName)) {
            mulOrgUnitNameList.add(forgunitName);
        }
        if (mulOrgUnitNameList != null && mulOrgUnitNameList.size() > 1) {
            return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"MaterialMulOrgCheckError", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, bomInfo.getMaterial()), mulOrgUnitNameList.toString()});
        }
        MaterialPlanInfo mpInfo = this.getMaterialPlanInfo(ctx, bomInfo.getMaterial().getId().toString(), bomInfo.getStorageOrgUnit().getId().toString());
        if (mpInfo == null) {
            return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"MaterialPlan_IsNUll", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, bomInfo.getMaterial()), this.getStorageOrgUnitName(ctx, bomInfo.getStorageOrgUnit())});
        }
        if (mpInfo.getManufactureStrategy() == null) {
            return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"MaterialManufactureStrategyIsNUll", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, bomInfo.getMaterial()), this.getStorageOrgUnitName(ctx, bomInfo.getStorageOrgUnit())});
        }
        boolean isfind = false;
        for (int i = 0; i < designMode.getEntry().size(); ++i) {
            DesignModeEntryInfo dsEntryInfo = designMode.getEntry().get(i);
            if (dsEntryInfo.getManufactureStrategy() == null || !dsEntryInfo.getManufactureStrategy().getId().toString().equals(mpInfo.getManufactureStrategy().getId().toString())) continue;
            if (mpInfo.getIsolatedRule() != null && !mpInfo.getIsolatedRule().equals((Object)IsolatedRuleEnum.NONE)) {
                if (dsEntryInfo.getIsolatedRule() == null || dsEntryInfo.getIsolatedRule().equals((Object)IsolatedRuleEnum.NONE) || !dsEntryInfo.getIsolatedRule().equals((Object)mpInfo.getIsolatedRule())) continue;
                isfind = true;
                break;
            }
            if (dsEntryInfo.getIsolatedRule() != null && !dsEntryInfo.getIsolatedRule().equals((Object)IsolatedRuleEnum.NONE)) continue;
            isfind = true;
            break;
        }
        if (!isfind) {
            return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"ParentMaterialManufactureStrategyIsolatedNoValid", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, bomInfo.getMaterial()), this.getStorageOrgUnitName(ctx, bomInfo.getStorageOrgUnit())});
        }
        return "true";
    }

    public String checkBomEntryData(Context ctx, BomEntryInfo entryInfo, WSBOMInfo wsBomInfo, DesignModeInfo ds) throws EASBizException, BOSException {
        List childDesignModeIDList = MfgBomUtil.getChildDesignModeIDByParentDesignMode((Context)ctx, (DesignModeInfo)ds);
        if (ds.isTrackNumber() && entryInfo.getBeginCarno() == null) {
            return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"BomEntryBeginTrackNumberIsNull", (Locale)ctx.getLocale(), (Object[])new String[]{this.getMaterialNumber(ctx, entryInfo.getMaterial())});
        }
        if (ds.isTrackNumber() && entryInfo.getEndCarno() == null) {
            return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"BomEntryEndTrackNumberIsNull", (Locale)ctx.getLocale(), (Object[])new String[]{this.getMaterialNumber(ctx, entryInfo.getMaterial())});
        }
        if (entryInfo.getMaterial() != null && entryInfo.getSupplyOrgUnit() != null) {
            MaterialPlanInfo mpInfo = this.getMaterialPlanInfo(ctx, entryInfo.getMaterial().getId().toString(), entryInfo.getSupplyOrgUnit().getId().toString());
            if (mpInfo == null) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"MaterialPlan_IsNUll", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, entryInfo.getMaterial()), this.getStorageOrgUnitName(ctx, entryInfo.getSupplyOrgUnit())});
            }
            MaterialInventoryInfo miInfo = this.getMaterialInventoryInfo(ctx, entryInfo.getMaterial().getId().toString(), entryInfo.getSupplyOrgUnit().getId().toString());
            if (mpInfo == null) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"MaterialInventory_IsNUll", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, entryInfo.getMaterial()), this.getStorageOrgUnitName(ctx, entryInfo.getSupplyOrgUnit())});
            }
            DesignModeInfo childDesignModeInfo = MfgBomUtil.getDesignModeByManufactureStrategy((Context)ctx, (String)(mpInfo.getManufactureStrategy() == null ? null : mpInfo.getManufactureStrategy().getId().toString()), mpInfo.getIsolatedRule() == null ? null : mpInfo.getIsolatedRule().getValue());
            if (!(childDesignModeInfo == null || childDesignModeIDList != null && childDesignModeIDList.contains(childDesignModeInfo.getId().toString()))) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"ChildMaterialMsNoValide", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, entryInfo.getMaterial()), this.getStorageOrgUnitName(ctx, entryInfo.getSupplyOrgUnit()), ds.getName()});
            }
        }
        return "true";
    }

    public String checkBomDesignModeData(Context ctx, BomInfo bomInfo, WSBOMInfo wsBomInfo, CtrlUnitInfo ctrlUnitInfo) throws BOSException, EASBizException {
        String forgunitName;
        Object errorString = null;
        if (bomInfo.getDesignMode() == null) {
            if (bomInfo.getMaterial() != null && bomInfo.getStorageOrgUnit() != null && this.checkHaveOtherBom(ctx, bomInfo.getStorageOrgUnit(), bomInfo.getMaterial(), bomInfo.getProject(), bomInfo)) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"ParentMaterialOrgUnitHaveOtherBom", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, bomInfo.getMaterial()), this.getStorageOrgUnitName(ctx, bomInfo.getStorageOrgUnit())});
            }
            return "true";
        }
        DesignModeInfo ds = DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeInfo((IObjectPK)new ObjectUuidPK(bomInfo.getDesignMode().getId()), MfgBomUtil.getDesignModeSelectSic());
        if (!ds.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
            return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"DesignMode_NoEnabled", (Locale)ctx.getLocale(), (Object[])new String[]{ds.getName()});
        }
        if (ds.isProject() && bomInfo.getProject() == null) {
            return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"BomProjectIsNull", (Locale)ctx.getLocale());
        }
        boolean isfind = false;
        if (bomInfo.getMaterial() != null && bomInfo.getStorageOrgUnit() != null) {
            forgunitName = this.getStorageOrgUnitName(ctx, bomInfo.getStorageOrgUnit());
            if (this.checkHaveOtherBom(ctx, bomInfo.getStorageOrgUnit(), bomInfo.getMaterial(), bomInfo.getProject(), bomInfo)) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"ParentMaterialOrgUnitHaveOtherBom", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, bomInfo.getMaterial()), forgunitName});
            }
            List<String> mulOrgUnitNameList = this.getBomMaterialMulOrgUnitList(ctx, bomInfo.getMaterial().getId().toString(), ctrlUnitInfo, bomInfo.getProject() == null ? null : bomInfo.getProject().getId().toString(), true);
            if (mulOrgUnitNameList != null && mulOrgUnitNameList.size() > 0 && !mulOrgUnitNameList.contains(forgunitName)) {
                mulOrgUnitNameList.add(forgunitName);
            }
            if (mulOrgUnitNameList != null && mulOrgUnitNameList.size() > 1) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"MaterialMulOrgCheckError", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, bomInfo.getMaterial()), mulOrgUnitNameList.toString()});
            }
            MaterialPlanInfo mpInfo = this.getMaterialPlanInfo(ctx, bomInfo.getMaterial().getId().toString(), bomInfo.getStorageOrgUnit().getId().toString());
            if (mpInfo == null) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"MaterialPlanIsNull", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, bomInfo.getMaterial()), this.getStorageOrgUnitName(ctx, bomInfo.getStorageOrgUnit())});
            }
            if (mpInfo.getManufactureStrategy() == null) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"MaterialManufactureStrategyIsNUll", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, bomInfo.getMaterial()), this.getStorageOrgUnitName(ctx, bomInfo.getStorageOrgUnit())});
            }
            MaterialInventoryInfo miInfo = this.getMaterialInventoryInfo(ctx, bomInfo.getMaterial().getId().toString(), bomInfo.getStorageOrgUnit().getId().toString());
            if (miInfo == null) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"MaterialInventroyIsNull", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, bomInfo.getMaterial()), this.getStorageOrgUnitName(ctx, bomInfo.getStorageOrgUnit())});
            }
            isfind = false;
            for (int i = 0; i < ds.getEntry().size(); ++i) {
                DesignModeEntryInfo dsEntryInfo = ds.getEntry().get(i);
                if (dsEntryInfo.getManufactureStrategy() == null || !dsEntryInfo.getManufactureStrategy().getId().toString().equals(mpInfo.getManufactureStrategy().getId().toString())) continue;
                if (mpInfo.getIsolatedRule() != null && !mpInfo.getIsolatedRule().equals((Object)IsolatedRuleEnum.NONE)) {
                    if (dsEntryInfo.getIsolatedRule() == null || dsEntryInfo.getIsolatedRule().equals((Object)IsolatedRuleEnum.NONE) || !dsEntryInfo.getIsolatedRule().equals((Object)mpInfo.getIsolatedRule())) continue;
                    isfind = true;
                    break;
                }
                if (dsEntryInfo.getIsolatedRule() != null && !dsEntryInfo.getIsolatedRule().equals((Object)IsolatedRuleEnum.NONE)) continue;
                isfind = true;
                break;
            }
            if (!isfind) {
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"ParentMaterialManufactureStrategyIsolatedNoValid", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, bomInfo.getMaterial()), this.getStorageOrgUnitName(ctx, bomInfo.getStorageOrgUnit())});
            }
        }
        List childDesignModeIDList = MfgBomUtil.getChildDesignModeIDByParentDesignMode((Context)ctx, (DesignModeInfo)ds);
        if (bomInfo.getEntrys() != null && bomInfo.getEntrys().size() > 0) {
            for (int i = 0; i < bomInfo.getEntrys().size(); ++i) {
                BomEntryInfo entryInfo = bomInfo.getEntrys().get(i);
                if (ds.isTrackNumber() && entryInfo.getBeginCarno() == null) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"BomEntryBeginTrackNumberIsNull", (Locale)ctx.getLocale(), (Object[])new String[]{this.getMaterialNumber(ctx, entryInfo.getMaterial())});
                }
                if (ds.isTrackNumber() && entryInfo.getEndCarno() == null) {
                    return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"BomEntryEndTrackNumberIsNull", (Locale)ctx.getLocale(), (Object[])new String[]{this.getMaterialNumber(ctx, entryInfo.getMaterial())});
                }
                if (entryInfo.getMaterial() != null && entryInfo.getSupplyOrgUnit() != null) {
                    forgunitName = this.getStorageOrgUnitName(ctx, entryInfo.getSupplyOrgUnit());
                    MaterialPlanInfo mpInfo = this.getMaterialPlanInfo(ctx, entryInfo.getMaterial().getId().toString(), entryInfo.getSupplyOrgUnit().getId().toString());
                    if (mpInfo == null) {
                        return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"MaterialPlanIsNull", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, entryInfo.getMaterial()), forgunitName});
                    }
                    MaterialInventoryInfo miInfo = this.getMaterialInventoryInfo(ctx, entryInfo.getMaterial().getId().toString(), entryInfo.getSupplyOrgUnit().getId().toString());
                    if (miInfo == null) {
                        return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"MaterialInventroyIsNull", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, entryInfo.getMaterial()), forgunitName});
                    }
                    List<String> mulOrgUnitNameList = this.getBomMaterialMulOrgUnitList(ctx, entryInfo.getMaterial().getId().toString(), ctrlUnitInfo, bomInfo.getProject() == null ? null : bomInfo.getProject().getId().toString(), false);
                    if (mulOrgUnitNameList != null && mulOrgUnitNameList.size() > 0 && !mulOrgUnitNameList.contains(forgunitName)) {
                        mulOrgUnitNameList.add(forgunitName);
                    }
                    if (mulOrgUnitNameList != null && mulOrgUnitNameList.size() > 1) {
                        return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"MaterialMulOrgCheckError", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, entryInfo.getMaterial()), mulOrgUnitNameList.toString()});
                    }
                    DesignModeInfo childDesignModeInfo = MfgBomUtil.getDesignModeByManufactureStrategy((Context)ctx, (String)(mpInfo.getManufactureStrategy() == null ? null : mpInfo.getManufactureStrategy().getId().toString()), mpInfo.getIsolatedRule() == null ? null : mpInfo.getIsolatedRule().getValue());
                    if (!(childDesignModeInfo == null || childDesignModeIDList != null && childDesignModeIDList.contains(childDesignModeInfo.getId().toString()))) {
                        return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"ChildMaterialPlanMsNoValide", (Locale)ctx.getLocale(), (Object[])new Object[]{this.getMaterialNumber(ctx, entryInfo.getMaterial()), this.getStorageOrgUnitName(ctx, entryInfo.getSupplyOrgUnit()), ds.getName()});
                    }
                }
                if (entryInfo.getBeginCarno() == null || entryInfo.getEndCarno() == null || this.checktrackNumberIsOneProject(ctx, entryInfo.getBeginCarno().getId().toString(), entryInfo.getEndCarno().getId().toString())) continue;
                return wsBomInfo.getSourceBillId() + ",-1," + ResourceBase.getString((String)BOM_RESOURCE_PATH, (String)"MfgBomEdit_015", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1 + "", this.getMaterialNumber(ctx, entryInfo.getMaterial())});
            }
        }
        return "true";
    }

    protected boolean checktrackNumberIsOneProject(Context ctx, String ftrackid1, String ftrackid2) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct pc.ftracknumberid,pc.fprojectid ");
        sql.append(" from t_mm_projectcar pc ");
        sql.append(" where pc.ftracknumberid in('" + ftrackid1 + "','" + ftrackid2 + "') ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String projectid1 = null;
        String projectid2 = null;
        try {
            while (rs.next()) {
                if (rs.getString("ftracknumberid").equals(ftrackid1)) {
                    projectid1 = rs.getString("fprojectid");
                }
                if (!rs.getString("ftracknumberid").equals(ftrackid2)) continue;
                projectid2 = rs.getString("fprojectid");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        if (projectid1 == null || projectid2 == null) {
            return true;
        }
        if (projectid1 == null && projectid2 != null || projectid1 != null && projectid2 == null) {
            return false;
        }
        return projectid1.equals(projectid2);
    }

    private MaterialPlanInfo getMaterialPlanInfo(Context ctx, String materialid, String orgunitID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("manufactureStrategy.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgunitID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(sic);
        MaterialPlanCollection mpc = MaterialPlanFactory.getLocalInstance((Context)ctx).getMaterialPlanCollection(viewInfo);
        if (mpc != null && mpc.size() > 0) {
            return mpc.get(0);
        }
        return null;
    }

    private MaterialInventoryInfo getMaterialInventoryInfo(Context ctx, String materialid, String orgunitID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgunitID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(sic);
        MaterialInventoryCollection mic = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(viewInfo);
        if (mic != null && mic.size() > 0) {
            return mic.get(0);
        }
        return null;
    }

    private String getMaterialNumber(Context ctx, MaterialInfo materialInfo) throws BOSException, EASBizException {
        if (materialInfo != null) {
            if (materialInfo.getNumber() == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()), sic);
            }
            return materialInfo.getNumber();
        }
        return "";
    }

    private String getStorageOrgUnitName(Context ctx, StorageOrgUnitInfo storageOrgUnitInfo) throws BOSException, EASBizException {
        if (storageOrgUnitInfo != null) {
            if (storageOrgUnitInfo.getName() == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                storageOrgUnitInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storageOrgUnitInfo.getId()), sic);
            }
            return storageOrgUnitInfo.getName();
        }
        return "";
    }

    protected boolean checkHaveOtherBom(Context ctx, StorageOrgUnitInfo storageOrgUnitInfo, MaterialInfo materialInfo, ProjectInfo projectInfo, BomInfo bomInfo) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("select b.fid");
        sql.append(" from t_mm_bom b  ");
        sql.append(" where b.fstorageorgunitid = ? ");
        sql.append(" and b.fmaterialid = ? ");
        sql.append(" and b.fbasestatus in(0,1,2,4) ");
        if (bomInfo.getDesignMode() == null) {
            sql.append(" and b.fdesignModeID is not null ");
        } else {
            if (projectInfo != null) {
                sql.append(" and (b.fprojectid = '" + projectInfo.getId().toString() + "' or b.fprojectid  is null or b.fdesignModeID is null) ");
            }
            sql.append(" and (b.fdesignModeID is not null or ( b.fbomtype <>  ").append(50);
            sql.append(" and b.fdesignModeID is null )) ");
        }
        sql.append(" and b.fid <> ? ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{storageOrgUnitInfo.getId().toString(), materialInfo.getId().toString(), bomInfo.getId() == null ? "*" : bomInfo.getId().toString()});
        try {
            if (rows.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public static boolean isPosNumber(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^\\d+(\\.\\d+)?$");
        return pattern.matcher(string).matches();
    }

    public static boolean isDate(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$");
        return pattern.matcher(string).matches();
    }

    public static boolean isInteteger(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[1-9]\\d*|0$");
        return pattern.matcher(string).matches();
    }

    public static boolean hasPermission(Context ctx, String permItemName, ObjectUuidPK orgIdPK, String userId) throws EASBizException, BOSException {
        ObjectUuidPK userPK = new ObjectUuidPK(userId);
        return PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgIdPK, permItemName);
    }

    protected String setBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID) throws EASBizException, BOSException {
        String billNumber = null;
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule(billInfo, bizOrgUnitID);
        if (ruleInfo != null) {
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(billInfo, ruleInfo);
        }
        if (billNumber != null) {
            ((BomInfo)billInfo).setNumber(billNumber);
        } else if (billInfo.getString("id") != null) {
            billInfo.setString("number", "AutoNumberFromBTP_" + billInfo.getString("id").toString());
        } else {
            billInfo.setString("number", "AutoNumberFromBTP_" + BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
        }
        String sqlbillNumber = "select 1 from T_MM_BOM where fnumber = '" + billNumber + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlbillNumber);
        try {
            if (rs.next()) {
                billNumber = this.setBillNumber(ctx, billInfo, bizOrgUnitID);
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
        }
        return billNumber;
    }

    protected List<String> getBomMaterialMulOrgUnitList(Context ctx, String materialID, CtrlUnitInfo ctrlUnitInfo, String projectID, boolean isParent) throws BOSException, EASBizException {
        ArrayList<String> orgUnitNameList = new ArrayList<String>();
        String paramNumber = "EMMBomOrg";
        if (isParent) {
            paramNumber = "EMMBomOrg_Parent";
        }
        if (!BomConvertBaseProcess.getSysParamBooleanValue(ctx, ctrlUnitInfo.getId().toString(), paramNumber, false)) {
            StringBuilder sql = new StringBuilder();
            sql.append(" select distinct s.fname_").append(ctx.getLocale()).append(" as forgunitname ");
            sql.append(" from t_mm_bom b  ");
            sql.append(" inner join t_mm_bomentry d on d.fparentid = b.fid  ");
            sql.append(" inner join t_org_storage s on s.fid = b.fstorageorgunitid  ");
            sql.append(" where b.fmaterialid = ? ");
            sql.append(" and b.fdesignModeid is not null ");
            if (projectID == null || "".equals(projectID)) {
                sql.append(" and b.fprojectid is not null ");
            } else {
                sql.append(" and b.fprojectid = '" + projectID + "' ");
            }
            sql.append(" union ");
            sql.append(" select distinct s1.fname_").append(ctx.getLocale()).append(" as forgunitname ");
            sql.append(" from t_mm_bom h  ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid  ");
            sql.append(" inner join t_org_storage s1 on s1.fid = d.fsupplystorageorgunitid  ");
            sql.append(" where d.fmaterialid = ? ");
            if (projectID == null || "".equals(projectID)) {
                sql.append(" and h.fprojectid is not null ");
            } else {
                sql.append(" and h.fprojectid = '" + projectID + "' ");
            }
            sql.append(" and h.fdesignModeid is not null ");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{materialID, materialID});
            try {
                while (rows.next()) {
                    orgUnitNameList.add(rows.getString("forgunitname"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        return orgUnitNameList;
    }
}

