/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.excel.json.JSONUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.BomCollection;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.PBOMEntryCollection;
import com.kingdee.eas.mm.basedata.PBOMEntryFactory;
import com.kingdee.eas.mm.basedata.PBOMEntryInfo;
import com.kingdee.eas.mm.basedata.PBOMFactory;
import com.kingdee.eas.mm.basedata.PBOMInfo;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.app.AbstractBOMCopyFacadeControllerBean;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import edu.emory.mathcs.backport.java.util.Collections;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BOMCopyFacadeControllerBean
extends AbstractBOMCopyFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.basedata.app.BOMCopyFacadeControllerBean");
    private String RESURL = "com.kingdee.eas.mm.basedata.EMMEMBasedataResource";
    Map<String, BigDecimal> allCheckQtyMap = new HashMap<String, BigDecimal>();

    @Override
    protected List _bomCopyRefresh(Context ctx, String param) throws BOSException, EASBizException {
        ArrayList dateList = new ArrayList();
        StringBuffer sql = new StringBuffer();
        HashMap map = JSONUtils.convertJsonToObject((String)param);
        String sourceProjectID = (String)map.get("sourceProjectID");
        String sourceTrackNumberID = (String)map.get("sourceTrackNumberID");
        String targetProjectID = (String)map.get("targetProjectID");
        String targetTrackNumberBeginID = (String)map.get("targetTrackNumberBeginID");
        String targetTrackNumberEndID = (String)map.get("targetTrackNumberEndID");
        sql.delete(0, sql.length());
        sql.append(" select distinct");
        sql.append("  a.fnumber BOMNumber");
        sql.append(" ,material.fnumber MaterialNumber");
        sql.append(" ,material.fname_L2 MaterialName");
        sql.append(" ,storage.fname_l2 StorageName");
        sql.append(" ,project.fnumber ProjectName");
        sql.append(" ,SourceTrack.fnumber TrackNumber");
        sql.append(" ,isnull(standardRooting.fnumber ,'\u65e0') StandardRootingNumber");
        sql.append(" ,(case isnull(pbom.fid,'null') when  'null' then '0' else   pbom.fid end ) isExistPBom");
        sql.append(" ,targetBom.fnumber targetBOMNumber");
        sql.append(" ,targetProject.fnumber targetProjectName");
        sql.append(" ,(select  min(bt.fnumber) from T_MM_TRACKNUMBER bt where bt.fid in(select be.FBeginCarnoID from T_MM_BOMENTRY be where be.FPARENTID = targetBom.fid )) beginTrackNumber");
        sql.append(" ,(select  max(et.fnumber) from T_MM_TRACKNUMBER et where et.fid in(select ee.FEndCarnoID from T_MM_BOMENTRY ee where ee.FPARENTID = targetBom.fid )) EndTrackNumber");
        sql.append(" ,isnull(targetRooting.fnumber ,'\u65e0') targetRootingNumber");
        sql.append(" ,(case isnull(targetPbom.fid,'null') when  'null' then '0' else   '1' end ) isExisttargetPbom");
        sql.append(" from T_MM_BOM A");
        sql.append(" left outer join T_MM_BOMENTRY B on A.FID = B.FPARENTID");
        sql.append(" left outer join T_BD_MATERIAL material on material.fid = A.fmaterialid");
        sql.append(" left outer join T_ORG_STORAGE storage on storage.fid = A.fstorageorgunitid");
        sql.append(" left outer join T_MM_Project project on project.fid = A.fprojectid");
        sql.append(" left outer join T_MM_StandardRooting standardRooting on standardRooting.FStorageOrgUnitID = A.FStorageOrgUnitID  and standardRooting.FMaterialID = A.FMaterialID  and standardRooting.FStatus =60");
        sql.append(" left outer join T_MM_PBOM pbom on pbom.FBomID = A.fid  and pbom.FRoutingID = standardRooting.fid");
        sql.append(" left outer join T_MM_TRACKNUMBER BeginTrack on BeginTrack.fid = B.FBeginCarnoID ");
        sql.append(" left outer join T_MM_TRACKNUMBER EndTrack on EndTrack.fid = B.FEndCarnoID");
        sql.append(" left outer join T_MM_TRACKNUMBER SourceTrack on SourceTrack.fid ='" + sourceTrackNumberID + "'");
        sql.append(" left outer join T_MM_BOM targetBom on A.fmaterialid=targetBom.fmaterialid  and A.fstorageorgunitid = targetBom.fstorageorgunitid  and targetBom.FPROJECTID = '" + targetProjectID + "'  and targetBom.Fbasestatus = " + 4 + " and targetBom.FBomType=A.FBomType");
        sql.append(" left outer join T_MM_StandardRooting targetRooting on targetRooting.FStorageOrgUnitID = targetBom.FStorageOrgUnitID  and targetRooting.FMaterialID = targetBom.FMaterialID  and targetRooting.FStatus =60");
        sql.append(" left outer join T_MM_PBOM targetPbom on targetPbom.FBomID = targetBom.fid  and targetPbom.FRoutingID = targetRooting.fid");
        sql.append(" left outer join T_MM_Project targetProject on targetProject.fid = targetBom.fprojectid");
        sql.append(" where 1=1 ");
        sql.append(" and A.FPROJECTID = '" + sourceProjectID + "'");
        sql.append(" and BeginTrack.FNumber <= SourceTrack.FNumber");
        sql.append(" and EndTrack.FNumber >= SourceTrack.FNumber");
        sql.append(" and A.Fbasestatus=4");
        sql.append(" and A.FBomType = 80");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                HashMap<String, String> dateMap = new HashMap<String, String>();
                dateMap.put("BOMNumber", rs.getString("BOMNumber"));
                dateMap.put("MaterialNumber", rs.getString("MaterialNumber"));
                dateMap.put("MaterialName", rs.getString("MaterialName"));
                dateMap.put("StorageName", rs.getString("StorageName"));
                dateMap.put("ProjectName", rs.getString("ProjectName"));
                dateMap.put("TrackNumber", rs.getString("TrackNumber"));
                dateMap.put("StandardRootingNumber", rs.getString("StandardRootingNumber"));
                dateMap.put("isExistPBom", rs.getString("isExistPBom"));
                dateMap.put("targetBOMNumber", rs.getString("targetBOMNumber"));
                dateMap.put("targetProjectName", rs.getString("targetProjectName"));
                dateMap.put("beginTrackNumber", rs.getString("beginTrackNumber"));
                dateMap.put("EndTrackNumber", rs.getString("EndTrackNumber"));
                dateMap.put("targetRootingNumber", rs.getString("targetRootingNumber"));
                dateMap.put("isExisttargetPbom", rs.getString("isExisttargetPbom"));
                dateList.add(dateMap);
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("SQLException:", e.getMessage()));
        }
        return dateList;
    }

    @Override
    protected boolean _isSameOperation(Context ctx, String standardRNum, String otherStandardRNum) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        ArrayList<String> operation1 = new ArrayList<String>();
        ArrayList<String> operation2 = new ArrayList<String>();
        sql.delete(0, sql.length());
        sql.append(" select opt.fnumber operation from T_MM_StandardRooting root");
        sql.append(" left outer join T_MM_MaterialRWP mrp on root.FmaterialRootingID = mrp.FparentID");
        sql.append(" left outer join T_MM_Operation opt on mrp.FOperationID = opt.Fid");
        sql.append(" where root.fnumber='" + standardRNum + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                operation1.add(rs.getString("operation"));
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("SQLException:", e.getMessage()));
        }
        sql.delete(0, sql.length());
        sql.append(" select opt.fnumber operation from T_MM_StandardRooting root");
        sql.append(" left outer join T_MM_MaterialRWP mrp on root.FmaterialRootingID = mrp.FparentID");
        sql.append(" left outer join T_MM_Operation opt on mrp.FOperationID = opt.Fid");
        sql.append(" where root.fnumber='" + otherStandardRNum + "'");
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs2.next()) {
                operation2.add(rs2.getString("operation"));
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("SQLException:", e.getMessage()));
        }
        Collections.sort(operation1);
        Collections.sort(operation2);
        if (operation2.size() == operation1.size()) {
            for (int i = 0; i < operation2.size(); ++i) {
                if (((String)operation1.get(i)).equals(operation2.get(i))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected String _bomCopy(Context ctx, String param) throws BOSException, EASBizException {
        HashMap map = JSONUtils.convertJsonToObject((String)param);
        String sourceProjectID = (String)map.get("sourceProjectID");
        String sourceTrackNumber = (String)map.get("sourceTrackNumber");
        String targetProjectID = (String)map.get("targetProjectID");
        String targetTrackNumberBeginID = (String)map.get("targetTrackNumberBeginID");
        String targetTrackNumberEndID = (String)map.get("targetTrackNumberEndID");
        String srcBomNumber = (String)map.get("srcBomNumber");
        if (targetProjectID == null || "".equals(targetProjectID)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_MBXMH_NN", (Locale)ctx.getLocale())));
        }
        if (sourceTrackNumber == null || "".equals(sourceTrackNumber)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_YGZH_NN", (Locale)ctx.getLocale())));
        }
        if (targetTrackNumberBeginID == null || "".equals(targetTrackNumberBeginID)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_MBKSGZH_NN", (Locale)ctx.getLocale())));
        }
        if (targetTrackNumberEndID == null || "".equals(targetTrackNumberEndID)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_MBJSGZH_NN", (Locale)ctx.getLocale())));
        }
        if (srcBomNumber == null || "".equals(srcBomNumber)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_YBOMBM_NN", (Locale)ctx.getLocale())));
        }
        ProjectInfo projectInfo = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(targetProjectID));
        TrackNumberInfo beginTrackInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(targetTrackNumberBeginID));
        TrackNumberInfo endTrackInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(targetTrackNumberEndID));
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        SelectorItemCollection sic = new SelectorItemCollection();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String oldBomID = BomFactory.getLocalInstance((Context)ctx).getBomInfo("where number ='" + srcBomNumber + "'").getId().toString();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("beginCarno.id"));
        sic.add(new SelectorItemInfo("beginCarno.number"));
        sic.add(new SelectorItemInfo("endCarno.id"));
        sic.add(new SelectorItemInfo("endCarno.number"));
        entityViewInfo.setSelector(sic);
        filterInfo.getFilterItems().add(new FilterItemInfo("beginCarno.number", (Object)sourceTrackNumber, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("endCarno.number", (Object)sourceTrackNumber, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)oldBomID, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        BomEntryCollection bomEntryCollection = BomEntryFactory.getLocalInstance((Context)ctx).getBomEntryCollection(entityViewInfo);
        BomEntryInfo oldbomentryInfo = null;
        BomInfo oldbomInfo = null;
        BomEntryInfo newbomentryInfo = null;
        BomInfo newbomInfo = null;
        StringBuffer sql = new StringBuffer();
        ArrayList<String> sqls = new ArrayList<String>();
        HashMap<String, BomInfo> bomidMap = new HashMap<String, BomInfo>();
        HashMap<String, BomEntryInfo> bomidentryMap = new HashMap<String, BomEntryInfo>();
        ArrayList<String> xNMaterial = new ArrayList<String>();
        if (bomEntryCollection.size() > 0) {
            for (int i = 0; i < bomEntryCollection.size(); ++i) {
                oldbomentryInfo = bomEntryCollection.get(i);
                oldbomInfo = oldbomentryInfo.getParent();
                if (oldbomInfo == null) continue;
                if (bomidMap.containsKey(oldbomInfo.getId().toString())) {
                    newbomInfo = (BomInfo)bomidMap.get(oldbomInfo.getId().toString());
                } else {
                    newbomInfo = (BomInfo)oldbomInfo.clone();
                    BOSUuid newpkid = BOSUuid.create((String)"8F409A89");
                    newbomInfo.setId(newpkid);
                    newbomInfo.setCreator(userInfo);
                    newbomInfo.setCreateTime(new Timestamp(new Date().getTime()));
                    try {
                        String billNumber = this.getBillNumber(ctx, (IObjectValue)newbomInfo, ContextUtil.getCurrentStorageUnit((Context)ctx).getId().toString());
                        String sqlbillNumber = "select 1 from T_MM_BOM where fnumber = '" + billNumber + "'";
                        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlbillNumber);
                        if (rs.next()) {
                            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_CXCFBM", (Locale)ctx.getLocale())));
                        }
                        newbomInfo.setNumber(billNumber);
                    }
                    catch (Exception e) {
                        throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_CWXX", (Locale)ctx.getLocale()) + e.getMessage()));
                    }
                    newbomInfo.setBizDate(new Date());
                    newbomInfo.setAuditor(userInfo);
                    newbomInfo.setAuditTime(new Timestamp(new Date().getTime()));
                    newbomInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
                    newbomInfo.setProject(projectInfo);
                    sql.delete(0, sql.length());
                    sql.append(" update t_mm_bom set foldid = '").append(oldbomInfo.getId().toString()).append("' where fid = '").append(newpkid).append("'");
                    sqls.add(sql.toString());
                }
                newbomentryInfo = (BomEntryInfo)oldbomentryInfo.clone();
                BOSUuid newentrypkid = BOSUuid.create((String)"B0D7AB69");
                newbomentryInfo.setId(newentrypkid);
                newbomentryInfo.setParent(newbomInfo);
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"GJYBOMGZHSSFZSC_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{srcBomNumber, sourceTrackNumber});
                newbomentryInfo.setRemark(strInfo);
                newbomentryInfo.setBeginCarno(beginTrackInfo);
                newbomentryInfo.setEndCarno(endTrackInfo);
                newbomentryInfo.setSourceProcessId(null);
                newbomentryInfo.setSourceProcess(null);
                newbomInfo.getEntrys().add(newbomentryInfo);
                MaterialAttributeEnum materialProp = newbomentryInfo.getMaterialProp();
                if (materialProp.getValue() == 10020) {
                    xNMaterial.add(newbomentryInfo.getMaterial().getId().toString());
                }
                sql.delete(0, sql.length());
                sql.append(" update t_mm_bomentry set foldid = '").append(oldbomentryInfo.getId().toString()).append("' where fid = '").append(newentrypkid).append("'");
                sqls.add(sql.toString());
                bomidMap.put(oldbomInfo.getId().toString(), newbomInfo);
                bomidentryMap.put(oldbomentryInfo.getId().toString(), newbomentryInfo);
            }
        } else {
            return null;
        }
        Iterator it = bomidMap.keySet().iterator();
        String foldid = "";
        IBom iBom = BomFactory.getLocalInstance((Context)ctx);
        while (it.hasNext()) {
            foldid = (String)it.next();
            newbomInfo = (BomInfo)bomidMap.get(foldid);
            FilterInfo view = new FilterInfo();
            view.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)newbomInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
            view.getFilterItems().add(new FilterItemInfo("material.id", (Object)newbomInfo.getMaterial().getId().toString(), CompareType.EQUALS));
            view.getFilterItems().add(new FilterItemInfo("project.id", (Object)newbomInfo.getProject().getId().toString(), CompareType.EQUALS));
            boolean isexists = iBom.exists(view);
            if (isexists) continue;
            iBom.addnew((CoreBaseInfo)newbomInfo);
        }
        if (sqls != null && sqls.size() > 0) {
            DBUtil.execBatchSql((Context)ctx, sqls, (boolean)true);
        }
        if (xNMaterial.size() > 0) {
            for (int i = 0; i < xNMaterial.size(); ++i) {
                HashMap<String, String> xNmap = new HashMap<String, String>();
                xNmap.put("sourceTrackNumber", sourceTrackNumber);
                xNmap.put("targetProjectID", targetProjectID);
                xNmap.put("targetTrackNumberBeginID", targetTrackNumberBeginID);
                xNmap.put("targetTrackNumberEndID", targetTrackNumberEndID);
                xNmap.put("sourceProjectID", sourceProjectID);
                String storage = oldbomInfo.getStorageOrgUnit().getId().toString();
                String sNsrcBomNumber = this.getSrcBomNumber(ctx, storage, sourceProjectID, (String)xNMaterial.get(i));
                if (sNsrcBomNumber == null) continue;
                xNmap.put("srcBomNumber", sNsrcBomNumber);
                String xNparam = JSONUtils.convertObjectToJson(xNmap);
                boolean isExists = BomFactory.getLocalInstance((Context)ctx).exists("where material.id ='" + (String)xNMaterial.get(i) + "' and project.id = '" + targetProjectID + "' and storageOrgUnit.id = '" + storage + "' ");
                if (isExists) continue;
                this._bomCopy(ctx, xNparam);
            }
            xNMaterial.clear();
        }
        return newbomInfo.getNumber();
    }

    @Override
    protected String _pBomCopy(Context ctx, String param) throws BOSException, EASBizException {
        HashMap map = JSONUtils.convertJsonToObject((String)param);
        String sourceProjectID = (String)map.get("sourceProjectID");
        String sourceTrackNumberID = (String)map.get("sourceTrackNumberID");
        String sourceTrackNumber = (String)map.get("sourceTrackNumber");
        String targetProjectID = (String)map.get("targetProjectID");
        String targetTrackNumberBeginID = (String)map.get("targetTrackNumberBeginID");
        String targetTrackNumberEndID = (String)map.get("targetTrackNumberEndID");
        String srcBomNumber = (String)map.get("srcBomNumber");
        String pBomID = (String)map.get("pBomID");
        String targetBomNumber = (String)map.get("targetBomNumber");
        if (targetProjectID == null || "".equals(targetProjectID)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_MBXMH_NN", (Locale)ctx.getLocale())));
        }
        if (sourceTrackNumberID == null || "".equals(sourceTrackNumberID)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_YGZH_NN", (Locale)ctx.getLocale())));
        }
        if (targetTrackNumberBeginID == null || "".equals(targetTrackNumberBeginID)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_MBKSGZH_NN", (Locale)ctx.getLocale())));
        }
        if (targetTrackNumberEndID == null || "".equals(targetTrackNumberEndID)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_MBJSGZH_NN", (Locale)ctx.getLocale())));
        }
        if (srcBomNumber == null || "".equals(srcBomNumber)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_YBOMBM_NN", (Locale)ctx.getLocale())));
        }
        ProjectInfo projectInfo = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(targetProjectID));
        TrackNumberInfo beginTrackInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(targetTrackNumberBeginID));
        TrackNumberInfo endTrackInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(targetTrackNumberEndID));
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        SelectorItemCollection sic = new SelectorItemCollection();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("sTrace.id"));
        sic.add(new SelectorItemInfo("sTrace.number"));
        sic.add(new SelectorItemInfo("eTrace.id"));
        sic.add(new SelectorItemInfo("eTrace.number"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("BOM.name"));
        entityViewInfo.setSelector(sic);
        filterInfo.getFilterItems().add(new FilterItemInfo("sTrace.number", (Object)sourceTrackNumber, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("eTrace.number", (Object)sourceTrackNumber, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pBomID, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        PBOMEntryCollection pBOMEntryCollection = PBOMEntryFactory.getLocalInstance((Context)ctx).getPBOMEntryCollection(entityViewInfo);
        SelectorItemCollection bomSic = new SelectorItemCollection();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo bomFilterInfo = new FilterInfo();
        bomSic.add(new SelectorItemInfo("*"));
        bomSic.add(new SelectorItemInfo("entrys.*"));
        bomSic.add(new SelectorItemInfo("entrys.material.number"));
        bomSic.add(new SelectorItemInfo("entrys.material.id"));
        bomSic.add(new SelectorItemInfo("entrys.beginCarno.*"));
        bomSic.add(new SelectorItemInfo("entrys.beginCarno.id"));
        bomSic.add(new SelectorItemInfo("entrys.beginCarno.number"));
        bomSic.add(new SelectorItemInfo("entrys.endCarno.*"));
        bomSic.add(new SelectorItemInfo("entrys.endCarno.id"));
        bomSic.add(new SelectorItemInfo("entrys.endCarno.number"));
        bomSic.add(new SelectorItemInfo("material.number"));
        bomSic.add(new SelectorItemInfo("storageOrgUnit.id"));
        bomSic.add(new SelectorItemInfo("project.id"));
        view.setSelector(bomSic);
        bomFilterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)targetBomNumber, CompareType.EQUALS));
        view.setFilter(bomFilterInfo);
        IBom iBom = BomFactory.getLocalInstance((Context)ctx);
        if (!iBom.exists(bomFilterInfo)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_CZSJWT", (Locale)ctx.getLocale()) + EASResource.getString((String)this.RESURL, (String)"EM_MYZDXMPZBOM", (Locale)ctx.getLocale()) + targetBomNumber + "!"));
        }
        if (iBom.getBomCollection(view).size() > 1) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_CZSJWT", (Locale)ctx.getLocale()) + EASResource.getString((String)this.RESURL, (String)"EM_XMPZBOM", (Locale)ctx.getLocale()) + targetBomNumber + EASResource.getString((String)this.RESURL, (String)"EM_BMCZCF", (Locale)ctx.getLocale())));
        }
        BomInfo targetBomInfo = iBom.getBomCollection(view).get(0);
        this.allCheckQtyMap.clear();
        this.getCheckQtyMap(targetBomInfo, ctx);
        Map<String, BigDecimal> checkQtyMap = this.allCheckQtyMap;
        PBOMEntryInfo oldpbomentryInfo = null;
        PBOMInfo oldpbomInfo = null;
        PBOMEntryInfo newpbomentryInfo = null;
        PBOMInfo newpbomInfo = null;
        StringBuffer sql = new StringBuffer();
        ArrayList<String> sqls = new ArrayList<String>();
        HashMap<String, PBOMInfo> pbomidMap = new HashMap<String, PBOMInfo>();
        if (pBOMEntryCollection.size() > 0) {
            for (int i = 0; i < pBOMEntryCollection.size(); ++i) {
                oldpbomentryInfo = pBOMEntryCollection.get(i);
                oldpbomInfo = oldpbomentryInfo.getParent();
                if (oldpbomInfo == null) continue;
                if (pbomidMap.containsKey(oldpbomInfo.getId().toString())) {
                    newpbomInfo = (PBOMInfo)pbomidMap.get(oldpbomInfo.getId().toString());
                } else {
                    newpbomInfo = (PBOMInfo)oldpbomInfo.clone();
                    BOSUuid newpkid = BOSUuid.create((String)"58D86787");
                    newpbomInfo.setId(newpkid);
                    newpbomInfo.setCreator(userInfo);
                    newpbomInfo.setCreateTime(new Timestamp(new Date().getTime()));
                    newpbomInfo.setNumber(targetBomInfo.getNumber());
                    newpbomInfo.setBom(targetBomInfo);
                    newpbomInfo.setProject(projectInfo);
                    sql.delete(0, sql.length());
                    sql.append(" update t_mm_pbom set foldid = '").append(oldpbomInfo.getId().toString()).append("' where fid = '").append(newpkid).append("'");
                    sqls.add(sql.toString());
                }
                newpbomentryInfo = (PBOMEntryInfo)oldpbomentryInfo.clone();
                BOSUuid newentrypkid = BOSUuid.create((String)"1BAE4D2B");
                newpbomentryInfo.setId(newentrypkid);
                newpbomentryInfo.setParent(newpbomInfo);
                newpbomentryInfo.setBomItem(null);
                newpbomentryInfo.setBOM(null);
                BomEntryInfo newEntryInfo = this.getNewEntryInfo(ctx, targetBomInfo, newpbomentryInfo.getMaterial().getId().toString(), oldpbomentryInfo.getBOM().getName());
                if (newEntryInfo == null) continue;
                newpbomentryInfo.setBomItem(newEntryInfo);
                newpbomentryInfo.setBOM(newEntryInfo.getParent());
                TrackNumberInfo BOMBeginTrackInfo = newEntryInfo.getBeginCarno();
                TrackNumberInfo BOMEndTrackInfo = newEntryInfo.getEndCarno();
                if (this.compareTrackNumber(BOMBeginTrackInfo.getNumber(), beginTrackInfo.getNumber()) == 1) {
                    throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_MBBOM", (Locale)ctx.getLocale()) + targetBomInfo.getNumber() + EASResource.getString((String)this.RESURL, (String)"EM_FZGXBOMSB", (Locale)ctx.getLocale()) + "\uff0c" + EASResource.getString((String)this.RESURL, (String)"EM_MYZDFHGZH", (Locale)ctx.getLocale()) + beginTrackInfo.getNumber() + EASResource.getString((String)this.RESURL, (String)"EM_DPZBOMSJ", (Locale)ctx.getLocale())));
                }
                if (this.compareTrackNumber(beginTrackInfo.getNumber(), BOMEndTrackInfo.getNumber()) == 1) {
                    throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_MBBOM", (Locale)ctx.getLocale()) + targetBomInfo.getNumber() + EASResource.getString((String)this.RESURL, (String)"EM_FZGXBOMSB", (Locale)ctx.getLocale()) + "\uff0c" + EASResource.getString((String)this.RESURL, (String)"EM_MYZDFHGZH", (Locale)ctx.getLocale()) + beginTrackInfo.getNumber() + EASResource.getString((String)this.RESURL, (String)"EM_DPZBOMSJ", (Locale)ctx.getLocale())));
                }
                newpbomentryInfo.setSTrace(beginTrackInfo);
                if (this.compareTrackNumber(BOMEndTrackInfo.getNumber(), endTrackInfo.getNumber()) == -1) {
                    throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_MBBOM", (Locale)ctx.getLocale()) + targetBomInfo.getNumber() + EASResource.getString((String)this.RESURL, (String)"EM_FZGXBOMSB", (Locale)ctx.getLocale()) + "\uff0c" + EASResource.getString((String)this.RESURL, (String)"EM_MYZDFHGZH", (Locale)ctx.getLocale()) + beginTrackInfo.getNumber() + EASResource.getString((String)this.RESURL, (String)"EM_DPZBOMSJ", (Locale)ctx.getLocale())));
                }
                if (this.compareTrackNumber(endTrackInfo.getNumber(), BOMBeginTrackInfo.getNumber()) == -1) {
                    throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESURL, (String)"EM_MBBOM", (Locale)ctx.getLocale()) + targetBomInfo.getNumber() + EASResource.getString((String)this.RESURL, (String)"EM_FZGXBOMSB", (Locale)ctx.getLocale()) + "\uff0c" + EASResource.getString((String)this.RESURL, (String)"EM_MYZDFHGZH", (Locale)ctx.getLocale()) + beginTrackInfo.getNumber() + EASResource.getString((String)this.RESURL, (String)"EM_DPZBOMSJ", (Locale)ctx.getLocale())));
                }
                newpbomentryInfo.setETrace(endTrackInfo);
                BigDecimal quota = newpbomentryInfo.getConsumeQuota();
                String sTrace = newpbomentryInfo.getSTrace().getNumber();
                String head = sTrace.substring(0, sTrace.length() - 4);
                int intsTrace = Integer.valueOf(sTrace.substring(sTrace.length() - 4));
                String eTrace = newpbomentryInfo.getETrace().getNumber();
                int inteTrace = Integer.valueOf(eTrace.substring(eTrace.length() - 4));
                String material = newpbomentryInfo.getMaterial().getNumber();
                boolean isCopyEntry = true;
                StringBuilder key = new StringBuilder();
                for (int k = 0; k < inteTrace - intsTrace + 1; ++k) {
                    key.delete(0, key.length());
                    key.append(material);
                    key.append("_");
                    key.append(head);
                    key.append(String.valueOf(intsTrace + k));
                    BigDecimal qty = checkQtyMap.get(key.toString());
                    if (qty == null) {
                        isCopyEntry = false;
                        continue;
                    }
                    if (qty.compareTo(quota) == -1) {
                        newpbomentryInfo.setConsumeQuota(qty);
                        continue;
                    }
                    checkQtyMap.put(key.toString(), qty.subtract(quota));
                }
                if (!isCopyEntry) continue;
                newpbomInfo.getPbomEntry().add(newpbomentryInfo);
                sql.delete(0, sql.length());
                sql.append(" update t_mm_pbomentry set foldid = '").append(oldpbomentryInfo.getId().toString()).append("' where fid = '").append(newentrypkid).append("'");
                sqls.add(sql.toString());
                pbomidMap.put(oldpbomInfo.getId().toString(), newpbomInfo);
            }
        } else {
            return null;
        }
        String foldid2 = "";
        for (String foldid2 : pbomidMap.keySet()) {
            newpbomInfo = (PBOMInfo)pbomidMap.get(foldid2);
            PBOMFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)newpbomInfo);
        }
        if (sqls != null && sqls.size() > 0) {
            DBUtil.execBatchSql((Context)ctx, sqls, (boolean)true);
        }
        return newpbomInfo.getNumber();
    }

    @Override
    protected String _standardRootingCopy(Context ctx, String param) throws BOSException, EASBizException {
        return null;
    }

    private String getBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID) throws Exception {
        String sqlbillNumber;
        IRowSet rs;
        String billNumber = null;
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule(billInfo, bizOrgUnitID);
        if (ruleInfo != null) {
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(billInfo, ruleInfo);
        }
        if (billNumber == null) {
            billNumber = billInfo.getString("id") != null ? "AutoNumberFromBTP_" + billInfo.getString("id").toString() : "AutoNumberFromBTP_" + BOSUuid.create((BOSObjectType)billInfo.getBOSType());
        }
        if ((rs = DbUtil.executeQuery((Context)ctx, (String)(sqlbillNumber = "select 1 from T_MM_BOM where fnumber = '" + billNumber + "'"))).next()) {
            billNumber = this.getBillNumber(ctx, billInfo, bizOrgUnitID);
        }
        return billNumber;
    }

    private String getSrcBomNumber(Context ctx, String storage, String project, String material) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        sic.add(new SelectorItemInfo("*"));
        entityViewInfo.setSelector(sic);
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storage, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("project.id", (Object)project, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        BomCollection colls = BomFactory.getLocalInstance((Context)ctx).getBomCollection(entityViewInfo);
        if (colls.size() > 0) {
            return colls.get(0).getNumber();
        }
        StorageOrgUnitInfo storInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storage));
        ProjectInfo proInfo = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(project));
        MaterialInfo materInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(material));
        String strInfo = ResourceBase.getString((String)this.RESURL, (String)"MYZDKCZZXMHWLBM_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{storInfo.getName(), proInfo.getName(), materInfo.getNumber()});
        throw new EASBizException(new NumericExceptionSubItem("", strInfo));
    }

    @Override
    protected List _analysisDiffer(Context ctx, String param) throws BOSException, EASBizException {
        ArrayList dateList = new ArrayList();
        HashMap map = JSONUtils.convertJsonToObject((String)param);
        List selectSrcBOMNumberLs = (List)map.get("selectSrcBOMNumberLs");
        String targetProjectID = (String)map.get("targetProjectID");
        String entrySrcTrackNumber = (String)map.get("entrySrcTrackNumber");
        String entryTargetTrackNumber = (String)map.get("entryTargetTrackNumber");
        StringBuffer sql = new StringBuffer();
        sql.delete(0, sql.length());
        sql.append(" select ");
        sql.append(" pbom.fnumber BOMNumber");
        sql.append(" ,stor.fname_L2 storageName");
        sql.append(" ,material.fName_l2 productName");
        sql.append(" ,material.fnumber productNumber");
        sql.append(" ,rooting.fnumber rootingNumber");
        sql.append(" ,pbom.fid PBOMID");
        sql.append(" ,targetPBom.fid TARGETPBOMID");
        sql.append(" from t_MM_PBOM pbom");
        sql.append(" left outer join t_Org_Storage stor on stor.fid = pbom.fstorageorgunitid");
        sql.append(" left outer join T_MM_StandardRooting rooting on rooting.fid = pbom.FRoutingID");
        sql.append(" left outer join t_Bd_Material material on material.fid = rooting.fmaterialid");
        sql.append(" left outer join T_MM_BOM bom on bom.fid = pbom.fbomid");
        sql.append(" left outer join t_Mm_bom targetBom on bom.fmaterialid = targetBom.fmaterialid");
        sql.append(" \t\t\t\t\t\t\t\t\tand bom.fstorageorgunitid = targetBom.fstorageorgunitid");
        sql.append(" \t\t\t\t\t\t\t\t\tand targetBom.FPROJECTID = '" + targetProjectID + "'");
        sql.append(" left outer join t_Mm_Pbom targetPBom on targetBom.fid = targetPBom.fbomid");
        sql.append(" where 1 = 1");
        sql.append(" and bom.fnumber in (" + SQLUtil.arrayToString((Object[])selectSrcBOMNumberLs.toArray()) + ")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList headList = new ArrayList();
        try {
            while (rs.next()) {
                HashMap<String, String> headMap = new HashMap<String, String>();
                headMap.put("BOMNumber", rs.getString("BOMNumber"));
                headMap.put("storageName", rs.getString("storageName"));
                headMap.put("productName", rs.getString("productName"));
                headMap.put("productNumber", rs.getString("productNumber"));
                headMap.put("rootingNumber", rs.getString("rootingNumber"));
                headMap.put("PBOMID", rs.getString("PBOMID"));
                headMap.put("TARGETPBOMID", rs.getString("TARGETPBOMID"));
                headList.add(headMap);
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("SQLException:", e.getMessage()));
        }
        for (HashMap hashMap : headList) {
            String pBomId = (String)hashMap.get("PBOMID");
            String targetPBomid = (String)hashMap.get("TARGETPBOMID");
            String BOMNumber = (String)hashMap.get("BOMNumber");
            String storageName = (String)hashMap.get("storageName");
            String productName = (String)hashMap.get("productName");
            String productNumber = (String)hashMap.get("productNumber");
            String rootingNumber = (String)hashMap.get("rootingNumber");
            EntityViewInfo pBomView = new EntityViewInfo();
            SelectorItemCollection pBOmsic = new SelectorItemCollection();
            pBOmsic.add(new SelectorItemInfo("*"));
            pBOmsic.add(new SelectorItemInfo("routingItem.*"));
            pBOmsic.add(new SelectorItemInfo("routingItem.wpSeq"));
            pBOmsic.add(new SelectorItemInfo("routingItem.operation.*"));
            pBOmsic.add(new SelectorItemInfo("bomItem.*"));
            pBOmsic.add(new SelectorItemInfo("bomItem.material.*"));
            pBOmsic.add(new SelectorItemInfo("bomItem.unit.*"));
            pBOmsic.add(new SelectorItemInfo("sTrace.*"));
            pBOmsic.add(new SelectorItemInfo("eTrace.*"));
            pBomView.setSelector(pBOmsic);
            FilterInfo pBomfilter = new FilterInfo();
            pBomfilter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pBomId, CompareType.EQUALS));
            pBomfilter.getFilterItems().add(new FilterItemInfo("sTrace.number", (Object)entrySrcTrackNumber, CompareType.LESS_EQUALS));
            pBomfilter.getFilterItems().add(new FilterItemInfo("eTrace.number", (Object)entrySrcTrackNumber, CompareType.GREATER_EQUALS));
            pBomView.setFilter(pBomfilter);
            PBOMEntryCollection pBomColls = PBOMEntryFactory.getLocalInstance((Context)ctx).getPBOMEntryCollection(pBomView);
            class AnalysisDifferHelp {
                private PBOMEntryInfo pBomEntryInfo;
                private PBOMEntryInfo targetPBomEntryInfo;

                AnalysisDifferHelp(PBOMEntryInfo pBomEntryInfo, PBOMEntryInfo targetPBomEntryInfo) {
                    this.pBomEntryInfo = pBomEntryInfo;
                    this.targetPBomEntryInfo = targetPBomEntryInfo;
                }

                public PBOMEntryInfo getPBomEntryInfo() {
                    return this.pBomEntryInfo;
                }

                public void setPBomEntryInfo(PBOMEntryInfo bomEntryInfo) {
                    this.pBomEntryInfo = bomEntryInfo;
                }

                public PBOMEntryInfo getTargetPBomEntryInfo() {
                    return this.targetPBomEntryInfo;
                }

                public void setTargetPBomEntryInfo(PBOMEntryInfo targetPBomEntryInfo) {
                    this.targetPBomEntryInfo = targetPBomEntryInfo;
                }
            }
            HashMap<String, AnalysisDifferHelp> keyMap = new HashMap<String, AnalysisDifferHelp>();
            for (int i = 0; i < pBomColls.size(); ++i) {
                PBOMEntryInfo entryInfo = pBomColls.get(i);
                int wpSeq = entryInfo.getRoutingItem().getWpSeq();
                String operaNumber = entryInfo.getRoutingItem().getOperation().getNumber();
                String operaName = entryInfo.getRoutingItem().getOperation().getName();
                MaterialInfo entryMater = entryInfo.getBomItem().getMaterial();
                String baseUnit = entryInfo.getBomItem().getUnit().getName();
                String sTrace = entryInfo.getSTrace().getNumber();
                String eTrace = entryInfo.getETrace().getNumber();
                BigDecimal consumequota = entryInfo.getConsumeQuota();
                String key = wpSeq + " " + entryMater.getNumber();
                AnalysisDifferHelp help = new AnalysisDifferHelp(entryInfo, null);
                keyMap.put(key, help);
            }
            EntityViewInfo targetPBomView = new EntityViewInfo();
            targetPBomView.setSelector(pBOmsic);
            FilterInfo targetPBomfilter = new FilterInfo();
            targetPBomfilter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)targetPBomid, CompareType.EQUALS));
            targetPBomfilter.getFilterItems().add(new FilterItemInfo("sTrace.number", (Object)entryTargetTrackNumber, CompareType.LESS_EQUALS));
            targetPBomfilter.getFilterItems().add(new FilterItemInfo("eTrace.number", (Object)entryTargetTrackNumber, CompareType.GREATER_EQUALS));
            targetPBomView.setFilter(targetPBomfilter);
            PBOMEntryCollection targetPBomColls = PBOMEntryFactory.getLocalInstance((Context)ctx).getPBOMEntryCollection(targetPBomView);
            for (int j = 0; j < targetPBomColls.size(); ++j) {
                PBOMEntryInfo targetEntryInfo = targetPBomColls.get(j);
                int targetWpSeq = targetEntryInfo.getRoutingItem().getWpSeq();
                String targetOperaNumber = targetEntryInfo.getRoutingItem().getOperation().getNumber();
                String targetOperaName = targetEntryInfo.getRoutingItem().getOperation().getName();
                MaterialInfo targetEntryMater = targetEntryInfo.getBomItem().getMaterial();
                String targetBaseUnit = targetEntryInfo.getBomItem().getUnit().getName();
                String targetSTrace = targetEntryInfo.getSTrace().getNumber();
                String targetETrace = targetEntryInfo.getETrace().getNumber();
                BigDecimal targetConsumequota = targetEntryInfo.getConsumeQuota();
                String targetKey = targetWpSeq + " " + targetEntryMater.getNumber();
                if (keyMap.containsKey(targetKey)) {
                    ((AnalysisDifferHelp)keyMap.get(targetKey)).setTargetPBomEntryInfo(targetEntryInfo);
                    continue;
                }
                AnalysisDifferHelp help = new AnalysisDifferHelp(null, targetEntryInfo);
                keyMap.put(targetKey, help);
            }
            Collection AnalysisDifferHelps = keyMap.values();
            for (AnalysisDifferHelp analysisDifferHelp : AnalysisDifferHelps) {
                MaterialInfo m;
                PBOMEntryInfo p = analysisDifferHelp.getPBomEntryInfo();
                PBOMEntryInfo t = analysisDifferHelp.getTargetPBomEntryInfo();
                HashMap<String, String> dateMap = new HashMap<String, String>();
                dateMap.put("BOMNumber", BOMNumber);
                dateMap.put("storageName", storageName);
                dateMap.put("productName", productName);
                dateMap.put("productNumber", productNumber);
                dateMap.put("rootingNumber", rootingNumber);
                if (p != null && t != null) {
                    dateMap.put("WpSeq", p.getRoutingItem().getWpSeq() + "");
                    dateMap.put("operaNumber", p.getRoutingItem().getOperation().getNumber());
                    dateMap.put("operaName", p.getRoutingItem().getOperation().getName());
                    m = p.getBomItem().getMaterial();
                    dateMap.put("entryMaterNumber", m.getNumber());
                    dateMap.put("entryMaterName", m.getName());
                    dateMap.put("baseUnit", p.getBomItem().getBaseUnit().getName());
                    dateMap.put("consumequota", p.getConsumeQuota().toString());
                    dateMap.put("targetConsumequota", t.getConsumeQuota().toString());
                    dateMap.put("diffQty", p.getConsumeQuota().subtract(t.getConsumeQuota()).toString());
                    dateList.add(dateMap);
                    continue;
                }
                if (p == null) {
                    dateMap.put("WpSeq", t.getRoutingItem().getWpSeq() + "");
                    dateMap.put("operaNumber", t.getRoutingItem().getOperation().getNumber());
                    dateMap.put("operaName", t.getRoutingItem().getOperation().getName());
                    m = t.getBomItem().getMaterial();
                    dateMap.put("entryMaterNumber", m.getNumber());
                    dateMap.put("entryMaterName", m.getName());
                    dateMap.put("baseUnit", t.getBomItem().getBaseUnit().getName());
                    dateMap.put("consumequota", "0");
                    dateMap.put("targetConsumequota", t.getConsumeQuota().toString());
                    dateMap.put("diffQty", BigDecimal.ZERO.subtract(t.getConsumeQuota()).toString());
                    dateList.add(dateMap);
                    continue;
                }
                dateMap.put("WpSeq", p.getRoutingItem().getWpSeq() + "");
                dateMap.put("operaNumber", p.getRoutingItem().getOperation().getNumber());
                dateMap.put("operaName", p.getRoutingItem().getOperation().getName());
                m = p.getBomItem().getMaterial();
                dateMap.put("entryMaterNumber", m.getNumber());
                dateMap.put("entryMaterName", m.getName());
                dateMap.put("baseUnit", p.getBomItem().getBaseUnit().getName());
                dateMap.put("consumequota", p.getConsumeQuota().toString());
                dateMap.put("targetConsumequota", "0");
                dateMap.put("diffQty", p.getConsumeQuota().subtract(BigDecimal.ZERO).toString());
                dateList.add(dateMap);
            }
        }
        return dateList;
    }

    private Map<String, BigDecimal> getCheckQtyMap(BomInfo targetBomInfo, Context ctx) throws BOSException, EASBizException {
        IBom iBom = BomFactory.getLocalInstance((Context)ctx);
        int targetBomEntrySize = targetBomInfo.getEntrys().size();
        for (int i = 0; i < targetBomEntrySize; ++i) {
            BomEntryInfo bomEntryInfo = targetBomInfo.getEntrys().get(i);
            String materialNumber = bomEntryInfo.getMaterial().getNumber();
            String beginCarno = bomEntryInfo.getBeginCarno().getNumber();
            String head = beginCarno.substring(0, beginCarno.length() - 4);
            MaterialAttributeEnum materialProp = bomEntryInfo.getMaterialProp();
            if (materialProp.getValue() == 10020) {
                String storge = targetBomInfo.getStorageOrgUnit().getId().toString();
                String project = targetBomInfo.getProject().getId().toString();
                SelectorItemCollection bomSic = new SelectorItemCollection();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo bomFilterInfo = new FilterInfo();
                bomSic.add(new SelectorItemInfo("*"));
                bomSic.add(new SelectorItemInfo("entrys.*"));
                bomSic.add(new SelectorItemInfo("entrys.material.number"));
                bomSic.add(new SelectorItemInfo("entrys.beginCarno.number"));
                bomSic.add(new SelectorItemInfo("entrys.endCarno.number"));
                bomSic.add(new SelectorItemInfo("material.number"));
                bomSic.add(new SelectorItemInfo("storageOrgUnit.id"));
                bomSic.add(new SelectorItemInfo("project.id"));
                view.setSelector(bomSic);
                bomFilterInfo.getFilterItems().add(new FilterItemInfo("material.number", (Object)materialNumber, CompareType.EQUALS));
                bomFilterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storge, CompareType.EQUALS));
                bomFilterInfo.getFilterItems().add(new FilterItemInfo("project.id", (Object)project, CompareType.EQUALS));
                view.setFilter(bomFilterInfo);
                if (!iBom.exists(bomFilterInfo)) continue;
                if (iBom.getBomCollection(view).size() > 1) {
                    StorageOrgUnitInfo storInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(storge));
                    ProjectInfo proInfo = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(project));
                    String strInfo = ResourceBase.getString((String)this.RESURL, (String)"YZDKCZZXMHWLBM_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{storInfo.getName(), proInfo.getName(), materialNumber});
                    throw new EASBizException(new NumericExceptionSubItem("", strInfo));
                }
                BomInfo bomInfo = iBom.getBomCollection(view).get(0);
                this.getCheckQtyMap(bomInfo, ctx);
                continue;
            }
            int intBeginCaron = Integer.valueOf(beginCarno.substring(beginCarno.length() - 4));
            String EndCarno = bomEntryInfo.getEndCarno().getNumber();
            int intEndCaron = Integer.valueOf(EndCarno.substring(EndCarno.length() - 4));
            BigDecimal fixQty = bomEntryInfo.getConsumeFixQty();
            StringBuilder key = new StringBuilder();
            for (int j = 0; j < intEndCaron - intBeginCaron + 1; ++j) {
                key.delete(0, key.length());
                key.append(materialNumber);
                key.append("_");
                key.append(head);
                key.append(String.valueOf(intBeginCaron + j));
                if (this.allCheckQtyMap.containsKey(key.toString())) {
                    this.allCheckQtyMap.put(key.toString(), fixQty.add(this.allCheckQtyMap.get(key.toString())));
                    continue;
                }
                this.allCheckQtyMap.put(key.toString(), fixQty);
            }
        }
        return null;
    }

    private BomEntryInfo getNewEntryInfo(Context ctx, BomInfo targetBomInfo, String materialid, String BOMName) throws EASBizException, BOSException {
        BomEntryInfo entryInfo = null;
        boolean entryExists = BomEntryFactory.getLocalInstance((Context)ctx).exists("where parent.id ='" + targetBomInfo.getId() + "' and material.id='" + materialid + "' and parent.name = '" + BOMName + "'");
        if (entryExists) {
            SelectorItemCollection bomSic = new SelectorItemCollection();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo bomFilterInfo = new FilterInfo();
            bomSic.add(new SelectorItemInfo("*"));
            bomSic.add(new SelectorItemInfo("beginCarno.*"));
            bomSic.add(new SelectorItemInfo("beginCarno.id"));
            bomSic.add(new SelectorItemInfo("beginCarno.number"));
            bomSic.add(new SelectorItemInfo("endCarno.*"));
            bomSic.add(new SelectorItemInfo("endCarno.id"));
            bomSic.add(new SelectorItemInfo("endCarno.number"));
            bomSic.add(new SelectorItemInfo("material.id"));
            bomSic.add(new SelectorItemInfo("material.number"));
            view.setSelector(bomSic);
            bomFilterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialid, CompareType.EQUALS));
            bomFilterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)targetBomInfo.getId(), CompareType.EQUALS));
            view.setFilter(bomFilterInfo);
            entryInfo = BomEntryFactory.getLocalInstance((Context)ctx).getBomEntryCollection(view).get(0);
            return entryInfo;
        }
        BomEntryCollection colles = targetBomInfo.getEntrys();
        for (int i = 0; i < colles.size(); ++i) {
            BomEntryInfo info = colles.get(i);
            if (info.getMaterialProp().getValue() != 10020) continue;
            String storge = targetBomInfo.getStorageOrgUnit().getId().toString();
            String project = targetBomInfo.getProject().getId().toString();
            SelectorItemCollection bomSic = new SelectorItemCollection();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo bomFilterInfo = new FilterInfo();
            bomSic.add(new SelectorItemInfo("*"));
            bomSic.add(new SelectorItemInfo("entrys.*"));
            bomSic.add(new SelectorItemInfo("entrys.material.number"));
            bomSic.add(new SelectorItemInfo("entrys.beginCarno.*"));
            bomSic.add(new SelectorItemInfo("entrys.beginCarno.id"));
            bomSic.add(new SelectorItemInfo("entrys.beginCarno.number"));
            bomSic.add(new SelectorItemInfo("entrys.endCarno.*"));
            bomSic.add(new SelectorItemInfo("entrys.endCarno.id"));
            bomSic.add(new SelectorItemInfo("entrys.endCarno.number"));
            bomSic.add(new SelectorItemInfo("material.number"));
            bomSic.add(new SelectorItemInfo("storageOrgUnit.id"));
            bomSic.add(new SelectorItemInfo("project.id"));
            view.setSelector(bomSic);
            bomFilterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)info.getMaterial().getId().toString(), CompareType.EQUALS));
            bomFilterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storge, CompareType.EQUALS));
            bomFilterInfo.getFilterItems().add(new FilterItemInfo("project.id", (Object)project, CompareType.EQUALS));
            view.setFilter(bomFilterInfo);
            if (!BomFactory.getLocalInstance((Context)ctx).exists(bomFilterInfo)) {
                return null;
            }
            BomInfo bomInfo = BomFactory.getLocalInstance((Context)ctx).getBomCollection(view).get(0);
            entryInfo = this.getNewEntryInfo(ctx, bomInfo, materialid, BOMName);
            if (entryInfo == null) continue;
            return entryInfo;
        }
        return entryInfo;
    }

    private int compareTrackNumber(String srcNumber, String targetNumber) {
        int intTargetNumber;
        int intSrcNumber = Integer.valueOf(srcNumber.substring(srcNumber.length() - 4));
        if (intSrcNumber == (intTargetNumber = Integer.valueOf(targetNumber.substring(targetNumber.length() - 4)).intValue())) {
            return 0;
        }
        if (intSrcNumber > intTargetNumber) {
            return 1;
        }
        return -1;
    }
}

