/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.mm.basedata.BomChangeBillStatusEnum;
import com.kingdee.eas.mm.basedata.BomChangeFactory;
import com.kingdee.eas.mm.basedata.BomChangeInfo;
import com.kingdee.eas.mm.basedata.BomChangeNewEntryInfo;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.IBomChange;
import com.kingdee.eas.mm.basedata.IssuePropEnum;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.app.AbstractBomChangeControllerBean;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.convert.BomChangeBillAuditFacadeFactory;
import com.kingdee.eas.zjbom.convert.process.BomConvertBaseProcess;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BomChangeControllerBean
extends AbstractBomChangeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.basedata.app.BomChangeControllerBean");

    @Override
    protected MaterialProvideTypeEnum _getMaterialProvideTypeEnum(Context ctx, String storageOrgUnitId, String supplyOrgUnit, String materialid) throws BOSException, EASBizException {
        return BomConvertBaseProcess.getMaterialProvideTypeEnum(ctx, storageOrgUnitId, supplyOrgUnit, materialid);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, model);
        BomChangeInfo info = (BomChangeInfo)model;
        if (info.getId() == null) {
            BOTRelationInfo botInfo = new BOTRelationInfo();
            botInfo.setSrcEntityID(info.getBom().getBOSType().toString());
            botInfo.setSrcObjectID(info.getBom().getId().toString());
            botInfo.setDestEntityID(this.getBOSType().toString());
            botInfo.setDestObjectID(pk.toString());
            botInfo.setDate(new Date());
            botInfo.setOperatorID(info.getCreator().getNumber());
            botInfo.setIsEffected(true);
            botInfo.setBOTMappingID("0");
            botInfo.setType(0);
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(botInfo);
        }
        return pk;
    }

    protected Result _save(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        return super._save(ctx, colls);
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._save(ctx, pk, model);
    }

    protected String checkSubmitDatas(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BomChangeInfo info = (BomChangeInfo)model;
        IBomChange ib = BomChangeFactory.getLocalInstance(ctx);
        String errorString = "";
        if (info.getNumber() == null || "".equals(info.getNumber())) {
            errorString = errorString + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_1", (Locale)ctx.getLocale()) + "\r\n";
        } else {
            if (info.getId() != null && BomChangeFactory.getLocalInstance(ctx).exists("where number = '" + info.getNumber() + "' and id <> '" + info.getId() + "'")) {
                errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_27", (Locale)ctx.getLocale()) + "\r\n";
            }
            if (info.getStorageOrgUnit() == null) {
                errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_2", (Locale)ctx.getLocale()) + "\r\n";
            }
            if (info.getDesignMode() == null) {
                errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_39", (Locale)ctx.getLocale()) + "\r\n";
            }
            if (info.getBom() == null) {
                errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_4", (Locale)ctx.getLocale()) + "\r\n";
            }
            if (info.getBizDate() == null) {
                errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_5", (Locale)ctx.getLocale()) + "\r\n";
            }
            if (info.isIsHandAdd()) {
                if (info.getDepartment() == null) {
                    errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_7", (Locale)ctx.getLocale()) + "\r\n";
                }
                if (info.getChangePerson() == null) {
                    errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_6", (Locale)ctx.getLocale()) + "\r\n";
                }
            }
            if (info.getUnit() == null) {
                errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_26", (Locale)ctx.getLocale()) + "\r\n";
            }
            if (info.getBaseStatus().equals((Object)BomChangeBillStatusEnum.AUDIT)) {
                errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_25", (Locale)ctx.getLocale()) + "\r\n";
            }
            if (errorString != null && !"".equals(errorString)) {
                return errorString;
            }
            DesignModeInfo dsInfo = info.getDesignMode();
            if (dsInfo.isProject() && info.getProject() == null) {
                errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_10", (Locale)ctx.getLocale()) + "\r\n";
            }
            String fkey = null;
            ArrayList<String> checkList = new ArrayList<String>();
            for (int i = 0; i < info.getNewEntry().size(); ++i) {
                BomChangeNewEntryInfo entryInfo = info.getNewEntry().get(i);
                if (entryInfo.getMaterial() == null) {
                    errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_18", (Locale)ctx.getLocale()) + "\r\n" + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_19", (Locale)ctx.getLocale()) + "\r\n";
                    continue;
                }
                if (entryInfo.getUnit() == null) {
                    errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_18", (Locale)ctx.getLocale()) + "\r\n" + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_21", (Locale)ctx.getLocale()) + "\r\n";
                    continue;
                }
                if (entryInfo.getSupplyOrgUnit() == null) {
                    errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_18", (Locale)ctx.getLocale()) + "\r\n" + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_20", (Locale)ctx.getLocale()) + "\r\n";
                    continue;
                }
                if (info.getMainTenanceLevel() != null && (entryInfo.getIssueProp() == null || entryInfo.getIssueProp().equals((Object)IssuePropEnum.NULL))) {
                    errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_18", (Locale)ctx.getLocale()) + "\r\n" + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_41", (Locale)ctx.getLocale()) + "\r\n";
                    continue;
                }
                if (dsInfo.isTrackNumber()) {
                    if (info.getNewEntry().get(i).getBeginCarno() == null) {
                        errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_18", (Locale)ctx.getLocale()) + "\r\n" + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_12", (Locale)ctx.getLocale()) + "\r\n";
                        continue;
                    }
                    if (info.getNewEntry().get(i).getEndCarno() == null) {
                        errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_18", (Locale)ctx.getLocale()) + "\r\n" + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_13", (Locale)ctx.getLocale()) + "\r\n";
                        continue;
                    }
                }
                fkey = entryInfo.getMaterial().getId().toString() + entryInfo.getSupplyOrgUnit().getId().toString();
                if (!dsInfo.isTrackNumber()) {
                    if (checkList.contains(fkey)) {
                        errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_18", (Locale)ctx.getLocale()) + "\r\n" + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_28", (Locale)ctx.getLocale()) + "\r\n";
                        continue;
                    }
                    checkList.add(fkey);
                    continue;
                }
                List trackIdList = ib.getTrackInfoList(entryInfo.getBeginCarno(), entryInfo.getEndCarno());
                for (int k = 0; k < trackIdList.size(); ++k) {
                    if (checkList.contains(fkey + (String)trackIdList.get(k))) {
                        errorString = errorString + info.getNumber() + ":" + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_18", (Locale)ctx.getLocale()) + "\r\n" + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.mm.basedata.client.BomChangeResource", (String)"bomchange_msg_29", (Locale)ctx.getLocale()) + "\r\n";
                        continue;
                    }
                    checkList.add(fkey + (String)trackIdList.get(k));
                }
            }
        }
        return errorString;
    }

    protected boolean isAuditAfterSubmit(Context ctx, String billTypeId, String orgUnitID, int orgType) throws BOSException, EASBizException {
        ISCMBillParam scmParam;
        String strAutoAudit;
        boolean isAutoAudit = false;
        if (billTypeId != null && (strAutoAudit = (scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx)).getParamByBillTypeID("BOMChange_Submit", orgType, orgUnitID, billTypeId)) != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().toLowerCase().equals("1")) {
            isAutoAudit = true;
        }
        return isAutoAudit;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BomChangeInfo info = (BomChangeInfo)model;
        String errorString = this.checkSubmitDatas(ctx, model);
        if (errorString != null && !"".equals(errorString)) {
            throw new EASBizException(new NumericExceptionSubItem(info.getNumber() + "_check error:", errorString));
        }
        info.setBaseStatus(BomChangeBillStatusEnum.SUBMIT);
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (pk == null && model == null) {
            return;
        }
        String id = null;
        id = pk == null ? ((BomChangeInfo)model).getId().toString() : pk.toString();
        BomChangeBillAuditFacadeFactory.getLocalInstance(ctx).bomBillChangeAudit(id);
    }

    @Override
    protected List<String> _getTrackInfoList(Context ctx, IObjectValue beginTrackInfo, IObjectValue endTrackInfo) throws BOSException, EASBizException {
        TrackNumberInfo btInfo = (TrackNumberInfo)beginTrackInfo;
        TrackNumberInfo etInfo = (TrackNumberInfo)endTrackInfo;
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select b.fid fid from t_mm_tracknumber b  ");
        sql.append("where b.fnumber >= '");
        sql.append(btInfo.getNumber());
        sql.append("' and b.fnumber <= '");
        sql.append(etInfo.getNumber());
        sql.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                list.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return list;
    }
}

