/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.mm.basedata.BomCollection;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectCarCollection;
import com.kingdee.eas.mm.project.ProjectCarFactory;
import com.kingdee.eas.mm.project.ProjectCarInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class PBomToBom {
    protected Context ctx;
    protected String projectid = "Si/vdBbUQOKh1aFYY7MEMACyBQ4=";
    protected IBom ib;
    protected String tempTableName_cars;
    protected Map tracks = new HashMap();
    protected String tempTableName_PBOM = null;
    protected String pbomid;
    protected String tempTableName_BOM = null;
    protected TempTablePool pool;

    public void update() throws BOSException {
        this.expandCars();
        StringBuilder sql = new StringBuilder();
        sql.append("select t_mm_pbomentry.cfbomid cfbomid, t_mm_pbomentry.cfmaterialid cfmaterialid ");
        sql.append(" ,t_mm_pbomentry.cfstraceid cfstraceid, t_mm_pbomentry.cfetraceid cfetraceid");
        sql.append(" ,sum(t_mm_pbomentry.cfconsumequota) cfconsumequota");
        sql.append(" from t_mm_pbom left join t_mm_pbomentry on t_mm_pbom.fid = t_mm_pbomentry.fparentid");
        sql.append(" where t_mm_pbom.fprojectid = 'Si/vdBbUQOKh1aFYY7MEMACyBQ4='");
        sql.append(" and t_mm_pbomentry.cfetraceid = 'kcYAAABXOacIbpg9'");
        sql.append(" and t_mm_pbomentry.cfbomid is not null and exists (select fid from t_mm_bom where fid = t_mm_pbomentry.cfbomid)");
        sql.append(" group by t_mm_pbomentry.cfmaterialid, t_mm_pbomentry.cfbomid, t_mm_pbomentry.cfstraceid, t_mm_pbomentry.cfetraceid");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        SelectorItemCollection msic = new SelectorItemCollection();
        msic.add(new SelectorItemInfo("id"));
        msic.add(new SelectorItemInfo("baseUnit"));
        HashMap<String, BomInfo> boms = new HashMap<String, BomInfo>();
        BomCollection updates = new BomCollection();
        Object base = null;
        ITrackNumber it = TrackNumberFactory.getLocalInstance((Context)this.ctx);
        IMaterialPlan imPlan = MaterialPlanFactory.getLocalInstance((Context)this.ctx);
        IMaterial im = MaterialFactory.getLocalInstance((Context)this.ctx);
        IStorageOrgUnit is = StorageOrgUnitFactory.getLocalInstance((Context)this.ctx);
        try {
            IRowSet row = DBUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[0]);
            while (row.next()) {
                BomInfo bom;
                String bomid = row.getString("cfbomid");
                String materialid = row.getString("cfmaterialid");
                String straceid = row.getString("cfstraceid");
                String etraceid = row.getString("cfetraceid");
                BigDecimal quota = row.getBigDecimal("cfconsumequota");
                if (quota == null) continue;
                if (boms.containsKey(bomid)) {
                    bom = (BomInfo)boms.get(bomid);
                } else {
                    SelectorItemCollection bsic = new SelectorItemCollection();
                    bsic.add(new SelectorItemInfo("*"));
                    bsic.add(new SelectorItemInfo("entrys.*"));
                    bom = null;
                    boms.put(bomid, bom);
                }
                boolean isUpdate = false;
                int size = bom.getEntrys().size();
                for (int i = 0; i < size; ++i) {
                    BomEntryInfo ei = bom.getEntrys().get(i);
                    if (ei.getMaterial() == null || !materialid.equals(ei.getMaterial().getId().toString()) || ei.getEndCarno() == null || !etraceid.equals(ei.getEndCarno().getId().toString())) continue;
                    ei.setConsumeFixBaseQty(quota);
                    ei.setConsumeFixQty(quota);
                    isUpdate = true;
                }
                if (!isUpdate) {
                    MaterialIssueModeEnum issMode;
                    BomEntryInfo newEI = base == null ? null : (BomEntryInfo)base.clone();
                    newEI.setId(null);
                    newEI.setParent(bom);
                    newEI.setProvideType(MaterialProvideTypeEnum.CURRENTORGPROVIDE);
                    newEI.setConsumeType(ConsumeTypeEnum.VariableAmount);
                    newEI.setOutputType(MaterialProductEnum.OTHER);
                    TrackNumberInfo b = it.getTrackNumberInfo((IObjectPK)new ObjectUuidPK(straceid), sic);
                    newEI.setBeginCarno(b);
                    TrackNumberInfo e = it.getTrackNumberInfo((IObjectPK)new ObjectUuidPK(etraceid), sic);
                    newEI.setEndCarno(e);
                    newEI.setMaterial(im.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialid), msic));
                    newEI.setUnit(newEI.getMaterial().getBaseUnit());
                    newEI.setUsedUnit(null);
                    MaterialPlanInfo planInfo = imPlan.getPlanInfo(materialid, bom.getStorageOrgUnit().getId().toString());
                    if (planInfo != null) {
                        newEI.setMaterialChar(planInfo.getMaterialChar());
                        newEI.setMaterialInventory(planInfo);
                        newEI.setProvideType(planInfo.getProvideType());
                        newEI.setSupplyOrgUnit(planInfo.getSupplyOrgUnit());
                        newEI.setIsBackFlush(planInfo.isIsBackFlush());
                        newEI.setIsStockTransfer(planInfo.isIsStockAllot());
                        newEI.setTransferOrgUnit(planInfo.getFromInvOrg());
                        newEI.setTransferWarehouse(planInfo.getFromWarehouse());
                    }
                    if (newEI.getSupplyOrgUnit() == null) {
                        sql.setLength(0);
                        sql.append("select FStorageOrgUnitID");
                        sql.append(" from t_mm_bom ");
                        sql.append(" where fprojectid = 'Si/vdBbUQOKh1aFYY7MEMACyBQ4='");
                        sql.append(" and fmaterialid = '").append(materialid).append("'");
                        IRowSet r = DBUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[0]);
                        if (r.next()) {
                            String id = r.getString("id");
                            newEI.setSupplyOrgUnit(is.getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic));
                        }
                        if (bom.getStorageOrgUnit().getId().toString().equals(newEI.getSupplyOrgUnit().getId().toString())) {
                            newEI.setProvideType(MaterialProvideTypeEnum.CURRENTORGPROVIDE);
                        } else {
                            newEI.setProvideType(MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE);
                        }
                    }
                    if (MaterialIssueModeEnum.STRAIGHT.equals((Object)(issMode = newEI.getIssMode()))) {
                        newEI.setIssMode(MaterialIssueModeEnum.PRODUCEISSMODE);
                    }
                    newEI.setConsumeFixBaseQty(quota);
                    newEI.setConsumeFixQty(quota);
                    newEI.setDesignRemark(newEI.getDesignRemark() + " \u7531\u5de5\u5e8fBOM\u65b0\u589e");
                    bom.getEntrys().add(newEI);
                }
                updates.add(bom);
            }
            int err = 0;
            if (updates.size() > 0) {
                int size = updates.size();
                for (int i = 0; i < size; ++i) {
                    BomInfo bom = updates.get(i);
                    int jsize = bom.getEntrys().size();
                    for (int j = 0; j < jsize; ++j) {
                        BomEntryInfo ei = bom.getEntrys().get(j);
                        if (ei.getConsumeFixBaseQty() == null) {
                            ei.setConsumeFixBaseQty(new BigDecimal("0.00"));
                        }
                        if (ei.getConsumeFixQty() != null) continue;
                        ei.setConsumeFixQty(new BigDecimal("0.00"));
                    }
                }
            }
            System.out.println(err);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void expandCars() throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("create table temptable (");
        sql.append(" FProjectID VARCHAR(44) Not Null\r\n");
        sql.append(" ,FTrackID VARCHAR(44) Not Null\r\n");
        sql.append(" ,FTrackNumber NVARCHAR(100) Null\r\n");
        sql.append(" ,FMaterialID VARCHAR(44) Not Null\r\n");
        sql.append(" ,FBomID VARCHAR(44) Null\r\n");
        sql.append(")");
        if (!StringUtils.isEmpty((String)this.tempTableName_cars)) {
            this.releaseTempTable(this.ctx, this.tempTableName_cars);
        }
        this.tempTableName_cars = this.createTempTable(this.ctx, sql.toString());
        sql.setLength(0);
        sql.append("insert into ").append(this.tempTableName_cars).append(" (");
        sql.append(" FProjectID");
        sql.append(" ,FTrackID");
        sql.append(" ,FTrackNumber");
        sql.append(" ,FMaterialID");
        sql.append(" ,FBomID");
        sql.append(") select distinct");
        sql.append(" car.fprojectid");
        sql.append(",track.fid");
        sql.append(",track.fnumber");
        sql.append(" from T_MM_ProjectCar car ");
        sql.append(" left join T_MM_TrackNumber track on car.ftracknumberid = track.fid ");
        sql.append(",").append(this.tempTableName_BOM).append(" bom");
        sql.append(",").append(this.tempTableName_PBOM).append(" pbom");
        sql.append(" where car.fprojectid = '").append(this.projectid).append("'");
        sql.append(" ");
        sql.append(" order by ");
        sql.append(",car.fprojectid");
        sql.append(",track.fnumber ASC");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
        ProjectCarCollection cars = this.getCars();
        this.tracks.clear();
        int size = cars.size();
        for (int i = 0; i < size; ++i) {
            ProjectCarInfo car = cars.get(i);
            TrackNumberInfo t = car.getTrackNumber();
            if (t == null) continue;
            this.tracks.put(t.getId().toString(), t);
        }
    }

    protected ProjectCarCollection getCars() throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("project.id", (Object)this.projectid));
        SorterItemCollection sorters = new SorterItemCollection();
        SorterItemInfo sorter = new SorterItemInfo("project.id");
        sorter.setSortType(SortType.ASCEND);
        sorters.add(sorter);
        sorter = new SorterItemInfo("trackNumber.number");
        sorter.setSortType(SortType.ASCEND);
        sorters.add(sorter);
        evi.setSorter(sorters);
        ProjectCarCollection cars = ProjectCarFactory.getLocalInstance((Context)this.ctx).getProjectCarCollection(evi);
        return cars;
    }

    protected void expandPBOM() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("create table pbomtemptable (FID VARCHAR(200) Null\r\n");
        sql.append(" ,FPBOMID VARCHAR(44) Null\r\n");
        sql.append(" ,FPBOMENTRYID VARCHAR(44) Null\r\n");
        sql.append(" ,FBOMID VARCHAR(44) Null\r\n");
        sql.append(" ,FSTrackID VARCHAR(44) Null\r\n");
        sql.append(" ,FSTrackNumber VARCHAR(44) Null\r\n");
        sql.append(" ,FETrackID VARCHAR(44) Not Null\r\n");
        sql.append(" ,FETrackNumber NVARCHAR(100) Null\r\n");
        sql.append(" ,FConsumeQuota Numeric(21,8) Default 0 Not Null\r\n");
        sql.append(" ,FProjectID VARCHAR(44) Null\r\n");
        sql.append(" ,FTrackID VARCHAR(44) Null\r\n");
        sql.append(" ,FTrackNumber NVARCHAR(100) Null");
        sql.append(" ,FMaterialID VARCHAR(44) Not Null\r\n");
        sql.append(")");
        if (!StringUtils.isEmpty((String)this.tempTableName_PBOM)) {
            this.releaseTempTable(this.ctx, this.tempTableName_PBOM);
        }
        this.tempTableName_PBOM = this.createTempTable(this.ctx, sql.toString());
        sql.setLength(0);
        sql.append("insert into ").append(this.tempTableName_PBOM).append(" (FID");
        sql.append(" ,FPBOMID,FPBOMENTRYID");
        sql.append(" ,FBOMID");
        sql.append(" ,FMaterialID");
        sql.append(" ,FSTrackID,FSTrackNumber");
        sql.append(" ,FETrackID ,FETrackNumber");
        sql.append(" ,FProjectID ,FTrackID ,FTrackNumber");
        sql.append(" ,FConsumeQuota");
        sql.append(")");
        sql.append(" select '1'");
        sql.append(" ,pb.FID FPBOMID").append(" ,pbe.FID FPBOMENTRYID");
        sql.append(" ,bom.FID");
        sql.append(" ,pbe.cfmaterialid");
        sql.append(" ,pbes.FID FSTrackID").append(" ,pbes.FNumber FSTrackNumber");
        sql.append(" ,pbee.FID FETrackID").append(" ,pbee.FNumber FETrackNumber");
        sql.append(" ,pb.FProjectID").append(" ,pbeTrack.FID FTrackID").append(" ,pbeTrack.FNumber FTrackNumber");
        sql.append(" ,sum(pbe.CFConsumeQuota)");
        sql.append(" from ");
        sql.append(" T_MM_PBOM pb ");
        sql.append(" left join T_MM_PBOMEntry pbe on pb.FID = pbe.fparentid ");
        sql.append(" inner join T_MM_BOM bom on pbe.CFBOMID = bom.FID and bom.fprojectid = pb.fprojectid");
        sql.append(" left join T_MM_TrackNumber pbes on pbe.CFSTraceID = pbes.FID");
        sql.append(" left join T_MM_TrackNumber pbee on pbe.CFETraceID = pbee.FID");
        sql.append(" ,T_MM_ProjectCar car left join T_MM_TrackNumber pbeTrack on pbeTrack.fid = car.ftrackNumberid  ");
        sql.append(" where 1=1 ");
        sql.append(" and pbes.FNumber <= pbeTrack.FNumber and pbee.FNumber >= pbeTrack.FNumber");
        sql.append(" and t_mm_pbom.fprojectid = '").append(this.projectid).append("' ");
        sql.append(" group by ");
        sql.append(" pb.FID FPBOMID").append(",pbe.FID FPBOMENTRYID");
        sql.append(" ,bom.FID");
        sql.append(" ,pbe.cfmaterialid");
        sql.append(" ,pbes.FID FSTrackID").append(" ,pbes.FNumber FSTrackNumber");
        sql.append(" ,pbee.FID FETrackID").append(" ,pbee.FNumber FETrackNumber");
        sql.append(" ,pb.FProjectID").append(",pbeTrack.FID FTrackID").append(",pbeTrack.FNumber FTrackNumber");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    protected void expandBOM() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Create Table ExpandBOMTable(\r\n");
        sql.append("FID NVARCHAR(200) Not Null,\r\n");
        sql.append("FBOMID VARCHAR(44) Not Null,\r\n");
        sql.append("FBOMENTRYID VARCHAR(44) Not Null,\r\n");
        sql.append("FMaterialID VARCHAR(44) Not Null,\r\n");
        sql.append("FProjectID VARCHAR(44) Not Null,\r\n");
        sql.append("FProjectNumber VARCHAR(100) Null,\r\n");
        sql.append("FProjectName VARCHAR(100) Null,\r\n");
        sql.append("FTrackID VARCHAR(44) Not Null,\r\n");
        sql.append("FTrackNumber NVARCHAR(80) Not Null,\r\n");
        sql.append("FSTrackID VARCHAR(44) Not Null,\r\n");
        sql.append("FSTrackNumber NVARCHAR(80) Not Null,\r\n");
        sql.append("FETrackID VARCHAR(44) Not Null,\r\n");
        sql.append("FETrackNumber NVARCHAR(80) Not Null,\r\n");
        sql.append("FConsumeFixQTY Numeric(21,8) Default 0 Not Null,");
        sql.append(")");
        if (!StringUtils.isEmpty((String)this.tempTableName_BOM)) {
            this.releaseTempTable(this.ctx, this.tempTableName_BOM);
        }
        this.tempTableName_BOM = this.createTempTable(this.ctx, sql.toString());
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("insert into ").append(this.tempTableName_BOM).append(" (");
        sql.append("FID");
        sqlStr.append(",FBOMID");
        sqlStr.append(",FBOMENTRYID");
        sqlStr.append(",FMaterialID");
        sqlStr.append(",FProjectID");
        sqlStr.append(",FProjectNumber");
        sqlStr.append(",FProjectName");
        sqlStr.append(",FTrackID");
        sqlStr.append(",FTrackNumber");
        sqlStr.append(",FSTrackID");
        sqlStr.append(",FSTrackNumber");
        sqlStr.append(",FETrackID");
        sqlStr.append(",FETrackNumber");
        sqlStr.append(",FConsumeFixQTY");
        sqlStr.append(") select ");
        sqlStr.append(" rownum");
        sqlStr.append(",t.fid");
        sqlStr.append(",e.fid");
        sqlStr.append(",e.fmaterialid");
        sqlStr.append(",t.fprojectid");
        sqlStr.append(",project.fnumber");
        sqlStr.append(",project.fname_l2");
        sqlStr.append(",track.fid");
        sqlStr.append(",track.fnumber");
        sqlStr.append(",stn.fid");
        sqlStr.append(",stn.fnumber");
        sqlStr.append(",etn.fid");
        sqlStr.append(",etn.fnumber");
        sqlStr.append(",isnull(e.FConsumeFixQTY,0)");
        sqlStr.append(" from T_MM_Bom t left join T_MM_BomEntry e on e.fparentid = t.fid");
        sqlStr.append(" left join T_MM_Project project on project.fid = t.fprojectid");
        sqlStr.append(" left Join T_MM_TrackNumber stn on stn.FID=e.CFBeginCarnoID");
        sqlStr.append(" left Join T_MM_TrackNumber etn on etn.FID=e.CFEndCarnoID");
        sqlStr.append(" ,T_MM_ProjectCar car left join T_MM_TrackNumber track on track.fid = car.ftrackNumberid ");
        sqlStr.append(" where stn.FNumber <= track.FNumber and etn.FNumber >= track.FNumber ");
        sqlStr.append(" and exists (select fid from ").append(this.tempTableName_PBOM).append(" where t.fid = FBomID)");
    }

    private String createTempTable(Context ctx, String createTableSQL) throws BOSException {
        TempTablePool pool = this.getTempTablePool();
        try {
            return pool.createTempTable(createTableSQL);
        }
        catch (Exception e) {
            throw new BOSException("\u521b\u5efa\u4e34\u65f6\u8868\u51fa\u9519", (Throwable)e);
        }
    }

    protected TempTablePool getTempTablePool() {
        if (this.pool == null) {
            this.pool = TempTablePool.getInstance((Context)this.ctx);
        }
        return this.pool;
    }

    private void releaseTempTable(Context ctx, String tableName) {
        TempTablePool pool = this.getTempTablePool();
        pool.releaseTable(tableName);
    }

    public void finallys() {
    }
}

