/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.WIPTransferRuleCollection;
import com.kingdee.eas.mm.basedata.WIPTransferRuleFactory;
import com.kingdee.eas.mm.basedata.WIPTransferRuleInfo;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.basedata.app.AbstractWIPTransferRuleControllerBean;
import com.kingdee.eas.mm.basedata.app.MMServerUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WIPTransferRuleControllerBean
extends AbstractWIPTransferRuleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.basedata.app.WIPTransferRuleControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WIPTransferRuleInfo objValue = (WIPTransferRuleInfo)model;
        if (MMBasedataStatusEnum.ADDNEW.equals((Object)objValue.getStatus())) {
            StorageOrgUnitInfo storageOrgUnitInfo = objValue.getStorageOrgUnit();
            WorkCenterInfo workCenterInfo = objValue.getWorkCenter();
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            if (workCenterInfo != null) {
                filter.getFilterItems().add(new FilterItemInfo("workCenter.id", (Object)workCenterInfo.getId().toString(), CompareType.EQUALS));
            }
            ev.setFilter(filter);
            WIPTransferRuleCollection coll = this.getWIPTransferRuleCollection(ctx, ev);
            if (coll.size() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.mm.basedata.EMMEMBasedataResource", (String)"EM_YCZZHGZ", (Locale)ctx.getLocale())));
            }
        }
        objValue.setStatus(MMBasedataStatusEnum.SAVED);
        return super._submit(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StorageOrgUnitInfo sInfo = WIPTransferRuleFactory.getLocalInstance(ctx).getWIPTransferRuleInfo(pk).getStorageOrgUnit();
        if (sInfo != null) {
            MMServerUtils.checkPermission((Context)ctx, (IObjectPK)new ObjectUuidPK(sInfo.getId()), (String)"WIPTransferRule_delete");
        }
        super._delete(ctx, pk);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        WIPTransferRuleInfo objValue = (WIPTransferRuleInfo)model;
        ObjectUuidPK orgPK = new ObjectUuidPK(objValue.getStorageOrgUnit().getId());
        MMServerUtils.checkPermission((Context)ctx, (IObjectPK)orgPK, (String)"WIPTransferRule_cancel");
        objValue.setStatus(MMBasedataStatusEnum.CLOSE);
        super._cancel(ctx, pk, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        WIPTransferRuleInfo objValue = (WIPTransferRuleInfo)model;
        ObjectUuidPK orgPK = new ObjectUuidPK(objValue.getStorageOrgUnit().getId());
        MMServerUtils.checkPermission((Context)ctx, (IObjectPK)orgPK, (String)"WIPTransferRule_cancelCancel");
        StorageOrgUnitInfo storageOrgUnitInfo = objValue.getStorageOrgUnit();
        WorkCenterInfo workCenterInfo = objValue.getWorkCenter();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(new Integer(10));
        statusList.add(new Integer(20));
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        if (workCenterInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("workCenter.id", (Object)workCenterInfo.getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("status", new HashSet(statusList), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)objValue.getId().toString(), CompareType.NOTEQUALS));
        ev.setFilter(filter);
        WIPTransferRuleCollection coll = this.getWIPTransferRuleCollection(ctx, ev);
        if (coll.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.mm.basedata.EMMEMBasedataResource", (String)"EM_YCZZHGZ", (Locale)ctx.getLocale())));
        }
        objValue.setStatus(MMBasedataStatusEnum.OPEN);
        super._cancelCancel(ctx, pk, model);
    }
}

