/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.CalculateResultScopeVO;
import com.kingdee.eas.mm.mo.DeliveryPlanSingletonFactory;
import com.kingdee.eas.mm.mo.app.AbstractCalculateResultScope;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CalculateStockScopeServiceOld
extends AbstractCalculateResultScope {
    private Object[] paramobj = null;
    private List<String> tmpTables = new ArrayList<String>();

    @Override
    public String getSql() {
        String x_table = "select b.fprojectid projectid,b.ftrackid trackid,a.fstorageorgunitid porgid,b.fstorageorgunitid orgid,d.fstorageorgunitid workorgid,a.fmaterialid materialid, isnull(c.cfdistributionorder,0) fdistributionorder ,case when c.cfarrivedays is null then 0 else c.cfarrivedays*-1 end days, a.fplannedqty-a.factissueqty qty,to_char(a.fdemandtime, 'yyyy-MM-dd') demandtime from t_mm_mftorderstock a left join t_mm_manufactureorder b on b.fid = a.fparentid left join t_mm_mftordertechnics d on a.foperationid = d.foperationid and a.fparentid = d.fparentid left join ct_pur_setpmade c on b.fstorageorgunitid = c.cfproductorgid left join ct_pur_setpmad f on c.fparentid = f.fid where d.fbasestatus in (4,5,8,90,10,11,12,13,14,15,16,17,18,20,21,22,23,24,26) and f.fcontrolunitid = b.fcontrolunitid and a.fmaterialid is not null and a.fdemandtime between ? and ? and a.fstorageorgunitid in (select fstorageorgunitid from #TMPTABLE#)";
        String y_table = "select projectid,trackid,porgid,orgid,workorgid,materialid,fdistributionorder,demandtime,days,sum(qty) qty from (" + x_table + ") x where x.qty>0 group by projectid,materialid,fdistributionorder,trackid,days,porgid,orgid,workorgid,demandtime order by fdistributionorder desc,demandtime";
        return y_table;
    }

    @Override
    public Object[] getParmaObj() {
        return this.paramobj;
    }

    @Override
    public String initParamObj(Context ctx, String _sql, List<Object> _paramobj) throws BOSException, EASBizException {
        this.paramobj = _paramobj.toArray();
        Date[] dates = this.getReviseTime((Date)this.paramobj[0], (Date)this.paramobj[1]);
        Object[] tmpObj = new Object[]{dates[0], dates[1]};
        ctx.put((Object)"START", (Object)dates[0]);
        ctx.put((Object)"END", (Object)dates[1]);
        ctx.put((Object)"SUPPLYMETHOD", this.paramobj[3]);
        ctx.put((Object)"PURMETHOD", this.paramobj[4]);
        ArrayList list = (ArrayList)this.paramobj[2];
        String motMergeTempTable = this.createStorageTempTable(ctx);
        String insertSql = this.insertMOTMergeTempTableSQL(motMergeTempTable);
        try {
            if (list != null && list.size() > 0) {
                for (int n = 0; n < list.size(); ++n) {
                    DbUtil.execute((Context)ctx, (String)insertSql, (Object[])new Object[]{list.get(n)});
                }
            } else {
                String allsql = "select fid from t_org_storage";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)allsql);
                while (rs.next()) {
                    String fid = rs.getString("fid");
                    DbUtil.execute((Context)ctx, (String)insertSql, (Object[])new Object[]{fid});
                }
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        _sql = _sql.replaceAll("#TMPTABLE#", motMergeTempTable);
        this.paramobj = tmpObj;
        return _sql;
    }

    @Override
    public boolean isValidateData(Context ctx, CalculateResultScopeVO vo) throws BOSException, EASBizException {
        return DeliveryPlanSingletonFactory.getDirectMaterialSingleton(ctx).isDirectMaterial(vo.getMaterialid(), vo.getProjectid(), vo.getTracknumberid());
    }

    private Date[] getReviseTime(Date startDate, Date endDate) throws BOSException, EASBizException {
        Date[] arraysdate = new Date[2];
        try {
            String defaultStartDate;
            SimpleDateFormat _sdf;
            SimpleDateFormat sdf;
            if (startDate != null) {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                _sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                defaultStartDate = sdf.format(startDate);
                defaultStartDate = defaultStartDate + " 00:00:00";
                startDate = _sdf.parse(defaultStartDate);
            }
            if (endDate != null) {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                _sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                defaultStartDate = sdf.format(endDate);
                defaultStartDate = defaultStartDate + " 23:59:59";
                endDate = _sdf.parse(defaultStartDate);
            }
            arraysdate[0] = new Timestamp(startDate.getTime());
            arraysdate[1] = new Timestamp(endDate.getTime());
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return arraysdate;
    }

    protected String createStorageTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MOTMergeTempTable(\r\n");
        sql.append("FStorageOrgUnitID VARCHAR(44) Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FStorageOrgUnitID", false, false);
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "IsNull(FStorageOrgUnitID,'Null')", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.tmpTables.add(tempTableName);
        return tempTableName;
    }

    protected String insertMOTMergeTempTableSQL(String mergeMOTTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(mergeMOTTempTable).append("(\r\n");
        sql.append("FStorageOrgUnitID\r\n");
        sql.append(") values (?)\r\n");
        return sql.toString();
    }

    @Override
    public List<String> getTmpTables() {
        return this.tmpTables;
    }

    @Override
    public String getDemandSql() {
        return null;
    }

    @Override
    public List<String> getSupplyOrgUnitString() {
        return null;
    }
}

