/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.report.AssemblyWorkshopStartScheduleControl;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class AssemblyWorkshopStartScheduleServer
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)AssemblyWorkshopStartScheduleServer.class.getName());
    public static final String PROJECT_NAME = "PROJECT_NAME";
    public static final String TRACKNUMBER = "TRACKNUMBER_NUMBER";
    public static final String TRACKNUMBER_CONTRAST = "TRACKNUMBER_contrast";
    public static final String PRODUCT_NAME = "PRODUCT_NAME";
    public static final String PRODUCT_NUMBER = "DRAWING_NUMBER";
    public static final String INDEPENDENT_NAME = "INDEPENDENT_NAME";
    public static final String WORKCENTER_NAME = "WORKCENTER_NAME";
    public static final String DELIVERY_QTY = "DELIVERY_QTY";
    private final String locatName = this.getContext().getLocale().toString();
    private int month = 0;
    private int maxDay = 0;

    private String getResourceInfo(String resourceName) {
        return AssemblyWorkshopStartScheduleControl.getResourceInfo(resourceName);
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        this.initParam(filter);
        ReportHeader reportHeader = new ReportHeader();
        reportHeader.addChild(PROJECT_NAME, this.getResourceInfo(PROJECT_NAME));
        reportHeader.addChild(TRACKNUMBER, this.getResourceInfo(TRACKNUMBER));
        reportHeader.addChild(TRACKNUMBER_CONTRAST, this.getResourceInfo(TRACKNUMBER_CONTRAST));
        reportHeader.addChild(PRODUCT_NAME, this.getResourceInfo(PRODUCT_NAME));
        reportHeader.addChild(PRODUCT_NUMBER, this.getResourceInfo(PRODUCT_NUMBER));
        reportHeader.addChild(INDEPENDENT_NAME, this.getResourceInfo(INDEPENDENT_NAME));
        reportHeader.addChild(WORKCENTER_NAME, this.getResourceInfo(WORKCENTER_NAME));
        if (this.maxDay > 0) {
            StringBuilder headerKey = new StringBuilder();
            StringBuilder headerShow = new StringBuilder();
            for (int i = 1; i <= this.maxDay; ++i) {
                headerKey.setLength(0);
                headerKey.append(DELIVERY_QTY).append(i);
                headerShow.setLength(0);
                headerShow.append(this.month).append("/").append(i);
                reportHeader.addChild(headerKey.toString(), headerShow.toString());
            }
        } else {
            reportHeader.addChild(DELIVERY_QTY, this.getResourceInfo(DELIVERY_QTY));
        }
        return reportHeader;
    }

    protected IRowSet getReportData(String arg0, RptParams rptparams) throws Exception {
        this.setSort(new Boolean(true));
        this.setSortClickType(new Integer(2));
        AssemblyWorkshopStartScheduleControl filterControl = new AssemblyWorkshopStartScheduleControl(rptparams);
        String resultSql = this.getResultSql(filterControl);
        IRowSet set = DbUtil.executeQuery((Context)this.getContext(), (String)resultSql.toString());
        return set;
    }

    protected ReportTitles getReportTitles(String arg0, RptParams params) throws BaseException {
        ReportTitles titles = new ReportTitles();
        AssemblyWorkshopStartScheduleControl.setReportTitles(titles, params);
        return titles;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tempTable;
        this.initParam(filter);
        AssemblyWorkshopStartScheduleControl filterControl = new AssemblyWorkshopStartScheduleControl(filter);
        String tempTableSql = this.createTempTableSql();
        try {
            tempTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(tempTableSql);
        }
        catch (Exception e) {
            throw new BaseException("create tempTable error : sql is [" + tempTableSql + "]", (Throwable)e);
        }
        String indexColumns = "DRAWING_NUMBER,PRODUCT_NAME,PROJECT_NAME";
        try {
            TempTablePool.getInstance((Context)this.getContext()).createIndex(tempTable, indexColumns, false, false);
        }
        catch (Exception e) {
            logger.error((Object)("create tempTable index error : index columns is [" + indexColumns + "]"), (Throwable)e);
        }
        this.insertDataToTempTable(tempTable, filterControl);
        return tempTable;
    }

    private String createTempTableSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append(PROJECT_NAME).append(" nvarchar(255)");
        sql.append(",\r\n").append(TRACKNUMBER).append(" nvarchar(255)");
        sql.append(",\r\n").append(TRACKNUMBER_CONTRAST).append(" nvarchar(255)");
        sql.append(",\r\n").append(PRODUCT_NAME).append(" nvarchar(255)");
        sql.append(",\r\n").append(PRODUCT_NUMBER).append(" nvarchar(255)");
        sql.append(",\r\n").append(INDEPENDENT_NAME).append(" nvarchar(255)");
        sql.append(",\r\n").append(WORKCENTER_NAME).append(" nvarchar(255)");
        if (this.maxDay > 0) {
            for (int i = 1; i <= this.maxDay; ++i) {
                sql.append(",\r\n").append(DELIVERY_QTY).append(i).append(" NUMERIC(21,8)");
            }
        } else {
            sql.append(",\r\n").append(DELIVERY_QTY).append(" NUMERIC(21,8)");
        }
        sql.append(")");
        return sql.toString();
    }

    private void insertDataToTempTable(String tempTable, AssemblyWorkshopStartScheduleControl filterControl) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(tempTable);
        insertSql.append("(").append(PROJECT_NAME);
        insertSql.append(",").append(TRACKNUMBER);
        insertSql.append(",").append(TRACKNUMBER_CONTRAST);
        insertSql.append(",").append(PRODUCT_NAME);
        insertSql.append(",").append(PRODUCT_NUMBER);
        insertSql.append(",").append(INDEPENDENT_NAME);
        insertSql.append(",").append(WORKCENTER_NAME);
        if (this.maxDay > 0) {
            for (int i = 1; i <= this.maxDay; ++i) {
                insertSql.append(",").append(DELIVERY_QTY).append(i);
            }
        }
        insertSql.append(") ");
        insertSql.append(" (").append(this.getResultSql(filterControl)).append(")");
        try {
            DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)("insert data to template table is error [" + insertSql.toString() + "]"), (Throwable)e);
        }
    }

    private String getResultSql(AssemblyWorkshopStartScheduleControl filterControl) {
        StringBuilder sql = new StringBuilder();
        StringBuilder from = new StringBuilder();
        StringBuilder where = new StringBuilder();
        StringBuilder group = new StringBuilder(" group by ");
        StringBuilder order = new StringBuilder(" order by ");
        sql.append("select ");
        sql.append("project.fname_").append(this.locatName).append(" as ").append(PROJECT_NAME);
        group.append(" project.fname_").append(this.locatName);
        order.append(" project.fname_").append(this.locatName);
        sql.append(",trackBegin.FNumber as ").append(TRACKNUMBER);
        group.append(",trackBegin.FNumber");
        sql.append(",trackContrast.FNumber as ").append(TRACKNUMBER_CONTRAST);
        group.append(",trackContrast.FNumber");
        sql.append(",product.fname_").append(this.locatName).append(" as ").append(PRODUCT_NAME);
        group.append(",product.fname_").append(this.locatName);
        sql.append(",product.fnumber as ").append(PRODUCT_NUMBER);
        group.append(",product.fnumber");
        order.append(",product.fnumber");
        sql.append(",independent.fname_").append(this.locatName).append(" as ").append(INDEPENDENT_NAME);
        group.append(",independent.fname_").append(this.locatName);
        sql.append(",workCenter.fname_").append(this.locatName).append(" as ").append(WORKCENTER_NAME);
        group.append(",workCenter.fname_").append(this.locatName);
        from.append(" from T_MM_ManufactureOrder MANUFACTUREORDER");
        from.append(" LEFT JOIN T_MM_Project project").append(" ON MANUFACTUREORDER.FProjectID = project.fid");
        from.append(" LEFT JOIN T_BD_Material product").append(" ON MANUFACTUREORDER.FMaterialID = product.FID");
        from.append(" LEFT JOIN T_BD_Material independent").append(" ON MANUFACTUREORDER.CFMaunMaterialID = independent.FID");
        from.append(" LEFT JOIN T_MM_TrackNumber trackBegin").append(" ON MANUFACTUREORDER.FTrackID = trackBegin.FID");
        from.append(" LEFT JOIN T_EMM_TrackNumberAssociation trackAssociation").append(" ON trackBegin.FID = trackAssociation.FEleTrackNumberID");
        from.append(" LEFT JOIN T_MM_TrackNumber trackContrast").append(" ON trackAssociation.FUniTrackNumberID = trackContrast.FID");
        from.append(" LEFT JOIN T_MM_MFTOrderTechnics technics").append(" ON MANUFACTUREORDER.fid = technics.fparentid").append(" and technics.fseq = 1");
        from.append(" LEFT JOIN T_MM_WorkCenter workCenter").append(" ON technics.FWorkcenterID = workCenter.fid");
        where.append(" where MANUFACTUREORDER.FBaseStatus in (").append(5).append(",").append(4).append(") ");
        if (filterControl != null) {
            where.append(" and YEAR(MANUFACTUREORDER.fplanBeginDate) = ").append(filterControl.getYear());
            where.append(" and MONTH(MANUFACTUREORDER.FplanBeginDate) = ").append(filterControl.getMonth());
            if (!StringUtil.isEmpty((String)filterControl.getStorageOrgUnitNum())) {
                from.append(" LEFT JOIN T_ORG_Storage storageOrg").append(" ON MANUFACTUREORDER.FStorageOrgUnitID = storageOrg.FID");
                where.append(" and storageOrg.fnumber = '").append(filterControl.getStorageOrgUnitNum()).append("'");
            }
            if (!StringUtil.isEmpty((String)filterControl.getAdminOrgUnitNum())) {
                from.append(" LEFT JOIN T_ORG_Admin adminOrg").append(" ON MANUFACTUREORDER.FAdminOrgUnitID = adminOrg.FID");
                where.append(" and adminOrg.fnumber = '").append(filterControl.getAdminOrgUnitNum()).append("'");
            }
            if (!StringUtil.isEmpty((String)filterControl.getProjectNum())) {
                where.append(" and project.fnumber = '").append(filterControl.getProjectNum()).append("'");
            }
            if (!StringUtil.isEmpty((String)filterControl.getTracknumberNum())) {
                where.append(" and trackBegin.fnumber = '").append(filterControl.getTracknumberNum()).append("'");
            }
        }
        if (this.maxDay > 0) {
            for (int i = 1; i <= this.maxDay; ++i) {
                sql.append(",SUM(");
                sql.append("case DAYOFMONTH(MANUFACTUREORDER.FplanBeginDate)").append(" when ").append(i).append(" then MANUFACTUREORDER.FQty else 0 end");
                sql.append(") as ").append(DELIVERY_QTY).append(i);
            }
        }
        sql.append(from.toString()).append(where.toString()).append(group.toString()).append(order.toString());
        return sql.toString();
    }

    private void initParam(RptParams filter) {
        if (this.maxDay > 0) {
            return;
        }
        int year = AssemblyWorkshopStartScheduleControl.getYear(filter);
        this.month = AssemblyWorkshopStartScheduleControl.getMonth(filter);
        Calendar now = Calendar.getInstance();
        now.set(1, year);
        now.set(2, this.month - 1);
        this.maxDay = now.getActualMaximum(5);
    }
}

