/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.util.CommonUitl;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.report.ComprehAnalysisOfPMFilterControl;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ComprehAnalysisOfPMReportServer
extends ReportServerBase {
    private static final String BACK_QTY = "REJECTEDQTY";
    private static final String FIXED_QTY = "FIXED_QTY";
    private static final String GONGWEI = "GongWei";
    private static final String LACKS_STOCK_QTY = "LACKSSTOCKQTY";
    private static final String LF_FEED_QTY = "MATERIALFEEDINGQTY";
    private static Logger logger = Logger.getLogger((String)ComprehAnalysisOfPMReportServer.class.getName());
    private static final String MATERIAL_MODLE = "MATERIAL_MODEL";
    private static final String MATERIAL_NAME = "MATERIAL_NAME";
    private static final String MATERIAL_NUM = "MATERIAL_NUMBER";
    private static final String MATERIAL_PROP = "materialProp";
    private static final String MATERIAL_UNIT = "MATERIAL_UNIT";
    private static final String OPERATION_NAME = "OperationName";
    private static final String OPERATION_NUMBER = "OperationNumber";
    private static final String PICKING_DIFFERENCES = "PICKINGDIFFERENCES";
    private static final String PICKING_DIFFERENCES_RATE = "PICKINGDIFFERENCESRATE";
    private static final String PRODUCT_MODLE = "PRODUCT_MODLE";
    private static final String PRODUCT_NAME = "PRODUCT_NAME";
    private static final String PRODUCT_NUM = "PRODUCT_NUMBER";
    private static final String PRODUCT_UNIT = "PRODUCT_UNIT";
    private static final String REAL_QTY = "REAL_QTY";
    private static final String RECEIVING_QTY = "TOTALDIRECTRECEIVEQTY";
    private static final String resClassName = "com.kingdee.eas.mm.report.ReportResource";
    private static final String SHOULD_ISSUED_QTY = "SHOULD_ISSUED_QTY";
    private static final String STOCK_QTY = "STOCKQTY";
    private static final String WASTE_FEED_QTY = "FEEDINGQTY";
    private long lstart = System.currentTimeMillis();
    private static final String WorkCenter_Number = "WorkCenter_Number";
    private static final String WorkCenter_Name = "WorkCenter_Name";
    private static final String StorageOrgUnit = "StorageOrgUnit";
    private static final String OperationNo = "OperationNo";
    private static final String IssueMode = "IssueMode";
    private String workShopId;
    private static final String MaterialSum = "MaterialSum";
    private static final String PurPerson = "PurPerson";
    private static final String ShortageQty = "ShortageQty";
    private static final String OTHERORGQTY = "OtherOrgQty";
    private static final String COMPREHSTOCKQTY = "ComprehStockQty";
    private static final String COMPREHREQQTY = "ComprehReqQty";
    private static final String NOEXECPURPLANNOWQTY = "NoExecPurPlanNowQty";
    private static final String NOCLOSEPURORDERQTY = "NoClosePurOrderQty";
    private static final String PURRECNOEXECANDNOINQTY = "PurRecNoExecAndNoInQty";
    private static final String PROJECTNUMBER = "ProjectNumber";
    private static final String PROJECTNAME = "ProjectName";
    private static final String TRACKNUMBER = "TrackNumber";
    private static final String TRACKNAME = "TrackName";
    private static String storageOrgUnitNumber = null;
    private static String companyOrgUnitNumber = null;
    private String Resource_Name = "com.kingdee.eas.mm.report.EMMEMReportResource";

    private String getString(Context ctx, String name) {
        return EASResource.getString((String)this.Resource_Name, (String)name, (Locale)ctx.getLocale());
    }

    private String createTempAnalysisTableSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("ProjectNumber nvarchar(255)");
        sql.append(",\r\nProjectName nvarchar(255)");
        sql.append(",\r\nTrackNumber nvarchar(255)");
        sql.append(",\r\nTrackName nvarchar(255)");
        sql.append(",\r\nPRODUCT_NUMBER nvarchar(255)");
        sql.append(",\r\nPRODUCT_NAME nvarchar(255)");
        sql.append(",\r\nPRODUCT_MODLE nvarchar(255)");
        sql.append(",\r\nPRODUCT_UNIT nvarchar(255)");
        sql.append(",\r\nMATERIAL_NUMBER nvarchar(255)");
        sql.append(",\r\nMATERIAL_NAME nvarchar(255)");
        sql.append(",\r\nMATERIAL_MODEL nvarchar(255)");
        sql.append(",\r\nMATERIAL_UNIT nvarchar(255)");
        sql.append(",\r\nFIXED_QTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nSHOULD_ISSUED_QTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nREAL_QTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nREJECTEDQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nFEEDINGQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nMATERIALFEEDINGQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nTOTALDIRECTRECEIVEQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nPICKINGDIFFERENCES NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nPICKINGDIFFERENCESRATE NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nSTOCKQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nLACKSSTOCKQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nWLBKCQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nOperationNumber nvarchar(255)");
        sql.append(",\r\nOperationName nvarchar(255)");
        sql.append(",\r\nmaterialProp nvarchar(255)");
        sql.append(",\r\nGongWei nvarchar(255)");
        sql.append(",\r\nOperationNo nvarchar(255)");
        sql.append(",\r\nWorkCenter_Number nvarchar(255)");
        sql.append(",\r\nWorkCenter_Name nvarchar(255)");
        sql.append(",\r\nIssueMode nvarchar(255)");
        sql.append(",\r\nStorageOrgUnit nvarchar(255)");
        sql.append(",\r\nPurPerson nvarchar(255)");
        sql.append(",\r\nShortageQty NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nOtherOrgQty NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nComprehStockQty NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nComprehReqQty NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nNoExecPurPlanNowQty NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nNoClosePurOrderQty NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nPurRecNoExecAndNoInQty NUMERIC(21,8) DEFAULT 0");
        sql.append(")");
        return sql.toString();
    }

    private String getResourceInfo(Context ctx, String resourceName) {
        return EASResource.getString((String)resClassName, (String)resourceName, (Locale)ctx.getLocale());
    }

    private String getResultSql(ComprehAnalysisOfPMFilterControl filterControl) throws BOSException, EASBizException {
        boolean deffStatusAll;
        boolean baseStatusAll;
        this.GetStorageOrgUnit(filterControl);
        Boolean materialSumFlag = filterControl.getMaterialSum().equalsIgnoreCase("false");
        StringBuffer sql = new StringBuffer();
        StringBuffer group = new StringBuffer();
        sql.append("select * from( ");
        sql.append("select ");
        if (materialSumFlag.booleanValue()) {
            sql.append("pro.fnumber AS ").append(PROJECTNUMBER);
            group.append("pro.fnumber");
            sql.append(",pro.fname_l2 AS ").append(PROJECTNAME);
            group.append(",pro.fname_l2");
            sql.append(",tn.fnumber AS ").append(TRACKNUMBER);
            group.append(",tn.fnumber");
            sql.append(",tn.fname_l2 AS ").append(TRACKNAME);
            group.append(",tn.fname_l2");
            sql.append(",MATERIAL.FNumber AS ").append(PRODUCT_NUM);
            group.append(",MATERIAL.FNumber");
            sql.append(",MATERIAL.FName_l2 AS ").append(PRODUCT_NAME);
            group.append(",MATERIAL.FName_l2");
            sql.append(",MATERIAL.FModel AS ").append(PRODUCT_MODLE);
            group.append(",MATERIAL.FModel");
            sql.append(",BASEUNIT.FName_l2 AS ").append(PRODUCT_UNIT);
            group.append(",BASEUNIT.FName_l2");
            sql.append(",MATERIAL1.FNumber AS ").append(MATERIAL_NUM);
            group.append(",MATERIAL1.FNumber");
        } else {
            sql.append("MATERIAL1.FNumber AS ").append(MATERIAL_NUM);
            group.append("MATERIAL1.FNumber");
        }
        sql.append(",MATERIAL1.FName_l2 AS ").append(MATERIAL_NAME);
        group.append(",MATERIAL1.FName_l2");
        sql.append(",MATERIAL1.FModel AS ").append(MATERIAL_MODLE);
        group.append(",MATERIAL1.FModel");
        sql.append(",BASEUNIT1.FName_l2 AS ").append(MATERIAL_UNIT);
        group.append(",BASEUNIT1.FName_l2");
        sql.append(",SUM(isnull(STOCKS.FUnitQty,0)) AS ").append(FIXED_QTY);
        sql.append(",SUM(isnull(STOCKS.FPlannedQty,0)) AS ").append(SHOULD_ISSUED_QTY);
        sql.append(",SUM(isnull(STOCKS.FActIssueQty,0)) AS ").append(REAL_QTY);
        sql.append(",SUM(isnull(STOCKS.FRejectedQty,0)) AS ").append(BACK_QTY);
        sql.append(",SUM(isnull(STOCKS.FFeedingQty,0)) AS ").append(WASTE_FEED_QTY);
        sql.append(",SUM(isnull(STOCKS.FMaterialFeedingQty,0)) AS ").append(LF_FEED_QTY);
        sql.append(",SUM(isnull(STOCKS.FTotalDirectReceiveQty,0)) AS ").append(RECEIVING_QTY);
        String diffPickingSql = "isnull(STOCKS.FPlannedQty,0)+isnull(STOCKS.FRejectedQty,0)-isnull(STOCKS.FActIssueQty,0)-isnull(STOCKS.FFeedingQty,0)-isnull(STOCKS.FMaterialFeedingQty,0)";
        sql.append(",SUM(");
        sql.append("isnull(STOCKS.FPlannedQty,0)+isnull(STOCKS.FRejectedQty,0)-isnull(STOCKS.FActIssueQty,0)-isnull(STOCKS.FFeedingQty,0)-isnull(STOCKS.FMaterialFeedingQty,0)");
        sql.append(") AS ").append(PICKING_DIFFERENCES);
        sql.append(",round(case SUM(STOCKS.FPlannedQty) when 0 then 0 ");
        sql.append(" else SUM(");
        sql.append("isnull(STOCKS.FPlannedQty,0)+isnull(STOCKS.FRejectedQty,0)-isnull(STOCKS.FActIssueQty,0)-isnull(STOCKS.FFeedingQty,0)-isnull(STOCKS.FMaterialFeedingQty,0)");
        sql.append(")/SUM(STOCKS.FPlannedQty) ");
        sql.append(" end,6) AS ").append(PICKING_DIFFERENCES_RATE);
        sql.append(",MAX(inventory.").append(STOCK_QTY).append(") AS ").append(STOCK_QTY);
        sql.append(",SUM(");
        sql.append("isnull(STOCKS.FPlannedQty,0)+isnull(STOCKS.FRejectedQty,0)-isnull(STOCKS.FActIssueQty,0)-isnull(STOCKS.FFeedingQty,0)-isnull(STOCKS.FMaterialFeedingQty,0)");
        sql.append(")-MAX(inventory.").append(STOCK_QTY).append(") AS ").append(LACKS_STOCK_QTY);
        sql.append(" ,MAX(wlbinventory.WLBKCQTY) as WLBKCQTY");
        if (materialSumFlag.booleanValue()) {
            sql.append(" ,operation.fnumber As ").append(OPERATION_NUMBER);
            sql.append(" ,operation.fname_l2 As ").append(OPERATION_NAME);
        }
        sql.append(" ,(case bomentry.Fmaterialprop when 10010 then '" + this.getString(this.getContext(), "EM_GHJ") + "' when 10020 then '" + this.getString(this.getContext(), "EM_XNJ") + "'  when 10030 then '" + this.getString(this.getContext(), "EM_ZZJ") + "'  when 10040 then '" + this.getString(this.getContext(), "EM_WGJ") + "'  when 10050 then '" + this.getString(this.getContext(), "EM_WWJ") + "'   else '" + this.getString(this.getContext(), "EM_QT") + "'  end ) As ").append(MATERIAL_PROP);
        if (materialSumFlag.booleanValue()) {
            sql.append(" ,TECHNICS.cfgongwei As ").append(GONGWEI);
            sql.append(" ,TECHNICS.Foperationno As ").append(OperationNo);
            sql.append(" ,Workcenter.Fnumber As ").append(WorkCenter_Number);
            sql.append(" ,Workcenter.Fname_l2 As ").append(WorkCenter_Name);
            sql.append(" ,(case STOCKS.FIssueMode when 11010 then '" + this.getString(this.getContext(), "EM_SCLL") + "' when 11030 then '" + this.getString(this.getContext(), "EM_KB") + "' when 11050 then '" + this.getString(this.getContext(), "EM_ZS") + "' when 11040 then '" + this.getString(this.getContext(), "EM_BLL") + "' end) As ").append(IssueMode);
        }
        sql.append(" ,Storage.Fname_l2 As ").append(StorageOrgUnit);
        sql.append(" ,mt.personName As ").append(PurPerson);
        String shortageQty = " ,(case when SUM(isnull(STOCKS.FPlannedQty, 0)) -SUM(isnull(STOCKS.FActIssueQty, 0))-MAX(isnull(wlbinventory.WLBKCQTY,0)) - MAX(isnull(inventory.STOCKQTY,0)) < 0 then 0 else  SUM(isnull(STOCKS.FPlannedQty, 0)) -SUM(isnull(STOCKS.FActIssueQty, 0))-MAX(isnull(wlbinventory.WLBKCQTY,0)) - MAX(isnull(inventory.STOCKQTY,0)) end )";
        sql.append(" ,(case when SUM(isnull(STOCKS.FPlannedQty, 0)) -SUM(isnull(STOCKS.FActIssueQty, 0))-MAX(isnull(wlbinventory.WLBKCQTY,0)) - MAX(isnull(inventory.STOCKQTY,0)) < 0 then 0 else  SUM(isnull(STOCKS.FPlannedQty, 0)) -SUM(isnull(STOCKS.FActIssueQty, 0))-MAX(isnull(wlbinventory.WLBKCQTY,0)) - MAX(isnull(inventory.STOCKQTY,0)) end )");
        sql.append(" AS ").append(ShortageQty);
        sql.append(",MAX(isnull(allinventory.ALLCURSTOREQTY,0)) - MAX(isnull(wlbinventory.WLBKCQTY,0)) - MAX(isnull(inventory.STOCKQTY,0)) AS ").append(OTHERORGQTY);
        sql.append(",MAX(isnull(allinventory.ALLCURSTOREQTY,0)) AS ").append(COMPREHSTOCKQTY);
        sql.append(",MAX(isnull(purrequndown.UnTotalDownQty,0)) AS ").append(NOEXECPURPLANNOWQTY);
        sql.append(",MAX(isnull(purnoclose.NOCLOSEPUR,0)) AS ").append(NOCLOSEPURORDERQTY);
        sql.append(",MAX(isnull(purnoexecnoin.PurRecQty,0)) AS ").append(PURRECNOEXECANDNOINQTY);
        sql.append(",SUM( isnull(TBSTOCK.STOCKQTY,0)+isnull(TBREQ.REQISSUEQTY,0) + isnull(SONOOUT.SONOOUTQTY,0) + isnull(TBNCRREQ.NCRISSUEQTY,0))  AS ").append(COMPREHREQQTY);
        if (materialSumFlag.booleanValue()) {
            group.append(",operation.fnumber");
            group.append(",operation.fname_l2");
        }
        group.append(",bomentry.Fmaterialprop");
        if (materialSumFlag.booleanValue()) {
            group.append(",TECHNICS.cfgongwei");
            group.append(",TECHNICS.Foperationno");
            group.append(",Workcenter.Fnumber");
            group.append(",Workcenter.Fname_l2");
            group.append(",STOCKS.FIssueMode");
        }
        group.append(",Storage.Fname_l2");
        group.append(",mt.personName");
        sql.append(" FROM T_MM_ManufactureOrder AS MANUFACTUREORDER");
        if (materialSumFlag.booleanValue()) {
            sql.append(" left join t_mm_project AS pro on MANUFACTUREORDER.fprojectid = pro.fid ");
            sql.append(" left join t_mm_tracknumber  As tn on MANUFACTUREORDER.ftrackid = tn.fid ");
            sql.append(" INNER JOIN T_BD_MeasureUnit AS BASEUNIT");
            sql.append(" ON MANUFACTUREORDER.FBaseUnitID = BASEUNIT.FID");
            sql.append(" INNER JOIN T_BD_Material AS MATERIAL");
            sql.append(" ON MANUFACTUREORDER.FMaterialID = MATERIAL.FID");
        }
        sql.append(" INNER JOIN T_MM_MFTOrderStock AS STOCKS");
        sql.append(" ON MANUFACTUREORDER.FID = STOCKS.FParentID");
        sql.append(" INNER JOIN T_BD_MeasureUnit AS BASEUNIT1");
        sql.append(" ON STOCKS.FUnitID = BASEUNIT1.FID");
        sql.append(" INNER JOIN T_BD_Material AS MATERIAL1");
        sql.append(" ON STOCKS.FMaterialID = MATERIAL1.FID");
        if (materialSumFlag.booleanValue()) {
            sql.append(" INNER JOIN t_mm_mftordertechnics AS TECHNICS");
            sql.append(" ON STOCKS.fparentid = TECHNICS.FParentID and STOCKS.foperationno = TECHNICS.foperationno ");
            sql.append(" Left outer JOIN t_mm_operation AS operation");
            sql.append(" ON TECHNICS.foperationid = operation.fid ");
        }
        sql.append(" Left outer JOIN t_mm_bomentry AS bomentry");
        sql.append(" ON STOCKS.fbomentryid = bomentry.fid ");
        if (materialSumFlag.booleanValue()) {
            sql.append(" INNER JOIN T_Mm_Workcenter AS Workcenter");
            sql.append(" ON TECHNICS.Fworkcenterid = Workcenter.FID");
        }
        sql.append(" INNER JOIN T_ORG_Storage AS Storage");
        sql.append(" ON STOCKS.FStorageOrgUnitID = Storage.FID");
        sql.append(" left join(");
        sql.append(" select APPOINTPURORGUNIT.fnumber,PURPERSON.Fname_l2 personName,PURCHASING.FMaterialID");
        sql.append(" from T_BD_Person PURPERSON");
        sql.append(" inner join T_BD_MaterialPurchasing PURCHASING");
        sql.append(" on PURCHASING.FPurPerson = PURPERSON.FID");
        sql.append(" INNER JOIN T_ORG_Purchase AS APPOINTPURORGUNIT");
        sql.append(" ON PURCHASING.FAppointPurOrgUnit = APPOINTPURORGUNIT.FID");
        sql.append(" where 1=1");
        sql.append("  ) mt on mt.FMaterialID=MATERIAL1.FID");
        if (storageOrgUnitNumber != null) {
            sql.append(" and mt.fnumber ='" + storageOrgUnitNumber + "'");
        } else {
            sql.append(" and mt.fnumber=Storage.fnumber ");
        }
        StringBuffer inventorySql = new StringBuffer("select ");
        inventorySql.append("TI.FMaterialID AS FMaterialID");
        inventorySql.append(",SUM(TI.FCurStoreQty) AS ").append(STOCK_QTY);
        inventorySql.append(" from T_IM_Inventory TI ").append(" \tinner join t_db_warehouse dw on dw.fid = ti.fwarehouseid and dw.FTransState = 1 and dw.FWhState = 1 ").append(" \tinner join CT_IN_Depottype dt on dt.fid = dw.cfdepottypeid and dt.cffattrible = 1 ");
        StringBuffer inventoryWhere = new StringBuffer(" where 1=1");
        if (!StringUtils.isEmpty((String)filterControl.getStorageOrgUnitNum())) {
            inventoryWhere.append(" and TI.FStorageOrgUnitID in (");
            inventoryWhere.append("select FID from T_ORG_Storage where FNumber = '").append(filterControl.getStorageOrgUnitNum()).append("'");
            inventoryWhere.append(")");
        }
        if (!StringUtils.isEmpty((String)filterControl.getMaterailNum())) {
            inventorySql.append(" LEFT JOIN T_BD_Material AS TM ON TI.FMaterialID = TM.FID ");
            inventoryWhere.append(" and TM.FNumber = '").append(filterControl.getMaterailNum()).append("'");
        }
        inventorySql.append(inventoryWhere.toString());
        inventorySql.append(" group by TI.FMaterialID");
        CommonUitl.getStorgOrgUnitIDFromCtx(this.getContext());
        StringBuffer wlbsql = new StringBuffer("select ");
        wlbsql.append("TI.FStorageOrgUnitID AS FStorageOrgUnitID");
        wlbsql.append(",TI.FMaterialID AS FMaterialID");
        wlbsql.append(",SUM(TI.FCurStoreQty) AS ").append("WLBKCQTY");
        wlbsql.append(" from T_IM_Inventory TI  inner join t_db_warehouse dw on dw.fid=ti.fwarehouseid and dw.FTransState = 1 and dw.FWhState = 1 inner join  CT_IN_Depottype dt on dt.fid=dw.cfdepottypeid and dt.cffattrible=1");
        StringBuffer wlbsqlWhere = new StringBuffer(" where 1=1 ");
        if (!StringUtils.isEmpty((String)filterControl.getMaterailNum())) {
            wlbsql.append(" LEFT JOIN T_BD_Material AS TM ON TI.FMaterialID = TM.FID ");
            wlbsqlWhere.append(" and TM.FNumber = '").append(filterControl.getMaterailNum()).append("'");
        }
        wlbsql.append(wlbsqlWhere.toString());
        wlbsql.append(" group by TI.FStorageOrgUnitID,TI.FMaterialID");
        sql.append(" left join (").append(inventorySql.toString()).append(") inventory");
        sql.append(" on STOCKS.FMaterialID = inventory.FMaterialID ");
        sql.append(" left join (").append(wlbsql.toString()).append(") wlbinventory");
        sql.append(" on stocks.fstorageOrgUnitID=wlbinventory.FStorageOrgUnitID  and STOCKS.FMaterialID = wlbinventory.FMaterialID ");
        sql.append(" left join (select TI.FMaterialID AS FMaterialID,SUM(TI.FCurStoreQty) AS ALLCURSTOREQTY from T_IM_Inventory TI  ").append(" \tinner join t_db_warehouse dw on dw.fid = ti.fwarehouseid and dw.FTransState = 1 and dw.FWhState = 1 ").append(" \tinner join CT_IN_Depottype dt on dt.fid = dw.cfdepottypeid and dt.cffattrible = 1 ").append(" where 1 = 1").append(" and TI.FCompanyOrgUnitID  ='").append(companyOrgUnitNumber).append("' group by TI.FMaterialID) allinventory on STOCKS.FMaterialID = allinventory.FMaterialID");
        sql.append(" left join (select puren.FMaterialID,SUM(puren.CFUnTotalDownQty) AS UnTotalDownQty  from T_SM_PurRequestEntry puren ").append(" inner join T_SM_PurRequest pur on puren.fparentid = pur.fid ").append(" where pur.FBaseStatus in( 1,2,4) ").append(" group by puren.FMaterialID").append(") purrequndown on STOCKS.FMaterialID = purrequndown.FMaterialID");
        sql.append(" left join (select poen.FMaterialID,SUM(poen.FQty-poen.FTotalReceiptQty) AS NOCLOSEPUR from T_SM_PurOrderEntry poen ").append(" where poen.FBaseStatus in( 1,2,4) ").append(" group by poen.FMaterialID").append(") purnoclose on STOCKS.FMaterialID = purnoclose.FMaterialID");
        sql.append(" left join (select pren.FMaterialID,SUM(pren.FQty-pren.FReceiptQty) AS PurRecQty from T_IM_PurReceivalEntry pren ").append(" inner join T_IM_PurReceivalBill pr on pren.fparentid = pr.fid ").append(" where pr.FBaseStatus in( 1,2,4) ").append(" group by pren.FMaterialID").append(") purnoexecnoin on STOCKS.FMaterialID = purnoexecnoin.FMaterialID");
        sql.append(" left join ( select stock.FMaterialID,SUM(isnull(stock.FplannedQty,0)-isnull(stock.FactIssueQty,0)) AS STOCKQTY from T_MM_MFTOrderStock stock ").append(" inner join T_MM_ManufactureOrder mo on stock.fparentid = mo.fid ").append(" inner JOIN T_MM_MFTOrderTechnics technics on mo.fid = technics.fparentid and stock.FOperationNo = technics.FOperationNo ").append(" where technics.FBaseStatus in( 4,5,14,24)  and isnull(stock.FplannedQty,0) > isnull(stock.FactIssueQty,0)").append(" group by stock.FMaterialID ").append(" ) TBSTOCK ON STOCKS.FMATERIALID = TBSTOCK.FMaterialID ");
        sql.append(" left join ( select mren.FMaterialID,SUM(isnull(mren.FissueQty,0)) AS REQISSUEQTY from T_IM_MaterialReqBill mr ").append(" inner join T_IM_MaterialReqBillEntry mren on mren.Fparentid = mr.Fid ").append(" left join T_SCM_BillType bt on bt.fid = mr.fsourcebilltypeid ").append(" where mr.fbasestatus in (1,2) AND bt.fnumber='160' ").append(" group by mren.FMaterialID ").append(" ) TBREQ ON STOCKS.FMaterialID = TBREQ.FMaterialID ");
        sql.append(" left join ( select soen.FMaterialID,SUM(isnull(soen.FQty,0) - isnull(soen.FtotalIssueQty,0)) AS SONOOUTQTY from T_SD_SaleOrder so ").append(" inner join T_SD_SaleOrderEntry soen on so.fid = soen.fparentid ").append(" left join T_ORG_UnitRelation ur on so.FSaleOrgUnitID = ur.ffromunitid ").append(" INNER JOIN T_ORG_TypeRelation tr on ur.FTypeRelationID = tr.FID ").append(" where so.fbasestatus=4 and ur.ftounitid ='").append(companyOrgUnitNumber).append("' ").append(" and tr.ffromtype=2 and tr.ftotype=1 ").append(" group by soen.fmaterialid ").append(" ) SONOOUT ON STOCKS.FMaterialID = SONOOUT.FMaterialID ");
        sql.append(" left join ( select mren.FMaterialID,SUM(isnull(mren.FissueQty,0)) AS NCRISSUEQTY from T_IM_MaterialReqBill mr ").append(" inner join T_IM_MaterialReqBillEntry mren on mren.Fparentid = mr.Fid ").append(" left join T_SCM_BillType bt on bt.fid = mr.fsourcebilltypeid ").append(" where mr.fbasestatus in (1,2) AND bt.fnumber='NCR' ").append(" group by mren.FMaterialID ").append(" ) TBNCRREQ ON STOCKS.FMaterialID = TBNCRREQ.FMaterialID ");
        StringBuffer where = new StringBuffer(" where 1=1 ");
        if (!StringUtils.isEmpty((String)filterControl.getStorageOrgUnitNum())) {
            where.append(" and MANUFACTUREORDER.FStorageOrgUnitID in (");
            where.append("select FID from T_ORG_Storage where FNumber = '").append(filterControl.getStorageOrgUnitNum()).append("'");
            where.append(")");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (filterControl.getBizDate() != null) {
            where.append(" and MANUFACTUREORDER.FBizDate >= {ts'").append(sdf.format(filterControl.getBizDate())).append("'}");
        }
        if (filterControl.getBizDate2() != null) {
            where.append(" and MANUFACTUREORDER.FBizDate <= {ts'").append(sdf.format(filterControl.getBizDate2())).append("'}");
        }
        if (!StringUtils.isEmpty((String)filterControl.getProductNum())) {
            where.append(" and MATERIAL.FNumber = '").append(filterControl.getProductNum()).append("'");
        }
        if (!StringUtils.isEmpty((String)filterControl.getMaterailNum())) {
            where.append(" and MATERIAL1.FNumber = '").append(filterControl.getMaterailNum()).append("'");
        }
        if (!StringUtils.isEmpty((String)filterControl.getProjectNum())) {
            Object[] arrProject = filterControl.getProjectNum().trim().replaceAll(" ", "").split(";");
            where.append(" and MANUFACTUREORDER.FProjectID in (");
            where.append("select FID from T_MM_Project where FNumber  in (").append(SQLUtil.arrayToString((Object[])arrProject)).append(")");
            where.append(")");
        }
        if (!StringUtils.isEmpty((String)filterControl.getTrackNum())) {
            where.append(" and MANUFACTUREORDER.FTrackID in (");
            where.append("select FID from T_MM_TrackNumber where FNumber = '").append(filterControl.getTrackNum()).append("'");
            where.append(")");
        }
        if (!StringUtils.isEmpty((String)filterControl.getZhujihua())) {
            where.append(" and MANUFACTUREORDER.FMpsId in (");
            where.append("select FID from CT_PS_MasterProductionSchedule where FNumber in (").append(filterControl.getZhujihua()).append(")");
            where.append(")");
        }
        if (!StringUtils.isEmpty((String)filterControl.getGongwei())) {
            where.append(" and TECHNICS.cfgongwei like '%").append(filterControl.getGongwei()).append("%'");
        }
        if (!StringUtils.isEmpty((String)filterControl.getWorkShop())) {
            String workShopNumStr = filterControl.getWorkShop();
            try {
                IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select wc.fid from T_Mm_Workcenter wc left join T_ORG_Storage tos on wc.fstorageorgunitid = tos.fid where wc.fnumber='" + workShopNumStr + "' and tos.fnumber='" + filterControl.getStorageOrgUnitNum() + "'"));
                while (rs.next()) {
                    this.workShopId = rs.getString("fid");
                }
                where.append(" and TECHNICS.fworkcenterid in (");
                where.append("(Select fid from T_Mm_Workcenter where T_Mm_Workcenter.fparentwcid='").append(this.workShopId).append("')");
                where.append(")");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.workShopId = null;
        }
        if (!StringUtils.isEmpty((String)filterControl.getOperaNo())) {
            where.append(" and TECHNICS.foperationno like '%").append(filterControl.getOperaNo()).append("%'");
        }
        if (!StringUtils.isEmpty((String)filterControl.getIssueMode()) && !filterControl.getIssueMode().equals("-1")) {
            where.append(" and STOCKS.FIssueMode = '").append(filterControl.getIssueMode()).append("'");
        }
        if (!StringUtils.isEmpty((String)filterControl.getWLBKC())) {
            where.append(" and STOCKS.FStorageOrgUnitID in(");
            where.append("select FID from T_ORG_Storage where FNumber = '").append(filterControl.getWLBKC()).append("'");
            where.append(")");
        }
        if (!StringUtils.isEmpty((String)filterControl.getPurPerson())) {
            where.append(" and mt.FID in(");
            where.append("select fid from T_BD_Person where fnumber = '").append(filterControl.getPurPerson()).append("'");
            where.append(")");
        }
        if (!StringUtils.isEmpty((String)filterControl.getMaterialProp()) && !filterControl.getMaterialProp().equals("-1")) {
            where.append(" and bomentry.Fmaterialprop = '").append(filterControl.getMaterialProp()).append("'");
        }
        StringBuffer baseStatusWhere = new StringBuffer();
        boolean bl = baseStatusAll = filterControl.isAuditedStatus() && filterControl.isCompleteStatus() && filterControl.isCloseStatus() && filterControl.isFinClosedStatus() && filterControl.isReleasedStatus() || !filterControl.isAuditedStatus() && !filterControl.isCompleteStatus() && !filterControl.isCloseStatus() && !filterControl.isFinClosedStatus() && !filterControl.isReleasedStatus();
        if (baseStatusAll || filterControl.isAuditedStatus()) {
            baseStatusWhere.append(",").append(4);
        }
        if (baseStatusAll || filterControl.isCloseStatus()) {
            baseStatusWhere.append(",").append(7);
        }
        if (baseStatusAll || filterControl.isCompleteStatus()) {
            baseStatusWhere.append(",").append(8);
        }
        if (baseStatusAll || filterControl.isFinClosedStatus()) {
            baseStatusWhere.append(",").append(11);
        }
        if (baseStatusAll || filterControl.isReleasedStatus()) {
            baseStatusWhere.append(",").append(5);
        }
        if (baseStatusWhere.length() > 0) {
            where.append(" and MANUFACTUREORDER.FBaseStatus in(");
            where.append(baseStatusWhere.substring(1));
            where.append(")");
        }
        StringBuffer diffStatusWhere = new StringBuffer();
        boolean bl2 = deffStatusAll = filterControl.isFullPicking() && filterControl.isLessPicking() && filterControl.isMuchPicking() || !filterControl.isFullPicking() && !filterControl.isLessPicking() && !filterControl.isMuchPicking();
        if (!deffStatusAll && filterControl.isFullPicking()) {
            diffStatusWhere.append(" or (");
            diffStatusWhere.append("isnull(STOCKS.FPlannedQty,0)+isnull(STOCKS.FRejectedQty,0)-isnull(STOCKS.FActIssueQty,0)-isnull(STOCKS.FFeedingQty,0)-isnull(STOCKS.FMaterialFeedingQty,0)");
            diffStatusWhere.append(") = 0");
        }
        if (!deffStatusAll && filterControl.isLessPicking()) {
            diffStatusWhere.append(" or (");
            diffStatusWhere.append("isnull(STOCKS.FPlannedQty,0)+isnull(STOCKS.FRejectedQty,0)-isnull(STOCKS.FActIssueQty,0)-isnull(STOCKS.FFeedingQty,0)-isnull(STOCKS.FMaterialFeedingQty,0)");
            diffStatusWhere.append(") > 0");
        }
        if (!deffStatusAll && filterControl.isMuchPicking()) {
            diffStatusWhere.append(" or (");
            diffStatusWhere.append("isnull(STOCKS.FPlannedQty,0)+isnull(STOCKS.FRejectedQty,0)-isnull(STOCKS.FActIssueQty,0)-isnull(STOCKS.FFeedingQty,0)-isnull(STOCKS.FMaterialFeedingQty,0)");
            diffStatusWhere.append(") < 0");
        }
        if (diffStatusWhere.length() > 0) {
            where.append(" and (1 != 1 ");
            where.append(diffStatusWhere.toString());
            where.append(")");
        }
        sql.append(where.toString());
        if (group.length() > 0) {
            sql.append(" group by ").append(group.toString());
        }
        sql.append(" ) newTable");
        boolean shortage = filterControl.IsShortage();
        if (shortage) {
            sql.append(" where ShortageQty>0");
        }
        return sql.toString();
    }

    private void insertDataToTempAnalysisTable(String tempTableName, ComprehAnalysisOfPMFilterControl filterControl) throws BOSException, EASBizException {
        Boolean materialSumFlag = filterControl.getMaterialSum().equalsIgnoreCase("false");
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into " + tempTableName + " ");
        if (materialSumFlag.booleanValue()) {
            insertSql.append("(ProjectNumber");
            insertSql.append(",ProjectName");
            insertSql.append(",TrackNumber");
            insertSql.append(",TrackName");
            insertSql.append(",PRODUCT_NUMBER");
            insertSql.append(",PRODUCT_NAME");
            insertSql.append(",PRODUCT_MODLE");
            insertSql.append(",PRODUCT_UNIT");
            insertSql.append(",MATERIAL_NUMBER");
        } else {
            insertSql.append("(MATERIAL_NUMBER");
        }
        insertSql.append(",MATERIAL_NAME");
        insertSql.append(",MATERIAL_MODEL");
        insertSql.append(",MATERIAL_UNIT");
        insertSql.append(",FIXED_QTY");
        insertSql.append(",SHOULD_ISSUED_QTY");
        insertSql.append(",REAL_QTY");
        insertSql.append(",REJECTEDQTY");
        insertSql.append(",FEEDINGQTY");
        insertSql.append(",MATERIALFEEDINGQTY");
        insertSql.append(",TOTALDIRECTRECEIVEQTY");
        insertSql.append(",PICKINGDIFFERENCES");
        insertSql.append(",PICKINGDIFFERENCESRATE");
        insertSql.append(",STOCKQTY");
        insertSql.append(",LACKSSTOCKQTY");
        insertSql.append(",WLBKCQTY");
        if (materialSumFlag.booleanValue()) {
            insertSql.append(",OperationNumber");
            insertSql.append(",OperationName");
        }
        insertSql.append(",materialProp");
        if (materialSumFlag.booleanValue()) {
            insertSql.append(",GongWei");
            insertSql.append(",OperationNo");
            insertSql.append(",WorkCenter_Number");
            insertSql.append(",WorkCenter_Name");
            insertSql.append(",IssueMode");
        }
        insertSql.append(",StorageOrgUnit");
        insertSql.append(",PurPerson");
        insertSql.append(",ShortageQty");
        insertSql.append(",OtherOrgQty");
        insertSql.append(",ComprehStockQty");
        insertSql.append(",NoExecPurPlanNowQty");
        insertSql.append(",NoClosePurOrderQty");
        insertSql.append(",PurRecNoExecAndNoInQty");
        insertSql.append(",ComprehReqQty");
        insertSql.append(") ");
        insertSql.append(this.getResultSql(filterControl));
        DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
    }

    private void lstop(String info) {
        long lstop = System.currentTimeMillis();
        logger.info((Object)("########### " + info + " : " + (lstop - this.lstart)));
    }

    private long restartTimeIndices() {
        this.lstart = System.currentTimeMillis();
        return this.lstart;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tempAnalysisTable;
        ComprehAnalysisOfPMFilterControl filterControl = new ComprehAnalysisOfPMFilterControl(filter);
        this.restartTimeIndices();
        String tempTableSql = this.createTempAnalysisTableSql();
        try {
            tempAnalysisTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(tempTableSql);
        }
        catch (Exception e) {
            throw new BaseException("create tempTable error : sql is [" + tempTableSql + "]", (Throwable)e);
        }
        this.lstop("createTempTable 'tempAnalysisTable'");
        String indexColumns = "PRODUCT_NUMBER,PRODUCT_NAME,MATERIAL_NUMBER,MATERIAL_NAME";
        try {
            TempTablePool.getInstance((Context)this.getContext()).createIndex(tempAnalysisTable, "PRODUCT_NUMBER,PRODUCT_NAME,MATERIAL_NUMBER,MATERIAL_NAME", false, false);
        }
        catch (Exception e) {
            throw new BaseException("create tempTable index error : index columns is [PRODUCT_NUMBER,PRODUCT_NAME,MATERIAL_NUMBER,MATERIAL_NAME]", (Throwable)e);
        }
        this.lstop("create tempAnalysisTable's index");
        this.insertDataToTempAnalysisTable(tempAnalysisTable, filterControl);
        this.lstop("insert tempAnalysisTable data");
        return tempAnalysisTable;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions reportFormatConditions = super.buildReportFormatConditions(reportID);
        return reportFormatConditions;
    }

    protected IRowSet getReportData(String s, RptParams rptparams) throws Exception {
        this.setSort(new Boolean(true));
        this.setSortClickType(new Integer(2));
        ComprehAnalysisOfPMFilterControl filterControl = new ComprehAnalysisOfPMFilterControl(rptparams);
        String resultSql = this.getResultSql(filterControl);
        IRowSet set = DbUtil.executeQuery((Context)this.getContext(), (String)resultSql.toString());
        return set;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        if (filter.getObject("materialSum") != null && filter.getObject("materialSum").equals("false")) {
            reportHeader.addChild(PROJECTNUMBER, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0026", (Locale)this.getContext().getLocale())).setWidth(140);
            reportHeader.addChild(PROJECTNAME, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0027", (Locale)this.getContext().getLocale())).setWidth(140);
            reportHeader.addChild(TRACKNUMBER, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0028", (Locale)this.getContext().getLocale())).setWidth(140);
            reportHeader.addChild(TRACKNAME, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0029", (Locale)this.getContext().getLocale())).setWidth(140);
            reportHeader.addChild(PRODUCT_NUM, this.getResourceInfo(this.getContext(), PRODUCT_NUM)).setWidth(140);
            reportHeader.addChild(PRODUCT_NAME, this.getResourceInfo(this.getContext(), PRODUCT_NAME)).setWidth(140);
        }
        reportHeader.addChild(MATERIAL_NUM, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0030", (Locale)this.getContext().getLocale())).setWidth(140);
        reportHeader.addChild(MATERIAL_NAME, this.getResourceInfo(this.getContext(), MATERIAL_NAME));
        reportHeader.addChild(MATERIAL_MODLE, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0004", (Locale)this.getContext().getLocale()));
        reportHeader.addChild(MATERIAL_UNIT, this.getResourceInfo(this.getContext(), MATERIAL_UNIT)).setWidth(160).setAlign(2);
        reportHeader.addChild(SHOULD_ISSUED_QTY, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0006", (Locale)this.getContext().getLocale())).setAlign(3);
        reportHeader.addChild(REAL_QTY, this.getResourceInfo(this.getContext(), REAL_QTY)).setAlign(3);
        reportHeader.addChild(PICKING_DIFFERENCES, this.getResourceInfo(this.getContext(), PICKING_DIFFERENCES)).setAlign(3);
        reportHeader.addChild(PICKING_DIFFERENCES_RATE, this.getResourceInfo(this.getContext(), PICKING_DIFFERENCES_RATE)).setAlign(3);
        reportHeader.addChild(StorageOrgUnit, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0010", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("WLBKCQTY", EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0011", (Locale)this.getContext().getLocale())).setAlign(3).setWidth(160);
        reportHeader.addChild(STOCK_QTY, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0012", (Locale)this.getContext().getLocale())).setAlign(3);
        reportHeader.addChild(ShortageQty, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0013", (Locale)this.getContext().getLocale())).setAlign(3);
        reportHeader.addChild(OTHERORGQTY, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0031", (Locale)this.getContext().getLocale())).setAlign(3);
        reportHeader.addChild(COMPREHSTOCKQTY, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0032", (Locale)this.getContext().getLocale())).setAlign(3);
        reportHeader.addChild(COMPREHREQQTY, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0033", (Locale)this.getContext().getLocale())).setAlign(3);
        reportHeader.addChild(NOEXECPURPLANNOWQTY, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0034", (Locale)this.getContext().getLocale())).setAlign(3);
        reportHeader.addChild(NOCLOSEPURORDERQTY, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0035", (Locale)this.getContext().getLocale())).setAlign(3);
        reportHeader.addChild(PURRECNOEXECANDNOINQTY, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0036", (Locale)this.getContext().getLocale())).setAlign(3);
        if (filter.getObject("materialSum") != null && filter.getObject("materialSum").equals("false")) {
            reportHeader.addChild(OperationNo, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0014", (Locale)this.getContext().getLocale())).setWidth(60);
            reportHeader.addChild(WorkCenter_Number, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0015", (Locale)this.getContext().getLocale()));
            reportHeader.addChild(WorkCenter_Name, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0016", (Locale)this.getContext().getLocale()));
            reportHeader.addChild(IssueMode, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0017", (Locale)this.getContext().getLocale()));
            reportHeader.addChild(OPERATION_NUMBER, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0018", (Locale)this.getContext().getLocale()));
            reportHeader.addChild(OPERATION_NAME, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0019", (Locale)this.getContext().getLocale()));
        }
        reportHeader.addChild(MATERIAL_PROP, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0020", (Locale)this.getContext().getLocale())).setWidth(80);
        if (filter.getObject("materialSum") != null && filter.getObject("materialSum").equals("false")) {
            reportHeader.addChild(GONGWEI, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0021", (Locale)this.getContext().getLocale()));
        }
        reportHeader.addChild(PurPerson, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0022", (Locale)this.getContext().getLocale()));
        return reportHeader;
    }

    private void GetStorageOrgUnit(ComprehAnalysisOfPMFilterControl filterControl) {
        if (!StringUtils.isEmpty((String)filterControl.getStorageOrgUnitNum())) {
            StringBuilder sql = new StringBuilder();
            sql.append(" select FID from T_ORG_Storage where FNumber = '").append(filterControl.getStorageOrgUnitNum()).append("'");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
                while (rs.next()) {
                    String storageOrgUnitID = rs.getString("FID");
                    if (storageOrgUnitID != null && !"".equals(storageOrgUnitID)) {
                        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)this.getContext());
                        OrgUnitCollection receiptOrgCol = iUnitRel.getToUnit(storageOrgUnitID, 4, 1);
                        companyOrgUnitNumber = ((CompanyOrgUnitInfo)receiptOrgCol.get(0)).getId().toString();
                    }
                    this.GetParam(storageOrgUnitID);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void GetParam(String FStorageOrgUnitID) throws EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Select PI.FValue_L2 FValue From T_BAS_PARAM P");
        sql.append(" Inner Join T_BAS_PARAMItem PI ");
        sql.append(" On PI.FKeyID=P.FID");
        sql.append(" Where FORGUnitID = '" + FStorageOrgUnitID + "' and P.FNumber='AOMES'");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
            while (rowset.next()) {
                String number = rowset.getString("FValue");
                if (number != null) {
                    // empty if block
                }
                sql.append("Select fid from T_ORG_Storage");
                sql.append(" where fnumber = '" + number + "'");
                IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
                while (rs.next()) {
                    storageOrgUnitNumber = rs.getString("fid");
                }
                if (rs.size() >= 1) continue;
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0023", (Locale)this.getContext().getLocale())));
            }
            if (rowset.size() >= 1) return;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return;
        }
        catch (EASBizException e) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0024", (Locale)this.getContext().getLocale()) + e.getMessage()));
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0024", (Locale)this.getContext().getLocale()) + e.getMessage()));
        }
    }

    protected ReportTitles getReportTitles(String s, RptParams rptparams) throws BaseException {
        ReportTitles titles = new ReportTitles();
        ComprehAnalysisOfPMFilterControl filterControl = new ComprehAnalysisOfPMFilterControl(rptparams);
        filterControl.setReportTitles(titles);
        return titles;
    }
}

