/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.IBomEntry;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.report.app.AbstractVarianceAnalysisReportFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.zjbom.app.util.BOMTreeUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VarianceAnalysisReportFacadeControllerBean
extends AbstractVarianceAnalysisReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.report.app.VarianceAnalysisReportFacadeControllerBean");
    private String RESURL = "com.kingdee.eas.mm.planning.EMMEMPlanningResource";
    private Set idSet = new HashSet();
    String sq = "";
    private String project = "";
    private String orgUnit = "";
    private String trackNumber = "";
    private String material = "";
    private String tempTable = "";
    private IBomEntry ibe;
    protected Set bomids = new HashSet();

    private String getString(Context ctx, String name) {
        return EASResource.getString((String)this.RESURL, (String)name, (Locale)ctx.getLocale());
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.expand_bom(ctx, params);
        this.update_bom(ctx, params);
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("materialNumber");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("materialName");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("materialModel");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("measureUnit");
        col.setWidth(80);
        header.addColumn(col);
        col = new RptTableColumn("productNumber");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("productName");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("pbomAmt");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("bomAmt");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("varianceType");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("bomFlow");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("materialSource");
        col.setWidth(120);
        col = new RptTableColumn("routingNumber");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("routingName");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("pmaterialNumber");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("pmaterialName");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("isWarehouse");
        col.setWidth(55);
        col.setWidth(55);
        header.setLabels((Object[][])new Object[][]{{EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0002", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0003", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0039", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0040", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0000", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0001", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0041", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0042", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0043", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0044", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0045", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0046", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0047", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0048", (Locale)ctx.getLocale())}});
        RptParams pp = new RptParams();
        pp.setString("tempTable", this.tempTable);
        pp.setObject("header", (Object)header);
        return pp;
    }

    protected void init_param(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.orgUnit = (String)params.getObjectElement("orgUnit");
        this.project = (String)params.getObjectElement("project");
        this.trackNumber = (String)params.getObjectElement("trackNumber");
        this.material = (String)params.getObjectElement("material");
        this.ibe = BomEntryFactory.getLocalInstance((Context)ctx);
        this.idSet.clear();
        this.bomids.clear();
    }

    protected BomEntryCollection query_bomEntry(Set materialSet) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.material.id", (Object)materialSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.basestatus", (Object)4));
        if (this.project != null && this.project != "") {
            filter.getFilterItems().add(new FilterItemInfo("parent.project.id", (Object)this.project, CompareType.EQUALS));
        }
        if (this.trackNumber != null && this.trackNumber != "") {
            filter.getFilterItems().add(new FilterItemInfo("beginCarno.number", (Object)this.trackNumber, CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endCarno.number", (Object)this.trackNumber, CompareType.GREATER_EQUALS));
        }
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("material.id"));
        evi.setSelector(sic);
        return this.ibe.getBomEntryCollection(evi);
    }

    protected void expand_bom(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.init_param(ctx, params);
        HashSet<String> materialSet = new HashSet<String>();
        materialSet.add(this.material);
        BomEntryCollection entrys = this.query_bomEntry(materialSet);
        int level = 1;
        while (entrys.size() > 0) {
            if (level > 30) {
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"ZKBOMCGXCQJC_INFO", (Locale)ctx.getLocale(), (Object[])new Object[0]);
                throw new EASBizException(new NumericExceptionSubItem("id_error", strInfo));
            }
            ++level;
            materialSet.clear();
            for (int i = 0; i < entrys.size(); ++i) {
                BomEntryInfo be = entrys.get(i);
                String mid = be.getMaterial().getId().toString();
                if (be.getMaterialProp() != MaterialAttributeEnum.PHANTOMPART) {
                    this.idSet.add(mid);
                }
                materialSet.add(mid);
                this.bomids.add(be.getParent().getId().toString());
            }
            entrys = this.query_bomEntry(materialSet);
        }
    }

    protected void update_bom(final Context ctx, RptParams params) throws BOSException, EASBizException {
        this.idSet.add(this.material);
        String eID = SQLUtil.arrayToString((Object[])this.idSet.toArray());
        BOMTreeUtil bomtree = new BOMTreeUtil(){

            @Override
            protected void execute(String treeTemp, Map params) throws Exception {
                VarianceAnalysisReportFacadeControllerBean.this.add_data(ctx, treeTemp, params);
            }
        };
        HashMap<String, Boolean> param = new HashMap<String, Boolean>();
        param.put("param_stopVirtual", true);
        if (this.project != null && this.project != "") {
            ProjectInfo pi = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(this.project));
            param.put("param_project", (Boolean)pi);
        }
        if (this.trackNumber != null && this.trackNumber != "") {
            TrackNumberInfo tn = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo("where number = '" + this.trackNumber + "'");
            param.put("param_track", (Boolean)tn);
            param.put("param_trackno", (Boolean)tn);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)this.idSet, CompareType.INCLUDE));
        MaterialCollection mc = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(evi);
        bomtree.run(ctx, mc, param);
    }

    protected void add_data(Context ctx, String treeTemp, Map params) throws BOSException, EASBizException {
        this.tempTable = this.getTempTableName("tempTable", ctx);
        StringBuffer selectSql = new StringBuffer();
        String tta = this.tempTable + "A";
        selectSql.append("select * \n");
        selectSql.append(" into " + tta + " \n");
        selectSql.append("from ( \n");
        selectSql.append(" select ");
        selectSql.append(" ").append("F_ProductID").append(",").append("F_ParentMaterialID").append(",").append("F_MaterialID").append(",").append("F_TrackID");
        selectSql.append(",max(").append("F_BOMENTRYID").append(") as ").append("F_BOMENTRYID").append(",sum(").append("F_ConsumeQty").append(") as ").append("F_ConsumeQty");
        selectSql.append(" from ").append(treeTemp);
        selectSql.append(" where FStorageOrgUnitID = '").append(this.orgUnit).append("'");
        selectSql.append(" group by ").append("F_ProductID").append(",").append("F_ParentMaterialID").append(",").append("F_MaterialID").append(",").append("F_TrackID");
        selectSql.append(")");
        this.executeCreateAsSelectInto(selectSql.toString(), null, ctx);
        String ttb = this.tempTable + "B";
        String bSql = this.tempTableC(ttb);
        this.executeCreateAsSelectInto(bSql, null, ctx);
        selectSql.setLength(0);
        selectSql.append("select * \n");
        selectSql.append(" into " + this.tempTable + "\n");
        selectSql.append("from ( \n");
        selectSql.append("( select \n");
        selectSql.append("m.fid materialid, \n");
        selectSql.append("m.fnumber materialNumber, \n");
        selectSql.append("m.fname_l2 materialName, \n");
        selectSql.append("m.fmodel materialModel, \n");
        selectSql.append("mu.fname_l2 measureUnit, \n");
        selectSql.append("p.fnumber productNumber,\n");
        selectSql.append("p.fname_l2 productName,\n");
        selectSql.append("ttb.").append("F_ConsumeQty").append(" pbomAmt, \n");
        selectSql.append("tta.").append("F_ConsumeQty").append(" bomAmt,\n");
        selectSql.append("( ");
        selectSql.append("case when ttb.").append("F_ConsumeQty").append(" < tta.").append("F_ConsumeQty").append(" then 'BOM>" + EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"EM_WLFP", (Locale)ctx.getLocale()) + "'\n");
        selectSql.append(" when ttb.").append("F_ConsumeQty").append(" is null and tta.").append("F_ConsumeQty").append(" is not null then 'BOM>" + EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"EM_WLFP", (Locale)ctx.getLocale()) + "'\n");
        selectSql.append(" when ttb.").append("F_ConsumeQty").append(" = tta.").append("F_ConsumeQty").append(" then '" + EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"EM_LZXD", (Locale)ctx.getLocale()) + "'\n");
        selectSql.append(" when ttb.").append("F_ConsumeQty").append(" is null and tta.").append("F_ConsumeQty").append(" is null then '" + EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"EM_LZXD", (Locale)ctx.getLocale()) + "'\n");
        selectSql.append(" when ttb.").append("F_ConsumeQty").append(" > tta.").append("F_ConsumeQty").append(" then 'BOM<" + EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"EM_WLFP", (Locale)ctx.getLocale()) + "' \n");
        selectSql.append(" when ttb.").append("F_ConsumeQty").append(" is not null and tta.").append("F_ConsumeQty").append(" is null then 'BOM<" + EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"EM_WLFP", (Locale)ctx.getLocale()) + "' end\n");
        selectSql.append(") varianceType ,\n");
        selectSql.append(" e.FBomFlow bomFlow,\n");
        selectSql.append(" e.FSupplyStorageOrgUnitID supplyStorageOrgUnitID,\n");
        selectSql.append("e.FMaterialProp,( ");
        selectSql.append("case e.FMaterialProp when 10010 then '" + this.getString(ctx, "EM_GHJ") + "'\n");
        selectSql.append("when 10020 then '" + this.getString(ctx, "EM_XNJ") + "'\n");
        selectSql.append("when 10030 then '" + this.getString(ctx, "EM_ZZJ") + "'\n");
        selectSql.append("when 10040 then '" + this.getString(ctx, "EM_WGJ") + "'\n");
        selectSql.append("when 10050 then '" + this.getString(ctx, "EM_WWJ") + "'\n");
        selectSql.append("when 10060 then '" + this.getString(ctx, "EM_QT") + "'\n");
        selectSql.append("when -1 then '' end\n");
        selectSql.append(") materialSource,\n");
        selectSql.append("ttb.rootingNumber routingNumber, \n");
        selectSql.append("ttb.rootingName routingName, \n");
        selectSql.append("pm.fnumber pmaterialNumber,\n");
        selectSql.append("pm.fname_l2 pmaterialName\n");
        selectSql.append("from " + tta + " tta\n");
        selectSql.append(" left join ").append(ttb).append(" ttb on ttb.").append("F_ProductID").append(" = tta.").append("F_ProductID").append(" and ttb.").append("F_ParentMaterialID").append(" = tta.").append("F_ParentMaterialID").append(" and ttb.").append("F_MaterialID").append(" = tta.").append("F_MaterialID");
        selectSql.append(" left join t_mm_bomentry e on e.fid = tta.").append("F_BOMENTRYID");
        selectSql.append(" left join t_bd_measureunit mu on mu.fid = e.funitid");
        selectSql.append(" left join t_bd_material p on p.fid = tta.").append("F_ProductID").append("");
        selectSql.append(" left join t_bd_material pm on pm.fid = tta.").append("F_ParentMaterialID").append("");
        selectSql.append(" left join t_bd_material m on m.fid = tta.").append("F_MaterialID").append("\n");
        selectSql.append(" ) union ( \n");
        selectSql.append(" select \n");
        selectSql.append("m.fid materialid, \n");
        selectSql.append("m.fnumber materialNumber, \n");
        selectSql.append("m.fname_l2 materialName, \n");
        selectSql.append("m.fmodel materialModel, \n");
        selectSql.append("mu.fname_l2 measureUnit, \n");
        selectSql.append("p.fnumber productNumber,\n");
        selectSql.append("p.fname_l2 productName,\n");
        selectSql.append("ttb.").append("F_ConsumeQty").append(" pbomAmt, \n");
        selectSql.append("null bomAmt,\n");
        selectSql.append("'BOM<\u7269\u6599\u5206\u914d' varianceType ,\n");
        selectSql.append(" e.FBomFlow bomFlow,\n");
        selectSql.append(" e.FSupplyStorageOrgUnitID supplyStorageOrgUnitID,\n");
        selectSql.append("e.FMaterialProp,( ");
        selectSql.append("case e.FMaterialProp when 10010 then '" + this.getString(ctx, "EM_GHJ") + "'\n");
        selectSql.append("when 10020 then '" + this.getString(ctx, "EM_XNJ") + "'\n");
        selectSql.append("when 10030 then '" + this.getString(ctx, "EM_ZZJ") + "'\n");
        selectSql.append("when 10040 then '" + this.getString(ctx, "EM_WGJ") + "'\n");
        selectSql.append("when 10050 then '" + this.getString(ctx, "EM_WWJ") + "'\n");
        selectSql.append("when 10060 then '" + this.getString(ctx, "EM_QT") + "'\n");
        selectSql.append("when -1 then '' end\n");
        selectSql.append(") materialSource,\n");
        selectSql.append("ttb.rootingNumber routingNumber, \n");
        selectSql.append("ttb.rootingName routingName, \n");
        selectSql.append("pm.fnumber pmaterialNumber,\n");
        selectSql.append("pm.fname_l2 pmaterialName\n");
        selectSql.append("from " + ttb + " ttb\n");
        selectSql.append(" left join t_mm_bomentry e on e.fid = ttb.").append("F_BOMENTRYID");
        selectSql.append(" left join t_bd_measureunit mu on mu.fid = e.funitid");
        selectSql.append(" left join t_bd_material p on p.fid = ttb.").append("F_ProductID").append("");
        selectSql.append(" left join t_bd_material pm on pm.fid = ttb.").append("F_ParentMaterialID").append("");
        selectSql.append(" left join t_bd_material m on m.fid = ttb.").append("F_MaterialID").append("");
        selectSql.append(" where not exists (").append("select 1 from ").append(tta).append(" where ttb.").append("F_ProductID").append(" = ").append("F_ProductID").append(" and ttb.").append("F_ParentMaterialID").append(" = ").append("F_ParentMaterialID").append(" and ttb.").append("F_MaterialID").append(" = ").append("F_MaterialID").append(")");
        selectSql.append(")");
        selectSql.append(" )\n");
        this.executeCreateAsSelectInto(selectSql.toString(), null, ctx);
        this.updateTableWithExtraInfo(ctx);
        this.dropTempTable(tta, ctx);
        this.dropTempTable(ttb, ctx);
    }

    private void updateTableWithExtraInfo(Context ctx) throws BOSException {
        String tempTableExtra = this.getTempTableName("tempTableExtra", ctx);
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select * \n");
        selectSql.append(" into " + tempTableExtra + " \n");
        selectSql.append("from ( \n");
        selectSql.append(" select a.*,(case b.FIsWarehouse when 1 then '" + this.getString(ctx, "EM_S") + "' when 0 then '" + this.getString(ctx, "EM_F") + "' else '" + this.getString(ctx, "EM_F") + "' end) isWarehouse,'" + this.getString(ctx, "EM_S") + "' IsMP  from \n");
        selectSql.append(this.tempTable).append(" a ").append("left join t_mat_emmmaterial b on a.materialid = b.fmaterialid and b.fStorageOrgUnitID = a.supplyStorageOrgUnitID)");
        this.tempTable = tempTableExtra;
        this.executeCreateAsSelectInto(selectSql.toString(), null, ctx);
    }

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return super._init(ctx, params);
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int i) throws BOSException, EASBizException {
        this.tempTable = params.getString("tempTable");
        StringBuffer sql = new StringBuffer("select ");
        RptTableHeader header = (RptTableHeader)params.getObject("header");
        if (header == null || header.getColumnCount() == 0) {
            sql.append(" * ");
        } else {
            int size = header.getColumnCount();
            for (int c = 0; c < size; ++c) {
                RptTableColumn col = header.getColumn(c);
                if (c != 0) {
                    sql.append(",");
                }
                sql.append(col.getName());
            }
        }
        sql.append(" from ").append(this.tempTable);
        String materialSource = params.getString("materialSource");
        if (materialSource != null && !materialSource.equals("")) {
            sql.append(" where FMaterialProp in (").append(materialSource).append(")");
        }
        RptRowSet rs = this.executeQuery(sql.toString(), null, from, i, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        this.dropTempTable(this.tempTable, ctx);
        return pp;
    }

    private String tempTableC(String tempTableC) {
        StringBuffer pbomSql = new StringBuffer();
        pbomSql.append("select *  into " + tempTableC + " from \n");
        pbomSql.append("(select ");
        pbomSql.append(" bom.fmaterialid as ").append("F_ProductID");
        pbomSql.append(" ,bom1.fmaterialid as ").append("F_ParentMaterialID");
        pbomSql.append(" ,PBOMENTRY.FMaterialID as ").append("F_MaterialID");
        pbomSql.append(" ,max(PBOMENTRY.fbomitemid) as ").append("F_BOMENTRYID");
        pbomSql.append(" ,max(STANDARDROOTING.Fnumber) as rootingNumber");
        pbomSql.append(" ,max(STANDARDROOTING.Fname_l2) as rootingName");
        pbomSql.append(" ,sum( PBOMENTRY .FConsumeQuota) AS  ").append("F_ConsumeQty");
        pbomSql.append(" FROM T_MM_PBOM PBOM  ");
        pbomSql.append(" LEFT OUTER JOIN T_MM_PBOMEntry PBOMENTRY  ");
        pbomSql.append(" ON  PBOM.FID =  PBOMENTRY.FParentID  ");
        pbomSql.append(" LEFT OUTER JOIN T_MM_Bom BOM ");
        pbomSql.append(" ON PBOM.FBomID = BOM.FID ");
        pbomSql.append(" LEFT OUTER JOIN T_MM_Bom BOM1 ");
        pbomSql.append(" ON BOM1.FID = PBOMENTRY.fbomid");
        pbomSql.append(" LEFT OUTER JOIN T_MM_TrackNumber BEGINCARNO ");
        pbomSql.append(" ON PBOMENTRY.FSTRACEID = BEGINCARNO.FID");
        pbomSql.append(" LEFT OUTER JOIN T_MM_TrackNumber ENDCARNO ");
        pbomSql.append(" ON PBOMENTRY.FETRACEID = ENDCARNO.FID ");
        pbomSql.append(" LEFT OUTER JOIN T_MM_StandardRooting STANDARDROOTING ");
        pbomSql.append(" ON PBOM.FRoutingID = STANDARDROOTING.FID ");
        pbomSql.append(" where STANDARDROOTING.fstatus != 30 \n");
        pbomSql.append(" and STANDARDROOTING.FStorageOrgUnitID = '").append(this.orgUnit).append("'");
        pbomSql.append(" AND PBOM.fbomid in (").append(SQLUtil.arrayToString((Object[])this.bomids.toArray())).append(")");
        pbomSql.append(" and BEGINCARNO.fnumber <= '").append(this.trackNumber).append("'");
        pbomSql.append(" and ENDCARNO.fnumber >= '").append(this.trackNumber).append("'");
        pbomSql.append(" group by bom.fmaterialid ,bom1.fmaterialid ,PBOMENTRY.FMaterialID");
        pbomSql.append(")\n");
        return pbomSql.toString();
    }
}

