/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;

public class WorkshopDailyOutputReportServer
extends ReportServerBase {
    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        int i;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String d1 = filter.getString("pkStartDate");
        String d2 = filter.getString("pkEndDate");
        String storageStr = filter.getString("storageOrgUnit");
        String[] storages = storageStr.split("[,;]");
        String workshopStr = filter.getString("workshop");
        String[] workshops = workshopStr == null ? null : workshopStr.split("[,;]");
        String workcenterStr = filter.getString("workcenter");
        String[] workcenters = workcenterStr == null ? null : workcenterStr.split("[,;]");
        ArrayList<Date> params = new ArrayList<Date>();
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append("/*dialect*/select");
        sql.append(" storages");
        sql.append(",workshop");
        sql.append(",workcenter");
        Calendar now = Calendar.getInstance();
        String ts = d1;
        do {
            now.setTime(df.parse(ts));
            ts = df.format(now.getTime());
            sql.append("        ,sum(case when ymd = '").append(ts).append("' then dailyOutput else 0 end) ").append(" \"dailyOutput").append(ts).append("\"");
            sql.append("        ,wmsys.wm_concat(distinct (case when ymd = '").append(ts).append("' then content_ else '' end)) ").append(" \"content").append(ts).append("\"");
            now.add(6, 1);
        } while ((ts = df.format(now.getTime())).compareTo(d2) <= 0);
        sql.append("   from ( ");
        sql.append("         select to_char(max(technics.FEarlistCmpTime), 'yyyy-MM-dd') ymd,");
        sql.append("                 s.fname_l2 storages,");
        sql.append("                 ws.fname_l2 workshop,");
        sql.append("                 wk.fname_l2 workcenter,");
        sql.append("                 b.cfqty dailyOutput,");
        sql.append("                 to_char(t.fnumber||' '||jch.FNumber) content_");
        sql.append("          from t_org_storage s");
        sql.append("          inner join CT_PS_MasterProductionSchedule b on s.fid = b.cfstorageorgunitid");
        sql.append("          inner join t_mm_manufactureorder o on b.fid = o.FSourceBillID");
        sql.append("          inner join t_mm_mftordertechnics technics on o.fid = technics.fparentid");
        sql.append("          inner join T_MM_WorkCenter wk on wk.fid = technics.fworkcenterid");
        sql.append("          inner join T_MM_WorkCenter ws on ws.fid = wk.FParentWCID");
        sql.append("          left join t_mm_tracknumber t on t.fid = b.cftraceid");
        sql.append("          left join T_EMM_ProjectJCH jch on jch.fid = b.CFProjectJCHID");
        sql.append("          where 1=1");
        sql.append("          and technics.FEarlistCmpTime >= ?");
        params.add(new Date(df.parse(d1).getTime()));
        sql.append("          and technics.FEarlistCmpTime <= ?");
        params.add(new Date(df.parse(d2).getTime()));
        sql.append("          and s.fnumber in (");
        for (i = 0; i < storages.length; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("'").append(storages[i].trim()).append("'");
        }
        sql.append(" )");
        if (!StringUtils.isEmpty((String)workcenterStr)) {
            sql.append("      and wk.fnumber in (");
            for (i = 0; i < workcenters.length; ++i) {
                if (i != 0) {
                    sql.append(",");
                }
                sql.append("'").append(workcenters[i].trim()).append("'");
            }
            sql.append(")");
        }
        if (!StringUtils.isEmpty((String)workshopStr)) {
            sql.append("      and ws.fnumber in (");
            for (i = 0; i < workshops.length; ++i) {
                if (i != 0) {
                    sql.append(",");
                }
                sql.append("'").append(workshops[i].trim()).append("'");
            }
            sql.append(")");
        }
        sql.append("          group by ");
        sql.append("                 s.fname_l2,");
        sql.append("                 ws.fname_l2,");
        sql.append("                 wk.fname_l2,");
        sql.append("                 b.cfqty,");
        sql.append("                 to_char(t.t.fnumber||' '||jch.FNumber)");
        sql.append(") group by storages,workshop,workcenter");
        IRowSet result = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (Object[])params.toArray());
        return result;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = new ReportHeader();
        ReportHeader storageRH = header.addChild("storages", EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0037", (Locale)this.getContext().getLocale()));
        storageRH.setMergeable(true);
        header.addChild("workshop", EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0049", (Locale)this.getContext().getLocale())).setMergeable(true);
        header.addChild("workcenter", EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0050", (Locale)this.getContext().getLocale())).setMergeable(true);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String d1 = filter.getString("pkStartDate");
        String d2 = filter.getString("pkEndDate");
        Calendar now = Calendar.getInstance();
        do {
            now.setTime(df.parse(d1));
            d1 = df.format(now.getTime());
            ReportHeader ymdRH = header.addChild("ymd" + d1, d1);
            ymdRH.addChild("dailyOutput" + d1, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0038", (Locale)this.getContext().getLocale())).setWidth(100);
            ymdRH.addChild("content" + d1, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0028", (Locale)this.getContext().getLocale())).setWidth(120);
            now.add(6, 1);
        } while ((d1 = df.format(now.getTime())).compareTo(d2) <= 0);
        return header;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        ReportTitles titles = new ReportTitles();
        int index = 0;
        Iterator it = filter.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (!key.endsWith("title")) continue;
            titles.AddTitle(index++, filter.getString(key));
        }
        return titles;
    }
}

