/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.mm.basedata.ChangeVersionFactory;
import com.kingdee.eas.industry.emm.mm.basedata.ChangeVersionInfo;
import com.kingdee.eas.industry.emm.mm.pm.ProjectPlanManagerFacadeFactory;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.BusinessChangeTypeEnum;
import com.kingdee.eas.zjbom.BusinessRepCollection;
import com.kingdee.eas.zjbom.BusinessRepEntryFactory;
import com.kingdee.eas.zjbom.BusinessRepEntryInfo;
import com.kingdee.eas.zjbom.BusinessRepFacadeFactory;
import com.kingdee.eas.zjbom.BusinessRepFactory;
import com.kingdee.eas.zjbom.BusinessRepInfo;
import com.kingdee.eas.zjbom.IBusinessRep;
import com.kingdee.eas.zjbom.app.AbstractBusinessRepControllerBean;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.eas.zjbom.util.BomUtil;
import com.kingdee.eas.zjbom.util.bomDesignBatchRequiredUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class BusinessRepControllerBean
extends AbstractBusinessRepControllerBean {
    private static final long serialVersionUID = 7523440389394213888L;
    private String RESURL = "com.kingdee.eas.zjbom.BusinessRepResource";

    @Override
    public boolean checkAudit(Context ctx, List ids, boolean throwError) throws BOSException, EASBizException {
        boolean check = false;
        if (ids == null || ids.size() == 0) {
            return check;
        }
        String idStr = this.getIdsStr(ctx, ids);
        IBusinessRep issp = BusinessRepFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4));
        check = issp.exists(filter);
        if (check && throwError) {
            String errMsg = ResourceBase.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0030", (Locale)ctx.getLocale());
            if (ids.size() == 1) {
                errMsg = ResourceBase.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0031", (Locale)ctx.getLocale());
            }
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", errMsg);
            throw new EASBizException(exc);
        }
        return check;
    }

    public boolean checkStatusValid(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        return super.checkStatusValid(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        if (pk != null) {
            String sql = "  delete from t_bot_relation where fdestobjectid = ? and fdestentityid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{pk.toString(), "BF3550CD"});
        }
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        super._delete(ctx, arrayPK);
        if (arrayPK != null && arrayPK.length > 0) {
            String sql = "  delete from t_bot_relation where fdestobjectid = ? and fdestentityid = ? ";
            for (int i = 0; i < arrayPK.length; ++i) {
                IObjectPK pk = arrayPK[i];
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{pk.toString(), "BF3550CD"});
            }
        }
    }

    private String getIdsStr(Context ctx, List ids) throws EASBizException {
        return BomUtil.getIdsStr(ids, ResourceBase.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0032", (Locale)ctx.getLocale()));
    }

    private void initBaseStatus(BusinessRepInfo info) {
        BillBaseStatusEnum status = BillBaseStatusEnum.TEMPORARILYSAVED;
        if (info.getState() == null || info.getState().getValue() < status.getValue()) {
            info.setState(status);
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BusinessRepInfo info = (BusinessRepInfo)model;
        this.initBaseStatus(info);
        if (this.exists(ctx, "where (number is null or number = '') and id = '" + pk.toString() + "'")) {
            AutoNumberUtil.initNumber(ctx, (IObjectValue)info);
        }
        try {
            super._addnew(ctx, pk, model);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo info = (CoreBaseInfo)model;
        BOSUuid id = info.getId();
        if (id == null) {
            id = BOSUuid.create((BOSObjectType)info.getBOSType());
        }
        info.setId(id);
        ObjectUuidPK pk = new ObjectUuidPK(id);
        this._addnew(ctx, (IObjectPK)pk, (IObjectValue)info);
        return pk;
    }

    @Override
    protected void _archive(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BusinessRepCollection bills = new BusinessRepCollection();
        BusinessRepInfo info = new BusinessRepInfo();
        info.setId(BOSUuid.read((String)pk.toString()));
        bills.add(info);
        BusinessRepFacadeFactory.getLocalInstance(ctx).archive(bills);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        this.checkAudit(ctx, ids, true);
        BusinessRepInfo info = (BusinessRepInfo)model;
        info.setState(BillBaseStatusEnum.AUDITED);
        info.setAuditor(BomUtil.getCurrentUser(ctx));
        info.setAuditorTime(new Date());
        super._passAudit(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    @Override
    protected void _processAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BusinessRepCollection bills = new BusinessRepCollection();
        BusinessRepInfo info = this.getBusinessRepInfo(ctx, pk);
        bills.add(info);
        BusinessRepFacadeFactory.getLocalInstance(ctx).processAudits(bills);
        this.updateChangeVersion(ctx, pk.toString());
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, model);
        BusinessRepInfo business = (BusinessRepInfo)model;
        if (business.getNumber() == null || "".equals(business.getNumber())) {
            try {
                String id = null;
                String sql = " select fcontrolunitid from CT_ZJB_BusinessRep where fid ='" + pk.toString() + "' ";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rs.next()) {
                    id = rs.getString("fcontrolunitid");
                }
                this.setprocessBillNumber(ctx, (IObjectValue)business, id);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        return super._save(ctx, (IObjectValue)business);
    }

    protected void setprocessBillNumber(Context ctx, IObjectValue billInfo, String bizOrgUnitID) throws Exception {
        String billNumber = null;
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule(billInfo, bizOrgUnitID);
        if (ruleInfo != null) {
            billNumber = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(billInfo, ruleInfo);
        }
        if (billNumber != null) {
            billInfo.setString("number", billNumber);
        } else if (billInfo.getString("id") != null) {
            billInfo.setString("number", "AutoNumberFromBTP_" + billInfo.getString("id").toString());
        } else {
            billInfo.setString("number", "AutoNumberFromBTP_" + BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
        }
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (this.exists(ctx, "where (number is null or number = '') and id = '" + pk.toString() + "'")) {
            AutoNumberUtil.initNumber(ctx, model);
        }
        super._save(ctx, pk, model);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BusinessRepCollection coll = new BusinessRepCollection();
        BusinessRepInfo info = (BusinessRepInfo)model;
        info.put("NOUPDATE", true);
        coll.add(info);
        String errorString = this.checkAndSubmitDatas(ctx, coll);
        if (errorString != null && !errorString.equals("")) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem(ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_024", (Locale)ctx.getLocale()), errorString);
            throw new EASBizException(exc);
        }
        info.setState(BillBaseStatusEnum.SUBMITED);
        super._submit(ctx, pk, (IObjectValue)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BusinessRepCollection coll = new BusinessRepCollection();
        BusinessRepInfo info = (BusinessRepInfo)model;
        info.put("NOUPDATE", true);
        coll.add(info);
        String errorString = this.checkAndSubmitDatas(ctx, coll);
        if (errorString != null && !errorString.equals("")) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem(ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_024", (Locale)ctx.getLocale()), errorString);
            throw new EASBizException(exc);
        }
        info.setState(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, (IObjectValue)info);
    }

    private boolean isArchive(Context ctx, IObjectCollection bills) throws BOSException, EASBizException {
        String idstr = BomUtil.getIdsStr(ResourceBase.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0041", (Locale)ctx.getLocale()), bills);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idstr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("isArchive", (Object)true, CompareType.EQUALS));
        return BusinessRepFactory.getLocalInstance(ctx).exists(filter);
    }

    private boolean checkProcessAudits(Context ctx, IObjectCollection bills) throws BOSException, EASBizException {
        String idstr = BomUtil.getIdsStr(ResourceBase.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0041", (Locale)ctx.getLocale()), bills);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idstr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("processAudit", (Object)true, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("batch is null"));
        filter.setMaskString("#0 and (#1 or #2)");
        FilterInfo filterEntry = new FilterInfo();
        filterEntry.getFilterItems().add(new FilterItemInfo("parent.id", (Object)idstr, CompareType.INNER));
        filterEntry.getFilterItems().add(new FilterItemInfo("changeType", (Object)"2", CompareType.NOTEQUALS));
        filterEntry.getFilterItems().add(new FilterItemInfo("flow is null"));
        filterEntry.getFilterItems().add(new FilterItemInfo("project is null"));
        filterEntry.getFilterItems().add(new FilterItemInfo("begincarno is null"));
        filterEntry.getFilterItems().add(new FilterItemInfo("endcarno is null"));
        filterEntry.setMaskString("#0 and #1 and (#2 or #3 or #4 or #5)");
        return !BusinessRepFactory.getLocalInstance(ctx).exists(filter) && !BusinessRepEntryFactory.getLocalInstance(ctx).exists(filterEntry);
    }

    protected String getParamValue(Context ctx, String paramName, String ctrlUnitId) throws BOSException, EASBizException {
        if (ctrlUnitId == null) {
            return null;
        }
        String value = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("value"));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)ctrlUnitId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)paramName, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        ParamItemCollection paramItemCollection = ParamItemFactory.getLocalInstance((Context)ctx).getParamItemCollection(entityViewInfo);
        if (paramItemCollection != null && paramItemCollection.size() > 0 && paramItemCollection.get(0) != null) {
            value = paramItemCollection.get(0).getValue() == null ? "" : paramItemCollection.get(0).getValue();
        }
        return value;
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        boolean isAudit = this.checkAudit(ctx, ids, false);
        if (!isAudit) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", ResourceBase.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0042", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        BusinessRepInfo info = (BusinessRepInfo)model;
        info.setState(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditorTime(null);
        super._unpassAudit(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BusinessRepInfo info = (BusinessRepInfo)model;
        this.initBaseStatus(info);
        if (this.exists(ctx, "where (number is null or number = '') and id = '" + pk.toString() + "'")) {
            AutoNumberUtil.initNumber(ctx, (IObjectValue)info);
        }
        try {
            super._update(ctx, pk, model);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void updateChangeVersion(Context ctx, String id) throws BOSException, EASBizException {
        if (ctx == null || id == null) {
            return;
        }
        if (id.trim().length() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Select\r\n");
        sql.append("BRE.FID FBREID,\r\n");
        sql.append("P.FID FProjectID,\r\n");
        sql.append("P.FNumber FProjectNumber,\r\n");
        sql.append("STN.FID FStartTrackNumberID,\r\n");
        sql.append("STN.FNumber FStartTrackNumber,\r\n");
        sql.append("ETN.FID FEndTrackNumberID,\r\n");
        sql.append("ETN.FNumber FEndTrackNumber\r\n");
        sql.append("From CT_ZJB_BusinessRep BR\r\n");
        sql.append("Inner Join CT_ZJB_BusinessRepEntry BRE On BRE.FParentID=BR.FID\r\n");
        sql.append("Inner Join T_MM_Project P On P.FID=BRE.CFProjectID\r\n");
        sql.append("Inner Join T_MM_TrackNumber STN On STN.FID=BRE.CFBeginCarNoID\r\n");
        sql.append("Inner Join T_MM_TrackNumber ETN On ETN.FID=BRE.CFEndCarNoID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And BR.FID='").append(id).append("'\r\n");
        sql.append("And IsNull(STN.FNumber,'Null')<=IsNull(ETN.FNumber,'Null')\r\n");
        sql.append("And Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From T_MM_ProjectCar PC\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And PC.FProjectID=P.FID\r\n");
        sql.append("And PC.FTrackNumberID=STN.FID\r\n");
        sql.append(")\r\n");
        sql.append("And Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From T_MM_ProjectCar PC\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And PC.FProjectID=P.FID\r\n");
        sql.append("And PC.FTrackNumberID=ETN.FID\r\n");
        sql.append(")\r\n");
        sql.append("And (Not Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From CT_BAS_ChangeVersion CV\r\n");
        sql.append("Inner Join T_MM_TrackNumber CVSTN On CVSTN.FID=CV.CFStartTrackNumberID\r\n");
        sql.append("Inner Join T_MM_TrackNumber CVETN On CVETN.FID=CV.CFEndTrackNumberID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And CV.CFProjectID=P.FID\r\n");
        sql.append("And (\r\n");
        sql.append("(\r\n");
        sql.append("STN.FNumber>=CVSTN.FNumber\r\n");
        sql.append("And STN.FNumber<=CVETN.FNumber\r\n");
        sql.append(")\r\n");
        sql.append("Or\r\n");
        sql.append("(\r\n");
        sql.append("ETN.FNumber>=CVSTN.FNumber\r\n");
        sql.append("And ETN.FNumber<=CVETN.FNumber\r\n");
        sql.append(")\r\n");
        sql.append(")\r\n");
        sql.append("))\r\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet == null) {
            return;
        }
        if (rowSet.size() == 0) {
            return;
        }
        try {
            CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            Timestamp time = new Timestamp(new Date().getTime());
            CoreBaseCollection addNewCollection = new CoreBaseCollection();
            ArrayList materialList = new ArrayList();
            while (rowSet.next()) {
                String breID = rowSet.getString("FBREID");
                String projectID = rowSet.getString("FProjectID");
                String projectNumber = rowSet.getString("FProjectNumber");
                String startTrackNumberID = rowSet.getString("FStartTrackNumberID");
                String startTrackNumber = rowSet.getString("FStartTrackNumber");
                String endTrackNumberID = rowSet.getString("FEndTrackNumberID");
                String endTrackNumber = rowSet.getString("FEndTrackNumber");
                if (projectID == null || projectNumber == null || startTrackNumberID == null || startTrackNumber == null || endTrackNumberID == null || endTrackNumber == null || projectID.trim().length() == 0 || projectNumber.trim().length() == 0 || startTrackNumberID.trim().length() == 0 || startTrackNumber.trim().length() == 0 || endTrackNumberID.trim().length() == 0 || endTrackNumber.trim().length() == 0) continue;
                ChangeVersionInfo changeVersionInfo = new ChangeVersionInfo();
                ProjectInfo projectInfo = new ProjectInfo();
                projectInfo.setId(BOSUuid.read((String)projectID));
                projectInfo.setNumber(projectNumber);
                TrackNumberInfo startTrackNumberInfo = new TrackNumberInfo();
                startTrackNumberInfo.setId(BOSUuid.read((String)startTrackNumberID));
                startTrackNumberInfo.setNumber(startTrackNumber);
                TrackNumberInfo endTrackNumberInfo = new TrackNumberInfo();
                endTrackNumberInfo.setId(BOSUuid.read((String)endTrackNumberID));
                endTrackNumberInfo.setNumber(endTrackNumber);
                changeVersionInfo.setId(BOSUuid.create((BOSObjectType)changeVersionInfo.getBOSType()));
                changeVersionInfo.setStatus(MMBasedataStatusEnum.SAVED);
                changeVersionInfo.setProject(projectInfo);
                changeVersionInfo.setStartTrackNumber(startTrackNumberInfo);
                changeVersionInfo.setEndTrackNumber(endTrackNumberInfo);
                changeVersionInfo.setCU(ctrlUnitInfo);
                changeVersionInfo.setCreator(userInfo);
                changeVersionInfo.setCreateTime(time);
                changeVersionInfo.setLastUpdateUser(userInfo);
                changeVersionInfo.setLastUpdateTime(time);
                changeVersionInfo.setDescription(breID);
                if (ctrlUnitInfo != null && ctrlUnitInfo.getId() != null) {
                    changeVersionInfo.setNumber(ProjectPlanManagerFacadeFactory.getLocalInstance(ctx).getBillNumber((IObjectValue)changeVersionInfo, ctrlUnitInfo.getId().toString()));
                }
                addNewCollection.addObject((IObjectValue)changeVersionInfo);
            }
            if (addNewCollection.size() > 0) {
                IObjectPK[] pks = ChangeVersionFactory.getLocalInstance(ctx).addnewBatchData(addNewCollection);
                System.out.println("AddNew ChangeVersion:\r\n" + pks.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _batchSubmit(Context ctx, List idList) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.designMode.*"));
        viewInfo.setSelector(sic);
        BusinessRepCollection coll = BusinessRepFactory.getLocalInstance(ctx).getBusinessRepCollection(viewInfo);
        return this.checkAndSubmitDatas(ctx, coll);
    }

    private String checkAndSubmitDatas(Context ctx, BusinessRepCollection coll) throws BOSException, EASBizException {
        String errorString = "";
        BusinessRepInfo info = null;
        BusinessRepEntryInfo entryInfo = null;
        if (coll == null || coll.size() < 1) {
            return null;
        }
        HashMap<String, String> mnameMap = new HashMap<String, String>();
        SelectorItemCollection updateSic = new SelectorItemCollection();
        updateSic.add(new SelectorItemInfo("state"));
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (info.getNumber() == null || "".equals(info.getNumber())) {
                errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_001", (Locale)ctx.getLocale()) + "\r\n";
                continue;
            }
            if (info.isIsArchive()) {
                errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_002", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber()}) + "\r\n";
                continue;
            }
            if (info.isProcessAudit()) {
                errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_003", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber()}) + "\r\n";
                continue;
            }
            if (info.getState().equals((Object)BillBaseStatusEnum.AUDITED)) {
                errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_004", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber()}) + "\r\n";
                continue;
            }
            if (info.getBizDate() == null) {
                errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_005", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber()}) + "\r\n";
                continue;
            }
            if (info.getEntrys() == null || info.getEntrys().size() == 0) {
                errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_006", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber()}) + "\r\n";
                continue;
            }
            if (bomDesignBatchRequiredUtil.getEMMDesignBatchParamValue() && (info.getBatch() == null || "".equals(info.getBatch()) || "NULL".equals(info.getBatch().toUpperCase()))) {
                errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_007", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber()}) + "\r\n";
                continue;
            }
            boolean hasError = false;
            for (int j = 0; j < info.getEntrys().size(); ++j) {
                entryInfo = info.getEntrys().get(j);
                if (entryInfo.getChangeType() == null) {
                    errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_008", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                    hasError = true;
                    continue;
                }
                if (entryInfo.getMnotype() == null) {
                    errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_009", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                    hasError = true;
                    continue;
                }
                if (entryInfo.getChangeType().equals((Object)BusinessChangeTypeEnum.DOCCHANGE)) continue;
                if (entryInfo.getMno() == null || "".equals(entryInfo.getMno())) {
                    errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_010", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                    hasError = true;
                    continue;
                }
                if (entryInfo.getMname() == null || "".equals(entryInfo.getMname())) {
                    errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_011", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                    hasError = true;
                    continue;
                }
                if (mnameMap != null && mnameMap.containsKey(entryInfo.getMno())) {
                    if (!((String)mnameMap.get(entryInfo.getMno())).equals(entryInfo.getMname())) {
                        errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_022", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                        hasError = true;
                        continue;
                    }
                } else {
                    mnameMap.put(entryInfo.getMno(), entryInfo.getMname());
                }
                if (entryInfo.getZpxh() == null) {
                    errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_012", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                    hasError = true;
                    continue;
                }
                if (entryInfo.getUnitname() == null || "".equals(entryInfo.getUnitname())) {
                    errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_015", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                    hasError = true;
                    continue;
                }
                if (entryInfo.getQty() == null || entryInfo.getQty().compareTo(BigDecimal.ZERO) < 0) {
                    errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_016", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                    hasError = true;
                    continue;
                }
                if (entryInfo.getChangeType().equals((Object)BusinessChangeTypeEnum.BOMCHANGE)) {
                    if (entryInfo.getPmno() == null || "".equals(entryInfo.getPmno())) {
                        errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_013", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                        hasError = true;
                        continue;
                    }
                    if (entryInfo.getPmname() == null || "".equals(entryInfo.getPmname())) {
                        errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_014", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                        hasError = true;
                        continue;
                    }
                    if (mnameMap != null && mnameMap.containsKey(entryInfo.getPmno())) {
                        if (!((String)mnameMap.get(entryInfo.getPmno())).equals(entryInfo.getPmname())) {
                            errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_023", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                            hasError = true;
                            continue;
                        }
                    } else {
                        mnameMap.put(entryInfo.getPmno(), entryInfo.getPmname());
                    }
                    if (entryInfo.getPQty() == null || entryInfo.getPQty().compareTo(BigDecimal.ZERO) <= 0) {
                        errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_017", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                        hasError = true;
                        continue;
                    }
                    if (entryInfo.getPUnitname() == null || "".equals(entryInfo.getPUnitname())) {
                        errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_018", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                        hasError = true;
                        continue;
                    }
                }
                if (entryInfo.getDesignMode() == null) {
                    errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_019", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                    hasError = true;
                    continue;
                }
                if (entryInfo.getDesignMode().isProject() && entryInfo.getProject() == null) {
                    errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_020", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                    hasError = true;
                    continue;
                }
                if (!entryInfo.getDesignMode().isTrackNumber() || entryInfo.getBegincarno() != null && entryInfo.getEndcarno() != null) continue;
                errorString = errorString + ResourceBase.getString((String)this.RESURL, (String)"CheckDatas_021", (Locale)ctx.getLocale(), (Object[])new String[]{info.getNumber(), j + 1 + ""}) + "\r\n";
                hasError = true;
            }
            if (hasError || info.get("NOUPDATE") != null && ((Boolean)info.get("NOUPDATE")).booleanValue()) continue;
            info.setState(BillBaseStatusEnum.SUBMITED);
            BusinessRepFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, updateSic);
        }
        return errorString;
    }
}

