/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.common.utils.BOSFtpUtil;
import com.kingdee.eas.industry.emm.common.utils.EASTask;
import com.kingdee.eas.industry.emm.common.utils.KmConfig;
import com.kingdee.eas.industry.emm.common.utils.TCTask;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.BomMaterialProEnum;
import com.kingdee.eas.zjbom.BusinessChangeTypeEnum;
import com.kingdee.eas.zjbom.BusinessRepCollection;
import com.kingdee.eas.zjbom.BusinessRepEntryCollection;
import com.kingdee.eas.zjbom.BusinessRepEntryFactory;
import com.kingdee.eas.zjbom.BusinessRepEntryInfo;
import com.kingdee.eas.zjbom.BusinessRepFactory;
import com.kingdee.eas.zjbom.BusinessRepInfo;
import com.kingdee.eas.zjbom.DesignBOMBillSplitFacadeFactory;
import com.kingdee.eas.zjbom.IBusinessRep;
import com.kingdee.eas.zjbom.IBusinessRepEntry;
import com.kingdee.eas.zjbom.ISplitSingleProcess;
import com.kingdee.eas.zjbom.SplitSingleProcessCollection;
import com.kingdee.eas.zjbom.SplitSingleProcessFactory;
import com.kingdee.eas.zjbom.SplitSingleProcessInfo;
import com.kingdee.eas.zjbom.app.AbstractBusinessRepFacadeControllerBean;
import com.kingdee.eas.zjbom.app.util.BomBotpUtil;
import com.kingdee.eas.zjbom.util.BomUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class BusinessRepFacadeControllerBean
extends AbstractBusinessRepFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.zjbom.app.BusinessRepFacadeControllerBean");

    @Override
    protected void _archive(Context ctx, IObjectCollection bills) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isArchive"));
        IBusinessRep ibr = BusinessRepFactory.getLocalInstance(ctx);
        int size = bills.size();
        for (int i = 0; i < size; ++i) {
            BusinessRepInfo info = (BusinessRepInfo)bills.getObject(i);
            info.setIsArchive(true);
            ibr.updatePartial((CoreBaseInfo)info, sic);
        }
    }

    private boolean isArchive(Context ctx, IObjectCollection bills) throws BOSException, EASBizException {
        String idstr = BomUtil.getIdsStr(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0041", (Locale)ctx.getLocale()), bills);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idstr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("isArchive", (Object)true, CompareType.EQUALS));
        return BusinessRepFactory.getLocalInstance(ctx).exists(filter);
    }

    @Override
    protected void _chanegDesignBOM(Context ctx, IObjectCollection bills) throws BOSException, EASBizException {
        Date now = new Date();
        String idstr = BomUtil.getIdsStr(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0041", (Locale)ctx.getLocale()), bills);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)idstr, CompareType.INNER));
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        evi.setSelector(sic);
        evi.setFilter(filter);
        BusinessRepEntryCollection businessReps = BusinessRepEntryFactory.getLocalInstance(ctx).getBusinessRepEntryCollection(evi);
        CoreBaseCollection updates = new CoreBaseCollection();
        UserInfo ui = BomUtil.getCurrentUser(ctx);
        int size = businessReps.size();
        for (int i = 0; i < size; ++i) {
            BusinessRepEntryInfo entry = (BusinessRepEntryInfo)businessReps.getObject(i);
            if (entry.getChangeType() == BusinessChangeTypeEnum.DOCCHANGE || entry.getMno() != null && entry.getMno().matches("^[Hh].*$") || entry.getPmno() != null && entry.getPmno().matches("^[Hh].*$")) continue;
            entry.setUpdatesjbom(true);
            entry.setUpdatedate(now);
            entry.setUpdateerid(ui);
            updates.add((CoreBaseInfo)entry);
        }
        if (updates.size() == 0) {
            return;
        }
        IBusinessRepEntry ibre = BusinessRepEntryFactory.getLocalInstance(ctx);
        int isize = updates.size();
        for (int i = 0; i < isize; ++i) {
            BusinessRepEntryInfo ue = (BusinessRepEntryInfo)updates.get(i);
            ibre.update((IObjectPK)new ObjectUuidPK(ue.getId()), (CoreBaseInfo)ue);
        }
        DesignBOMBillSplitFacadeFactory.getLocalInstance(ctx).splitByBusinessRep((BusinessRepCollection)bills);
    }

    @Override
    protected void _convertSplitSingle(Context ctx, IObjectCollection businessRep) throws BOSException, EASBizException {
        String idstr = BomUtil.getIdsStr(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0041", (Locale)ctx.getLocale()), businessRep);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idstr, CompareType.INNER));
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        evi.setSelector(sic);
        evi.setFilter(filter);
        BusinessRepCollection businessReps = BusinessRepFactory.getLocalInstance(ctx).getBusinessRepCollection(evi);
        BOTMappingInfo botInfo = BomBotpUtil.getBOTP(ctx, "MM_BR001");
        CoreBaseCollection updateCol = new CoreBaseCollection();
        for (int i = 0; i < businessReps.size(); ++i) {
            BusinessRepInfo info = businessReps.get(i);
            BusinessRepEntryCollection entrys = new BusinessRepEntryCollection();
            for (int j = 0; j < info.getEntrys().size(); ++j) {
                BusinessRepEntryInfo entry = info.getEntrys().get(j);
                if (entry.getChangeType() == BusinessChangeTypeEnum.DOCCHANGE || entry.getMno() != null && entry.getMno().matches("^[Hh].*$") || entry.getPmno() != null && entry.getPmno().matches("^[Hh].*$")) continue;
                entrys.add(entry);
            }
            if (entrys.size() <= 0) continue;
            info.put("entrys", (Object)entrys);
            SplitSingleProcessCollection sspCol = BomBotpUtil.createBillByBOTP(ctx, info, botInfo);
            for (int j = 0; j < sspCol.size(); ++j) {
                SplitSingleProcessInfo sspinfo = sspCol.get(j);
                sspinfo.setAttributes(BomMaterialProEnum.NORMAL);
                updateCol.add((CoreBaseInfo)sspinfo);
            }
        }
        ISplitSingleProcess issp = SplitSingleProcessFactory.getLocalInstance(ctx);
        if (updateCol.size() > 0) {
            int size = updateCol.size();
            for (int i = 0; i < size; ++i) {
                SplitSingleProcessInfo ssp = (SplitSingleProcessInfo)updateCol.get(i);
                issp.update((IObjectPK)new ObjectUuidPK(ssp.getId()), (CoreBaseInfo)ssp);
            }
        }
    }

    @Override
    protected void _processAudits(Context ctx, IObjectCollection bills) throws BOSException, EASBizException {
        boolean check;
        if (bills == null || bills.size() <= 0) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0043", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        boolean bl = check = !this.isArchive(ctx, bills);
        if (!check) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0033", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        boolean bl2 = check = check && this.checkProcessAudits(ctx, bills);
        if (!check) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0044", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("processAudit"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("auditorTime"));
        IBusinessRep ibr = BusinessRepFactory.getLocalInstance(ctx);
        int size = bills.size();
        UserInfo user = BomUtil.getCurrentUser(ctx);
        for (int i = 0; i < size; ++i) {
            BusinessRepInfo info = (BusinessRepInfo)bills.getObject(i);
            info.setState(BillBaseStatusEnum.AUDITED);
            info.setProcessAudit(true);
            info.setAuditor(user);
            info.setAuditorTime(new Date());
            ibr.updatePartial((CoreBaseInfo)info, sic);
        }
        this._chanegDesignBOM(ctx, bills);
        this._convertSplitSingle(ctx, bills);
    }

    private boolean checkProcessAudits(Context ctx, IObjectCollection bills) throws BOSException, EASBizException {
        String idstr = BomUtil.getIdsStr(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0041", (Locale)ctx.getLocale()), bills);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idstr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("processAudit", (Object)true, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("batch is null"));
        filter.setMaskString("#0 and (#1 or #2)");
        FilterInfo filterEntry = new FilterInfo();
        filterEntry.getFilterItems().add(new FilterItemInfo("parent.id", (Object)idstr, CompareType.INNER));
        filterEntry.getFilterItems().add(new FilterItemInfo("changeType", (Object)"2", CompareType.NOTEQUALS));
        filterEntry.getFilterItems().add(new FilterItemInfo("flow is null"));
        filterEntry.getFilterItems().add(new FilterItemInfo("project is null"));
        filterEntry.getFilterItems().add(new FilterItemInfo("begincarno is null"));
        filterEntry.getFilterItems().add(new FilterItemInfo("endcarno is null"));
        filterEntry.setMaskString("#0 and #1 and (#2 or #3 or #4 or #5)");
        return !BusinessRepFactory.getLocalInstance(ctx).exists(filter) && !BusinessRepEntryFactory.getLocalInstance(ctx).exists(filterEntry);
    }

    @Override
    protected void _setFlowPathInfo(Context ctx, List bills, String flow) throws BOSException, EASBizException {
        Date now = new Date();
        String idstr = BomUtil.getIdsStr(bills, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0041", (Locale)ctx.getLocale()));
        IBusinessRepEntry ibre = BusinessRepEntryFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idstr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("parent.processAudit", (Object)true, CompareType.EQUALS));
        boolean exists = ibre.exists(filter);
        if (exists) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0045", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idstr, CompareType.INNER));
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        evi.setSelector(sic);
        evi.setFilter(filter);
        BusinessRepEntryCollection bres = ibre.getBusinessRepEntryCollection(evi);
        if (bres.size() > 0) {
            UserInfo userInfo = BomUtil.getCurrentUser(ctx);
            CoreBaseCollection cbc = new CoreBaseCollection();
            for (int i = 0; i < bres.size(); ++i) {
                BusinessRepEntryInfo info = bres.get(i);
                info.setFlow(flow);
                info.setFlowerid(userInfo);
                info.setFlowedate(now);
                cbc.add((CoreBaseInfo)info);
            }
            ibre.update(cbc);
        }
    }

    @Override
    protected void _setProjectInfo(Context ctx, IObjectCollection bills) throws BOSException, EASBizException {
        if (bills == null || bills.size() == 0) {
            return;
        }
        String idstr = BomUtil.getIdsStr(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0041", (Locale)ctx.getLocale()), bills);
        if (!BusinessRepCollection.class.isInstance(bills)) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0046", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        IBusinessRep ibr = BusinessRepFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idstr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("processAudit", (Object)true, CompareType.EQUALS));
        boolean exists = ibr.exists(filter);
        if (exists) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0047", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("project"));
        sic.add(new SelectorItemInfo("begincarno"));
        sic.add(new SelectorItemInfo("endcarno"));
        IBusinessRepEntry ibre = BusinessRepEntryFactory.getLocalInstance(ctx);
        BusinessRepEntryCollection result = new BusinessRepEntryCollection();
        for (int i = bills.size() - 1; i >= 0; --i) {
            BusinessRepInfo info = (BusinessRepInfo)bills.getObject(i);
            result.addCollection(info.getEntrys());
        }
        int size = result.size();
        for (int i = 0; i < size; ++i) {
            BusinessRepEntryInfo info = result.get(i);
            ibre.updatePartial((CoreBaseInfo)info, sic);
        }
    }

    private boolean isNoAudited(Context ctx, IObjectCollection bills) throws EASBizException, BOSException {
        String idstr = BomUtil.getIdsStr(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0041", (Locale)ctx.getLocale()), bills);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idstr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)4, CompareType.NOTEQUALS));
        return BusinessRepFactory.getLocalInstance(ctx).exists(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _toOA(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        super._toOA(ctx, id);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        selector.add(new SelectorItemInfo("entrys.project.name"));
        selector.add(new SelectorItemInfo("entrys.begincarno.number"));
        selector.add(new SelectorItemInfo("entrys.endcarno.number"));
        selector.add(new SelectorItemInfo("creator.person.*"));
        BusinessRepInfo binfo = BusinessRepFactory.getLocalInstance(ctx).getBusinessRepInfo((IObjectPK)new ObjectUuidPK(id), selector);
        StringBuilder sql = new StringBuilder();
        ArrayList params = new ArrayList();
        this.addEASToOAData(ctx, id, binfo, sql, params);
        KmConfig km = new KmConfig();
        km.setFtpHost("172.18.1.10");
        km.setFtpPort(21);
        km.setFtpUser("csroa");
        km.setFtpPassword("csr_oa123");
        km.setFtpPath("OA\\eas\\businessrep\\" + binfo.getNumber());
        KmConfig km_download = new KmConfig();
        km_download.setFtpHost("172.18.1.10");
        km_download.setFtpPort(21);
        km_download.setFtpUser("csrEas");
        km_download.setFtpPassword("csr_Eas123");
        km_download.setFtpPath("Draws");
        Pattern pa = Pattern.compile("[\u4e00-\u9fa5]");
        BOSFtpUtil util = null;
        BOSFtpUtil util_download = null;
        try {
            util = new BOSFtpUtil(km);
            util_download = new BOSFtpUtil(km_download);
            this.addEASZip(ctx, id, binfo, util, util_download, sql, params, km, km_download, pa);
            this.addTCZip(ctx, id, binfo, util, util_download, sql, params, km, km_download, pa);
            this.addTCExcel(ctx, id, binfo, util, util_download, sql, params, km, km_download, pa);
            this.addEASExcel(ctx, id, binfo, util, util_download, sql, params, km, km_download, pa);
        }
        finally {
            if (util != null) {
                util.ftpQuit();
            }
            if (util_download != null) {
                util_download.ftpQuit();
            }
        }
    }

    protected void addEASToOAData(Context ctx, BOSUuid id, BusinessRepInfo binfo, StringBuilder sql, List params) throws BOSException, EASBizException {
        DBUtil.executeUpdate((Context)ctx, (String)"update t_zjb_businessrep_oa set fid = fid where fid = ?", (Object[])new Object[]{binfo.getId().toString()});
        sql.setLength(0);
        sql.append("select fstatus from t_zjb_businessrep_oa where fid = ?");
        IRowSet rowset = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{binfo.getId().toString()});
        try {
            if (rowset.next()) {
                if (rowset.getInt("fstatus") != 0) {
                    NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0048", (Locale)ctx.getLocale()));
                    throw new EASBizException(exc);
                }
                DBUtil.executeUpdate((Context)ctx, (String)"delete t_zjb_businessrep_oa where fid = ?", (Object[])new Object[]{binfo.getId().toString()});
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        sql.setLength(0);
        sql.append("insert into t_zjb_businessrep_oa (");
        sql.append(" fid");
        sql.append(" ,Fsourceorgname");
        sql.append(" ,Fcreatornumber ");
        sql.append(" ,Fcreatorname ");
        sql.append(" ,Fphone ");
        sql.append(" ,CFName ");
        sql.append(" ,CFSenddw ");
        sql.append(" ,CFCsdw ");
        sql.append(" ,ffj1,ffj2");
        sql.append(" ,fstatus");
        sql.append(" ) values (");
        params.clear();
        sql.append("?");
        params.add(binfo.getId().toString());
        sql.append(",?");
        params.add(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0049", (Locale)ctx.getLocale()));
        UserInfo user = binfo.getCreator();
        if (user == null || user.getPerson() == null) {
            sql.append(",?");
            params.add("");
            sql.append(",?");
            if (binfo.getDescription() == null) {
                params.add("");
            } else {
                params.add(binfo.getDescription().replaceAll(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0050", (Locale)ctx.getLocale()), ""));
            }
            sql.append(",?");
            params.add(null);
        } else {
            PersonInfo per = user.getPerson();
            sql.append(",?");
            params.add(per.getIdNum());
            sql.append(",?");
            params.add(per.getName());
            sql.append(",?");
            params.add(per.getCell());
        }
        sql.append(",?");
        params.add(binfo.getName() + "  (" + binfo.getNumber() + ")" + binfo.getBatch());
        if (binfo.getSenddw() != null) {
            sql.append(",?");
            params.add(binfo.getSenddw().replaceAll("[,;\uff0c\uff1b\u3001]", ";"));
        } else {
            sql.append(",''");
        }
        if (binfo.getCsdw() != null) {
            sql.append(",?");
            params.add(binfo.getCsdw().replaceAll("[,;\uff0c\uff1b\u3001]", ";"));
        } else {
            sql.append(",''");
        }
        sql.append(",null,null");
        sql.append(",0");
        sql.append(")");
        DBUtil.executeUpdate((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
    }

    protected void addEASZip(Context ctx, BOSUuid id, BusinessRepInfo binfo, BOSFtpUtil util, BOSFtpUtil util_download, StringBuilder sql, List params, KmConfig km, KmConfig km_download, Pattern pa) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(new SelectorItemInfo("attachment.file"));
        evi.getSelector().add(new SelectorItemInfo("attachment.szie"));
        evi.getSelector().add(new SelectorItemInfo("attachment.szieInByte"));
        evi.getSelector().add(new SelectorItemInfo("attachment.simplename"));
        evi.getSelector().add(new SelectorItemInfo("attachment.name"));
        evi.getSelector().add(new SelectorItemInfo("attachment.attachid"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("boID", (Object)id.toString()));
        BoAttchAssoCollection bocoll = BoAttchAssoFactory.getLocalInstance((Context)ctx).getBoAttchAssoCollection(evi);
        if (bocoll != null && bocoll.size() > 0) {
            FileOutputStream fos = null;
            ZipOutputStream jos = null;
            File fj = new File("\u9644\u4ef6.zip");
            try {
                fos = new FileOutputStream(fj);
                jos = new ZipOutputStream(fos);
                int size = bocoll.size();
                for (int i = 0; i < size; ++i) {
                    BoAttchAssoInfo boinfo = bocoll.get(i);
                    AttachmentInfo attInfo = boinfo.getAttachment();
                    String fj_path = attInfo.getName();
                    Matcher m = pa.matcher(fj_path);
                    if (StringUtils.isEmpty((String)fj_path) || m.find()) {
                        fj_path = attInfo.getAttachID();
                    }
                    fj_path = fj_path + "." + attInfo.getSimpleName();
                    fj_path = new String(fj_path.getBytes());
                    ZipEntry jarEntry = new ZipEntry(fj_path);
                    jos.putNextEntry(jarEntry);
                    jos.write(attInfo.getFile());
                    jos.closeEntry();
                }
            }
            catch (Exception e) {
                NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0051", (Locale)ctx.getLocale()));
                throw new EASBizException(exc, (Throwable)e);
            }
            finally {
                if (jos != null) {
                    try {
                        jos.close();
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            params.clear();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(fj);
                String name = binfo.getNumber() + "_EAS\u9644\u4ef6.zip";
                util.upLoadFileFtp(fis, name);
                params.add(km.getFtpPath() + "\\" + name);
            }
            catch (FileNotFoundException e) {
                NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0052", (Locale)ctx.getLocale()));
                throw new EASBizException(exc, (Throwable)e);
            }
            finally {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            fj.delete();
            sql.setLength(0);
            sql.append("update t_zjb_businessrep_oa set ffj2 = ? where fid = ? and ffj2 is null");
            params.add(binfo.getId().toString());
            int r = DBUtil.executeUpdate((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            if (r == 0) {
                sql.setLength(0);
                sql.append("update t_zjb_businessrep_oa set ffj2 = ffj2||';'||? where fid = ?");
                DBUtil.executeUpdate((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            }
        }
    }

    protected void addTCZip(Context ctx, BOSUuid id, BusinessRepInfo binfo, BOSFtpUtil util, BOSFtpUtil util_download, StringBuilder sql, List params, KmConfig km, KmConfig km_download, Pattern pa) throws BOSException, EASBizException {
        block24: {
            sql.setLength(0);
            params.clear();
            sql.append("select fj.ffilepath,max(fj.fid)||'_'||max(fj.frow)||'_'||max(fj.fseq) fjname ");
            sql.append(" from T_PBOMYL_D_FJ fj inner join t_Pbomyl_h h on fj.fid = h.fid where h.feasid = ? group by fj.ffilepath ");
            params.add(binfo.getId().toString());
            IRowSet fj_rowset = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            try {
                if (!fj_rowset.next()) break block24;
                FileInputStream fis = null;
                FileOutputStream fos = null;
                ZipOutputStream jos = null;
                File fj = new File("\u9644\u4ef61.zip");
                try {
                    fos = new FileOutputStream(fj);
                    jos = new ZipOutputStream(fos);
                    do {
                        String fj_path = fj_rowset.getString("ffilepath");
                        fj_path = new String(fj_path.getBytes());
                        String efileName = fj_path.substring(fj_path.lastIndexOf("\\") + 1);
                        Matcher m = pa.matcher(efileName);
                        if (StringUtils.isEmpty((String)efileName) || m.find()) {
                            efileName = fj_rowset.getString("fjname") + fj_path.substring(fj_path.lastIndexOf("."));
                        }
                        ZipEntry jarEntry = new ZipEntry(efileName);
                        jos.putNextEntry(jarEntry);
                        util_download.downloadFileFtp("\\" + fj_path, jos);
                        jos.closeEntry();
                    } while (fj_rowset.next());
                }
                catch (Exception e) {
                    NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0051", (Locale)ctx.getLocale()));
                    throw new EASBizException(exc, (Throwable)e);
                }
                finally {
                    if (jos != null) {
                        try {
                            jos.close();
                            fos.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                params.clear();
                try {
                    fis = new FileInputStream(fj);
                    String name = binfo.getNumber() + EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0053", (Locale)ctx.getLocale());
                    util.upLoadFileFtp(fis, name);
                    params.add(km.getFtpPath() + "\\" + name);
                }
                catch (FileNotFoundException e) {
                    NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0052", (Locale)ctx.getLocale()));
                    throw new EASBizException(exc, (Throwable)e);
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                fj.delete();
                sql.setLength(0);
                sql.append("update t_zjb_businessrep_oa set ffj2 = ? where fid = ? and ffj2 is null");
                params.add(binfo.getId().toString());
                int r = DBUtil.executeUpdate((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
                if (r == 0) {
                    sql.setLength(0);
                    sql.append("update t_zjb_businessrep_oa set ffj2 = ffj2||';'||? where fid = ?");
                    DBUtil.executeUpdate((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
                }
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
    }

    protected void addTCExcel(Context ctx, BOSUuid id, BusinessRepInfo binfo, BOSFtpUtil util, BOSFtpUtil util_download, StringBuilder sql, List params, KmConfig km, KmConfig km_download, Pattern pa) throws BOSException, EASBizException {
        File excel = null;
        FileOutputStream fileOut = null;
        FileInputStream fis = null;
        if (binfo.getNumber().startsWith("CM")) {
            TCTask task = new TCTask(ctx);
            try {
                String tempFile = binfo.getNumber() + ".xls";
                excel = new File(tempFile);
                excel.createNewFile();
                fileOut = new FileOutputStream(excel);
                task.exec(binfo.getNumber(), fileOut);
            }
            catch (IOException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (fileOut != null) {
                    try {
                        fileOut.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            params.clear();
            try {
                fis = new FileInputStream(excel);
                String name = binfo.getNumber() + "_" + binfo.getBatch().trim() + "_TC.xls";
                util.upLoadFileFtp(fis, name);
                params.add(km.getFtpPath() + "\\" + name);
            }
            catch (FileNotFoundException e) {
                NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0054", (Locale)ctx.getLocale()));
                throw new EASBizException(exc, (Throwable)e);
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            excel.delete();
            sql.setLength(0);
            sql.append("update t_zjb_businessrep_oa set ffj1 = ? where fid = ? and ffj1 is null");
            params.add(binfo.getId().toString());
            int r = DBUtil.executeUpdate((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            if (r == 0) {
                sql.setLength(0);
                sql.append("update t_zjb_businessrep_oa set ffj1 = ffj1||';'||? where fid = ?");
                DBUtil.executeUpdate((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            }
        }
    }

    protected void addEASExcel(Context ctx, BOSUuid id, BusinessRepInfo binfo, BOSFtpUtil util, BOSFtpUtil util_download, StringBuilder sql, List params, KmConfig km, KmConfig km_download, Pattern pa) throws BOSException, EASBizException {
        File excel = null;
        FileOutputStream fileOut = null;
        FileInputStream fis = null;
        EASTask eastask = new EASTask(ctx);
        try {
            String tempFile = binfo.getNumber() + ".xls";
            excel = new File(tempFile);
            excel.createNewFile();
            fileOut = new FileOutputStream(excel);
            eastask.exec(binfo, fileOut);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        params.clear();
        try {
            fis = new FileInputStream(excel);
            String name = binfo.getNumber() + "_" + binfo.getBatch().trim() + "_EAS.xls";
            util.upLoadFileFtp(fis, name);
            params.add(km.getFtpPath() + "\\" + name);
        }
        catch (FileNotFoundException e) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0054", (Locale)ctx.getLocale()));
            throw new EASBizException(exc, (Throwable)e);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        excel.delete();
        sql.setLength(0);
        sql.append("update t_zjb_businessrep_oa set ffj1 = ? where fid = ? and ffj1 is null");
        params.add(binfo.getId().toString());
        int r = DBUtil.executeUpdate((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        if (r == 0) {
            sql.setLength(0);
            sql.append("update t_zjb_businessrep_oa set ffj1 = ffj1||';'||? where fid = ?");
            DBUtil.executeUpdate((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        }
    }

    @Override
    protected IRowSet _getbusinessrepattachmentstandlist(Context ctx, String fid) throws BOSException, EASBizException {
        if (fid == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("  /*dialect*/ ");
        sql.append(" Select b.fname_l2 as ffilename,N' ' as ffilepath,b.fsimplename as ffiletype,b.fid as ffjid,'" + EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0055", (Locale)ctx.getLocale()) + "' As fsource   \r\n");
        sql.append(" From T_BAS_BoAttchAsso a inner join T_BAS_Attachment b on a.Fattachmentid = b.fid   \r\n");
        sql.append(" where a.fboid = (Select fparentid from ct_zjb_businessrepentry where fid ='").append(fid).append("')   \r\n");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    @Override
    protected IRowSet _getbusinessrepattachmenttclist(Context ctx, String fid) throws BOSException, EASBizException {
        if (fid == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("  /*dialect*/ ");
        sql.append(" Select a.ffilename,a.ffilepath,substr(a.ffilepath,instr(a.ffilepath,'.') + 1,length(a.ffilepath)) as ffiletype   \r\n");
        sql.append(" ,to_char(a.fid)||'-'||to_char(a.frow)||'-'||to_char(a.fseq) as ffjid,'" + EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0056", (Locale)ctx.getLocale()) + "' As fsource   \r\n");
        sql.append(" From t_pbomyl_d_fj a   \r\n");
        sql.append(" where exists(Select 1 from ct_zjb_businessrepentry where cfallinkid = a.fid and cfallinkentryid = a.frow   \r\n");
        sql.append(" and ct_zjb_businessrepentry.fid = '").append(fid).append("')  \r\n");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    @Override
    protected void _syncBusinessflowcopy(Context ctx, String businessRepId) throws BOSException, EASBizException {
        String sql = "select b.fid,a.fbatch,b.cfmno,b.cfpmno,b.cfprojectid from ct_zjb_businessrep a,ct_zjb_businessrepentry b where a.fid='" + businessRepId + "' and b.fparentid='" + businessRepId + "' and cfflow is null";
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String fbatch = rs.getString("fbatch");
                String cfmno = rs.getString("cfmno");
                String cfpmno = rs.getString("cfpmno");
                String cfprojectid = rs.getString("cfprojectid");
                String entryfid = rs.getString("fid");
                String _sql1 = "select b.cfmakeflow from ct_zjb_designbombill b where   b.cfpartno='" + cfmno + "' and b.cfparentno='" + cfpmno + "' and b.cfprojectid='" + cfprojectid + "' and b.cfbatch='" + fbatch + "'";
                IRowSet _rs1 = SQLUtils.executeQuery((Context)ctx, (String)_sql1);
                while (_rs1.next()) {
                    String makeflow = _rs1.getString("cfmakeflow");
                    String _sql = "update ct_zjb_businessrepentry  set cfflow = ? where fid=? ";
                    DBUtil.executeUpdate((Context)ctx, (String)_sql, (Object[])new Object[]{makeflow, entryfid});
                }
            }
        }
        catch (SQLException e) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_syncBusinessflowcopy", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0057", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
    }

    @Override
    protected void _batchFlow(Context ctx, Map parmMap) throws BOSException {
        ArrayList tempList = (ArrayList)parmMap.get("list");
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        String flow = (String)parmMap.get("flow");
        for (int i = 0; i < tempList.size(); ++i) {
            Map tempMap = (Map)tempList.get(i);
            String id = (String)tempMap.get("id");
            String updateSql = "update ct_zjb_businessrepentry set cfflow = '" + flow + "',       CFFLOWERIDID = '" + userInfo.getId() + "',        CFFLOWEDATE = sysdate where fid = '" + id + "'";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    @Override
    protected boolean _hasWFInstance(Context ctx, String billid) throws BOSException {
        boolean hasWorkflow = false;
        if (billid != null) {
            IEnactmentService service2 = EnactmentServiceFactory.createEnactService((Context)ctx);
            ProcessInstInfo instInfo = null;
            ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(billid);
            int n = procInsts.length;
            for (int i = 0; i < n; ++i) {
                if (!"open.running".equals(procInsts[i].getState())) continue;
                instInfo = procInsts[i];
            }
            hasWorkflow = instInfo != null;
        }
        return hasWorkflow;
    }
}

