/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.clientUtil.ThrowUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.taskmng.util.StringUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.zjbom.BusinessChangeTypeEnum;
import com.kingdee.eas.zjbom.BusinessRepEntryCollection;
import com.kingdee.eas.zjbom.BusinessRepEntryFactory;
import com.kingdee.eas.zjbom.BusinessRepEntryInfo;
import com.kingdee.eas.zjbom.BusinessRepInfo;
import com.kingdee.eas.zjbom.DesignBOMBillCollection;
import com.kingdee.eas.zjbom.DesignBOMBillFactory;
import com.kingdee.eas.zjbom.DesignBOMBillInfo;
import com.kingdee.eas.zjbom.FlowChangeRepEntryCollection;
import com.kingdee.eas.zjbom.FlowChangeRepEntryFactory;
import com.kingdee.eas.zjbom.FlowChangeRepEntryInfo;
import com.kingdee.eas.zjbom.IDesignBOMBill;
import com.kingdee.eas.zjbom.app.AbstractDesignBOMBillSplitFacadeControllerBean;
import com.kingdee.eas.zjbom.app.util.BomBotpUtil;
import com.kingdee.eas.zjbom.util.BomUtil;
import com.kingdee.eas.zjbom.util.ToDesignBom;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DesignBOMBillSplitFacadeControllerBean
extends AbstractDesignBOMBillSplitFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.zjbom.app.DesignBOMBillSplitFacadeControllerBean");

    @Override
    protected void _splitByBusinessRep(Context ctx, IObjectCollection bills) throws BOSException, EASBizException {
        String idstr = BomUtil.getIdsStr(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0041", (Locale)ctx.getLocale()), bills);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)idstr, CompareType.INNER));
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("parent.project.*"));
        sic.add(new SelectorItemInfo("parent.begincarno.*"));
        sic.add(new SelectorItemInfo("parent.endcarno.*"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("begincarno.*"));
        sic.add(new SelectorItemInfo("endcarno.*"));
        evi.setSelector(sic);
        evi.setFilter(filter);
        BusinessRepEntryCollection businessReps = BusinessRepEntryFactory.getLocalInstance(ctx).getBusinessRepEntryCollection(evi);
        int size = businessReps.size();
        for (int i = 0; i < size; ++i) {
            BusinessRepEntryInfo entry = (BusinessRepEntryInfo)businessReps.getObject(i);
            if (entry.getChangeType() == BusinessChangeTypeEnum.DOCCHANGE || entry.getMno() != null && entry.getMno().matches("^[Hh].*$") || entry.getPmno() != null && entry.getPmno().matches("^[Hh].*$")) continue;
            this.splitDesignBOMBill(ctx, entry);
        }
    }

    private void splitDesignBOMBill(Context ctx, BusinessRepEntryInfo businessRepEntry) throws BOSException, EASBizException {
        IDesignBOMBill idb = DesignBOMBillFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("erpbatchno1.*"));
        sic.add(new SelectorItemInfo("erpbatchno2.*"));
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("partNo", (Object)businessRepEntry.getMno(), CompareType.EQUALS));
        if (!StringUtil.isEmpty((String)businessRepEntry.getPmno())) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("parentNo", (Object)businessRepEntry.getPmno(), CompareType.EQUALS));
        }
        evi.getFilter().getFilterItems().add(new FilterItemInfo("batch", (Object)businessRepEntry.getParent().getBatch(), CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("project.number", (Object)businessRepEntry.getProject().getNumber(), CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("erpbatchno1 is not null"));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("erpbatchno2 is not null"));
        DesignBOMBillCollection dbc = idb.getDesignBOMBillCollection(evi);
        int size = dbc.size();
        if (size == 0) {
            BOTMappingInfo dbbBotp = BomBotpUtil.getBOTP(ctx, "MM_BR002");
            BusinessRepInfo info = (BusinessRepInfo)businessRepEntry.getParent().clone();
            info.getEntrys().clear();
            info.getEntrys().add(businessRepEntry);
            BomBotpUtil.createBillByBOTP2(ctx, info, dbbBotp);
        } else {
            for (int i = 0; i < size; ++i) {
                TrackNumberInfo changeEndNum;
                TrackNumberInfo changeStartNum;
                DesignBOMBillInfo info = dbc.get(i);
                boolean split = this._splitDesignBOMBillTrackNumber(ctx, (IObjectValue)info, (IObjectValue)(changeStartNum = businessRepEntry.getBegincarno()), (IObjectValue)(changeEndNum = businessRepEntry.getEndcarno()));
                if (!split) continue;
                ToDesignBom.changeDesignBomInfo(info, businessRepEntry);
                idb.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            }
        }
    }

    @Override
    protected boolean _splitDesignBOMBillTrackNumber(Context ctx, IObjectValue designBomV, IObjectValue changeStartNumV, IObjectValue changeEndNumV) throws BOSException, EASBizException {
        TrackNumberInfo endNum;
        TrackNumberInfo startNum;
        TrackNumberInfo sourceEndNum;
        DesignBOMBillInfo designBom = (DesignBOMBillInfo)designBomV;
        TrackNumberInfo changeStartNum = (TrackNumberInfo)changeStartNumV;
        TrackNumberInfo changeEndNum = (TrackNumberInfo)changeEndNumV;
        TrackNumberInfo sourceStartNum = designBom.getErpbatchno1();
        List splitTN = this._splitTrackNumber(ctx, (IObjectValue)sourceStartNum, (IObjectValue)(sourceEndNum = designBom.getErpbatchno2()), (IObjectValue)changeStartNum, (IObjectValue)changeEndNum);
        int size = splitTN.size();
        if (size == 0) {
            return false;
        }
        IDesignBOMBill idb = DesignBOMBillFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("erpbatchno1"));
        sic.add(new SelectorItemInfo("erpbatchno2"));
        if (size > 2) {
            BOTMappingInfo dbbBotp = BomBotpUtil.getBOTP(ctx, "MM_DBB001");
            CoreBaseCollection dbbs = new CoreBaseCollection();
            for (int i = 2; i < size; i += 2) {
                startNum = (TrackNumberInfo)splitTN.get(i);
                endNum = (TrackNumberInfo)splitTN.get(i + 1);
                DesignBOMBillCollection dbbCol = BomBotpUtil.createBillByBOTP(ctx, designBom, dbbBotp);
                for (int d = 0; d < dbbCol.size(); ++d) {
                    DesignBOMBillInfo info = dbbCol.get(d);
                    info.setErpbatchno1(startNum);
                    info.setErpbatchno2(endNum);
                    dbbs.add((CoreBaseInfo)info);
                }
            }
            if (dbbs.size() > 0) {
                idb.update(dbbs);
            }
        }
        startNum = (TrackNumberInfo)splitTN.get(0);
        endNum = (TrackNumberInfo)splitTN.get(1);
        designBom.setErpbatchno1(startNum);
        designBom.setErpbatchno2(endNum);
        return true;
    }

    @Override
    protected void _splitByFlowChangeRep(Context ctx, IObjectCollection bills) throws BOSException, EASBizException {
        String idstr = BomUtil.getIdsStr(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0041", (Locale)ctx.getLocale()), bills);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)idstr, CompareType.INNER));
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("ferpbatchno1.*"));
        sic.add(new SelectorItemInfo("ferpbatchno2.*"));
        sic.add(new SelectorItemInfo("sjbom.*"));
        sic.add(new SelectorItemInfo("sjbom.erpbatchno1.*"));
        sic.add(new SelectorItemInfo("sjbom.erpbatchno2.*"));
        evi.setSelector(sic);
        evi.setFilter(filter);
        FlowChangeRepEntryCollection flowchanges = FlowChangeRepEntryFactory.getLocalInstance(ctx).getFlowChangeRepEntryCollection(evi);
        int size = flowchanges.size();
        IDesignBOMBill idb = DesignBOMBillFactory.getLocalInstance(ctx);
        CoreBaseCollection updatecol = new CoreBaseCollection();
        for (int i = 0; i < size; ++i) {
            String flow;
            FlowChangeRepEntryInfo entry = (FlowChangeRepEntryInfo)flowchanges.getObject(i);
            DesignBOMBillInfo sjbom = entry.getSjbom();
            if (sjbom == null) {
                NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", entry.getParent().getNumber() + EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0073", (Locale)ctx.getLocale()));
                throw new EASBizException(exc);
            }
            TrackNumberInfo changeStartNum = entry.getFerpbatchno1();
            TrackNumberInfo changeEndNum = entry.getFerpbatchno2();
            if (changeStartNum == null || changeEndNum == null) {
                // empty if block
            }
            if (StringUtil.isEmpty((String)(flow = entry.getFlow()))) {
                NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", entry.getParent().getNumber() + EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0075", (Locale)ctx.getLocale()));
                throw new EASBizException(exc);
            }
            if (changeStartNum == null || changeEndNum == null) {
                ToDesignBom.changeDesignBomInfo(sjbom, entry);
                updatecol.add((CoreBaseInfo)sjbom);
                continue;
            }
            boolean split = this._splitDesignBOMBillTrackNumber(ctx, (IObjectValue)sjbom, (IObjectValue)changeStartNum, (IObjectValue)changeEndNum);
            if (!split) continue;
            ToDesignBom.changeDesignBomInfo(sjbom, entry);
            updatecol.add((CoreBaseInfo)sjbom);
        }
        if (updatecol.size() > 0) {
            idb.update(updatecol);
        }
    }

    @Override
    protected List _splitTrackNumber(Context ctx, IObjectValue sourceStartNum, IObjectValue sourceEndNum, IObjectValue changeStartNum, IObjectValue changeEndNum) throws BOSException, EASBizException {
        TrackNumberInfo sourceStartNumber = (TrackNumberInfo)sourceStartNum;
        TrackNumberInfo sourceEndNumber = (TrackNumberInfo)sourceEndNum;
        TrackNumberInfo changeStartNumber = (TrackNumberInfo)changeStartNum;
        TrackNumberInfo changeEndNumber = (TrackNumberInfo)changeEndNum;
        if (changeStartNum == null || changeEndNum == null) {
            ThrowUtil.showUIError((String)EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0076", (Locale)ctx.getLocale()));
        }
        ArrayList<TrackNumberInfo> result = new ArrayList<TrackNumberInfo>();
        if (sourceStartNum == null || sourceEndNum == null) {
            result.add(changeStartNumber);
            result.add(changeEndNumber);
            return result;
        }
        String ssNumber = sourceStartNumber.getNumber();
        String seNumber = sourceEndNumber.getNumber();
        String csNumber = changeStartNumber.getNumber();
        String ceNumber = changeEndNumber.getNumber();
        if (StringUtil.isEmpty((String)ssNumber) || StringUtil.isEmpty((String)ssNumber) || StringUtil.isEmpty((String)ssNumber) || StringUtil.isEmpty((String)ssNumber)) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0077", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        ITrackNumber itn = TrackNumberFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        evi.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        evi.setSorter(sorter);
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("number", (Object)ssNumber, CompareType.GREATER_EQUALS));
        filter1.getFilterItems().add(new FilterItemInfo("number", (Object)seNumber, CompareType.LESS_EQUALS));
        filter1.getFilterItems().add(new FilterItemInfo("number", (Object)csNumber, CompareType.LESS));
        evi.setFilter(filter1);
        TrackNumberCollection tnc1 = itn.getTrackNumberCollection(evi);
        if (tnc1 != null && tnc1.size() != 0) {
            TrackNumberInfo s = tnc1.get(0);
            TrackNumberInfo e = tnc1.get(tnc1.size() - 1);
            if (s.getNumber().equalsIgnoreCase(ssNumber) && e.getNumber().equalsIgnoreCase(ceNumber)) {
                return result;
            }
        }
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("number", (Object)ssNumber, CompareType.GREATER_EQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("number", (Object)seNumber, CompareType.LESS_EQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("number", (Object)ceNumber, CompareType.GREATER));
        evi.setFilter(filter2);
        TrackNumberCollection tnc2 = itn.getTrackNumberCollection(evi);
        if (tnc2 != null && tnc2.size() != 0) {
            TrackNumberInfo s = tnc2.get(0);
            TrackNumberInfo e = tnc2.get(tnc2.size() - 1);
            if (s.getNumber().equalsIgnoreCase(ssNumber) && e.getNumber().equalsIgnoreCase(ceNumber)) {
                return result;
            }
        }
        int size1 = tnc1.size();
        int size2 = tnc2.size();
        if (size1 == 0 && size2 == 0) {
            result.add(sourceStartNumber);
            result.add(sourceEndNumber);
        } else if (size1 != 0 && size2 == 0) {
            result.add(changeStartNumber);
            result.add(sourceEndNumber);
            result.add(tnc1.get(0));
            result.add(tnc1.get(tnc1.size() - 1));
        } else if (size1 == 0 && size2 != 0) {
            result.add(sourceStartNumber);
            result.add(changeEndNumber);
            result.add(tnc2.get(0));
            result.add(tnc2.get(tnc2.size() - 1));
        } else {
            result.add(changeStartNumber);
            result.add(changeEndNumber);
            result.add(tnc1.get(0));
            result.add(tnc1.get(tnc1.size() - 1));
            result.add(tnc2.get(0));
            result.add(tnc2.get(tnc2.size() - 1));
        }
        return result;
    }
}

