/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.clientUtil.ThrowUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.ISQLFacade;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.BOMChangeTypeEnum;
import com.kingdee.eas.zjbom.DesignBOMBillSplitFacadeFactory;
import com.kingdee.eas.zjbom.FlowSplitConfigCollection;
import com.kingdee.eas.zjbom.FlowSplitConfigEntryCollection;
import com.kingdee.eas.zjbom.FlowSplitConfigEntryInfo;
import com.kingdee.eas.zjbom.FlowSplitConfigFactory;
import com.kingdee.eas.zjbom.FlowSplitConfigInfo;
import com.kingdee.eas.zjbom.IDesignBOMBillSplitFacade;
import com.kingdee.eas.zjbom.IProcessBomBill;
import com.kingdee.eas.zjbom.IProcessBomBillOld;
import com.kingdee.eas.zjbom.IProcessBomChangeBill;
import com.kingdee.eas.zjbom.IProcessBomChangeBillEntry;
import com.kingdee.eas.zjbom.ProcessBomBillCollection;
import com.kingdee.eas.zjbom.ProcessBomBillFactory;
import com.kingdee.eas.zjbom.ProcessBomBillInfo;
import com.kingdee.eas.zjbom.ProcessBomBillOldFactory;
import com.kingdee.eas.zjbom.ProcessBomBillOldInfo;
import com.kingdee.eas.zjbom.ProcessBomChangeBillCollection;
import com.kingdee.eas.zjbom.ProcessBomChangeBillEntryCollection;
import com.kingdee.eas.zjbom.ProcessBomChangeBillEntryFactory;
import com.kingdee.eas.zjbom.ProcessBomChangeBillEntryInfo;
import com.kingdee.eas.zjbom.ProcessBomChangeBillFacadeFactory;
import com.kingdee.eas.zjbom.ProcessBomChangeBillFactory;
import com.kingdee.eas.zjbom.ProcessBomChangeBillInfo;
import com.kingdee.eas.zjbom.UpdateMaterialNotFinishFactory;
import com.kingdee.eas.zjbom.UpdateMaterialNotFinishInfo;
import com.kingdee.eas.zjbom.app.AbstractProcessBomChangeBillControllerBean;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.eas.zjbom.app.util.BomBotpUtil;
import com.kingdee.eas.zjbom.util.BomUtil;
import com.kingdee.eas.zjbom.util.BomUtilZY;
import com.kingdee.eas.zjbom.util.ToProcessBomChangeBill;
import com.kingdee.eas.zjbom.util.ToSplitSingleProcess;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProcessBomChangeBillControllerBean
extends AbstractProcessBomChangeBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.zjbom.app.ProcessBomChangeBillControllerBean");
    private String RESURL = "com.kingdee.eas.zjbom.EMMEMZjResource";

    @Override
    public Map _getChangeMsg(Context ctx, List ids) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        String idStr = this.getIdsStr(ctx, ids);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("ptsNumberP"));
        sic.add(new SelectorItemInfo("ptsNameP"));
        sic.add(new SelectorItemInfo("afterFlow"));
        sic.add(new SelectorItemInfo("fixed"));
        sic.add(new SelectorItemInfo("assemblyQty"));
        sic.add(new SelectorItemInfo("trackNumberStart.number"));
        sic.add(new SelectorItemInfo("trackNumberEnd.number"));
        sic.add(new SelectorItemInfo("oldBom.portNo"));
        sic.add(new SelectorItemInfo("oldBom.name"));
        sic.add(new SelectorItemInfo("oldBom.makeFlow"));
        sic.add(new SelectorItemInfo("oldBom.ration"));
        sic.add(new SelectorItemInfo("oldBom.quantity"));
        sic.add(new SelectorItemInfo("oldBom.beginCarno.number"));
        sic.add(new SelectorItemInfo("oldBom.endCarno.number"));
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        ProcessBomChangeBillCollection sspCol = this.getProcessBomChangeBillCollection(ctx, evi);
        int size = sspCol.size();
        if (size < 0) {
            return result;
        }
        StringBuilder title = new StringBuilder(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0244", (Locale)ctx.getLocale())).append("\u3010");
        for (int i = 0; i < size; ++i) {
            ProcessBomChangeBillInfo info = sspCol.get(i);
            title.append(info.getNumber()).append(" ");
            String msg = this.getChangeMsg(ctx, info);
            if (!StringUtils.isEmpty((String)msg)) {
                msg = EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0244", (Locale)ctx.getLocale()) + "[" + info.getNumber() + "]\uff0c" + msg;
            }
            result.put(info.getId().toString(), msg);
        }
        title.append("\u3011").append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0245", (Locale)ctx.getLocale()));
        result.put("title", title.toString());
        return result;
    }

    private void addOldBom(Context ctx, IObjectPK pk, ProcessBomChangeBillInfo info) throws BOSException, EASBizException {
        ProcessBomBillInfo processbom;
        ProcessBomBillOldInfo oldbom = info.getOldBom();
        if (oldbom == null && (processbom = info.getProcessBom()) != null && processbom.getId() != null) {
            ObjectUuidPK bpk = new ObjectUuidPK(processbom.getId());
            BOTMappingInfo botpinfo = BomBotpUtil.getBOTP(ctx, "MM_PBB001");
            ProcessBomBillInfo bom = ProcessBomBillFactory.getLocalInstance(ctx).getProcessBomBillInfo((IObjectPK)bpk);
            oldbom = BomBotpUtil.createBillByBOTP(ctx, bom, botpinfo);
        }
        if (oldbom == null) {
            return;
        }
        IProcessBomBillOld ipb = ProcessBomBillOldFactory.getLocalInstance(ctx);
        ipb.save((CoreBaseInfo)oldbom);
        info.setOldBom(oldbom);
    }

    private ProcessBomBillInfo addProcessBom(Context ctx, ProcessBomChangeBillInfo changeBill) throws EASBizException, BOSException {
        BOTMappingInfo botInfo = BomBotpUtil.getBOTP(ctx, "MM_PBCB004");
        ProcessBomBillInfo processBom = BomBotpUtil.createBillByBOTP4(ctx, changeBill, botInfo);
        if (changeBill.isZZNoChildToBom()) {
            processBom.setZZNoChildToBom(changeBill.isZZNoChildToBom());
        }
        processBom.setIsAdd(true);
        changeBill.setProcessBom(processBom);
        return processBom;
    }

    private void afterAudit(Context ctx, List ids, boolean throwError) throws BOSException, EASBizException {
        try {
            StringBuilder sql = new StringBuilder();
            StringBuilder errorMessages = new StringBuilder();
            errorMessages.setLength(0);
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("PBCB.FNumber FNumber,\r\n");
            sql.append("PBCB.CFPTSNumberP FPartNo,\r\n");
            sql.append("PBCB.CFParentPTSNumberP FParentPartNo,\r\n");
            sql.append("PBCB.CFBatchNo FBatchNo,\r\n");
            sql.append("P.FNumber FProjectNumber,\r\n");
            sql.append("TN.FNumber FTrackNumber\r\n");
            sql.append("From CT_ZJB_ProcessBOMChangeBill PBCB\r\n");
            sql.append("Inner Join T_MM_Project P On P.FID=PBCB.FProjectNo\r\n");
            sql.append("Inner Join T_MM_TrackNumber STN On STN.FID=PBCB.FTrackNumberStart\r\n");
            sql.append("Inner Join T_MM_TrackNumber ETN On ETN.FID=PBCB.FTrackNumberEnd\r\n");
            sql.append("Inner Join T_MM_TrackNumber TN On\r\n");
            sql.append("1=1\r\n");
            sql.append("And TN.FNumber>=STN.FNumber\r\n");
            sql.append("And TN.FNumber<=ETN.FNumber\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And PBCB.FID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])ids.toArray())).append("\r\n");
            sql.append(")\r\n");
            sql.append("And IsNull((\r\n");
            sql.append("Select\r\n");
            sql.append("Count(1)\r\n");
            sql.append("From CT_ZJB_ProcessBOMBill PBB\r\n");
            sql.append("Inner Join T_MM_TrackNumber TSTN On TSTN.FID=PBB.CFBeginCarNoID\r\n");
            sql.append("Inner Join T_MM_TrackNumber TETN On TETN.FID=PBB.CFEndCarNoID\r\n");
            sql.append("Inner Join T_MM_TrackNumber TTN On\r\n");
            sql.append("1=1\r\n");
            sql.append("And TTN.FNumber>=TSTN.FNumber\r\n");
            sql.append("And TTN.FNumber<=TETN.FNumber\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And PBB.CFBatch=PBCB.CFBatchNo\r\n");
            sql.append("And PBB.CFPortNo=PBCB.CFPTSNumberP\r\n");
            sql.append("And PBB.CFParentNo=PBCB.CFParentPTSNumberP\r\n");
            sql.append("And TTN.FID=TN.FID\r\n");
            sql.append("And PBB.FID<>PBCB.CFProcessBOMID\r\n");
            sql.append("),0)>0\r\n");
            IRowSet checkRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (checkRowSet != null && checkRowSet.size() > 0) {
                while (checkRowSet.next()) {
                    String number = checkRowSet.getString("FNumber") == null ? "" : checkRowSet.getString("FNumber");
                    String partNo = checkRowSet.getString("FPartNo") == null ? "" : checkRowSet.getString("FPartNo");
                    String parentPartNo = checkRowSet.getString("FParentPartNo") == null ? "" : checkRowSet.getString("FParentPartNo");
                    String batchNo = checkRowSet.getString("FBatchNo") == null ? "" : checkRowSet.getString("FBatchNo");
                    String projectNumber = checkRowSet.getString("FProjectNumber") == null ? "" : checkRowSet.getString("FProjectNumber");
                    String trackNumber = checkRowSet.getString("FTrackNumber") == null ? "" : checkRowSet.getString("FTrackNumber");
                    String strInfo = ResourceBase.getString((String)this.RESURL, (String)"GYBOMGGDXGJS_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{number, partNo, parentPartNo, batchNo, projectNumber, trackNumber});
                    errorMessages.append(strInfo).append("\r\n");
                }
            }
            if (errorMessages.toString().trim().length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0246", (Locale)ctx.getLocale()), errorMessages.toString()));
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
    }

    private boolean checkAudit(Context ctx, List ids, boolean throwError) throws BOSException, EASBizException {
        boolean check = false;
        if (ids == null || ids.size() <= 0) {
            return check;
        }
        String idStr = this.getIdsStr(ctx, ids);
        IProcessBomChangeBill issp = ProcessBomChangeBillFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4));
        check = issp.exists(filter);
        if (check && throwError) {
            String errMsg = EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0030", (Locale)ctx.getLocale());
            if (ids.size() == 1) {
                errMsg = EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0031", (Locale)ctx.getLocale());
            }
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", errMsg);
            throw new EASBizException(exc);
        }
        return check;
    }

    private boolean checkFlowHasSplit(Context ctx, List ids, boolean throwError) throws BOSException, EASBizException {
        boolean check = false;
        if (ids == null || ids.size() == 0) {
            return check;
        }
        String idStr = this.getIdsStr(ctx, ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("flowHasSplit", (Object)true));
        check = this.exists(ctx, filter);
        if (check && throwError) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0247", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        FilterInfo filterOr = new FilterInfo();
        filterOr.getFilterItems().add(new FilterItemInfo("technologicalFlow is null"));
        FilterInfo filterOr2 = new FilterInfo();
        filterOr2.getFilterItems().add(new FilterItemInfo("technologicalFlow", (Object)"", CompareType.EQUALS));
        filterOr.mergeFilter(filterOr2, "or");
        filter.mergeFilter(filterOr, "and");
        boolean bl = check = check || this.exists(ctx, filter);
        if (check && throwError) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0248", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        return check;
    }

    private boolean checkMaterialSplit(Context ctx, List ids, boolean throwError) throws BOSException, EASBizException {
        boolean check = false;
        if (ids == null || ids.size() == 0) {
            return check;
        }
        String idStr = this.getIdsStr(ctx, ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("materialSplit", (Object)true));
        check = this.exists(ctx, filter);
        if (check && throwError) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0249", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("flowHasSplit", (Object)false));
        boolean bl = check = check || this.exists(ctx, filter);
        if (check && throwError) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0250", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        FilterInfo filterOr = new FilterInfo();
        filterOr.getFilterItems().add(new FilterItemInfo("materialNumberP is null"));
        FilterInfo filterOr2 = new FilterInfo();
        filterOr2.getFilterItems().add(new FilterItemInfo("materialNumberP", (Object)"", CompareType.EQUALS));
        filterOr.mergeFilter(filterOr2, "or");
        filter.mergeFilter(filterOr, "and");
        boolean bl2 = check = check || this.exists(ctx, filter);
        if (check && throwError) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0251", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        filter = new FilterInfo();
        HashSet<Integer> materialPropSet = new HashSet<Integer>();
        materialPropSet.add(10030);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("materialSources", materialPropSet, CompareType.INCLUDE));
        boolean check4 = this.exists(ctx, filter);
        boolean bl3 = check = check || check4;
        if (!check4 && throwError) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0252", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        return check;
    }

    private boolean checkNotCorrectlyType(Context ctx, List ids, boolean throwError) throws BOSException, EASBizException {
        boolean check = false;
        if (ids == null || ids.size() <= 0) {
            return check;
        }
        String idStr = this.getIdsStr(ctx, ids);
        IProcessBomChangeBill issp = ProcessBomChangeBillFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("bomChangeType", (Object)BOMChangeTypeEnum.correctly, CompareType.NOTEQUALS));
        check = issp.exists(filter);
        if (check && throwError) {
            String errMsg = EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0253", (Locale)ctx.getLocale());
            if (ids.size() > 1) {
                errMsg = EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0254", (Locale)ctx.getLocale()) + errMsg;
            }
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", errMsg);
            throw new EASBizException(exc);
        }
        return check;
    }

    private void deleteEntry(Context ctx, ProcessBomChangeBillEntryCollection entrys) throws BOSException, EASBizException {
        if (entrys == null || entrys.size() == 0) {
            return;
        }
        ArrayList<IObjectPK> delEntry = new ArrayList<IObjectPK>();
        for (int i = 0; i < entrys.size(); ++i) {
            ProcessBomChangeBillEntryInfo entryInfo = entrys.get(i);
            String id = entryInfo.getId().toString();
            delEntry.add((IObjectPK)new ObjectUuidPK(id));
        }
        if (delEntry.size() > 0) {
            IObjectPK[] del = this.getPK(delEntry);
            IProcessBomChangeBillEntry ipbce = ProcessBomChangeBillEntryFactory.getLocalInstance(ctx);
            ipbce.delete(del);
        }
    }

    private void flowHasSplit(Context ctx, ProcessBomChangeBillInfo info) {
        Date now = new Date();
        UserInfo user = BomUtil.getCurrentUser(ctx);
        info.setFlowHasSplit(true);
        info.setFlowSplitTime(now);
        info.setFlowSplitUser(user);
    }

    private String getChangeMsg(Context ctx, ProcessBomChangeBillInfo info) {
        String trackNumberEndOld;
        String trackNumberStartOld;
        BigDecimal fixedOld;
        String afterFlowOld;
        String trackNumberEnd;
        StringBuilder msg = new StringBuilder();
        info.getPtsNumberP();
        info.getPtsNameP();
        String afterFlow = info.getAfterFlow();
        BigDecimal fixed = info.getFixed();
        info.getAssemblyQty();
        String trackNumberStart = info.getTrackNumberStart() == null ? "" : info.getTrackNumberStart().getNumber();
        String string = trackNumberEnd = info.getTrackNumberEnd() == null ? "" : info.getTrackNumberEnd().getNumber();
        if (info.getOldBom() == null) {
            afterFlowOld = "";
            fixedOld = null;
            trackNumberStartOld = "";
            trackNumberEndOld = "";
        } else {
            info.getOldBom().getPortNo();
            info.getOldBom().getName();
            afterFlowOld = info.getOldBom().getMakeFlow();
            fixedOld = info.getOldBom().getRation();
            info.getOldBom().getQuantity();
            trackNumberStartOld = info.getOldBom().getBeginCarno() == null ? "" : info.getOldBom().getBeginCarno().getNumber();
            String string2 = trackNumberEndOld = info.getOldBom().getEndCarno() == null ? "" : info.getOldBom().getEndCarno().getNumber();
        }
        if (!StringUtils.equalsIgnoreCase((String)afterFlow, (String)afterFlowOld)) {
            this.setChangeMsg(ctx, msg, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0255", (Locale)ctx.getLocale()), afterFlowOld, afterFlow);
        }
        if (!BomUtil.equals(fixed, fixedOld)) {
            this.setChangeMsg(ctx, msg, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0256", (Locale)ctx.getLocale()), fixedOld, fixed);
        }
        if (!StringUtils.equalsIgnoreCase((String)trackNumberStart, (String)trackNumberStartOld) || !StringUtils.equalsIgnoreCase((String)trackNumberEnd, (String)trackNumberEndOld)) {
            msg.append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0257", (Locale)ctx.getLocale())).append("(").append(trackNumberStart).append("-").append(trackNumberEnd).append(")\uff1b");
        }
        return msg.toString();
    }

    private FlowSplitConfigInfo getFlowSplitConfig(Context ctx, String flow) throws BOSException, EASBizException {
        FlowSplitConfigInfo info = null;
        FlowSplitConfigCollection fscc = FlowSplitConfigFactory.getLocalInstance(ctx).getFlowSplitConfigCollection("select *,Entry.* where FlowName = '" + flow.trim() + "' order by entry.seq");
        if (fscc.size() == 0) {
            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"WLCDCFPZ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{flow});
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", strInfo);
            throw new EASBizException(exc);
        }
        info = fscc.get(0);
        return info;
    }

    private String getIdsStr(Context ctx, List ids) throws EASBizException {
        return BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0258", (Locale)ctx.getLocale()));
    }

    private IObjectPK[] getPK(List<IObjectPK> list) {
        IObjectPK[] pks = new IObjectPK[list.size()];
        list.toArray(pks);
        return pks;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("flowSplitUser.person.id"));
        sic.add(new SelectorItemInfo("materialSplitUser.person.id"));
        sic.add(new SelectorItemInfo("processBom.*"));
        sic.add(new SelectorItemInfo("processBom.beginCarno.name"));
        sic.add(new SelectorItemInfo("processBom.beginCarno.number"));
        sic.add(new SelectorItemInfo("processBom.endCarno.name"));
        sic.add(new SelectorItemInfo("processBom.endCarno.number"));
        sic.add(new SelectorItemInfo("oldBom.*"));
        sic.add(new SelectorItemInfo("oldBom.beginCarno.name"));
        sic.add(new SelectorItemInfo("oldBom.beginCarno.number"));
        sic.add(new SelectorItemInfo("oldBom.endCarno.name"));
        sic.add(new SelectorItemInfo("oldBom.endCarno.number"));
        sic.add(new SelectorItemInfo("projectNo.name"));
        sic.add(new SelectorItemInfo("projectNo.number"));
        sic.add(new SelectorItemInfo("trackNumberStart.name"));
        sic.add(new SelectorItemInfo("trackNumberStart.number"));
        sic.add(new SelectorItemInfo("trackNumberEnd.name"));
        sic.add(new SelectorItemInfo("trackNumberEnd.number"));
        sic.add(new SelectorItemInfo("entrys.*"));
        return sic;
    }

    private void initBaseStatus(ProcessBomChangeBillInfo info) {
        BillBaseStatusEnum status = BillBaseStatusEnum.TEMPORARILYSAVED;
        if (info.getBaseStatus() == null || info.getBaseStatus().getValue() < status.getValue()) {
            info.setBaseStatus(status);
        }
    }

    private void materialSplit(Context ctx, ProcessBomChangeBillInfo info) {
        Date now = new Date();
        UserInfo user = BomUtil.getCurrentUser(ctx);
        info.setMaterialSplit(true);
        info.setMaterialSplitTime(now);
        info.setMaterialSplitUser(user);
    }

    private void setChangeMsg(Context ctx, StringBuilder msg, String cm, Object old, Object now) {
        msg.append(cm).append("(").append(old).append(")").append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0259", (Locale)ctx.getLocale())).append("(").append(now).append(");");
    }

    private void syncProcessWordsConfigInfo(ProcessBomChangeBillInfo sspInfo, FlowSplitConfigEntryInfo entryInfo) throws BOSException, EASBizException {
        ToProcessBomChangeBill.syncProcessWordsConfigInfo(sspInfo, entryInfo);
    }

    private void updateBomByAudit(Context ctx, ProcessBomBillCollection processBoms) throws BOSException, EASBizException {
        if (processBoms == null || processBoms.size() == 0) {
            return;
        }
        int size = processBoms.size();
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            ProcessBomBillInfo processbom = processBoms.get(i);
            ids.add(processbom.getId().toString());
        }
        IProcessBomBill ipb = ProcessBomBillFactory.getLocalInstance(ctx);
        List errors = ipb.checkProcessBom(processBoms);
        if (errors != null && errors.size() > 0) {
            StringBuilder es = new StringBuilder();
            int esize = errors.size();
            for (int i = 0; i < esize; ++i) {
                es.append(errors.get(i)).append("\n");
            }
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0260", (Locale)ctx.getLocale()) + "\n" + es.toString());
            throw new EASBizException(exc, errors.toArray());
        }
        Map result = ipb.createToBom(ids, true);
        errors = (List)result.get("errListHt");
        if (errors != null && errors.size() > 0) {
            StringBuilder es = new StringBuilder();
            int esize = errors.size();
            for (int i = 0; i < esize; ++i) {
                es.append(errors.get(i)).append("\n");
            }
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0261", (Locale)ctx.getLocale()) + "\n" + es.toString());
            throw new EASBizException(exc, errors.toArray());
        }
    }

    private void updateEntry(Context ctx, IObjectPK pk, ProcessBomChangeBillInfo info) throws BOSException, EASBizException {
        IProcessBomChangeBillEntry ipbce = ProcessBomChangeBillEntryFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("content.id"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pk.toString()));
        evi.setFilter(filter);
        ProcessBomChangeBillEntryCollection entrys = ipbce.getProcessBomChangeBillEntryCollection(evi);
        if (info.getEntrys() == null || info.getEntrys().size() == 0) {
            this.deleteEntry(ctx, entrys);
            return;
        }
        ArrayList<String> updateIds = new ArrayList<String>();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            ProcessBomChangeBillEntryInfo ue = info.getEntrys().get(i);
            ue.setParent(info);
            if (ue.getId() == null) continue;
            String id = ue.getId().toString();
            updateIds.add(id);
        }
        if (updateIds.size() == 0) {
            this.deleteEntry(ctx, entrys);
        } else if (entrys != null && entrys.size() > 0) {
            ProcessBomChangeBillEntryCollection dels = new ProcessBomChangeBillEntryCollection();
            for (int j = 0; j < entrys.size(); ++j) {
                ProcessBomChangeBillEntryInfo entryInfo = entrys.get(j);
                String id = entryInfo.getId().toString();
                if (updateIds.contains(id)) continue;
                dels.add(entryInfo);
            }
            this.deleteEntry(ctx, dels);
        }
        ProcessBomChangeBillFacadeFactory.getLocalInstance(ctx).saveIntroducingChildLayer(info.getEntrys());
    }

    private void updateProcessBom(Context ctx, ProcessBomBillInfo processBom, ProcessBomChangeBillInfo changeBill) throws EASBizException, BOSException {
        BOTMappingInfo botInfo = BomBotpUtil.getBOTP(ctx, "MM_PBCB004");
        ProcessBomBillInfo pb = BomBotpUtil.createBillByBOTP4(ctx, changeBill, botInfo);
        BOSUuid id = processBom.getId();
        processBom.putAll((IObjectValue)pb);
        processBom.setId(id);
        if (changeBill.isZZNoChildToBom()) {
            processBom.setZZNoChildToBom(changeBill.isZZNoChildToBom());
        }
    }

    private ProcessBomBillCollection updateProcessBomByAudit(Context ctx, ProcessBomChangeBillCollection changebills) throws EASBizException, BOSException {
        ProcessBomBillCollection result = new ProcessBomBillCollection();
        if (changebills == null || changebills.size() == 0) {
            return result;
        }
        new Date();
        BomUtil.getCurrentUser(ctx);
        CoreBaseCollection adds = new CoreBaseCollection();
        CoreBaseCollection updates = new CoreBaseCollection();
        IDesignBOMBillSplitFacade isplit = DesignBOMBillSplitFacadeFactory.getLocalInstance(ctx);
        for (int i = 0; i < changebills.size(); ++i) {
            ProcessBomChangeBillInfo changebill = changebills.get(i);
            changebill.setUpdateOfficialTable(true);
            ProcessBomBillInfo processBom = changebill.getProcessBom();
            if (processBom == null) {
                ProcessBomBillInfo add = this.addProcessBom(ctx, changebill);
                adds.addObject((IObjectValue)add);
                continue;
            }
            TrackNumberInfo sourceStartNum = processBom.getBeginCarno();
            TrackNumberInfo sourceEndNum = processBom.getEndCarno();
            TrackNumberInfo changeStartNum = changebill.getTrackNumberStart();
            TrackNumberInfo changeEndNum = changebill.getTrackNumberEnd();
            if (changeStartNum == null || changeEndNum == null) {
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"GYBOMGGDQSQZCH_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{changebill.getNumber()});
                ThrowUtil.showUIError((String)strInfo);
            }
            if (sourceStartNum != null && sourceEndNum != null) {
                TrackNumberInfo endNum;
                TrackNumberInfo startNum;
                List splitTN = isplit.splitTrackNumber(sourceStartNum, sourceEndNum, changeStartNum, changeEndNum);
                int size = splitTN.size();
                if (size == 0) continue;
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("beginCarno"));
                sic.add(new SelectorItemInfo("endCarno"));
                if (size > 2) {
                    for (int j = 2; j < size; j += 2) {
                        startNum = (TrackNumberInfo)splitTN.get(j);
                        endNum = (TrackNumberInfo)splitTN.get(j + 1);
                        ProcessBomBillInfo pb = (ProcessBomBillInfo)processBom.clone();
                        pb.setId(BOSUuid.create((BOSObjectType)processBom.getBOSType()));
                        pb.setBeginCarno(startNum);
                        pb.setEndCarno(endNum);
                        adds.addObject((IObjectValue)pb);
                    }
                }
                startNum = (TrackNumberInfo)splitTN.get(0);
                endNum = (TrackNumberInfo)splitTN.get(1);
                processBom.setBeginCarno(startNum);
                processBom.setEndCarno(endNum);
            }
            this.updateProcessBom(ctx, processBom, changebill);
            updates.addObject((IObjectValue)processBom);
        }
        IProcessBomBill ipb = ProcessBomBillFactory.getLocalInstance(ctx);
        if (updates.size() > 0) {
            for (int i = 0; i < updates.size(); ++i) {
                ProcessBomBillInfo cb = (ProcessBomBillInfo)updates.get(i);
                ipb.update((IObjectPK)new ObjectUuidPK(cb.getId()), (CoreBaseInfo)cb);
            }
            result.addObjectCollection((IObjectCollection)updates);
        }
        if (adds.size() > 0) {
            for (int i = 0; i < adds.size(); ++i) {
                ipb.addnew(adds.get(i));
            }
            result.addObjectCollection((IObjectCollection)adds);
        }
        return result;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ProcessBomChangeBillInfo info = (ProcessBomChangeBillInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            AutoNumberUtil.initNumber(ctx, (IObjectValue)info);
        }
        this.initBaseStatus(info);
        this.addOldBom(ctx, pk, info);
        super._addnew(ctx, pk, model);
        Object o = info.get("relations");
        if (o != null && BOTRelationCollection.class.isInstance(o)) {
            IBOTRelation ibr = BOTRelationFactory.getLocalInstance((Context)ctx);
            info.remove("relations");
            BOTRelationCollection col = (BOTRelationCollection)o;
            for (int a = 0; a < col.size(); ++a) {
                ibr.addnew(col.get(a));
            }
        }
        this.updateEntry(ctx, pk, info);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProcessBomChangeBillInfo info = (ProcessBomChangeBillInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            AutoNumberUtil.initNumber(ctx, (IObjectValue)info);
        }
        IObjectPK pk = super._addnew(ctx, model);
        Object o = info.get("relations");
        if (o != null && BOTRelationCollection.class.isInstance(o)) {
            IBOTRelation ibr = BOTRelationFactory.getLocalInstance((Context)ctx);
            info.remove("relations");
            BOTRelationCollection col = (BOTRelationCollection)o;
            for (int a = 0; a < col.size(); ++a) {
                ibr.addnew(col.get(a));
            }
        }
        this.addOldBom(ctx, pk, info);
        this.updateEntry(ctx, pk, info);
        return pk;
    }

    @Override
    protected void _isToPBOM(Context ctx, List ids, HashMap map) throws BOSException, EASBizException {
        ArrayList rowAarray = new ArrayList();
        String idStr = BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0013", (Locale)ctx.getLocale()));
        StringBuffer sql = new StringBuffer();
        sql.append("select pbe.fid as pfid from T_MM_PBOMEntry pbe");
        sql.append(" inner join t_mm_pbom pbh on pbh.fid = pbe.fparentid");
        sql.append(" inner join t_mm_bomentry be on pbe.FBomItemID=be.fid ");
        sql.append(" inner join CT_ZJB_ProcessBomBill pb on be.FSourceProcessId=pb.fid ");
        sql.append(" inner join CT_ZJB_ProcessBomChangeBill pbc on pbc.cfprocessbomid=pb.fid");
        sql.append(" where pbc.fid in ( " + idStr + " )");
        sql.append(" and pbc.CFFixed =0");
        sql.append(" and Not Exists(select 1 from t_bas_param ph inner join t_bas_paramitem pd on ph.fid = pd.fkeyid where ph.fnumber = 'EMMProcessBomChangeAuditSyncPBOM' and pd.forgunitid = pbh.fstorageorgunitid and pd.fvalue_l2 = 'true' )");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<String> idList = new ArrayList<String>();
            while (rowset.next()) {
                String pbomEntryID = rowset.getString("pfid") == null ? "" : rowset.getString("pfid");
                if (idList.contains(pbomEntryID)) continue;
                idList.add(pbomEntryID);
            }
            if (!idList.isEmpty()) {
                sql.setLength(0);
                sql.append("delete from T_MM_PBOMEntry where fid in" + this.getStringIDByList(idList));
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (SQLException e1) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", "");
            throw new EASBizException(exc);
        }
    }

    private String getStringIDByList(List idList) {
        StringBuffer strBuf = new StringBuffer();
        Iterator it = idList.iterator();
        strBuf.append("(");
        while (it.hasNext()) {
            strBuf.append("'");
            strBuf.append(it.next());
            strBuf.append("',");
        }
        if (strBuf.length() != "(".length()) {
            strBuf.deleteCharAt(strBuf.length() - 1);
            strBuf.append(")");
        } else {
            strBuf.append(")");
        }
        return strBuf.toString();
    }

    @Override
    protected void _batchPassAudit(Context ctx, List ids) throws EASBizException, BOSException {
        String idStr = BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0013", (Locale)ctx.getLocale()));
        HashSet set = new HashSet();
        ArrayList<String> nos = new ArrayList<String>();
        EntityViewInfo e = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        e.setFilter(f);
        ProcessBomChangeBillCollection pbcb = this.getProcessBomChangeBillCollection(ctx, e);
        for (int i = 0; i < pbcb.size(); ++i) {
            ProcessBomChangeBillInfo pbcbinfo = pbcb.get(i);
            nos.add(pbcbinfo.getNumber());
        }
        IObjectPK instancePK = null;
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0262", (Locale)ctx.getLocale()), (BOSObjectType)this.getBOSType(), instancePK, (String)((Object)nos).toString(), (String)"ProcessBomChangeBill_audit");
        this.checkAudit(ctx, ids, true);
        this.checkNotCorrectlyType(ctx, ids, true);
        FilterInfo filter = new FilterInfo();
        StringBuilder maskString = new StringBuilder();
        int m = 0;
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        maskString.append("#").append(m++).append(" and (");
        filter.getFilterItems().add(new FilterItemInfo("pts.id is null"));
        maskString.append(" #").append(m++);
        filter.getFilterItems().add(new FilterItemInfo("parentPts.id is null"));
        maskString.append(" or #").append(m++);
        filter.getFilterItems().add(new FilterItemInfo("afterFlow is null"));
        maskString.append(" or #").append(m++);
        filter.getFilterItems().add(new FilterItemInfo("fixed is null"));
        maskString.append(" or #").append(m++);
        filter.getFilterItems().add(new FilterItemInfo("unitP is null"));
        maskString.append(" or #").append(m++);
        filter.getFilterItems().add(new FilterItemInfo("leadInOrgUnitEAS.id is null"));
        maskString.append(" or #").append(m++);
        filter.getFilterItems().add(new FilterItemInfo("suppliesOrgUnitEAS.id is null"));
        maskString.append(" or #").append(m++);
        filter.getFilterItems().add(new FilterItemInfo("materialSources", (Object)0, CompareType.EQUALS));
        maskString.append(" or #").append(m++);
        filter.getFilterItems().add(new FilterItemInfo("batchNo is null"));
        maskString.append(" or #").append(m++);
        filter.getFilterItems().add(new FilterItemInfo("projectNo.id is null"));
        maskString.append(" or #").append(m++);
        filter.getFilterItems().add(new FilterItemInfo("trackNumberStart.id is null"));
        maskString.append(" or #").append(m++);
        filter.getFilterItems().add(new FilterItemInfo("trackNumberEnd.id is null"));
        maskString.append(" or #").append(m++);
        maskString.append(" )");
        filter.setMaskString(maskString.toString());
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("afterFlow"));
        evi.getSelector().add(new SelectorItemInfo("fixed"));
        evi.getSelector().add(new SelectorItemInfo("unitP"));
        evi.getSelector().add(new SelectorItemInfo("batchNo"));
        evi.getSelector().add(new SelectorItemInfo("pts.number"));
        evi.getSelector().add(new SelectorItemInfo("parentPts.number"));
        evi.getSelector().add(new SelectorItemInfo("projectNo.number"));
        evi.getSelector().add(new SelectorItemInfo("trackNumberStart.number"));
        evi.getSelector().add(new SelectorItemInfo("trackNumberEnd.number"));
        evi.getSelector().add(new SelectorItemInfo("leadInOrgUnitEAS.number"));
        evi.getSelector().add(new SelectorItemInfo("suppliesOrgUnitEAS.number"));
        evi.getSelector().add(new SelectorItemInfo("leadInOrgUnit.number"));
        evi.getSelector().add(new SelectorItemInfo("suppliesOrgUnit.number"));
        ProcessBomChangeBillCollection errorBill = this.getProcessBomChangeBillCollection(ctx, evi);
        StringBuilder error = new StringBuilder();
        int size = errorBill.size();
        for (int i = 0; i < size; ++i) {
            ProcessBomChangeBillInfo bomchange = errorBill.get(i);
            error.append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0263", (Locale)ctx.getLocale())).append("\u3010").append(bomchange.getNumber()).append("\u3011");
            if (UIRuleUtil.isNull((String)bomchange.getAfterFlow())) {
                error.append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0264", (Locale)ctx.getLocale()));
            }
            if (UIRuleUtil.isNull((BigDecimal)bomchange.getFixed())) {
                error.append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0265", (Locale)ctx.getLocale()));
            }
            if (UIRuleUtil.isNull((String)bomchange.getUnitP())) {
                error.append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0266", (Locale)ctx.getLocale()));
            }
            if (UIRuleUtil.isNull((String)bomchange.getBatchNo())) {
                error.append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0267", (Locale)ctx.getLocale()));
            }
            if (UIRuleUtil.isNull((Object)bomchange.getPts())) {
                error.append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0268", (Locale)ctx.getLocale()));
            }
            if (UIRuleUtil.isNull((Object)bomchange.getParentPts())) {
                error.append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0269", (Locale)ctx.getLocale()));
            }
            if (UIRuleUtil.isNull((Object)bomchange.getProjectNo())) {
                error.append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0270", (Locale)ctx.getLocale()));
            }
            if (UIRuleUtil.isNull((Object)bomchange.getTrackNumberStart())) {
                error.append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0271", (Locale)ctx.getLocale()));
            }
            if (UIRuleUtil.isNull((Object)bomchange.getTrackNumberEnd())) {
                error.append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0272", (Locale)ctx.getLocale()));
            }
            if (UIRuleUtil.isNull((Object)bomchange.getLeadInOrgUnitEAS())) {
                error.append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0273", (Locale)ctx.getLocale()));
            }
            if (UIRuleUtil.isNull((Object)bomchange.getSuppliesOrgUnitEAS())) {
                error.append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0274", (Locale)ctx.getLocale()));
            }
            if (UIRuleUtil.isNull((Object)bomchange.getMaterialSources())) {
                error.append(" \u7269\u6599\u5c5e\u6027\u4e3a\u7a7a");
            }
            error.append("\n");
        }
        if (error.length() > 0) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", error.toString());
            throw new EASBizException(exc);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        FilterInfo filterOr = new FilterInfo();
        filterOr.getFilterItems().add(new FilterItemInfo("mainChangeForm.id", (Object)idStr, CompareType.INNER));
        filterOr.getFilterItems().add(new FilterItemInfo("bomChangeType", (Object)"0", CompareType.NOTEQUALS));
        filter.mergeFilter(filterOr, "or");
        EntityViewInfo evi2 = new EntityViewInfo();
        evi2.setSelector(this.getSelector());
        evi2.setFilter(filter);
        ProcessBomChangeBillCollection pbcCol = this.getProcessBomChangeBillCollection(ctx, evi2);
        int size2 = pbcCol.size();
        if (size2 == 0) {
            return;
        }
        ArrayList<Object> allid = new ArrayList<Object>();
        Date now = new Date();
        UserInfo user = BomUtil.getCurrentUser(ctx);
        CoreBaseCollection changeBillCol = new CoreBaseCollection();
        for (int i = 0; i < pbcCol.size(); ++i) {
            ProcessBomChangeBillInfo changeBill = pbcCol.get(i);
            changeBill.setBaseStatus(BillBaseStatusEnum.AUDITED);
            changeBill.setAuditor(user);
            changeBill.setAuditTime(now);
            String remark = this.getChangeMsg(ctx, changeBill);
            if (!StringUtils.isEmpty((String)remark)) {
                if (!StringUtils.isEmpty((String)changeBill.getRemarks())) {
                    remark = changeBill.getRemarks() + "\n" + remark;
                }
                changeBill.setRemarks(remark.substring(0, remark.length() > 255 ? 255 : remark.length() - 1));
            }
            changeBillCol.add((CoreBaseInfo)changeBill);
            allid.add(changeBill.getId().toString());
        }
        String allidStr = BomUtil.getIdsStr(allid, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0013", (Locale)ctx.getLocale()));
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)allidStr, CompareType.INNER));
        FilterInfo filterOr1 = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("leadInOrgUnitEAS.id is null"));
        FilterInfo filterOr2 = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("suppliesOrgUnitEAS.id is null"));
        filterOr1.mergeFilter(filterOr2, "or");
        filter.mergeFilter(filterOr1, "and");
        if (this.exists(ctx, filter)) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0275", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        ISQLFacade isf = SQLFacadeFactory.getLocalInstance((Context)ctx);
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append("select cb.fid");
        sql.append(" from CT_ZJB_ProcessBomChangeBill cb left join CT_ZJB_ProcessBomBillOld po on cb.FOldBomId = po.fid");
        sql.append(" where cb.FOldBomId is not null");
        sql.append(" and po.CFStorageOrgUnitID != cb.CFLeadInOrgUnitEAS");
        sql.append(" and cb.fid in (").append(allidStr).append(")");
        if (isf.exeSQL(sql.toString())) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0276", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        for (int i = 0; i < pbcb.size(); ++i) {
            ProcessBomChangeBillInfo pbcbinfo = pbcb.get(i);
            sql.setLength(0);
            sql.append("select 1 from ct_zjb_flowsplitconfigentry fe inner join CT_ZJB_FlowSplitConfig f on f.fid = fe.FParentID where f.CFFlowName ='" + pbcbinfo.getTechnologicalFlow() + "' and fe.CFFLOW = '" + pbcbinfo.getAfterFlow() + "' AND fe.CFSTORAGEORGUNITID = '" + pbcbinfo.getSuppliesOrgUnitEAS().getId().toString() + "' AND fe.CFGETSTORAGEORGUNI = '" + pbcbinfo.getLeadInOrgUnitEAS().getId().toString() + "' AND fe.CFMaterialProperty = " + pbcbinfo.getMaterialSources().getValue());
            if (pbcbinfo.getSupplier() != null) {
                sql.append(" AND fe.CFSupplierID = '" + pbcbinfo.getSupplier().getId().toString() + "'");
            } else {
                sql.append(" AND fe.CFSupplierID is null");
            }
            if (pbcbinfo.getGetSupplier() != null) {
                sql.append(" AND fe.CFGetSupplierID = '" + pbcbinfo.getGetSupplier().getId().toString() + "'");
            } else {
                sql.append(" AND fe.CFGetSupplierID is null");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) continue;
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"JCBZBCZYGJLGHKCZZ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{pbcbinfo.getTechnologicalFlow()});
                NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", strInfo);
                throw new EASBizException(exc);
            }
            catch (SQLException e1) {
                NumericExceptionSubItem exc = new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0277", (Locale)ctx.getLocale()));
                throw new EASBizException(exc);
            }
        }
        ProcessBomBillCollection result = new ProcessBomBillCollection();
        if (pbcCol == null || pbcCol.size() == 0) {
            this.updateBomByAudit(ctx, result);
        } else {
            new Date();
            BomUtil.getCurrentUser(ctx);
            CoreBaseCollection adds = new CoreBaseCollection();
            CoreBaseCollection updates = new CoreBaseCollection();
            IDesignBOMBillSplitFacade isplit = DesignBOMBillSplitFacadeFactory.getLocalInstance(ctx);
            for (int i = 0; i < pbcCol.size(); ++i) {
                ProcessBomChangeBillInfo changebill = pbcCol.get(i);
                changebill.setUpdateOfficialTable(true);
                ProcessBomBillInfo processBom = changebill.getProcessBom();
                if (processBom == null) {
                    ProcessBomBillInfo add = this.addProcessBom(ctx, changebill);
                    adds.addObject((IObjectValue)add);
                    continue;
                }
                TrackNumberInfo sourceStartNum = processBom.getBeginCarno();
                TrackNumberInfo sourceEndNum = processBom.getEndCarno();
                TrackNumberInfo changeStartNum = changebill.getTrackNumberStart();
                TrackNumberInfo changeEndNum = changebill.getTrackNumberEnd();
                if (changeStartNum == null || changeEndNum == null) {
                    String strInfo = ResourceBase.getString((String)this.RESURL, (String)"GYBOMGGDQSQZCH_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{changebill.getNumber()});
                    ThrowUtil.showUIError((String)strInfo);
                }
                if (sourceStartNum != null && sourceEndNum != null) {
                    TrackNumberInfo endNum;
                    TrackNumberInfo startNum;
                    List splitTN = isplit.splitTrackNumber(sourceStartNum, sourceEndNum, changeStartNum, changeEndNum);
                    int size1 = splitTN.size();
                    if (size1 == 0) continue;
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("beginCarno"));
                    sic.add(new SelectorItemInfo("endCarno"));
                    if (size1 > 2) {
                        for (int j = 2; j < size1; j += 2) {
                            startNum = (TrackNumberInfo)splitTN.get(j);
                            endNum = (TrackNumberInfo)splitTN.get(j + 1);
                            ProcessBomBillInfo pb = (ProcessBomBillInfo)processBom.clone();
                            pb.setId(BOSUuid.create((BOSObjectType)processBom.getBOSType()));
                            pb.setBeginCarno(startNum);
                            pb.setEndCarno(endNum);
                            pb.setIsAdd(true);
                            adds.addObject((IObjectValue)pb);
                        }
                    }
                    startNum = (TrackNumberInfo)splitTN.get(0);
                    endNum = (TrackNumberInfo)splitTN.get(1);
                    processBom.setBeginCarno(startNum);
                    processBom.setEndCarno(endNum);
                }
                this.updateProcessBom(ctx, processBom, changebill);
                updates.addObject((IObjectValue)processBom);
            }
            if (updates.size() > 0) {
                result.addObjectCollection((IObjectCollection)updates);
            }
            if (adds.size() > 0) {
                result.addObjectCollection((IObjectCollection)adds);
            }
            IProcessBomBill ipb = ProcessBomBillFactory.getLocalInstance(ctx);
            if (updates.size() > 0) {
                for (int i = 0; i < updates.size(); ++i) {
                    ProcessBomBillInfo cb = (ProcessBomBillInfo)updates.get(i);
                    ipb.update((IObjectPK)new ObjectUuidPK(cb.getId()), (CoreBaseInfo)cb);
                }
            }
            if (adds.size() > 0) {
                for (int i = 0; i < adds.size(); ++i) {
                    ipb.addnew(adds.get(i));
                }
            }
        }
        this.updateBomByAudit(ctx, result);
        Result rlt = this.update(ctx, changeBillCol);
        ThrowUtil.checkResult((Result)rlt, (CoreBaseCollection)changeBillCol, (String)"number");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _batchProcessSplits(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() == 0) {
            return;
        }
        this.checkAudit(ctx, ids, true);
        this.checkNotCorrectlyType(ctx, ids, true);
        this.checkFlowHasSplit(ctx, ids, true);
        String idStr = this.getIdsStr(ctx, ids);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        ProcessBomChangeBillCollection sspc = this.getProcessBomChangeBillCollection(ctx, evi);
        BOTMappingInfo botInfo = BomBotpUtil.getBOTP(ctx, "MM_PBCB001");
        CoreBaseCollection updateCol = new CoreBaseCollection();
        for (int i = 0; i < sspc.size(); ++i) {
            ProcessBomChangeBillInfo info = sspc.get(i);
            String flow = info.getTechnologicalFlow();
            if (StringUtils.isEmpty((String)flow)) {
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"QSZLCCFDDGYLC_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()});
                NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", strInfo);
                throw new EASBizException(exc);
            }
            String initportNumber = info.getPtsNumberP();
            MaterialInfo initportMaterialInfo = info.getPts();
            FlowSplitConfigInfo config = this.getFlowSplitConfig(ctx, info.getTechnologicalFlow());
            FlowSplitConfigEntryCollection fscec = config.getEntry();
            int size = fscec.size();
            if (size > 0) {
                FlowSplitConfigEntryInfo entryInfo = fscec.get(0);
                info.setAfterFlow(entryInfo.getFlow());
                if (entryInfo.getSupplier() != null && entryInfo.getSupplier().getId() != null) {
                    info.setSupplier(SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSupplier().getId().toString())));
                } else {
                    info.setSupplier(null);
                }
                if (entryInfo.getGetSupplier() != null && entryInfo.getGetSupplier().getId() != null) {
                    info.setGetSupplier(SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(entryInfo.getGetSupplier().getId().toString())));
                } else {
                    info.setGetSupplier(null);
                }
                this.flowHasSplit(ctx, info);
                this.syncProcessWordsConfigInfo(info, entryInfo);
                if (entryInfo.getCodeRule() != null && !"".equals(entryInfo.getCodeRule())) {
                    info.setPts(null);
                    info.setPtsNumberP(initportNumber + entryInfo.getCodeRule());
                }
                updateCol.add((CoreBaseInfo)info);
            }
            if (size <= 1) continue;
            ProcessBomChangeBillInfo newParent = info;
            for (int c = 1; c < size; ++c) {
                ProcessBomChangeBillCollection sspCol = BomBotpUtil.createBillByBOTP(ctx, info, botInfo);
                FlowSplitConfigEntryInfo entryInfo = fscec.get(c);
                ProcessBomChangeBillInfo nowssp = null;
                for (int j = 0; j < sspCol.size(); ++j) {
                    nowssp = sspCol.get(j);
                    if (entryInfo.getCodeRule() == null || "".equals(entryInfo.getCodeRule())) {
                        nowssp.setPts(initportMaterialInfo);
                        nowssp.setPtsNumberP(initportNumber);
                    } else {
                        nowssp.setPts(null);
                        nowssp.setPtsNumberP(initportNumber + entryInfo.getCodeRule());
                    }
                    nowssp.setPtsNameP(info.getPtsNameP());
                    nowssp.setParentPts(newParent.getPts());
                    nowssp.setParentPtsNameP(newParent.getPtsNameP());
                    nowssp.setParentPtsNumberP(newParent.getPtsNumberP());
                    nowssp.setAfterFlow(entryInfo.getFlow());
                    this.syncProcessWordsConfigInfo(nowssp, entryInfo);
                    updateCol.add((CoreBaseInfo)nowssp);
                }
                if (nowssp == null) continue;
                nowssp.setMaterialNameP(newParent.getMaterialNameP());
                nowssp.setMaterialNumberP(newParent.getMaterialNumberP());
                if (entryInfo.getSupplier() != null && entryInfo.getSupplier().getId() != null) {
                    nowssp.setSupplier(SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSupplier().getId().toString())));
                    newParent.setSupplier(nowssp.getSupplier());
                }
                if (entryInfo.getGetSupplier() != null && entryInfo.getGetSupplier().getId() != null) {
                    nowssp.setGetSupplier(SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(entryInfo.getGetSupplier().getId().toString())));
                    newParent.setGetSupplier(nowssp.getGetSupplier());
                }
                newParent.setMaterialNameP(null);
                newParent.setMaterialNumberP(null);
                newParent = nowssp;
            }
            if (newParent.equals(info) || info.getPtsNumberP().equals(newParent.getPtsNumberP())) continue;
            evi = new EntityViewInfo();
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            evi.setSelector(sic);
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("parentPtsNumberP", (Object)initportNumber, CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("batchNo", (Object)info.getBatchNo(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("technologicalFlow is not null"));
            ProcessBomChangeBillCollection updateParentPts = this.getProcessBomChangeBillCollection(ctx, evi);
            for (int k = 0; k < updateParentPts.size(); ++k) {
                ProcessBomChangeBillInfo up = updateParentPts.get(k);
                up.setParentPts(newParent.getPts());
                up.setParentPtsNameP(newParent.getPtsNameP());
                up.setParentPtsNumberP(newParent.getPtsNumberP());
                updateCol.add((CoreBaseInfo)up);
            }
        }
        if (updateCol.size() > 0) {
            for (int i = 0; i < updateCol.size(); ++i) {
                ProcessBomChangeBillInfo up = (ProcessBomChangeBillInfo)updateCol.get(i);
                if (up.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) continue;
                this.flowHasSplit(ctx, up);
                ObjectUuidPK pk = new ObjectUuidPK(up.getId());
                this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)up);
            }
        }
        super._batchProcessSplits(ctx, ids);
    }

    @Override
    protected void _batchSettingProcess(Context ctx, List ids, Map param) throws BOSException, EASBizException {
        this.checkAudit(ctx, ids, true);
        String idStr = BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0013", (Locale)ctx.getLocale()));
        String flow = (String)param.get("flow");
        ProcessBomChangeBillCollection infos = this.getProcessBomChangeBillCollection(ctx, "select id where id in (" + idStr + ")");
        CoreBaseCollection updates = new CoreBaseCollection();
        for (int i = 0; i < infos.size(); ++i) {
            ProcessBomChangeBillInfo info = infos.get(i);
            info.setTechnologicalFlow(flow);
            updates.add((CoreBaseInfo)info);
        }
        if (updates.size() > 0) {
            this.update(ctx, updates);
        }
    }

    @Override
    protected void _batchSplitOfRawMaterials(Context ctx, List ids) throws BOSException, EASBizException {
        this.checkAudit(ctx, ids, true);
        this.checkNotCorrectlyType(ctx, ids, true);
        this.checkMaterialSplit(ctx, ids, true);
        String idStr = this.getIdsStr(ctx, ids);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        ProcessBomChangeBillCollection sspc = this.getProcessBomChangeBillCollection(ctx, evi);
        BOTMappingInfo botInfo = BomBotpUtil.getBOTP(ctx, "MM_PBCB001");
        CoreBaseCollection updateCol = new CoreBaseCollection();
        for (int i = 0; i < sspc.size(); ++i) {
            ProcessBomChangeBillInfo info = sspc.get(i);
            updateCol.add((CoreBaseInfo)info);
            String flow = info.getAfterFlow();
            if (StringUtils.isEmpty((String)flow)) {
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"QSZLCCFDDGYLC_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()});
                NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", strInfo);
                throw new EASBizException(exc);
            }
            String[] afterflow = ToSplitSingleProcess.splitProcessWordsInfo(flow);
            info.setAfterFlow(afterflow[0]);
            try {
                FlowSplitConfigInfo config = this.getFlowSplitConfig(ctx, afterflow[0]);
                if (config.getEntry() != null && config.getEntry().size() == 1) {
                    FlowSplitConfigEntryInfo entryInfo = config.getEntry().get(0);
                    this.syncProcessWordsConfigInfo(info, entryInfo);
                }
            }
            catch (Exception config) {
                // empty catch block
            }
            this.materialSplit(ctx, info);
            FlowSplitConfigEntryInfo entryInfoM = null;
            try {
                FlowSplitConfigInfo configM = this.getFlowSplitConfig(ctx, afterflow[1]);
                if (configM.getEntry() != null && configM.getEntry().size() == 1) {
                    entryInfoM = configM.getEntry().get(0);
                }
            }
            catch (Exception configM) {
                // empty catch block
            }
            ProcessBomChangeBillCollection sspCol = BomBotpUtil.createBillByBOTP(ctx, info, botInfo);
            for (int j = 0; j < sspCol.size(); ++j) {
                ProcessBomChangeBillInfo ssp = sspCol.get(j);
                ssp.setPts(null);
                ssp.setPtsNameP(info.getMaterialNameP());
                ssp.setPtsNumberP(info.getMaterialNumberP());
                ssp.setParentPts(info.getPts());
                ssp.setParentPtsNameP(info.getPtsNameP());
                ssp.setParentPtsNumberP(info.getPtsNumberP());
                ssp.setMaterialNameP(null);
                ssp.setMaterialNumberP(null);
                ssp.setSingleFixed(info.getClqty());
                if (ssp.getSingleFixed() != null && ssp.getAssemblyQty() != null) {
                    ssp.setFixed(ssp.getSingleFixed().multiply(ssp.getAssemblyQty()));
                } else {
                    ssp.setFixed(new BigDecimal(0));
                }
                ssp.setAfterFlow(afterflow[1]);
                if (entryInfoM != null) {
                    this.syncProcessWordsConfigInfo(ssp, entryInfoM);
                    this.flowHasSplit(ctx, ssp);
                }
                ssp.setTechnologicalFlow(null);
                ssp.setAfterFlow(null);
                ssp.setSuppliesOrgUnitEAS(null);
                ssp.setLeadInOrgUnitEAS(null);
                ssp.setMaterialSources(null);
                ssp.setGetSupplier(null);
                ssp.setSupplier(null);
                updateCol.add((CoreBaseInfo)ssp);
            }
            info.setMaterialNumberP(null);
        }
        if (updateCol.size() > 0) {
            this.update(ctx, updateCol);
            ArrayList<BOSUuid> um = new ArrayList<BOSUuid>();
            for (int i = 0; i < updateCol.size(); ++i) {
                um.add(updateCol.get(i).getId());
            }
        }
        super._batchSplitOfRawMaterials(ctx, ids);
    }

    @Override
    protected void _batchUpdateBatchNo(Context ctx, List ids, Map param) throws BOSException, EASBizException {
        this.checkAudit(ctx, ids, true);
        String idStr = BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0013", (Locale)ctx.getLocale()));
        String batchNo = (String)param.get("batchNo");
        ProcessBomChangeBillCollection infos = this.getProcessBomChangeBillCollection(ctx, "select id where id in (" + idStr + ")");
        CoreBaseCollection updates = new CoreBaseCollection();
        for (int i = 0; i < infos.size(); ++i) {
            ProcessBomChangeBillInfo info = infos.get(i);
            info.setBatchNo(batchNo);
            updates.add((CoreBaseInfo)info);
        }
        if (updates.size() > 0) {
            this.update(ctx, updates);
        }
    }

    @Override
    protected void _batchUpdateProjectInfo(Context ctx, List ids, Map param) throws BOSException, EASBizException {
        this.checkAudit(ctx, ids, true);
        String idStr = BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0013", (Locale)ctx.getLocale()));
        Object project = param.get("paramProject");
        Object ts = param.get("paramTrackNumberStart");
        Object te = param.get("paramTrackNumberEnd");
        ProcessBomChangeBillCollection infos = this.getProcessBomChangeBillCollection(ctx, "select id where id in (" + idStr + ")");
        CoreBaseCollection updates = new CoreBaseCollection();
        for (int i = 0; i < infos.size(); ++i) {
            ProcessBomChangeBillInfo info = infos.get(i);
            info.setProjectNo((ProjectInfo)project);
            info.setTrackNumberStart((TrackNumberInfo)ts);
            info.setTrackNumberEnd((TrackNumberInfo)te);
            updates.add((CoreBaseInfo)info);
        }
        if (updates.size() > 0) {
            this.update(ctx, updates);
        }
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.setFilter(filter);
        ProcessBomChangeBillCollection infos = this.getProcessBomChangeBillCollection(ctx, evi);
        ArrayList<ObjectUuidPK> pklist = new ArrayList<ObjectUuidPK>();
        for (int i = 0; i < infos.size(); ++i) {
            ProcessBomChangeBillInfo info = infos.get(i);
            pklist.add(new ObjectUuidPK(info.getId()));
        }
        IObjectPK[] pks = new IObjectPK[pklist.size()];
        pklist.toArray(pks);
        this._delete(ctx, pks);
        return pks;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this._delete(ctx, pks);
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        List<IObjectPK> ids = Arrays.asList(arrayPK);
        this.checkAudit(ctx, ids, true);
        String idStr = this.getIdsStr(ctx, ids);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("oldBom.id"));
        evi.getSelector().add(new SelectorItemInfo("entrys.content.id"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        ProcessBomChangeBillCollection infos = this.getProcessBomChangeBillCollection(ctx, evi);
        ArrayList<ObjectUuidPK> oldbompklist = new ArrayList<ObjectUuidPK>();
        ArrayList<ObjectUuidPK> contentpklist = new ArrayList<ObjectUuidPK>();
        for (int i = 0; i < infos.size(); ++i) {
            ProcessBomChangeBillEntryCollection entrys;
            ProcessBomChangeBillInfo info = infos.get(i);
            ProcessBomBillOldInfo oldbom = info.getOldBom();
            if (oldbom != null) {
                oldbompklist.add(new ObjectUuidPK(oldbom.getId()));
            }
            if ((entrys = info.getEntrys()) == null || entrys.size() == 0) continue;
            for (int j = 0; j < entrys.size(); ++j) {
                ProcessBomChangeBillEntryInfo entry = entrys.get(j);
                ProcessBomChangeBillInfo content = entry.getContent();
                if (content == null) continue;
                contentpklist.add(new ObjectUuidPK(content.getId()));
            }
        }
        if (oldbompklist.size() > 0) {
            IObjectPK[] pks = new IObjectPK[oldbompklist.size()];
            oldbompklist.toArray(pks);
            ProcessBomBillOldFactory.getLocalInstance(ctx).delete(pks);
        }
        super._delete(ctx, arrayPK);
        List<IObjectPK> pklist = Arrays.asList(arrayPK);
        BomBotpUtil.deleteRelations(ctx, this.getBOSType().toString(), new HashSet<IObjectPK>(pklist));
        if (contentpklist.size() > 0) {
            IObjectPK[] pks = new IObjectPK[contentpklist.size()];
            contentpklist.toArray(pks);
            super._delete(ctx, pks);
        }
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        ProcessBomChangeBillCollection infos = this.getProcessBomChangeBillCollection(ctx, oql);
        ArrayList<ObjectUuidPK> pklist = new ArrayList<ObjectUuidPK>();
        for (int i = 0; i < infos.size(); ++i) {
            ProcessBomChangeBillInfo info = infos.get(i);
            pklist.add(new ObjectUuidPK(info.getId()));
        }
        IObjectPK[] pks = new IObjectPK[pklist.size()];
        pklist.toArray(pks);
        this._delete(ctx, pks);
        return pks;
    }

    protected void _deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        this._delete(ctx, pkArray);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        super._passAudit(ctx, pk, model);
        if (!(model instanceof ProcessBomChangeBillInfo)) {
            return;
        }
    }

    @Override
    protected void _rationCalculate(Context ctx, List ids) throws BOSException, EASBizException {
        this.checkAudit(ctx, ids, true);
        String idStr = BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0013", (Locale)ctx.getLocale()));
        ProcessBomChangeBillCollection infos = this.getProcessBomChangeBillCollection(ctx, "select * where id in (" + idStr + ")");
        CoreBaseCollection updates = new CoreBaseCollection();
        for (int i = 0; i < infos.size(); ++i) {
            ProcessBomChangeBillInfo info = infos.get(i);
            BigDecimal fixed = info.getFixed();
            BigDecimal singleFixed = info.getSingleFixed();
            BigDecimal sizeWidth = info.getFeedingSizeWidth();
            BigDecimal sizeLong = info.getFeedingSizeLong();
            BigDecimal useFactor = info.getUseFactor();
            BigDecimal qty = info.getAssemblyQty();
            String materialID = null;
            if (info.getPts() != null) {
                materialID = info.getPts().getId().toString();
            }
            BigDecimal mi = BomUtil.getMultiMeasureUnit(ctx, materialID);
            BigDecimal nowSingleFixed = BomUtil.calculationOfSingleFixed(singleFixed, sizeWidth, sizeLong, useFactor, mi);
            BigDecimal nowFixed = BomUtil.calculationOfFixed(fixed, nowSingleFixed, qty);
            info.setSingleFixed(nowSingleFixed);
            info.setFixed(nowFixed);
            updates.add((CoreBaseInfo)info);
        }
        if (updates.size() > 0) {
            this.update(ctx, updates);
        }
    }

    @Override
    protected void _rationCopy(Context ctx, List ids) throws BOSException, EASBizException {
        this.checkAudit(ctx, ids, true);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSorter(new SorterItemCollection());
        SorterItemInfo sorter = new SorterItemInfo("createTime");
        sorter.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorter);
        evi.setTopCount(1);
        ProcessBomBillCollection lastInfos = ProcessBomBillFactory.getLocalInstance(ctx).getProcessBomBillCollection(evi);
        ProcessBomBillInfo lastInfo = null;
        if (lastInfos == null || lastInfos.size() != 1) {
            return;
        }
        lastInfo = lastInfos.get(0);
        BigDecimal singleFixed = lastInfo.getRationUnit();
        BigDecimal sizeWidth = lastInfo.getSizeWidth();
        BigDecimal sizeLong = lastInfo.getSizeLength();
        BigDecimal useFactor = lastInfo.getUsingRate();
        if (BomUtil.isEmpty(singleFixed) && BomUtil.isEmpty(sizeLong) && BomUtil.isEmpty(sizeWidth) && BomUtil.isEmpty(useFactor)) {
            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"", (Locale)ctx.getLocale(), (Object[])new Object[]{lastInfo.getNumber()});
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", strInfo);
            throw new EASBizException(exc);
        }
        String idStr = BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0013", (Locale)ctx.getLocale()));
        ProcessBomChangeBillCollection infos = this.getProcessBomChangeBillCollection(ctx, "select * where id in (" + idStr + ")");
        CoreBaseCollection updates = new CoreBaseCollection();
        for (int i = 0; i < infos.size(); ++i) {
            ProcessBomChangeBillInfo info = infos.get(i);
            boolean up = false;
            if (!BomUtil.isEmpty(singleFixed) && BomUtil.isEmpty(info.getSingleFixed())) {
                info.setSingleFixed(singleFixed);
                up = true;
            }
            if (!BomUtil.isEmpty(sizeLong) && BomUtil.isEmpty(info.getFeedingSizeLong())) {
                info.setFeedingSizeLong(sizeLong);
                up = true;
            }
            if (!BomUtil.isEmpty(sizeWidth) && BomUtil.isEmpty(info.getFeedingSizeWidth())) {
                info.setFeedingSizeWidth(sizeWidth);
                up = true;
            }
            if (!BomUtil.isEmpty(useFactor) && BomUtil.isEmpty(info.getUseFactor())) {
                info.setUseFactor(useFactor);
                up = true;
            }
            if (!up) continue;
            updates.add((CoreBaseInfo)info);
        }
        if (updates.size() > 0) {
            this.update(ctx, updates);
        }
        this._rationCalculate(ctx, ids);
    }

    @Override
    protected void _rationInit(Context ctx, List ids) throws BOSException, EASBizException {
        this.checkAudit(ctx, ids, true);
        String idStr = BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0258", (Locale)ctx.getLocale()));
        ProcessBomChangeBillCollection infos = this.getProcessBomChangeBillCollection(ctx, "select * where id in (" + idStr + ")");
        CoreBaseCollection updates = new CoreBaseCollection();
        for (int i = 0; i < infos.size(); ++i) {
            ProcessBomChangeBillInfo info = infos.get(i);
            BigDecimal fixed = info.getFixed();
            BigDecimal singleFixed = info.getSingleFixed();
            info.getFeedingSizeWidth();
            info.getFeedingSizeLong();
            BigDecimal useFactor = info.getUseFactor();
            BigDecimal qty = info.getAssemblyQty();
            if (!BomUtil.isEmpty(singleFixed) || !BomUtil.isEmpty(useFactor)) continue;
            singleFixed = BigDecimal.ONE;
            info.setSingleFixed(singleFixed);
            BigDecimal nowFixed = BomUtil.calculationOfFixed(fixed, singleFixed, qty);
            info.setFixed(nowFixed);
            updates.add((CoreBaseInfo)info);
        }
        if (updates.size() > 0) {
            this.update(ctx, updates);
        }
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ProcessBomChangeBillInfo info = (ProcessBomChangeBillInfo)model;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        this.checkAudit(ctx, ids, true);
        super._save(ctx, pk, model);
        this.updateEntry(ctx, pk, info);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BillBaseStatusEnum status;
        ProcessBomChangeBillInfo info = (ProcessBomChangeBillInfo)model;
        BOSUuid id = info.getId();
        if (id != null) {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(pk.toString());
            this.checkAudit(ctx, ids, true);
        }
        if ((status = info.getBaseStatus()) != null && status != BillBaseStatusEnum.ADD && status != BillBaseStatusEnum.TEMPORARILYSAVED && id != null && this.exists(ctx, (IObjectPK)new ObjectUuidPK(id.toString()))) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0278", (Locale)ctx.getLocale()) + status.getAlias() + EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0279")));
        }
        info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        IObjectPK pk = super._save(ctx, model);
        this.updateEntry(ctx, pk, info);
        return pk;
    }

    @Override
    protected void _saveReceivers(Context ctx, List ids, String receivers) throws BOSException, EASBizException {
        String idStr = this.getIdsStr(ctx, ids);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("receivers"));
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        ProcessBomChangeBillCollection sspCol = this.getProcessBomChangeBillCollection(ctx, evi);
        int size = sspCol.size();
        if (size < 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            ProcessBomChangeBillInfo info = sspCol.get(i);
            info.setReceivers(receivers);
            this.updatePartial(ctx, (CoreBaseInfo)info, sic);
        }
    }

    @Override
    protected void _setComplete(Context ctx, List ids, boolean isComplete) throws BOSException, EASBizException {
        boolean check = this.checkAudit(ctx, ids, false);
        if (!check) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0280", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        String idStr = this.getIdsStr(ctx, ids);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("complete"));
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        ProcessBomChangeBillCollection sspCol = this.getProcessBomChangeBillCollection(ctx, evi);
        int size = sspCol.size();
        if (size < 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            ProcessBomChangeBillInfo info = sspCol.get(i);
            info.setComplete(isComplete);
            this.updatePartial(ctx, (CoreBaseInfo)info, sic);
        }
    }

    @Override
    public void isNotComplete(Context ctx, List ids, boolean isNotComplete) throws BOSException {
        try {
            this._setComplete(ctx, ids, isNotComplete);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        this.checkAudit(ctx, ids, true);
        if (ProcessBomChangeBillInfo.class.isInstance(model)) {
            ProcessBomChangeBillInfo info = (ProcessBomChangeBillInfo)model;
            info.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        }
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProcessBomChangeBillInfo info = (ProcessBomChangeBillInfo)model;
        BOSUuid id = info.getId();
        if (id != null) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(id.toString());
            this.checkAudit(ctx, ids, true);
        }
        info.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        boolean isAudit = this.checkAudit(ctx, ids, false);
        if (!isAudit) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0042", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        ProcessBomChangeBillInfo info = this.getProcessBomChangeBillInfo(ctx, "select baseStatus,entrys.* where id = '" + pk.toString() + "'");
        info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("auditTime"));
        super.updatePartial(ctx, (CoreBaseInfo)info, sic);
        if (info.getEntrys() == null || info.size() == 0) {
            return;
        }
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            ProcessBomChangeBillEntryInfo entry = info.getEntrys().get(i);
            ProcessBomChangeBillInfo content = entry.getContent();
            if (content == null) continue;
            content.setBaseStatus(info.getBaseStatus());
            content.setAuditor(info.getAuditor());
            content.setAuditTime(info.getAuditTime());
            super.updatePartial(ctx, (CoreBaseInfo)content, sic);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        this.checkAudit(ctx, ids, true);
        ProcessBomChangeBillInfo info = (ProcessBomChangeBillInfo)model;
        this.initBaseStatus(info);
        this.updateEntry(ctx, pk, info);
        super._update(ctx, pk, model);
    }

    @Override
    protected void _updateMaterial(Context ctx, List ids) throws BOSException, EASBizException {
        boolean isUseNew = true;
        for (int i = 0; i < ids.size(); ++i) {
            Map tempMap = (Map)ids.get(i);
            this.updateMaterial(ctx, tempMap);
        }
    }

    public MaterialInfo updateMaterial(Context ctx, Map tempMap) throws BOSException, EASBizException {
        String fid = (String)tempMap.get("id");
        String portNo = (String)tempMap.get("portNo");
        String portName = (String)tempMap.get("portName");
        String parentNo = (String)tempMap.get("parentNo");
        String parentName = (String)tempMap.get("parentName");
        String StorageOrgUnitID = (String)tempMap.get("StorageOrgUnitID");
        String DrawBillOrgId = (String)tempMap.get("DrawBillOrgId");
        String model = tempMap.containsKey("model") ? (tempMap.get("model") == null ? null : tempMap.get("model").toString()) : null;
        Integer materialPro = Integer.valueOf(tempMap.get("materialPro").toString());
        Boolean updateParentMaterial = (Boolean)tempMap.get("updateParentMaterial");
        String RegisteredMark = (String)tempMap.get("RegisteredMark");
        String WarrantNumber = (String)tempMap.get("WarrantNumber");
        String CZ = (String)tempMap.get("CZ");
        String PICTURENUMBER = (String)tempMap.get("PICTURENUMBER");
        String makeFlow = tempMap.containsKey("makeFlow") ? (tempMap.get("makeFlow") == null ? null : tempMap.get("makeFlow").toString()) : null;
        StorageOrgUnitInfo disPatchOrgUnitInfo = FlowSplitConfigFactory.getLocalInstance(ctx).getDispatchOrgUnitInfo(makeFlow);
        String fdisPatchOrgUnitId = null;
        if (disPatchOrgUnitInfo != null) {
            fdisPatchOrgUnitId = disPatchOrgUnitInfo.getId().toString();
        }
        MaterialInfo materialInfo = null;
        try {
            String existsSql;
            IRowSet row;
            if (updateParentMaterial == null || !updateParentMaterial.booleanValue()) {
                MaterialInfo material;
                MeasureUnitCollection mus;
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select CFAfterFlow,CFUnitP,CFPieceWeight from CT_ZJB_ProcessBomChangeBill where fid = ?", (Object[])new Object[]{fid});
                String flow = "";
                String funit = null;
                BigDecimal fweight = new BigDecimal(0);
                if (rs.next()) {
                    flow = rs.getString("CFAfterFlow");
                    funit = rs.getString("CFUnitP");
                    if (rs.getBigDecimal("CFPieceWeight") != null) {
                        fweight = rs.getBigDecimal("CFPieceWeight");
                    }
                }
                IMeasureUnit imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
                MeasureUnitInfo unitInfo = null;
                if (!StringUtils.isEmpty(funit) && (mus = imu.getMeasureUnitCollection("where name = '" + funit + "'")).size() > 0) {
                    unitInfo = mus.get(0);
                }
                if (unitInfo == null) {
                    unitInfo = imu.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK("gw5fUwEOEADgAArZwKgSOFuCXFc="));
                }
                if ((material = BomUtilZY.createMaterial(ctx, portNo, portName, unitInfo, null, 6, model, materialPro, StorageOrgUnitID, DrawBillOrgId, flow, 1, CZ, RegisteredMark, WarrantNumber, PICTURENUMBER, fweight, fdisPatchOrgUnitId)) != null) {
                    String updateSql = "update CT_ZJB_ProcessBomChangeBill set CFPtsID = '" + material.getId() + "' where fid = '" + fid + "'";
                    DbUtil.execute((Context)ctx, (String)updateSql);
                }
                materialInfo = material;
            } else if (!(StringUtils.isEmpty((String)parentNo) || (row = DbUtil.executeQuery((Context)ctx, (String)(existsSql = "select fid from T_BD_MATERIAL where FNUMBER = ? "), (Object[])new Object[]{parentNo.trim()})).next() || (row = DbUtil.executeQuery((Context)ctx, (String)(existsSql = "select top 1 fid from T_ZJB_UpdateMaterialNotFinish where fnumber = ? "), (Object[])new Object[]{parentNo.trim()})).next() || (row = DbUtil.executeQuery((Context)ctx, (String)(existsSql = "select top 1 fid from CT_ZJB_ProcessBomChangeBill where Cfptsnumberp = ? "), (Object[])new Object[]{parentNo.trim()})).next())) {
                IMeasureUnit imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
                MeasureUnitInfo unitInfo = null;
                MeasureUnitCollection cols = imu.getMeasureUnitCollection(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0283", (Locale)ctx.getLocale()));
                if (cols.size() <= 0) {
                    NumericExceptionSubItem exc = new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0115", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0115", (Locale)ctx.getLocale()));
                    throw new EASBizException(exc);
                }
                unitInfo = cols.get(0);
                MaterialInfo material = BomUtil.createMaterial(ctx, parentNo, parentName, unitInfo, null, 6, null, 10030, StorageOrgUnitID, StorageOrgUnitID, null);
                if (material != null) {
                    UpdateMaterialNotFinishInfo umInfo = new UpdateMaterialNotFinishInfo();
                    umInfo.setMaterial(material);
                    umInfo.setNumber(parentNo);
                    umInfo.setName(parentName);
                    UpdateMaterialNotFinishFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)umInfo);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return materialInfo;
    }

    @Override
    protected void _batchUpdateMaterial(Context ctx, HashMap parmMap) throws BOSException, EASBizException {
        String updateSql;
        String id;
        Map tempMap;
        int i;
        ArrayList tempList = (ArrayList)parmMap.get("list");
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        String supplyOrg = (String)parmMap.get("supplyOrg");
        String storageOrg = (String)parmMap.get("storageOrg");
        Integer materialProp = (Integer)parmMap.get("materialProp");
        if (supplyOrg != null && !supplyOrg.equals("")) {
            for (i = 0; i < tempList.size(); ++i) {
                tempMap = (Map)tempList.get(i);
                id = (String)tempMap.get("id");
                updateSql = "update CT_ZJB_ProcessBomChangeBill set CFSuppliesOrgUnitE = '" + supplyOrg + "' where fid = '" + id + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
        }
        if (storageOrg != null && !storageOrg.equals("")) {
            for (i = 0; i < tempList.size(); ++i) {
                tempMap = (Map)tempList.get(i);
                id = (String)tempMap.get("id");
                updateSql = "update CT_ZJB_ProcessBomChangeBill set CFLeadInOrgUnitEAS = '" + storageOrg + "' where fid = '" + id + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
        }
        if (materialProp != 0) {
            for (i = 0; i < tempList.size(); ++i) {
                tempMap = (Map)tempList.get(i);
                id = (String)tempMap.get("id");
                updateSql = "update CT_ZJB_ProcessBomChangeBill set FMaterialSources = " + materialProp + " where fid = '" + id + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
        }
    }
}

