/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.BomMaterialProEnum;
import com.kingdee.eas.zjbom.app.util.ProcessBomTree;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ProcessBomFixedTableReportServer
extends ReportServerBase {
    protected static final String F_TITLE = "_title";
    private static String RESURL = "com.kingdee.eas.zjbom.EMMEMZjResource";
    protected final Map reportHeaderMap = new HashMap();
    public static final String group_by_flow = "_sum";
    public static final String PROJECT_ID = "PROJECT_ID";
    public static final String PROJECT_NAME = "PROJECT_NAME";
    public static final String TRACK_BIGEN = "TRACK_NUMBER_B";
    public static final String TRACK_END = "TRACK_NUMBER_E";
    public static final String MATERIAL_NUMBER = "MATERIAL_NUMBER";
    public static final String MATERIAL_NAME = "MATERIAL_NAME";
    public static final String MATERIAL_PROP = "MATERIAL_PROP";
    public static final String FIXED = "FIXED";
    public static final String WORKCENTRE_ID = "WORKCENTRE_ID";
    public static final String WORKCENTRE_NAME = "WORKCENTRE_NAME";
    public static final String MATERIAL_UNIT = "MATERIAL_UNIT";
    public static final String MATERIAL_MSPEC = "MATERIAL_MSPEC";
    public static final String BOM_MATERIAL_PROP = "BOM_MATERIAL_PROP";
    public static final String SORT_NO = "SORT_NO";
    public static final String UPDATE_RECORD = "UPDATE_RECORD";
    public static final String DEFAULT_TREASURY = "DEFAULT_TREASURY";
    public static final String weight = "weight";

    protected ReportTitles getReportTitles(String s, RptParams params) throws BaseException {
        ReportTitles titles = new ReportTitles();
        int index = 0;
        titles.AddTitle(index, params.getString("txtBatchF_title"));
        titles.AddTitle(++index, params.getString("prmtProductNumber_title"));
        titles.AddTitle(++index, params.getString("fixed_title"));
        titles.AddTitle(++index, params.getString("prmtProject_title"));
        titles.AddTitle(++index, params.getString("prmtTrackBegin_title"));
        titles.AddTitle(++index, params.getString("prmtTrackEnd_title"));
        titles.AddTitle(++index, params.getString("materialSources_title"));
        titles.AddTitle(++index, params.getString("txtFlow_title"));
        titles.AddTitle(++index, params.getString("groupby_title"));
        ++index;
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        Context ctx = this.getContext();
        return this.getReportHeader(ctx);
    }

    private ReportHeader getReportHeader(Context ctx) {
        ReportHeader reportHeader = (ReportHeader)this.reportHeaderMap.get(ctx);
        if (reportHeader == null) {
            reportHeader = new ReportHeader();
            this.reportHeaderMap.put(ctx, reportHeader);
        }
        return reportHeader;
    }

    protected IRowSet getReportData(String s, RptParams rptparams) throws Exception {
        String resultSql = "";
        IRowSet set = DbUtil.executeQuery((Context)this.getContext(), (String)resultSql.toString());
        return set;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tempTable;
        String tempTableSql = this.getTempTableSql(filter);
        try {
            tempTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(tempTableSql);
        }
        catch (Exception e) {
            throw new BaseException("create tempTable error : sql is [" + tempTableSql + "]", (Throwable)e);
        }
        String indexColumns = "MATERIAL_NUMBER,TRACK_NUMBER_BTRACK_END";
        try {
            TempTablePool.getInstance((Context)this.getContext()).createIndex(tempTable, indexColumns, false, false);
        }
        catch (Exception e) {
            throw new BaseException("create tempTable index error : index columns is [" + indexColumns + "]", (Throwable)e);
        }
        this.insertData(tempTable, filter);
        return tempTable;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions reportFormatConditions = super.buildReportFormatConditions(reportID);
        if (reportFormatConditions == null) {
            reportFormatConditions = new ReportFormatConditions();
        }
        Appearance a = new Appearance();
        a.backColor = Color.blue;
        a.foreColor = Color.yellow;
        int condition = 6;
        reportFormatConditions.add(FIXED, condition, (Object)BigDecimal.ZERO, a, false);
        return reportFormatConditions;
    }

    protected void insertData(String tempTable, RptParams filter) throws BaseException {
        MaterialInfo topMaterial;
        Context ctx = this.getContext();
        String top = filter.getString("prmtProductNumber");
        try {
            topMaterial = (MaterialInfo)MaterialFactory.getLocalInstance((Context)ctx).getValue(" where number = '" + top + "'");
        }
        catch (ObjectNotFoundException e) {
            String strInfo = ResourceBase.getString((String)RESURL, (String)"QJCWLBDCCPBCZ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{top});
            throw new EASBizException(new NumericExceptionSubItem("", strInfo), (Throwable)e);
        }
        ProjectInfo project = null;
        String pro = filter.getString("prmtProject");
        if (pro != null && !"".equals(pro)) {
            project = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo(" where number = '" + pro + "'");
        }
        BomTree tree = new BomTree();
        Map params = filter.toMap();
        params.put("tempTable", tempTable);
        params.put("reportHeader", this.getReportHeader(ctx));
        tree.run(ctx, project, topMaterial, params);
    }

    private String getResourceInfo(String resourceName) {
        return "";
    }

    protected String getTempTableSql(RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        StringBuilder sql = new StringBuilder();
        ReportHeader reportHeader = this.getReportHeader(ctx);
        if (reportHeader.getChildCount() > 0) {
            reportHeader.getChilds().clear();
        }
        sql.append("Create Table ExpandBOMTable(\r\n");
        sql.append(MATERIAL_NUMBER).append(" NVARCHAR(80) Not Null,\r\n");
        reportHeader.addChild(MATERIAL_NUMBER, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0229", (Locale)ctx.getLocale()));
        sql.append(MATERIAL_NAME).append(" NVARCHAR(80) Null,\r\n");
        reportHeader.addChild(MATERIAL_NAME, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0294", (Locale)ctx.getLocale()));
        sql.append(MATERIAL_MSPEC).append(" NVARCHAR(80) Null,\r\n");
        reportHeader.addChild(MATERIAL_MSPEC, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0295", (Locale)ctx.getLocale()));
        sql.append(MATERIAL_UNIT).append(" NVARCHAR(120) Null,\r\n");
        reportHeader.addChild(MATERIAL_UNIT, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0296", (Locale)ctx.getLocale()));
        String flow = filter.getString("txtFlow");
        if (flow == null) {
            flow = "";
        }
        String batch = filter.getString("txtBatch");
        sql.append(FIXED).append(" Numeric(21,8) Default 0 Not Null,\r\n");
        if (!filter.getBoolean("byFlow") && StringUtils.isEmpty((String)flow)) {
            reportHeader.addChild(FIXED, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0256", (Locale)ctx.getLocale())).setAlign(3);
        } else {
            StringBuilder resultSql = new StringBuilder();
            resultSql.append("select distinct CFMakeFlow Flow from CT_ZJB_ProcessBomBill ");
            resultSql.append(" where CFMakeFlow like ?");
            resultSql.append(" and CFState = ").append(4);
            resultSql.append(" order by CFMakeFlow");
            try {
                IRowSet set = DbUtil.executeQuery((Context)ctx, (String)resultSql.toString(), (Object[])new Object[]{"%" + flow + "%"});
                if (set.next()) {
                    reportHeader.addChild(group_by_flow, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0256", (Locale)ctx.getLocale())).setAlign(3);
                    ReportHeader child = ProcessBomFixedTableReportServer.getChild(reportHeader, group_by_flow);
                    child.addChild(FIXED, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0297", (Locale)ctx.getLocale())).setAlign(3);
                    int n = 1;
                    do {
                        sql.append(FIXED).append(n).append(" Numeric(21,8) Null,\r\n");
                        child.addChild(FIXED + n, set.getString("Flow")).setAlign(3);
                        ++n;
                    } while (set.next());
                } else {
                    reportHeader.addChild(FIXED, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0256", (Locale)ctx.getLocale())).setAlign(3);
                }
            }
            catch (SQLException e) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0298", (Locale)ctx.getLocale()), (Throwable)e);
            }
        }
        sql.append(weight).append(" Numeric(21,8) Null,\r\n");
        reportHeader.addChild(weight, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0299", (Locale)ctx.getLocale())).setAlign(3);
        sql.append(PROJECT_ID).append(" VARCHAR(44) Null,\r\n");
        sql.append(PROJECT_NAME).append(" NVARCHAR(80) Null,\r\n");
        reportHeader.addChild(PROJECT_NAME, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0300", (Locale)ctx.getLocale()));
        sql.append(TRACK_BIGEN).append(" NVARCHAR(80)  Null,\r\n");
        reportHeader.addChild(TRACK_BIGEN, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0301", (Locale)ctx.getLocale()));
        sql.append(TRACK_END).append(" NVARCHAR(80)  Null,\r\n");
        reportHeader.addChild(TRACK_END, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0302", (Locale)ctx.getLocale()));
        sql.append(WORKCENTRE_ID).append(" VARCHAR(44) Null,\r\n");
        sql.append(WORKCENTRE_NAME).append(" NVARCHAR(80) Null,\r\n");
        if (filter.getBoolean("byWorkCenter")) {
            reportHeader.addChild(WORKCENTRE_NAME, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0303", (Locale)ctx.getLocale()));
        }
        sql.append(MATERIAL_PROP).append(" INT Null,\r\n");
        sql.append(MATERIAL_PROP).append("_Alias NVARCHAR(80) Null,\r\n");
        if (filter.getBoolean("byMaterialProp")) {
            reportHeader.addChild("MATERIAL_PROP_Alias", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0304", (Locale)ctx.getLocale()));
        }
        sql.append(BOM_MATERIAL_PROP).append(" VARCHAR(100) Null,\r\n");
        sql.append(BOM_MATERIAL_PROP).append("_Alias NVARCHAR(80) Null,\r\n");
        if (filter.getBoolean("byBomMaterialProp")) {
            reportHeader.addChild("BOM_MATERIAL_PROP_Alias", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0305", (Locale)ctx.getLocale()));
        }
        sql.append(UPDATE_RECORD).append(" NVARCHAR(2000) Null,\r\n");
        if (filter.getBoolean("byUpdateRecord")) {
            reportHeader.addChild(UPDATE_RECORD, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0306", (Locale)ctx.getLocale()));
        }
        sql.append(DEFAULT_TREASURY).append(" NVARCHAR(100) Null,\r\n");
        sql.append(SORT_NO).append(" INT Null");
        reportHeader.addChild(SORT_NO, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0307", (Locale)ctx.getLocale())).setVisible(false);
        sql.append(")");
        return sql.toString();
    }

    protected static ReportHeader getChild(ReportHeader reportHeader, String fieldName) {
        ArrayList childs = reportHeader.getChilds();
        for (int i = childs.size() - 1; i >= 0; --i) {
            ReportHeader child = (ReportHeader)childs.get(i);
            if (!fieldName.equalsIgnoreCase(child.getFieldName())) continue;
            return child;
        }
        return null;
    }

    public static boolean getBoolean(Map map, String key) {
        Object bb = map.get(key);
        if (bb == null) {
            return false;
        }
        if (bb instanceof Boolean) {
            return (Boolean)bb;
        }
        return Boolean.valueOf(String.valueOf(bb));
    }

    private class BomTree
    extends ProcessBomTree {
        public static final String report_Header = "reportHeader";
        public static final String temp_Table = "tempTable";

        private BomTree() {
        }

        @Override
        protected void execute(String treeTemp, Map params) throws Exception {
            Object e;
            int i;
            ReportHeader flowChild;
            int f;
            int size;
            ArrayList pv;
            ArrayList flows;
            String tempTable = (String)params.get(temp_Table);
            ReportHeader reportHeader = (ReportHeader)params.get(report_Header);
            String flow = (String)params.get("txtFlow");
            if (StringUtils.isEmpty((String)flow)) {
                flow = null;
            }
            boolean byWorkCenter = ProcessBomFixedTableReportServer.getBoolean(params, "byWorkCenter");
            boolean byMaterialProp = ProcessBomFixedTableReportServer.getBoolean(params, "byMaterialProp");
            boolean byBomMaterialProp = ProcessBomFixedTableReportServer.getBoolean(params, "byBomMaterialProp");
            boolean byUpdateRecord = ProcessBomFixedTableReportServer.getBoolean(params, "byUpdateRecord");
            StringBuilder sql = new StringBuilder();
            ArrayList<Object> paramValue = new ArrayList<Object>();
            sql.append("insert into ").append(tempTable).append("(");
            sql.append(ProcessBomFixedTableReportServer.MATERIAL_NUMBER);
            sql.append(",").append(ProcessBomFixedTableReportServer.MATERIAL_NAME);
            if (byWorkCenter) {
                sql.append(",").append(ProcessBomFixedTableReportServer.WORKCENTRE_ID);
                sql.append(",").append(ProcessBomFixedTableReportServer.WORKCENTRE_NAME);
            }
            if (byMaterialProp) {
                sql.append(",").append(ProcessBomFixedTableReportServer.MATERIAL_PROP);
            }
            if (byBomMaterialProp) {
                sql.append(",").append(ProcessBomFixedTableReportServer.BOM_MATERIAL_PROP);
            }
            if (byUpdateRecord) {
                sql.append(",").append(ProcessBomFixedTableReportServer.UPDATE_RECORD);
            }
            sql.append(",").append(ProcessBomFixedTableReportServer.FIXED);
            ReportHeader child = ProcessBomFixedTableReportServer.getChild(reportHeader, ProcessBomFixedTableReportServer.group_by_flow);
            if (child != null) {
                flows = child.getChilds();
                pv = new ArrayList();
                size = flows.size();
                for (f = 1; f < size; ++f) {
                    flowChild = (ReportHeader)flows.get(f);
                    sql.append(",").append(flowChild.getFieldName());
                }
            }
            sql.append(",").append(ProcessBomFixedTableReportServer.PROJECT_ID);
            sql.append(",").append(ProcessBomFixedTableReportServer.PROJECT_NAME);
            sql.append(",").append(ProcessBomFixedTableReportServer.TRACK_BIGEN);
            sql.append(",").append(ProcessBomFixedTableReportServer.TRACK_END);
            sql.append(",").append(ProcessBomFixedTableReportServer.SORT_NO);
            sql.append(",").append(ProcessBomFixedTableReportServer.weight);
            sql.append(") select ");
            sql.append("tree.").append("TREE_MATERIAL_NUMBER");
            sql.append(",tree.").append("TREE_MATERIAL_NAME");
            if (byWorkCenter) {
                sql.append(",storage.fid");
                sql.append(",storage.fname_l2");
            }
            if (byMaterialProp) {
                sql.append(",tree.").append("TREE_MATERIAL_PROP");
            }
            if (byBomMaterialProp) {
                sql.append(",bom.CFBomMaterialPro");
            }
            if (byUpdateRecord) {
                sql.append(",bom.CFUpdateRecord");
            }
            sql.append(",sum(tree.").append("Expand_FIXED").append(") as ").append("Expand_FIXED");
            if (child != null) {
                flows = child.getChilds();
                pv = new ArrayList();
                size = flows.size();
                for (f = 1; f < size; ++f) {
                    flowChild = (ReportHeader)flows.get(f);
                    sql.append(",sum(");
                    sql.append("case when bom.CFMakeFlow = '").append(flowChild.getCaption()).append("'");
                    sql.append(" then tree.").append("Expand_FIXED").append(" else 0 end");
                    sql.append(")");
                }
            }
            sql.append(",tree.").append("TREE_PROJECT_ID").append(" ");
            sql.append(",p.fname_l2");
            sql.append(",min(tree.").append("TREE_TRACK_NUMBER").append(")");
            sql.append(",max(tree.").append("TREE_TRACK_NUMBER").append(")");
            sql.append(",min(bom.CFSortNo)");
            sql.append(",max(bom.CFWeight)");
            StringBuilder from = new StringBuilder();
            from.append(" from ").append(treeTemp).append(" tree");
            from.append(" left join CT_ZJB_ProcessBomBill bom on bom.fid = tree.").append("TREE_BOM_ID");
            from.append(" left join T_ORG_Storage storage on storage.fid = bom.CFStorageOrgUnitID ");
            from.append(" left join t_mm_project p on p.fid = tree.").append("TREE_PROJECT_ID").append(" ");
            StringBuilder where = new StringBuilder();
            where.append(" where 1=1 ");
            if (params.containsKey("prmtTrackBegin")) {
                where.append(" and tree.").append("TREE_TRACK_NUMBER").append(" >= ?");
                paramValue.add(params.get("prmtTrackBegin"));
            }
            if (params.containsKey("prmtTrackEnd")) {
                where.append(" and tree.").append("TREE_TRACK_NUMBER").append(" <= ?");
                paramValue.add(params.get("prmtTrackEnd"));
            }
            if (params.containsKey("materialSources")) {
                where.append(" and tree.").append("TREE_MATERIAL_PROP").append(" = ?");
                paramValue.add(params.get("materialSources"));
            }
            if (flow != null) {
                where.append(" and bom.CFMakeFlow like ?");
                paramValue.add("%" + flow + "%");
            }
            StringBuilder group = new StringBuilder();
            group.append(" group by tree.").append("TREE_MATERIAL_NUMBER").append(",tree.").append("TREE_MATERIAL_NAME");
            group.append(",tree.").append("TREE_PROJECT_ID");
            group.append(",p.fname_l2");
            StringBuilder orderby = new StringBuilder();
            orderby.append(" order by tree.").append("TREE_MATERIAL_NUMBER");
            if (byWorkCenter) {
                group.append(",storage.fid");
                group.append(",storage.fname_l2");
            }
            if (byMaterialProp) {
                group.append(",tree.").append("TREE_MATERIAL_PROP");
            }
            if (byBomMaterialProp) {
                group.append(",bom.CFBomMaterialPro");
            }
            if (byUpdateRecord) {
                group.append(",bom.CFUpdateRecord");
            }
            sql.append(from.toString());
            sql.append(where.toString());
            sql.append(group.toString());
            sql.append(orderby.toString());
            BomTree.executeUpdate(this.ctx, sql.toString(), paramValue);
            sql.setLength(0);
            sql.append("update ").append(tempTable).append(" set ");
            sql.append(ProcessBomFixedTableReportServer.MATERIAL_PROP).append("_Alias = ( case ").append(ProcessBomFixedTableReportServer.MATERIAL_PROP);
            List ma = MaterialAttributeEnum.getEnumList();
            int size2 = ma.size();
            for (i = 0; i < size2; ++i) {
                e = (MaterialAttributeEnum)ma.get(i);
                sql.append(" when ").append("").append(e.getValue()).append(" then '").append(e.getAlias()).append("'");
            }
            sql.append(" else null end)");
            sql.append(",").append(ProcessBomFixedTableReportServer.BOM_MATERIAL_PROP).append("_Alias = ( case ").append(ProcessBomFixedTableReportServer.BOM_MATERIAL_PROP);
            ma = BomMaterialProEnum.getEnumList();
            size2 = ma.size();
            for (i = 0; i < size2; ++i) {
                e = (BomMaterialProEnum)((Object)ma.get(i));
                sql.append(" when '").append(e.getValue()).append("' then '").append(e.getAlias()).append("'");
            }
            sql.append(" else null end)");
            sql.append(",(").append(ProcessBomFixedTableReportServer.MATERIAL_UNIT).append(",").append(ProcessBomFixedTableReportServer.MATERIAL_MSPEC).append(") = (");
            sql.append("select unit.fname_l2,material.fmodel ");
            sql.append(" from T_BD_Material material left join T_BD_MeasureUnit unit on unit.fid = material.fbaseunit");
            sql.append(" where material.fnumber = ").append(tempTable).append(".").append(ProcessBomFixedTableReportServer.MATERIAL_NUMBER);
            sql.append(")");
            BomTree.executeUpdate(this.ctx, sql.toString(), null);
        }
    }
}

