/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TreeNode
implements Serializable {
    private int parentId;
    private int selfId;
    protected String nodeName;
    protected Object obj;
    protected TreeNode parentNode;
    protected List<TreeNode> childList;

    public TreeNode() {
        this.initChildList();
    }

    public TreeNode(TreeNode parentNode) {
        this.getParentNode();
        this.initChildList();
    }

    public boolean isLeaf() {
        if (this.childList == null) {
            return true;
        }
        return this.childList.isEmpty();
    }

    public void addChildNode(TreeNode treeNode) {
        this.initChildList();
        this.childList.add(treeNode);
    }

    public void initChildList() {
        if (this.childList == null) {
            this.childList = new ArrayList<TreeNode>();
        }
    }

    public boolean isValidTree() {
        return true;
    }

    public List<TreeNode> getElders() {
        ArrayList<TreeNode> elderList = new ArrayList<TreeNode>();
        TreeNode parentNode = this.getParentNode();
        if (parentNode == null) {
            return elderList;
        }
        elderList.add(parentNode);
        elderList.addAll(parentNode.getElders());
        return elderList;
    }

    public List<TreeNode> getJuniors() {
        ArrayList<TreeNode> juniorList = new ArrayList<TreeNode>();
        List<TreeNode> childList = this.getChildList();
        if (childList == null) {
            return juniorList;
        }
        int childNumber = childList.size();
        for (int i = 0; i < childNumber; ++i) {
            TreeNode junior = childList.get(i);
            juniorList.add(junior);
            juniorList.addAll(junior.getJuniors());
        }
        return juniorList;
    }

    public List<TreeNode> getChildList() {
        return this.childList;
    }

    public void deleteNode() {
        TreeNode parentNode = this.getParentNode();
        int id = this.getSelfId();
        if (parentNode != null) {
            parentNode.deleteChildNode(id);
        }
    }

    public void deleteChildNode(int childId) {
        List<TreeNode> childList = this.getChildList();
        int childNumber = childList.size();
        for (int i = 0; i < childNumber; ++i) {
            TreeNode child = childList.get(i);
            if (child.getSelfId() != childId) continue;
            childList.remove(i);
            return;
        }
    }

    public boolean insertJuniorNode(TreeNode treeNode) {
        int juniorParentId = treeNode.getParentId();
        if (this.parentId == juniorParentId) {
            this.addChildNode(treeNode);
            return true;
        }
        List<TreeNode> childList = this.getChildList();
        int childNumber = childList.size();
        for (int i = 0; i < childNumber; ++i) {
            TreeNode childNode = childList.get(i);
            boolean insertFlag = childNode.insertJuniorNode(treeNode);
            if (!insertFlag) continue;
            return true;
        }
        return false;
    }

    public TreeNode findTreeNodeById(int id) {
        if (this.selfId == id) {
            return this;
        }
        if (this.childList.isEmpty() || this.childList == null) {
            return null;
        }
        int childNumber = this.childList.size();
        for (int i = 0; i < childNumber; ++i) {
            TreeNode child = this.childList.get(i);
            TreeNode resultNode = child.findTreeNodeById(id);
            if (resultNode == null) continue;
            return resultNode;
        }
        return null;
    }

    public void traverse() {
        if (this.selfId < 0) {
            return;
        }
        this.print(this.selfId);
        if (this.childList == null || this.childList.isEmpty()) {
            return;
        }
        int childNumber = this.childList.size();
        for (int i = 0; i < childNumber; ++i) {
            TreeNode child = this.childList.get(i);
            child.traverse();
        }
    }

    public void print(String content) {
        System.out.println(content);
    }

    public void print(int content) {
        System.out.println(String.valueOf(content));
    }

    public void setChildList(List<TreeNode> childList) {
        this.childList = childList;
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public int getSelfId() {
        return this.selfId;
    }

    public void setSelfId(int selfId) {
        this.selfId = selfId;
    }

    public TreeNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(TreeNode parentNode) {
        this.parentNode = parentNode;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public Object getObj() {
        return this.obj;
    }

    public void setObj(Object obj) {
        this.obj = obj;
    }

    public String toString() {
        return this.getNodeName();
    }
}

