/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.taskmng.util.StringUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.industry.AutoNumberFacadeFactory;
import com.kingdee.eas.zjbom.app.util.ProcessBomTree;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.Locale;

public final class AutoNumberUtil {
    public static final String EAS_ROOT_ORGUNIT_ID = null;
    public static final String EAS_TOP_ORGUNIT_ID = "00000000-0000-0000-0000-000000000000CCE7AED4";
    public static final String ENTITY_NUMBER = "number";
    public static final String def_bostype = "def_bostype";
    public static final String sql_lock_unlock = "update t_bd_lockcodingrule set flock = ? where fbostype = ?";
    public static final String sql_insert = "insert into t_bd_lockcodingrule ( flock, fbostype) values ( ?,? )";

    public static boolean isExistRule(Context ctx, IObjectValue temp, String orgTypeKey) throws BOSException, EASBizException {
        String companyID = EAS_ROOT_ORGUNIT_ID;
        Object o = temp.get(orgTypeKey);
        if (o != null && StorageOrgUnitInfo.class.isInstance(o)) {
            companyID = ((StorageOrgUnitInfo)o).getId().toString();
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (companyID != null && iCodingRuleManager.isExist(temp, companyID)) {
            return true;
        }
        if (iCodingRuleManager.isExist(temp, EAS_ROOT_ORGUNIT_ID)) {
            return true;
        }
        return iCodingRuleManager.isExist(temp, EAS_TOP_ORGUNIT_ID);
    }

    public static void initNumber(Context ctx, IObjectValue temp, String mainOrgKey) throws EASBizException {
        if (mainOrgKey == null) {
            mainOrgKey = "storageOrgUnit";
        }
        CoreBaseCollection tempColl = new CoreBaseCollection();
        tempColl.addObject(temp);
        try {
            AutoNumberUtil.initNumber(ctx, (IObjectCollection)tempColl, mainOrgKey);
        }
        catch (BOSException e) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0000", (Locale)ctx.getLocale()) + e.getMessage()), (Throwable)e);
        }
    }

    public static void initNumber(Context ctx, IObjectValue temp) throws EASBizException {
        AutoNumberUtil.initNumber(ctx, temp, "storageOrgUnit");
    }

    public static void initNumber(Context ctx, IObjectCollection tempColl, String mainOrgKey) throws EASBizException, BOSException {
        IObjectValue tempInfo;
        if (mainOrgKey == null) {
            mainOrgKey = "storageOrgUnit";
        }
        CoreBaseCollection res = new CoreBaseCollection();
        for (int i = 0; i < tempColl.size(); ++i) {
            tempInfo = tempColl.getObject(i);
            String number = tempInfo.getString(ENTITY_NUMBER);
            if (!StringUtil.isEmpty((String)number)) continue;
            res.addObject(tempInfo);
        }
        if (res.size() == 0) {
            return;
        }
        String[] numbers = AutoNumberFacadeFactory.getLocalInstance(ctx).getBatchAutoNumber(tempColl, mainOrgKey);
        for (int i = 0; i < res.size(); ++i) {
            tempInfo = res.getObject(i);
            tempInfo.put(ENTITY_NUMBER, (Object)numbers[i]);
        }
    }

    public static void initNumber(Context ctx, IObjectCollection temps) throws EASBizException, BOSException {
        AutoNumberUtil.initNumber(ctx, temps, "storageOrgUnit");
    }

    protected static void lockCodingRule(Context ctx, String bostype, String org) throws BOSException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(1);
        params.add(bostype);
        int up = ProcessBomTree.executeUpdate(ctx, sql_lock_unlock, params);
        if (up == 0) {
            params.clear();
            params.add(1);
            params.add(def_bostype);
            ProcessBomTree.executeUpdate(ctx, sql_lock_unlock, params);
        }
    }

    protected static void unlockCodingRule(Context ctx, String bostype, String org) throws BOSException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(0);
        params.add(bostype);
        int up = ProcessBomTree.executeUpdate(ctx, sql_lock_unlock, params);
        if (up == 0) {
            params.clear();
            params.add(0);
            params.add(def_bostype);
            ProcessBomTree.executeUpdate(ctx, sql_lock_unlock, params);
            params.clear();
            params.add(0);
            params.add(bostype);
            ProcessBomTree.executeUpdate(ctx, sql_insert, params);
        }
    }
}

